from parallels.common.utils.yaml_utils import read_yaml, write_yaml
from parallels.utils import generate_random_password

class PasswordHolder(object):
	"""PasswordHolder is necessary to keep passwords the same between multiple executions of check-convert"""
	def __init__(self, filename):
		self.filename = filename
		self.passwords = read_yaml(self.filename, True, {})

	def get(self, object_type, object_id):
		if (object_type, object_id) not in self.passwords:
			password = generate_random_password()
			self.passwords[(object_type, object_id)] = password
			write_yaml(self.filename, self.passwords)
		else:
			password = self.passwords[(object_type, object_id)]

		return password

