import logging
import threading

from parallels.target_panel_plesk.import_api.import_api_base import \
	PleskBaseImportAPI
from parallels.common.import_api.utils import plesk_unix_change_sysuser_login

logger = logging.getLogger(__name__)


class PleskUnixImportAPI(PleskBaseImportAPI):
	def __init__(self, conn):
		super(PleskUnixImportAPI, self).__init__(conn)
		self.lock = threading.Lock()

	def change_sysuser_login(self, subscription_name, sysuser_login):
		with self.conn.main_node_runner() as runner:
			# There is a problem in Plesk for Unix which could lead to
			# incorrect Apache configs if we run change system user login in
			# parallel. So we don't allow two threads to change system user
			# login at the same time.
			self.lock.acquire() 
			plesk_unix_change_sysuser_login(runner, subscription_name, sysuser_login)
			self.lock.release()

	@staticmethod
	def repair_webspace_security(subscription):
		raise NotImplementedError(
			u"Repair webspace security is a Windows-specific function and can not be applied to Plesk for Unix"
		)

	def update_webspace_subdomains_security_metadata_location(self, domain_name):
		raise NotImplementedError(
			u"Update webspace subdomains security metadata location is a"
			u" Windows-specific function and can not be applied to Plesk for Unix"
		)

	@staticmethod
	def get_dedicated_app_pool_user(subscription):
		raise NotImplementedError(
			u"Get dedicated application pool user is a Windows-specific "
			u"function and can not be applied to Plesk for Unix"
		)

	def refresh_node_components(self, node):
		raise NotImplementedError(
			u"Refresh node components is a Windows-specific function and can not be applied to Plesk for Unix"
		)