from parallels.common.actions.base.compound_action import CompoundAction
from parallels.common.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.common.utils.backup_adapter import SubscriptionBackup
from parallels.custom_panel_migrator.actions.backup.create_converted import CustomPanelCreateConverted
from parallels.custom_panel_migrator.actions.backup.create_from_light import CreateFromLight


class FromCustomPanelWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromCustomPanelWorkflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'create-full-backup-from-light', CreateFromLight()
		)

		self.get_path('generate-migration-list').remove_action('analyse-hosting')

		for stub_action in ('fetch-source-shallow', 'copy-content'):
			self.get_path('transfer-accounts').replace(
				stub_action, CompoundAction()
			)

		# no need to check infrastructure in case of migration w/o source server access,
		# so just replace corresponding action with empty action
		self.replace_shared_action(
			'check-infrastructure', CompoundAction()
		)

		self.get_shared_action('convert-hosting').replace(
			'create-converted-backup',
			CustomPanelCreateConverted(SubscriptionBackup())
		)