from parallels.common.actions.base.subscription_action import SubscriptionAction

from parallels.common.actions.hosting_settings.convert.ppa.dns \
	import DNS as ActionHostingSettingsConvertPPADNS
from parallels.common.actions.utils.logging_properties import LoggingProperties
from parallels.common.target_panels import TargetPanels
from parallels.common.actions.hosting_settings.convert.plesk.dns \
	import DNS as ActionConvertDNSPlesk


class ExpandToPPADNS(ActionHostingSettingsConvertPPADNS):
	def _get_all_source_ips(self, global_context, subscription):
		"""Get all IPs of all source servers.

		:type global_context: parallels.expand_migrator.global_context.ExpandGlobalMigrationContext
		"""
		return (
			{global_context.conn.expand.conn_settings.ip} |
			global_context.expand_data.dns_server_ips |
			global_context.expand_data.plesk_server_ips |
			global_context.expand_data.mail_server_ips |
			global_context.expand_data.db_server_ips
		)


class ExpandDNS(SubscriptionAction):
	def get_description(self):
		return "Convert DNS records"

	def get_failure_message(self, global_context, subscription):
		return "Failed to convert DNS records for subscription '%s'" % subscription.name

	def get_logging_properties(self):
		return LoggingProperties(info_log=False)

	def filter_subscription(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		return True

	def run(self, global_context, subscription):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		"""
		if global_context.target_panel == TargetPanels.PLESK:
			ActionConvertDNSPlesk().run(global_context, subscription)
		elif global_context.target_panel == TargetPanels.PPA:
			ExpandToPPADNS().run(global_context, subscription)
		else:
			raise NotImplementedError(
				"DNS conversion is implemented only for Plesk and PPA"
			)