from parallels.utils import cached
from parallels.common.connections.source_server import SourceServer


class Connections(object):
	def __init__(self, config, target_panel):
		self._config = config
		self.target = target_panel.get_connections(config)

	def check_source_servers(self):
		"""Check source servers: connections, versions, licenses, etc"""

		# By default, don't check anything
		# Override in child classes
		pass

	@cached
	def has_source_node(self, node_id):
		return node_id in self.get_information_servers()

	@cached
	def get_source_node(self, node_id):
		return SourceServer(
			node_id,
			self.get_information_servers()[node_id]
		)

	def get_information_servers(self):
		"""Get servers which could provide info about subscriptions and customers""" 
		raise NotImplementedError()
