from collections import namedtuple

from parallels.expand_api.core import parse_result_set
from parallels.utils.xml import elem, text_elem, seq

DnsZoneInfo = namedtuple('DnsZoneInfo', ('id'))


class PleskCentralizedDnsZoneOperator:
	class GetZone(namedtuple('GetZone', ('filter'))):
		class FilterByDomainId(namedtuple('FilterByDomainId', ('ids',))):
			def inner_xml(self):
				return [text_elem('domain_id', domain_id) for domain_id in self.ids]

		operator_name = 'exp_plesk_centralized_dns_zone'
		operation_name = 'get_zone'

		def inner_xml(self):
			return [
				elem('filter', self.filter.inner_xml()),
			]
			
		@classmethod
		def parse(cls, elem):
			return parse_result_set(elem, cls._parse_data)

		@classmethod
		def _parse_data(cls, elem):
			return DnsZoneInfo(
				id=elem.findtext('id')
			)

	class SyncZone(namedtuple('SyncZone', ('filter', 'force'))):
		class FilterByCdnsZoneId(namedtuple('FilterByCdnsZoneId', ('ids',))):
			def inner_xml(self):
				return [text_elem('cdns_zone_id', cdns_zone_id) for cdns_zone_id in self.ids]

		operator_name = 'exp_plesk_centralized_dns_zone'
		operation_name = 'sync_zone'

		def inner_xml(self):
			return seq(
				elem('filter', self.filter.inner_xml()),
				elem('force') if self.force else None
			)

		@classmethod
		def parse(cls, elem):
			return parse_result_set(elem, cls._parse_data)

		@classmethod
		def _parse_data(cls, elem):
			pass
