
// Show popup dialog to reassign plan of subscriptions.
// Arguments: subscriptions - list of subscription names.
function showReassignPlanPopup(subscriptions, onSuccess) {
    // compose title - it is different when one subscription is selected
    // and when multiple subscriptions are selected
    var title = '';
    if (subscriptions.length > 1) {
        title = formatMessage(MESSAGE_POPUP_REASSIGN_PLAN_TITLE_MULTIPLE, subscriptions.length);
    } else if (subscriptions.length == 1) {
        title = formatMessage(MESSAGE_POPUP_REASSIGN_PLAN_TITLE_MIGRATE_SINGLE, subscriptions[0]);
    } else {
        // no subscriptions - no sense to show dialog
        return;
    }

    new Ajax.Request(URL_GET_REASSIGN_PLAN_CONTROL_DATA, {
        parameters: {
            subscriptions: Object.toJSON(subscriptions)
        },
        onSuccess: function(response) {
            var planControlData = response.responseText.evalJSON();

            var popup = new Jsw.Popup({
                title: title,
                content: (
                    '<div class="form-row">' +
                        '<div class="field-name">' + MESSAGE_POPUP_REASSIGN_PLAN_NEW_PLAN + '</div>' +
                        '<div class="field-value">' +
                            '<div id="reassign-plan-input-container"></div>' +
                        '</div>' +
                    '</div>'
                ),
                buttons: [
                    {
                        id: 'reassignPlanOkButton',
                        title: MESSAGE_POPUP_REASSIGN_PLAN_BUTTON_OK,
                        class: 'action',
                        handler: function (event, popup) {
                            var elemReassignPlan =  $$('input[name="reassign-plan"]').first();

                            disableButtonInProgress($('reassignPlanOkButton'), 'changingButtonTitle');
                            disableButtonPlain($('reassignPlanCancelButton'));

                            new Ajax.Request(URL_REASSIGN_PLAN_SUBSCRIPTIONS, {
                                parameters: {
                                    subscriptions: Object.toJSON(subscriptions),
                                    plan: elemReassignPlan.value
                                },
                                onSuccess: function (response) {
                                    if (onSuccess) {
                                        onSuccess();
                                    }
                                    popup.hide();
                                }
                            });
                        }
                    },
                    {
                        id: 'reassignPlanCancelButton',
                        title: MESSAGE_POPUP_REASSIGN_PLAN_BUTTON_CANCEL,
                        handler: function (event, popup) {
                            popup.hide();
                        }
                    }
                ],
                popupCls: 'popup-panel popup-panel-centered migrator-popup-reassign'
            });

            popup.show();

            new Jsw.LookUp({
                id: 'reassign-plan',
                name: 'reassign-plan',
                renderTo: 'reassign-plan-input-container',
                data: planControlData,
                value: '',
                locale: REASSIGN_PLAN_LOCALE
            });
        }
    });
}