
// Show popup dialog with migration issues for some object
// Arguments:
// - title: popup dialog title
// - issues - array of objects, each object describes an issue and contains problem text, solution text, etc,
//   see asDictionary method of Modules_PanelMigrator_Backend_Issue
function showIssuesPopupDialog(title, issues) {
    var popupContent = '';

    popupContent += '<div class="status-details-dialog-content">';

    if (issues.length > 0) {
        var lastIssue = issues[issues.length - 1];
        issues.each(function(issue) {
            var image = migratorImage('subscription-status-success.png');
            if (issue.severity == issueSeverity.ERROR) {
                image = migratorImage('subscription-status-error.png');
            } else if (issue.severity == issueSeverity.WARNING) {
                image = migratorImage('subscription-status-warning.png');
            }

            popupContent += '<div>';
            popupContent += '<img src="' + image + '" class="status-details-dialog-issue-icon">';
            popupContent += '&nbsp;';
            popupContent += '[' + formatStr(issue.executionDate) + ']';
            popupContent += '&nbsp;';
            popupContent += '[' + formatStr(issue.executionCommandTitle) + ']';
            popupContent += '&nbsp;';
            popupContent += formatStr(issue.problemText);

            if (issue.solutionText) {
                popupContent += '<br/>';
                popupContent += formatStr(issue.solutionText);
            }
            popupContent += '</div>';

            if (issue != lastIssue) {
                popupContent += '<hr/>';
            }
        });
    } else {
        popupContent += migratorLocale.lmsg('popupStatusDetailsNoIssues');
    }

    popupContent += '</div>';

    var popup = new Jsw.Popup({
        title: title,
        content: popupContent,
        buttons: [
            {
                title: migratorLocale.lmsg('popupStatusDetailsButtonOk'),
                class: 'action',
                handler: function(event, popup) {
                    popup.hide();
                }
            }
        ],
        popupCls: 'popup-panel popup-panel-centered'
    });

    popup.show();
}
