from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core import MigrationError


class SetExternalIdNotSupported(CommonAction):
    def get_description(self):
        return messages.ACTION_SET_EXTERNAL_ID_NOT_SUPPORTED

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_SET_EXTERNAL_ID_NOT_SUPPORTED_FAILED

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        raise MigrationError(messages.ACTION_SET_EXTERNAL_ID_NOT_SUPPORTED_MESSAGE)
