from parallels.core import messages
from parallels.core.reports.model.issue import Issue
from parallels.core.utils.common.logging import create_safe_logger

logger = create_safe_logger(__name__)


def check_web_ip(report, subscription, domain_name):
    """Check that at least one web IP address is configured for subscription; if not - add issues to report

    :type report: parallels.core.reports.model.report.Report
    :type subscription: parallels.core.migrated_subscription.MigratedSubscription
    :type domain_name: str | unicode
    :rtype: bool
    """
    if not (subscription.target_web_ip or subscription.target_web_ipv6):
        errmsg = (
            messages.TARGET_PANEL_WEBSPACE_S_IS_NOT % (
                subscription.name, domain_name
            )
        )
        logger.error(errmsg)
        report.add_issue(
            'real_check_web_failure', Issue.SEVERITY_ERROR, errmsg,
            messages.MAKE_SURE_THAT_WEB_HOSTING_IS
        )
        return False

    return True


def should_run_post_migration_checks(global_context, check_type=None):
    """Check whether execution of post-migration checks is enabled or disabled by CLI options

    :type global_context: parallels.core.global_context.GlobalMigrationContext
    :type check_type: str | unicode
    :rtype: bool
    """
    if (
        check_type is not None and
        hasattr(global_context.options, 'skip_test_%s' % check_type) and
        getattr(global_context.options, 'skip_test_%s' % check_type)
    ):
        return False

    return not (
        hasattr(global_context.options, 'run_post_migration_checks') and
        not global_context.options.run_post_migration_checks
    )
