from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.utils.common.logging import create_safe_logger

logger = create_safe_logger(__name__)


class RemoveSubscriptionsFromTargetAction(CommonAction):
    """Remove subscriptions listed in migration list from the target server"""

    def get_description(self):
        """Get short description of action as string

        :rtype: str | unicode
        """
        return messages.REMOVE_SUBSCRIPTIONS_ACTION_DESCRIPTION

    def get_failure_message(self, global_context):
        """Get message for situation when action failed

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :rtype: basestring
        """
        return messages.REMOVE_SUBSCRIPTIONS_ACTION_FAILURE

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        for subscription in global_context.migration_list_data.subscriptions_mapping.iterkeys():
            if global_context.hosting_repository.subscription.is_exists(subscription):
                logger.finfo(messages.REMOVE_SUBSCRIPTION_FROM_TARGET, subscription=subscription)
                global_context.hosting_repository.subscription.remove(subscription)
                global_context.subscriptions_status.reset_operation_status(subscription)
