
class ApplicationConfig(object):
    """Base class for detection and fixing application configuration files for popular applications"""

    def get_config_file_description(self, filename):
        """Human-readable description of configuration file

        :rtype: str | unicode
        """
        raise NotImplementedError()

    def filename_match(self, path):
        """Check if given path looks like configuration file of that application

        :type path: str | unicode
        :rtype: boolean
        """
        raise NotImplementedError()

    def contents_match(self, contents):
        """Check if given file contents looks like configuration file of that application

        :type contents: str | unicode
        :rtype: boolean
        """
        raise NotImplementedError()

    def fix_database_hostname(self, contents, db_host_mapping):
        """Fix database hostname in configuration file of that application

        :type contents: str | unicode
        :type db_host_mapping: dict[str | unicode, str | unicode]
        :rtype: parallels.core.utils.line_processor.ReplaceResults
        """
        raise NotImplementedError()
