from parallels.core.utils.entity import Entity


class ServicePlanAddonModel(object):
    def get_list(self, filter_id=None, filter_name=None, filter_owner_id=None, filter_owner_username=None):
        """Retrieve list of service plan add-ons by given filter

        :type filter_id: list[int] | None
        :type filter_name: list[str] | None
        :type filter_owner_id: list[int] | None
        :type filter_owner_username: list[str] | None
        :rtype: list[parallels.core.hosting_repository.service_plan_addon.ServicePlanAddonEntity]
        """
        raise NotImplementedError()

    def create(self, name, owner_username, settings):
        """Create service plan add-on with given name, owner and settings in target panel

        :type name: str
        :type owner_username: str
        :type settings:
        """
        raise NotImplementedError()


class ServicePlanAddonEntity(Entity):
    def __init__(self, service_plan_addon_id, name, owner_id):
        self._service_plan_addon_id = service_plan_addon_id
        self._name = name
        self._owner_id = owner_id

    @property
    def service_plan_addon_id(self):
        return self._service_plan_addon_id

    @property
    def name(self):
        return self._name

    @property
    def owner_id(self):
        return self._owner_id
