# coding=utf-8
from parallels.core.utils.message_utils import single_line_message, multi_line_message, load_overrides

LOG_EXCEPTION = single_line_message("""
    Exception:
""")
EXCEPTION_PARALLEL_EXECUTION = single_line_message("""
    Unable to execute command because another migration is in progress
""")
ACTION_GET_PROGRESS = single_line_message("""
    Get operation progress in current session
""")
ACTION_GET_PROGRESS_FAILED = single_line_message("""
    Unable to retrieve operation progress in current session
""")
ACTION_GET_PROGRESS_DATA = single_line_message("""
    Last executed command is {command}, it has status {status}
""")
ACTION_GET_PROGRESS_NONE = single_line_message("""
    No one command was executed
""")
ACTION_CHECK_UPGRADE_ALLOWED = single_line_message("""
    Check availability to perform upgrade gracefully
""")
ACTION_CHECK_UPGRADE_ALLOWED_FAILED = single_line_message("""
    Unable to check availability to perform upgrade
""")
ACTION_CHECK_UPGRADE_ALLOWED_YES = single_line_message("""
    Gracefully upgrade is available
""")
ACTION_CHECK_UPGRADE_ALLOWED_NO = single_line_message("""
    Gracefully upgrade is not available
""")
ACTION_CHECK_UPGRADE_ALLOWED_DIRECTORY_UNAVAILABLE = single_line_message("""
    Unable to open directory "{directory_path}": {error_message}
""")
ACTION_CHECK_TARGET_ACCOUNT = single_line_message("""
    Check that specified target server account is built-in Windows administrator
""")
ACTION_CHECK_TARGET_ACCOUNT_FAILED = single_line_message("""
    Failed to check that specified target server account is built-in Windows administrator
""")
ACTION_CHECK_TARGET_ACCOUNT_UNABLE_RUN = single_line_message("""
    Unable to check that Plesk Migrator was executed under built-in administrator account: {exception}
""")
ACTION_CHECK_TARGET_ACCOUNT_UNABLE_SPECIFIED = single_line_message("""
    Unable to check that specified account '{username}' is built-in administrator account: {exception}
""")
ACTION_CHECK_TARGET_ACCOUNT_BUILT_IN_RUN = single_line_message("""
    Plesk Migrator was executed under built-in administrator account
""")
ACTION_CHECK_TARGET_ACCOUNT_NOT_BUILT_IN_RUN = single_line_message("""
    Plesk Migrator was executed not under built-in administrator account
""")
ACTION_CHECK_TARGET_ACCOUNT_BUILT_IN_SPECIFIED = single_line_message("""
    Specified account '{username}' is built-in administrator account
""")
ACTION_CHECK_TARGET_ACCOUNT_NOT_BUILT_IN_SPECIFIED = single_line_message("""
    Specified account '{username}' is not built-in administrator account
""")

ACTION_DEPLOY_SUBSCRIPTION = single_line_message("""
    Deploy subscription
""")
ACTION_DEPLOY_SUBSCRIPTION_FAILED = single_line_message("""
    Failed to deploy subscription '{subscription_name}'
""")
ACTION_DEPLOY_SUBSCRIPTION_SET_PHYSICAL_HOSTING = single_line_message("""
    Set physical hosting on subscription '{subscription_name}'
""")
ACTION_DEPLOY_SUBSCRIPTION_SET_LIMITS = single_line_message("""
    Set limits on subscription '{subscription_name}'
""")

ACTION_READ_IP_MAPPING = single_line_message("""
    Read IP mapping file
""")
ACTION_READ_IP_MAPPING_FAILED = single_line_message("""
    Failed to read IP mapping file
""")
ACTION_READ_IP_MAPPING_READ_IP_MAPPING_FILE = single_line_message("""
    Read IP-mapping file {ip_mapping_file}
""")
ACTION_READ_IP_MAPPING_IP_MAPPING_FILE_NOT_EXIST = single_line_message("""
    IP-mapping file {ip_mapping_file} does not exist. Please specify correct location of IP mapping file via
    --ip-mapping-file option
""")

ACTION_SET_EXTERNAL_ID_NOT_SUPPORTED = single_line_message("""
    Check if target panel supports External ID
""")
ACTION_SET_EXTERNAL_ID_NOT_SUPPORTED_FAILED = single_line_message("""
    Failed to check if target panel supports External ID
""")
ACTION_SET_EXTERNAL_ID_NOT_SUPPORTED_MESSAGE = single_line_message("""
    External ID is not supported by target panel
""")

ACTION_STOP_TRANSFER_AGENTS = single_line_message("""
    Stop remote Windows agents
""")
ACTION_STOP_TRANSFER_AGENTS_FAILED = single_line_message("""
    Failed to stop remote Windows agents
""")
ACTION_START_TRANSFER_AGENTS = single_line_message("""
    Start remote Windows agents
""")
ACTION_START_TRANSFER_AGENTS_FAILED = single_line_message("""
    Failed to start remote Windows agents
""")
ACTION_RUN_QUEUE_DESCRIPTION = single_line_message("""
    Run tasks from migration queue
""")
ACTION_RUN_QUEUE_FAILURE = single_line_message("""
    Failed to run tasks from migration queue
""")
ACTION_ADD_QUEUE_TASK_DESCRIPTION = single_line_message("""
    Add new migration task to the queue
""")
ACTION_ADD_QUEUE_TASK_FAILURE = single_line_message("""
    Failed to add new migration task to the queue
""")
ACTION_REMOVE_QUEUE_SUBSCRIPTIONS_DESCRIPTION = single_line_message("""
    Remove subscriptions from queue
""")
ACTION_REMOVE_QUEUE_SUBSCRIPTIONS_FAILURE = single_line_message("""
    Failed to remove subscriptions from queue
""")
ACTION_STOP_MIGRATION_DESCRIPTION = single_line_message("""
    Stop all running migrations in the current session
""")
ACTION_STOP_MIGRATION_FAILURE = single_line_message("""
    Failed stop migrations in the current session
""")
ACTION_STOP_QUEUE_TASK_DESCRIPTION = single_line_message("""
    Stop migration task
""")
ACTION_STOP_QUEUE_TASK_FAILURE = single_line_message("""
    Failed to stop migration task
""")
COMMAND_GET_PROGRESS = single_line_message("""
    Get progress of previously executed command in current session
""")
COMMAND_RUN_QUEUE = single_line_message("""
    Run tasks from migration queue
""")
COMMAND_STOP_MIGRATION = single_line_message("""
    Stop all migrations in the current session
""")
ADD_QUEUE_TASK_COMMAND_FILE = single_line_message("""
    File which contains command to be executed
""")
ADD_QUEUE_TASK_MIGRATION_LIST_FILE = single_line_message("""
    File which contains migration list in JSON format for which the command will be executed
""")
ADD_QUEUE_TASK_ID = single_line_message("""
    Identifier of task to add. If not specified - generated automatically by current date and time.
""")
COMMAND_ADD_QUEUE_TASK = single_line_message("""
    Add new migration task to the queue
""")
RUN_TASK = single_line_message("""
    Run task "{task_id}"
""")
FINISHED_TASK = single_line_message("""
    Finished task "{task_id}"
""")
RUN_COMMAND = single_line_message("""
    Run task command: {command}
""")
ANOTHER_INSTANCE_OF_RUN_QUEUE_RUNNING = single_line_message("""
    Another instance of "run-queue" command is already running, this instance will be stopped
""")
COMMAND_CHECK_UPGRADE_ALLOWED = single_line_message("""
    Check ability to perform upgrade gracefully
""")
COMMAND_START_TRANSFER_AGENT = single_line_message("""
    Deploy and start RPC Agents on all Windows servers
""")
COMMAND_ANALYSE_HOSTING = single_line_message("""
    Analyse source and destination servers for using effective migration strategy
""")
DOWNLOAD_DUMP_AGENT = single_line_message("""
    Download dump agent installer from {url}
""")
UPLOAD_DUMP_AGENT = single_line_message("""
    Upload dump agent installer to {path} at {server}
""")
INSTALL_DUMP_AGENT = single_line_message("""
    Install dump agent at {server}
""")
DOWNLOAD_RSYNC = single_line_message("""
    Download rsync installer from {url}
""")
UPLOAD_RSYNC = single_line_message("""
    Upload rsync installer to {path} at {server}
""")
INSTALL_RSYNC = single_line_message("""
    Install rsync at {server}
""")
DOWNLOAD_PYTHON = single_line_message("""
    Download python package from {url}
""")
DOWNLOAD_7ZIP = single_line_message("""
    Download 7zip package from {url}
""")
DOWNLOAD_RPC_AGENT = single_line_message("""
    Download RPC agent package from {url}
""")
DOWNLOAD_PAEXEC = single_line_message("""
    Download paexec from {url}
""")
MIGRATION_EXCEPTION_TARGET_PANEL_NAME_UNDEFINED = single_line_message("""
    Name of target panel was not specified during configuring of migration
""")
MIGRATION_TOOLS_TRIED_PERFORM_OPERATION_IN = single_line_message("""
    Migration tools tried to perform operation in %s attempts.
""")
FAILED_MIGRATE_SERVICE_PLAN_THAT_RESELLER_2 = single_line_message("""
    Failed to migrate service plan that the reseller of this plan is assigned to.
""")
FAILED_MIGRATE_RESELLER_THAT_OWNS_CLIENT_1 = single_line_message("""
    Failed to migrate reseller that owns client of this subscription.
""")
FAILED_MIGRATE_SERVICE_PLAN_THAT_RESELLER_1 = single_line_message("""
    Failed to migrate service plan that the reseller that owns client of this subscription is assigned to.
""")
FAILED_MIGRATE_SERVICE_PLAN_THAT_RESELLER = single_line_message("""
    Failed to migrate service plan that the reseller that owns this client is assigned to.
""")
FAILED_MIGRATE_RESELLER_PLAN = single_line_message("""
    Failed to migrate reseller of this plan.
""")
FAILED_MIGRATE_SERVICE_PLAN_RESELLER_IS = single_line_message("""
    Failed to migrate service plan this reseller is assigned to.
""")
FAILED_MIGRATE_CLIENT_SUBSCRIPTION = multi_line_message("""
    Subscription was not migrated: Failed to migrate customer that owns this subscription.
    Resolve issues with the customer (or create it manually) and restart migration.

    Also you can assign subscription to another customer or administrator.
    Refer to Plesk Migrator documentation for more information.
""")
FAILED_MIGRATE_RESELLER_THAT_OWNS_CLIENT = single_line_message("""
    Failed to migrate reseller that owns this client.
""")
FAILED_MIGRATE_SERVICE_PLAN_SUBSCRIPTION = single_line_message("""
    Failed to migrate service plan of this subscription.
""")
FAILED_TO_CREATE_RESELLER_ON_TARGET = single_line_message("""
    Failed to create reseller in target panel.
""")
AUTO_GENERATED_CUSTOMER_COMMENT = single_line_message("""
    automatically generated special account which will receive %s's subscriptions
""")
ALREADY_EXISTS_IN_TARGET_PANEL = single_line_message("""
    already exists in the target panel
""")
EXISTING_HOSTING_PLANS_NOT_USED_BY = single_line_message("""
    Existing hosting plans not used by any customer
""")
MIGRATION_LIST_FILE_HEADER = multi_line_message("""
    # This file specifies a list of domains and clients to be migrated.
    # For each domain, you should specify a service plan, that is to be
    # used when creating subscription for this domain. You should also
    # specify a client, that owns the domain. Domains that are not assigned
    # to a customer, will be automatically assigned to a reseller or admin
    # account, depending on what you've specified earlier in this file.
    #
    # For each client, you should specify a reseller, that will be a vendor
    # of the corresponding customer. If you do not specify a reseller,
    # corresponding customer will be created under admin. For the examples
    # of how to specify that, consult Plesk Migrator documentation.
""")
ADMIN_SUBSCRIPTIONS_AND_CUSTOMERS = single_line_message("""
    # Admin subscriptions and customers
""")
CUSTOM_SUBSCRIPTIONS_MUST_ASSOCIATED_SERVICE_TEMPLATE = single_line_message("""
    # Custom subscriptions, must be associated with a service template to be transferred
""")
MIGRATION_LIST_INVALID_LINE = single_line_message("""
    Line {line} with content '{content}' is not valid
""")
MIGRATION_LIST_SUBSCRIPTION_NOT_ON_SOURCE = single_line_message("""
    Line {line}: subscription '{subscription}' selected for migration is not presented on source server.
""")
MIGRATION_LIST_SUBSCRIPTION_IS_ALREADY_DEFINED = single_line_message("""
    Line {line}: subscription '{subscription}' is already defined
""")
MIGRATION_LIST_INVALID_IPV6 = single_line_message("""
    Line {line}: '{address}' is not a valid value for IPv6 mapping.
    Please specify valid IPv6 address or select one of: {possible_values}
""")
MIGRATION_LIST_INVALID_IPV4 = single_line_message("""
    Line {line}: '{address}' is not a valid value for IPv4 mapping.
    Please specify valid IPv4 address or select one of: {possible_values}
""")
MIGRATION_LIST_CUSTOMER_ASSIGNED_TO_ANOTHER_RESELLER = single_line_message("""
    Line {line}: customer '{customer}' was already assigned to another reseller '{reseller}'
""")
FAILED_TO_CONNECT_TO_SERVER_WITH_RPC_AGENT = single_line_message("""
    Failed to connect to server {server} with RPC Agent
""")
LINE_S_INVALID_SOURCE_IP_ADDRESS = single_line_message("""
    Line #%s: invalid source IP address '%s'. Specify valid IPv4 or IPv6 address.
""")
LINE_S_TARGET_IP_ADDRESS_S = single_line_message("""
    Line #%s: target IP address '%s' does not exist on target server.
""")
LINE_S_SOURCE_IP_ADDRESS_S = single_line_message("""
    Line #%s: source IP address '%s' was already specified before.
""")
LINE_S_IP_ADDRESSES_DIFFERENT_TYPES = single_line_message("""
    Line #%s: IP addresses of different types can not be mapped. Specify either both IPv4 addresses, or both IPv6
    addresses.
""")
LINE_S_INVALID_TARGET_IP_ADDRESS = single_line_message("""
    Line #%s: invalid target IP address '%s'. Specify valid IPv4 or IPv6 address.
""")
SKIP_CHECKING_LOG_PRIORITY_OPTION = single_line_message("""
    Skip checking log priority option.
""")
CHECK_DISK_SPACE_REQUIREMENTS_FOR_S = single_line_message("""
    Check disk space requirements for %s
""")
FAILED_SET_SECURITY_POLICY_WINDOWS = multi_line_message("""
    Failed to set security policy on some of target servers: %s
    Restoration of customers/users/resellers with weak passwords might be failed by Windows security policy.
    Set 'PasswordComplexity' value to '0' with help of 'secedit' utility and re-run migration tool.
    Restore required security policy after migration.
""")
FAILED_DETECT_DATABASES_SUBSCRIPTION = single_line_message("""
    Failed to detect databases of subscription.
""")
FAILED_CHECK_CONNECTIONS_BETWEEN_MAIL_SERVERS = single_line_message("""
    Failed to check connections between source and the destination mail servers
""")
NO_RESELLER_WITH_SUCH_LOGIN_ON_TARGET = single_line_message("""
    There is no reseller named %s on target panel, skipped retrieving its plans
""")
CHECK_MYSQL_MAX_ALLOWED_PACKET = single_line_message("""
    Check MySQL max allowed packet
""")
DETAILED_RESELLER_MIGRATION_STATUS = single_line_message("""
    Detailed Reseller Migration Status
""")
DETAILED_RESELLER_MIGRATION_STATUS_TARGET_RESELLER = single_line_message("""
    Reseller
""")
FAILED_FIND_SUBSCRIPTION_BY_NAME_1 = single_line_message("""
    Failed to find subscription by name
""")
CHECK_MYSQL_MAX_ALLOWED_PACKET_1 = single_line_message("""
    Check MySQL max allowed packet
""")
GET_TARGET_PANEL_RESELLERS = single_line_message("""
    Get target panel's resellers for conflict resolution
""")
FAILED_COPY_CONTENT_DATABASE_S_MIGRATION = single_line_message("""
    Failed to copy content of database '%s': migration of databases from Windows to Unix is not allowed
""")
UNABLE_RETRIEVE_RAW_BACKUP = single_line_message("""
    Unable to retrieve raw backup "%s"
""")
FAILED_COPY_DATABASE_CONTENT = single_line_message("""
    Failed to copy content of database '%s'
""")
MIGRATION_TOOL_NOT_ENOUGH_INFORMATION_TRANSFER = single_line_message("""
    Migration list was not specified, and Plesk Migrator failed to create it. Please create it manually and restart
    the migration.
""")
UNABLE_RETRIEVE_SOURCE_NODE_WITH_ID = single_line_message("""
    Unable to retrieve source server with id "%s"
""")
DATABASE_DOES_NOT_EXIST = single_line_message("""
    %s database '%s' does not exist on target. Its content will not be copied.
""")
REVIEW_PRE_MIGRATION_ERRORS = single_line_message("""
    Please review pre-migration tree above and fix the errors. You can also use --ignore-pre-migration-errors command-
    line option if you're sure what you are doing.
""")
FAILED_REFRESH_COMPONENTS_LIST_FOR_WINDOWS = single_line_message("""
    Failed to refresh components list for Windows servers: %s.
""")
FAILED_FIND_SUBSCRIPTION_BY_NAME = single_line_message("""
    Failed to find subscription by name
""")
TRANSFERRED_DOMAINS_DNS_ISSUES = single_line_message("""
    Transferred Domains DNS Issues
""")
SKIP_COPY_DATABASE_DUE_TO_CONFLICT = single_line_message("""
    Skip copy database '{db_name}' from {db_type} server as there is some conflict (run 'plesk-migrator check' command
    to see conflict details)
""")
TRANSFERRED_DOMAINS_FUNCTIONAL_ISSUES = single_line_message("""
    Transferred Domains' Functional Issues
""")
SKIP_CHECKING_PANEL_MIGRATOR_UPDATES = single_line_message("""
    Skip checking Plesk Migrator updates
""")
SAVED_TARGET_MODEL_TO_FILE = single_line_message("""
    Saved panel objects to file '{filename}':
""")
UNABLE_CONTINUE_MIGRATION_UNTIL_THERE_ARE = single_line_message("""
    Unable to continue migration until there are no issues at 'error' level in pre-migration checks.
""")
TRANSFERRED_DOMAINS_DATABASE_ISSUES = single_line_message("""
    Transferred Domains Database Issues
""")
MIGRATION_LIST_NON_UNICODE_CHARS = single_line_message("""
    There are non-UTF-8 characters in the migration list. Convert the migration list file to UTF-8 encoding.
""")
SUBSCRIPTIONS_MIGRATION_STATUS = multi_line_message("""
    Operation finished successfully for %s out of %s subscriptions
""")
RUN_TEST_ALL_AFTER_MIGRATION = multi_line_message("""
    To verify that the transfer completed correctly, run 'plesk-migrator test-all config.ini'.
    This command will check the operation of web, mail, DNS, database, FTP/SSH/RDP services for each transferred domain.
""")
TARGET_MODEL_FILE_NOT_FOUND = single_line_message("""
    Internal error: target model file not found.
""")
UNABLE_COPY_CONTENT_DATABASE_S_SUBSCRIPTION = single_line_message("""
    Unable to copy content of database '%s' on subscription '%s'. Trying to copy content again.
""")
REPORT_WAS_SAVED_INTO_FILE = single_line_message("""
    The report was saved into the file %s
""")
FAILED_FIND_DOMAIN_IN_CONVERTED_BACKUP = single_line_message("""
    Failed to find domain '%s' in converted backup
""")
CRITICAL_INFRASTRUCTURE_ISSUES = multi_line_message("""
    There are infrastructure issues that should be fixed prior to the next migration steps. Migration is stopped, please
    check and fix the issues listed above and then run transfer-accounts command again.

    If you want to skip infrastructure checks pass --skip-infrastructure-checks command line option
""")
CONNECTIONS_BETWEEN_SOURCE_AND_DESTINATION_DATABASE = single_line_message("""
    Connections between source and the destination database servers
""")
CHECK_CONNECTIONS_TARGET_NODES = single_line_message("""
    Check connections to target servers
""")
NOT_ENOUGH_DISK_SPACE = single_line_message("""
    %s has insufficient free disk space for migration. Migration is stopped. Free some disk space, then run 'transfer-
    accounts' command again.
""")
OPERATION_FINISHED_SUCCESSFULLY_FOR_RESELLERS = single_line_message("""
    Operation finished successfully for %s out of %s resellers
""")
RESTART_IIS_FOR_IDN_DOMAINS = single_line_message("""
    Restart IIS for IDN domains on %s.
""")
DNS_FORWARDING_WAS_SUCCESSFULLY_SET_UP = single_line_message("""
    DNS forwarding was successfully set up
""")
DNS_FORWARDING_WAS_SUCCESSFULLY_UNDONE = single_line_message("""
    DNS forwarding was successfully undone
""")
GET_TARGET_PANEL_CUSTOMERS = single_line_message("""
    Get target panel's customers for conflict resolution
""")
INTERNAL_ERROR_INFRASTRUCTURE_CHECKS = multi_line_message("""
    Internal error: %s.
    Migration tool will skip corresponding infrastructure checks and proceed to the next migration steps.
""")
FAILED_COPY_DB_CONTENT_UNIX_WINDOWS = single_line_message("""
    Failed to copy content of database '%s': migration of databases from Unix to Windows is not allowed
""")
TRANSFERRED_DOMAINS_MAIL_ISSUES = single_line_message("""
    Transferred Domains Mail Issues
""")
CHECK_LOG_PRIORITY_TARGET_PLESK_NODE = single_line_message("""
    Check log priority on target Plesk server
""")
UNABLE_READ_MIGRATION_LIST_FILE = single_line_message("""
    Unable to read migration list file.
""")
ERRORS_READING_MIGRATION_LIST = multi_line_message("""
    There were some error(s) while reading migration list file. Please review and fix them:
    {errors}
""")
ALL_SUBSCRIPTIONS_ARE_FAILED_MIGRATE_STOPPING = single_line_message("""
    All subscriptions are failed to migrate, stopping.
""")
RESOLVE_ISSUE_DATABASE_CREATION_CREATE_DATABASE = single_line_message("""
    Resolve the issue with database creation or create database on target panel, then run copy-db-content command for
    that subscription to copy database contents.
""")
FAILED_SYNCHRONIZE_SUBSCRIPTIONS_PLANS = single_line_message("""
    Failed to synchronize subscriptions with plans
""")
DISK_SPACE_REQUIREMENTS_FOR_S_ARE = single_line_message("""
    Disk space requirements for %s are met
""")
AT_LEAST_ONE_DNS_SERVER_SHOULD = single_line_message("""
    At least one DNS server should exist for domain '%s'
""")
FAILED_CHECK_CONNECTIONS_WEB_SERVERS = single_line_message("""
    Failed to check connections between source and the destination web servers
""")
FAILED_CHECK_CONNECTIONS_DB_SERVERS = single_line_message("""
    Failed to check connections between source and the destination database servers
""")
ERROR_WHILE_CHECKING_TARGET_PANEL_CONFIGURATION = single_line_message("""
    Error while checking target panel configuration and connections: '%s'
""")
GET_TARGET_PANEL_PLANS = single_line_message("""
    Get target panel's plans for conflict resolution
""")
CONNECTIONS_BETWEEN_SOURCE_AND_DESTINATION_WEB = single_line_message("""
    Connections between source and the destination web servers
""")
CONNECTIONS_BETWEEN_SOURCE_AND_DESTINATION_MAIL = single_line_message("""
    Connections between source and the destination mail servers
""")
FAILED_SYNCRONIZE_SUBSCRIPTION_PLAN = single_line_message("""
    Failed to synchronize subscription with plan
""")
FIX_SERVICE_TEMPLATE_SUBSCRIPTION_IS_ASSIGNED_1 = single_line_message("""
    Fix service template subscription is assigned to, so databases are provisioned to Unix servers
""")
CHECK_PLESK_VERSION_MAIN_TARGET_NODE = single_line_message("""
    Check Plesk version of the main target server
""")
INFRASTRUCTURE_CHECK_INTERNAL_ERROR = single_line_message("""
    Failed to perform infrastructure checks: %s. Check debug.log for more details. Still migration will proceed to the
    next steps.
""")
UNABLE_TO_CAT_FILE = single_line_message("""
    Unable to cat %s file. Most probably this file is absent.
""")
REVIEW_PRE_MIGRATION_ISSUES = single_line_message("""
    Please review pre-migration tree above and fix the errors. You can also use --ignore-pre-migration-errors command-
    line option if you're sure what you are doing.
""")
FIX_SERVICE_TEMPLATE_SUBSCRIPTION_IS_ASSIGNED = single_line_message("""
    Fix service template subscription is assigned to, so databases are provisioned to Windows servers
""")
GET_TARGET_DOMAINS = single_line_message("""
    Get target panel's domains for conflict resolution
""")
SUMMARY = single_line_message("""
    ******************** Summary ********************
""")
FAILED_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Failed to check disk space requirements.
""")
FAILED_TO_COPY_DATABASE_CONTENT = single_line_message("""
    Failed to copy content of database '%s'
""")
UNABLE_TO_COPY_DATABASE_CONTENT_RETRY = single_line_message("""
    Unable to copy content of database '%s' on subscription '%s'. Trying to copy content again.
""")
UNABLE_CONTINUE_MIGRATION_UNTIL_THERE_ARE_1 = single_line_message("""
    Unable to continue migration until there are no issues at 'error' level in pre-migration checks.
""")
ACTION_REMOVE_LIMITS_AND_PERMISSIONS_DESCRIPTION = single_line_message("""
    Remove limits and permissions of subscription from dump when migrating
    to Web Admin or Web App editions of Plesk
""")
ACTION_REMOVE_LIMITS_AND_PERMISSIONS_FAILURE = single_line_message("""
    Failed to remove limits and permissions of subscription from dump when migrating
    to Web Admin or Web App editions of Plesk
""")
FAILED_TO_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Failed to check disk space requirements for %s: %s. Check debug.log for more details. Still migration will proceed
    to the next steps.
""")
FAILED_CHECK_MYSQL_REQUIREMENTS = single_line_message("""
    Failed to check MySQL requirements.
""")
FAILED_FIND_CLIENT_THAT_OWNS_SUBSCRIPTION = single_line_message("""
    Failed to find client that owns subscription '%s'
""")
FAILED_FIND_SUBSCRIPTION_BY_NAME_2 = single_line_message("""
    Failed to find subscription by name
""")
STOP_RSYNC_IF_IT_IS_RUNNING = single_line_message("""
    Stop rsync if it is running, then start
""")
CONFIGURE_RSYNC_SERVER_RSYNCDCONF_AND_RSYNCDSECRETS = single_line_message("""
    Configure rsync server (rsyncd.conf and rsyncd.secrets)
""")
UNABLE_SET_VHOSTS_DIR_RSYNC_SERVER = single_line_message("""
    Unable to set vhosts_dir: rsync server at %s is not configured yet
""")
TRY_RESTART_SERVER_AND_RETRY = single_line_message("""
    , try to restart server and retry
""")
SSH_KEY_FILE_DOES_NOT_EXIST = multi_line_message("""
    SSH key file specified by 'ssh-key' option in section '{section_name}' of configuration file does not exist.
    Please specify valid filename for private SSH key and restart Plesk Migrator.
""")
IF_NOT_SPECIFIED_NONE_IS_SPECIFIED = single_line_message("""
    If not specified, or 'none' is specified, local execution is considered.
""")
WINDOWS_PASSWORD_IS_NOT_SPECIFIED = multi_line_message("""
    Windows password is not specified for server '%s'. Please
    specify it with 'windows-password' option of corresponding section
    '[%s]' in config.ini
""")
UNABLE_RETRIEVE_SOURCE_INFO_S = single_line_message("""
    Unable to retrieve source info "%s"
""")
MAKE_SURE_THAT_WEB_HOSTING_IS = single_line_message("""
    Make sure that web hosting is configured for this webspace in the target panel.
""")
TARGET_PANEL_WEBSPACE_S_IS_NOT = single_line_message("""
    The target panel webspace %s is not associated with a web IP address. Unable to check the site %s in the target
    panel.
""")
INVALID_EXTERNAL_DNS_SERVERS_OPTION = single_line_message("""
    'external-dns-servers' option in [GLOBAL] section of config file of migration tool contains invalid value: '%s'.
    Valid IPv4 address should be specified in order for all DNS checks to be performed.
""")
ALL_TRANSFERRED_DOMAINS_ARE_WORKING_CORRECTLY = single_line_message("""
    All transferred domains are working correctly.
""")
ALL_SERVICES_ARE_WORKING_CORRECTLY = single_line_message("""
    All services are working correctly.
""")
SKIPPED_CHECKING_MAILBOXES_SUBSCRIPTION_S_BECAUSE_1 = single_line_message("""
    Skipped checking mailboxes of the subscription %s because it has no mail service
""")
SKIPPED_CHECKING_MAILBOXES_SUBSCRIPTION_S_BECAUSE = single_line_message("""
    Skipped checking mailboxes of the subscription %s because it is suspended
""")
SKIPPED_CHECKING_MAIL_SERVICE_DOMAIN_S = single_line_message("""
    Skipped checking mail service of the domain %s because it is suspended
""")
SUBSCRIPTION_S_IS_NOT_PRESENTED_MAIL = single_line_message("""
    Subscription '%s' is not presented on mail server, do not check mail for it
""")
SKIPPED_CHECKING_SITE_S_SUBSCRIPTION_S = single_line_message("""
    Skipped checking site %s of subscription %s because this site is disabled
""")
SKIPPED_CHECKING_SITES_SUBSCRIPTION_S_BECAUSE = single_line_message("""
    Skipped checking the sites of the subscription %s because this subscription is disabled
""")
RESOLVE_INCONSISTENCY_SOURCE_SERVER = single_line_message("""
    Resolve the inconsistency on the source server.
""")
SKIPPED_CHECKING_SITE_S_SUBSCRIPTION_S_1 = single_line_message("""
    Skipped checking site %s of subscription %s because this site is in maintenance
""")
SKIPPED_CHECKING_SITES_DOMAIN_S_BECAUSE = single_line_message("""
    Skipped checking the sites of the domain %s because it has no web hosting
""")
SETTINGS_DOMAIN_S_SOURCE_SERVER_ARE = single_line_message("""
    The settings of the domain %s on the source server are inconsistent: web hosting is configured for this domain, but
    the domain is not associated with an IP address.
""")
SKIP_CHECKING_DOMAIN_S_BECAUSE_IT = single_line_message("""
    Skip checking of domain '%s' because it is in slave mode
""")
SKIP_CHECKING_DOMAIN_S_BECAUSE_IT_1 = single_line_message("""
    Skip checking of domain '%s' because it has no DNS zone or DNS zone is disabled
""")
CAN_NOT_EXECUTE_COMMANDS_CONNECTION_THAT = single_line_message("""
    Can not execute commands on connection that is not open
""")
CAN_NOT_UPLOAD_FILES_COMMANDS_CONNECTION = single_line_message("""
    Can not upload files commands on connection that is not open
""")
CAN_NOT_OPEN_CONNECTION_WHICH_IS = single_line_message("""
    Can not open connection which is already open
""")
CAN_NOT_CLOSE_CONNECTION_THAT_IS = single_line_message("""
    Can not close connection that is not open
""")
ACTION_TEST_SERVICES_DESCRIPTION = single_line_message("""
    Check whether services operate properly
""")
ACTION_TEST_SERVICES_FAILURE = single_line_message("""
    Failed to check whether services operate properly
""")
ACTION_TEST_MAIL_DESCRIPTION = single_line_message("""
    Check whether IMAP, SMTP and POP3 authentication work for mailboxes of the transferred domains
""")
ACTION_TEST_MAIL_FAILURE = single_line_message("""
    Failed to check whether IMAP, SMTP and POP3 authentication work for mailboxes of the transferred domains
""")
CHECK_LICENSES_TARGET_SERVERS = single_line_message("""
    Check licenses on target servers
""")
CHECK_INFRASTRUCTURE_CONNECTIONS_AND_DISK_SPACE = single_line_message("""
    Check infrastructure (connections and disk space)
""")
CHECK_DISK_SPACE_REQUIREMENTS_FOR_MAIN = single_line_message("""
    Check disk space requirements for main target server
""")
FETCH_INFORMATION_FROM_SOURCE_PANEL = single_line_message("""
    Fetch information from source panel
""")
CONVERT_HOSTING_SETTINGS_TARGET_PANEL_FORMAT = single_line_message("""
    Convert hosting settings to target panel format
""")
USE_CONVERTED_DUMPS_FROM_CACHE = single_line_message("""
    Skip convert hosting settings, use cached converted dumps
""")
COPY_WEB_FILES_AND_SYNC_WEB = single_line_message("""
    Copy web files and sync web assets
""")
ACTION_RESTORE_SECURITY_POLICY_WINDOWS = single_line_message("""
    Restore security policy on Windows servers
""")
ACTION_RESTORE_SECURITY_POLICY_WINDOWS_FAILURE = single_line_message("""
    Failed to restore security policy on Windows servers
""")
ACTION_TEST_DNS_DESCRIPTION = single_line_message("""
    Check that the DNS queries for transferred domains' records are ok
""")
ACTION_TEST_DNS_FAILURE = single_line_message("""
    Failed to check that the DNS queries for transferred domains' records are ok
""")
ACTION_SET_SECURITY_POLICY_WINDOWS = single_line_message("""
    Set security policy on Windows servers
""")
ACTION_SET_SECURITY_POLICY_WINDOWS_FAILURE = single_line_message("""
    Failed to set security policy on Windows servers, there could be problems when restoring passwords
""")
ACTION_FETCH_TARGET_INFO_DESCRIPTION = single_line_message("""
    Fetch information from target servers
""")
ACTION_FETCH_TARGET_INFO_FAILURE = single_line_message("""
    Failed to fetch information from target servers
""")
USE_CACHED_TARGET_INFO = single_line_message("""
    Use cached information from target servers
""")
RESTORE_LOGINS_SYSTEM_USERS = single_line_message("""
    Restore logins of system users
""")
SYNCHRONIZE_SUBSCRIPTIONS_PLANS = single_line_message("""
    Synchronize subscriptions with plans
""")
CONVERT_CLIENTS_AND_SUBSCRIPTIONS = single_line_message("""
    Convert clients and subscriptions
""")
CONVERT_TARGET_MODEL = single_line_message("""
    Create target hosting model
""")
REFRESH_COMPONENTS_LIST_TARGET_WINDOWS_SERVERS = single_line_message("""
    Refresh components list on target Windows servers
""")
ACTION_TEST_DATABASES_DESCRIPTION = single_line_message("""
    Check whether the databases were copied correctly
""")
ACTION_TEST_DATABASES_FAILURE = single_line_message("""
    Failed to check whether the databases were copied correctly
""")
COPY_WEB_DATABASE_AND_MAIL_CONTENT = single_line_message("""
    Copy web, database and mail content
""")
COUNT_MIGRATION_STATISTICS_PRINT_REPORT = single_line_message("""
    Count migration statistics, print report
""")
RESTORE_STATUS_SUSPENDED_CLIENTS_AND_SUBSCRIPTIONS = single_line_message("""
    Restore status of suspended clients and subscriptions
""")
CAN_NOT_REPLACE_SHARED_ACTION_SHARED = single_line_message("""
    Internal error: Can not replace shared action: shared action with ID '%s' not found in workflow
""")
MIGRATOR_INTERNAL_ERROR_ENTRY_POINT_ID = single_line_message("""
    Internal error: Entry point with ID '%s' does not exist. Check entry point ID spelling, or add entry point
    with such ID to workflow.
""")
MIGRATOR_INTERNAL_ERROR_SHARED_ACTION_ID = single_line_message("""
    Internal error: Shared action with ID '%s' does not exist. Check action ID spelling, or add shared action
    with such ID to workflow.
""")
CAN_NOT_REPLACE_ENTRY_POINT_S = single_line_message("""
    Internal error: Can not replace entry point '%s' which does not exist
""")
ENTRY_POINT_S_ALREADY_EXISTS = single_line_message("""
    Internal error: Entry point '%s' already exists
""")
EXCEPTION_IN_SUBSCRIPTION_THREAD = single_line_message("""
    Exception in subscription thread:
""")
NO_NEED_EXECUTE_ACTION_CONTINUE_NEXT = single_line_message("""
    No need to execute action, continue to the next one
""")
CHECKING_WHETHER_IT_IS_REQUIRED_EXECUTE = single_line_message("""
    Checking whether it is required to execute action
""")
EXIT_SUBSCRIPTION_ACTION_BLOCK = single_line_message("""
    Exit subscription action block
""")
ENTER_SUBSCRIPTION_ACTION_BLOCK = single_line_message("""
    Enter subscription action block
""")
INTERNAL_ERROR_IN_SUBSCRIPTION_THREAD = single_line_message("""
    Internal error in subscription thread, migration of subscription {subscription} stopped: {reason}.
""")
S_TRY_REPEAT_OPERATION_ONCE_MORE = single_line_message("""
    %s. Try to repeat operation once more.
""")
USER_INTERRUPT_REQUESTED_FORCING_STOP_MIGRATION = single_line_message("""
    User interrupt requested, forcing stop migration
""")
INTERRUPT_EXCEPTION = single_line_message("""
    Migrator interrupted by user request
""")
STOP_BY_CRITICAL_ERROR = multi_line_message("""
    %s
    Cause: %s
    That is a critical error, migration was stopped.
""")
MIGRATION_FOR_SUBSCRIPTION_FAILED = multi_line_message("""
    Migration for that subscription is considered completely failed. No further actions are performed for it.
""")
USER_INTERRUPT_REQUESTED_TRYING_STOP_MIGRATION = multi_line_message("""
    User interrupt requested, trying to stop migration gracefully:
    finish all running operations for each of migrated subscription
    To force interrupt, press Ctrl+C again, but it may lead to unpredictable results
""")
RUN_GROUP_ACTIONS_WITH_WORKERS = single_line_message("""
    Run group of actions with %s workers
""")
END_PROCESSING_SUBSCRIPTION = single_line_message("""
    END Processing subscription '%s'
""")
CAN_NOT_RUN_COMMON_ACTION_IN = single_line_message("""
    Can not run common action in subscription's actions queue
""")
TRY_REPEAT_OPERATION_ONCE_MORE = single_line_message("""
    %s. Try to repeat operation once more.
""")
INVALID_ACTION_TYPE = single_line_message("""
    Internal error: Invalid action '%s': %s is not a subclass of CompoundAction, SubscriptionAction or BaseAction
""")
FINISH_PROCESSING_SUBSCRIPTION = single_line_message("""
    Finish processing subscription '%s'
""")
RUN_SUBSCRIPTION_ACTION_CLASS = single_line_message("""
    Run subscription action class %s
""")
START_PROCESSING_SUBSCRIPTION = single_line_message("""
    Start processing subscription '%s'
""")
SKIP_COPYING_MAIL_CONTENT_FOR_DOMAIN = single_line_message("""
    Skip copying mail content for the domain %s which has no mail hosting
""")
SOURCE_MAIL_SERVER_IS_NOT_DEFINED = single_line_message("""
    Source mail server is not defined for subscription '%s', do not copy mail content
""")
RSYNC_FAILED_COPY_MAIL_CONTENT = multi_line_message("""
    Rsync failed to copy mail content from the source (%s) to the target server (%s): %s
    1. This could happen because of a network connection issue.
    Retry copying the mail content with the help of the "copy-mail-content" command.
    2. Check whether rsync is installed and configured on the source server.
""")
FAILED_RECALCULATE_MAIL_DIRECTORY_SIZE_MAIL = single_line_message("""
    Failed to recalculate mail directory size. Mail usage may become incorrect after migration
""")
SKIP_COPYING_MAIL_CONTENT_FOR_DOMAIN_1 = single_line_message("""
    Skip copying mail content for the domain %s which has no mail hosting
""")
SKIP_COPYING_MAIL_CONTENT_FOR_DOMAIN_2 = single_line_message("""
    Skip copying mail content for the domain %s which has no mailboxes
""")
SUBSCRIPTION_NOT_PRESENTED_ON_MAIL_SERVER = single_line_message("""
    Subscription '%s' is not presented on mail server, do not copy mail content
""")
UNABLE_COPY_MAIL_CONTENT_S_DOMAIN = single_line_message("""
    Unable to copy mail content on '%s' domain: mail service is disabled due to domain is disabled.
""")
MAILBOX_EMPTY_PASSWORD_EMAIL_S_SKIPPING = single_line_message("""
    Mailbox has empty password on E-mail %s, skipping it
""")
SUBSCRIPTION_HAS_NO_IP_ADDRESSES_TARGET = single_line_message("""
    Subscription '{subscription}' has no IP addresses on target system. DNS records won't be changed
""")
CREATE_RESELLER_IN_DESTINATION_PANEL_MAP = single_line_message("""
    Create this reseller in destination panel, or map client to some existing reseller or administrator
""")
CLIENT_IS_MAPPED_AN_UNEXISTING_RESELLER = single_line_message("""
    Client is mapped to an unexisting reseller '%s'
""")
CONVERT_CLIENTS_FROM_SOURCE_PANEL = single_line_message("""
    Convert clients from source panel
""")
CONVERT_RESELLERS_FROM_SOURCE_PANEL = single_line_message("""
    Convert resellers from source panel
""")
RESELLER_LOGIN_IS_PRESENTED_IN_MIGRATION = single_line_message("""
    Reseller '{login}' is presented in migration list, but is presented neither on the source panel, nor in the target
    panel.
""")
EITHER_REMOVE_DIFFERENCE_IF_BOTH_ACCOUNTS_1 = single_line_message("""
    Either remove the difference (if both accounts belong to the same reseller) or change the reseller's username (if
    these are the different resellers).
""")
NEW_PASSWORD_GENERATED_FOR_RESELLER_S = single_line_message("""
    A new password has been generated for the reseller '%s': '%s'. You can change the password after data transfer is
    finished.
""")
UNABLE_RETRIEVE_RESELLERS_PASSWORD_AS_IT = single_line_message("""
    Unable to retrieve the reseller's password as it is stored in the encrypted form
""")
CONVERT_RESELLERS_FROM_TARGET_PANEL = single_line_message("""
    Convert resellers from target panel
""")

CONVERTER_PLAN_ADMIN_NOT_EXISTS = single_line_message("""
    The administrator at the destination server does not have the hosting plan '{hosting_plan_name}'.
    In the same time the administrator does not have this hosting plan at the source servers as well,
    so unable to create it on the destination server automatically. Please do it manually.
""")
CONVERTER_PLAN_RESELLER_NOT_EXISTS = single_line_message("""
    The reseller '{reseller_username}' at the destination server does not have the hosting plan '{hosting_plan_name}'.
    In the same time the reseller '{reseller_username}' does not have this hosting plan at the source servers as well,
    so unable to create it on the destination server automatically. Please do it manually.
""")
CONVERTER_PLAN_EXISTS_TARGET = single_line_message("""
    Hosting plan '{hosting_plan_name}' already exists on the target panel
""")
CONVERTER_PLAN_EXISTS_SOURCE = single_line_message("""
    Hosting plan '{hosting_plan_name}' exists on source '{source_id}', it will be used
""")
CONVERTER_PLAN_EXISTS_SOURCE_MULTIPLE = single_line_message("""
    Hosting plan '{hosting_plan_name}' exists on several source panels. Source '{source_id}' will be used
""")

CONVERTER_PLAN_ADDON_ADMIN_NOT_EXISTS = single_line_message("""
    The administrator at the destination server does not have the hosting plan '{hosting_plan_name}'.
    In the same time the administrator does not have hosting plan '{hosting_plan_name}' at the source
    servers as well, so unable to create it on the destination server automatically. Check that hosting plan
    name '{hosting_plan_name}' specified in the migration list is correct.
""")
CONVERTER_PLAN_ADDON_RESELLER_NOT_EXISTS = single_line_message("""
    The reseller '{reseller_username}' at the destination server does not have the hosting plan '{hosting_plan_name}'.
    In the same time the reseller '{reseller_username}' does not have hosting plan '{hosting_plan_name}' at the
    source servers as well, so unable to create it on the destination server automatically. Check that hosting plan
    name '{hosting_plan_name}' specified in the migration list is correct.
""")
CONVERTER_PLAN_ADDON_EXISTS_TARGET = single_line_message("""
    Hosting plan '{hosting_plan_name}' already exists on the target panel
""")
CONVERTER_PLAN_ADDON_EXISTS_SOURCE = single_line_message("""
    Hosting plan '{hosting_plan_name}' exists on source '{source_id}', it will be used
""")
CONVERTER_PLAN_ADDON_EXISTS_SOURCE_MULTIPLE = single_line_message("""
    Hosting plan '{hosting_plan_name}' exists on several source panels. Source '{source_id}' will be used
""")

FIX_DOMAINS_CONFLICT = single_line_message("""
    Either change the conflicting names, or exclude this subscription from transfer using the migration list file.
""")
SAME_CUSTOMER_SOLUTION = single_line_message("""
    If these are the same customers, ignore that issue. If these are different customers, change login of one of them.
""")
FIX_SUBSCRIPTION_NAME_CONFLICT = single_line_message("""
    Either rename one of the subscriptions (if you want to transfer both of them) or exclude one of the subscriptions
    from the migration list file.
""")
CUSTOMER_WITH_USERNAME_EXISTS_FOR_SOURCE_AND_TARGET = multi_line_message("""
    A customer with the same username but different contact data already exists in the destination panel.
    The list of differences:
    %s
""")
CUSTOMER_WITH_USERNAME_EXISTS_FOR_SOURCES = multi_line_message("""
    A customer with the same username but different contact data already exists on another server.
    The list of differences:
    %s
""")
NEW_PASSWORD_GENERATED_FOR_CUSTOMER_S = single_line_message("""
    A new password has been generated for the customer '%s': '%s'. You can change the password after data transfer is
    finished.
""")
CONTACT_NAME_FIRST_NAME_LAST_NAME = single_line_message("""
    the Contact Name (First Name + Last Name) parameter of a customer in the destination panel: '%s', the contact name
    of the verified customer: '%s'
""")
UNABLE_RETRIEVE_CUSTOMERS_PASSWORD_AS_IT = single_line_message("""
    Unable to retrieve the customer's password as it is stored in the encrypted form
""")
NAME_S_S_IN_SUBSCRIPTION_CONFLICTS_3 = single_line_message("""
    The name of %s '%s' in this subscription conflicts with the name of %s '%s' which exists in subscription '%s' on the
    other server
""")
SUBSCRIPTION_ALREADY_EXISTS_ON_OTHER_SERVER_ISSUE = single_line_message("""
    A subscription '%s' (with or without the 'www' prefix) already exists on the other server '%s'
""")
SITE_CONFLICT_SOLUTION = single_line_message("""
    Either rename this subscription or the %s '%s' or exclude this subscription from transfer using the migration list
    file.
""")
NAME_S_S_IN_SUBSCRIPTION_CONFLICTS = single_line_message("""
    The name of the %s '%s' in this subscription conflicts with the name of destination panel webspace '%s'
""")
NAME_S_S_IN_SUBSCRIPTION_CONFLICTS_2 = single_line_message("""
    The name of %s '%s' in this subscription conflicts with the name of %s '%s' which already exists in a subscription
    '%s'
""")
NAME_S_S_IN_SUBSCRIPTION_CONFLICTS_1 = single_line_message("""
    The name of the %s '%s' in this subscription conflicts with the name of subscription '%s' which exists on the other
    server '%s'
""")
SITE_NAME_ALREADY_EXIST_ON_TARGET_ISSUE = single_line_message("""
    A %s '%s' (with or without the 'www' prefix) already exists on target within the '%s' subscription
""")
SITE_CONFLICT_TARGET_SOLUTION = single_line_message("""
    Either rename this subscription or the %s '%s' or exclude this subscription from transfer using the migration list
    file.
""")
SITE_NAME_ALREADY_EXIST_ON_SOURCE_ISSUE = single_line_message("""
    A %s '%s' (with or without the 'www' prefix) already exists on the other server within the '%s' subscription
""")
CONTACT_NAME_CUSTOMER_ANOTHER_SERVER_S = single_line_message("""
    the contact name of a customer on another server: '%s', the contact name of the checked customer: '%s'
""")
RESTORE_DATABASE_DUMP_TARGET_SERVER = single_line_message("""
    Restore database dump on target server
""")
SERVER_IS_NOT_PROPERLY_CONFIGURED_TARGET = multi_line_message("""
    {server} is not properly configured on target server: credentials (login or password) are not set.
    Please configure the server, then proceed with migration.
""")
COPY_DATABASE_DUMP_FROM_SOURCE_TARGET = single_line_message("""
    Copy database dump from source to target server with rsync
""")
MYSQL_CLIENT_BINARY_WAS_NOT_FOUND = multi_line_message("""
    mysql client binary was not found on %s, database '%s' of subscription will not be copied. Make sure that:
    1) MySQL is installed on the server
    2) MySQL 'bin' directory is added to PATH environment variable,
    so MySQL client can be simply started with 'mysql' command.
""")
DATABASE_UNSUPPORTED_TYPE_AND_HENCE_NOT = single_line_message("""
    Database has unsupported type and hence will not be copied
""")
PG_DUMP_UTILITY_IS_NOT_INSTALLED = multi_line_message("""
    'pg_dump' utility is not installed on '%s' server.
    Make sure that:
    1) All external PostgreSQL servers (other than Plesk servers) are specified in
    config.ini in 'external-postgresql-servers' option, and 'pg_dump' utility is
    installed on them.
    OR
    2) 'pg_dump' is installed on all servers that have domains with
    PostgreSQL databases. Once the problem is fixed, run 'copy-db-content'
    migration tool command to transfer only the databases.
""")
CANNOT_TRANSFER_DATABASE_OF_UNSUPPORTED_TYPE = single_line_message("""
    Cannot transfer a database with unsupported type '%s'
""")
PER_SUBSCRIPTION_MIGRATION_WAS_NOT_STARTED_YET = single_line_message("""
    Per-subscription migration was not started yet, common actions are executing
""")
SUBSCRIPTION_MIGRATION_STATUS = multi_line_message("""
    Subscription migration status:

""")
FAILED_REMOVE_BACKUP_FILE_FROM_TARGET = single_line_message("""
    Failed to remove backup file from target Plesk, exception:
""")
RESTORATION_SUBSCRIPTION_FAILED_RESTORATION_TASK_STOPPED = single_line_message("""
    Restoration of subscription failed: restoration task stopped. Check debug.log and PMM restoration logs for more
    details.
""")
RESTORATION_SUBSCRIPTION_FAILED_TIMED_OUT_WAITING = single_line_message("""
    Restoration of subscription failed: timed out waiting for the restore task. Check debug.log and PMM restoration logs
    for more details.
""")
RETRIEVING_RESTORATION_LOG_S = single_line_message("""
    Retrieving the restoration log "%s"
""")
RESTORATION_SUBSCRIPTION_FAILED_NO_TASK_ID = multi_line_message("""
    Restoration of hosting settings (addon domains, mailboxes, PHP settings, etc) failed:
    No task ID was returned by pmmcli.
    Check debug.log and PMM restoration logs for more details. Output of pmmcli utility:
    {output}
""")
RESTORATION_SUBSCRIPTION_FAILED_ERROR_CODE = multi_line_message("""
    Restoration of hosting settings (addon domains, mailboxes, PHP settings, etc) of subscription failed.
    Check PMM restoration logs for more details.
    Error code: {code}
    Error message: {message}
""")
EXCEPTION_WHILE_PARSING_XML = single_line_message("""
    Exception while parsing XML (most probably could be ignored):
""")
POLL_PLESK_FOR_RESTORATION_TASK_STATUS = single_line_message("""
    Poll Plesk for restoration task status, attempt #%s
""")
INITIALLY_WAIT_FOR_PMM_DEPLOYER_START = single_line_message("""
    Initially wait for PMM deployer to start
""")
WAITING_FOR_RESTORE_TASK_FINISH_CHECK = single_line_message("""
    Waiting for restore task to finish, check interval: %s seconds, maximum check attempts %s
""")
RESTORATION_SUBSCRIPTION_FAILED_NO_RESTORATION_STATUS = single_line_message("""
    Restoration of subscription failed: no restoration status log is available. Check debug.log and PMM restoration logs
    for more details
""")
WAITING_FOR_PLESK_RESTORE_TASK_FINISH = single_line_message("""
    Waiting for Plesk restore task to finish
""")
FAILED_TO_PERFORM_OPEARATION_ON_IIS_APP_POOL = single_line_message("""
    Failed to %s IIS dedicated application pool. Check debug log for more details.
""")
PROVIDED_CLIGATE_AUTH_IS_NOT_SUPPORTED = single_line_message("""
    Provided CLIGate auth is not supported
""")
UNABLE_GET_RSYNC_SOURCE_SERVER_OBJECT = single_line_message("""
    Unable to get rsync: source server object or source server IP should be specified
""")
ERROR_WHILE_COPYING_VIRTUAL_HOSTS_CONTENT = single_line_message("""
    Error while copying virtual host's content: virtual host's directory '%s' does not exist on source server '%s'
""")
CHANGE_FILE_PERMISSIONS_ACCORDING_USER_MAP = single_line_message("""
    Change file permissions according to user map
""")
SOURCE_DIRECTORY_DOES_NOT_EXIST = single_line_message("""
    Error while copying web files of subscription:
    file or directory '{path}' does not exist on source server '{server_ip}'
""")
CHANGE_FILE_PERMISSIONS_ACCORDING_GROUP_MAP = single_line_message("""
    Change file permissions according to group map
""")
UNABLE_OPEN_CHANNEL_SSH_CONNECTION_S = single_line_message("""
    Unable to open channel on SSH connection to '%s' or channel is suddenly closed
""")
SUCCESSFULLY_CONNECTED_S_BY_SSH = single_line_message("""
    Successfully connected to '%s' by SSH
""")
SSH_CONNECTION_S_WAS_UNEXPECTEDLY_CLOSED = single_line_message("""
    The SSH connection to %s was unexpectedly closed, reconnecting
""")
UNABLE_CONNECT_HOST_BY_SSH_EXCEPTION = multi_line_message("""
    Unable to connect to '{host}' by SSH: {exception}.
    Ensure that the server is up and there are no firewall rules that may block SSH connections to the server,
    then restart migration.
""")
SSH_CONNECTION_S_WAS_UNEXPECTEDLY_CLOSED_1 = single_line_message("""
    The SSH connection to %s was unexpectedly closed, reconnecting
""")
SHUTDOWN_WINDOWS_AGENT_AT_S = single_line_message("""
    Shutdown Windows agent at '%s'
""")
IS_FILE_INDICATING_THAT_SSL_CERTIFICATES = single_line_message("""
    This is a file indicating that SSL certificates and keys used by migration tools were generated successfully. Remove
    that file if you want to regenerate them.
""")
FAILED_DETECT_PLESK_DATA_DIRECTORY = single_line_message("""
    Failed to detect Plesk data directory
""")
PLESK_FOR_UNIX_CONFIGURATION_VARIABLE_S = single_line_message("""
    Plesk for Unix configuration variable '%s' has value '%s'
""")
FAILED_DETECT_PLESK_VIRTUAL_HOSTS_DIRECTORY = single_line_message("""
    Failed to detect Plesk virtual hosts directory
""")
UNABLE_RETRIEVE_CREDENTIALS_FOR_S_DATABASE = single_line_message("""
    Unable to retrieve credentials for %s database server with host %s via %s
""")
INCONSISTENCY_DATABASE_MULTIPLE_OWNERS = single_line_message("""
    Panel server '{server}' has inconsistency in its database. Customer's database '{db_name}' of type '{db_type}' on
    host '{db_host}' is owned by more than 1 webspace: {webspaces}
""")
INCONSISTENCY_DB_USER_MULTIPLE_OWNERS = single_line_message("""
    Panel server '{server}' has inconsistency in its database. Database user {db_user} of type '{db_type}' on host
    '{db_host}' is owned by more than 1 webspace: {webspaces}
""")
PLESK_VIRTUAL_HOSTS_DIRECTORY_IS_S = single_line_message("""
    Plesk virtual hosts directory is "%s"
""")
FAILED_DETECT_PLESK_BASE_DIRECTORY = single_line_message("""
    Failed to detect Plesk base directory
""")
INTERNAL_ERROR_TRYING_EXECUTE_COMMAND_THAT = single_line_message("""
    Internal error: trying to execute command that contains national symbols on Windows server. Command's Python repr
    is: %r.
""")
SSH_KEY_POOL_IS_READ_ONLY = single_line_message("""
    SSH key pool is read only as it was cleaned up
""")
INTERNAL_ERROR_FAILED_FIND_IMPORTED_BACKUP = single_line_message("""
    Internal error: failed to find imported backup for specified backup object. Probable reason is that backup was never
    imported to target panel's PMM repository
""")
FAILED_FIND_IMPORTED_BACKUP_XML_FILE = single_line_message("""
    Failed to find imported dump XML file for subscription. Most probable reason is that dump file is not valid
    or corrupted. To investigate the issue it is recommended to check debug log for errors
    happened during "pmmcli --import-file-as-dump" operation.
""")
RESTORE_HOSTING_SETTINGS_INFO = multi_line_message("""
    Use these files when investigating issues happened while restoring hosting settings of domain '{domain}':
    - Session directory of restoration: {session_dir}
    - Restore hosting settings log: {log_filename}
    - Restore hosting settings XML: {xml_filename}
""")
CHANGE_PERMISSIONS_ACCORDING_FOLLOWING_RULES_S = single_line_message("""
    Change permissions according to the following rules: %s
""")
PROFILING_RESULTS = single_line_message("""
    ***************** Profiling results *****************
""")
TOTAL_TIME_OUTSIDE_MIGRATOR_API_CALLS = single_line_message("""
    Total time outside Plesk Migrator (API calls, external command executions, waitings, ...): %s
""")
FAILED_DETECT_OS_INVALID_OUTPUT = single_line_message("""
    Failed to detect OS: invalid output '%s'
""")
EXCEPTION_WHEN_CLOSING_SOCKET = single_line_message("""
    Exception when closing socket:
""")
EXCEPTION_WHEN_TRYING_DEPLOY_AND_START_1 = single_line_message("""
    Exception when trying to deploy and start RPC Agent, most likely agent failed to deploy, print
    manual deploy instructions. Exception:
""")
RPC_AGENT_DEPLOY_ERROR_ON_VERSION_MISMATCH = single_line_message("""
    Exception when trying to redeploy and start RPC Agent (previously installed RPC
    agent is of incompatible version), most likely agent failed to deploy,
    print manual deploy instructions. Exception:
""")
DEPLOY_PANEL_MIGRATOR_TRANSFER_AGENT_AT = single_line_message("""
    Deploy RPC Agent at '%s'
""")
TRY_START_PANEL_MIGRATOR_TRANSFER_AGENT = single_line_message("""
    Try to start RPC Agent. If it was not deployed, this will fail
""")
TRY_STOP_PANEL_MIGRATOR_TRANSFER_AGENT = single_line_message("""
    Try to stop RPC Agent if it is already running, but is broken for some reason, or has different
    SSL keys
""")
RPC_PROXY_FAILED_CONNECTION = multi_line_message("""
    Failed to connect to '{remote_server}' through '{proxy_server}'.
    Make sure that:
    1. The RPC agent is running on the '{remote_server}' server.
    2. There are no firewalls that could block connections from '{proxy_server}' to '{remote_server}' by 10155
    and 10156 ports.
""")
RPC_PROXY_FAILED_CONNECTION_SSL_ISSUE = multi_line_message("""
    Failed to connect to '{remote_server}' through '{proxy_server}'.
    Most probably an old version of the RPC agent is running on the '{remote_server}'.
    Stop and remove the old version of the RPC agent, deploy the new version of the agent to the server,
    and restart migration.

    Reason: {reason}.
""")
SSL_IS_DISABLED_FOR_AGENT_AT = single_line_message("""
    SSL is disabled for agent at '%s'
""")
EXCEPTION_WHEN_TRYING_STOP_PANEL_MIGRATOR = single_line_message("""
    Exception when trying to stop RPC Agent, most likely it could be ignored:
""")
TRY_CONNECT_AGENT_AT_S = single_line_message("""
    Try to connect to agent at '%s'
""")
EXCEPTION_WHEN_TRYING_START_PANEL_MIGRATOR = single_line_message("""
    Exception when trying to start RPC Agent, most likely agent was not deployed, and the exception
    could be ignored:
""")
START_PANEL_MIGRATOR_TRANSFER_AGENT_AT = single_line_message("""
    Start RPC Agent at '%s'
""")
CONNECTION_FAILED_MOST_LIKELY_THAT_PANEL = single_line_message("""
    Connection failed, most likely that RPC Agent is not installed or running.
""")
EXCEPTION_WHEN_TRYING_DEPLOY_AND_START = single_line_message("""
    Exception when trying to deploy and start RPC Agent, most likely agent failed to deploy, print
    manual deploy instructions. Exception:
""")
PACK_AGENT_INTO_SELFEXTRACTABLE_ARCHIVE = single_line_message("""
    Pack agent into self-extractable archive
""")
DEPLOY_AND_START_PANEL_MIGRATOR_TRANSFER = single_line_message("""
    Deploy and start RPC Agent at '%s'
""")
UNIQUE_NAME_SUFFIX_IS_TOO_LONG = single_line_message("""
    Unique name suffix is too long
""")
UNABLE_GET_THIRDPARTIES_DIR_IT_IS = single_line_message("""
    Unable to get thirdparties dir: it is available on Windows only
""")
UNABLE_GET_PANEL_MIGRATOR_TRANSFER_AGENT = single_line_message("""
    Unable to get RPC Agent's directory: it is available on Windows only
""")
MODULE_DEFINES_PATH_MIGRATORS_THIRDPARY_UTILS = single_line_message("""
    This module defines path to Plesk Migrator's thirdparty utils for Windows
""")
PACK_DUMP_XML_INTO_DUMP_ARCHIVE = single_line_message("""
    Pack dump XML into dump archive
""")
RUN_PMM_AGENT_CREATE_DUMP_XML = single_line_message("""
    Run PMM agent to create dump XML
""")
RUN_PMM_AGENT_CREATE_SHALLOW_DUMP = single_line_message("""
    Run PMM agent to create shallow dump XML
""")
RUN_PMM_AGENT_CREATE_CAPABILITY_DUMP = single_line_message("""
    Run PMM agent to create capability dump XML
""")
UTILS_PMM_WINDOWS_AGENT_CREATE_MIGRATION_DUMP = single_line_message("""
    Creating migration dump '{dump_path}'
""")
UTILS_PMM_WINDOWS_AGENT_CREATE_CAPABILITY_DUMP = single_line_message("""
    Creating capability dump '{dump_path}'
""")
UTILS_PMM_WINDOWS_AGENT_CREATE_SHALLOW_DUMP = single_line_message("""
    Creating shallow migration dump '{dump_path}'
""")
DOWNLOADING_MIGRATION_DUMP_S = single_line_message("""
    Downloading migration dump '%s'
""")
UNABLE_USE_PANEL_MIGRATOR_AGENT_SERVER = multi_line_message("""
    Unable to use Panel Migrator Agent: {server} does not meet requirements.
    Please make sure that Microsoft .NET Framework version 4 is installed
""")
CONVERT_PLESK_DUMP_PLESK_FORMAT = single_line_message("""
    Convert Plesk 8 dump to Plesk 9 format.
""")
PLESK_8_DUMP_FILE_NOT_FOUND = single_line_message("""
    Plesk 8 dump archive file '{dump_archive}' was not found.
""")
ERROR_WHILE_PARSING_PLESK_RESTORE_XML = single_line_message("""
    Error while parsing Plesk restore XML
""")
REMOVE_BACKUP_FILE_FROM_TARGET = single_line_message("""
    Remove backup file %s from target Plesk
""")
IMPORT_BACKUP_TARGET_PANEL_PMM_REPOSITORY = single_line_message("""
    Import backup to target panel PMM repository.
""")
CHECK_THAT_COMMAND_LINE_OPTIONS_ARE = single_line_message("""
    Check that command line options are correct
""")
FAILED_CHECK_THAT_COMMAND_LINE_OPTIONS = single_line_message("""
    Failed to check that command line options are correct
""")
MIGRATION_LIST_FILE_NOT_EXIST = single_line_message("""
    Migration list file '%s' specified with --migration-list-file option does not exist. Check that correct path to
    migration list is specified.
""")
MIGRATION_LIST_FORMAT_INVALID= single_line_message("""
    Migration list file format '{value}' specified with --migration-list-format is invalid.
    Allowed values: {allowed_values}.
""")
IP_MAPPING_FILE_NOT_EXISTS = single_line_message("""
    IP mapping file '%s' specified with --ip-mapping-file option does not exist. Check that correct path to IP mapping
    file is specified.
""")
FAILED_SHUTDOWN_WINDOWS_RSYNC_SERVERS = single_line_message("""
    Failed to shutdown Windows rsync servers
""")
SHUTDOWN_WINDOWS_RSYNC_SERVERS = single_line_message("""
    Shutdown Windows rsync servers
""")
SERVICE_PLANS_SERVICE_TEMPLATES_IMPORT_IS = single_line_message("""
    Deployment of hoisting plans is not supported for current target panel. Create hosting plans manually
    before migration.
""")
FAILED_CHECK_IF_TARGET_PANEL_SUPPORTS = single_line_message("""
    Failed to check if target panel supports plans import
""")
CHECK_IF_TARGET_PANEL_SUPPORTS_PLANS = single_line_message("""
    Check if target panel supports plans import
""")
FAILED_CLOSE_SSH_CONNECTIONS = single_line_message("""
    Failed to close SSH connections
""")
PRINT_SUBSCRIPTION_MIGRATION_STATUS = single_line_message("""
    Print subscription migration status
""")
SUBSCRIPTION_MIGRATION_FINISHED_HERE_IS_STATUS = multi_line_message("""
    Subscription migration finished, here is a status:
""")
SUBSCRIPTION_POST_MIGRATION_REPORT_TITLE = multi_line_message("""
    Here are results of post-migration checks performed for the subscription:
""")
SUBSCRIPTION_MIGRATED_SUCCESSFULLY = single_line_message("""
    Subscription migrated successfully
""")
FAILED_PRINT_SUBSCRIPTION_MIGRATION_STATUS = single_line_message("""
    Failed to print subscription migration status
""")
FAILED_REMOVE_TEMPORARY_SSH_KEYS = single_line_message("""
    Failed to remove temporary SSH keys
""")
MIGRATION_LIST_FILE_EXISTS_OVERWRITE = single_line_message("""
    Migration list file '%s' already exists, overwrite it
""")
MIGRATION_LIST_FILE_EXISTS = single_line_message("""
    Migration list file '%s' already exists. To overwrite it, use --overwrite option
""")
FAILED_CHECK_IF_MIGRATION_LIST_FILE = single_line_message("""
    Failed to check if migration list file already exists
""")
CHECK_IF_MIGRATION_LIST_FILE_ALREADY = single_line_message("""
    Check if migration list file already exists
""")
FAILED_GENERATE_MIGRATION_LIST_FILE = single_line_message("""
    Failed to generate migration list file
""")
FAILED_WRITE_MIGRATION_LIST_FILE = single_line_message("""
    Failed to write migration list file
""")
MIGRATION_LIST_FILE_TEMPLATE_IS_SAVED = single_line_message("""
    Migration list file template is saved to '%s'
""")
BROWSING_SERVICE_TEMPLATES_WHICH_COULD_USED = single_line_message("""
    Browsing service templates which could be used for migration
""")
CHECKING_IF_WEBSPACES_EXIST_IN_TARGET = single_line_message("""
    Checking, if webspaces exist in the target panel
""")
FAILED_CHECK_IF_MIGRATION_LIST_FILE_1 = single_line_message("""
    Failed to check if migration list file exists
""")
CHECK_IF_MIGRATION_LIST_FILE_EXISTS = single_line_message("""
    Check if migration list file exists
""")
MIGRATION_LIST_IS_NOT_DEFINED = multi_line_message("""
    A migration list is not defined. Please either:
    (*) Put the correct migration list to '%s', or
    (*) Specify its location with "--migration-list-file" command-line option.

    The migration list defines the list of object (client accounts, domains) that should
    be transferred from the source server. To generate the migration list sample, run the following command:
    # %s generate-migration-list config.ini

    Please check the migration tool documentation for more details.
""")
RESTORE_OLD_APACHE_RESTART_INTERVAL_VALUE = single_line_message("""
    Restore old Apache restart interval value
""")
FAILED_RESTORE_OLD_APACHE_RESTART_INTERVAL = single_line_message("""
    Failed to restore the old Apache restart interval value: %s
""")
RESTORE_APACHE_RESTART_INTERVAL = single_line_message("""
    Restore Apache restart interval
""")
FORCE_APACHE_RESTART = single_line_message("""
    Force Apache restart
""")
FAILED_FIX_PERMISSIONS_FOR_VHOST_DIRECTORY = single_line_message("""
    Failed to fix permissions for vhost directory of subscription '%s'
""")
FIX_PERMISSIONS_FOR_VHOST_DIRECTORY = single_line_message("""
    Fix permissions for vhost directory
""")
RSYNC_FAILED_COPY_FILES_FROM_SOURCE = multi_line_message("""
    Rsync failed to copy files from the source (%s) to the target server (%s): %s
    This could happen because of a network connection issue.
    Retry copying the files with the help of the "copy-content" command.
""")
FILE_DIRECTORY_S_SUBSCRIPTION_S_DOES = single_line_message("""
    File or directory '%s' of subscription '%s' does not exist on source server %s, so it won't be transferred
""")
FAILED_COPY_WEB_FILES_FOR_SUBSCRIPTION = single_line_message("""
    Failed to copy web files for subscription '%s'
""")
COPY_WEB_FILES_FROM_WINDOWS_SERVERS = single_line_message("""
    Copy web files from Windows servers
""")
FAILED_COPY_WEB_FILES_FOR_SUBSCRIPTION_1 = single_line_message("""
    Failed to copy web files for subscription '%s'
""")
COPY_WEB_FILES_FROM_UNIX_SERVERS = single_line_message("""
    Copy web files from Unix servers
""")
FAILED_COPY_MAIL_CONTENT_OF_SUBSCRIPTION = single_line_message("""
    Failed to copy mail content of subscription. Most probably that happens because of a network-related issue. Please
    check network connections between source and target servers, then re-copy mail content with the help of
    'copy-mail-content' command
""")
FAILED_COPY_DATABASE_CONTENT_OF_SUBSCRIPTION = single_line_message("""
    Failed to copy database content of subscription. Most probably that happens because of a network-related issue.
    Please check network connections between source and target servers, then re-copy database content with the help of
    'copy-db-content' command
""")
EXTRACTING_FILES_FROM_BACKUP_S_S = single_line_message("""
    Extracting files from backup '%s' to '%s'
""")
FAILED_SAVE_CONVERTED_BACKUP_FILE = single_line_message("""
    Failed to save converted backup to file
""")
FAILED_CREATE_CONVERTED_BACKUPS = single_line_message("""
    Failed to create converted backups
""")
REMOVE_CONTENT_NODES_FROM_BACKUPS = single_line_message("""
    Remove content XML nodes from backups
""")
UNABLE_REMOVE_CONTENT_NODES_FROM_BACKUPS = single_line_message("""
    Unable to remove content XML nodes from backups
""")
FAILED_FIND_ACTION_S_AFTER_WHICH = single_line_message("""
    Failed to find action '%s' after which we should insert another action
""")
FAILED_FIND_ACTION_S_BEFORE_WHICH = single_line_message("""
    Failed to find action '%s' before which we should insert another action
""")
CONCRETE_IMPORT_CLIENTS_AND_SUBSCRIPTIONS_ACTIONS = single_line_message("""
    Concrete import clients and subscriptions actions are not defined for target panel '%s'
""")
IMPORT_CLIENTS_AND_SUBSCRIPTIONS = single_line_message("""
    Create clients and subscriptions on target panel
""")
FAILED_IMPORT_CLIENTS_AND_SUBSCRIPTIONS = single_line_message("""
    Failed to create clients and subscriptions on target panel
""")
PARALLEL_CREATION_SUBSCRIPTIONS_MAY_FAIL_ACQUIRE = single_line_message("""
    Parallel creation of subscriptions may fail, acquire lock
""")
RELEASE_LOCK_FOR_CREATION_SUBSCRIPTIONS_OPERATION = single_line_message("""
    Release lock for creation of subscriptions operation
""")
CREATE_CLIENT_S_OWNED_BY_ADMINISTRATOR = single_line_message("""
    Create client '%s' owned by administrator
""")
CREATE_CLIENT_S_OWNED_BY_RESELLER = single_line_message("""
    Create client '%s' owned by reseller '%s'
""")
FAILED_CREATE_CLIENT_IN_TARGET_PANEL = single_line_message("""
    Failed to create customer '{customer_username}' in target panel
""")
CREATE_CLIENTS_IN_TARGET_PANEL = single_line_message("""
    Create clients in target panel
""")
CLIENT_LOGIN_S_ALREADY_EXISTS_SKIP = single_line_message("""
    Client with login '%s' already exists, skip creating
""")
FAILED_CREATE_CLIENTS_TARGET_PANEL_MIGRATION = single_line_message("""
    Failed to create clients on target panel, migration can not proceed to the next steps
""")
INVALID_COMBINATION_MULTITHREADING_OPTIONS = single_line_message("""
    Invalid combination of multithreading options
""")
ANALYSING_HOSTING_OS_RESOURCE_USAGE_AND = single_line_message("""
    Analysing hosting OS resource usage and webspaces content
""")
FAILED_ANALYSE_MIGRATION_NODES = single_line_message("""
    Failed to analyse migration servers
""")
FAILED_RESTORE_HOSTING_SETTINGS_SUBSCRIPTION_S = single_line_message("""
    Failed to restore hosting settings of subscription '%s'
""")
RESTORE_HOSTING_SETTINGS_SUBSCRIPTION = single_line_message("""
    Restore hosting settings of subscription
""")
TRANSFER_CUSTOM_ERROR_DOCUMENTS_SITE_S = single_line_message("""
    Transfer custom error documents of site '%s' and its virtual directories
""")
SKIP_TRANSFER_CUSTOM_ERROR_DOCUMENTS_FOR = single_line_message("""
    Skip transfer custom error documents for site '%s' of subscription '%s' as is has no virtual hosting
""")
SKIP_TRANSFER_CUSTOM_ERROR_DOCUMENTS_FOR_SUBDOMAIN_ON_SUBFOLDER = single_line_message("""
    Skip transfer custom error documents for subdomain '{site}'
    which is subdomain on subfolder of subscription '{subscription}'.
    Custom error documents of that subdomain should be restored when restoring custom error documents of parent domain.
""")
RESTORE_ERROR_DOCUMENTS_VIRTUAL_DIRECTORY_S = single_line_message("""
    Restore error documents of virtual directory '%s'
""")
SKIP_TRANSFER_CUSTOM_ERROR_DOCUMENTS_TYPES = single_line_message("""
    Skip transfer custom error documents types for subscription '%s' as is has no virtual hosting
""")
TRANSFER_CUSTOM_ERROR_DOCUMENTS = single_line_message("""
    Transfer custom error documents
""")
RESTORE_ERROR_DOCUMENTS_VIRTUAL_HOSTS_ROOT = single_line_message("""
    Restore error documents of virtual host's root
""")
FAILED_TRANSFER_CUSTOM_ERROR_DOCUMENTS_FOR = single_line_message("""
    Failed to transfer custom error documents for subscription '%s'
""")
THERE_IS_NO_SYSTEM_USER_LOGIN = single_line_message("""
    There is no system user login in backup, skip changing
""")
THERE_IS_NO_SYSTEM_USER_LOGIN_1 = single_line_message("""
    There is no system user login on target system, skip changing
""")
UNABLE_RESTORE_ORIGINAL_USERNAME_S_FOR = single_line_message("""
    Unable to restore the original username ('%s') for the system user of the subscription %s: it does not conform to
    the target panel rules. For this reason, the subscription owner will not be able to log in to FTP under the original
    username.
""")
UNABLE_RESTORE_ORIGINAL_USERNAME_FOR_SYSTEM = single_line_message("""
    Unable to restore the original username for the system user of the subscription %s: a system user named %s is
    already present on target panel. For this reason, the subscription owner will not be able to log in to FTP under the
    original username.
""")
FAILED_RESTORE_LOGIN_SYSTEM_USER_FOR = single_line_message("""
    Failed to restore login of system user for subscription '%s'
""")
NOTIFY_SUBSCRIPTION_OWNER_NEW_FTP_USERNAME = single_line_message("""
    Notify the subscription owner of the new FTP username: %s. The subscription owner can change this username on target
    panel.
""")
RESTORE_LOGINS_SYSTEM_USERS_1 = single_line_message("""
    Restore logins of system users
""")
NOTIFY_SUBSCRIPTION_OWNER_NEW_FTP_USERNAME_1 = single_line_message("""
    Notify the subscription owner of the new FTP username: %s. The subscription owner can change this username on target
    panel.
""")
REMOVE_IMPORTED_BACKUP_DUMPS_FROM_TARGET = single_line_message("""
    Remove imported backup dumps from target panel's repository
""")
FAILED_REMOVE_IMPORTED_BACKUP_DUMPS_TARGET = single_line_message("""
    Failed to remove imported backup dumps to target panel's repository
""")
ACTION_CHECK_OLD_MYSQL_PASSWORDS_DESCRIPTION = single_line_message("""
    Check old MySQL passwords that could not be used on target MySQL servers
""")
ACTION_CHECK_OLD_MYSQL_PASSWORDS_FAILURE = single_line_message("""
    Failed to check old MySQL passwords that could not be used on target MySQL servers
""")
MYSQL_INSECURE_PASSWORDS_PROBLEM = multi_line_message("""
    Some MySQL database users on the source server have old password hashes,
    which are not supported by the target MySQL servers. So, these database users won't be able
    to login after migration, which could cause broken web sites.

    Here is a list of affected target MySQL servers, subscriptions and MySQL users:
    {servers_and_users}
""")
MYSQL_INSECURE_PASSWORDS_SOLUTION_UNIX = multi_line_message("""
    To resolve the issue:
    - Either disable 'secure_auth' option on the target MySQL servers with the help of server's configuration file
    (which is usually located at /etc/my.cnf) and restart the MySQL servers to allow old insecure password hashes.
    - Or perform migration and then reset passwords for these MySQL users on target server
    and accordingly reconfigure web sites and applications.

    Refer to https://dev.mysql.com/doc/refman/5.5/en/password-hashing.html for more details.
""")
MYSQL_INSECURE_PASSWORDS_SOLUTION_WINDOWS = multi_line_message("""
    To resolve the issue:
    - Either disable 'secure_auth' option on the target MySQL servers with the help of server's configuration file
    (which is usually located at %PLESK_DIR%\Databases\MySQL\data\my.ini) and restart the MySQL servers
    to allow old insecure password hashes.
    - Or perform migration and then reset passwords for these MySQL users on target server
    and accordingly reconfigure web sites and applications.

    Refer to https://dev.mysql.com/doc/refman/5.5/en/password-hashing.html for more details.
""")
MYSQL_SUBSCRIPTION_USERS = single_line_message("""
- Subscription '{subscription}': {users}
""")
FOLLOWING_SITES_SUBSCRIPTION_WERE_NOT_RESTORED = single_line_message("""
    The following sites of subscription were not restored - they do not exist on target panel: %s
""")
SUBSCRIPTION_WAS_NOT_RESTORED_IT_DOES = single_line_message("""
    Subscription was not restored: it does not exist on target panel
""")
CHECK_THAT_EACH_SITE_SUBSCRIPTION_WAS = single_line_message("""
    Check that each site of subscription was restored and exists in target panel
""")
FAILED_VERIFY_THAT_HOSTING_SETTINGS_WERE = single_line_message("""
    Failed to verify that hosting settings were restored for subscription '%s'
""")
VERIFY_THAT_HOSTING_SETTINGS_WERE_RESTORED = single_line_message("""
    Verify that hosting settings were restored
""")
CHECK_IF_SUBSCRIPTION_WAS_RESTORED_IT = single_line_message("""
    Check if subscription was restored: it should exist in target panel
""")
SKIP_TRANSFER_MIME_TYPES_FOR_SITE = single_line_message("""
    Skip transfer MIME types for site '%s' of subscription '%s' as it has no virtual hosting
""")
SKIP_TRANSFER_MIME_TYPES_FOR_SUBSCRIPTION = single_line_message("""
    Skip transfer MIME types for subscription '%s' as is has no virtual hosting
""")
SKIP_TRANSFER_MIME_TYPES_FOR_SUBDOMAIN_ON_SUBFOLDER = single_line_message("""
    Skip transfer MIME types for subdomain '{site}' which is subdomain on subfolder of subscription '{subscription}'.
    MIME types of that subdomain should be restored when restoring MIME types of parent domain.
""")
TRANSFER_MIME_TYPES_SITE_S_AND = single_line_message("""
    Transfer MIME types of site '%s' and its virtual directories
""")
TRANSFER_MIME_TYPES_FOR_SITES_SUBSCRIPTION = single_line_message("""
    Transfer MIME types for sites of subscription '%s'
""")
RESTORE_MIME_TYPES_VIRTUAL_HOSTS_ROOT = single_line_message("""
    Restore MIME types of virtual host's root
""")
FAILED_TRANSFER_MIME_TYPES_FOR_SUBSCRIPTION = single_line_message("""
    Failed to transfer MIME types for subscription '%s'
""")
RESTORE_MIME_TYPES_VIRTUAL_DIRECTORY_S = single_line_message("""
    Restore MIME types of virtual directory '%s'
""")
FAILED_IMPORT_BACKUP_DUMPS_TARGET_PANELS = single_line_message("""
    Failed to import backup dumps to target panel's repository
""")
IMPORT_BACKUP_DUMPS_TARGET_PANELS_REPOSITORY = single_line_message("""
    Import backup dumps to target panel's repository
""")
UPLOAD_BACKUP_DUMP_S_TARGET_NODE = single_line_message("""
    Upload backup dump '%s' to target server
""")
IMPORT_BACKUP_DUMP_TARGET_PANELS_REPOSITORY = single_line_message("""
    Import backup dump to target panel's repository
""")
CREATE_MAPPING_DOMAIN_NAME_BACKUP_XML = single_line_message("""
    Create mapping of domain name to backup XML file name
""")
TRANSFER_VIRTUAL_DIRECTORIES_SITE_S = single_line_message("""
    Transfer virtual directories of site '%s'
""")
FAILED_TRANSFER_VIRTUAL_DIRECTORIES_FOR_SUBSCRIPTION = single_line_message("""
    Failed to transfer virtual directories for subscription '%s'
""")
NO_VIRTUAL_DIRECTORIES_INFORMATION_FOR_SITE = single_line_message("""
    No virtual directories information for site '%s', won't transfer them
""")
SKIP_TRANSFER_VIRTUAL_DIRECTORIES_FOR_SUBSCRIPTION = single_line_message("""
    Skip transfer virtual directories for subscription '%s' as is has no virtual hosting
""")
SKIP_TRANSFER_VDIRS_FOR_NO_HOSTING = single_line_message("""
    Skip transfer virtual directories for site '%s' of subscription '%s' as is has no virtual hosting
""")
SKIP_TRANSFER_VDIRS_FOR_SUBDOMAIN_ON_SUBFOLDER = single_line_message("""
    Skip transfer virtual directories for subdomain '%s' which is subdomain on subfolder of subscription '%s'.
    Virtual directories of that subdomain should be restored when restoring virtual directories of parent domain.
""")
RESET_HOSTING_FOR_SUBSCRIPTIONS_WITHOUT_HOSTING = single_line_message("""
    Reset hosting for subscriptions without hosting
""")
FAILED_RESET_HOSTING_FOR_SUBSCRIPTIONS_WITHOUT = single_line_message("""
    Failed to reset hosting for subscriptions without hosting '%s'
""")
CHANGE_NONVALID_SYSTEM_USER_PASSWORD = single_line_message("""
    Change non-valid system user password
""")
SYSTEM_USER_S_TRANSFERRED_ANOTHER_PASSWORD = single_line_message("""
    The system user '%s' will be transferred with another password: '%s'. You can change the password for the
    corresponding system/FTP/web user on target panel once the content transfer is finished.
""")
PASSWORD_SYSTEM_USER_S_DOES_NOT = single_line_message("""
    Password of system user '%s' does not meet target panel's requirements.
""")
FAILED_CHANGE_NONVALID_SYSTEM_USER_PASSWORDS = single_line_message("""
    Failed to change non-valid system user passwords for subscription '%s'
""")
CHANGE_LOGINS_SYSTEM_USERS_IN_BACKUP = single_line_message("""
    Change logins of system users in backup
""")
FAILED_CHANGE_LOGIN_SYSTEM_USER_FOR = single_line_message("""
    Failed to change login of system user for subscription '%s'
""")
FAILED_RESTORE_SUBSCRIPTION_SYSTEM_USERS_LOGIN_1 = single_line_message("""
    Failed to restore subscription system user's login.
""")
REMOVE_DEFAULT_DATABASE_SERVER_FROM_BACKUP = single_line_message("""
    Remove default database server from backup
""")
FAILED_REMOVE_DEFAULT_DATABASE_SERVERS_FOR = single_line_message("""
    Failed to remove default database servers for subscription '%s'
""")
SUBSCRIPTION_S_WEBMAIL_THAT_DOES_NOT = single_line_message("""
    Subscription '%s' has webmail that is not supported by target panel, so it was changed to Horde.
""")
FAILED_CHANGE_WEBMAIL_FOR_SUBSCRIPTION_S = single_line_message("""
    Failed to change webmail for subscription '%s'
""")
CHANGE_WEBMAIL_FROM_OLD_WEBMAILS_HORDE = single_line_message("""
    Change webmail from old webmails to Horde
""")
REMOVE_DISABLED_MAILSYSTEM_WITHOUT_RESOURCE_IN = single_line_message("""
    Remove disabled mailsystem without resource in backup
""")
FAILED_REMOVE_DISABLED_MAILSYSTEM_FOR_SUBSCRIPTION = single_line_message("""
    Failed to remove disabled mailsystem for subscription '%s'
""")
SUBSCRIPTION_S_DISABLED_MAIL_AND_SERVICE = multi_line_message("""
    Subscription '%s' has disabled mail and service template does not have mail
    resource, so mailsystem XML node was removed.
""")
MAIL_USER_S_TRANSFERRED_ANOTHER_PASSWORD = single_line_message("""
    The mail user '%s' will be transferred with another password: '%s'.
""")
FAILED_CHANGE_SMARTERMAIL_PASSWORDS_FOR_SUBSCRIPTION = single_line_message("""
    Failed to change SmarterMail passwords for subscription '%s'
""")
PASSWORD_MAIL_USER_S_DOES_NOT = single_line_message("""
    Password of mail user '%s' does not meet Windows mail server requirements.
""")
CHANGE_SMARTERMAIL_PASSWORDS_IN_BACKUPS = single_line_message("""
    Change SmarterMail passwords in backups
""")
FAILED_CHANGE_CATCH_ALL_REDIRECT_FOR = single_line_message("""
    Failed to change catch all redirect for subscription '%s'
""")
CHANGE_SERVER_CATCHALL_REDIRECT_DISCART = single_line_message("""
    Change server catch-all redirect to discard
""")
REMOVE_RELATION_PLANS_AND_SUBSCRIPTIONS_FROM = single_line_message("""
    Remove relation of plans and subscriptions from backup
""")
FAILED_REMOVE_RELATION_PLANS_AND_SUBSCRIPTION = single_line_message("""
    Failed to remove relation of plans and subscription for '%s'
""")
FAILED_REMOVE_DOMAIN_KEYS_FOR_SUBSCRIPTION = single_line_message("""
    Failed to remove domain keys for subscription '%s'
""")
REMOVE_DOMAINS_KEYS_FROM_BACKUP = single_line_message("""
    Remove domains keys from backup
""")
FAILED_REMOVE_LIMITS_AND_PERMISSIONS_FOR = single_line_message("""
    Failed to remove limits and permissions for subscription '%s'
""")
REMOVE_LIMITS_AND_PERMISSIONS_FROM_BACKUP = single_line_message("""
    Remove limits and permissions from backup
""")
FAILED_REMAP_DATABASE_SERVERS_FOR_SUBSCRIPTION = single_line_message("""
    Failed to remap database servers for subscription '%s'
""")
CHANGE_DATABASE_SERVERS_IN_BACKUPS = single_line_message("""
    Change database servers in backups
""")
CHANGE_DATABASE_SERVER_LOCATION_FOR_DATABASE = single_line_message("""
    Change database server location for database users
""")
CHANGE_DATABASE_SERVER_LOCATION_FOR_DATABASES = single_line_message("""
    Change database server location for databases
""")
FAILED_SWITCH_PHP_ISAPI_PHP_FASTCGI = single_line_message("""
    Failed Switch PHP 5.3/ISAPI to PHP 5.3/FastCGI for Windows domains in backup for subscription '%s'
""")
SWITCH_PHP_ISAPI_PHP_FASTCGI_FOR = single_line_message("""
    Switch PHP 5.3/ISAPI to PHP 5.3/FastCGI for Windows domains in backup
""")
FAILED_REMOVE_EXTERNAL_IDS_FOR_SUBSCRIPTION = single_line_message("""
    Failed to remove External IDs for subscription '%s'
""")
REMOVE_EXTERNAL_IDS_FROM_BACKUP = single_line_message("""
    Remove subscriptions External ID from source dump
""")
FAILED_CONVERT_DNS_RECORDS_FOR_SUBSCRIPTION_2 = single_line_message("""
    Failed to convert DNS records for subscription '%s'
""")
ACTION_CHECK_DATABASE_CONFLICTS_DESCRIPTION = single_line_message("""
    Check database conflicts, when database or database user already exists but owned by another subscription
""")
ACTION_CHECK_DATABASE_CONFLICTS_FAILURE = single_line_message("""
    Failed to check database conflicts for subscription '%s'
""")
ACTION_CHECK_SERVICE_PLAN_ACCORDANCE_DESCRIPTION = single_line_message("""
    Check service plans accordance
""")
ACTION_CHECK_SERVICE_PLAN_ACCORDANCE_FAILURE = single_line_message("""
    Failed to check service plans accordance for subscription '%s'
""")
DATABASE_EXISTS_ISSUE = single_line_message("""
    Database '{db_name}' of type '{db_type}' of subscription can not be migrated: database with such name already exists
    on target server and is owned by another subscription '{target_owner_subscription}'
""")
DATABASE_EXISTS_SOLUTION = single_line_message("""
    Rename database either on source or on target to make database name unique. Other possible way is to migrate
    subscription to another database server (attach new external database server, specify it in service plan the
    subscription is assigned to)
""")
DATABASE_USER_EXISTS_ISSUE = single_line_message("""
    Database '{db_name}' of type '{db_type}' of subscription can not be migrated: database user of the database with
    name '{db_user}' already exists on target server and is owned by another subscription '{target_owner_subscription}'.
""")
DATABASE_USER_EXISTS_SOLUTION = single_line_message("""
    Migrating database in such situation may lead to invalid ownership of database tables. Rename database user on
    source or on target to make database user name unique. Other possible way is to migrate subscription to another
    database server (attach new external database server, specify it in service plan the subscription is assigned to)
""")
SERVICE_PLAN_ACCORDANCE_ISSUE = single_line_message("""
    Access over SSH is enabled for the subscription {subscription_name}, however, the service plan {plan_name} with
    which the subscription is associated does not allow access over SSH. For this reason, access to the subscription
    over SSH will be unavailable after migration. To resolve this, you need to either enable SSH access in the settings
    of the plan {plan_name}, or associate the subscription {subscription_name} to another plan.
""")
SERVICE_PLAN_ACCORDANCE_SOLUTION = single_line_message("""
    To resolve this, you need to either enable SSH access in the settings of the plan {plan_name}, or associate the
    subscription {subscription_name} to another plan.
""")
FAILED_CHECK_FOR_EMPTY_PASSWORDS_MAILBOXES = single_line_message("""
    Failed to check for empty passwords of mailboxes for subscription '%s'
""")
SET_PASSWORD_FOR_S_MAILUSER_SOURCE = single_line_message("""
    Set password for '%s' mailuser on source panel.
""")
CONTENT_CAN_NOT_MIGRATED_FOR_S = single_line_message("""
    Content can not be migrated for '%s' mailuser because of empty password of mailuser.
""")
CHECK_EMPTY_PASSWORDS_MAILBOXES = single_line_message("""
    Check empty passwords of mailboxes
""")
FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS = single_line_message("""
    Failed to check if source panel supports setting DNS timings
""")
SETTING_LOW_DNS_TIMINGS_IS_NOT = single_line_message("""
    Setting low DNS timings is not supported by this type of migration. Set them manually in the configurations of DNS
    zones, or just wait for about two TTL intervals when migrating.
""")
CHECK_IF_SOURCE_PANEL_SUPPORTS_SETTING = single_line_message("""
    Check if source panel supports setting DNS timings
""")
FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS_1 = single_line_message("""
    Failed to check if source panel supports DNS forwarding
""")
CHECK_IF_SOURCE_PANEL_SUPPORTS_DNS = single_line_message("""
    Check if source panel supports DNS forwarding
""")
DNS_FORWARDING_IS_NOT_SUPPORTED_FOR = single_line_message("""
    DNS forwarding is not supported for this type of migration.
    Switch IP addresses of DNS servers manually at registrar.
""")
FAILED_CHECK_IF_TARGET_PANEL_SUPPORTS_1 = single_line_message("""
    Failed to check if target panel supports DNS forwarding
""")
DNS_FORWARDING_IS_NOT_SUPPORTED_WHEN = multi_line_message("""
    DNS forwarding is not supported when migrating to Plesk.
    Switch IP addresses of DNS servers manually at registrar.
""")
CHECK_IF_TARGET_PANEL_SUPPORTS_DNS = single_line_message("""
    Check if target panel supports DNS forwarding
""")
CHECK_IF_SOURCE_PANEL_SUPPORTS_DNS_1 = single_line_message("""
    Check if source panel supports DNS forwarding
""")
FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS_2 = single_line_message("""
    Failed to check if source panel supports DNS forwarding
""")
DNS_FORWARDING_IS_NOT_SUPPORTED_FOR_1 = single_line_message("""
    DNS forwarding is not supported for this type of migration. Switch IP addresses of DNS servers manually at registrar.
""")
UNABLE_LOGIN_S_SSH_SERVICE_DUE = multi_line_message("""
    Unable to login to %s SSH service due to incorrect login/password specified in config file.
    Set valid credentials in 'ssh-username' and 'ssh-password' options in corresponding section in config file and
    re-run migration tool.
""")
CHECK_SSH_CONNECTION_FOR_S_SERVER = single_line_message("""
    Check SSH connection for %s server
""")
ALL_SSH_CONNECTIONS_WERE_ALREADY_CLOSED = single_line_message("""
    All SSH connections were already closed
""")
CLOSE_SSH_CONNECTION = single_line_message("""
    Close SSH connection to the %s
""")
SSH_CONNECTION_S_IS_ALREADY_OPENED = single_line_message("""
    SSH connection to the %s is already opened
""")
DOMAIN_NAME_S_NOT_FOUND = single_line_message("""
    Domain with name '%s' not found
""")
DOMAIN_NAME_S_NOT_FOUND_1 = single_line_message("""
    Domain with name '%s' not found
""")
OPENED_ZIP_FILE_FROM_FILEOBJECT = single_line_message("""
    Opened a zip file from a fileobject
""")
OPENED_TAR_FILE_FROM_FILEOBJECT = single_line_message("""
    Opened a tar file from a fileobject
""")
READING_DUMP_FROM_TAR_ARCHIVE_S = single_line_message("""
    Reading dump from a TAR archive %s
""")
READING_DUMP_FROM_ZIP_ARCHIVE_S = single_line_message("""
    Reading dump from a ZIP archive %s
""")
EXPECTED_HAVE_ONE_NO_DOMAINUSER_NODES = single_line_message("""
    Expected to have one or no domainuser XML nodes in Plesk backup XML for client '%s'
""")
DISCARD_PATH_R_AS_HAVING_UNKNOWN = single_line_message("""
    Discard path %r as having unknown type/purpose and being not needed.
""")
READING_DUMP_FROM_PLESK_BACKUP_FILE = single_line_message("""
    Reading dump from Plesk 8 backup file %s
""")
FAILED_FIND_SUBSCRIPTION_S_IN_BACKUP = single_line_message("""
    Failed to find subscription '%s' in backup file
""")
SAVING_FILEOBJECT_USING_S_FORMAT = single_line_message("""
    Saving a fileobject using %s format
""")
S_PLEASE_FIX_MIGRATION_TOOL_CONFIGURATION = single_line_message("""
    %s. Please fix migration tool configuration file ('%s') and run migration tool again.
""")
SHOW_HELP_INTERNAL_COMMANDS = single_line_message("""
    Show help on internal commands
""")
ADVANCED_COMMANDS_ARE_EXECUTED_AS_SEPARATE = single_line_message("""
    The advanced commands are executed as separate steps of the commands listed in the main section, but can be invoked
    separately for problem resolution or more granular migration process. Advanced commands:
""")
START_PYTHON_SCRIPT_IN_MIGRATOR_ENVIRONMENT = single_line_message("""
    Start Python script in Plesk Migrator's environment
""")
ERROR_OCCURRED_WHILE_WORKING_FOLLOWING_STRING = single_line_message("""
    Error occurred while working with the following string: %r
""")
INTERNAL_COMMANDS_ARE_INTENDED_USE_BY = single_line_message("""
    The internal commands are intended to use by migration tool developers. Internal commands:
""")
INTERNAL_MIGRATOR_ERROR_CAUSED_BY_UNICODE = single_line_message("""
    Internal Plesk Migrator error caused by unicode string processing: '%s', migration is aborted.
    See the traceback and the string that caused failure in debug log.
""")
SHOW_HELP_ADVANCED_COMMANDS = single_line_message("""
    Show help on advanced commands
""")
INTERNAL_MIGRATOR_ERROR_S_MIGRATION_IS = single_line_message("""
    Internal Plesk Migrator error: '%s', migration is aborted. See the traceback in debug log for more information.
""")
MIGRATION_STOPPED_BY_USER_REQUEST = single_line_message("""
    Migration stopped by user request
""")
START_PYTHON_INTERPRETER_IN_MIGRATOR_ENVIRONMENT = single_line_message("""
    Start Python interpreter in Plesk Migrator's environment
""")
AVAILABLE_VARIABLES_MIGRATOR_OPTIONS = single_line_message("""
    Available variables: migrator, options.
""")
FAILED_READ_CONFIGURATION_FILE_THERE_IS = single_line_message("""
    Failed to read configuration file: there is no section '[%s]'. Please fix migration tool configuration file ('%s')
    and run migration tool again.
""")
IGNORE_PREMIGRATION_ERRORS_AND_CONTINUE_MIGRATION = single_line_message("""
    Ignore pre-migration errors and continue migration even if there are some of them. Do not use it, it is left for use
    by support only.
""")
CLI_OPTION_SKIP_COPY_WEB_CONTENT = single_line_message("""
    Do not copy web files
""")
CLI_OPTION_SKIP_COPY_MAIL_CONTENT = single_line_message("""
    Do not copy mail messages
""")
CLI_OPTION_SKIP_COPY_DB_CONTENT = single_line_message("""
    Do not copy content of databases
""")
CLI_OPTION_SKIP_TEST_SITES = single_line_message("""
    Do not perform testing of web sites
""")
CLI_OPTION_SKIP_TEST_MAIL = single_line_message("""
    Do not perform testing of mail
""")
CLI_OPTION_SKIP_TEST_DATABASES = single_line_message("""
    Do not perform testing of databases
""")
CLI_OPTION_SKIP_TEST_DNS = single_line_message("""
    Do not perform testing of DNS
""")
CLI_OPTION_SKIP_TEST_USERS = single_line_message("""
    Do not perform testing of users
""")
SWITCH_STRICT_MODE_IN_WHICH_NEW = single_line_message("""
    Switch to the strict mode in which new webspaces are created using only the resources required for the transfer of
    the corresponding subscriptions.
""")
DO_NOT_CHECK_ANY_LICENSES_ON_TARGET = single_line_message("""
    Do not check any licenses on target servers
""")
COMMAND_TEST_SERVICES = single_line_message("""
    Check that services are working correctly.
""")
DO_NOT_CHECK_SERVICES_FOR_ANY = single_line_message("""
    Do not check services for any issues that may affect migration
""")
FORCE_FETCHING_DATA_FROM_SOURCE_PANELS = single_line_message("""
    Force fetching data from source panels, do not use already fetched data.
""")
COMMAND_CHECK_TARGET_PANEL_LICENSES = single_line_message("""
    Check target panel licenses
""")
COMMAND_CHECK_ADMINISTRATOR_ACCOUNT = single_line_message("""
    Check that specified target server account is build-in Windows administrator
""")
COMMAND_FETCH_SOURCE = single_line_message("""
    Download configuration data from source Plesk servers
""")
COMMAND_TRANSFER_WPB = single_line_message("""
    Transfer Web Presense Builder sites
""")
COPY_HOSTING_CONTENT_DESTINATION_SERVERS = single_line_message("""
    Copy hosting content to destination servers
""")
IMPORT_RESELLERS_NOTE_THAT_ONLY_CONTACT = single_line_message("""
    Import resellers. Note that only contact data is imported, and you should assign resellers to resellers plans
    manually
""")
COMMAND_UNDO_DNS_FORWARDING = single_line_message("""
    Undo DNS forwarding on all source Plesk servers
""")
COMMAND_SET_EXTERNAL_ID = single_line_message("""
    Set External ID
""")
COMMAND_RESTORE_STATUS = single_line_message("""
    Restore suspended status for the subscriptions, which were suspended in the originating system
""")
DO_NOT_CHECK_THAT_DNS_QUERIES = single_line_message("""
    Do not check that DNS queries for the transferred domains are correctly forwarded to target DNS servers
""")
SET_LOW_DNS_TIMING_VALUES_TTL = single_line_message("""
    Set low DNS timing values (TTL, refresh, retry, etc). This operation should be done in advance to insure quick
    transition to the new DNS server. Low DNS timing values are set for all domains on source Plesk servers.
""")
DO_NOT_USE_RELOAD_SOURCE_DATA = single_line_message("""
    Do not use reload source data if it was already fetched.
""")
COMMAND_VERIFY_HOSTING = single_line_message("""
    Verify that subscriptions, domains and hosting settings were restored
""")
COMMAND_TEST_USERS = single_line_message("""
    Check that system users are transferred correctly (access by FTP, SSH and RDP is checked).
""")
GENERATE_MIGRATION_LIST_FILE_FILE_COULD = single_line_message("""
    Generate migration list file. This file could be used to migrate only a specified set of plans and subscriptions,
    and to map subscriptions to plans. Comment out all objects that you don't want to be migrated
""")
COMMAND_RESTORE_HOSTING = single_line_message("""
    Configure original hosting settings from source panel on target panel
""")
MIGRATION_LIST_FILENAME_DEFAULT_VALUE_IS = single_line_message("""
    Migration list filename, default value is $session_dir/migration-list
""")
IGNORE_MIGRATION_LIST_ERRORS = single_line_message("""
    Ignore migration list errors and proceed with migration
""")
COMMAND_CHECK_INFRASTRUCTURE = single_line_message("""
    Check infrastructure (connections between servers, disk space requirements) for common issues that
    can make copy web, mail or database content stages to fail
""")
MIGRATOR_HELP_TITLE = single_line_message("""
    Plesk Migrator
""")
IP_MAPPING_FILENAME_FILE_CONTAINS_SOURCE = single_line_message("""
    IP mapping filename. This file contains source IP to target IP mapping.
""")
COMMAND_CONVERT = single_line_message("""
    Convert source data files to target panel format
""")
SOURCE_TYPE_NOT_SUPPORTED = single_line_message("""
    Source type '{source_type}' specified in 'source-type' option of '[GLOBAL]' section of configuration file is not
    supported. Supported types: {supported_types}
""")
TARGET_TYPE_NOT_SUPPORTED = single_line_message("""
    Target type '{target_type}' specified in 'target-type' option of '[GLOBAL]' section of configuration file is not
    supported. Supported types: {supported_types}
""")
COMMAND_TEST_DATABASES = single_line_message("""
    Check that the database service works fine for transferred domains.
""")
DO_NOT_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Do not check disk space requirements for the main server
""")
COMMAND_LIST_OPTIONS = single_line_message("""
    Return list of available options
""")
COMMAND_TEST_DNS = single_line_message("""
    Check that the DNS queries for transferred domains' records are ok.
""")
COMMAND_TEST_MAIL = single_line_message("""
    Check that the mail service works fine for transferred domains: check login to all transferred mailboxes by IMAP and
    SMTP.
""")
COMMAND_CONVERT_HOSTING_SETTINGS = single_line_message("""
    Convert source hosting settings according to target subscription settings
""")
DO_NOT_CHECK_INFRASTRUCTURE_FOR_ANY = single_line_message("""
    Do not check infrastructure for any issues that may affect migration
""")
COMMAND_TEST_ALL = single_line_message("""
    Check that the transferred domains are working correctly: test web sites, DNS, mail and FTP
""")
ACTION_TEST_SITES_DESCRIPTION = single_line_message("""
    Check that the transferred web sites are working correctly
""")
ACTION_TEST_SITES_FAILURE = single_line_message("""
    Failed to test that the transferred web sites are working correctly
""")
OVERWRITE_FILE_IF_IT_ALREADY_EXISTS = single_line_message("""
    Overwrite file if it already exists
""")
COMMAND_TEST_SITES = single_line_message("""
    Check that the web sites of the transferred domains are working correctly.
""")
COMMAND_UNPACK_BACKUPS = single_line_message("""
    Unpack all Plesk backups to $session_dir/unpacked directory
""")
COMMAND_PACK_BACKUPS = single_line_message("""
    Pack Plesk backups from $session_dir/unpacked directory to archives
""")
CHECK_FOR_POTENTIAL_MIGRATION_ISSUES = single_line_message("""
    Check for potential migration issues
""")
COMMAND_CHECK_MAIN_NODE_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Check main server's disk space requirements
""")
FAILED_TO_DETECT_ARCH = multi_line_message("""
    Failed to detect OS architecture for {server}. Assuming 64-bit.
    Reason: {reason}
""")
LOG_NO_NEED_TO_COPY_MAILCONTENT_BECAUSE_DISABLED_BY_USER = single_line_message("""
    Mail content migration for subscription '%s' is disabled by user
""")
LOG_NO_NEED_TO_COPY_MAILCONTENT_BECAUSE_OF_ASSIMILATION = single_line_message("""
    Mail server of subscription '%s' is migrated in assimilate mode, no need to copy mail content
""")
LOG_NO_NEED_TO_COPY_WEBCONTENT_BECAUSE_DISABLED_BY_USER = single_line_message("""
    Web content migration for subscription '%s' is disabled by user
""")
LOG_NO_NEED_TO_COPY_DB_CONTENT_BECAUSE_DISABLED_BY_USER = single_line_message("""
    Database content migration for subscription '%s' is disabled by user
""")
OPTION_ASYNC_HELP = single_line_message("""
    Run command asynchronously
""")
OPTION_QUIET_HELP = single_line_message("""
    Do not display log entries in console output
""")
OPTION_SKIP_PROFILING_HELP = single_line_message("""
    Do not write profiler report
""")
OPTION_DEBUG_HELP = single_line_message("""
    Increase debug level
""")
DISABLE_HIGH_LOG_PRIORITY = single_line_message("""
    Please change value of '{option_name}' option in {section_name} section in '{file_name}' file
    on {server_name} to '0'. If you want to debug Plesk panel and run migration tool
    specify 'skip-log-priority-check' option in [GLOBAL] section of config file of migration tool,
    but migration tool can hang in this case.
""")
CHANGE_MAIL_IPS_IN_BACKUP = single_line_message("""
    Change mail IP addresses in backup
""")
FAILED_TO_CHANGE_MAIL_IPS_IN_BACKUP = single_line_message("""
    Failed to change mail IP addresses in backup
""")
CHANGE_SUBSCRIPTION_DOCROOT_ACTION_DESCRIPTION = single_line_message("""
    Change document root of subscription in backup
""")
CHANGE_SUBSCRIPTION_DOCROOT_ACTION_FAILURE = single_line_message("""
    Failed to change document root of subscription in backup
""")
LOG_MAIL_IPS_SET_TO = single_line_message("""
    Subscription '{subscription_name}' mail IPs are set to ({ipv4}, {ipv6}).
""")
CHANGE_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
    Change web IP addresses in backup for subscription with virtual hosting
""")
FAILED_TO_CHANGE_VHOSTING_SUBSCRIPTION_WEB_IP_IN_BACKUP = single_line_message("""
    Failed to change web IP addresses in backup for subscription with virtual hosting
""")
LOG_WEB_IPS_SET_TO = single_line_message("""
    Subscription '{subscription_name}' web IPs are set to ({ipv4}, {ipv6})
""")
RESYNC_CONTENT = single_line_message("""
    Run content synchronization once migration is finished
""")
RUN_POST_MIGRATION_CHECKS = single_line_message("""
    Run post migration checks once migration is finished
""")
TEST_ALL_AFTER_TRANSFER_ACTION_DESCRIPTION = single_line_message("""
    Check that the services and transferred domains are working correctly
""")
TEST_ALL_AFTER_TRANSFER_ACTION_FAILURE = single_line_message("""
    Failed to check that the services and transferred domains are working correctly
""")
PRINT_POST_MIGRATION_REPORT_ACTION_DESCRIPTION = single_line_message("""
    Print post migration check report
""")
PRINT_POST_MIGRATION_REPORT_ACTION_FAILURE = single_line_message("""
    Failed to print post migration check report
""")
PRINT_SUBSCRIPTION_POST_MIGRATION_REPORT_ACTION_DESCRIPTION = single_line_message("""
    Print post migration check report of subscription
""")
PRINT_SUBSCRIPTION_POST_MIGRATION_REPORT_ACTION_FAILURE = single_line_message("""
    Failed to print post migration check report of subscription
""")
SKIP_CAPABILITY_CHECKS_OPTION = single_line_message("""
    Do not perform capability checks for target panel
""")
SKIP_REMOTE_MSSQL_CHECKS_OPTION = single_line_message("""
    Do not perform check of connection to remote MSSQL servers
""")
COMMAND_LIST_IP_ADDRESSES = single_line_message("""
    List IP addresses involved into migration process
""")
LIST_IP_ADDRESSES_ACTION_DESCRIPTION = single_line_message("""
    List IP addresses
""")
LIST_IP_ADDRESSES_ACTION_FAILURE = single_line_message("""
    Failed to list IP addresses
""")
REMOVE_SUBSCRIPTIONS_ACTION_DESCRIPTION = single_line_message("""
    Remove subscriptions from the target server
""")
REMOVE_SUBSCRIPTIONS_ACTION_FAILURE = single_line_message("""
    Failed to remove subscriptions from the target server
""")
IP_ADDRESSES_LIST_SAVED_TO = single_line_message("""
    IP addresses list was saved to '{filename}'
""")
SKIP_IP_MAPPING_CHECKS = single_line_message("""
    Skip IP mapping checks. No issues related to IP address mapping will be reported.
""")
LOG_CHECK_SOURCE_PLESK_API = single_line_message("""
    Check Plesk API connection to {server}
""")
FAILED_TO_CONNECT_BY_PLESK_API = single_line_message("""
    Failed to connect to {server} by Plesk API: {error}
""")
FAILED_TO_CHECK_PLESK_API_CONNECTION = single_line_message("""
    Failed to check Plesk API connection to {server}: {error}
""")
FAILED_TO_CHECK_PLESK_API_INVALID_CREDENTIALS = single_line_message("""
    Unable to login to Plesk API service of {server} due to incorrect login/password specified in config file.
    Set valid credentials in 'panel-username' and 'panel-password' options
    in corresponding section in config file and re-run migration tool.
""")
FAILED_TO_CHECK_PLESK_API_EXPIRED_LICENSE = single_line_message("""
    The license key has expired on {server}.
    To continue with migration, you need to install a valid license key, and then restart migration.
""")
WINDOWS_FAILED_TO_EXECUTE_REMOTE_COMMAND = single_line_message(r"""
    Failed to execute remote command on '{server_ip}' server. Check debug log
    (usually at "%SYSTEMDRIVE%\panel-migrator\rpc-agent\debug.log") for more details.
""")
WINDOWS_AGENT_INSTALL_INSTRUCTIONS = multi_line_message("""
    Panel Migrator failed to start RPC Agent on '{source_ip}' server.
    RPC Agent is required for communication between current server and '{source_ip}' server

    First, check that Windows Administrator's credentials specified for the server are correct.

    If they are correct, it is very likely that File and Printer Sharing service is disabled on the remote server,
    so automatic start of agent is not possible.

    To start it manually, upload '{dist}' file to the {source_ip} server and run it there.
""")
WINDOWS_AGENT_INSTALL_INSTRUCTIONS_VERSION_MISMATCH = multi_line_message("""
    RPC agent installed on '{source_ip}' server has version incompatible with Plesk Migrator.
    Panel Migrator tried to deploy new version of RPC agent, but failed to start it.

    RPC Agent is required for communication between current server and '{source_ip}' server

    First, check that Windows Administrator's credentials specified for the server are correct.

    If they are correct, it is very likely that File and Printer Sharing service is disabled on the remote server,
    so automatic start of agent is not possible.

    To start it manually, upload '{dist}' file to the {source_ip} server and run it there.
""")
DEBUG_RPC_AGENT_VERSION_MISMATCH = single_line_message("""
    RPC agent installed on server '{source_ip}' has version incompatible with Plesk Migrator.
    Try to deploy new version of RPC agent.
""")
DEBUG_GET_RPC_AGENT_VERSION = single_line_message("""
    Get RPC agent version on server '{source_ip}'
""")
DEBUG_RPC_AGENT_VERSION = single_line_message("""
    RPC agent version on server '{source_ip}': {version}
""")
DEBUG_RPC_AGENT_VERSION_UNKNOWN = single_line_message("""
    RPC agent version on server '{source_ip}' in unknown: most probably it is < 1.9.
    Exception below in the log could be ignored.
""")
DEBUG_FILE_TRANSFER_PROGRESS = multi_line_message("""
    Transferred {percentage} of '{remote_filename}' to '{local_filename}': {bytes_human_readable} ({bytes} bytes).
    Average speed for the last {interval} seconds: {speed_human_readable}/second ({speed} bytes/second).
""")
WINDOWS_AGENT_CONNECTION_ISSUE = multi_line_message(r"""
    Panel Migrator failed to connect to RPC Agent running on '{source_ip}' server.
    RPC Agent is required for communication between current server and '{source_ip}' server

    1. Check that there are no firewall rules blocking connections to {port} port on {source_ip} from that server.
    Make sure you could connect to the source server by {port} port with "telnet" utility running on that server.
    2. Check that agent is running on the source server (panel-migrator-rpc-agent.exe process)
    and listening on {port} port. If it does not, try to start 'panel-migrator-rpc-agent.exe',
    which is usually installed to "%SYSTEMDRIVE%\panel-migrator\rpc-agent\". If it is still not running -
    investigate debug.log and info.log files on {source_ip} server
    (which are usually located at"%SYSTEMDRIVE%\panel-migrator\rpc-agent\ directory).
""")
WINDOWS_AGENT_VERSION_MISMATCH = multi_line_message(r"""
    RPC Agent running on '{hostname}' server has version that is not compatible
    with the current version of Plesk Migrator.
    RPC Agent is required for communication between current server and '{hostname}' server.

    Stop previous version of RPC agent, upload the new version '{dist}' to the '{hostname}' server and run it there.
""")
WINDOWS_AGENT_POOL_GET_AUTO = single_line_message("""
    Perform automatic deployment of RPC agent on server '{source_ip}'
""")
WINDOWS_AGENT_POOL_GET_AUTO_PROXY = single_line_message("""
    Perform connection with RPC agent installed manually on server '{source_ip}'
    via proxy RPC agent '{proxy_ip}' installed automatically
""")
WINDOWS_AGENT_POOL_GET_MANUAL = single_line_message("""
    Perform connection with RPC agent installed manually on server '{source_ip}'
""")
WINDOWS_AGENT_POOL_GET_MANUAL_PROXY = single_line_message("""
    Perform connection with RPC agent installed manually on server '{source_ip}'
    via proxy RPC agent '{proxy_ip}' installed manually
""")
INVALID_OPTION_VALUE = single_line_message("""
    Invalid value for '{option_name}' option: '{specified_value}'. Please specify one of: {allowed_values}
""")
SECTION_DOES_NOT_EXIST = single_line_message("""
    Section '{section}' specified in '{option}' option does not exist in config
""")
MSSQL_DATABASE_NATIVE_DUMP_NO_PHYSICAL_ACCESS = single_line_message("""
    Unable to migrate MSSQL database '%s' using native MSSQL backups: there is no direct access
    to the server with MSSQL server: {server}. Provide access to it with the help of
    'external-db-servers' option in configuration file and run copy database content again.
""")
CANNOT_GET_OS_TYPE_FOR_EXTERNAL_DB_SERVER = single_line_message("""
    Plesk Migrator can not get OS type for external database server.
""")
FAILED_RESTORE_SECURITY_POLICY_SOME_TARGET = multi_line_message("""
    Failed to restore security policy on some of target servers: %s
    Restore 'PasswordComplexity' value with help of 'secedit' utility manually
    on all target Windows servers involved into migration.
""")
FAILED_RESTORE_SECURITY_POLICY_TARGET_NODE = multi_line_message("""
    Failed to restore security policy on target server %s: %s
    Restore 'PasswordComplexity' value with help of 'secedit' utility manually on the server
""")
ACTION_CREATE_CONVERTED_BACKUPS = single_line_message("""
    Create converted backups
""")
ACTION_SAVE_CONVERTED_BACKUPS = single_line_message("""
    Save converted backup to file
""")
ACTION_UNPACK_BACKUPS = single_line_message("""
    Unpack backups
""")
FAILED_TO_UNPACK_BACKUPS = single_line_message("""
    Failed to unpack backups
""")
ACTION_PACK_BACKUPS = single_line_message("""
    Pack backups
""")
FAILED_TO_PACK_BACKUPS = single_line_message("""
    Failed to pack backups
""")
FAILED_TO_PERFORM_ACTION = single_line_message("""
    Failed to perform action: {action_description}
""")
ACTION_COPY_DATABASE_CONTENT = single_line_message("""
    Copy databases
""")
ACTION_COPY_MAIL = single_line_message("""
    Copy mail messages
""")
DEBUG_COPY_WEB_FILES = single_line_message("""
    Copy the following web files: %r
""")
UNSUPPORTED_SOURCE_WEB_PATH_TYPE = single_line_message("""
    Unsupported source web path type
""")
SOURCE_WEB_PATH_ERROR_NO_RSYNC_SHARE = single_line_message("""
    Unable to copy '{absolute_path}' from {server_description}: access to this path is not allowed in rsync config
""")
SOURCE_WEB_PATH_ERROR_NO_VHOST = single_line_message("""
    Unable to retrieve absolute path for '{relative_path}' on {server_description}: base vhost directory not specified
""")
UNSUPPORTED_TARGET_WEB_PATH_TYPE = single_line_message("""
    Unsupported target web path type
""")
ACTION_CONVERT_DNS_RECORDS = single_line_message("""
    Convert DNS records
""")
DUPLICATE_DNS_RECORD_REMOVED = single_line_message("""
    Duplicate DNS record '{record}' was removed from DNS zone of domain '{domain}'
""")
DEBUG_MAPPING_XML_FILES = single_line_message("""
    Mapping of backup XML files: %r
""")
ACTION_GENERATE_MIGRATION_LIST = single_line_message("""
    Generate migration list file
""")
ACTION_WRITE_MIGRATION_LIST_FILE = single_line_message("""
    Write migration list file
""")

ACTION_DEPLOY_EXTENSIONS_NOT_SUPPORTED = single_line_message("""
    Check if target panel support deployment of Plesk extensions
""")
ACTION_DEPLOY_EXTENSIONS_NOT_SUPPORTED_FAILED = single_line_message("""
    Failed to check if target panel support deployment of Plesk extensions
""")
ACTION_DEPLOY_EXTENSIONS_NOT_SUPPORTED_MESSAGE = single_line_message("""
    Deployment of Plesk extensions is not supported for current target panel
""")

ACTION_DEPLOY_RESELLERS = single_line_message("""
    Deploy resellers
""")
ACTION_DEPLOY_RESELLERS_FAILED = single_line_message("""
    Failed to deploy resellers
""")
ACTION_DEPLOY_RESELLERS_RESELLER_FAILED = single_line_message("""
    Failed to deploy reseller '{reseller_username}'
""")
ACTION_DEPLOY_RESELLERS_RESELLER_CREATE = single_line_message("""
    Create reseller '{reseller_username}'
""")
ACTION_DEPLOY_RESELLERS_RESELLER_EXISTS = single_line_message("""
    Reseller '{reseller_username}' already exists, so skip it
""")

ACTION_DEPLOY_RESELLERS_PRINT_SUMMATY = single_line_message("""
    Print resellers migration status
""")
ACTION_DEPLOY_RESELLERS_PRINT_SUMMATY_FAILED = single_line_message("""
    Failed to print resellers migration status
""")

ACTION_RESTORE_AUX_USER_ROLES = single_line_message("""
    Deploy auxiliary user roles
""")
ACTION_RESTORE_AUX_USER_ROLES_FAILED = single_line_message("""
    Failed to deploy auxiliary user roles
""")
ACTION_RESTORE_AUX_USER_ROLES_CREATE = single_line_message("""
    Create auxiliary user role '{panel_user_role_name}' for {owner_username}
""")
ACTION_RESTORE_AUX_USER_ROLES_CREATE_FAILED = single_line_message("""
    Failed to create auxiliary user role, see debug log for details
""")
ACTION_RESTORE_AUX_USER_ROLES_SKIP_EXISTING = single_line_message("""
    Auxiliary user role '{panel_user_role_name}' for '{owner_username}' already exist, so skip it
""")
ACTION_RESTORE_AUX_USERS = single_line_message("""
    Deploy auxiliary users
""")
ACTION_RESTORE_AUX_USERS_SKIP_EXISTING = single_line_message("""
    Auxiliary user '{panel_user_username}' for '{owner_username}' already exist, so skip it
""")
ACTION_RESTORE_AUX_USERS_SKIP_EMPTY_PASSWORD = single_line_message("""
    Creation of auxiliary user '{panel_user_username}' for {owner_username} skipped,
    as it is not active and does not have password
""")
ACTION_RESTORE_AUX_USER_CREATE = single_line_message("""
    Create auxiliary user '{panel_user_username}' for {owner_username}
""")
ACTION_RESTORE_AUX_USER_CREATE_FAILED = single_line_message("""
    Failed to create auxiliary user on target panel.
    After migration customer won't be able to login to target panel with username '{panel_user_username}'.
""")
FAILED_TO_RESTORE_AUX_USERS = single_line_message("""
    Failed to deploy auxiliary users
""")
ACTION_CLOSE_SSH_CONNECTIONS = single_line_message("""
    Close SSH connections
""")
ACTION_REMOVE_TEMP_SSH_KEYS = single_line_message("""
    Remove temporary SSH keys
""")
ACTION_UNINSTALL_DUMP_AGENT = single_line_message("""
    Uninstall migration agent files
""")
FAILED_TO_UNINSTALL_DUMP_AGENT = single_line_message("""
    Could not uninstall the migration agent files
""")
LOG_UNICODE_EXCEPTION = single_line_message("""
    Unicode exception:
""")
EXCEPTION_CONTEXT = single_line_message("""
    Context: {context}
""")
EXCEPTION_FAILED_TO_READ_CONFIG_ABSENT_OPTION = single_line_message("""
    Failed to read configuration file: no option '%s' in section '[%s]'. Please fix migration tool
    configuration file ('%s') and run migration tool again.
""")
FAILED_TO_READ_CONFIG_FILE = single_line_message("""
    Failed to read configuration file '%s': %s
""")
AVAILABLE_COMMANDS = single_line_message("""
    Available commands:
""")
HOW_TO_SEE_MORE_COMMANDS = multi_line_message("""
    To see more commands run
    {indent}{command} help --advanced
""")
SCRIPT_TO_EXECUTE_OPTION = single_line_message("""
    Script to execute
""")
MIGRATOR_HELP_MESSAGE = multi_line_message("""
    %%(prog)s COMMAND [MIGRATION_CONFIGURATION_FILE]

    Available commands:
    %s

    The most useful commands are:
    1) generate-migration-list - to create list of objects to migrate
    2) check - to run pre-migration checks
    3) transfer-accounts - to run migration of objects
    4) test-all - to run post-migration checks

    Migration configuration file describes panels to be migrated, connection configuration
    for source and target servers and various other migration options.
    Refer to the official Plesk Migrator documentation for more information.
    You could find different sample configuration files at %s
    If this argument is not specified, Plesk Migrator will look for
    configuration file at default location: %s

    To view detailed help run "%%(prog)s help".
    To view arguments of a command COMMAND run "%%(prog)s COMMAND -h".
""")
CONFIG_FILE_OPTION = single_line_message("""
    migration configuration file which describes panels to be migrated, connection configuration
    for source and target servers and various other migration options.
    Refer to the official Plesk Migrator documentation for more information.
    You could find different sample configuration files at {samples_path}.
    If this argument is not specified, Plesk Migrator will look for
    configuration file at default location: {default_path}
""")
COMMAND_TRANSFER_ACCOUNTS = single_line_message("""
    Perform accounts transfer
""")
COMMAND_COPY_WEB_CONTENT = single_line_message("""
    Copy web content
""")
COMMAND_COPY_MAIL_CONTENT = single_line_message("""
    Copy mail content
""")
COMMAND_COPY_DB_CONTENT = single_line_message("""
    Copy databases content
""")
COMMAND_SET_DNS_FORWARDING = single_line_message("""
    Set up DNS forwarding
""")
COMMAND_TRANSFER_APS_PACKAGES = single_line_message("""
    Transfer APS packages
""")
COMMAND_RESTORE_APS_APPLICATIONS = single_line_message("""
    Restore APS applications
""")
COMMAND_TRANSFER_VDIRS = single_line_message("""
    Transfer virtual directories
""")
FAILED_TO_CONNECT_BY_SSH = single_line_message("""
    Failed to connect to the %s at '%s' by SSH as '%s': %s
""")
ERROR_CONNECTING_BY_SSH = single_line_message("""
    Error while connecting to the %s at '%s' by SSH as '%s': %s
""")
DEBUG_OPEN_SSH_CONNECTION = single_line_message("""
    Open SSH connection to the %s
""")
DEBUG_CLOSE_SSH_CONNECTION = single_line_message("""
    Closing SSH connection to %s
""")
CHECKER_FAILED_TO_CONNECT_BY_SSH = single_line_message("""
    Failed to connect to %s by SSH: %s
""")
CHECKER_FAILED_TO_CHECK_SSH_CONNECTION = single_line_message("""
    Failed to check SSH connection to %s: %s
""")
DEBUG_CHECK_API_CONNECTION = single_line_message("""
    Check API connection for %s.
""")
DATABASE_SERVER_DESCRIPTION = single_line_message("""
    %s database server %s:%s
""")
MIGRATOR_SERVER_DESCRIPTION = single_line_message("""
    this server
""")
PHYSICAL_SERVER_DESCRIPTION = single_line_message("""
    the server '%s'
""")
SOURCE_DESCRIPTION = single_line_message("""
    the source '%s'
""")
SOURCE_SERVER_DESCRIPTION = single_line_message("""
    the source server '%s' (%s)
""")
MODEL_SOURCE_TARGET = single_line_message("""
    Target panel
""")
MODEL_SOURCE_SOURCE = single_line_message("""
    Source panel '%s'
""")
EMAIL_DIFFERENCE = single_line_message("""
    e-mail of a customer on another server: '%s', e-mail of the checked customer: '%s'
""")
EMAIL_DIFFERENCE_DEST = single_line_message("""
    e-mail of a customer on destination panel: '%s', e-mail of the verified customer: '%s'
""")
LOG_CONVERT_PLANS = single_line_message("""
    Convert service plans
""")
LOG_CONVERT_RESELLERS = single_line_message("""
    Convert resellers
""")
LOG_MERGE_RESELLERS = single_line_message("""
    Merge resellers
""")
RESELLER_EXISTS_ON_NUMBER_OF_SERVERS_ERROR = multi_line_message("""
    Reseller with the same username '{login}' but different {difference} exists on a number of servers:
    {info_list}
""")
RESELLER_DESCRIPTION = single_line_message("""
    %s: username '%s', contact (first and last names) '%s', e-mail '%s'
""")
DEBUG_CONVERT_RESELLERS_FROM_SERVER = single_line_message("""
    Convert resellers from '%s'
""")
CLIENT_DESCRIPTION = single_line_message("""
    %s: username '%s', contact (first and last names) '%s', e-mail '%s'
""")
LOG_CONVERT_CLIENTS_FROM_SERVER = single_line_message("""
    Convert clients from '%s'
""")
LOG_REPLACED_IP = single_line_message("""
    Replaced IP in %s with %s
""")
UNKNOWN_IP_ADDRESS_TYPE = single_line_message("""
    Unknown IP address type: %s
""")
DEBUG_OPENING_DUMP = single_line_message("""
    Opening XML dump file: %s
""")
ERROR_UNSUPPORTED_DUMP_VERSION = single_line_message("""
    Unsupported backup dump version: %r
""")
ASSERT_BACKUP_UNKNOWN_OBJECT_TYPE = single_line_message("""
    Backup contains a path (%r), associated with an object of unknown type (%s)
""")
DEBUG_PARSE_PLAN = single_line_message("""
    Parse plan '%s'
""")
DEBUG_PARSE_RESELLER_PLAN = single_line_message("""
    Parse reseller plan '%s'
""")
DEBUG_PARSE_INFO_FOR_RESELLER = single_line_message("""
    Parsed info for reseller '%s'
""")
DEBUG_PARSE_INFO_FOR_CLIENT = single_line_message("""
    Parsed info for client '%s'
""")
DEBUG_PARSE_INFO_FOR_DOMAIN = single_line_message("""
    Parsed info for domain '%s'
""")
DEBUG_LOAD_RESELLERS_INFO = single_line_message("""
    Load resellers info
""")
DEBUG_LOAD_CLIENTS_INFO = single_line_message("""
    Load clients info
""")
DEBUG_DOMAINS_INFO = single_line_message("""
    Load domains info
""")
DEBUG_SAVING_BACKUP_INFO_FILE = single_line_message("""
    Saving a backup_info_file: %s
""")
DEBUG_SAVING_INDEXED_BY_PATH = single_line_message("""
    Saving a file indexed_by_path: %s
""")
DEBUG_SAVING_FILE = single_line_message("""
    Saving a file: %s, '%d' bytes
""")
DEBUG_CLOSED_ARCHIVE = single_line_message("""
    Closed an archive file
""")
DEBUG_OPENED_ZIP = single_line_message("""
    Opened a zip file %s
""")
DEBUG_OPENED_TAR = single_line_message("""
    Opened a tar file %s
""")
TARGET_DNS_SERVER_TITLE = single_line_message("""
    target DNS server
""")
SUMMARY_OPERATION_FINISHED_SUCCESSFULLY = single_line_message("""
    Operation finished successfully for %s out of %s %s
""")
NO_OBJECTS_CHECKED = single_line_message("""
    No objects were checked
""")
SUMMARY_TITLE_CHECKED_OBJECT = single_line_message("""
    Checked objects
""")
SUMMARY_TITLE_TOTAL = single_line_message("""
    Total
""")
SUMMARY_TITLE_SUCCESSFUL = single_line_message("""
    Successful
""")
SUMMARY_TITLE_WARNINGS = single_line_message("""
    Warnings
""")
SUMMARY_TITLE_FAILED = single_line_message("""
    Failed
""")
COMMAND_FAILED_WITH_EXIT_CODE = multi_line_message("""
    Command '%s' failed with exit code %d
    stdout: %s
    stderr: %s
""")
INVALID_BOOLEAN_VALUE = single_line_message("""
    Invalid boolean value string '%s', expected 'true' or 'false'
""")
STRING_EXPECTED_STARTS_WITH = single_line_message("""
    String '%s': expected that is starts with '%s'
""")
ASSERT_INVALID_ARGUMENTS_PASSED_TO_CONSTRUCTOR = single_line_message("""
    invalid arguments passed to constructor
""")
XML_TAGS_DO_NOT_MATCH = single_line_message("""
    Tags do not match: %s and %s
""")
XML_ATTRIBUTES_DO_NOT_MATCH = single_line_message("""
    Attributes do not match: %s=%r, %s=%r
""")
XML_ATTRIBUTE_MISSING = single_line_message("""
    x2 has an attribute x1 is missing:
""")
XML_TEXT_DIFFERS = single_line_message("""
    text: %r != %r
""")
XML_TAIL_DIFFERS = single_line_message("""
""")
XML_NUMBER_OF_CHILD_DIFFERS = single_line_message("""
    number of children of "%s" element differs, %i != %i
""")
XML_CHILDREN_DO_NOT_MATCH = single_line_message("""
    children %i do not match: %s
""")
DEBUG_API_REQUEST_TO = multi_line_message("""
    API request to %s:
    %s
""")
DEBUG_API_RESPONSE_FROM = multi_line_message("""
    API response from %s:
    %s
""")
INVALID_IPV4_MASK = single_line_message("""
    Invalid IPv4 mask: %s
""")
DEBUG_EXECUTE_SQL = single_line_message("""
    Execute SQL: '%s'
""")
DEBUG_SQL_ROW_COUNT = single_line_message("""
    SQL row count: '%s'
""")
DEBUG_SQL_QUERY_RESULTS = single_line_message("""
    SQL query result: '%s'
""")
DEBUG_XML_RPC_REQUEST_TO = multi_line_message("""
    XML-RPC request to %s:
    %s
""")
DEBUG_XML_RESPONSE = multi_line_message("""
    XML-RPC response:
    %s
""")
DEBUG_IMPORT_DUMP_REQUEST_XML = single_line_message("""
    Import dump request XML: %s
""")
DEBUG_RESTORE_REQUEST_XML = single_line_message("""
    Restore request XML: %s
""")
DEBUG_DELETE_DUMP_REQUEST_XML = single_line_message("""
    Delete dump request XML: %s
""")
DEBUG_RESTORE_TASK_FINISHED = single_line_message("""
    Restore task finished
""")
DEBUG_RESTORE_TASK_RUNNING = single_line_message("""
    Restore task is running
""")
FEATURE_WILL_BE_DISABLED = single_line_message("""
    This feature will be disabled.
""")
DOT_NET_RUNTIME = single_line_message("""
    .NET runtime
""")
UNABLE_TO_INSTALL_DUMP_AGENT_ANOTHER_INSTALLER = single_line_message("""
    Unable to install dump agent at %s because another software is installing right now. Please try again later.
""")
INSTALL_COMMAND_FAILED_WITH_EXIT_CODE = multi_line_message("""
    Command %s failed with exit code %d:
    stdout: %s
    stderr: %s
""")
DEBUG_UPLOAD_CONVERTER = single_line_message("""
    Uploaded converter to '%s'
""")
DATABASE_COPY_INFO_DESCRIPTION = single_line_message("""
    Database '%s' of subscription '%s': copy from %s to %s
""")
LOG_COPY_DB_CONTENT = single_line_message("""
    Copy database '{db_name}' content from {source} to {target}
""")
LOG_REMOVE_DB_DUMP_FILES = single_line_message("""
    Remove database dump files; source: %s, target: %s
""")
DB_CONNECTION_FAILURE = multi_line_message("""
    Connection to {server} failed.
    Command was: {command}
    Stdout: {stdout}
    Stderr: {stderr}
    Exit code: {exit_code}
""")
MSSQL_DB_CONNECTION_FAILURE = multi_line_message("""
    Connection to {server} failed.
    Reason: {reason}
""")
MSSQL_DB_CONNECTION_CHECK_RESULT = multi_line_message("""
    Check connection to {server} failed.
    Tried to execute query "{query}".
    Expected result was a single row with one column "result" and value "1".
    Actually got: {result}.
""")
STARTED_ASYNC_MIGRATION_PROCESS = single_line_message("""
    Started async migration process, pid=%s
""")
MESSAGE_SUMMARY = single_line_message("""
    Summary
""")
PROGRESS_STATUS_TOTAL = single_line_message("""
    Total
""")
PROGRESS_STATUS_FINISHED = single_line_message("""
    Finished
""")
PROGRESS_STATUS_NOT_FINISHED = single_line_message("""
    Not finished
""")
PROGRESS_STATUS_NOT_STARTED = single_line_message("""
    Not Started
""")
PROGRESS_STATUS_IN_PROGRESS = single_line_message("""
    In Progress
""")
PROGRESS_STATUS_ON_HOLD = single_line_message("""
    On Hold
""")
PROGRESS_STATUS_FINISHED_OK = single_line_message("""
    Finished successfully
""")
PROGRESS_STATUS_FINISHED_WARNINGS = single_line_message("""
    Finished with warnings
""")
PROGRESS_STATUS_FAILED = single_line_message("""
    Failed
""")
PROGRESS_STATUS_REVERTED = single_line_message("""
    Reverted
""")
PROGRESS_STATUS_CANCELLED = single_line_message("""
    Cancelled
""")
PROGRESS_ACTION = single_line_message("""
    Action
""")
PROGRESS_STATUS = single_line_message("""
    Status
""")
SUBSCRIPTION_TITLE = single_line_message("""
    Subscription
""")
UNABLE_TO_FIND_RSYNC_BINARY = single_line_message("""
    Unable to find rsync binary on the server %s. Checked the following path: %s
""")
FAILED_TO_SET_PLAIN_PASSWORDS = single_line_message("""
    Failed to %s. Command: %s, stdout: %s, stderr: %s
""")
FAILED_TO_DETERMINE_PLESK_API_SHOW_PASSWORD = single_line_message("""
    Failed to determine if Plesk API is allowed to show plain passwords. Command: %s, stdout: %s, stderr: %s
""")
TRACE_START = single_line_message("""
    START: %s
""")
TRACE_FINISH = single_line_message("""
    FINISH: %s
""")
TRACE_ABORT = single_line_message("""
    ABORT (by exception): %s
""")
DEBUG_CLIGATE_REQUEST = multi_line_message("""
    Request to CLIGate:
    URL: {url}
    Query: {query}
    Equivalent command: {command}
""")
CLIGATE_COMMAND_FAILED = multi_line_message("""
    Command %s failed with exit code %d:
    stdout: %s
    stderr: %s
""")
DEBUG_PLESK_BASE_DIRECTORY = single_line_message("""
    Plesk base directory is "%s"
""")
DEBUG_PLESK_DATA_DIRECTORY = single_line_message("""
    Plesk data directory is "%s"
""")
DEBUG_PLESK_DUMP_DIRECTORY = single_line_message("""
    Plesk dump directory is "%s"
""")
DEBUG_WINDOWS_VHOST_DIRECTORY = single_line_message("""
    Windows vhost directory: %s
""")
DEBUG_UNIX_VHOST_DIRECTORY = single_line_message("""
    Unix vhost directory: %s
""")
DEBUG_UNIX_VHOST_SYSTEM_DIRECTORY = single_line_message("""
    Unix vhost system directory: %s
""")
DEBUG_UNIX_VHOSTS_DIRECTORY = single_line_message("""
    Virtual hosts directory
""")
DEBUG_MAIL_MESSAGES_DIRECTORY = single_line_message("""
    Mail messages directory
""")
DEBUG_BACKUP_DUMPS_DIRECTORY = single_line_message("""
    Backup dumps directory
""")
DEBUG_UNIX_PRODUCT_ROOT_DIRECTORY = single_line_message("""
    Unix product root directory
""")
DEBUG_UNIX_MAILMAN_ROOT_DIRECTORY = single_line_message("""
    Unix mailman root directory
""")
PHP_HANDLER_TYPE_DEFAULT_OS = single_line_message("""
    default OS PHP
""")
PHP_HANDLER_TYPE_DEFAULT_PLESK = single_line_message("""
    default Plesk handler
""")
PHP_HANDLER_TYPE_CUSTOM = single_line_message("""
    custom PHP handler (id='%s')
""")
PHP_UNKNOWN_VERSION = single_line_message("""
    of unknown version
""")
PHP_MODE_FASTCGI = single_line_message("""
    running in FastCGI mode
""")
PHP_MODE_CGI = single_line_message("""
    running in CGI mode
""")
PHP_MODE_FPM = single_line_message("""
    running in FPM mode
""")
PHP_MODE_APACHE_MODULE = single_line_message("""
    running as Apache module
""")
PHP_MODE_UNKNOWN = single_line_message("""
    running in unknown mode
""")
PHP_MODE_ID_STRING = single_line_message("""
    running in '%s' mode
""")
PHP_DESCRIPTION = single_line_message("""
    {title} for PHP {version} {mode}
""")
ERROR_FAILED_TO_IMPORT_DUMP = multi_line_message("""
    Failed to import backup XML: errcode must be '0' (no errors) or '116' (backup sign error).
    Output of pmmcli utility:
    %s
""")
ERROR_FAILED_TO_IMPORT_DUMP_INVALID_FORMAT = multi_line_message("""
    Failed to import Plesk configuration dump: backup file is not valid or corrupted.
    Migration will try to continue, but there could be issues when restoring hosting settings.
""")
DEBUG_IMPORTED_DUMP_ID = single_line_message("""
    Imported backup id reported by pmmcli is '%s'
""")
PLESK_RESTORE_REPORT_PROBLEM = single_line_message("""
    Plesk restore report problem:
""")
DEBUG_INSTALL_RSYNC = single_line_message("""
    Install rsync on %s
""")
DEBUG_RSYNC_INSTALLED_TO = single_line_message("""
    Rsync on %s was installed into %s
""")
DEBUG_CONFIGURE_SSH_KEY_AUTH = single_line_message("""
    Configure SSH key auth from %s to %s
""")
DEBUG_REMOVE_SSH_KEY_AUTH = single_line_message("""
    Remove SSH key auth from %s to %s
""")
FAILED_TO_REMOVE_SSH_KEY = single_line_message("""
    Failed to remove SSH key from %s to %s: %s
""")
SSH_EXECUTION_ERROR = multi_line_message("""
    Remote command "%s" terminated with code %d
    stdout: %s
    stderr: %s
""")
SSH_UNABLE_TO_CONNECT_TO_HOST = single_line_message("""
    Unable to connect to '{host}' by SSH: {exception}. Retrying in {interval_between_attempts} seconds
""")
WAIT_RECONNECT_BY_SSH = single_line_message("""
    Reconnect by SSH
""")
PROFILE_TOTAL_TIME = single_line_message("""
    Total time: %s
""")
PROFILE_TIME_INSIDE_MIGRATOR = single_line_message("""
    Total time inside Plesk Migrator: %s
""")
PROFILE_OTHER_TIME = single_line_message("""
    Other
""")
PROFILE_PER_SUBSCRIPTION = single_line_message("""
    %s per subscription
""")
FAILURE_NAME_NOT_UNIQUE = single_line_message("""
    Name is not unique: %s
""")
DEBUG_TRY_TO_CONNECT_TO_TRANSFER_AGENT = single_line_message("""
    Try to connect to RPC Agent at %s:%s
""")
DEBUG_UPLOAD_AND_START_AGENT = single_line_message("""
    Upload and start agent
""")
DEBUG_SSL_CLIENT_KEY = multi_line_message("""
    SSL is enabled for agent at '{ip}'. Agent keys and certificates:
    SSL client key: {ssl_client_key}
    SSL client certificate: {ssl_client_cert}
    SSL server certificate: {ssl_server_cert}
""")
DEBUG_CONNECT_TO_AGENT = single_line_message("""
    Connect to agent at '%s'
""")
DEBUG_RECONNECT_TO_AGENT = single_line_message("""
    Reconnect to agent at '%s'
""")
REMOTE_OPERATION_OK_AFTER_ATTEMPTS = single_line_message("""
    Remote operation executed successfully at {host} after {attempts} attempt(s)
""")
REMOTE_OPERATION_FAILED_RETRY = single_line_message("""
    Failed to run remote operation, retry in {interval_between_attempts} seconds
""")
SLEEP_RETRY_RUNNING_REMOTE_COMMAND = single_line_message("""
    Retry running remote command
""")
LOG_PROCESS_SUBSCRIPTION = single_line_message("""
    Process subscription '%s' (#%s out of %s)
""")
DEBUG_ENTER_COMMON_BLOCK = single_line_message("""
    Enter common action block
""")
DEBUG_EXIT_COMMON_BLOCK = single_line_message("""
    Exit common action block
""")
LOG_START_SUBSCRIPTION = single_line_message("""
    START Processing subscription '%s' (#%s out of %s)
""")
PROFILE_SUBSCRIPTION_TITLE = single_line_message("""
    Subscription '%s'
""")
DEBUG_EXECUTE_SHUTDOWN_ACTION = single_line_message("""
    Execute shutdown action '%s'
""")
ACTION_COPY_WEB_FILES = single_line_message("""
    Copy web files
""")
ACTION_SYNC_WEB_CONTENT_ASSETS = single_line_message("""
    Sync web content assets
""")
ACTION_CHECK_CONNECTIONS = single_line_message("""
    Check connections
""")
ACTION_CHECK_SOURCE_CONNECTIONS = single_line_message("""
    Check source connections
""")
ACTION_COPY_CONTENT_AFTER_TRANSFER_DESCRIPTION = single_line_message("""
    Sync content of migrated subscriptions
""")
ACTION_COPY_CONTENT_AFTER_TRANSFER_FAILURE = single_line_message("""
    Failed to sync content of migrated subscriptions
""")
ACTION_CHECK_TARGET_CONNECTIONS = single_line_message("""
    Check target connections
""")
ACTION_READ_MIGRATION_LIST = single_line_message("""
    Read migration list
""")
ACTION_VERIFY_HOSTING = single_line_message("""
    Verify hosting
""")
ACTION_PRINT_PRE_MIGRATION_ERROR = single_line_message("""
    Print pre-migration report
""")
ACTION_RESTART_IIS_FOR_IDN_DOMAINS = single_line_message("""
    Restart IIS for IDN domains
""")
ACTION_TEST_SERVICES_PRINT_REPORT_DESCRIPTION = single_line_message("""
    Print test services report
""")
ACTION_TEST_SERVICES_PRINT_REPORT_FAILURE = single_line_message("""
    Failed to print test services report
""")
ACTIONS_TEST_USERS_DESCRIPTION = single_line_message("""
    Check that users are transferred correctly (FTP/SSH/RDP access)
""")
ACTIONS_TEST_USERS_FAILURE = single_line_message("""
    Failed to check that users are transferred correctly (FTP/SSH/RDP access)
""")
LOCAL_COMMAND_FAILED = multi_line_message("""
    Command '%s' executed locally failed with exit code %d.
    stdout: %s
    stderr:%s
""")
DEBUG_COMMAND_RESULTS = multi_line_message("""
    Command execution results:
    stdout: {stdout}
    stderr: {stderr}
    exit code: {exit_code}
""")
FAILED_TO_EXECUTE_LOCAL_COMMAND = single_line_message("""
    Failed to execute local command '{command}': {reason}
""")
IP_MAPPING_INVALID_ARGUMENTS_COUNT = single_line_message("""
    Line #%s: invalid number of arguments found on line. Expected: <source-ip> <target-ip>.
    For example: 10.52.1.17 10.52.12.32
""")
FAILED_TO_READ_IP_MAPPING = multi_line_message("""
    Failed to read IP mapping:
    %s
""")
INVALID_SSH_AUTH_VALUE = single_line_message("""
    Invalid value '%s' of 'ssh-auth-type' parameter in '[%s]' section of configuration file. Allowed values: %s.
""")
RUNNER_COMMAND_STR_FAILED_WITH_EXIT_CODE = multi_line_message("""
    Command execution failed on {server} with non-zero exit code.
    command: {command}
    exit code: {exit_code}
    stdout: {stdout}
    stderr: {stderr}
""")
COMMAND_RUN_ATTEMPTS = single_line_message("""
    Attempting to run "%s"
""")
COMMAND_EXECUTED_OK_AFTER_ATTEMPTS = single_line_message("""
    Command "%s" was executed successfully after %d attempt(s).
""")
SLEEP_RETRY_EXECUTING_COMMAND = single_line_message("""
    Retry executing command
""")
UNABLE_DETECT_WINDOWS_CODEPAGE = multi_line_message("""
    Unable to determine Windows CMD code page:
    stdout: %s
    stderr: %s
""")
DEBUG_DETECTED_CODEPAGE = single_line_message("""
    Detected CMD codepage: %s
""")
LOCAL_SERVER_TITLE = single_line_message("""
    Local server
""")
DEBUG_COPY_LOCAL_FILE = single_line_message("""
    Copy local file '%s' to '%s'
""")
DEBUG_EXECUTE_COMMAND = single_line_message("""
    Execute command on {server}: {command}
""")
DEBUG_DOWNLOAD_FILE = single_line_message("""
    Download file '%s' to '%s' from '%s
""")
DEBUG_UPLOAD_FILE = single_line_message("""
    Upload file '%s' to '%s' at '%s'
""")
DEBUG_UPLOAD_FILE_CONTENTS = single_line_message("""
    Upload file contents to '%s' at '%s
""")
DEBUG_FTP_CONNECTION = single_line_message("""
    Try to establish FTP connection to host '{host}' with username '{username}'
""")
DEBUG_FTP_DOWNLOAD_DIR = single_line_message("""
    Upload dir via FTP from '{source_host}' to '{target_host}': {source_path} > {target_path}
""")
DEBUG_FTP_DOWNLOAD_FILE = single_line_message("""
    Download file via FTP: {source_path} > {target_path}
""")
DEBUG_FTP_DOWNLOAD_FILE_FAILED = single_line_message("""
    Unable to download file '{source_path}' into '{target_path}' via FTP: {message}
""")
DEBUG_FTP_UPLOAD_FILE = single_line_message("""
    Upload file via FTP: {source_path} > {target_path}
""")
PROFILE_UPLOAD_FILE = single_line_message("""
    Upload file '%s'
""")
DEBUG_DOWNLOAD_FILE_CONTENTS = single_line_message("""
    Download contents of '%s' file from '%s'
""")
PROFILE_DOWNLOAD_FILE = single_line_message("""
    Download file '%s'
""")
DEBUG_MOVE_FILE = single_line_message("""
    Move '%s' to '%s' on '%s'
""")
PROFILE_MOVE_FILE = single_line_message("""
    Move '%s' to '%s'
""")
DEBUG_LIST_FILES = single_line_message("""
    List '%s' on '%s'
""")
PROFILE_LIST_FILES = single_line_message("""
    List '%s'
""")
DEBUG_REMOVE_FILE = single_line_message("""
    Remove file '%s' from '%s'
""")
PROFILE_REMOVE_FILE = single_line_message("""
    Remove file '%s'
""")
DEBUG_CREATE_DIRECTORY = single_line_message("""
    Create directory '%s' at '%s'
""")
PROFILE_CREATE_DIRECTORY = single_line_message("""
    Create directory '%s'
""")
FAILED_TO_EXECUTE_COMMAND = single_line_message("""
    Failed to execute command '%s'. Stdout: %s. Stderr: %s.
""")
ERRORS_WHEN_EXECUTING_COMMAND = multi_line_message("""
    Errors while executing command:
    %s
""")
ERROR_READING_SUBSCRIPTION_STATUS = single_line_message("""
    Failed to read subscription status file {filename}: {reason}. Subscription status will be reset
""")
FAILED_TO_PERFORM_ACTION_ON_SUBSCRIPTION = single_line_message("""
    Failed to perform an action on subscription '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_PLAN = single_line_message("""
    Failed to perform an action on plan '%s' owned by %s: %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_RESELLER = single_line_message("""
    Failed to perform an action on reseller '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_CLIENT = single_line_message("""
    Failed to perform an action on client '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_AUX_USER = single_line_message("""
    Failed to perform an action on auxiliary user '%s' owner by '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_AUX_USER_ROLE = single_line_message("""
    Failed to perform an action on auxiliary user role '%s' owned by '%s': %s Exception message: %s
""")
FAILED_TO_PERFORM_ACTION_ON_SUBSCRIPTION_ERROR_STRING = single_line_message("""
    Failed to perform an action on subscription '%s': %s
""")
FAILED_TO_PERFORM_ACTION_ON_CLIENT_ERROR_STRING = single_line_message("""
    Failed to perform an action on client '%s': %s
""")
FAILED_TO_PERFORM_ACTION_ON_RESELLER_ERROR_STRING = single_line_message("""
    Failed to perform an action on reseller '{reseller_username}': {error_message}
""")
ATTEMPT_FAILED_WITH_ERROR = multi_line_message("""
    Attempt #%s failed with the following error:
    %s
""")
MIGRATOR_TRIED_TO_PERFORM_ACTION_IN_ATTEMPTS = single_line_message("""
    Migration tools tried to perform operation in %s attempts: %s
""")
ASSERT_NO_ATTEMPTS = single_line_message("""
    No attempts were performed to perform operation
""")
RSYNC_INTERACTION_OK_AFTER_ATTEMPTS = single_line_message("""
    Interaction via rsync with server at {source_ip} ad client at {target_ip}
    was finished successfully after {attempts} attempt(s).
""")
RSYNC_INTERACTION_FAILED = single_line_message("""
    Interaction via rsync with server at {source_ip} and client at {target_ip} was failed
""")
RSYNC_RETRY_IN = single_line_message("""
    retry in {interval} seconds
""")
SLEEP_RETRY_RSYNC = single_line_message("""
    Retry interaction via rsync
""")
MIGRATOR_START = single_line_message("""
    MIGRATOR START: %s
""")
MIGRATOR_END = single_line_message("""
    MIGRATOR END: %s
""")
LOG_INITIALIZE_MIGRATOR = single_line_message("""
    Initialize Plesk Migrator
""")
REPORT_POTENTIAL_ISSUES = single_line_message("""
    Detected potential issues
""")
REPORT_DNS_FORWARDING_ISSUES = single_line_message("""
    DNS forwarding issues
""")
REPORT_ADJUSTED_APPLICATIONS = single_line_message("""
    Adjusted applications
""")
LOG_LOAD_CONFIGURATION = single_line_message("""
    Load configuration
""")
DEBUG_TARGET_PANEL = single_line_message("""
    Target panel: %s
""")
DEBUG_SOURCE_PANEL = single_line_message("""
    Source panel: %s
""")
REPORT_SERVICE_ISSUES = single_line_message("""
    Services' Issues
""")
REPORT_DETECTED_PROBLEMS = single_line_message("""
    Detected problems
""")
FAILED_TO_READ_MIGRATION_LIST = single_line_message("""
    Failed to read migration list file '%s': %s
""")
DEBUG_ENABLE_SECURITY_POLICY = single_line_message("""
    Enable security policy on '%s'
""")
DEBUG_DISABLE_SECURITY_POLICY = single_line_message("""
    Disable security policy on '%s'
""")
LOG_CONVERT_HOSTING_SETTINGS = single_line_message("""
    Convert hosting settings
""")
SUSPEND_TARGET_SUBSCRIPTION = single_line_message("""
    Suspend target subscription '%s'
""")
FAILED_TO_SUSPEND_CUSTOMER = single_line_message("""
    Failed to suspend customer
""")
DEBUG_SUSPEND_CUSTOMER = single_line_message("""
    Suspend customer
""")
FAILED_TO_SUSPEND_RESELLER = single_line_message("""
    Failed to suspend reseller
""")
REPORT_WEBSITE_ISSUES = single_line_message("""
    Transferred Web Sites' Issues
""")
REPORT_USER_ISSUES = single_line_message("""
    Transferred Users Issues
""")
FAILED_TO_SAVE_EXTERNAL_REPORT = single_line_message("""
    Unable to save external report data into file '%s': %s
""")
FAILED_OBJECTS_SUBSCRIPTIONS = single_line_message("""
    subscription(s)
""")
FAILED_OBJECTS_RESELLERS = single_line_message("""
    reseller(s)
""")
FAILED_OBJECTS_CLIENTS = single_line_message("""
    client(s)
""")
FAILED_OBJECTS_PLANS = single_line_message("""
    plan(s)
""")
FAILED_OBJECTS_AUX_USERS = single_line_message("""
    auxiliary user(s)
""")
FAILED_OBJECTS_AUX_USER_ROLES = single_line_message("""
    auxiliary user role(s)
""")
OWNED_BY = single_line_message("""
    '%s' owned by '%s'
""")
OWNED_BY_ADMIN = single_line_message("""
    '%s' owned by admin
""")
OWNED_BY_RESELLER = single_line_message("""
    '%s' owned by reseller '%s'
""")
OWNED_BY_CUSTOMER = single_line_message("""
    '%s' owned by customer '%s'
""")
FAILED_TO_PERFORM_OPERATION = single_line_message("""
    Failed to perform operation on %s %s: %s
""")
EXCEPTION_MIGRATION_CONFIGURATION_FILE_SOURCES_MISSED = single_line_message("""
    Sources are not specified in migration configuration file
""")
EXCEPTION_MESSAGE = single_line_message("""
    Exception message: %s
""")
SUBSCRIPTIONS_FAILED_TO_MIGRATE = multi_line_message("""
    {failed_subscriptions} of {total_subscriptions} subscription(s) failed to migrate.
    All of them are listed in "{failed_subscriptions_file}".
    To repeat migration for these subscriptions only, run Plesk Migrator in the following way:
    # {executable_name} transfer-accounts config.ini --migration-list-file "{failed_subscriptions_file}"
""")
REPORT_MIGRATION_STATUS = single_line_message("""
    Detailed Migration Status
""")
FAILED_TO_DETECT_DB_LIST = single_line_message("""
    Failed to detect list of databases on %s: %s
""")
DB_NOT_COPIED_NO_DB_SERVER = single_line_message("""
    Database '{db.name}' from {db.dbtype} server at {db.host}:{db.port} will not be copied
    as no {db.dbtype} DB server is assigned to subscription '{subscr}'
""")
DEBUG_DB_ASSIMILATION = single_line_message("""
    Database '{db.name}' from {db.dbtype} server at {db.host}:{db.port} remains on the same server,
    content will not be copied
""")
HOW_TO_SKIP_DISK_SPACE_CHECK = single_line_message("""
    To skip disk space requirements, check for %s pass --skip-main-node-disk-space-checks command line option
""")
ERROR_AND_EXCEPTION_MESSAGE = single_line_message("""
    %s Exception message: %s
""")
FAILED_TO_CHECK_CONNECTIONS = single_line_message("""
    Failed to check connections
""")
REPORT_INFRASTRUCTURE = single_line_message("""
    Infrastructure
""")
LOG_CHECK_CONNECTION_REQUIREMENTS = single_line_message("""
    Check connection requirements
""")
LOG_CHECK_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Check disk space requirements
""")
REPORT_DISK_SPACE_REQUIREMENTS = single_line_message("""
    Disk space requirements
""")
FAILED_TO_SET_DBDUMP_DIR_PERMISSIONS = single_line_message("""
    Failed to set permissions for directory with MSSQL database dumps: {reason}.
    Default (inherited) permissions will be used.
    If there are some problems when copying database content, ensure that {server} is provided with
    full access to {directory}
""")
FAILED_TO_FIND_ELEMENT_IN_LIST = single_line_message("""
    Failed to find element in list
""")
DEBUG_FILES_TO_COPY = single_line_message("""
    Files to copy for subscription '{subscription_name}': {files}
""")
DEBUG_START_COPY_FILES = single_line_message("""
    Start copy files for subscription '{subscription_name}': {files_item}
""")
ASSERT_INVALID_MSSQL_HOSTNAME = single_line_message("""
    Invalid MSSQL hostname '{hostname}'
""")
FAILED_DISABLE_CP_ACCESS_FOR_NO_PASSWORD_MAILUSER = single_line_message("""
    Failed to disable control panel access in configuration dump for mail users that have no password
""")
ACTION_DISABLE_CP_ACCESS_FOR_NO_PASSWORD_MAILUSER = single_line_message("""
    Disable control panel access in configuration dump for mail users that have no password
""")
DEBUG_PLAIN_PASSWORD_NOT_FOUND_FOR_RESELLER = single_line_message("""
    Plain password not found for reseller '%s'
""")
DEBUG_AUX_USER_PASSWORD_NOT_FOUND_FOR_RESELLER = single_line_message("""
    Auxiliary user password not found for reseller '%s'
""")
DEBUG_ENCRYPTED_PASSWORD_NOT_APPLICABLE_FOR_RESELLER = single_line_message("""
    Encrypted password does not exist for reseller '%s', or encrypted passwords are not supported by target panel.
    Password will be generated.
""")
DEBUG_PLAIN_PASSWORD_NOT_FOUND_FOR_CLIENT = single_line_message("""
    Plain password not found for client '%s'
""")
DEBUG_AUX_USER_PASSWORD_NOT_FOUND_FOR_CLIENT = single_line_message("""
    Auxiliary user password not found for client '%s'
""")
DEBUG_ENCRYPTED_PASSWORD_NOT_APPLICABLE_FOR_CLIENT = single_line_message("""
    Encrypted password does not exist for client '%s', or encrypted passwords are not supported by target panel.
    Password will be generated.
""")
NO_COMMAND_LINE_OPTION_WARNING = single_line_message("""
    Internal error: command line option '{option_name}' does not exist for current command.
    Default value will be used.
""")
OPTION_INCLUDE_EXISTING_SUBSCRIPTIONS = single_line_message("""
    Include subscriptions that already exist on the target server into migration list
    (do not comment them, as it is done by default)
""")
OPTION_MIGRATION_LIST_FORMAT = single_line_message("""
    Migration list format: plain text ("text", default value) or JSON ("json")
""")
FAILED_TO_DOWNLOAD_FILE = single_line_message("""
    Failed to download '{url}' to '{file}': {code} ({message}) was returned by the server
""")
DEBUG_DOWNLOAD_FILE_TO = single_line_message("""
    Download '{url}' into '{filename}'
""")
DEBUG_UNZIP_FILE_TO = single_line_message("""
    Unzip {archive} into {path}
""")
ACTION_FIX_PROTECTED_DIRECTORY_LOGINS_DESCRIPTION = single_line_message("""
    Fix logins of protected directory users
""")
ACTION_FIX_PROTECTED_DIRECTORY_LOGINS_FAILURE = single_line_message("""
    Failed to fix logins of protected directory users
""")
PROTECTED_DIRECTORY_LOGIN_FIXED = multi_line_message("""
    Protected directory '{directory}' of domain '{domain}':
    login of protected directory user '{old_login}' does not conform to Plesk validation rules.
    Login was changed to '{new_login}'.
""")
ACTION_REMOVE_BAD_PROTECTED_DIRS_DESCRIPTION = single_line_message("""
    Remove protected directories that have names which do not conform to Plesk rules from dump
""")
ACTION_REMOVE_BAD_PROTECTED_DIRS_FAILURE = single_line_message("""
    Failed to remove protected directories that have names which do not conform to Plesk rules from dump
""")
ACTION_CHECK_PROTECTED_DIR_NAMES_DESCRIPTION = single_line_message("""
    Check if protected directories have names which conform to Plesk rules
""")
ACTION_CHECK_PROTECTED_DIR_NAMES_FAILURE = single_line_message("""
    Failed to check if protected directories have names which conform to Plesk rules
""")
PROTECTED_DIRECTORY_NAME_INVALID_ISSUE = single_line_message("""
    Protected directory '{directory}' of domain '{domain}' can not be created in Plesk:
    it does not conform to Plesk rules.
""")
PROTECTED_DIRECTORY_NAME_INVALID_SOLUTION = single_line_message("""
    Before migration, you can rename (move) protected directory on the source server.
    Once migration is finished, you can move the directory on the target to a place
    which conforms to Plesk rules, and then recreate protected directory and its users manually.
""")
ACTION_FIX_UNIX_HTACCESS_DESCRIPTION = single_line_message("""
    Fix htaccess for protected directories
""")
ACTION_FIX_UNIX_HTACCESS_FAILED = single_line_message("""
    Failed to fix htaccess for protected directories of subscription '{subscription_name}'
""")
FIX_HTACCESS_FOR_PROTECTED_DIR = single_line_message("""
    Fix file '{filename}' for protected directory '{directory}' of domain '{domain}' to work on target
""")
SSH_AUTH_NOT_SPECIFIED = multi_line_message("""
    SSH connection parameters are not specified for remote target Plesk server.
    Please specify SSH root password with "ssh-password" option in '[{section_name}]' section of configuration file.
    For other SSH connection options like SSH keys, refer to the official documentation and
    configuration file examples.
""")
ACTION_RUN_SUBSCRIPTION_FINISHED_SCRIPTS = single_line_message("""
    Run custom scripts on subscription migration finished event
""")
FAILURE_RUN_SUBSCRIPTION_FINISHED_SCRIPTS = single_line_message("""
    Failed to run custom scripts on subscription migration finished event
""")
LOG_RUN_SUBSCRIPTION_FINISHED_SCRIPT = single_line_message("""
    Run subscription finished script '{script}' for subscription '{subscription}'
""")
LOG_SUBSCRIPTION_FINISHED_SCRIPT_DIR = single_line_message("""
    Looking for subscription finished scripts at '{scripts_dir}'
""")
CHANGED_APPLICATION_FILE_LINE = multi_line_message("""
    {configuration_file_description}: adjusted database host.
    Line #{line_number} of the file was changed.
    Before fix: {before_fix}
    After fix: {after_fix}
""")
CHANGED_PATHS = multi_line_message("""
    File '{filename}': fixed paths, that were updated during migration.
    Line #{line_number} of the file was changed.
    Before fix: {before_fix}
    After fix: {after_fix}
""")
APPLICATION_FILE_CONFIG_DESCRIPTION = single_line_message("""
    Configuration file '{filename}' of application '{application_name}'
""")
WINDOWS_WEB_CONFIG_FILE_DESCRIPTION = single_line_message("""
    Windows web configuration file '{filename}'
""")
FAILED_TO_PROCESS_FILE_WHEN_ADJUSTING_DB = single_line_message("""
    Failed to process file '{filename}' when adjusting configuration of applications: {reason}
""")
FAILED_TO_PROCESS_FILE_WHEN_ADJUSTING_PATHS = single_line_message("""
    Failed to process file '{filename}' when adjusting paths in applications: {reason}
""")
DEBUG_SKIP_LARGE_SIZE_CONFIGS = single_line_message("""
    File {filename} was skipped when adjusting application configs:
    it does not look like configuration file as it is quite large
""")
DEBUG_SKIP_BINARY_FILE = single_line_message("""
    File {filename} was skipped when adjusting application configs:
    it looks like a binary file, or has not-UTF-8 encoding
""")
FIX_WEB_CONFIG_INTEGRATED_MODE_ACTION_DESCRIPTION = single_line_message("""
    Allow applications in Classic mode to work in Integrated mode after migration in web.config files
""")
FIX_WEB_CONFIG_INTEGRATED_MODE_ACTION_FAILURE = single_line_message("""
    Failed to allow applications in Classic to work in Integrated mode after migration in web.config files
""")
COMMAND_SUMMARIZE_STATISTICS = single_line_message("""
    Summarize statistics
""")
GET_PATH_TO_RPC_AGENT_BINARY = single_line_message("""
    Get path to RPC agent binary. If it does not exist yet - create.
""")
ACTION_START_SESSION_STATISTICS = single_line_message("""
    Start session statistics
""")
FAILED_ACTION_START_SESSION_STATISTICS = single_line_message("""
    Failed to start session statistics
""")
ACTION_FINALIZE_SESSION_STATISTICS = single_line_message("""
    End session statistics
""")
FAILED_ACTION_FINALIZE_SESSION_STATISTICS = single_line_message("""
    Failed to finalize session statistics
""")
EXECUTE_SQL_QUERY = single_line_message("""
    Execute SQL query on panel database: {query}
""")
EXECUTE_SQL_QUERY_RESULT = single_line_message("""
    SQL query result: {result}
""")
FAILED_TO_EXECUTE_SQL_QUERY = single_line_message("""
    Failed to execute SQL query on panel database: {reason}
""")
MYSQL_TARGET_VERSION_DOES_NOT_HAVE_ENCODING = multi_line_message("""
    Restoration of MySQL database failed. Most probable reason:

    Target MySQL server does not contain necessary character set 'utf8mb4'.
    It is required to have at least MySQL 5.5 to restore such database, that feature is not available by
    default in the previous versions of MySQL.
    See https://dev.mysql.com/doc/refman/5.5/en/charset-unicode-utf8mb4.html for more details.

    Proposed solutions:
    *) Obtain another target server which has OS providing appropriate MySQL server version.
    For example, CentOS 6 provides MySQL 5.1 by default, while CentOS 7 provides MySQL 5.5 by default.
    *) Connect another external MySQL server to the target server with appropriate MySQL version.
    Configure that server as default, or specify it in service plan to which subscriptions are assigned to.
    Remove migrated subscription from the target server and start migration once more.
    *) Upgrade MySQL server on the target server to appropriate version, then run migration once more (no need to
    remove subscriptions from target - just run migration over existing domains). For example, for CentOS you could use
    packages provided by EPEL repositories. This way is not recommended for servers already running in production.

    Here is the original error message reported by MySQL client when restoring the database:
    {restoration_error}
""")
FAILED_TO_READ_STATISTICS_FILE = multi_line_message("""
    Failed to read statistics file '{filename}', consider it is empty
""")
RPC_AGENT_BUILT_INDICATOR = single_line_message("""
    This is a file indicating that RPC agent was successfully built. Remove
    that file if you want to rebuild it.
""")
COMMAND_GENERATE_HTML_LOG = single_line_message("""
    Generate HTML log out of plain text debug log
""")
INVALID_LOG_LINE = multi_line_message("""
    Text log file "{log_file}" contain invalid log line, which will be skipped when generating HTML log file:
    {line}
""")
ACTION_GENERATE_HTML_LOG_DESCRIPTION = single_line_message("""
    Generate HTML log out of plain text debug log
""")
ACTION_GENERATE_HTML_LOG_FAILURE = single_line_message("""
    Failed to generate HTML log out of plain text debug log
""")
HTML_LOG_SAVED_TO = single_line_message("""
    HTML log was saved to {filename}
""")
NO_DEBUG_LOG_IN_SESSION = single_line_message("""
    Cannot generate HTML log: there is no debug.log file in session directory ({filename})
""")
DEBUG_ADD_ALLOWED_PROGRAM_FIREWALL_RULE = single_line_message("""
    Add firewall rule '{rule}' allowing connections for program '{program}'
""")
DEBUG_DELETE_ALLOWED_PROGRAM_FIREWALL_RULE = single_line_message("""
    Delete firewall rule '{rule}' allowing connections for program '{program}'
""")
FAILED_TO_ADD_ALLOWED_PROGRAM_FIREWALL_RULE = single_line_message("""
    Failed to add firewall rule '{rule}'.
    If it is required then add rule allowing connections for program '{program}' manually.
""")
FAILED_TO_DELETE_ALLOWED_PROGRAM_FIREWALL_RULE = single_line_message("""
    Failed to delete firewall rule '{rule}' allowing connections for program '{program}'.
""")
PAEXEC_COMMAND_FAILED = multi_line_message("""
    Failed to execute command with PAExec: {message}.
    Command: {command}
    PAExec exit code: {exit_code}
    PAExec stdout: {stdout}
    PAExec stderr: {stderr}
""")
ISSUE_DATABASE_SERVER_NOT_FOUND = multi_line_message("""
    Failed to find source database server for {db_type} database '{db_name}'.
    Database content will not be transferred to the target panel.

    Most probably that is caused by inconsistency on the source panel.
    Check that:
    1) Database actually exists in the source panel.
    2) Database actually exists on the source database server.
    3) The database server '{db_server_host}' is registered in the source panel.

    Resolve the inconsistency on the source server if any, or copy database manually, or ignore that message
    if database does not actually exist on source.
""")
UNABLE_DECRYPT_PASSWORD = multi_line_message("""
    The encrypted password is specified in the configuration option '{option}' of section '{section}'. Migration with
    encrypted passwords is not supported by CLI interface. Replace the encrypted password by plain one
    (also change the password type to "plain") or set up the plain password in the environment variable '{variable}'.
""")
COMMAND_LIST_FILES_TO_COPY = single_line_message("""
    List files Plesk Migrator is going to copy from source server to target server
""")
COMMAND_REMOVE_SUBSCRIPTIONS_FROM_TARGET = single_line_message("""
    Remove subscriptions specified in migration list from target server
""")
COMMAND_REMOVE_SUBSCRIPTIONS_FROM_QUEUE = single_line_message("""
    Remove subscriptions specified in migration list from queue, stop all operations on them if running
""")
REMOVE_SUBSCRIPTION_FROM_TARGET = single_line_message("""
    Remove subscription '{subscription}' from the target server
""")
LIST_FILES_TO_COPY_ACTION_DESCRIPTION = single_line_message("""
    List files Plesk Migrator is going to copy from source server to target server
""")
LIST_FILES_TO_COPY_ACTION_FAILURE = single_line_message("""
    Failed to list files Plesk Migrator is going to copy from source server to target server
""")
FILES_TO_COPY = single_line_message("""
    Files to copy:
""")
DEBUG_APPLICATION_PATH_MAPPING = multi_line_message("""
    Application path mapping:
    {mapping}
""")
SQL_QUERY = multi_line_message("""
    SQL query to {server}:
    {query}
""")
SQL_QUERY_RESULTS = multi_line_message("""
    SQL query results:
    {results}
""")
NO_SSH_KEY_SUCCEEDED = multi_line_message("""
    Failed to connect to '{server}' with the following SSH key(s): {keys}.
    1) Make sure you have configured key-based authentication to the server '{server}'.
    For example, if you run "ssh {server} echo test", it should print "test" with no password prompt.
    2) If path to SSH keys that Plesk Migrator tried to use is not correct, specify correct one with "ssh-key" option
    in configuration file. Also you may switch to password based authentication. Refer to configuration file examples
    for more details.
""")
NO_SSH_KEYS_AVAILABLE = multi_line_message("""
    No appropriate SSH keys were found for server '{server}'. Specify path to correct private SSH key with
    "ssh-key" option, or switch to password based authentication. Refer to configuration file examples
    for more details.
""")
UNABLE_TO_CONVERT_IDN_NAME = single_line_message("""
    Unable to convert domain name from punycode to unicode. Domain name: {domain_name}
""")
UTIL_WINDOWS_GET_USERNAME_SID = single_line_message("""
    SID of '{username}' is '{sid}'
""")
UTIL_WINDOWS_GET_CURRENT_PROCESS_SID = single_line_message("""
    Current process executed with SID '{sid}'
""")
UNABLE_TO_FIND_BINARY = single_line_message("""
    Failed to find location of '{binary_name}' utility on {server}.
    Make sure it is installed on the server and could be found at any path from PATH environment variable.
""")
CREATE_HOSTING_DESCRIPTION = single_line_message("""
    Creating hosting description
""")
CONVERT_HOSTING_DESCRIPTION = single_line_message("""
    Converting hosting description to local configuration dump '{dump_path}'
""")
CREATE_REMOTE_CONFIGURATION_DUMP = single_line_message("""
    Creating remote configuration dump on the target server '{dump_path}'
""")
FAILED_TO_CREATE_REMOTE_CONFIGURATION_DUMP = multi_line_message("""
    Failed to create the remote configuration dump on the target server. Not all settings may be migrated.
    Error message: {error}
""")
IMPORT_REMOTE_CONFIGURATION_DUMP = single_line_message("""
    Importing remote configuration dump from the target server
""")
FAILED_TO_IMPORT_REMOTE_CONFIGURATION_DUMP = multi_line_message("""
    Failed to import the remote configuration dump from the target server. Not all settings may be migrated.
    Error message: {error}
""")
MERGE_CONFIGURATION_DUMPS = single_line_message("""
    Merging local and remote configuration dumps in '{dump_path}'
""")
FAILED_TO_MERGE_CONFIGURATION_DUMPS = multi_line_message("""
    Failed to merge the local and remote configuration dumps. Not all settings may be migrated.
    Error message: {error}
""")
REMOVE_IMPORTED_CONFIGURATION_DUMP = single_line_message("""
    Remove the imported configuration dump '{dump_name}'
""")
FAILED_TO_REMOVE_IMPORTED_CONFIGURATION_DUMP = multi_line_message("""
    Failed to remove the imported configuration dump '{dump_name}'. Remove it manually on the target server.
    Error message: {error}
""")
ACTION_CHANGE_FTP_LOGIN_DESCRIPTION = single_line_message("""
    Change login of FTP users that do not conform to Plesk rules
""")
ACTION_CHANGE_FTP_LOGIN_FAILURE = single_line_message("""
    Failed to change login of FTP users that do not conform to Plesk rules
""")
FTP_LOGIN_DOES_NOT_CONFORM_PLESK_RULES = single_line_message("""
    Login of FTP user '{login}' does not conform to Plesk rules. It was changed to '{fixed_login}'.
""")
ACTION_COMPOSE_FINAL_REPORT_DESCRIPTION = single_line_message("""
    Compose final migration report
""")
ACTION_COMPOSE_FINAL_REPORT_FAILURE = single_line_message("""
    Failed to compose final migration report
""")
ACTION_PRINT_FINAL_REPORT_DESCRIPTION = single_line_message("""
    Print final migration report
""")
ACTION_PRINT_FINAL_REPORT_FAILURE = single_line_message("""
    Failed to print final migration report
""")
FAILED_TO_LOAD_PLESK_DUMP_SCHEMA = multi_line_message("""
    Failed to load XSD-schema of Plesk dumps from '{path}'.
    That may cause validation errors of migrated dumps and not all settings may be migrated.
    Error message: {error}
""")
ACTION_CHECK_REMOTE_MSSQL_DESCRIPTION = single_line_message("""
    Check connection to remote MSSQL servers
""")
ACTION_CHECK_REMOTE_MSSQL_FAILURE = single_line_message("""
    Failed to check connection to remote MSSQL servers. Migrator will consider that all MSSQL servers have
    RPC agent running and try to copy all MSSQL databases.
""")
ACTION_CHECK_REMOTE_MSSQL_BLOCKING_DESCRIPTION = single_line_message("""
    Check connection to remote MSSQL servers
""")
ACTION_CHECK_REMOTE_MSSQL_BLOCKING_FAILURE = single_line_message("""
    Failed to check connection to remote MSSQL servers
""")
DEBUG_CHECK_IF_SERVERS_ARE_SAME = single_line_message("""
    Check if {source_server} is the same as {target_server} for assimilation scenario
""")
DEBUG_DIFFERENT_SERVERS = single_line_message("""
    Server {source_server} is different than {target_server}
""")
DEBUG_SAME_SERVER = single_line_message("""
    Server {source_server} is the same as {target_server}
""")
ERROR_FAILED_TO_FIND_UNUSED_DATABASE_NAME = single_line_message("""
    Failed to detect if {source_server} is the same as {target_server}: failed to find unused database name to
    perform check. We will consider that these are different servers. If it is the same server and you do
    assimilation of databases, not transfer, migration will fail.
""")
EXECUTE_MSSQL_QUERY = multi_line_message("""
    Execute SQL query from {executor_server} on MSSQL server '{server}'.
    Query: {query}
""")
EXECUTE_MSSQL_QUERY_ARGS = multi_line_message("""
    Execute SQL query from {executor_server} on MSSQL server '{server}'.
    Query: {query}
    Arguments: {arguments}
""")
EXECUTE_MSSQL_QUERY_RESULT = single_line_message("""
    SQL query result: {result}
""")
FAILED_TO_CHECK_MSSQL_SERVER = single_line_message("""
    Internal error when checking connection to external MSSQL server {host}: {reason}. Migrator will consider
    that RPC agent is running there and will try to copy databases from that server.
""")
REMOTE_MSSQL_SERVER_WARNING_CLI = multi_line_message("""
    There are remote MSSQL servers for which we don't have direct access.
    You need to install RPC agent on these servers and open 10155 port in firewall for connections
    from server to which remote MSSQL server is attached to. If some previous version of RPC agent
    is already running on the server, you need to remove it and install the latest version of the agent.
    RPC agent could be taken from that path:
    {rpc_agent_path}

    If that is not done, Plesk Migrator will still try to copy MSSQL databases from that server.
    But there could be problems if remote MSSQL server is not available from target Plesk server.
    Also there could be issues with MSSQL dump format. So it is strongly recommended to install RPC agent
    to these servers.

    ATTENTION: Once you have installed the RPC agent on all servers and configured the firewall,
    restart "check" command to make sure that Plesk Migrator is able to connect to all servers.
    If you want to proceed without RPC agent installation, just continue with "transfer-accounts" command.
""")
REMOTE_MSSQL_SERVER_WARNING_GUI = multi_line_message("""
    There are remote MSSQL servers for which we don't have direct access.
    You need to install RPC agent on these servers and open 10155 port in firewall for connections
    from server to which remote MSSQL server is attached to. If some previous version of RPC agent
    is already running on the server, you need to remove it and install the latest version of the agent.

    If that is not done, Plesk Migrator will still try to copy MSSQL databases from that server.
    But there could be problems if remote MSSQL server is not available from target Plesk server.
    Also there could be issues with MSSQL dump format. So it is strongly recommended to install RPC agent
    to these servers.

    ATTENTION: Once you have installed the RPC agent on all servers and configured the firewall,
    click the "Refresh" button to make sure that Plesk Migrator is able to connect to all servers.
    If you want to proceed without RPC agent installation, click "Continue".
""")
REMOTE_MSSQL_SERVER_BLOCKING_WARNING_CLI = multi_line_message("""
    There are remote MSSQL servers for which we don't have direct access:
    {servers}

    You need to install RPC agent on these servers and open 10155 port in firewall for connections
    from server to which remote MSSQL server is attached to. If some previous version of RPC agent
    is already running on the server, you need to remove it and install the latest version of the agent.
    RPC agent could be taken from that path:
    {rpc_agent_path}

    It is not recommended, but you could avoid installing RPC agent on these servers by one of the following:
    1) Run pre-migration checks with "plesk-migrator check" command, which will make Plesk Migrator to use text dump
    when transferring databases from these servers. But there could be problems if remote MSSQL server is not
    available from target Plesk server. Also there could be issues with MSSQL dump format.
    2) Set option in configuration file (config.ini) of Plesk Migrator to copy all MSSQL databases with text dumps.
    The option is "copy-mssql-content" with value "text" in "[GLOBAL]" section.
    As in the previous way, there could be problems if remote MSSQL server is not available from target Plesk server,
    and there could be issues with MSSQL dump format.
    3) Skipping this check by "--skip-remote-mssql-servers-check" option. In that case Plesk Migrator
    will continue migration, but most probably copy MSSQL databases from that server will fail.
""")
REMOTE_MSSQL_SERVER_DESCRIPTION = single_line_message("""
    MSSQL server "{mssql_server}" connected to "{panel_server}"
""")
EXECUTE_COMMAND_IN_PIPED_MODE = single_line_message("""
    Execute remote command at {server} in piped mode: {command}
""")
DEBUG_PIPED_PACKET_TYPE = single_line_message("""
    Received packet type: {packet_type}
""")
DEBUG_PIPED_DATE_LENGTH = single_line_message("""
    Received data_length: {length}
""")
DEBUG_PIPED_STDOUT = single_line_message("""
    Received stdout packet: {stdout}
""")
DEBUG_PIPED_STDERR = single_line_message("""
    Received stderr packet: {stderr}
""")
COMMAND_IN_PIPED_MODE_FINISHED = single_line_message("""
    Command executed in piped mode finished with exit code {exit_code}
""")
RPC_AGENT_PROTOCOL_INVALID_PACKET = single_line_message("""
    Invalid data was received from RPC agent: invalid packet type {packet_type}
""")
WINDOWS_MAIL_BACKUP_FAILED = multi_line_message("""
    Error when backing up mail messages of mailbox '{mailbox}' on the source server.
    Command: {command}
    Exit code: {exit_code}
    Stderr: {stderr}
""")
WINDOWS_MAIL_RESTORE_FAILED = multi_line_message("""
    Error when restoring mail messages of mailbox '{mailbox}' on the target server.
    Command (mail backup was provided to standard input): {command}
    Exit code: {exit_code}
    Stderr: {stderr}
""")
PIPE_COMMAND_REMOTE_TO_LOCAL_START = multi_line_message("""
    Execute 2 commands on different servers, piping stdout of the first command to stdin of the second command.
    The first command (at {remote_server}, take data from stdout): {command_remote}
    The second command (at local server, put data to stdin): {command_local}
""")
PIPE_COMMAND_REMOTE_TO_LOCAL_FINISH = multi_line_message("""
    Piped command execution results:
    - Exit code on local server: {exit_code_local}
    - Exit code on remote server: {exit_code_remote}
    - Stderr on local server: {stderr_local}
    - Stderr on remote server: {stderr_remote}
""")

FAILED_LOAD_MIGRATION_STATE = single_line_message("""
    Failed to load the migration state. It will be reset.
""")

WEB_RPC_AGENT_DOWNLOAD = single_line_message("""
    Download web RPC agent package from {url}
""")
WEB_RPC_AGENT_REQUEST = single_line_message("""
    Send request to web RPC agent by url '{url}' with json encoded data '{data}'
""")
WEB_RPC_AGENT_RESPONSE = single_line_message("""
    Request to web RPC agent completed with HTTP code '{code}'
""")
WEB_RPC_AGENT_RESPONSE_DATA = single_line_message("""
    Data retrieved via web RPC agent: {data}
""")
WEB_RPC_AGENT_EXCEPTION_RESPONSE_WRONG_HTTP_CODE = single_line_message("""
    Execution of task '{task}' on remote server via web RPC agent failed: HTTP request finished with code '{code}';
    see php error log at that server to investigate an issue
""")
WEB_RPC_AGENT_EXCEPTION_RESPONSE_WRONG_DATA = single_line_message("""
    Execution of task '{task}' on remote server via web RPC agent failed: Unable to decode json data: {error}
""")
WEB_RPC_AGENT_EXCEPTION_TASK_SH_UNCHECKED_WRONG_DATA = single_line_message("""
    Unable to process result sh_unchecked task execution: expected dict with keys 'error_code', 'stdout' and 'stderr'
""")
SQL_QUERY_FAILED = single_line_message("""
    Failed to execute SQL query: {reason}
""")
SQL_QUERY_QUERY = single_line_message("""
    Query: {query}
""")
SQL_QUERY_ARGUMENTS = single_line_message("""
    Arguments: {arguments}
""")
SQL_QUERY_SERVER = single_line_message("""
    Server: {server}
""")
SQL_QUERY_USER = single_line_message("""
    User: {user}
""")
SQL_QUERY_DATABASE = single_line_message("""
    Database: {database}
""")
SQL_QUERY_CONNECTED_FROM = single_line_message("""
    Tried to connect from: {server}
""")
SQL_QUERY_SOLUTION = multi_line_message("""
    Check that:
    1) MSSQL server is running.
    2) SQL server browser is running.
    3) You can connect to the SQL server with MSSQL Management Studio
    (from the server from which migrator tried to connect to the server).
    4) Database (if specified) exists on the server.
    5) Database user (if specified) can login to the server.
    6) There are no firewall rules that could break connection.
    7) SQL query is valid.
""")
FAILED_TO_DECODE_PASSWORD = multi_line_message("""
    Failed to decode the password. It will be reset.
    Error message: {error}
""")
FAILED_TO_REMOVE_DIRECTORY = multi_line_message("""
    Failed to remove directory '{directory}' on '{server}'
""")
AFFECTED_TITLE_SUBSCRIPTIONS = single_line_message("""
    Affected subscriptions:
""")
AFFECTED_TITLE_MSSQL_SERVERS = single_line_message("""
    Affected MSSQL servers:
""")
AFFECTED_TITLE_GENERIC = single_line_message("""
    Affected objects:
""")
SERIALIZE_XML_NONE_ATTRIBUTE = multi_line_message("""
    Warning when serializing XML: attribute '{attr_name}' has empty (None) value.
    Attribute will be skipped when serializing, corresponding options will not be restored during migration.
    XML node: {xml_node}.
""")
SERIALIZE_XML_NONE_NODE = multi_line_message("""
    Warning when serializing XML: node '{tag}' has empty (None) child.
    This child will be skipped when serializing, corresponding options will not be restored during migration.
    Parent XML nodes: {xml_nodes}.
""")
COPY_MESSAGES_OF_MAILBOX = single_line_message("""
    Copy mail messages of mailbox '{mailbox}'
""")

# Load language and UI type overrides. That must be the last line of root messages file.
load_overrides(__name__, locals())
