from parallels.core.migration_list.entities.ip_mapping import SubscriptionIPMapping
from parallels.core.utils.entity import Entity


class SubscriptionMappingInfo(Entity):
    def __init__(self, plan=None, addon_plans=None, owner=None, ipv4=None, ipv6=None):
        self._plan = plan
        self._addon_plans = addon_plans
        self._owner = owner
        self._ips = SubscriptionIPMapping(ipv4, ipv6)

    @property
    def plan(self):
        return self._plan

    @property
    def addon_plans(self):
        return self._addon_plans

    @property
    def owner(self):
        return self._owner

    @property
    def ipv4(self):
        return self._ips.v4

    @property
    def ipv6(self):
        return self._ips.v6

    @property
    def ips(self):
        return self._ips
