
class ReportWriter(object):
    """Interface to append issues to the report"""

    def add_issue(
        self, issue_id, severity, problem_text, solution_text=None,
        affected_objects=None, solution_type=None,
        solution_url=None, solution_url_text=None, solution_component_name=None,
        solution_download_rpc_agent=False
    ):
        """Add issue to report, by issue parameters

        :rtype: None
        """
        raise NotImplementedError()

    def add_issue_obj(self, issue):
        """Add issue to report

        :type issue: parallels.core.reports.model.issue.Issue
        """
        raise NotImplementedError()

    def subtarget(self, type, name):
        """Get child report by type and name

        :type type: str | unicode
        :type name: str | unicode | None
        :rtype: parallels.core.reports.report_writer.ReportWriter
        """
        raise NotImplementedError()