"""Various entities which describe interface of runner object"""

from parallels.core.utils.entity import Entity


class MSSQLConnectionSettings(Entity):
    """Connection settings to execute queries on MSSQL servers"""
    def __init__(self, host, user, password, database=None):
        self._host = host
        self._user = user
        self._password = password
        self._database = database

    @classmethod
    def create_from_server(cls, database_server):
        """Create entity for specified database server

        :type database_server: parallels.core.connections.database_servers.base.DatabaseServer
        :rtype parallels.core.runners.entities.MSSQLConnectionSettings:
        """
        return cls(host=database_server.host(), user=database_server.user(), password=database_server.password())

    @property
    def host(self):
        """Host name (or IP address) of database server, with instance name

        :rtype: str | unicode
        """
        return self._host

    @property
    def user(self):
        """User login

        :rtype: str | unicode
        """
        return self._user

    @property
    def password(self):
        """Password of user

        :rtype: str | unicode
        """
        return self._password

    @property
    def database(self):
        return self._database