import os

from parallels.core import messages
from parallels.core import MigrationError
from parallels.core.registry import Registry
from parallels.core.utils.common import open_no_inherit


class StopMark(object):
    """Way to control shutdown of migrator. If set then migrator will try to shut down as soon as possible"""

    @staticmethod
    def set():
        stop_file = Registry.get_instance().get_context().session_files.get_stop_mark_file()
        with open_no_inherit(stop_file, 'w'):
            pass

    @staticmethod
    def is_set():
        context = Registry.get_instance().get_context()
        if context is None:
            return False

        session_files = context.session_files
        if session_files is None:
            return False

        stop_file = session_files.get_stop_mark_file()

        return os.path.isfile(stop_file)

    @staticmethod
    def remove():
        stop_file = Registry.get_instance().get_context().session_files.get_stop_mark_file()
        os.remove(stop_file)


class MigratorInterruptException(MigrationError):
    def __init__(self):
        super(MigratorInterruptException, self).__init__(messages.INTERRUPT_EXCEPTION)
