"""Deploy MySQL clients to Windows servers"""

import parallels.core
from parallels.core.utils.migrator_utils import get_package_extras_file_path


def deploy_mysqldump(server):
    """Deploy mysqldump.exe to the server and return path to it

    :type server: parallels.core.connections.source_server.SourceServer
    :rtype: str
    """
    mysqldump_path = server.get_session_file_path('mysqldump.exe')
    extras_mysqldump_path = get_package_extras_file_path(parallels.core, 'mysqldump.exe')
    with server.runner() as runner:
        runner.upload_file(extras_mysqldump_path, mysqldump_path)

    return mysqldump_path


def deploy_mysql_client(server):
    """Deploy mysql.exe to the server and return path to it

    :type server: parallels.core.connections.source_server.SourceServer
    :rtype: str
    """

    mysql_path = server.get_session_file_path('mysql.exe')
    extras_mysql_path = get_package_extras_file_path(
        parallels.core, "mysql.exe"
    )
    with server.runner() as runner:
        runner.upload_file(extras_mysql_path, mysql_path)

    return mysql_path