from parallels.core.cli.common_cli import Command, CommandTypes
from parallels.core.cli.extension import CLIExtensionBase
from parallels.plesk import messages


class CLIExtension(CLIExtensionBase):
    """Command line migrator interface extension for target Plesk panel"""

    def get_additional_commands(self, common_options):
        """
        :type common_options: parallels.core.cli.migration_cli.CommonMigrationOptions
        :rtype: list[parallels.core.cli.common_cli.Command]
        """
        return [
            Command(
                'adjust-applications', CommandTypes.INTERNAL,
                messages.COMMAND_FIX_APPLICATIONS,
                lambda runner: runner.run_entry_point('adjust-applications'),
                common_options.post_migration_options_list
            ),
        ]