from parallels.plesk import messages


def parse_bool_value(value, invalid_default=None):
    """Parse boolean value from hosting description file

    If value is invalid, function will throw exception, unless
    invalid_default parameter is specified.

    :type value: str | unicode | bool
    :type invalid_default: bool
    :rtype: bool
    """
    if value in (1, True, '1', 'on', 'true', 'enabled'):
        return True
    elif value in (0, False, '0', 'off', 'false', 'disabled'):
        return False
    else:
        if invalid_default is None:
            raise Exception(
                messages.INVALID_BOOLEAN_VALUE % value
            )
        else:
            return invalid_default


def create_dict(**kwargs):
    return {key: value for key, value in kwargs.iteritems() if value is not None}


def safe_get_list(data, key):
    """Read attribute from a dictionary, which is expected to be a list. If it is not - return empty list

    :type data: dict
    :type key: str | unicode
    :rtype: list | tuple
    """
    if key not in data:
        return []
    else:
        if type(data[key]) is list or type(data[key]) is tuple:
            return data[key]
        else:
            return []


def safe_get_dict(data, key):
    """Read attribute from a dictionary, which is expected to be a dictionary. If it is not - return empty dictionary

    :type data: dict
    :type key: str | unicode
    :rtype: dict
    """
    if key not in data:
        return {}
    else:
        if type(data[key]) is dict:
            return data[key]
        else:
            return {}


def safe_get_struct(data, key):
    """Read attribute from a dictionary, which is expected to be a dictionary. If it is not - return None

    :type data: dict
    :type key: str | unicode
    :rtype: dict | None
    """
    if key not in data:
        return None
    else:
        if type(data[key]) is dict:
            return data[key]
        else:
            return None
