from parallels.core.utils.plesk_utils import get_plesk_db_connection_args
from parallels.core.utils.mysql import query as mysql_query
from parallels.plesk.connections.target_server import PleskTargetServer
from parallels.plesk.source.plesk.server import PleskSourceServer


def db_query(plesk_server, query_str, query_args=None):
    """Perform given query to database of given Plesk

    :type plesk_server: parallels.core.connections.plesk_server.PleskServer
    :type query_str: str
    :type query_args: dict
    """
    if isinstance(plesk_server, PleskTargetServer):
        connection_args = get_plesk_db_connection_args(plesk_server)
        return mysql_query(connection_args, query_str, query_args, True)
    elif isinstance(plesk_server, PleskSourceServer):
        return plesk_server.dump_agent.execute_sql(query_str, query_args)
    else:
        raise NotImplementedError()
