# coding=utf-8
from parallels.core.utils.message_utils import single_line_message, multi_line_message, load_overrides

LOG_EXCEPTION = single_line_message("""
    Exception:
""")
UNABLE_TO_GET_DUMP_PATH = single_line_message("""
    Unable to retrieve path to Plesk configuration dump "%s"
""")
ACTION_COPY_MAIL_MESSAGES_FAILURE = single_line_message("""
    Failed to copy mail messages of subscription
""")
ACTION_RESTORE_DATABASES_FROM_DUMPS_DESCRIPTION = single_line_message("""
    Restore databases from dump files
""")
ACTION_RESTORE_DATABASES_FROM_DUMPS_FAILURE = single_line_message("""
    Failed to restore databases of subscription from dump files
""")
ACTION_CREATE_DUMP_FAILURE = single_line_message("""
    Failed to create Plesk configuration dump out of hosting description file
""")
ACTION_CREATE_DUMP_DESCRIPTION = single_line_message("""
    Create Plesk configuration dump out of hosting description file
""")
LOG_CREATE_DUMP = single_line_message("""
    Create Plesk configuration dump for '%s'
""")
LOG_RESTORE_DB_DUMP = single_line_message("""
    Restore database dump for {db_type} database '{db_name}' from '{dump}'
""")
DB_WILL_NOT_BE_RESTORED_NO_DB_SERVER = single_line_message("""
    Database '{db_name}' of {db_type} will not be restored from dump
    as no {db_type} DB server is assigned to subscription
""")
ACTION_COPY_MAIL_MESSAGES = single_line_message("""
    Copy mail messages
""")
INVALID_FORMAT = single_line_message("""
    Invalid format: %s"
""")
UNSUPPORTED_SOURCE_WEB_PATH_TYPE = single_line_message("""
    Unsupported source web path type
""")
ACTION_COPY_LOCAL_WEB_FILES = single_line_message("""
    Put web files to domain directories
""")
FAIL_TO_COPY_LOCAL_WEB_FILES = single_line_message("""
    Failed to put web files to domain directories
""")
ACTION_COPY_LOCAL_MAIL_FILES = single_line_message("""
    Put mail messages to domain directories
""")
FAIL_TO_COPY_LOCAL_MAIL_FILES = single_line_message("""
    Failed to put mail messages to domain directories
""")
COMMAND_CREATE_DUMP_FROM_HOSTING_DESCRIPTION = single_line_message("""
    Create Plesk configuration dump out of hosting description file (YAML/JSON/XML)
""")
COMMAND_VALIDATE_HOSTING_DESCRIPTION = single_line_message("""
    Validate hosting description files specified in tool's configuration file
""")
SOURCE_HOSTING_DESCRIPTION_FILE_OPTION = single_line_message("""
    Path to source hosting description file
""")
SOURCE_HOSTING_DESCRIPTION_FORMAT_OPTION = single_line_message("""
    Format of source hosting description file: YAML, JSON or XML (default is YAML)
""")
TARGET_DUMP_FILE_OPTION = single_line_message("""
    Path to target full Plesk configuration dump file
""")
ACTION_FAILED_VALIDATE_HOSTING_DESCRIPTION = single_line_message("""
    Failed to validate hosting description file
""")
ACTION_DESCRIPTION_VALIDATE_HOSTING_DESCRIPTION = single_line_message("""
    Validate hosting description file
""")
VALIDATION_FAILED = multi_line_message("""
    Hosting description file '{file}' validation failed:
    {errors}
""")
VALIDATION_FAILED_MIGRATION_STOPPED = multi_line_message("""
    Hosting description file '{file}' validation failed:
    {errors}

    Migration will be stopped. To continue migration fix the errors listed above.
    For details on hosting description format refer to the official migration tool's documentation.

    If you are sure that these errors won't affect migration, you could try
    to specify 'validation-mode: warn' or 'validation-mode: skip' in corresponding source section of migrator's
    configuration file to ignore these errors and force migrator to proceed.
""")
VALIDATION_PASSED = multi_line_message("""
    Hosting description file '{file}' successfully passed validation
""")
FIX_WEB_CONTENT_PERMISSIONS_ACTION_DESCRIPTION = single_line_message("""
    Fix web content permissions
""")
FIX_WEB_CONTENT_PERMISSIONS_ACTION_FAILURE = single_line_message("""
    Failed to fix web content permissions
""")
FAILED_TO_FIND_SUBSCRIPTION_IN_DUMP = single_line_message("""
    Failed to find subscription '%s' in hosting description file
""")

# Load language and UI type overrides. That must be the last line of root messages file.
load_overrides(__name__, locals())
