from parallels.core.migrated_subscription import MigratedSubscription
from parallels.core.utils.common import cached


class CustomPanelMigratedSubscription(MigratedSubscription):
    @property
    @cached
    def hosting_description(self):
        """Get hosting description of specified subscription

        Returns object model over part of the hosting description file which is related to that subscription.

        :rtype: parallels.plesk.hosting_description.model.HostingDescriptionSubscription | None
        """
        if self._migrator.global_context.conn.has_hosting_description_config(self.model.source):
            hosting_description = self._migrator.global_context.get_hosting_description(self.model.source)
            return hosting_description.get_subscription(self.name)
        else:
            return None

    @property
    def mail_source_server_id(self):
        if (
            self.hosting_description is not None and
            self.hosting_description.mail_service is not None and
            self.hosting_description.mail_service.mail_server is not None
        ):
            return self.hosting_description.mail_service.mail_server
        else:
            return self.model.source
