# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package Storage::ContentNameCreator;

use strict;

use Storage::FileNameCreator;

sub new {
  my $self = {};
  bless( $self, shift );
  $self->_init(@_);
  return $self;
}

sub _init{
  my( $self ) = @_;
  $self->{fnamecreator} = Storage::FileNameCreator->new();
}

sub getPhostingDstFile {
  my ($self, $type, $domainName) = @_;
  my $dir = "/domains/".$domainName."/phosting";
  return  $self->{fnamecreator}->getFileName($dir, '', '', $type);
}

sub getSubdomainDstFile {
  my ($self, $type, $domainName, $subdomainName) = @_;
  my $dir = "/domains/".$domainName."/phosting/subdomain";
  return $self->{fnamecreator}->getFileName($dir, '', '', $subdomainName."_".$type);
}

sub getDbDstFile {
  my ($self, $type, $domainName, $dbName) = @_;
  my $dir = "/domains/".$domainName."/databases/".$dbName;
  return $self->{fnamecreator}->getFileName($dir, '', '', $type);
}

sub getWebUserDstFile {
  my ($self, $domainName, $wuName) = @_;
  my $dir = "/domains/".$domainName."/phosting/";
  return $self->{fnamecreator}->getFileName($dir, '', '', $wuName);
}

sub getMailnameDstFile {
  my ($self, $mailname, $domainName) = @_;
  my $dir = "/domains/".$domainName."/mailnames";
  return $self->{fnamecreator}->getFileName($dir, '', '', "mailname_" . $mailname);
}

sub getMaillistDstFile {
  my ($self, $listname, $domainName) = @_;
  my $dir = "/domains/".$domainName;
  return $self->{fnamecreator}->getFileName($dir, '', '', "maillist_". $listname);
}


1;