# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package XPath;

use XmlNode;

sub SelectArray {
  my ($xmlNode, $selectsPtr, $code) = @_;

  unless ( ( ref($code) =~ /CODE/ ) &&
           ( ref($xmlNode) =~ /XmlNode/ ) &&
           ( ref($selectsPtr) =~ /ARRAY/ ) ) {
    die "Invalid parameters in ". (caller(0))[3];
  }

  my @selects = @{$selectsPtr};
  my $select = pop @selects;
  my @children = $xmlNode->getChildren( $select );
  foreach my $childNode ( @children ) {
    if ( @selects ) {
      SelectArray($childNode, \@selects, $code);
    }
    else {
      $code->($childNode);
    }
  }
}

sub Select ($$&) {
  my ($xmlNode, $select, $code) = @_;

  unless ( ( ref($code) =~ /CODE/ ) &&
           ( ref($xmlNode) =~ /XmlNode/ ) &&
           ( $select ne '') ) {
    die "Invalid parameters in ". (caller(0))[3];
  }

  my @selects = reverse( split( /\//, $select) );
  SelectArray($xmlNode, \@selects, $code);
}


1;
