from parallels.core.global_context import GlobalMigrationContext
from parallels.core.utils.common import cached


class LegacyGlobalMigrationContext(GlobalMigrationContext):
    @property
    @cached  # to avoid re-deploying, have a single PMM agent object
    def dump_agent(self):
        agent = self._deploy_dump_agent()
        self.deployed_dump_agents.append(agent)
        return agent

    @property
    def settings(self):
        raise NotImplementedError()

    def _deploy_dump_agent(self):
        """Deploy dump agent for this legacy panel"""
        raise NotImplementedError()