from parallels.core.utils.restore_hosting_utils import restore_hosting_settings_lock
from parallels.plesk.source.plesk import messages
import logging

from parallels.core.actions.base.subscription_action import SubscriptionAction
from parallels.core.utils import subscription_filter
from parallels.core.utils.common import ilen

logger = logging.getLogger(__name__)


class ResetPermissions(SubscriptionAction):
    """Reset file permissions on Windows like Plesk restore does"""
    
    def get_description(self):
        return messages.ACTION_RESET_PERMISSIONS_DESCRIPTION

    def get_failure_message(self, global_context, subscription):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        """
        return messages.ACTION_RESET_PERMISSIONS_FAILURE % subscription.name

    def is_critical(self):
        """If action is critical or not

        If action is critical and it failed for a subscription, migration tool
        won't run the next operations for the subscription.

        :rtype: bool
        """
        return False

    def filter_subscription(self, global_context, subscription):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        :rtype: bool
        """
        return (
            subscription_filter.windows_with_virtual_hosting(subscription) and
            # Check that the action is already executed. This action is executed a long time
            # for subscriptions with huge count of folders. So we skip it repeat runs.
            subscription_filter.reset_permissions(subscription, global_context)
        )

    def run(self, global_context, subscription):
        """
        :type subscription: parallels.core.migrated_subscription.MigratedSubscription
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """

        sysuser_name = subscription.converted_dump.get_phosting_sysuser_name()
        if sysuser_name is not None:
            if ilen(subscription.raw_dump.iter_sites()) > 1:
                # there are subdomains or/and addon domains
                logger.debug(messages.UPDATE_WEBSPACE_SUBDOMAINS_SECURITY, subscription.name_idn)
                with restore_hosting_settings_lock:
                    global_context.hosting_repository.subdomain.update_security(subscription.name)

        logger.debug(messages.REPAIR_PERMISSIONS_FOR_SUBSCRIPTION, subscription.name_idn)
        with restore_hosting_settings_lock:
            global_context.hosting_repository.subscription.update_security(subscription.name)
