from parallels.core.utils.entity import Entity


class Domain(Entity):
    """
    By domain here we mean webspace or subscription in terms of recent Plesk versions,
    but not addon domains, subdomains or aliases
    """

    def __init__(self, domain_id, name, owner_id, vendor_login):
        self._domain_id = domain_id
        self._name = name
        self._owner_id = owner_id
        self._vendor_login = vendor_login

    @property
    def domain_id(self):
        """
        :rtype: str | unicode
        """
        return self._domain_id

    @property
    def name(self):
        """
        :rtype: str | unicode
        """
        return self._name

    @property
    def owner_id(self):
        """
        :rtype: str | unicode
        """
        return self._owner_id

    @property
    def vendor_login(self):
        """
        :rtype: str | unicode
        """
        return self._vendor_login
