from parallels.core.utils.entity import Entity


class ServicePermission(Entity):
    def __init__(
        self, service_permission_id, service_instance_id, service_provider_id, permission_code, permission_class
    ):
        self._service_permission_id = service_permission_id
        self._service_instance_id = service_instance_id
        self._service_provider_id = service_provider_id
        self._permission_code = permission_code
        self._permission_class = permission_class

    @property
    def service_permission_id(self):
        """
        :rtype: str | unicode
        """
        return self._service_permission_id

    @property
    def service_instance_id(self):
        """
        :rtype: str | unicode
        """
        return self._service_instance_id

    @property
    def service_provider_id(self):
        """
        :rtype: str | unicode
        """
        return self._service_provider_id

    @property
    def permission_code(self):
        """
        :rtype: str | unicode
        """
        return self._permission_code

    @property
    def permission_class(self):
        """
        :rtype: str | unicode
        """
        return self._permission_class
