from parallels.core.actions.base.compound_action import CompoundAction
from parallels.core.workflow.extension import WorkflowExtensionBase
from parallels.plesk.source.web.actions.content.web.copy_content import CopyWebContentViaFtp
from parallels.plesk.source.web.actions.content.web.fix_permissions import FixPermissions
from parallels.plesk.source.web.actions.content.database.copy_database_content import CopyDatabaseContent
from parallels.plesk.source.web.actions.dump.validate_hosting_description import ValidateHostingDescriptionFiles
from parallels.plesk.actions.dump.create_dump_from_hosting_description import CreateDumpFromHostingDescription


class WorkflowExtension(WorkflowExtensionBase):
    def extend_workflow(self, workflow):
        workflow.get_shared_action('fetch-source').insert_action(
            'validate-hosting-description-files', ValidateHostingDescriptionFiles()
        )
        workflow.get_shared_action('fetch-source').insert_action(
            'create-dump-from-hosting-description', CreateDumpFromHostingDescription()
        )
        workflow.get_shared_action('copy-web-files').insert_action(
            'copy-files-via-ftp', CopyWebContentViaFtp()
        )
        workflow.get_shared_action('sync-web-content-assets').insert_action(
            'fix-permissions', FixPermissions()
        )
        workflow.replace_shared_action('copy-db-content', CompoundAction())
        workflow.get_shared_action('copy-db-content').insert_action(
            'copy-db-from-servers', CopyDatabaseContent()
        )
