from collections import namedtuple

from parallels.plesk.utils.xml_rpc.expand.core import parse_result_set
from parallels.core.utils.common.xml import elem, text_elem

PleskCentralizedDbServerData = namedtuple('PleskCentralizedDbServerData', ('host', 'is_local'))


class PleskCentralizedDbServerOperator(object):
    class Get(namedtuple('Get', ('filter'))):
        class FilterAll(object):
            def inner_xml(self): return []

        class FilterByPleskServerId(namedtuple('FilterByPleskServerId', ('ids',))):
            def inner_xml(self):
                return [text_elem('server_id', plesk_server_id) for plesk_server_id in self.ids]

        operator_name = 'exp_plesk_centralized_db'
        operation_name = 'get'

        def inner_xml(self):
            return [
                elem('filter', self.filter.inner_xml()),
            ]
            
        @classmethod
        def parse(cls, elem):
            return parse_result_set(elem, cls._parse_data)

        @classmethod
        def _parse_data(cls, elem):
            return PleskCentralizedDbServerData(
                host=elem.findtext('data/host'),
                is_local=(elem.find('data/local') is not None)
            )