from collections import namedtuple

from parallels.plesk.utils.xml_rpc.expand.core import parse_result_set
from parallels.core.utils.common.xml import elem, text_elem


class PleskDnsOperator(object):
    class Refresh(namedtuple('Refresh', ('filter'))):
        class FilterByServerId(namedtuple('ServerId', ('server_id'))):
            def inner_xml(self):
                return [text_elem('server_id', self.server_id)]

        operator_name = 'exp_plesk_dns'
        operation_name = 'refresh'

        def inner_xml(self):
            return [
                elem('filter', self.filter.inner_xml()),
            ]
            
        @classmethod
        def parse(cls, elem):
            return parse_result_set(elem, cls._parse_data)

        @classmethod
        def _parse_data(cls, elem):
            pass