from collections import namedtuple
from .. import core

IpAddressInfo = namedtuple('IpAddressInfo', ('ip_address', 'ip_type', 'public_ip_address'))


class IpOperator(object):
    class Get(core.operation('Get', [])):
        operator_name = 'ip'
        operation_name = 'get'
        min_api_version = '1.4.1.2'
        max_api_version = None

        def inner_xml(self):
            return []

        @classmethod
        def parse(cls, elem):
            return core.Result.parse(elem.find('result'), cls._parse_data)
        
        @classmethod
        def _parse_data(cls, elem):
            return [
                IpAddressInfo(
                    ip_address=ip_node.findtext('ip_address'), 
                    ip_type=ip_node.findtext('type'),
                    public_ip_address=ip_node.findtext('public_ip_address'),
                ) for ip_node in elem.findall('addresses/ip_info')
            ]