import logging
import posixpath

from parallels.utils import obj
from parallels.plesks_migrator.actions.content.web.copy_unix_content import CopyUnixWebContentBase

logger = logging.getLogger(__name__)


class CpanelCopyUnixWebContent(CopyUnixWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		"""Make a list of source server directories to be transferred.

		Return:
			A list of (source directory -> destination directory) mappings

		"""
		sysuser = subscription.raw_backup.get_phosting_sysuser_name()
		source_vhosts_path = global_context.pmm_agent.get_vhosts_dir(sysuser)
		vhost_name = subscription.name.encode('idna')

		tocopy = [
			obj(
				source_subdir=posixpath.join(source_vhosts_path),
				target_subdir=posixpath.join(vhost_name),
				exclude=['/mail', '/.*'],
				skip_if_source_not_exists=False
			)
		]

		return tocopy
