from parallels.utils import cached
from parallels.common.connections.connections import Connections
from parallels.cpanel_migrator.server import CpanelSourceServer
from parallels.cpanel_migrator import settings


class MigratorConnections(Connections):
	def __init__(self, config, target_panel):
		super(MigratorConnections, self).__init__(config, target_panel)
		self.source_settings = settings.init(config)
		self.cpanel = CpanelSourceServer('cpanel', self.source_settings)

	def get_information_servers(self):
		return {'cpanel': self.cpanel.node_settings}

	@cached
	def get_source_node(self, node_id):
		return CpanelSourceServer(node_id, self.get_information_servers()[node_id])
