from plesk_mail_migrator.utils.cmd_args.cmd_args_parser import CmdArgsParser


class PrefixedCmdArgsParser(CmdArgsParser):
    """ Class to get prefixed command-line arguments.

    For example if prefix is set to "source", then for request of arguments "param"
    this class will return argument specified by "--source-param" command line option."""

    def __init__(self, cmd_args_parser, prefix):
        """Class constructor

        :type cmd_args_parser: plesk_mail_migrator.utils.cmd_args.cmd_args_parser.CmdArgsParser
        :type prefix: str
        """
        self._cmd_args_parser = cmd_args_parser
        self._prefix = prefix

    def get(self, arg_name):
        return self._cmd_args_parser.get('%s-%s' % (self._prefix, arg_name))

    def contains(self, arg_name):
        return self._cmd_args_parser.contains('%s-%s' % (self._prefix, arg_name))

    def get_full_param_name(self, short_name):
        return "--%s-%s" % (self._prefix, short_name)
