
class IMAPFlag(object):
    def __init__(self, name, enum_number, imap_string, maildir_string):
        self._name = name
        self._enum_number = enum_number
        self._imap_string = imap_string
        self._maildir_string = maildir_string

    @property
    def name(self):
        return self._name

    @property
    def enum_number(self):
        return self._enum_number

    @property
    def imap_string(self):
        return self._imap_string

    @property
    def maildir_string(self):
        return self._maildir_string

    def __repr__(self):
        return "IMAPFlag('%s')" % self._name


class IMAPFlags(object):
    all_flags = [
        IMAPFlag('seen', 0x01, r'\Seen', 'S'),
        IMAPFlag('answered', 0x02, r'\Answered', 'R'),
        IMAPFlag('flagged', 0x04, r'\Flagged', 'F'),
        IMAPFlag('draft', 0x08, r'\Draft', 'D'),
        IMAPFlag('deleted', 0x10, r'\Deleted', 'T'),
        IMAPFlag('forwarded', 0x20, r'$Forwarded', None),
        IMAPFlag('mdn-sent', 0x40, r'$MDNSent', None)
    ]

    def __init__(self):
        self._flags = set()

    def add_flag(self, flag):
        self._flags.add(flag)

    def is_set(self, flag):
        return flag in self._flags

    def __repr__(self):
        return 'IMAPFlags([%s])' % (', '.join([repr(f) for f in self._flags]))
