
class BaseProvider(object):
    def get_title(self):
        """Get title of provider to print in logging messages"""
        raise NotImplementedError()

    def get_provider_id(self):
        """Get ID of provider, that is used in command-line interface to specify that provider"""
        raise NotImplementedError()

    def get_parameters(self):
        """Get parameters of provider - options that could be customized

        :rtype: list[plesk_mail_migrator.core.provider.provider_parameter.ProviderParameter]
        """
        return []

    def get_parameter_value(self, parameter_name):
        for parameter in self.get_parameters():
            if parameter.name == parameter_name:
                return parameter.value

        raise Exception("Failed to get parameter '%s': parameter with such name does not exists" % parameter_name)
