from contextlib import contextmanager

import errno

from plesk_mail_migrator.utils.exceptions import MailMigratorException


@contextmanager
def open_wrap_not_exists(filename, error_message):
    """Try to open file and if it does not exists - raise exception with specified error message.

    Returns the same data as built-in 'open' function.

    :type filename: str
    :type error_message: str
    """
    try:
        with open(filename) as fp:
            yield fp
    except IOError as e:
        if e.errno == errno.ENOENT:
            raise MailMigratorException(error_message)
        else:
            raise
