#!/usr/bin/perl
# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.

# Execute SQL query on MySQL database.
#
# The query and connection settings are specified by STDIN. It must be a JSON with the following structure:
# {
#   "connection_settings": {
#       "user": "admin",
#       "password": "123qwe",
#       "database": "mydatabase",
#       "host": "localhost",
#       "socket": "/var/lib/mysql/mysql.sock"
#   },
#   "query": "SELECT * FROM clients WHERE login = ?",
#   "query_args": [
#       "john"
#   ]
# }
#
# Result is returned to STDOUT in JSON format:
# * On success it looks in the following way:
#       {
#           "status": 'ok',
#           "rowset": [
#               {"id": "1", "name": "one", ...},
#               ...
#           ]
#       }
# * On failure it looks in the following way:
#       {
#           "status": "error",
#           "message": "Failed to execute query..."
#       }
#
# Additionally you could specify type of backend used to execute queries by "backend" option in "connection_settings".
# Available backends:
# - "dbi" - execute queries with Perl DBI native library (preferred - fast and secure way)
# - "shell" - execute queries with "mysql" utility
# If backend is not specified, the tool will try to autodetect it by probing "dbi" backend first, and if it does
# not work for any reason (for example, by absence of DBI library for MySQL), the tool will try to execute query with
# "mysql" utility.

use strict;

use lib 'thirdparties';
use lib 'lib';

use MySQLAgent::MySQLAgent

MySQLAgent::MySQLAgent::main();
