<?php

class FileUtils {
    public static function get_file_paths($base_path, $is_recursive = false) {
        $handle = self::open_dir($base_path);
        if (is_null($handle)) {
            return array();
        }
        $file_paths = array();
        while (false !== ($item = readdir($handle))) {
            if ($item == '.' || $item == '..') {
                continue;
            }
            $item_path = $base_path . DIRECTORY_SEPARATOR . $item;
            if (is_file($item_path)) {
                $file_paths[] = $item_path;
                continue;
            }
            if (!$is_recursive) {
                continue;
            }
            $file_paths = array_merge($file_paths, self::get_file_paths($item_path, $is_recursive));
        }
        return $file_paths;
    }

    public static function get_dir_tree($base_path) {
        $handle = self::open_dir($base_path);
        if (is_null($handle)) {
            // Failed to open the directory - try to open directories near the agent directory.
            // For example, if requested base path was
            //   C:\inetpub\vhosts\example.com
            // and web RPC agent was deployed to
            //   C:\inetpub\vhosts\example.com\a\b\c
            // we will try here to list directories:
            //   C:\inetpub\vhosts\example.com\a
            //   C:\inetpub\vhosts\example.com\a\b
            //   C:\inetpub\vhosts\example.com\a\b\c
            $script_dir = dirname($_SERVER["SCRIPT_FILENAME"]);
            if (stripos($script_dir, $base_path) === 0) {
                $path_elements = explode(
                    DIRECTORY_SEPARATOR, trim(substr($script_dir, strlen($base_path)), DIRECTORY_SEPARATOR)
                );
                $tree = array();
                $root_tree = &$tree;
                $full_subpath = rtrim($base_path, DIRECTORY_SEPARATOR);
                foreach ($path_elements as $path_element) {
                    $full_subpath .=  DIRECTORY_SEPARATOR . $path_element;
                    $handle = self::open_dir($full_subpath);
                    if ($handle) {
                        closedir($handle);
                        $tree[] = array($path_element => self::get_dir_tree($full_subpath));
                        return $root_tree;
                    } else {
                        $subtree = array();
                        $tree[] = array($path_element => &$subtree);
                        $tree = &$subtree;
                    }
                }
            } else {
                return array();
            }
        }
        $tree = array();
        while (false !== ($item = readdir($handle))) {
            if ($item == '.' || $item == '..') {
                continue;
            }
            $item_path = $base_path . DIRECTORY_SEPARATOR . $item;
            if (is_file($item_path)) {
                $tree[] = $item;
                continue;
            }
            $tree[] = array($item => self::get_dir_tree($item_path));
        }
        return $tree;
    }

    private static function open_dir($base_path) {
        if (!is_dir($base_path)) {
            return null;
        }
        $handle = opendir($base_path);
        if ($handle === false) {
            return null;
        }
        return $handle;
    }
}