<?php

/**
 *   @property $cmd
 */
class ExecTask extends Task {
    /**
     * Execute given command
     *
     * @return array
     */
    public function run() {
        $exit_code = 0;
        $stdout = array();
        if ($this->_isExecDisabled()) {
            throw new TaskException("Failed to execute command: 'exec' function is disabled in PHP configuration");
        }
        exec($this->cmd . ' 2>&1', $stdout, $exit_code);
        return array('exit_code' => $exit_code, 'stdout' => implode(PHP_EOL, $stdout), 'stderr' => '');
    }

    /**
     * Check if "exec" function is disabled in PHP configuration.
     *
     * @return bool
     */
    private function _isExecDisabled()
    {
        try {
            $disabled_functions_option = ini_get('disable_functions');
            if (!$disabled_functions_option) {
                return false;
            }
            $disabled_functions = explode(',', $disabled_functions_option);
            foreach ($disabled_functions as $disabled_function) {
                if (trim($disabled_function) === 'exec') {
                    return true;
                }
            }
        } catch (Exception $e) {
            // ignore any errors
        }
        return false;
    }
}