<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

class Logger {
    const CRLF = "\r\n";

    const TYPE_ERROR = 1;
    const TYPE_WARNING = 2;
    const TYPE_INFO = 3;
    const TYPE_DEBUG = 4;

    private $_handle = null;

    public function __construct() {
        try {
            $this->_handle = fopen('log', 'w');
        } catch (Exception $e) {
            // logging should not block task execution, so skip any exceptions
        }
    }

    public function log($message, $type) {
        $type_label = 'DEBUG';
        switch ($type) {
            case self::TYPE_ERROR:
                $type_label = 'ERROR';
                break;
            case self::TYPE_WARNING:
                $type_label = 'WARNING';
                break;
            case self::TYPE_INFO:
                $type_label = 'INFO';
                break;
        }
        if (is_null($this->_handle)) {
            return;
        }
        $date = date('Y-m-d H:i:s');
        try {
            fwrite($this->_handle, '[' . $date . '][' . $type_label . '] ' . $message . self::CRLF);
        } catch (Exception $e) {
            // logging should not block task execution, so skip any exceptions
        }
    }

    public function error($message) {
        $this->log($message, self::TYPE_ERROR);
    }

    public function warning($message) {
        $this->log($message, self::TYPE_WARNING);
    }

    public function info($message) {
        $this->log($message, self::TYPE_INFO);
    }

    public function debug($message) {
        $this->log($message, self::TYPE_DEBUG);
    }
}