<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

class Registry {
    private static $_instance = null;

    /**
     * @var Logger
     */
    private $_logger = null;

    /**
     * @var PhpFunctions
     */
    private $_php_functions = null;

    /**
     * @return Registry
     */
    public static function get_instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new Registry();
        }
        return self::$_instance;
    }

    /**
     * @param $logger Logger
     * @return Logger
     */
    public function set_logger($logger) {
        return $this->_logger = $logger;
    }

    /**
     * @return Logger
     */
    public function get_logger() {
        return $this->_logger;
    }

    /**
     * @param $php_functions PhpFunctions
     * @return PhpFunctions
     */
    public function set_php_functions($php_functions) {
        return $this->_php_functions = $php_functions;
    }

    /**
     * @return PhpFunctions
     */
    public function get_php_functions() {
        return $this->_php_functions;
    }
}