<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

/**
 * @property $base_path
 */
class GetDirTreeTask extends Task {
    /**
     * Retrieve list of file names in given directory
     *
     * @param ResultEncoder $resultEncoder
     */
    public function run(ResultEncoder $resultEncoder) {
        $resultEncoder->startList();
        self::_get_dir_tree_items($resultEncoder, $this->base_path);
        $resultEncoder->endList();
    }

    private static function _get_dir_tree_items(ResultEncoder $resultEncoder, $base_path) {
        $phpFunctions = Registry::get_instance()->get_php_functions();

        $handle = FileUtils::open_dir($base_path);

        if (is_null($handle)) {
            // Failed to open the directory - try to open directories near the agent directory.
            // For example, if requested base path was
            //   C:\inetpub\vhosts\example.com
            // and web RPC agent was deployed to
            //   C:\inetpub\vhosts\example.com\a\b\c
            // we will try here to list directories:
            //   C:\inetpub\vhosts\example.com\a
            //   C:\inetpub\vhosts\example.com\a\b
            //   C:\inetpub\vhosts\example.com\a\b\c
            $script_dir = dirname($_SERVER["SCRIPT_FILENAME"]);
            if (stripos($script_dir, $base_path) === 0) {
                $path_elements = explode(
                    DIRECTORY_SEPARATOR, trim(substr($script_dir, strlen($base_path)), DIRECTORY_SEPARATOR)
                );
                $full_subpath = rtrim($base_path, DIRECTORY_SEPARATOR);

                $cnt = 0;
                foreach ($path_elements as $path_element) {
                    $resultEncoder->startDictionary();
                    $cnt++;
                    $resultEncoder->startDictionaryValue($path_element);
                    $resultEncoder->startList();

                    $full_subpath .=  DIRECTORY_SEPARATOR . $path_element;
                    $handle = FileUtils::open_dir($full_subpath);
                    if ($handle) {
                        $phpFunctions->closedir($handle);
                        self::_get_dir_tree_items($resultEncoder, $full_subpath);
                        break;
                    }
                }

                for ($i = 0; $i < $cnt; $i++) {
                    $resultEncoder->endList();
                    $resultEncoder->endDictionary();
                }
            }

            return;
        }

        while (false !== ($item = $phpFunctions->readdir($handle))) {
            if ($item == '.' || $item == '..') {
                continue;
            }
            $item_path = $base_path . DIRECTORY_SEPARATOR . $item;
            if ($phpFunctions->is_file($item_path)) {
                $resultEncoder->startListValue();
                $resultEncoder->addString($item);
                continue;
            } else {
                $resultEncoder->startListValue();
                $resultEncoder->startDictionary();
                $resultEncoder->startDictionaryValue($item);
                $resultEncoder->startList();
                self::_get_dir_tree_items($resultEncoder, $item_path);
                $resultEncoder->endList();
                $resultEncoder->endDictionary();
            }
        }
    }
}