<?php
// Copyright 1999-2017. Plesk International GmbH. All rights reserved.

/**
 * @property $path
 */
class GetFileNamesTask extends Task {
    /**
     * Retrieve list of file names in given directory
     *
     * @param ResultEncoder $resultEncoder
     */
    public function run(ResultEncoder $resultEncoder) {
        $phpFunctions = Registry::get_instance()->get_php_functions();

        $resultEncoder->startList();

        $handle = FileUtils::open_dir($this->path);

        if (!is_null($handle)) {
            while (false !== ($item = $phpFunctions->readdir($handle))) {
                if ($item == '.' || $item == '..') {
                    continue;
                }
                $item_path = $this->path . DIRECTORY_SEPARATOR . $item;
                if ($phpFunctions->is_file($item_path)) {
                    $resultEncoder->startListValue();
                    $resultEncoder->addString($item);
                    continue;
                }
            }
        }

        $resultEncoder->endList();
    }
}