REM Remap Panel and domains to the new IP
"%plesk_bin%\reconfigurator" --remap-ips
"%plesk_bin%\ipmanage" --reread

REM Get instance external IP
for /f "tokens=*" %%i IN ('"%plesk_bin%\amazon\curl" http://169.254.169.254/latest/meta-data/public-ipv4') DO set EXTERNAL_IP=%%i
echo EXTERNAL_IP: %EXTERNAL_IP%

REM Fixing public ip
setlocal enabledelayedexpansion
for /f "tokens=1 delims= " %%i IN ('"%plesk_bin%\ifmng.exe" -l') DO (
	set "INTERNAL_IP="
	echo %%i | find "." > temp
	set /p INTERNAL_IP="" < temp
	del temp

	if "!INTERNAL_IP!" NEQ "" (
		"%plesk_bin%\ipmanage" -u %%i -public_ip %EXTERNAL_IP%
	)
)
endlocal

REM Adjust passive FTP settings
set PASSIVE_PORT_RANGE=60000-65535
"%plesk_bin%\ftpmng" --set-ftp-passive-port-range --range="%PASSIVE_PORT_RANGE%"
"%plesk_bin%\dbclient" --direct-sql --sql="UPDATE misc SET val='%PASSIVE_PORT_RANGE%' WHERE param='passive_ftp_port_range'"
"%SystemRoot%\System32\inetsrv\appcmd.exe" set config -section:system.applicationHost/sites /siteDefaults.ftpServer.firewallSupport.externalIp4Address:"%EXTERNAL_IP%" /commit:apphost

REM Update DNS zones
"%plesk_bin%\dbclient" --direct-sql --sql="UPDATE dns_recs SET displayVal='%EXTERNAL_IP%', val='%EXTERNAL_IP%' WHERE type='A' AND val='%1'"
"%plesk_bin%\dbclient" --direct-sql --sql="UPDATE dns_recs SET displayHost='%EXTERNAL_IP%', host='%EXTERNAL_IP%' WHERE type='PTR' AND opt='24' AND displayHost='%1'"

"%plesk_bin%\dnsmng.exe" UPDATE *
	