<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => '如果您的網站託管於一個獨立的 IP 位址上（不與其他用戶或網站共用），您可在網站內創建一個其他用戶可通過 FTP 匿名上傳或下載檔案的目錄。匿名 FTP 一打開，用戶將可使用“匿名”用戶名與密碼登入至目錄，位址如 ftp://ftp.your-domain.com。',
    'anonymous-ftp.displayLogin' => '顯示登入資訊',
    'anonymous-ftp.loginText' => '資訊文本',
    'anonymous-ftp.incomingDir' => '允許上傳至接收目錄',
    'anonymous-ftp.incomingSubDir' => '允許在接收目錄中創建目錄',
    'anonymous-ftp.incomingReadable' => '允許從接收目錄中下載',
    'anonymous-ftp.quota' => '限制接收目錄中的磁碟空間',
    'anonymous-ftp.maxConnections' => '限制同時連接的數量',
    'anonymous-ftp.bandwidth' => '限制此虛擬 FTP 域名的下載頻寬',
    'anonymous-ftp.unlimited' => '無限',

    'aps.catalog.loading' => '載入中...',
    'aps.catalog.searchName' => '應用程式',
    'aps.catalog.searchVendor' => '廠商',
    'aps.catalog.searchPackager' => '打包者',
    'aps.catalog.searchLicenseType' => '許可證類型',
    'aps.catalog.searchLicenseTypeAny' => '任何',
    'aps.catalog.searchLicenseTypeFreeware' => '免費',
    'aps.catalog.searchLicenseTypeCommercial' => '商業',
    'aps.catalog.showSearch' => '顯示搜尋',
    'aps.catalog.hideSearch' => '隱藏搜尋',
    'aps.catalog.buttonSearch' => '搜尋',
    'aps.catalog.buttonResetSearch' => '重置搜尋',
    'aps.catalog.showCategories' => '在下面選擇一個目錄或使用搜尋框搜尋應用程式',
    'aps.catalog.searchResults' => '搜索結果',
    'aps.catalog.buttonInstall' => '安裝',
    'aps.catalog.buttonInstallTooltip' => '快速安裝最新版本的應用程式，設定最優預設參數。',
    'aps.catalog.buttonAdvancedInstall' => '安裝（自訂）',
    'aps.catalog.buttonAdvancedInstallTooltip' => '安裝最新版本的應用程式，自訂所有參數。',
    'aps.catalog.buttonInstallOldVersion' => '安裝版本',
    'aps.catalog.buttonInstallOldVersionTooltip' => '安裝選定版本的應用程式，自訂所有參數。',
    'aps.catalog.buttonInstallDescription' => '若有啟動碼或僅想試用，請在網站上安裝應用程式。',
    'aps.catalog.buttonInstallDescriptionFree' => '在網站上安裝此免費應用程式。',
    'aps.catalog.version' => '版本',
    'aps.catalog.moreVersions' => '更多版本',
    'aps.catalog.release' => '發行版本本',
    'aps.catalog.overview' => '概要',
    'aps.catalog.noApplicationsInCategory' => '此類別中無可用應用程式。請選擇另一類別。',
    'aps.catalog.noCategoriesSelected' => '選擇一類來流覽此類別中的所有應用程式。',
    'aps.catalog.noSearchResults' => '未搜尋到匹配的應用程式。',
    'aps.catalog.connectionFailed' => '連接到應用程式目錄失敗。%%retryLink%%。',
    'aps.catalog.retry' => '重試',
    'aps.catalog.categoriesError' => '此刻無法載入類別列表。',
    'aps.catalog.applicationsError' => '此刻無法載入應用程式清單。',
    'aps.catalog.detailsError' => '此刻無法載入應用程式詳情。',
    'aps.catalog.searchError' => '此刻無法載入搜尋結果。',
    'aps.catalog.changelogEntry' => 'v%%version%% (發行版本 %%release%%) - %%description%%',
    'aps.catalog.changelog' => '變更歷史記錄',
    'aps.catalog.officialApplicationSite' => '廠商資訊',
    'aps.catalog.returnToCategories' => '< 返回應用程式清單',
    'aps.catalog.buttonUninstall' => '移除',
    'aps.catalog.gotoHome' => '首頁',
    'aps.catalog.all' => '所有',
    'aps.catalog.buttonDetails' => '瞭解更多',
    'aps.catalog.buttonBuy' => '現在購買',
    'aps.catalog.buttonBuyTooltip' => '購買該應用',
    'aps.catalog.buttonBuyDescription' => '存取商店購買應用程式啟動碼。',
    'aps.catalog.buttonDownload' => '下載',
    'aps.catalog.buttonDownloadDescription' => '若已有啟動碼或僅想試用，請下載應用程式。',
    'aps.catalog.marketplaceMoreInfo' => '如需更多資訊，請連接 %%link%%。',
    'aps.catalog.marketplaceMoreInfoLink' => '應用程式代理商網站',

    'aps.configure.installedAt' => "安裝位置",
    'aps.configure.otherSettings' => "其他",
    'aps.configure.globalSettings' => '包設定',
    'aps.configure.passwordConfirmation' => '確認密碼',
    'aps.configure.databaseParams' => '資料庫參數',
    'aps.configure.noInstallationUrlAvailable' => '無（外部應用程式）',
    'aps.configure.updateSettingsSection' => '更新設定',
    'aps.configure.forceUpdates' => '當更新可用時自動更新此應用程式',
    'aps.configure.forceUpdatesHint' => '該應用程式將會接收自動更新以更新至新版本。 警告： 請謹慎使用此選項因為更新會在很大程度上影響應用程式的功能。 例如，應用程式擴展可能會在應用程式更新為其它版本後停止工作。',

    'aps.install.showAllSettings' => '顯示所有設定',
    'aps.install.showLessSettings' => '顯示最小設定',
    'aps.install.install' => '安裝',
    'aps.install.otherSettings' => '其他設定',
    'aps.install.globalSettings' => '包設定',
    'aps.install.passwordConfirmation' => '確認密碼',
    'aps.install.provisionsSectionLabel' => '安裝路徑',
    'aps.install.context' => '指定此 web 應用程式應該安裝的位置',
    'aps.install.registerAsWebmailSection' => 'web 郵箱註冊',
    'aps.install.registerAsWebmailDescription' => "如果此應用程式是一個 web 郵箱用戶端可選擇此選項。然後該應用程式將出現在訂閱與服務方案的郵件設定裡的可用 web 郵箱服務中。該管理員可配置 web 郵箱的公共存取 URL，依次是伺服器管理 > 設定 > web 郵箱。",
    'aps.install.registerAsWebmailLabel' => '註冊一個 web 郵箱服務',
    'aps.install.addItem' => '添加',
    'aps.install.removeItem' => '移除',
    'aps.install.updateSettingsSection' => '更新設定',
    'aps.install.forceUpdates' => '當更新可用時自動更新此應用程式',
    'aps.install.forceUpdatesHint' => '該應用程式將會接收自動更新以更新至新版本。 警告： 請謹慎使用此選項因為更新會在很大程度上影響應用程式的功能。 例如，應用程式擴展可能會在應用程式更新為其它版本後停止工作。',

    'aps.invalid-requirements.requirementsLegend' => '要求',
    'aps.invalid-requirements.domainLegend' => '網站',
    'aps.invalid-requirements.context' => '選擇另一網站',
    'aps.invalid-requirements.backToApplicationList' => '返回應用程式清單',

    'aps.license.title' => '安裝%%packageName%%',
    'aps.license.doYouAcceptLicense' => '若要安裝此應用程式，您需要閱讀使用者授權合約並同意此協議。',
    'aps.license.licenseAgree' => '我接受授權合約',

    'aps.services-list-customization.settings' => '設定',

    'asp-dot-net.change-version.frameworkVersion' => 'ASP.NET Framework 版本',

    'asp-dot-net.settings.casSettingsSection' => "代碼存取安全性",
    'asp-dot-net.settings.clientScriptsSection' => "腳本庫設定",
    'asp-dot-net.settings.connStringsSection' => "連接字串管理器",
    'asp-dot-net.settings.customErrorsSection' => "自訂錯誤設定",
    'asp-dot-net.settings.frameworkVersionSection' => "Framework 版本",
    'asp-dot-net.settings.globalizationSection' => "全域化設定",
    'asp-dot-net.settings.otherSection' => "會話設定",
    'asp-dot-net.settings.pageAndRuntimeSection' => "編譯和調試",
    'asp-dot-net.settings.authMode' => "驗證模式",
    'asp-dot-net.settings.connStrings' => "連接字串",
    'asp-dot-net.settings.connStringName' => "名稱",
    'asp-dot-net.settings.connStringValue' => "連接參數",
    'asp-dot-net.settings.culture' => "區域性",
    'asp-dot-net.settings.customErrMode' => "自訂錯誤模式",
    'asp-dot-net.settings.customErrorRedirect' => "重定向 URL",
    'asp-dot-net.settings.customErrorStatus' => "狀態碼",
    'asp-dot-net.settings.customErrorStatusInvalid' => "狀態碼必須為整數。",
    'asp-dot-net.settings.customErrors' => "自訂錯誤",
    'asp-dot-net.settings.debugMode' => "啟用調試",
    'asp-dot-net.settings.defLanguage' => "網頁預設語言",
    'asp-dot-net.settings.tempDirectory' => "臨時目錄",
    'asp-dot-net.settings.fileEnc' => "檔編碼",
    'asp-dot-net.settings.fileEncInvalid' => "檔編碼參數的指定值無效。",
    'asp-dot-net.settings.pathToLib' => "Microsoft 腳本庫的路徑",
    'asp-dot-net.settings.pathToLibInstall' => "安裝",
    'asp-dot-net.settings.reqEnc' => "請求編碼",
    'asp-dot-net.settings.reqEncInvalid' => "請求編碼參數的指定值無效。",
    'asp-dot-net.settings.resEnc' => "回應編碼",
    'asp-dot-net.settings.resEncInvalid' => "回應編碼參數的指定值無效。",
    'asp-dot-net.settings.sessTimeout' => "會話超時(分鐘)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "會話超時參數的指定值無效。請輸入一個不大於 %%max%% 的正整數。",
    'asp-dot-net.settings.trustLevel' => "代碼存取安全性 (CAS) 信任級別",
    'asp-dot-net.settings.uiCulture' => "UI 區域性",
    'asp-dot-net.settings.version' => "版本",
    'asp-dot-net.settings.trustLevelAllowOverride' => '允許覆蓋網站上的 CAS 信任等級',
    'asp-dot-net.settings.addConnStrings' => '添加連接字串',
    'asp-dot-net.settings.addCustomErrors' => '添加自訂錯誤',
    'asp-dot-net.settings.buttonRemove' => '移除',

    'database.clone.formDescription' => '複製資料庫內容到新的或現有的資料庫。當複製到現有的資料庫時，來源資料庫的表格會被添加到目的資料庫中的表格清單裡。警告：如果表格名稱相同，來源資料庫的表格將會替換目的資料庫中的表格。',
    'database.clone.copyData' => '創建一個完整的副本',
    'database.clone.copyDataHint' => '如果選定該選項，將會複製整個資料庫（包括結構和資料）。如果清空選項，將只會複製表格的結構。',
    'database.clone.server' => '目的資料庫伺服器',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => '其他...',
    'database.clone.database' => '目的資料庫',
    'database.clone.newDatabase' => '創建新資料庫（名稱）',
    'database.clone.existingDatabase' => '複製到現有的資料庫',
    'database.clone.externalDbHost' => '主機名稱稱或 IP 地址',
    'database.clone.externalDbLogin' => '用戶名',
    'database.clone.externalDbPassword' => '密碼',
    'database.clone.subscription' => '目的訂閱',
    'database.clone.subscription_powerUser' => '目的主機空間',
    'database.clone.cloneInProgress' => '克隆資料庫 %%source%% 到資料庫 %%destination%%.將會通過郵件通知您其進程(%%email%%)。',
    'database.clone.unableToClone' => '無法複製該資料庫',
    'database.clone.unableToCreateExternalDatabase' => '無法在指定的伺服器上創建一個資料庫。',
    'database.clone.databaseCloned' => '資料庫被複製過。',
    'database.clone.emailSubjSuccess' => '資料庫 "%%sourceDatabase%%" 被複製過。',
    'database.clone.emailSubjFailure' => '複製資料庫 "%%sourceDatabase%%" 失敗。',
    'database.clone.emailBodySuccess' => '資料庫  "%%sourceDatabase%%" (%%sourceHost%%) was copied to the database "%%destDatabase%%" (%%destHost%%)。',
    'database.clone.emailBodyFailure' => '無法複製資料庫"%%sourceDatabase%%" (%%sourceHost%%)  到資料庫 "%%destDatabase%%" (%%destHost%%)。複製失敗。',
    'database.clone.localServer' => '本機伺服器',

    'database.repair-orphaned.formDescription' => '恢復流程後該使用者被孤立。請提供用於該使用者的密碼以解決該問題。如果該使用者是無需密碼的系統使用者，則留空密碼欄位運行修復工具。',
    'database.repair-orphaned.login' => '資料庫用戶名',
    'database.repair-orphaned.pass' => '密碼',
    'database.repair-orphaned.pass2' => '確認密碼',
    'database.repair-orphaned.users' => '一些使用者需要您的關注。有多個被孤立使用者需要進行修復才能正常運行。',
    'database.repair-orphaned.orphaned' => '用戶被孤立。%%gui begin:link%%現在修復%%gui end:link%%.',
    'database.repair-orphaned.repair' => '修理',

    'database.repair.fixSelected' => '修復所選的',
    'database.repair.fix' => '修理',

    'database.user.password' => '密碼',
    'database.user.passwordConfirmation' => '確認密碼',
    'database.user.server' => '資料庫伺服器',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => '資料庫',
    'database.user.anyDatabase' => '任何',
    'database.user.dataAccess' => '資料存取',
    'database.user.structureAccess' => '結構存取',
    'database.user.globalAccess' => '全域許可權',
    'database.user.globalAccessHint' => '全域許可權適用於該主機帳戶內所有的資料庫。',
    'database.user.aclRadio' => '存取控制',
    'database.user.aclLocalhost' => '僅允許本地連接',
    'database.user.aclAny' => '允許來自任何主機的遠端連接',
    'database.user.aclCustom' => '允許遠端連接來自',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\n允許指定的主機代表該使用者存取資料庫。",
    'database.user.remoteAccess' => '遠端存取',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n允許指定的主機代表該使用者存取資料庫。在該清單中的修改將被您的主機提供商預先修改。",
    'database.user.example' => "例如：\n%%example%%",
    'database.user.denied' => '使用系統防火牆規則',
    'database.user.allowed' => '允許遠端連接來自',
    'database.user.default' => '默認使用該用戶的驗證憑據存取 %%webadmin%%',
    'database.user.remoteAccessHint' => '請聯繫您的主機提供商確認您上述指定的選項符合傳入連接 MySQL 的當前防火牆規則。',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.myLittleAdmin' => 'myLittleAdmin',
    'database.user.webAdmin' => 'web Admin',
    'database.user.role' => '角色',
    'database.user.roleReadWrite' => '讀取和寫入',
    'database.user.roleWriteOnly' => '只寫入',
    'database.user.roleReadOnly' => '唯讀取',
    'database.user.roleCustom' => '自訂',

    'database.generalSection' => '通用',
    'database.name' => '資料庫名',
    'database.server' => '資料庫伺服器',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => '相關網站',
    'database.noDomainRelations' => '無相關網站',
    'database.userSection' => '用戶',
    'database.userSectionDescription' => '創建一個預設的資料庫使用者。Plesk 將會代表該使用者存取資料庫。如果資料庫沒有分配資料庫使用者，將無法存取該資料庫。',
    'database.createUser' => '創建資料庫使用者',
    'database.username' => '資料庫使用者名稱',
    'database.password' => '密碼',
    'database.passwordConfirmation' => '確認密碼',
    'database.allDbAccess' => '使用者有存取所選訂閱內所有資料庫的許可權',
    'database.aclRadio' => '存取控制',
    'database.aclLocalhost' => '僅允許本地連接',
    'database.aclAny' => '允許來自任何主機的遠端連接',
    'database.aclCustom' => '允許遠端連接來自',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\n允許指定的主機代表該使用者存取資料庫。",
    'database.remoteAccess' => '遠端存取',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n允許指定的主機代表該使用者存取資料庫。在該清單中的修改將被您的主機提供商預先修改。",
    'database.example' => "例如：\n%%example%%",
    'database.denied' => '使用系統防火牆規則',
    'database.allowed' => '允許遠端連接來自',

    'deployment-section.deploymentDisabledHint' => '從 Git repository 上傳文件',
    'deployment-section.deploymentEnabledHint' => '啟用 Git 支援',
    'deployment-section.deploymentSectionLegend' => '要複製到主機的檔',
    'deployment-section.deploymentSectionDescriptionHint' => '如果保持禁用 Git 支援，將會創建一個空的根目錄（網站/應用程式根目錄和檔根目錄），而網站將會在瀏覽器裡顯示預設的頁面。您需要使用 FTP 或檔案管理員上傳網站檔到文檔根目錄。另外，還可以現在或之後啟用 Git （在 網站與域名 中啟用）從 Git repository 上傳文件。',

    'dns-zone.acl-record.addIpHint' => '添加允許接收 DNS 區域副本的 DNS 伺服器 IP 位址。',
    'dns-zone.acl-record.ipAddress' => 'IP 地址',
    'dns-zone.acl-record.ipAddressWithMask' => 'IP 地址/遮罩',
    'dns-zone.acl-record.ipAddressDescription' => "例如，2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.acl-record.ipAddressWithMaskDescription' => "例如，2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.acl-record.addIpButton' => '添加 IP 地址',

    'dns-zone.record.type' => "記錄類型",
    'dns-zone.record.domainName' => "域名",
    'dns-zone.record.nameServer' => "域名伺服器",
    'dns-zone.record.protocol' => "協議",
    'dns-zone.record.priority' => "優先順序",
    'dns-zone.record.priorityLow' => "低 (%%priority%%)",
    'dns-zone.record.priorityHigh' => "非常高 (%%priority%%)",
    'dns-zone.record.weightLow' => "低 (%%weight%%)",
    'dns-zone.record.weightHigh' => "非常高 (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP 地址",
    'dns-zone.record.ipAddressDescription' => "例如，123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6 地址",
    'dns-zone.record.ipAddressV6Description' => "例如，2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "例如，2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "例如，2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "正式名稱",
    'dns-zone.record.mailDomain' => "郵件域名",
    'dns-zone.record.mxServer' => "郵件交換伺服器",
    'dns-zone.record.mxServerPriority' => "指定郵件交換伺服器優先順序。",
    'dns-zone.record.txtRecord' => "TXT 記錄",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "指定的 TXT 記錄值不正確。",
    'dns-zone.record.dsRecord' => "DS 記錄",
    'dns-zone.record.dsRecordDescription' => "示例：60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "指定的 DS 記錄值不正確。",
    'dns-zone.record.serviceName' => "服務名稱",
    'dns-zone.record.serviceNameDescription' => "示例：SIP",
    'dns-zone.record.srvWeight' => "擁有相同優先順序的記錄的相對權重",
    'dns-zone.record.targetHost' => "目標主機",
    'dns-zone.record.targetHostDescription' => "例如：example.com",
    'dns-zone.record.targetPort' => "目標埠",
    'dns-zone.record.retrieveDataError' => "未找到記錄資料。",
    'dns-zone.record.unknownTypeError' => "未知的 DNS 記錄類型",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => '當存在其它 MX 記錄時無法設定 NULL MX 記錄。',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => '當存在 NULL MX 記錄時，無法設定非 NULL MX 記錄。',
    'dns-zone.record.masterShouldBeRemote' => "您必須在不同的主機上有兩個不同的授權域名伺服器。",
    'dns-zone.record.caaTag' => "標籤",
    'dns-zone.record.caaRecord' => "值",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.invalidValue' => '值無效。可介於 1 秒到 2147483647 秒之間。',
    'dns-zone.record.ttlDefaultValue' => '預設值：%%value%% 秒',

    'dns-zone.restore-default.formHint' => "您可在此根據伺服器上使用的預設 DNS 範本設定恢復原始的區域配置。請選擇用於恢復區域的 IP 位址以及指定域名是否需要 www 別名。",
    'dns-zone.restore-default.ipv4' => "IPv4 地址",
    'dns-zone.restore-default.ipv4Hint' => "例如，123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6 地址",
    'dns-zone.restore-default.ipv6Hint' => "例如，2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => '指定的 IP 地址無效。',
    'dns-zone.restore-default.customIpHint' => "帶有此 IP 位址的記錄將被視為使用者修改的記錄，將不會與伺服器級的 DNS 範本同步。",
    'dns-zone.restore-default.wwwPrefix' => "WWW 首碼",
    'dns-zone.restore-default.previewRecords' => "恢復用於網站預覽的記錄",

    'dns-zone.soa-record.soaMnameSection' => '主域名伺服器',
    'dns-zone.soa-record.soaMname' => '域名伺服器',
    'dns-zone.soa-record.soaMnameAutoselect' => '（自動選擇）',
    'dns-zone.soa-record.soaRecordSection' => 'SOA 記錄',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => '刷新',
    'dns-zone.soa-record.retry' => '重試',
    'dns-zone.soa-record.expire' => '過期',
    'dns-zone.soa-record.minimum' => '最小',
    'dns-zone.soa-record.invalidValue' => '無效值。介於 1 秒到 68 年之間。',
    'dns-zone.soa-record.serialNumberFormatSection' => 'DNS 區域序號格式',
    'dns-zone.soa-record.serialNumberFormatText' => '使用 IETF 和 RIPE 推薦的序號格式可解決註冊混亂的問題，因此強制用於一些高級別 DNS 區域中註冊的眾多域名中。',
    'dns-zone.soa-record.serialNumberFormat' => '選擇使用 IETF 與 RIPE 推薦的序號格式。',
    'dns-zone.soa-record.serialNumberFormatHint' => '在不同序號格式之間切換可能會引起更新 DNS 區域的延遲。',
    'dns-zone.soa-record.restoreDefaultButton' => '使用默認設定',
    'dns-zone.soa-record.zoneDefaultsSection' => '區域預設設定',

    'domain-info-section.domainName' => '域名',
    'domain-info-section.emptyDomainName' => '請提供域名。',
    'domain-info-section.ipAddress' => 'IP地址',
    'domain-info-section.shared' => '共用',
    'domain-info-section.exclusive' => '獨立',
    'domain-info-section.ipAddressHint' => "託管網站的IP地址是網站虛擬機的網路位址。在此訂閱中創建的所有網站將使用此IP位址。",
    'domain-info-section.ipAddressHint_powerUser' => "託管此網站的IP地址是網站虛擬機的網路位址。在此主機空間內創建的所有網站將使用此IP位址。",
    'domain-info-section.userName' => '用戶名',
    'domain-info-section.userNameHint' => '與主機空間相關聯的、用於通過 FTP 和 SSH 協定存取託管檔的系統使用者帳戶。',
    'domain-info-section.emptyLogin' => '請提供用戶名。',
    'domain-info-section.password' => '密碼',
    'domain-info-section.emptyPassword' => '請提供密碼。',
    'domain-info-section.passwordConfirmation' => '重複密碼',

    'email-address.generalTab' => '常規',
    'email-address.generalHint' => '如果此郵件帳戶與其他用戶相關聯（存取客戶面板 功能已啟用）, 在此頁面上的修改會影響該用戶的設定。而且，如果您更改了電郵地址和密碼，其他使用者的登入名和密碼也將會更改為新的值。',
    'email-address.redirectTab' => '轉發',
    'email-address.redirectHint' => '設定將電子郵件消息轉發到一個或多個電子郵寄地址。',
    'email-address.aliasesTab' => '郵件別名',
    'email-address.autoResponderTab' => '自動回復',
    'email-address.antispamTab' => '垃圾郵件篩檢程式',
    'email-address.autoResponderHint' => '設定在任何郵件進入您的郵箱時自動回應。自動回復是您不在辦公室或在休假時設定的標準響應方式。',
    'email-address.antivirusTab' => '防病毒程式',
    'email-address.name' => '電郵地址',
    'email-address.externalEmail' => '外部郵箱位址',
    'email-address.externalEmailHint' => '如果您無法存取主要的電子郵箱位址，將用於重置您的密碼。',
    'email-address.user' => '分配到',
    'email-address.password' => '密碼',
    'email-address.passwordConfirmation' => '確認密碼',
    'email-address.responderEnable' => '啟用自動回復',
    'email-address.responderSubject' => '自動回復郵件主題',
    'email-address.responderContentType' => '郵件格式',
    'email-address.responderContentTypeHint' => '所有郵件用戶端程式都支援純文字格式，因此，所有收件人看到的郵件與您看到的相同。HTML郵件看起來較好，因您可以選擇不同的字體及樣式。但部分郵件用戶端不支援HTML郵件，因此部分收件人可能看不到該格式文本。',
    'email-address.responderContentTypeTextPlain' => '純文字',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => '文本編碼',
    'email-address.responderCodepageHint' => '文本編碼定義文字的顯示方式。建議編碼是UTF-8。',
    'email-address.responderReplyTo' => '轉發到',
    'email-address.responderReplyToHint' => '當發送了自動回應時，原始資訊將會被轉發到指定的電郵地址。',
    'email-address.responderForwardAddress' => '轉發到',
    'email-address.responderForwardAddressHint' => '當發送了自動回應時，原始資訊將會被轉發到指定的電郵地址。',
    'email-address.responderMessage' => '自動回復郵件文本',
    'email-address.responderReplyToEqualsEmail' => '指定的轉發位址與該郵寄位址一致。',
    'email-address.responderForwardAddressEqualsEmail' => '指定的轉發位址與該郵寄位址一致。',
    'email-address.responderReplyLimit' => '自動發送回應至唯一的電郵地址不超過（一日內）',
    'email-address.buttonAddResponderAttachment' => '添加附件',
    'email-address.buttonRemoveResponderAttachment' => '移除',
    'email-address.responderAttachment' => '附加檔',
    'email-address.redirectEnable' => '啟用轉發',
    'email-address.redirectRemoveEnable' => '不要將轉發的電子郵件的副本發送到 Plesk 郵箱',
    'email-address.redirectAddress' => '轉發傳入資訊到以下郵寄位址',
    'email-address.redirectAddressHint' => '指定電郵地址。您可每一行輸入一個電郵地址，或者使用空格、逗號或分號隔開位址。',
    'email-address.role' => '用戶角色。',
    'email-address.roleHint' => '用戶角色會授權使用者以管理優先權和到您為該角色所選定應用程式的存取權限。',
    'email-address.errorRedirectAddress' => '您指定了無效的電子郵箱位址：%value%。',
    'email-address.errorRedirectAddressMultiple' => '您指定了無效的電子郵箱位址：%value%。',
    'email-address.mailAlias' => "郵件別名",
    'email-address.mailAliasNone' => '無',
    'email-address.mailAliasHint' => "郵件別名是與主要的電郵地址相關聯的其它電郵地址。主要電郵地址會接收到所有發送到郵件別名的郵件。",
    'email-address.buttonAddMailAlias' => '添加郵件別名',
    'email-address.buttonRemoveMailAlias' => '移除',
    'email-address.emptyEmail' => '指定轉發所有傳入資訊所到的郵寄位址。',
    'email-address.emailsIsEqual' => '外部的電郵地址與主要的電郵地址匹配。請另外指定一個外部的電郵地址。',
    'email-address.emptyPassword' => '您需要提供密碼。',
    'email-address.emptyPasswordConfirmation' => '您需要確認密碼。',
    'email-address.emptyAlias' => "為此電郵地址指定郵件別名。",
    'email-address.aliasEqualsEmail' => '指定的郵件別名與郵寄位址一致。',
    'email-address.passwordHint' => '將用於存取郵箱以及登入 Plesk（如果啟用了相應選項）。',
    'email-address.cyclicRedirect' => '無法設定電郵地址向其自己轉發郵件',
    'email-address.errorMailnameReserved' => '指定的郵寄位址已在使用中。',
    'email-address.antivirusEnable' => '為此郵寄位址打開病毒防護功能',
    'email-address.antivirusHint' => '反病毒服務會攔截包含病毒的郵件並通知寄件者和收件人此資訊。',
    'email-address.antivirusSettings' => '查看是否有病毒',
    'email-address.antivirusSettingOnlyIncomingMail' => '僅限傳入郵件',
    'email-address.antivirusSettingOnlyOutgoingMail' => '僅限傳出郵件',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => '傳入和傳出郵件',
    'email-address.antispamHint' => '垃圾郵件過濾服務會檢測出發送至電郵地址的垃圾郵件。您可以設定垃圾郵件篩檢程式刪除垃圾郵件，通過更改其標題來標誌其為垃圾郵件，或移動它們到郵件用戶端通過 IMAP 可存取的特殊垃圾郵件資料夾中。垃圾郵件篩檢程式會通過廣泛的本地和網路測試來識別垃圾郵件簽名。',
    'email-address.antispamEnable' => '為此電郵地址打開垃圾郵件過濾功能',
    'email-address.antispamSettings' => '防垃圾郵件設定',
    'email-address.antispamSettingsMark' => '添加以下文本到資訊主題來標記垃圾資訊',
    'email-address.antispamSettingsMarkHint' => '如果您不想添加任何文本，保持該欄位元為空。如果您想要把評分包括在資訊主題中請輸入評分。',
    'email-address.antispamReportTextHint' => '輸入您想要添加到垃圾郵件資訊正文的文本。',
    'email-address.antispamSettingsDelete' => '刪除所有垃圾郵件',
    'email-address.antispamSettingsDeleteHint' => '則從您的郵箱刪除垃圾郵件。',
    'email-address.antispamSettingsMove' => '移動垃圾郵件到垃圾郵件資料夾',
    'email-address.antispamSettingsMoveHint' => '移動所有垃圾郵件到垃圾郵件資料夾。您可從郵件用戶端程式或 web 郵箱存取此資料夾。若您正使用IMAP郵件帳戶，則可使用垃圾郵件資料夾來調整垃圾郵件篩檢程式。',
    'email-address.antispamSettingsMoveWarning' => '無法實現“將垃圾郵件移動到垃圾郵件資料夾”，除非您禁用“轉發”標籤上的“不發送轉發的電子郵件的副本”選項。',
    'email-address.antispamSettingsMoveJunk' => '將垃圾郵件移動到 "垃圾郵件" 資料夾。',
    'email-address.antispamSettingsMoveJunkHint' => '將所有的垃圾資訊移動到 "垃圾郵件" 資料夾。可以從您的郵件用戶端程式或 web 郵箱存取該資料夾。如果您使用的是 IMAP 郵件帳戶，則可以使用 "垃圾郵件" 資料夾調控垃圾郵件篩檢程式。',
    'email-address.antispamShowAdvancedSection' => '顯示高級操作',
    'email-address.antispamHideAdvancedSection' => '隱藏高級操作',
    'email-address.antispamLearnMore' => '瞭解如何“訓練”垃圾郵件篩檢程式。',
    'email-address.antispamFilterScoreTitle' => '篩檢程式敏感度',
    'email-address.antispamFilterScoreHint' => '垃圾郵件篩檢程式會對每封郵件的內容和主題行執行多種不同測試。結果，每封郵件都會記錄一些分數。分數越高，這封郵件為垃圾郵件的可能性越大。預設情況下，篩檢程式敏感度設定認為當郵件分數大於等於 7 時即被標識為垃圾郵件。如果在當前設定下您會收到大量垃圾郵件，可設定更小的值來把篩檢程式調整得更為敏感，例如 6。如果因為垃圾郵件篩檢程式而丟失了一些郵件，可設定更高的值來降低其敏感度，例如 8。',
    'email-address.antispamFilterScore' => '垃圾郵件篩檢程式敏感度',
    'email-address.antispamWhiteListTitle' => '白名單',
    'email-address.antispamWhiteListHint' => '垃圾郵件篩檢程式不會檢查來自白名單清單中的發送者的電子郵件。',
    'email-address.antispamWhiteListField' => '白名單',
    'email-address.antispamWhiteListFieldHint' => '一行鍵入一個域名。位址應包含"*" 和"?" 萬用字元 (如*@domain.com、user?@*.com)',
    'email-address.antispamBlackListTitle' => '黑名單',
    'email-address.antispamBlackListHint' => '來自黑名單清單中的發送者的電子郵件會被歸類為垃圾郵件。',
    'email-address.antispamBlackListField' => '黑名單',
    'email-address.antispamBlackListFieldHint' => '一行鍵入一個域名。位址應包含"*" 和 "?" 萬用字元 (如 *@domain.com, user?@*.com)',
    'email-address.antispamTrustedLanguagesTitle' => '可信的語言',
    'email-address.antispamTrustedLanguagesHint' => '以這些語言書寫的郵件總會通過篩檢程式。',
    'email-address.antispamTrustedLocalesTitle' => '可信的區域設定',
    'email-address.antispamTrustedLocalesHint' => '使用指定區域設定組的郵件將總會通過篩檢程式。區域設定組包括最常用的字元集。例如，西方字元集包括用於英文和西歐語言中字母的編碼。',
    'email-address.antispamTrustedNetworksTitle' => '可信的網路',
    'email-address.antispamTrustedNetworksHint' => '在可信的網路上運行的中繼主機被視為不可能由垃圾郵件寄件者操控，且此類中繼主機不是開放中繼或開放代理。',
    'email-address.antispamIpAddressesField' => 'IP地址',
    'email-address.antispamIpAddressesFieldHint' => '指定網路IP位址及遮罩。',
    'email-address.mailBoxQuotaDomainDefault' => '默認大小 (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => '默認大小',
    'email-address.mailBoxOutgoingMessages' => '傳出郵件資訊的最大數量',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => '默認（每小時 %%domainOutgoingMessages%% 條資訊）',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => '該郵箱的自訂值',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => '信息',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => '默認',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => '默認大小',
    'email-address.mailBoxQuotaDomainSpecific' => '其它大小',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => '郵箱大小',
    'email-address.mailBoxQuotaUnlimited' => '無限',
    'email-address.mailBoxLimitReached' => '已達到郵箱數量上限。',
    'email-address.postboxEnabled' => '郵箱',
    'email-address.postboxEnabledYes' => '開啟',
    'email-address.postboxEnabledNo' => '關閉',
    'email-address.description' => 'Plesk 中的描述',
    'email-address.descriptionHint' => '任何可存取該郵件帳戶的用戶都可看到該描述。',
    'email-address.longDescription' => '指定的描述太長。不得超過 %%max%% 個字元。',
    'email-address.loginAsUser' => '可用於登入 Plesk',
    'email-address.loginAsUserDescription' => '（用戶名：%%username%%）',
    'email-address.maxCustomSizeDesc' => '郵箱大小不能超過默認大小。',
    'email-address.endDateEnable' => '關閉自動回復時間',

    'failed-request.enable-tracing.description' => '失敗請求跟蹤是一項資源密集型操作。跟蹤將會在 %%days%% 日內自動停止。您可以在任何時候手動停止。',
    'failed-request.enable-tracing.statusCodes' => '狀態碼',
    'failed-request.enable-tracing.statusCodesDescription' => '示例：401.3-999, 405',
    'failed-request.enable-tracing.provider' => '提供商',

    'file-manager.show.buttonReload' => '重新載入',
    'file-manager.show.buttonSave' => '保存',
    'file-manager.show.buttonSaveAs' => '保存為',
    'file-manager.show.buttonReset' => '重設',
    'file-manager.show.buttonTextCodeEditor' => '在代碼編輯器中編輯',
    'file-manager.show.buttonTextEdit' => '在文字編輯器中編輯',
    'file-manager.show.buttonWysiwygEdit' => '在 HTML 編輯器中編輯',
    'file-manager.show.eolLabel' => '斷行類型：',
    'file-manager.show.saveAs' => '保存為：',
    'file-manager.show.saveCodepage' => '在以下編碼中保存：',
    'file-manager.show.loadCodepage' => '查看以下編碼中的原始檔：',
    'file-manager.show.loadCodepageHint' => '警告：任何未保存的修改都將會在重新載入檔時丟失。',
    'file-manager.show.fileExists' => "文件或資料夾 %%fileName%% 已存在。您無法擁有相同名稱的資料夾和文件。",
    'file-manager.show.popupTitle' => '保存為',
    'file-manager.show.popupFilename' => '檔案名：',

    'file-manager.permissions.filePermissions' => '文件許可權',
    'file-manager.permissions.directoryPermissions' => '目錄許可權',
    'file-manager.permissions.buttonSubmit' => '保存',
    'file-manager.permissions.buttonApply' => '保存並恢復',
    'file-manager.permissions.buttonCancel' => '取消',
    'file-manager.permissions.buttonAdvanced' => '高級',

    'file-manager.unix-file-permissions.group' => '組',
    'file-manager.unix-file-permissions.owner' => '所有人',
    'file-manager.unix-file-permissions.others' => '其他',
    'file-manager.unix-file-permissions.readMode' => '讀取',
    'file-manager.unix-file-permissions.writeMode' => '寫入',
    'file-manager.unix-file-permissions.execMode' => '執行/搜尋',
    'file-manager.unix-file-permissions.changeRecursive' => '遞迴地更改許可權',

    'file-manager.windows-permissions.allow' => '允許',
    'file-manager.windows-permissions.deny' => '拒絕',
    'file-manager.windows-permissions.inheritFromParent' => '允許來自父級的可繼承權限傳播到此對象和所有子對象。包括此處明確定義的項目。',
    'file-manager.windows-permissions.replaceOnChildren' => '將所有子對象的許可權項替換為此處顯示的許可權項。',
    'file-manager.windows-permissions.buttonAdvanced' => '高級',
    'file-manager.windows-permissions.applyTo' => '應用到:',
    'file-manager.windows-permissions.folderOnly' => '僅此資料夾',
    'file-manager.windows-permissions.subfolderOnly' => '僅子資料夾',
    'file-manager.windows-permissions.filesOnly' => '僅文件',
    'file-manager.windows-permissions.permissionsFor' => '許可權主體',
    'file-manager.windows-permissions.applyOnto1' => '僅此資料夾',
    'file-manager.windows-permissions.applyOnto2' => '僅子資料夾',
    'file-manager.windows-permissions.applyOnto3' => '此資料夾和子資料夾',
    'file-manager.windows-permissions.applyOnto4' => '僅文件',
    'file-manager.windows-permissions.applyOnto5' => '此資料夾和文件',
    'file-manager.windows-permissions.applyOnto6' => '僅子資料夾和文件',
    'file-manager.windows-permissions.applyOnto7' => '此資料夾、子資料夾和文件',
    'file-manager.windows-permissions.notInherited' => '<尚未繼承>',

    'file-manager.editor.titleTextEditor' => 'Text Editor',
    'file-manager.editor.titleCodeEditor' => 'Code Editor',
    'file-manager.editor.titleCodeViewer' => '查看',
    'file-manager.editor.buttonSubmit' => '保存',
    'file-manager.editor.buttonApply' => '保存並恢復',
    'file-manager.editor.buttonSaveAs' => '另存為 ...',
    'file-manager.editor.buttonCancel' => '取消',
    'file-manager.editor.exitConfirmationYes' => '是',
    'file-manager.editor.exitConfirmationNo' => '否',
    'file-manager.editor.fileOverwrite' => '文件已存在。',
    'file-manager.editor.fileOverwriteDescription' => '相同名稱的檔已存在。您要覆蓋它嗎？',
    'file-manager.editor.exitConfirmation' => '您確定要關閉檔並放棄未保存的更改嗎？',
    'file-manager.editor.buttonCodeEditor' => '在代碼編輯器中編輯',
    'file-manager.editor.buttonTextEditor' => '在文字編輯器中編輯',
    'file-manager.editor.buttonHtmlEditor' => '在 HTML 編輯器中編輯',

    'file-manager.import-file.buttonSubmit' => '導入',
    'file-manager.import-file.fieldUrl' => '文件的 URL',
    'file-manager.import-file.fieldUrlDescription' => '指定源 URL，例如：\'https://example.com/example.tgz\'。',
    'file-manager.import-file.fieldUrlFullDescription' => '完整的 URL 模式如下：\'https://user:password@example.com/example.tgz\'。用戶名稱和密碼是備選的。支援的協定有 http、https、ftp、ftps。含有特殊字元或空格的 URL 部分使用 URL編碼。',
    'file-manager.import-file.failure' => '無法導入文件。',

    'ftp-user.description' => '如果您想與他人合作製作網站或為其他用戶託管子域名，您可為他們創建其他的 FTP 帳號。',
    'ftp-user.generalSection' => '常用',
    'ftp-user.login' => 'FTP 帳戶名稱',
    'ftp-user.home' => '主目錄',
    'ftp-user.systemArea' => '創建可存取主目錄之外的檔的 FTP 帳戶',
    'ftp-user.password' => '密碼',
    'ftp-user.passwordConfirmation' => '確認密碼',
    'ftp-user.hardQuotaSection' => '硬碟配額',
    'ftp-user.hardQuota' => '硬碟配額',
    'ftp-user.hardQuotaUnlimited' => '無限',
    'ftp-user.permissionsSection' => '許可權',
    'ftp-user.permissionRead' => '讀取許可權',
    'ftp-user.permissionWrite' => '寫入許可權',
    'ftp-user.popupTitle' => '選擇目錄',

    'mail-list.listName' => '郵寄清單地址',
    'mail-list.enabled' => '已啟用',
    'mail-list.administratorEmail' => '郵寄清單管理員的郵件',
    'mail-list.password' => '密碼',
    'mail-list.passwordConfirmation' => '確認密碼',
    'mail-list.subscribers' => '訂戶',
    'mail-list.subscribersHint' => '指定電郵地址。您可每一行輸入一個電郵地址，或者使用空格、逗號或分號隔開位址。',
    'mail-list.notify' => '建立郵寄清單後通知管理員',
    'mail-list.emptyPassword' => '提供一個密碼。',
    'mail-list.emptyPasswordConfirmation' => '請確認密碼。',
    'mail-list.errorSubscribers' => '無效的電郵地址。%value%.',
    'mail-list.errorMaillistReserved' => '指定的郵寄清單位址已在使用。',

    'mail-settings.hint' => '在此處您可以為該域名修改郵件服務設定。',
    'mail-settings.service' => '啟動此域名上的郵件服務',
    'mail-settings.nonExist' => '如何處理不存在用戶的郵件',
    'mail-settings.nonExistBounceWithMessage' => '退回信息',
    'mail-settings.nonExistBounce' => '退信',
    'mail-settings.nonExistCatch' => '轉發至地址',
    'mail-settings.nonExistCatchDescription' => '電郵地址應該屬於選定的域名。只有管理員可以為多個域名指定外部位址或一個位址。',
    'mail-settings.nonExistExternal' => '重定向到該 IP 位址的外部郵件伺服器：',
    'mail-settings.nonExistReject' => '拒絕',
    'mail-settings.nonExistDiscard' => '拒絕',
    'mail-settings.webmail' => 'web 郵箱',
    'mail-settings.webmailNone' => '無',
    'mail-settings.webmailComponentNotInstalled' => '未安裝 web 郵箱組件。',
    'mail-settings.webmailSubdomainAlreadyExists' => '這是一個名為 %%subdomain%% 的子域名。',
    'mail-settings.webmailCertificate' => 'web 郵箱的 SSL/TLS 證書',
    'mail-settings.webmailCertificateNone' => '未選定',
    'mail-settings.mailCertificate' => '用於郵箱的 SSL/TLS 證書',
    'mail-settings.mailCertificateNone' => '未選定',
    'mail-settings.serverCertificateNotSelected' => '已簽署憑證，但該網域的郵件不安全。如需完成確保該網域郵件的安全性，%%certLink%%。',
    'mail-settings.serverCertificatesList' => '確保郵件伺服器的安全性',
    'mail-settings.mailLists' => '啟用郵寄清單',
    'mail-settings.mailAutodiscovery' => '啟用郵件 autodiscover',
    'mail-settings.mailAutodiscoveryDescription' => '查看其在 %%link%% 中是如何工作運行的',
    'mail-settings.mailAutodiscoveryDescriptionLink' => '知識庫',
    'mail-settings.domainKeys' => '使用 DKIM 垃圾郵件防護系統簽名發件資訊',
    'mail-settings.greyListing' => '對此域名上所有郵件帳戶啟用灰名單過濾垃圾郵件功能',
    'mail-settings.howToConfigureExternalDns' => '如何配置外部 DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => '若您使用外部 DNS 伺服器而想要啟用 DKIM 簽名，則需要您自己在 DNS 伺服器上配置 DKIM DNS 記錄。',
    'mail-settings.howToConfigureExternalDnsEnabled' => '具體操作是使用下面的 DKIM DNS 記錄：',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => '若您有用於發送郵件的域名，請同時為其添加 DKIM DNS 記錄。請將用於主域名的相同記錄用於域名別名。',
    'mail-settings.howToConfigureExternalDnsDisabled' => '若要查看需要配置的 DKIM DNS 記錄，請選擇 "%%option%%" 核取方塊，請應用它並再次打開此快顯視窗。',

    'role.roleSection' => '常規',
    'role.name' => '用戶角色名稱',
    'role.description' => '描述',
    'role.generalPermissionsSection' => '存取 Plesk 服務',
    'role.applicationsAccessSection' => '存取應用程式',
    'role.permissionAllow' => '允許',
    'role.permissionDeny' => '拒絕',
    'role.emptyRoleName' => '請提供角色名稱。',
    'role.installedAt' => '安裝位置',
    'role.noInstallationUrlAvailable' => '外部應用程式',
    'role.invalidRoleName' => '指定的用戶角色名稱無效。不可以在角色名稱中使用問號和引號。',
    'role.longRoleName' => '指定用戶角色名太長。',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => '因下列原因部分操作不可用: 操作許可權未授予當前所選的訂閱，或分配的資源量不足於執行操作。',
    'role.servicesPermissionsDescription' => '為有該角色的所有用戶定義存取已安裝的應用程式或 Plesk 服務的許可權。如果您授予使用者存取某個應用程式的許可權，那麼他們將可在客戶面板中存取該應用程式。',
    'role.emailActivation' => '通過電子郵件啟動該角色的帳戶',

    'service.admin-access.adminAccess' => '管理存取',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => '這些憑據將用於管理存取此應用程式。',
    'service.admin-access.login' => '管理員用戶名',
    'service.admin-access.password' => '管理員密碼',
    'service.admin-access.passwordConfirmation' => '確認密碼',

    'service.info.service-entry-point.availableAt' => '可用',
    'service.info.service-entry-point.customize' => '自訂快捷方式',
    'service.info.service-entry-point.displayNameLabel' => '快捷方式名稱',
    'service.info.service-entry-point.displayNameDescription' => '請提供此快捷方式名稱。此名稱顯示在快捷方式圖示下方。這些快捷方式顯示在授權存取此應用程式的使用者我的服務頁面。',
    'service.info.service-entry-point.descriptionLabel' => '快捷方式描述',
    'service.info.service-entry-point.descriptionDescription' => '提供此快捷方式的描述。當滑鼠指標懸停在快捷方式上方時，則會顯示有關此快捷方式用途的簡短說明。',
    'service.info.service-entry-point.iconLabel' => '點按選擇快捷方式圖示',
    'service.info.service-entry-point.iconCurrent' => '當前圖示',
    'service.info.service-entry-point.errorEmptyName' => '請提供快捷方式名稱',
    'service.info.service-entry-point.errorLongName' => '快捷方式名稱應介於1到255個字元之間。',
    'service.info.service-entry-point.errorLongDescription' => '快捷方式描述應介於1到255個字元之間。',
    'service.info.service-entry-point.hiddenLabel' => '隱藏快捷方式',
    'service.info.service-entry-point.hiddenDescription' => '請對使用者隱藏此快捷方式。',

    'service.info.service-permission.assignedUser' => "授權管理員存取此用戶",
    'service.info.service-permission.assignedUserNone' => '未分配用戶',

    'shared-ssl.master-ssl.switchedOn' => '啟用共用 SSL/TLS',
    'shared-ssl.master-ssl.domainName' => '將與其它網站共用其 SSL/TLS 證書的網站的域名',
    'shared-ssl.master-ssl.none' => '無',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => '沒有啟用 共用 SSL/TLS 因為沒有已啟用 SSL/TLS 支援的域名。',

    'user.email.email' => '電郵地址',
    'user.email.emptyEmail' => '您需要提供一個郵箱位址。',
    'user.email.internalEmailHint' => '在 Plesk 中創建新的郵箱位址或使用外部的郵箱位址。',
    'user.email.longInternalEmail' => '電郵地址太長。',
    'user.email.longInternalEmailMailboxAddressMailServer' => '用於該郵件伺服器的電郵地址的用戶名部分太長。請指定一個用戶名，且不得超過 %%max%% 個字元。',
    'user.email.longInternalEmailFullAddressMailServer' => '用於該郵件伺服器的電郵地址太長。請指定一個位址，且不得超過 %%max%% 個字元。',
    'user.email.externalEmail' => '外部郵箱位址',
    'user.email.externalEmailHint' => '如果您無法存取主要的電子郵箱位址，將用於重置您的密碼。',
    'user.email.emailsIsEqual' => '外部的郵箱位址與主要的郵箱位址匹配。指定其它的外部郵箱位址。',

    'user.profileSection' => '常規資訊',
    'user.contactName' => '連絡人姓名',
    'user.email' => '電郵地址',
    'user.role' => '用戶角色',
    'user.accountSection' => 'Plesk 偏好設定',
    'user.login' => '用戶名',
    'user.password' => '密碼',
    'user.buttonBack' => '返回',
    'user.generalTab' => '常規',
    'user.applicationsAccessSection' => '服務',
    'user.generalPermissionsSection' => '許可權',
    'user.contactsTab' => '連絡詳情',
    'user.passwordConfirmation' => '確認密碼',
    'user.emailName' => '電郵地址',
    'user.emailType' => '郵件類型',
    'user.companyName' => '公司名稱',
    'user.phone' => '電話',
    'user.imNumber' => '即時消息',
    'user.fax' => '傳真號',
    'user.address' => '地址',
    'user.city' => '城市',
    'user.state' => '省/市/自治區',
    'user.zip' => '郵編',
    'user.country' => '國家/地區',
    'user.additionalInfo' => '其他資訊',
    'user.additionalInfoHint' => '僅限純文字，將忽略所有 HTML 標籤。',
    'user.language' => 'Plesk 語言',
    'user.buttonChangePassword' => '更改密碼',
    'user.permissionAllow' => '允許',
    'user.permissionDeny' => '拒絕',
    'user.permissionInherited' => '由角色定義',
    'user.emptyContactName' => '請提供連絡人姓名。',
    'user.emptyLogin' => '請提供用戶名。',
    'user.emptyPassword' => '請提供密碼。',
    'user.emptyPasswordConfirmation' => '請確認密碼。',
    'user.chooseDomainBoxTitle' => '選擇另一域名:',
    'user.userIsActive' => '使用者處於活動狀態',
    'user.userIsActiveHint' => '活動的用戶可存取 Plesk。',
    'user.emailActivation' => '通過電子郵件啟動帳戶',
    'user.emailHint' => '要向用戶提供託管於此伺服器上的電郵地址，請進入 郵件 標籤，創建指定的電郵地址並與該用戶建立關聯。',
    'user.emailContactHint' => '如果您想要使用託管於該伺服器上的電郵地址可聯繫您的服務提供者。',
    'user.personalEmailHint' => "可以在 郵件 標籤上更改此用戶的電郵地址。",
    'user.externalMailRedirectHint' => '只能為託管於此伺服器上的電郵地址啟動轉發功能。要創建電郵地址，請進入 郵件 標籤。',
    'user.externalMailRedirectHint2' => '只能為託管於此伺服器上的電郵地址啟動轉發功能。',
    'user.externalMailAutoResponderHint' => '只能為託管於此伺服器上的電郵地址啟動自動回復。要創建電郵地址，請進入 郵件 標籤。',
    'user.externalMailAutoResponderHint2' => '只能為託管於此伺服器上的電郵地址啟動自動回復功能。',
    'user.roleHint' => '用戶角色授予用戶管理許可權，以及存取所選角色對應的應用程式。',
    'user.cannotManageMail' => "您不具備許可權管理郵件設定與服務。",
    'user.longCompanyName' => '指定的公司名太長。',
    'user.longPhone' => '指定的電話號碼太長。',
    'user.longFax' => '指定的傳真號太長。',
    'user.longAddress' => '指定的地址太長。',
    'user.longCity' => '指定的城市名太長。',
    'user.phoneRegexNotMatch' => '指定的電話號碼無效。',
    'user.faxRegexNotMatch' => '指定的傳真號無效。',
    'user.shortCity' => '指定的城市名太短。',
    'user.limitSubscription' => '存取訂閱',
    'user.limitSubscriptionHint' => '允許用戶只能存取指定的訂閱。值“所有”授權使用者存取您主機帳戶裡的所有訂閱。',
    'user.limitSubscriptionAll' => '所有',
    'user.deletedSubscription' => '移除的訂閱',

    'web.add-domain-alias.title' => '添加一個域名別名',
    'web.add-domain-alias.createdSuccessfully' => "已創建域名別名 %%name%%。",
    'web.add-domain-alias.domainAliasName' => '域名別名',
    'web.add-domain-alias.domainAliasNameHint' => '例如，example.net',
    'web.add-domain-alias.forDomain' => '基於域名',
    'web.add-domain-alias.settingsSectionLegend' => '設定',
    'web.add-domain-alias.settingsDns' => '將DNS區域與主域名進行同步',
    'web.add-domain-alias.settingsMail' => '郵件服務',
    'web.add-domain-alias.settingsWeb' => '網站服務',
    'web.add-domain-alias.settingsSeoRedirect' => '使用 HTTP 301 代碼重定向',
    'web.add-domain-alias.settingsSeoRedirectHint' => '當訪客打開別名的 URL，他們將會被重定向至主域的 URL。Plesk 會使用搜尋引擎友好 HTTP 301 重定向，這表示搜尋引擎排名將不會在兩個 URL 之間分割。',
    'web.add-domain-alias.settingsTomcat' => 'Java web 應用程式',
    'web.add-domain-alias.invalidDomainGuid' => '無效的域名',

    'web.add-domain.formTitle' => '添加新域名',
    'web.add-domain.formRegistrationHint' => '您可以在 %%link%% 中註冊一個新域名。',
    'web.add-domain.portalLink' => '服務埠',
    'web.add-domain.domainName' => '域名',
    'web.add-domain.domainNameHint' => "例如，example.com",
    'web.add-domain.assignToCustomer' => '分配該域名給一個客戶',
    'web.add-domain.customer' => '選擇一個客戶',
    'web.add-domain.createNewCustomer' => '創建一個新客戶',
    'web.add-domain.selectExistingCustomer' => '選擇一名現有客戶：',
    'web.add-domain.customerContactInfoHint' => '輸入客戶聯繫資訊。您可以稍後指定所有其它資訊，如電話號碼和位址。',
    'web.add-domain.customerLoginInfoHint' => '客戶面板的驗證憑據',
    'web.add-domain.target' => '主機空間',
    'web.add-domain.createNewTarget' => '創建一個新訂閱',
    'web.add-domain.createNewTarget_powerUser' => '創建新主機空間',
    'web.add-domain.selectExistingTarget' => '選擇一個現有訂閱：',
    'web.add-domain.selectExistingTarget_powerUser' => '選擇一個現有主機空間：',
    'web.add-domain.dns' => '啟動 DNS 服務',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => '啟動郵件服務',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => '如果訂閱的設定允許按每域名管理郵件許可權則適用。如果不允許，將從訂閱獲取實際的郵件服務狀態。',
    'web.add-domain.hostingManagementOptions' => '主機類型',
    'web.add-domain.websiteHosting' => '網站主機',
    'web.add-domain.websiteForwarding' => '轉發',
    'web.add-domain.websiteNoHosting' => '無主機',
    'web.add-domain.hostingSettingsSectionLegend' => '主機設定',
    'web.add-domain.domainCreatedSuccessfully' => '成功創建域名%%domainName%%。',
    'web.add-domain.webspaceLegend' => '主機空間設定',
    'web.add-domain.addWhmWebsiteTitle' => '添加新網站',
    'web.add-domain.addWhmWebsiteHint' => "您可以選擇在伺服器上託管網站。",
    'web.add-domain.selectWhmDomain' => '選擇域名',
    'web.add-domain.customerLegend' => '客戶資訊',
    'web.add-domain.credentials' => '系統使用者驗證憑據',
    'web.add-domain.credentialsHint' => '通過 FTP 和 SSH 存取託管的檔',
    'web.add-domain.buttonAddDomain' => '添加網站',

    'web.add-subdomain.formTitle' => '添加子域名',
    'web.add-subdomain.formGeneralHint' => '子域名是網站其它部分的互聯網位元址。子域名包含主域名和一個首碼。如，若域名是 domain.com，子域名則可能是 store.domain.com。',
    'web.add-subdomain.formGeneralHintAdditional' => '您還可通過輸入 * 符號替代名稱創建一個萬用字元子域名。不管網站訪客在瀏覽器中輸入的域名是什麼都會被重導向至該子域。',
    'web.add-subdomain.subdomainName' => '子域名',
    'web.add-subdomain.subdomainNameHint' => '輸入 * 創建萬用字元子域名。',
    'web.add-subdomain.forDomain' => '父級域名',
    'web.add-subdomain.subdomainCreatedSuccessfully' => '已創建子域名。',
    'web.add-subdomain.hostingSettingsSectionLegend' => '主機設定',

    'web.change-hosting.formGeneralHint' => '您可以選擇在伺服器上託管網站（網站主機），設定 web 轉發到其它網站（轉發），或使用域的 DNS 區域在該域名下擁有一個郵箱（無主機）。',
    'web.change-hosting.changed' => '已成功更改 %%domainName%% 的主機類型。',
    'web.change-hosting.hostingManagementOptions' => '主機類型',
    'web.change-hosting.websiteHosting' => '網站主機',
    'web.change-hosting.websiteForwarding' => '轉發',
    'web.change-hosting.websiteNoHosting' => '無虛擬主機',
    'web.change-hosting.hostingSettingsSectionLegend' => '主機設定',
    'web.change-hosting.userName' => '用戶名',
    'web.change-hosting.userNameHint' => '管理訂閱內的檔和資料夾的系統使用者。',
    'web.change-hosting.userNameHint_powerUser' => '管理主機空間內的檔和資料夾的系統使用者。',
    'web.change-hosting.emptyLogin' => '請指定用戶名。',
    'web.change-hosting.password' => '密碼',
    'web.change-hosting.emptyPassword' => '請指定密碼。',
    'web.change-hosting.passwordConfirmation' => '確認密碼',
    'web.change-hosting.warningInstalledApplications' => '在網站上安裝了 web 應用程式。如果您更改主機類型，將無法存取它們。',
    'web.change-hosting.removeWebsiteHostingTitle' => '警告：將會刪除網站的內容。',
    'web.change-hosting.removeWebsiteHostingDescription' => '您要更改網站的主機類型嗎？',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => '將刪除下面的資料夾和其所有內容：',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => '將刪除主機空間根資料夾的所有內容。',

    'web.change-status.changed' => '已成功更改 %%domainName%% 的網站狀態。',
    'web.change-status.statusManagementOptions' => '網站狀態',
    'web.change-status.statusDisabled' => '禁用（以前稱為掛起）',
    'web.change-status.statusSuspended' => '掛起',
    'web.change-status.statusActive' => '活動',
    'web.change-status.statusDisabledHint' => '網站將不再託管於伺服器上，除了通過 FTP 用戶端和檔案管理員之外，將無法存取。訪客將會看到 web 伺服器的預設頁面。郵件服務將不可用。',
    'web.change-status.statusSuspendedHint' => '網站將繼續託管於伺服器上，但是訪客將被以 503 HTTP 代碼重定向至自訂錯誤文檔頁面。郵件服務將繼續可用。在此處您可以 %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => '儘管網站仍託管於伺服器上但是訪客將會被重定向至自訂的錯誤文檔頁面（帶有搜尋引擎友好 503 HTTP 代碼）。而郵件服務將繼續可用。',
    'web.change-status.error503PageLink' => '編輯自訂錯誤文檔',
    'web.change-status.statusActiveHint' => '網站將正常運行。',
    'web.change-status.notActivatedSuspended' => '無法啟動域名或網站 %%domainName%% 因為它已被主機提供商掛起。',
    'web.change-status.notActivatedDisabled' => '無法啟動域名或網站 %%domainName%% 因為它已被主機提供商禁用。',

    'web.edit.formTitle' => '%%name%% 的主機存取權限',
    'web.edit.formGeneralHint' => '在此處您可以查看與您訂閱相關聯的 IP 位址以及更改系統使用者的用戶名和密碼。',
    'web.edit.formGeneralHint_powerUser' => '在此處您可以查看與您主機空間相關聯的 IP 位址以及更改系統使用者的用戶名和密碼。',
    'web.edit.ipAddressesLegend' => 'IP 地址',
    'web.edit.ipAddresses' => 'IP 地址',
    'web.edit.certificateLegend' => '證書',
    'web.edit.certificateFromDomainRepository' => '%%name%%（%%repositoryName%%）',
    'web.edit.certificateFromOtherRepository' => '%%name%% (另一用戶所有)',
    'web.edit.userAccountLegend' => '系統使用者',
    'web.edit.systemUserHint' => '您可在此指定一個作業系統使用者，用於通過 FTP 或檔案管理員管理訂閱內的檔和資料夾。如果允許相應的許可權，還可使用該系統使用者通過 SSH (Linux) 或 RDP (Windows) 存取 Plesk。',
    'web.edit.systemUserHint_powerUser' => '您可在此指定一個作業系統使用者，用於通過 FTP 或檔案管理員管理主機空間內的檔和資料夾。如果允許相應的許可權，還可使用該系統使用者通過 SSH (Linux) 或 RDP (Windows) 存取 Plesk。',
    'web.edit.login' => '用戶名',
    'web.edit.emptyLogin' => '請指定用戶名。',
    'web.edit.password' => '密碼',
    'web.edit.passwordConfirmation' => '確認密碼',
    'web.edit.emptyPassword' => '請指定密碼。',
    'web.edit.emptyPasswordConfirmation' => '請確認密碼。',
    'web.edit.shellUnix' => "通過SSH存取伺服器",
    'web.edit.shellHintUnix' => "使用系統使用者憑據通過SSH存取伺服器。",
    'web.edit.shellWin' => '通過遠端桌面存取伺服器',
    'web.edit.shellHintWin' => "通過遠端桌面使用系統使用者的驗證憑據存取伺服器。",
    'web.edit.diskQuotaLegend' => '磁碟空間的硬配額',
    'web.edit.diskQuotaHint' => '磁碟空間硬配額是可用磁片量的限制。若硬配額已設定，且所有分配的磁碟空間已使用，將無法對檔執行進一步操作。',
    'web.edit.diskQuota' => '磁碟空間硬配額',
    'web.edit.diskQuotaUnlimited' => '無限',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => '無限。因伺服器檔案系統配置，導致硬碟配額不受支援。',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => '成功更新主機設定。',
    'web.edit.affectedDomainsLegend' => '應用這些設定的網站',
    'web.edit.affectedDomainsHint' => '以下網站與當前的系統使用者相關聯。您在該頁面上對主機存取所做的設定更改將會應用於這些網站。',

    'web.mobile.create.formTitle' => '創建移動',
    'web.mobile.create.formGeneralHint' => '指定移動網站名 — 可存取移動網站的URL。通常使用的首碼是"m"、"mob"、"mobi"、"mobile"，如: mobile.example.com。您可以使用此URL，則"移動版本"出現在常規網站連結中，因此您的網站訪客則可在移動及常規版本之間切換。',
    'web.mobile.create.prefix' => '網站名',
    'web.mobile.create.emptySiteName' => '移動站名名不可以為空，則會與您的常規網站衝突。',

    'web.security-section.securitySectionLegend' => '安全',
    'web.security-section.securitySectionHint' => '要保證您網站的交易安全，可使用 SSL/TLS 協定，該協定可加密所有資料並通過安全的連接來傳輸資料。要啟用 SSL/TLS 支援，請將此網站移向獨立 IP 位址，然後在網站上安裝 SSL/TLS 證書，最後在下面選擇該證書。',
    'web.security-section.securitySectionSniHint' => '要保證您網站的交易安全，可使用 SSL/TLS 協定，該協定可加密所有資料並通過安全的連接來傳輸資料。要啟用 SSL/TLS 支援，請在網站上安裝 SSL/TLS 證書，最後在下面選擇該證書。',
    'web.security-section.enableSslSupport' => 'SSL/TLS 支援',
    'web.security-section.enableSslRedirect' => 'SEO 安全 301 永久重定向（從 HTTP 到 HTTPS）',

    'web.seo-settings.seoRedirectDirection' => '偏好域名',
    'web.seo-settings.seoRedirectDirectionHint' => '選擇將要通過 SEO 安全 HTTP 301 重定向將網站訪客重定向到的 URL（有或無 www. 首碼）。',
    'web.seo-settings.seoRedirectDirectionNone' => '無',

    'web.settings.formGeneralHint' => '您可在此配置網站主機設定並選擇網站可用的功能。',
    'web.settings.hostingType' => '主機類型',
    'web.settings.websiteHosting' => '網站',
    'web.settings.forwardingHosting' => '轉發',
    'web.settings.noHosting' => '無主機',
    'web.settings.changeHosting' => '更改',
    'web.settings.websiteStatus' => '網站狀態',
    'web.settings.changeStatus' => '更改',
    'web.settings.active' => '活動',
    'web.settings.suspended' => '掛起',
    'web.settings.disabled' => '禁用',
    'web.settings.webScriptingSectionLegend' => '網站腳本和統計',
    'web.settings.webScriptingSectionHint' => '指定可由 web 伺服器解釋、執行或處理的程式設計和指令碼語言。',
    'web.settings.__asp_win_support' => 'Microsoft ASP支援',
    'web.settings.__asp_dot_net_support' => 'Microsoft ASP.NET支援',
    'web.settings.__asp_dot_net_version' => '版本',
    'web.settings.__asp_dot_net_version_readonly' => '版本%%value%%',
    'web.settings.__ssi_support' => 'SSI支援',
    'web.settings.__ssi_with_html' => '使用*.htm, *.html文件用於SSI',
    'web.settings.__php_support' => 'PHP支援',
    'web.settings.__php_run_as' => '運行 PHP 以',
    'web.settings.__php_served_by_apache' => '由 Apache 服務',
    'web.settings.__php_served_by_nginx' => '由 nginx 服務',
    'web.settings.__cgi_support' => 'CGI支援',
    'web.settings.__cgi_bin_mode' => 'cgi-bin目錄位於',
    'web.settings.__cgi_bin_mode_webspace' => '主機空間的根目錄',
    'web.settings.__cgi_bin_mode_www_root' => '此域名的文檔根',
    'web.settings.__cgi_bin_mode_old_style' => '該域名舊式的根目錄',
    'web.settings.__cgi_bin_mode_readonly' => 'cgi-bin目錄位於%%value%%',
    'web.settings.__perl_unix_support' => 'Perl支援',
    'web.settings.__perl_win_support' => 'Perl支援',
    'web.settings.__python_unix_support' => 'Python支援',
    'web.settings.__python_win_support' => 'Python支援',
    'web.settings.__fastcgi_unix_support' => 'FastCGI 支援',
    'web.settings.__webstat_support' => '網站統計',
    'web.settings.__plesk_stat_protect' => '使用您的 FTP 用戶名和密碼對您的網站統計存取權限加以保護',
    'web.settings.__plesk_stat_protected' => '使用您的 FTP 用戶名和密碼保護對您的 web 統計的存取權限',
    'web.settings.__apache_errdocs' => '自訂錯誤文檔',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'FastCGI應用程式',
    'web.settings.__php_cgi_handler' => 'CGI應用程式',
    'web.settings.__php_isapi_handler' => 'ISAPI擴展',
    'web.settings.__php_version' => 'PHP 版本',
    'web.settings.__hosting_write_modify' => '其它寫入/修改許可權',
    'web.settings.__hosting_webdeploy' => 'Web Deploy 發佈',
    'web.settings.awstats' => 'AWstats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => '無',
    'web.settings.activate' => '啟動',
    'web.settings.deactivate' => '取消啟動',
    'web.settings.__php_support_readonly' => '版本： %%version%%; 處理器： %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => '未註冊',
    'web.settings.domainName' => '域名',
    'web.settings.domainNameHint' => "例如，example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => '繼承選項“分離 SSL/TLS 與非 SSL/TLS 內容”的相容模式',
    'web.settings.sameSslCompatibilityModeCheckbox' => '在繼承選項 “分離 SSL/TLS 與非 SSL/TLS 內容”的相容模式下運行網站',
    'web.settings.sameSslCompatibilityHint' => '您看到了該部分是因為您在升級前選定了“分離 SSL/TLS 與非 SSL/TLS 內容”選項。在 Plesk 11 中，該選項已被棄用。所有在 Plesk 11 中創建的網站都會使用同一個目錄存放通過 HTTP 和 HTTPS 連接獲取的內容。這表示該網站仍在相容模式中運行，但是您無法通過 Plesk 對其進行管理。強力建議您從 httpsdocs/ 目錄移動所有資料到 httpdocs/，之後關閉相容模式。關閉相容模式後，您將無法再重新打開該模式，而此部分將不再顯示。請注意如果當打開了相容模式時安裝了應用程式到 httpsdocs/ 目錄，那麼該應用程式將無法通過互聯網進行存取。如果您想要安裝應用程式到 httpsdocs/，請關閉相容模式。',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => '網站設定將在%%restartInterval%% 分鐘後被應用。',
    'web.settings.phpSettingsDescription' => '該頁面會顯示網站的 PHP 配置。這些設定針對該網站，而不會影響訂閱上的其它網站。如果主機提供商給以您相應的許可權則可以更改 PHP 配置。當您想要限制 PHP 腳本消耗的系統資源或想要達到某個 web 應用程式的要求時，自訂 PHP 配置可能會有用。當您設定一個參數為預設值時，PHP 會使用伺服器級的 PHP 配置的該參數值。',
    'web.settings.phpSettingsAvailableVariables' => '您可在參數值中使用以下預留位置：',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} 代表網站的文檔根目錄。當前的值為 %%DOCROOT%%。%%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'HTTPS 文檔根目錄與 http 的相同。',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'HTTPS 文檔根目錄是 %%DOCROOT%%。',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} 代表訂閱主網站的文檔根目錄。',
    'web.settings.phpSettingsVariableTmp' => '{TMP} - 用於存儲暫存檔案的目錄。',
    'web.settings.phpSettingsPhpVersion' => '您的 PHP 版本是 %%version%%。',
    'web.settings.phpSettingsPhpDisabled' => 'PHP 已被關閉。',
    'web.settings.phpHandlerTypeHint' => '注意更改 PHP 處理常式類型可能會中斷該網站上現有 PHP 腳本的運行。',
    'web.settings.phpHandlerChangeHint' => '您已更改了 PHP handler 設定。如果您保存這些更改，您網站上的 PHP 腳本可能會因您的伺服器配置停止 %%interval%% 秒。',
    'web.settings.phpHandlerTypeHelpLink' => '瞭解如何選擇最適合的 PHP 設定',
    'web.settings.phpHandlerTypeNotAvailableHint' => '不能禁用 PHP 支援，因為當前的主機配置不包括任何該功能變數名稱可以使用的 PHP 版本。',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => '了解如何啟用其他 PHP 版本。',
    'web.settings.phpHandlerBroken' => '當前選定的 PHP 處理常式已損壞。選擇一個其它的處理常式。',
    'web.settings.phpHandlerOutdated' => '（已過時）',
    'web.settings.phpHandlerDeprecated' => '（已棄用）',

    'web.setupService.formTitle' => '設定服務： %%serviceReference%%',
    'web.setupService.successfullyUpdated' => '已成功更新 \'%%serviceReference%%\' 服務。',

    'web.site-copy.subdomainsGroup' => '%%siteName%%子域名：',
    'web.site-copy.destinationTypeSection' => '複製目標',
    'web.site-copy.destinationType' => '選擇複製網站檔的位址',
    'web.site-copy.destinationTypeSite' => 'Plesk 中的網站',
    'web.site-copy.destinationTypeSiteDescription' => '複製網站文件到該帳戶下託管的其他網站。如果您有 FTP，存取伺服器上的其他帳戶，請使用 FTP 存儲選項。',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => '複製網站檔到伺服器上託管的其他網站。',
    'web.site-copy.destinationTypeSiteSelect' => '網站名稱',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "網站檔 %%source%% 無法複製到 %%destination%% 因為 %%destination%% 是檔當中的一部分 — 其文檔根是 %%source%% 文檔根的子目錄。",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "網站檔 %%destination%%  無法移除因為 %%source%% 檔是其中一部分 — %%source%% 文檔根是 %%destination%% 的子目錄。",
    'web.site-copy.destinationTypeFtp' => 'FTP 存儲',
    'web.site-copy.destinationTypeFtpDescription' => '複製網站檔到此伺服器或外部伺服器上的一個 FTP 帳戶。',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => '複製網站檔到一個外部伺服器上的 FTP 帳戶。',
    'web.site-copy.destinationTypeFtpHost' => "伺服器主機名稱",
    'web.site-copy.destinationTypeFtpPort' => "埠",
    'web.site-copy.destinationTypeFtpFolder' => '目錄',
    'web.site-copy.destinationTypeFtpUser' => '用戶名',
    'web.site-copy.destinationTypeFtpPassword' => '密碼',
    'web.site-copy.destinationTypeFtpMode' => 'FTP 連接方式',
    'web.site-copy.destinationTypeFtpModeActive' => '主動模式',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => '在主動模式中，Plesk 會發送其 IP 位址和將要監聽的埠號到一台外部伺服器，而該伺服器會啟動 TCP 連接。如果服務 Plesk 的伺服器沒有防火牆保護，建議使用該模式。',
    'web.site-copy.destinationTypeFtpModePassive' => '被動模式',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => '如果服務 Plesk 的伺服器有防火牆保護而無法接受傳入 TCP 連接，則可使用被動模式。',
    'web.site-copy.existingFiles' => '如何處理現有的文件',
    'web.site-copy.existingFilesKeep' => '保留目的網站上的現有檔',
    'web.site-copy.existingFilesKeepDescription' => '覆蓋目的網站上同名的現有檔。',
    'web.site-copy.existingFilesDelete' => '刪除所有現有檔',
    'web.site-copy.existingFilesDeleteDescription' => '複製前，刪除目的網站上的檔。',
    'web.site-copy.emptyLogin' => '指定一個 FTP 帳戶用戶名。',
    'web.site-copy.emptyHost' => '指定一個伺服器主機名稱。',
    'web.site-copy.emptyPort' => '指定一個伺服器主機埠。',
    'web.site-copy.copyInProgress' => '複製網站 %%sourceName%% 到 %%destinationName%%。將會通過郵件通知您其進程(%%email%%)。',
    'web.site-copy.unableToCopy' => '複製網站檔失敗。',
    'web.site-copy.siteCopied' => '網站檔已複製過。',
    'web.site-copy.emailSubjSuccess' => '已複製過網站 "%%source%%" 文件。',
    'web.site-copy.emailSubjFailure' => '複製網站 "%%source%%" 檔失敗。',
    'web.site-copy.emailBodySuccess' => '網站 "%%source%%"  檔複製到 "%%destination%%"。',
    'web.site-copy.emailBodyFailure' => '複製網站 "%%source%%" 檔到 "%%destination%%" 失敗： %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => '轉發設定',
    'web._shared.forwardDestination' => '目標位址',
    'web._shared.forwardDestinationHint' => '目的網站的 URL',
    'web._shared.forwardingTypeOptions' => '轉發類型',
    'web._shared.forwardingFrame' => '幀轉發',
    'web._shared.forwardingFrameHint' => '重定向網站訪客到另一網站，但不向訪客顯示目標位址，讓訪客不知道被重定向。',
    'web._shared.forwardingHttpCode301' => '永久移動（代碼 301）',
    'web._shared.forwardingHttpCode301Hint' => '重定向網站存取者到其它網站並向他們顯示目的地址。此類重定向會保持網站搜尋引擎的排名。',
    'web._shared.forwardingHttpCode302' => '暫時移動（代碼 302）',
    'web._shared.forwardingHttpCode302Hint' => '當您不想讓搜尋引擎索引此預備網站時，可重定向存取者到預備網站副本。',
    'web._shared.documentRoot' => '文檔根目錄',
    'web._shared.documentRootHint' => '進入網站主目錄的路徑。',
    'web._shared.documentRootHintDisabledDueApplications' => '因web應用程式安裝到此網站上，無法更改文檔根目錄。',
    'web._shared.ipAddress' => 'IP地址',
    'web._shared.shared' => '共用',
    'web._shared.exclusive' => '獨立',
    'web._shared.ipAddressHint' => "託管此網站的IP位址是網站虛擬主機的網路位址。",
    'web._shared.certificateFromDomainRepository' => '%%name%%（%%repositoryName%%）',
    'web._shared.certificateFromOtherRepository' => '%%name%%（其他庫）',
    'web._shared.certificate' => '證書',
    'web._shared.sameCertificatesHint' => '選定的證書將用於託管在同一獨立 IP 位址上的所有網站。',
    'web._shared.differentCertificatesHint' => '此訂閱與兩個帶有不同證書的獨立 IP 位址相關聯。選定的證書將代替安裝於託管在這兩個 IP 地址上的網站上的證書。',
    'web._shared.differentIpTypesCertificateHint' => '此訂閱與一個共用及一個獨立的 IP 位址關聯。選定的證書也將用於託管於獨立的 IP 位址上的所有其他網站。',
    'web._shared.certificateNotSelected' => '未選定',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => '在您的 repository 中沒有 SSL/TLS 證書。要添加證書請進入 %%link%%。',
    'web._shared.sslCertificatesRepositoryLink' => '此頁面',

    'web-user.settings.allowScripts' => '允許網站用戶使用腳本。',

    'web-user.name' => '用於通過 FTP 連接到伺服器的用戶名',
    'web-user.longName' => '該用戶名太長（允許最多 %max% 個字元）。',
    'web-user.password' => '密碼',
    'web-user.passwordConfirmation' => '確認密碼',
    'web-user.hardDiskQuota' => '磁碟空間配額',
    'web-user.hardDiskQuotaUnlimited' => '無限',
    'web-user.hardDiskQuotaIsNotSupported' => '（由於伺服器檔案系統的配置不支援硬碟配額）',
    'web-user.megabytes' => 'MB',

    'requiredFields' => '必填欄位',
];