<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Toegang geweigerd: uw account is opgeschort.",
    'login_up__login_has_been_locked' => "U hebt te vaak geprobeerd om u aan te melden met een onjuist wachtwoord. Om veiligheidsredenen kunt u zich nu enige tijd niet meer aanmelden met deze gebruikersnaam.",
    'login_up__login_label_plesk' => "Aanmelden bij %1", // PFU
    'login_up__login_label_parallels' => "Aanmelden bij Plesk %1",
    'login_up__login_text' => "Uw gebruikersnaam en wachtwoord invoeren.",
    'login_up__unable_to_check_pass' => "Kan wachtwoord niet controleren: %1",
    'login_up__warning_limits_licence_key' => "Eén van de volgende onderdelen heeft de beperking overschreden die door uw licentiesleutel is ingesteld: aantal gebruikeraccounts, domeinen, mailaccounts of webgebruikers dat op uw server wordt gehost.\nNeem contact op met de verkoopafdeling van Plesk om een licentiesleutel aan te schaffen waarmee u het gewenste aantal gebruikers en domeinen kunt hosten. Neem contact op met de technische ondersteuning van Plesk als u denkt dat u deze boodschap ten onrechte hebt ontvangen.\nDe licentiebeperking voor gebruikeraccounts/domeinen/mailaccounts/webgebruikers/taakpakketten: %2.\nHet aantal accounts/domeinen/mailaccounts/webgebruikers/taakpakketten dat momenteel wordt gehost: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "De hoeveelheid middelen die u gebruikt heeft de beperkingen van uw huidige productlicentie overschreden. Neem contact op met de verkoopafdeling van Plesk voor het aanschaffen van een nieuwe licentiesleutel.",
    'login_up__grace_period' => 'U werkt momenteel binnen de gedoogperiode van uw productlicentie. Om uw productlicentie bij te werken, selecteer de optie Sleutels Ophalen op de %1Pagina Licentiebeheer%2.',
    'login_up__partner_license_message' => 'U werkt momenteel met een beperkte productlicentie die registratie vereist voorafgaand aan de activering van de volledige set functies. Om uw productlicentie bij te werken, selecteer de optie Sleutels Ophalen op de %1Pagina Licentiebeheer%2.',
    'login_up__system_admin_disabled' => 'De superuser (het root- of beheerderaccount) kan zich vanwege veiligheidsoverwegingen niet bij Plesk aanmelden.',
    'login_up__mobile_application_message' => 'Voor een betere ervaring raden wij u aan %%name%% te installeren.',
    'login_up__mobile_application_install' => 'Nu installeren',
    'login_up__mobile_application_hide' => 'Nee, bedankt',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk, Handleiding voor Beheerders",
    'plesk_guide_reseller' => "Plesk, Handleiding voor Resellers",
    'plesk_guide_client' => "Plesk, Handleiding voor cliënten",
    'plesk_guide_domain_admin' => "Plesk, Handleiding voor Domeinbeheerders",
    'plesk_guide_mailuser' => "Plesk, Handleiding voor E-mailgebruikers",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Zoeken', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Cliënten',
    'ui__reseller_unknown__quick-search' => 'Resellers',
    'ui__client/domain_unknown__quick-search' => 'Domeinen',
    'nav__general' => 'Hoofdmenu',
    '__home' => 'Startpagina',
    '__resellers' => 'Resellers',
    '__clients' => 'Cliënten',
    '__domains' => 'Domeinen',
    '__applications' => 'Toepassingen',
    '__settings' => 'Instellingen',
    'nav__system' => 'Systeem',
    '__master' => 'Primair',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Omhoog',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Verwijderen',
    'bt_make_default' => 'Als standaard instellen',

    // common list object operation errors
    'class_cList__empty_selection' => 'Geen objecten geselecteerd.',

    // common list object search keys
    'clist__search_show' => 'Zoekveld tonen',
    'clist__search_hide' => 'Zoeken verbergen',

    'bt_show_all' => "Zoekveld opnieuw instellen",

    // common object list info keys
    'clist__first' => 'Eerste',
    'clist__last' => 'Laatste',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Pagina\'s',
    'clist__page_size' => 'Aantal per pagina',
    'clist__info' => 'Totaal %1: %4',
    'clist__info_empty' => 'Geen %1',
    'clist__info_filter' => '%5 %1 gevonden (%4 totaal)',
    'clist__info_paging' => '%2-%3 %1 van %4 totaal',
    'clist__info_paging_filter' => '%2-%3 %1 van %5 gevonden (%4 totaal)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Actief',
    '__object_off' => 'Opschorten',

    '__home_description' => 'Terug naar startpagina',
    'indicator_title' => '%1% in gebruik, %2% beschikbaar', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Er is een ongeldige URL opgevraagd.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Reselleraccounts",
    'ui__reseller_unknown__title' => "Reselleraccounts",
    'ui__reseller_unknown__description' => "Reselleraccounts beheren.",
    'ui__reseller/client_unknown__short-title' => 'Cliëntaccounts',
    'ui__reseller/client_unknown__title' => 'Cliëntaccounts',
    'ui__reseller/client_unknown__description' => 'Cliëntaccounts beheren.',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => 'Nieuwe houder toewijzen aan cliëntaccounts',
    'ui__reseller/client/chowner_multi-select__short-title' => 'Nieuwe houder toewijzen',
    'ui__reseller/client/chowner_multi-select__description' => 'Een nieuwe houder aan geselecteerde cliëntaccounts toewijzen.',
    'ui__client/to-reseller_multi__title' => 'Cliëntaccounts omzetten naar reselleraccounts',
    'ui__client/to-reseller_multi__short-title' => 'Omzetten naar resellers',
    'ui__client/to-reseller_multi__description' => 'Geselecteerde gebruikeraccounts omzetten naar reselleraccounts.',
    'ui__reseller/to-client_multi__title' => 'Reselleraccounts omzetten naar cliëntaccounts',
    'ui__reseller/to-client_multi__short-title' => 'Omzetten naar cliënten',
    'ui__reseller/to-client_multi__description' => 'Geselecteerde reselleraccounts omzetten naar cliëntaccounts.',
    'ui__admin-alias_unknown__title' => "Extra beheerderaccounts", // PFW
    'ui__admin-alias_unknown__short-title' => "Extra beheerderaccounts", // PFW
    'ui__admin-alias_unknown__description' => "Extra beheerderaccounts bekijken en beheren.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Instellingen mailserver",
    'ui__server/mail__title' => "Instellingen mailserver",
    'ui__server/mail__description' => "Uw mailserver instellen en mailinstellingen voor de server als geheel configureren.",
    'ui__server/dns__short-title' => 'DNS-instellingen',
    'ui__server/dns__title' => 'DNS-instellingen',
    'ui__server/dns__description' => 'Loop de DNS-instellingen voor de server als geheel na en wijzig deze waar nodig.',
    'ui__server/components__short-title' => 'Servercomponenten',
    'ui__server/components__title' => 'Servercomponenten',
    'ui__server/components__description' => 'Bekijk informatie over de op de server geïnstalleerde systeemcomponenten die worden gebruikt door Plesk.',
    'ui__server/services__short-title' => 'Beheer van diensten',
    'ui__server/services__title' => 'Beheer van diensten',
    'ui__server/services__description' => 'Start, stop of herstart de diensten van Plesk.',
    'ui__server/db__short-title' => 'Database-servers',
    'ui__server/db__title' => 'Database-servers',
    'ui__server/db__description' => 'Database-servers voor de server als geheel bekijken en beheren.',
    'ui__server/crontab/task_unknown__short-title' => 'Ingeroosterde taken',
    'ui__server/crontab/task_unknown__title' => 'Ingeroosterde taken',
    'ui__server/crontab/task_unknown__description' => 'Ingeroosterde taken voor de server als geheel toevoegen en verwijderen.',
    'ui__server/ip-address_unknown__short-title' => 'IP-adressen',
    'ui__server/ip-address_unknown__title' => 'IP-adressen',
    'ui__server/ip-address_unknown__description' => 'IP-adressen bekijken, toevoegen en verwijderen; IP-adressen toewijzen aan resellers.',
    'ui__promotion/smartermail__short-title' => 'SmarterMail downloaden',
    'ui__promotion/smartermail__title' => 'SmarterMail downloaden',
    'ui__promotion/smartermail__description' => 'Open een nieuw venster met daarin de website van SmarterMail, van waaruit u de laatste versie van de SmarterMail-mailserver kunt downloaden. De SmarterMail website is gemaakt en wordt ondersteund door Smarter Tools Inc. Plesk is niet verantwoordelijk voor de inhoud van de website van SmarterMail. Plesk levert geen ondersteuning voor de SmarterMail Lite-mailserver.',
    // dropdowns
    'ui__server/tsclient__short-title' => 'Extern bureaublad',
    'ui__server/tsclient__title' => 'Extern bureaublad',
    'ui__server/tsclient__description' => 'Toegang tot de server via Extern bureaublad.',
    'ui__server/time__title' => 'Systeemtijd',
    'ui__server/time__short-title' => 'Systeemtijd',
    'ui__server/time__description' => 'Systeemdatum en -tijd wijzigen en synchronisatie met een NTP-server instellen.',
    'ui__server/odbc__title' => 'ODBC-gegevensbronnen', // PFW
    'ui__server/odbc__short-title' => 'ODBC-gegevensbronnen', // PFW
    'ui__server/odbc__description' => 'ODBC-gegevensbronnen instellen.', // PFW
    'ui__server/ftp-settings__short-title' => "FTP-instellingen", // PFW
    'ui__server/ftp-settings__title' => "FTP-instellingen", // PFW
    'ui__server/ftp-settings__description' => "FTP-configuratie voor de server als geheel instellen.", // PFW
    'ui__server/maillists__title' => 'Server voor verzendlijsten instellen', // PFU
    'ui__server/maillists__short-title' => 'Server voor verzendlijsten instellen', // PFU
    'ui__server/maillists__description' => 'Mailman-server voor verzendlijsten instellen', // PFU
    'ui__mass-email__short-title' => "E-mailberichten voor een grote groep", // PFW
    'ui__mass-email__title' => "E-mailberichten voor een grote groep", // PFW
    'ui__mass-email__description' => "E-mailberichten naar meerdere gebruikers tegelijkertijd versturen.", // PFW
    'ui__mass-mail__title' => 'E-mailberichten voor een grote groep', // PFU
    'ui__mass-mail__short-title' => 'E-mailberichten voor een grote groep', // PFU
    'ui__mass-mail__description' => 'E-mailberichten naar meerdere gebruikers tegelijkertijd versturen.', // PFU
    'ui__server/spam-filter__title' => 'Spamfilterinstellingen',
    'ui__server/spam-filter__short-title' => 'Spamfilterinstellingen',
    'ui__server/spam-filter__description' => 'Spamfilter voor de server als geheel instellen.',
    'ui__server/preferences__title' => "Serverinstellingen",
    'ui__server/preferences__short-title' => "Serverinstellingen",
    'ui__server/preferences__description' => "Het berekenen van statistieken voor de website als geheel instellen, de hostnaam van de server en andere server-instellingen wijzigen.",

    // interface
    // icons
    'ui__logo__short-title' => 'Branding van Plesk',
    'ui__logo__title' => 'Branding van Plesk',
    'ui__logo__description' => 'Nieuwe branding instellen voor Plesk, waarbij de logoafbeelding en de titelbalk van de browser worden gewijzigd.',

    // help & support
    // icons
    'ui__support__short-title' => 'Ondersteuning',
    'ui__support__title' => 'Ondersteuning',
    'ui__support__description' => 'Dien een verzoek in voor technische ondersteuning of bekijk meldingen die door uw klanten zijn ingediend.',
    'ui__license__short-title' => 'Licentiebeheer',
    'ui__license__title' => 'Plesk Licentiebeheer',
    'ui__license__description' => 'Bekijk informatie over uw licentie van Plesk en bestel nieuwe licentiesleutels.',
    'ui__help__short-title' => 'Contact',
    'ui__help__title' => 'Online hulp',
    'ui__help__description' => 'Online hulp bekijken.',
    'ui__news__short-title' => "Laatste nieuws",
    'ui__news__title' => "Laatste nieuws",
    'ui__news__description' => "Bekijk de lijst met wijzigingen in deze versie van Plesk.",
    'ui__server/autoinstaller__short-title' => 'Updates',
    'ui__server/autoinstaller__title' => 'Updates',
    'ui__server/autoinstaller__description' => 'Bijwerken van Plesk en componenten.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domeinen',
    'ui__client/domain_unknown__title' => 'Domeinen',
    'ui__client/domain_unknown__description' => 'Domeinen beheren.',
    'ui__server/skeleton__short-title' => 'Sjabloon voor virtuele hosts',
    'ui__server/skeleton__title' => 'Sjabloon voor virtuele hosts',
    'ui__server/skeleton__description' => 'Geef aan welke bestanden en mappen moeten worden geplaatst in de mappen van nieuw aangemaakte domeinen.',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => 'Domein aanmaken',
    'ui__client/domain/properties_unknown-new__short-title' => 'Domein aanmaken',
    'ui__client/domain/properties_unknown-new__description' => 'Een domein aanmaken en instellen.',
    'ui__client/domain/chowner_multi-select__title' => 'Nieuwe houder toewijzen aan pakketten',
    'ui__client/domain/chowner_multi-select__short-title' => 'Nieuwe abonnementhouder toewijzen',
    'ui__client/domain/chowner_multi-select__description' => 'Nieuwe houder toewijzen aan geselecteerde pakketen',
    'ui__client/domain/to-client_multi__title' => 'Domeinbeheerderaccounts omzetten naar cliëntaccounts',
    'ui__client/domain/to-client_multi__short-title' => 'Omzetten naar cliënten',
    'ui__client/domain/to-client_multi__description' => 'Geselecteerde domeinbeheerderaccounts omzetten naar cliëntaccounts',
    'ui__client/domain/disable_multi__title' => 'Domeinen opschorten',
    'ui__client/domain/disable_multi__short-title' => 'Domeinen opschorten',
    'ui__client/domain/disable_multi__description' => 'Geselecteerde domeinen opschorten',
    'ui__client/domain/enable_multi__title' => 'Domeinen activeren',
    'ui__client/domain/enable_multi__short-title' => 'Domeinen activeren',
    'ui__client/domain/enable_multi__description' => 'Geselecteerde domeinen activeren',

    // icons
    'ui__admin/extras-domain__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'ASP.NET-instellingen', // PFW
    'ui__server/aspdotnet__title' => 'ASP.NET-instellingen', // PFW
    'ui__server/aspdotnet__description' => 'ASP.NET-configuratie voor de server als geheel instellen', // PFW
    'ui__server/sitebuilder__short-title' => 'Presence Builder-instellingen', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builder-instellingen', // PFU
    'ui__server/sitebuilder__description' => 'Presence Builder instellen voor het bewerken van websites die op deze server worden gehost.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Domein registreren',
    'ui__admin/register-domain__short-title' => 'Domein registreren',
    'ui__admin/register-domain__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Domein beheren',
    'ui__admin/manage-domain__short-title' => 'Domein beheren',
    'ui__admin/manage-domain__description' => 'Geregistreerde domeinnamen beheren via MyPlesk.com.',
    'ui__server/register__title' => 'Uw server registreren',
    'ui__server/register__short-title' => 'Server registreren',
    'ui__server/register__description' => 'Registreer uw server om u bij een affiliate-programma aan te sluiten',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Bewerking',
    'ui__actionlog__title' => 'Bewerkingslogboek',
    'ui__actionlog__description' => 'Download het bewerkingslogboek en beheer de instellingen daarvan.',
    'ui__notification_unknown__short-title' => 'Meldingen',
    'ui__notification_unknown__title' => 'Meldingen',
    'ui__notification_unknown__description' => 'Meldingen die worden verstuurd bij belangrijke events in Plesk bekijken en bewerken.',
    'ui__server/resources__short-title' => 'Verbruik',
    'ui__server/resources__title' => 'Verbruik',
    'ui__server/resources__description' => 'Het gebruik van systeembronnen bekijken.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Serverinformatie',
    'ui__server/statistics__title' => 'Serverinformatie',
    'ui__server/statistics__description' => 'Statistieken met betrekking tot de diensten die door Plesk worden beheerd.',
    'ui__admin/report__title' => 'Samenvattend verslag',
    'ui__admin/report__short-title' => 'Samenvattend verslag',
    'ui__admin/report__description' => 'Verslag over het gebruik van dataverkeer en middelen door resellers, cliënten en domeinen bekijken.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Periode van inactiviteit binnen sessie',
    'ui__sessions/properties__title' => 'Periode van inactiviteit binnen sessie',
    'ui__sessions/properties__description' => 'Tijd van inactiviteit instellen voor sessies in Plesk.',
    'ui__cp-access__short-title' => 'Toegang tot Plesk',
    'ui__cp-access__title' => 'Toegang tot Plesk',
    'ui__cp-access__description' => 'De toegang tot Plesk beperken.',
    'ui__sessions__short-title' => 'Actieve sessies',
    'ui__sessions__title' => 'Actieve sessies',
    'ui__sessions__description' => 'Bekijk actieve Plesk-sessies.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS-certificaten',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS-certificaten',
    'ui__server/certificate_unknown__description' => 'De lijst met SSL/TLS-certificaten.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Persoonlijke gegevens',
    'ui__admin-info__title' => 'Persoonlijke gegevens',
    'ui__admin-info__description' => 'Persoonlijke gegevens voor uw account bekijken.',
    'ui__admin-password__short-title' => 'Wachtwoord wijzingen',
    'ui__admin-password__title' => 'Wachtwoord wijzingen',
    'ui__admin-password__description' => 'Wachtwoord van uw account wijzigen.',
    'ui__admin/interface__short-title' => 'Schermvoorkeuren',
    'ui__admin/interface__title' => 'Voorkeuren beheerderscherm',
    'ui__admin/interface__description' => 'Schermvoorkeuren voor serverbeheerder wijzigen.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'Bestandsbeheer',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'Bestandsbeheer',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'Werken met bestanden en mappen via bestandsbeheer.',
    'ui__client/domain/hosting/tsclient_unknown__short-title' => 'Extern bureaublad', // PFW
    'ui__client/domain/hosting/tsclient_unknown__title' => 'Extern bureaublad', // PFW
    'ui__client/domain/hosting/tsclient_unknown__description' => 'Toegang tot de server via Extern bureaublad.', // PFW
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'SSH-terminal gebruiken voor toegang tot de server.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Afgeschermde mappen',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Afgeschermde mappen',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Toegang tot geselecteerde onderdelen van de website afschermen.',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => 'Virtuele mappen voor een domein aanmaken en beheren.', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Werken met fysieke en virtuele bestanden en mappen binnen een website.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => 'Webstatistieken',
    'ui__client/domain/report/web-stats_unknown__title' => 'Webstatistieken',
    'ui__client/domain/report/web-stats_unknown__description' => 'Statistieken bekijken over het aantal websitebezoeken.',
    'ui__reseller/limits__short-title' => 'Verbruik',
    'ui__reseller/limits__title' => 'Verbruik',
    'ui__reseller/limits__description' => 'De door reseller %1 verbruikte middelen bekijken en beheren.',
    'ui__reseller/limits_unknown__short-title' => 'Verbruik',
    'ui__reseller/limits_unknown__title' => 'Verbruik',
    'ui__reseller/limits_unknown__description' => 'Verbruik van middelen door reseller bekijken en beheren.',
    'ui__reseller/limits_self__short-title' => 'Verbruik',
    'ui__reseller/limits_self__title' => 'Verbruik',
    'ui__reseller/limits_self__description' => "Uw gebruik van middelen bekijken en beheren.",
    'ui__reseller/limits_readonly-self__short-title' => 'Verbruik',
    'ui__reseller/limits_readonly-self__title' => 'Verbruik',
    'ui__reseller/limits_readonly-self__description' => "Uw verbruik van middelen bekijken.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Door cliënten verbruikt dataverkeer',
    'ui__reseller/client/traffic_unknown__title' => 'Historie bekijken van bandbreedteverbruik per cliënt',
    'ui__reseller/client/traffic_unknown__description' => 'Verslagen bekijken over door cliëntaccounts verbruikt dataverkeer.',
    'ui__client/traffic_unknown__short-title' => "Door cliënten verbruikt dataverkeer", // temporary for presets
    'ui__client/traffic_unknown__title' => "Historie bekijken van bandbreedteverbruik per cliënt", // temporary for presets
    'ui__client/traffic_unknown__description' => "Verslagen bekijken over door cliëntaccounts verbruikt dataverkeer.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Logbeheer',
    'ui__client/domain/hosting/logs_unknown__title' => 'Logbeheer',
    'ui__client/domain/hosting/logs_unknown__description' => 'Logbestanden bekijken en logopschoning instellen.',
    // dropdowns
    'ui__reseller/report__title' => 'Samenvattend verslag',
    'ui__reseller/report__short-title' => 'Samenvattend verslag',
    'ui__reseller/report__description' => 'Verslag bekijken over het verbruik van dataverkeer en middelen door deze reseller.',
    'ui__reseller/report_unknown__title' => 'Samenvattend verslag',
    'ui__reseller/report_unknown__short-title' => 'Samenvattend verslag',
    'ui__reseller/report_unknown__description' => 'Verslag bekijken over het verbruik van dataverkeer en middelen voor reseller.',
    'ui__reseller/report_self__title' => 'Samenvattend verslag',
    'ui__reseller/report_self__short-title' => 'Samenvattend verslag',
    'ui__reseller/report_self__description' => 'Verslag bekijken over het door u verbruikte dataverkeer en de gebruikte middelen.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Branding van Plesk',
    'ui__client/logo_reseller__short-title' => 'Branding van Plesk',
    'ui__client/logo_reseller__description' => 'Nieuwe branding van Plesk voor reseller %1.',
    'ui__client/logo_unknown__title' => 'Branding van Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Branding van Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Nieuwe branding instellen voor Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Branding van Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Branding van Plesk',
    'ui__client/logo_self-reseller__description' => 'Nieuwe branding instellen voor uw Plesk.',
    'ui__reseller/permissions__title' => 'Rechten',
    'ui__reseller/permissions__short-title' => 'Rechten',
    'ui__reseller/permissions__description' => "De handelingen die reseller %1 kan uitvoeren in Plesk bekijken of wijzigen.",
    'ui__reseller/permissions_unknown__short-title' => 'Rechten',
    'ui__reseller/permissions_unknown__title' => 'Rechten',
    'ui__reseller/permissions_unknown__description' => "De handelingen die reseller kan uitvoeren in Plesk bekijken of wijzigen.",
    'ui__reseller/permissions_self__title' => 'Rechten',
    'ui__reseller/permissions_self__short-title' => 'Rechten',
    'ui__reseller/permissions_self__description' => 'Bekijk de lijst met bewerkingen die u in Plesk kunt uitvoeren.',
    'ui__reseller/permissions_readonly-self__title' => 'Rechten',
    'ui__reseller/permissions_readonly-self__short-title' => 'Rechten',
    'ui__reseller/permissions_readonly-self__description' => 'Bekijk de lijst met bewerkingen die u in Plesk kunt uitvoeren.',
    // dropdowns
    'ui__reseller/to-client__title' => 'Reselleraccount omzetten naar cliëntaccount',
    'ui__reseller/to-client__short-title' => 'Reseller omzetten naar cliënt',
    'ui__reseller/to-client__description' => 'Dit reselleraccount omzetten naar een cliëntaccount.',
    'ui__reseller/to-client_unknown__title' => 'Reselleraccount omzetten naar cliëntaccount',
    'ui__reseller/to-client_unknown__short-title' => 'Reseller omzetten naar cliënt',
    'ui__reseller/to-client_unknown__description' => 'Reselleraccount omzetten naar een cliëntaccount.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Sjabloon voor virtuele hosts',
    'ui__client/skeleton__short-title' => 'Sjabloon voor virtuele hosts',
    'ui__client/skeleton__description' => 'Geef aan welke bestanden en mappen moeten worden geplaatst in de mappen van nieuw aangemaakte domeinen.',
    'ui__client/skeleton_unknown__short-title' => 'Sjabloon voor virtuele hosts',
    'ui__client/skeleton_unknown__title' => 'Sjabloon voor virtuele hosts',
    'ui__client/skeleton_unknown__description' => 'Geef aan welke bestanden en mappen in de mapstructuur van nieuw aangemaakte domeinen moeten worden geplaatst.',
    // dropdowns
    'ui__client/domain/properties_new__title' => 'Domein aanmaken',
    'ui__client/domain/properties_new__short-title' => 'Domein aanmaken',
    'ui__client/domain/properties_new__description' => "Een domein aanmaken voor %1.",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Domeinaliassen',
    'ui__client/domain/domain-alias_unknown__title' => 'Domeinaliassen',
    'ui__client/domain/domain-alias_unknown__description' => 'De lijst bekijken met alternatieve namen voor uw domein.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS-instellingen',
    'ui__client/domain/dns_unknown__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_unknown__description' => 'Instellingen DNS-zone voor een domein beheren.',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly-unknown__description' => 'Instellingen DNS-zone voor een domein bekijken.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__client/domain/odbc_unknown__short-title' => 'ODBC-gegevensbronnen', // PFW
    'ui__client/domain/odbc_unknown__title' => 'ODBC-gegevensbronnen', // PFW
    'ui__client/domain/odbc_unknown__description' => 'ODBC-gegevensbronnen voor een domein instellen.', // PFW
    'ui__reseller/register-domain__short-title' => 'Domein registreren',
    'ui__reseller/register-domain__title' => 'Domein registreren',
    'ui__reseller/register-domain__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Domein registreren',
    'ui__reseller/register-domain_unknown__title' => 'Domein registreren',
    'ui__reseller/register-domain_unknown__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Domein registreren',
    'ui__reseller/register-domain_self__title' => 'Domein registreren',
    'ui__reseller/register-domain_self__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Domein beheren',
    'ui__reseller/manage-domain__short-title' => 'Domein beheren',
    'ui__reseller/manage-domain__description' => 'Geregistreerde domeinnamen beheren via MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Domein beheren',
    'ui__reseller/manage-domain_unknown__short-title' => 'Domein beheren',
    'ui__reseller/manage-domain_unknown__description' => 'Geregistreerde domeinnamen beheren via MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Domein beheren',
    'ui__reseller/manage-domain_self__short-title' => 'Domein beheren',
    'ui__reseller/manage-domain_self__description' => 'Geregistreerde domeinnamen beheren via MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP-adressen',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP-adressen',
    'ui__client/ipaddress_unknown-reseller__description' => 'IP-adressen beheren.',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS-certificaten',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS-certificaten',
    'ui__client/domain/certificate_unknown__description' => 'SSL/TLS-certificaten installeren en beheren.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'Bescherming tegen hotlinking', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'Bescherming tegen hotlinking', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'De bestanden tegen hotlinking beschermen.', // PFW
    'ui__reseller/sessions__short-title' => 'Actieve sessies',
    'ui__reseller/sessions__title' => 'Actieve sessies',
    'ui__reseller/sessions__description' => 'Bekijk actieve Plesk-sessies.',
    'ui__reseller/sessions_unknown__short-title' => 'Actieve sessies',
    'ui__reseller/sessions_unknown__title' => 'Actieve sessies',
    'ui__reseller/sessions_unknown__description' => 'Bekijk actieve Plesk-sessies.',
    'ui__reseller/sessions_self__short-title' => 'Actieve sessies',
    'ui__reseller/sessions_self__title' => 'Actieve sessies',
    'ui__reseller/sessions_self__description' => 'Bekijk actieve Plesk-sessies.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_unknown__title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_unknown__description' => 'De beperking van het bandbreedteverbruik en het aantal gelijktijdige verbindingen dat met een website kan worden gelegd bekijken of aanpassen.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'De beperking van het bandbreedteverbruik en het aantal gelijktijdige verbindingen dat met een website kan worden gelegd bekijken.',
    'ui__client/domain/hosting/php_unknown__short-title' => 'PHP-instellingen', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'PHP-instellingen', // PFW
    'ui__client/domain/hosting/php_unknown__description' => 'PHP voor een domein instellen.', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Mailaccounts binnen gebruikersaccount %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Sjabloon voor virtuele hosts',
    'ui__client/skeleton_self__title' => 'Sjabloon voor virtuele hosts',
    'ui__client/skeleton_self__description' => 'Geef aan welke bestanden en mappen in de mapstructuur van nieuw aangemaakte domeinen moeten worden geplaatst.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // Remote desktop - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Verbruik',
    'ui__client/limits__title' => 'Verbruik',
    'ui__client/limits__description' => "Het verbruik van middelen door cliënt %1 bekijken en beheren.",
    'ui__client/limits_unknown__short-title' => 'Verbruik',
    'ui__client/limits_unknown__title' => 'Verbruik',
    'ui__client/limits_unknown__description' => 'Het verbruik van middelen door cliënt bekijken en beheren.',
    'ui__client/limits_readonly__short-title' => 'Verbruik',
    'ui__client/limits_readonly__title' => 'Verbruik',
    'ui__client/limits_readonly__description' => 'Bekijk gebruik van middelen voor cliënt %1.',
    'ui__client/limits_self__short-title' => 'Verbruik',
    'ui__client/limits_self__title' => 'Verbruik',
    'ui__client/limits_self__description' => "Uw gebruik van middelen bekijken en beheren.",
    'ui__client/limits_readonly-self__short-title' => 'Verbruik',
    'ui__client/limits_readonly-self__title' => 'Verbruik',
    'ui__client/limits_readonly-self__description' => "Uw verbruik van middelen bekijken.",
    'ui__client/domain/traffic_unknown__short-title' => "Dataverkeerverbruik van domeinen %1",
    'ui__client/domain/traffic_unknown__title' => "Door domeinen verbruikt dataverkeer bekijken",
    'ui__client/domain/traffic_unknown__description' => "Verslagen over door domeinen verbruikt dataverkeer bekijken.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Samenvattend verslag',
    'ui__client/report__short-title' => 'Samenvattend verslag',
    'ui__client/report__description' => 'Verslag over het gebruik van dataverkeer en middelen door deze cliënt bekijken.',
    'ui__client/report_unknown__short-title' => 'Samenvattend verslag',
    'ui__client/report_unknown__title' => 'Samenvattend verslag',
    'ui__client/report_unknown__description' => 'Verslag over het gebruik van dataverkeer en middelen door cliënt bekijken.',
    'ui__client/report_self__short-title' => 'Samenvattend verslag',
    'ui__client/report_self__title' => 'Samenvattend verslag',
    'ui__client/report_self__description' => 'Verslag over het verbruik van dataverkeer en middelen bekijken.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Schermvoorkeuren',
    'ui__client/preferences__title' => 'Schermvoorkeuren',
    'ui__client/preferences__description' => 'Schermvoorkeuren van Plesk instellen voor cliënt %1.',
    'ui__client/preferences_unknown__short-title' => 'Schermvoorkeuren',
    'ui__client/preferences_unknown__title' => 'Schermvoorkeuren',
    'ui__client/preferences_unknown__description' => "Sessie- en scherminstellingen vastleggen voor Plesk van cliënt.",
    'ui__client/preferences_self__short-title' => 'Schermvoorkeuren',
    'ui__client/preferences_self__title' => 'Schermvoorkeuren',
    'ui__client/preferences_self__description' => 'Schermvoorkeuren instellen voor uw Plesk.',
    'ui__client/logo__title' => 'Branding van Plesk',
    'ui__client/logo__short-title' => 'Branding van Plesk',
    'ui__client/logo__description' => "Nieuwe branding instellen voor Plesk van cliënt %1.",
    'ui__client/logo_self__title' => 'Branding van Plesk',
    'ui__client/logo_self__short-title' => 'Branding van Plesk',
    'ui__client/logo_self__description' => 'Nieuwe branding instellen voor Plesk, waarbij de logoafbeelding en de titelbalk van de browser worden gewijzigd.',
    'ui__client/permissions__title' => 'Rechten',
    'ui__client/permissions__short-title' => 'Rechten',
    'ui__client/permissions__description' => "De handelingen die cliënt %1 kan uitvoeren in Plesk bekijken of wijzigen.",
    'ui__client/permissions_unknown__short-title' => 'Rechten',
    'ui__client/permissions_unknown__title' => 'Rechten',
    'ui__client/permissions_unknown__description' => "De handelingen die cliënt kan uitvoeren in Plesk bekijken of wijzigen.",
    'ui__client/permissions_self__title' => 'Rechten',
    'ui__client/permissions_self__short-title' => 'Rechten',
    'ui__client/permissions_self__description' => "Bekijk de lijst met bewerkingen die u in Plesk kunt uitvoeren.",
    'ui__client/permissions_readonly-self__title' => 'Rechten',
    'ui__client/permissions_readonly-self__short-title' => 'Rechten',
    'ui__client/permissions_readonly-self__description' => "Bekijk de lijst met bewerkingen die u in Plesk kunt uitvoeren.",
    // dropdowns
    'ui__client/chowner_select__title' => 'Nieuwe houder toewijzen aan cliëntaccount',
    'ui__client/chowner_select__short-title' => 'Nieuwe houder toewijzen aan cliënt',
    'ui__client/chowner_select__description' => 'Nieuwe houder toewijzen aan dit cliëntaccount.',
    'ui__client/chowner_unknown-select__short-title' => 'Nieuwe houder toewijzen aan cliëntaccount',
    'ui__client/chowner_unknown-select__title' => 'Nieuwe houder toewijzen aan cliënt',
    'ui__client/chowner_unknown-select__description' => 'Nieuwe houder toewijzen aan cliëntaccount.',
    'ui__client/to-reseller__title' => 'Cliëntaccount omzetten naar reselleraccount',
    'ui__client/to-reseller__short-title' => 'Cliënt omzetten naar reseller',
    'ui__client/to-reseller__description' => 'Dit cliëntaccount omzetten naar reselleraccount.',
    'ui__client/to-reseller_unknown__title' => 'Cliëntaccount omzetten naar reselleraccount',
    'ui__client/to-reseller_unknown__short-title' => 'Cliënt omzetten naar reseller',
    'ui__client/to-reseller_unknown__description' => 'Dit cliëntaccount omzetten naar reselleraccount.',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/extras-domain__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/extras-domain__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Domein registreren',
    'ui__client/register-domain__short-title' => 'Domein registreren',
    'ui__client/register-domain__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Domein registreren',
    'ui__client/register-domain_unknown__short-title' => 'Domein registreren',
    'ui__client/register-domain_unknown__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Domein registreren',
    'ui__client/register-domain_self__short-title' => 'Domein registreren',
    'ui__client/register-domain_self__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Domein beheren',
    'ui__client/manage-domain__short-title' => 'Domein beheren',
    'ui__client/manage-domain__description' => 'Geregistreerde domeinnamen beheren via MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Domein beheren',
    'ui__client/manage-domain_unknown__short-title' => 'Domein beheren',
    'ui__client/manage-domain_unknown__description' => 'Geregistreerde domeinnamen beheren via MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Domein beheren',
    'ui__client/manage-domain_self__short-title' => 'Domein beheren',
    'ui__client/manage-domain_self__description' => 'Geregistreerde domeinnamen beheren via MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP-adressen',
    'ui__client/ipaddress_unknown__short-title' => "IP-adressen",
    'ui__client/ipaddress_unknown__description' => "IP-adressen beheren.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Domeinaliassen',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Domeinaliassen',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'De lijst bekijken met alternatieve namen voor uw domein.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'Actieve sessies',
    'ui__client/sessions__title' => 'Actieve sessies',
    'ui__client/sessions__description' => 'Bekijk actieve Plesk-sessies.',
    'ui__client/sessions_unknown__short-title' => 'Actieve sessies',
    'ui__client/sessions_unknown__title' => 'Actieve sessies',
    'ui__client/sessions_unknown__description' => 'Bekijk actieve Plesk-sessies.',
    'ui__client/sessions_self__short-title' => 'Actieve sessies',
    'ui__client/sessions_self__title' => 'Actieve sessies',
    'ui__client/sessions_self__description' => 'Bekijk actieve Plesk-sessies.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'Bestandsbeheer',
    'ui__client/domain/hosting/file-manager__title' => 'Bestanden binnen domein %1 beheren',
    'ui__client/domain/hosting/file-manager__description' => "Via bestandsbeheer werken met bestanden en mappen op domein %1.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'Bestandsbeheer',
    'ui__client/domain/hosting/file-manager_self__title' => 'Bestandsbeheer',
    'ui__client/domain/hosting/file-manager_self__description' => "Werken met uw bestanden en mappen via bestandsbeheer.",
    'ui__client/domain/hosting/tsclient__short-title' => 'Extern bureaublad', // PFW
    'ui__client/domain/hosting/tsclient__title' => 'Extern bureaublad', // PFW
    'ui__client/domain/hosting/tsclient__description' => 'Toegang tot de server via Extern bureaublad.', // PFW
    'ui__client/domain/hosting/tsclient_self__short-title' => 'Extern bureaublad', // PFW
    'ui__client/domain/hosting/tsclient_self__title' => 'Extern bureaublad', // PFW
    'ui__client/domain/hosting/tsclient_self__description' => 'Toegang tot de server via Extern bureaublad.', // PFW
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'SSH-terminal gebruiken voor toegang tot de server.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'SSH-terminal gebruiken voor toegang tot de server.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'Afgeschermde mappen',
    'ui__client/domain/hosting/protected-directories__title' => 'Afgeschermde mappen',
    'ui__client/domain/hosting/protected-directories__description' => 'Toegang tot geselecteerde onderdelen van de website afschermen.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Afgeschermde mappen',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Afgeschermde mappen',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Toegang tot geselecteerde onderdelen van de website afschermen.',
    'ui__client/domain/hosting/virtual-directories__short-title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => 'Virtuele mappen voor domein %1 aanmaken en beheren.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => 'Virtuele mappen voor domein %1 aanmaken en beheren.', // PFW
    'ui__client/domain/hosting/web-directories__title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Werken met fysieke en virtuele bestanden en mappen binnen de site %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Virtuele mappen', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Werken met fysieke en virtuele bestanden en mappen binnen uw website.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => 'Webstatistieken',
    'ui__client/domain/report/web-stats__title' => 'Webstatistieken',
    'ui__client/domain/report/web-stats__description' => 'Statistieken bekijken over het aantal websitebezoeken.',
    'ui__client/domain/report/web-stats_self__short-title' => 'Webstatistieken',
    'ui__client/domain/report/web-stats_self__title' => 'Webstatistieken',
    'ui__client/domain/report/web-stats_self__description' => 'Statistieken bekijken over het aantal websitebezoeken.',
    'ui__client/domain/traffic__short-title' => 'Dataverkeerverbruik %1',
    'ui__client/domain/traffic__title' => 'Statistieken gegevensoverdracht voor domein %1',
    'ui__client/domain/traffic__description' => 'Statistieken van door het domein %1 verbruikt dataverkeer bekijken.',
    'ui__client/domain/traffic_self__short-title' => 'Dataverkeerverbruik',
    'ui__client/domain/traffic_self__title' => 'Door uw domein verbruikt dataverkeer bekijken',
    'ui__client/domain/traffic_self__description' => 'Verslag over door uw domein verbruikt dataverkeer bekijken',
    'ui__client/domain/hosting/logs__short-title' => 'Logbeheer',
    'ui__client/domain/hosting/logs__title' => 'Logbeheer',
    'ui__client/domain/hosting/logs__description' => 'Logbestanden bekijken en logopschoning instellen.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Logbeheer',
    'ui__client/domain/hosting/logs_self__title' => 'Logbeheer',
    'ui__client/domain/hosting/logs_self__description' => 'Logbestanden bekijken en logopschoning instellen.',
    // dropdowns
    'ui__client/domain/report__title' => 'Samenvattend verslag',
    'ui__client/domain/report__short-title' => 'Samenvattend verslag',
    'ui__client/domain/report__description' =>  'Verslag over het verbruik van dataverkeer en middelen bekijken.',
    'ui__client/domain/report_unknown__short-title' => 'Samenvattend verslag',
    'ui__client/domain/report_unknown__title' => 'Samenvattend verslag',
    'ui__client/domain/report_unknown__description' => 'Verslag over het verbruik van dataverkeer en middelen bekijken.',
    'ui__client/domain/report_self__short-title' => 'Samenvattend verslag',
    'ui__client/domain/report_self__title' => 'Samenvattend verslag',
    'ui__client/domain/report_self__description' => 'Verslag over het verbruik van dataverkeer en middelen bekijken.',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => 'Persoonlijke gegevens',
    'ui__client/domain/properties__title' => 'Persoonlijke gegevens',
    'ui__client/domain/properties__description' => 'Persoonlijke gegevens voor domeinbeheerderaccount wijzigen.',
    'ui__client/domain/properties_unknown__short-title' => 'Persoonlijke gegevens',
    'ui__client/domain/properties_unknown__title' => 'Persoonlijke gegevens',
    'ui__client/domain/properties_unknown__description' => 'Persoonlijke gegevens voor account wijzigen.',
    'ui__client/domain/properties_self__short-title' => 'Persoonlijke gegevens',
    'ui__client/domain/properties_self__title' => 'Persoonlijke gegevens',
    'ui__client/domain/properties_self__description' => 'Persoonlijke gegevens voor uw account bekijken.',
    // dropdowns
    'ui__client/domain/rename__title' => 'Naam van domein wijzigen',
    'ui__client/domain/rename__short-title' => 'Naam van domein wijzigen',
    'ui__client/domain/rename__description' => 'Naam van domein %1 wijzigen.',
    'ui__client/domain/rename_unknown__short-title' => 'Naam van domein wijzigen',
    'ui__client/domain/rename_unknown__title' => 'Naam van domein wijzigen',
    'ui__client/domain/rename_unknown__description' => 'De naam van een domein wijzigen:',
    'ui__client/domain/chowner_select__title' => 'Domein aan nieuwe houder toewijzen',
    'ui__client/domain/chowner_select__short-title' => 'Nieuwe houder toewijzen aan pakket',
    'ui__client/domain/chowner_select__description' => 'Nieuwe houder toewijzen aan het pakket',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Nieuwe houder toewijzen aan pakket',
    'ui__client/domain/chowner_unknown-select__title' => 'Nieuwe houder toewijzen aan pakket',
    'ui__client/domain/chowner_unknown-select__description' => 'Een nieuwe houder aan een pakket toewijzen.',
    'ui__client/domain/to-client__title' => 'Domeinbeheerderaccount omzetten naar cliëntaccount',
    'ui__client/domain/to-client__short-title' => 'Domeinbeheerder omzetten naar cliënt',
    'ui__client/domain/to-client__description' => 'Dit domeinbeheerderaccount omzetten naar een cliëntaccount',
    'ui__client/domain/to-client_unknown__short-title' => 'Domeinbeheerder omzetten naar cliënt',
    'ui__client/domain/to-client_unknown__title' => 'Domeinbeheerderaccount omzetten naar cliëntaccount',
    'ui__client/domain/to-client_unknown__description' => 'Domeinbeheerderaccount omzetten naar een cliëntaccount',
    'ui__client/domain/toggle__title' => 'Domein opschorten of activeren', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Domein opschorten of activeren', // for HP customization
    'ui__client/domain/toggle__description' => 'Domein %1 opschorten of activeren.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Domein opschorten of activeren', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Domein opschorten of activeren', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Een domein opschorten of activeren.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Domein activeren',
    'ui__client/domain/toggle_enable__short-title' => 'Domein activeren',
    'ui__client/domain/toggle_enable__description' => 'Domein %1 activeren.',
    'ui__client/domain/toggle_disable__title' => 'Domein opschorten',
    'ui__client/domain/toggle_disable__short-title' => 'Domein opschorten',
    'ui__client/domain/toggle_disable__description' => 'Domein %1 opschorten.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS-instellingen',
    'ui__client/domain/dns__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns__description' => 'Instellingen DNS-zone voor domein %1 beheren.',
    'ui__client/domain/dns_self__title' => 'DNS-instellingen',
    'ui__client/domain/dns_self__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_self__description' => 'Instellingen DNS-zone voor uw domein beheren.',
    'ui__client/domain/dns_disabled__title' => 'DNS-instellingen',
    'ui__client/domain/dns_disabled__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_disabled__description' => 'Instellingen DNS-zone voor domein %1 beheren.',
    'ui__client/domain/dns_self-disabled__title' => 'DNS-instellingen',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_self-disabled__description' => 'Instellingen DNS-zone voor uw domein beheren.',
    'ui__client/domain/dns_readonly__title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly__description' => 'Instellingen DNS-zone voor domein %1 bekijken.',
    'ui__client/domain/dns_readonly-self__title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly-self__description' => 'Instellingen DNS-zone voor uw domein bekijken.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Instellingen DNS-zone voor uw domein bekijken.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Instellingen DNS-zone voor uw domein bekijken.',
    'ui__client/domain/dns_slave__title' => 'DNS-instellingen',
    'ui__client/domain/dns_slave__short-title' => 'DNS-instellingen',
    'ui__client/domain/dns_slave__description' => 'Instellingen DNS-zone voor domein %1 beheren.',
    'ui__client/domain/dns_self-slave__title' => 'DNS-instellingen',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS-Instellingen',
    'ui__client/domain/dns_self-slave__description' => 'Instellingen DNS-zone voor uw domein beheren.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/domain/extras__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/domain/extras__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Hulpprogramma\'s van MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Extra hulpprogramma\'s en diensten vindt u op MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'ODBC-gegevensbronnen', // PFW
    'ui__client/domain/odbc__title' => 'ODBC-gegevensbronnen', // PFW
    'ui__client/domain/odbc__description' => 'ODBC-gegevensbronnen instellen voor domein %1.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'ODBC-gegevensbronnen', // PFW
    'ui__client/domain/odbc_self__title' => 'ODBC-gegevensbronnen', // PFW
    'ui__client/domain/odbc_self__description' => 'ODBC-gegevensbronnen voor uw domein instellen.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Domein registreren',
    'ui__client/domain/register__title' => 'Domein registreren',
    'ui__client/domain/register__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Domein registreren',
    'ui__client/domain/register_unknown__title' => 'Domein registreren',
    'ui__client/domain/register_unknown__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Domein registreren',
    'ui__client/domain/register_self__title' => 'Domein registreren',
    'ui__client/domain/register_self__description' => 'Een domeinnaam registreren via MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'Bescherming tegen hotlinking', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'Bescherming tegen hotlinking', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'Bestanden op domein %1 beschermen tegen hotlinking.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'Bescherming tegen hotlinking', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'Bescherming tegen hotlinking', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'Uw bestanden beschermen tegen hotlinking.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance__title' => 'Beperk het bandbreedteverbruik en het aantal toegestane verbindingen met uw website',
    'ui__client/domain/hosting/performance__description' => 'Bekijk de beperking van het bandbreedteverbruik voor domein %1 en voor het aantal gelijktijdige verbindingen dat ermee kan worden gelegd, of pas deze aan.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_readonly__title' => 'Beperk van bandbreedteverbruik en het aantal toegestane verbindingen met uw website',
    'ui__client/domain/hosting/performance_readonly__description' => 'De beperking van de door domein %1 verbruikte bandbreedte en het aantal gelijktijdige verbindingen dat ermee mogelijk is bekijken.',
    'ui__client/domain/hosting/performance_self__short-title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_self__title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_self__description' => 'Bekijk de beperking van het bandbreedteverbruik voor uw domein en voor het aantal gelijktijdige verbindingen dat ermee kan worden gelegd, of pas deze aan.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'Beperking van bandbreedte',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'De beperking van de door uw domein verbruikte bandbreedte en het aantal gelijktijdige verbindingen dat ermee mogelijk is bekijken.',
    'ui__client/domain/hosting/php__short-title' => 'PHP-instellingen', // PFW
    'ui__client/domain/hosting/php__title' => 'PHP-instellingen', // PFW
    'ui__client/domain/hosting/php__description' => 'PHP instellen voor domein %1.', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'PHP-instellingen', // PFW
    'ui__client/domain/hosting/php_self__title' => 'PHP-instellingen', // PFW
    'ui__client/domain/hosting/php_self__description' => 'PHP voor uw domein instellen.', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => 'U moet de cliëntaccounts selecteren die u naar reselleraccounts wilt omzetten.',
    'ui__client/chowner__empty_selection' => 'U moet de cliëntaccounts selecteren die u aan een nieuwe houder wilt toewijzen',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Hulpprogramma's",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Statistieken bekijken',
    'ui__client/domain-summary-report_unknown__title' => 'Statistieken bekijken',
    'ui__client/domain-summary-report_unknown__description' => 'Informatie over verbruikte middelen per domein bekijken.',
    'ui__client/domain-summary-report__short-title' => "Statistieken bekijken",
    'ui__client/domain-summary-report__title' => "Statistieken bekijken",
    'ui__client/domain-summary-report__description' => "Informatie over verbruikte middelen per domein bekijken.",
    'ui__client/domain-summary-report_self__short-title' => "Statistieken bekijken",
    'ui__client/domain-summary-report_self__title' => "Statistieken bekijken",
    'ui__client/domain-summary-report_self__description' => "De gegevens over door domeinen gebruikte middelen bekijken.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domeinen", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => 'Rechten controleren',
    'ui__client/domain/check-permissions_multi__title' => 'Rechtencontrole',
    'ui__client/domain/check-permissions_multi__description' => 'De toegangsrechten voor bestanden en mappen binnen een domein controleren. Als er fouten worden gevonden dan zullen deze automatisch worden gecorrigeerd.',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'U moet de domeinen selecteren die u wilt verwijderen',
    'ui__client/domain/properties__empty_selection' => 'U moet de domeinen selecteren die u wilt aanpassen',
    'ui__client/domain/chowner__empty_selection' => 'U moet de domeinen selecteren waaraan u een nieuwe houder wilt toewijzen',
    'ui__client/domain/check-permissions__empty_selection' => 'U moet de domeinen selecteren waarvan u de rechten van bestanden en mappen wilt controleren',
    'ui__client/domain/to-client__empty_selection' => 'U moet de domeinen selecteren waarvan u de beheerderaccounts wilt omzetten naar cliëntaccounts',

    // list objects filtering
    'domains_list__name__filter_title' => 'Naam',
    'domains_list__state__filter_title' => 'Verbruik',
    'domains_list__filter_state_any' => 'Alle',
    'domains_list__filter_state_overuse' => 'Beperkingen overschreden',
    'domains_list__filter_state_normal' => 'Binnen de beperkingen',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Alle',
    'domains_list__filter_status_blocked' => 'Opgeschort',
    'domains_list__filter_status_active' => 'Actief',
    'domains_list__ownership__filter_title' => 'Houderschap',
    'domains_list__filter_ownership_all' => 'Alle domeinen',
    'domains_list__filter_ownership_personal' => 'Alleen mijn domeinen',
    'domains_list__filter_owner_pname__filter_title' => 'Naam van houder',
    'domains_list__subrows__filter_title' => 'Tonen',
    'domains_list__subrows_off' => 'Alleen domeinen',
    'domains_list__subrows_subdomain_domainaliases' => 'Met subdomeinen en aliassen',
    'domains_list__subrows_subdomain' => 'Met subdomeinen',
    'domains_list__subrows_domainaliases' => 'Met aliassen',

    // objects list
    'domains_list__owner__title' => 'Houder',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Toepassingen opzoeken",
    'site_apps__promo_main_text' => "De Application Packaging Standard (APS)-catalogus bevat de lijst met toepassingen die binnen een domein of webruimte kunnen worden ingezet. Als u toepassingen wilt gebruiken die momenteel niet in de catalogus staan, dan kunt u dit eenvoudig doen door de instructies voor het maken van APS-pakketten te volgen; deze kunt u vinden op www.apsstandard.com",
    'site_apps__promo_download_now' => "Toepassingen downloaden:",
    'site_apps__promo_close' => "Dit blok sluiten",
    'site_apps__promo_preset__mostused' => '%1 populairste',
    'site_apps__promo_preset__lessused' => 'Volgende %1 populairste',
    'site_apps__promo_preset__all' => "Alles",
    'site_apps__promo_disclaimer_note' => 'Merk op dat toepassingen die vanuit de APS-catalogus worden geïnstalleerd zijn geleverd door andere bedrijven en organisaties en dat Plesk hiervoor geen ondersteuning kan leveren.',
    'site_apps__promo_preset__page_title' => '%1 APS-toepassingen',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Toepassingen toevoegen',

    // Errors
    'site_apps__no_applications_for_update' => 'U hebt geen toepassingen zijn geïnstalleerd in de Programmabibliotheek.',
    'site_apps__incorrect_download_preset_configuration' => 'Er zijn fouten aangetroffen in de configuratie van voorinstelling downloaden APS-catalogus.',
    'site_apps__aps_catalog_url_is_invalid' => 'Opgegeven URL is niet geldig.',
    'site_apps__no_updates_at_the_moment' => 'Er zijn op het moment geen updates voor de toepassing beschikbaar.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Onjuiste informatie ontvangen vanuit de APS-catalogus. Probeer het later opnieuw.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Instellingen van de APS-catalogus zijn opgeslagen, maar Plesk kon geen verbinding maken met de APS-catalogus die is opgegeven in de instellingen van de APS-catalogus (%1). Controleer of het adres van de APS-catalogus juist is en of de APS-catalogus op dit adres actief is.',
    'site_apps__cannot_retrieve_updates' => 'Kan op dit moment geen updates voor toepassingen downloaden: kan geen verbinding maken met de APS-catalogus (%1). Controleer of het adres van de APS-catalogus juist is en of de APS-catalogus op dit adres actief is.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Er zijn geen webtoepassingen beschikbaar om te installeren.',
    'site_apps__site_applications_already_installed_in_root' => 'Er zijn al andere webtoepassingen geïnstalleerd in de hoofdmap van deze virtuele hosts.',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET-webtoepassingen worden niet ondersteund op het Unix/Linux-platform",
    'site_apps__server_wide_packages_not_supported' => 'Webtoepassingen voor de server als geheel worden niet ondersteund',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "Er moeten nog %1 webtoepassingen aan de Programmabibliotheek worden toegevoegd.",
    'site_apps__applications_all_in_vault' => "De geselecteerde webtoepassingen zijn al aanwezig in de Programmabibliotheek.",
    'site_apps__applications_already_in_download_queue' => "%1 van de geselecteerde toepassingen worden op dit moment aan de Programmabibliotheek toegevoegd.",
    'site_apps__applications_already_in_valut' => "%1 van de geselecteerde toepassingen zijn al in de Programmabibliotheek opgenomen.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Overig (geen categorie)',

    // Errors
    'site_apps__no_applications_in_category' => 'Er zijn geen toepassingen beschikbaar in deze categorie. Selecteer een andere categorie.',
    'site_apps__no_category_selected__please_specify' => 'Selecteer een categorie in het linker menu. Alle beschikbare toepassingen in de geselecteerde categorie zullen in dit scherm worden getoond.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Beheerderaccount',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Algemeen',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Hostnaam wijzingen',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Beveiliging',
    'bt_setup_firewall' => 'Firewall instellen',
    'bt_manage_firewall_rules' => 'Firewall-regels beheren',
    'cu_firewall__rule' => 'Firewall-regel aanmaken',
    'cu_firewall__protocol' => 'Protocol voor de regel instellen (\'tcp\' of \'udp\')',
    'cu_firewall__name' => "Naam voor de regel instellen",
    'cu_firewall__disabled' => 'Indien \'waar\' wordt de regel na het aanmaken uitgeschakeld',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Selecteer DNS-server', // PFW
    'bt_soa_records_template' => 'Sjabloon voor SOA-records',
    'bt_dns_recursion' => 'Instellingen DNS-recursie',
    'bt_restrict_creation_of_subzones' => 'Het aanmaken van subzones beperken',

    'databases' => 'Databases',
    'bt_select_mssqlwebadmin' => 'Selecteer MS SQL-webadmin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Toepassingen',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Mail',
    'bt_select_mailserver' => 'Selecteer mailserver', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Antivirus selecteren', // PFW
    'bt_virus_protection_settings' => 'Antivirusinstellingen',
    'bt_select_spamfilter' => 'Selecteer spamfilter', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Selecteer webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Logbestanden & Statistieken',
    'bt_server_statistics_settings' => 'Instellingen voor serverstatistieken',
    'bt_select_web_statistics' => 'Beschikbare software voor webstatistieken', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk-interface',

    'components_and_modules' => 'Componenten & modules',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Watchdog instellen', // PFU
    'bt_setup_vpn' => 'VPN instellen', // PFU
    'bt_setup_samba' => 'Samba instellen',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Instellingen',
    'ui__client/domain/settings_self__short-title' => 'Instellingen',
    'ui__client/domain/settings_self__description' => 'Domeininstellingen bekijken en wijzigen.',

    'domain_administrator_account' => 'Domeinbeheerderaccount',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Accountinstellingen',

    'domain' => 'Domein',
    'bt_dns_soa_records' => 'DNS SOA-records',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Instellingen takenrooster',

    'website' => 'Website',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripts voor webgebruikers',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Selecteer SSL/TLS-certificaat',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Webstatistieken',
    'bt_log_rotation_settings' => 'Instellingen voor logopschoning',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Beperkingen", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Beleid bij meerverbruik en meerverkoop",
    'limits__overuse_policy_legend' => "Meerverbruik",
    'limits__oversell_policy_legend' => "Meerverkoop",
    'limits__reseller_overuse_description' => "Het overusebeleid bepaalt wat Plesk moet doen als er meer middelen worden gebruikt dan zijn toegewezen.",
    'limits__overuse_text' => "Beleid bij meerverbruik",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Schijfruimte en dataverkeer',
    'limit__disk_space' => 'Schijfruimte',
    'limit__max_traffic' => 'Dataverkeer',
    'limit_group__client' => 'Cliënten',
    'limit__max_cl' => 'Cliënten',
    'limit_group__domain' => 'Domeinen',
    'limit__max_dom' => 'Domeinen',
    'limit__max_dom_powerUser' => 'Abonnementen',
    'limit__max_subdom' => 'Subdomeinen',
    'limit__max_dom_aliases' => 'Domeinaliassen',
    'limit__max_wu' => 'Webgebruikers',
    'limit__max_subftp_users' => 'Extra FTP-accounts', // PFW
    'limit_group__mail' => 'Mail',
    'limit__max_box' => 'Postvakken',
    'limit__mbox_quota' => 'Omvang van postvak',
    'limit__total_mboxes_quota' => 'Totale beperking van postvakken', // PFW
    'limit__max_maillists' => 'Verzendlijsten',
    'limit_group__database' => 'Databases',
    'limit__max_mssql_db' => 'Microsoft SQL Server-databases', // PFW
    'limit__mssql_dbase_space' => 'Totale beperking MS SQL-databases', // PFW
    'limit__max_odbc' => 'ODBC-koppelingen', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Beperking MySQL-databases', // PFW?
    'limit_group__application' => 'Toepassingen',
    'limit__max_iis_app_pools' => 'IIS Groepen van toepassingen', // PFW
    'limit_group__security' => 'Beveiliging',
    'limit_group__validity' => 'Verloopdatum',
    'limit__expiration' => 'Verloopdatum',
    'limit__validity' => 'Geldigheidsduur',
    'limit__max_site_builder' => 'Met Presence Builder gepubliceerde sites',
    'limit__max_site' => 'Domeinen',
    'limit__mssql_dbase_filesize' => 'Bestandsgrootte MS SQL-database',
    'limit__mssql_dbase_log_filesize' => 'Grootte logbestand MS SQL-database',
    'limit__mssql_dbase_filesize_hint' => 'De maximale omvang van een bestand van een Microsoft SQL-database.',
    'limit__mssql_dbase_log_filesize_hint' => 'De maximale omvang van een logbestand van een Microsoft SQL-database.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Ongeldige beperking aantal domeinen. Minimale waarde is 1.',

    'property__has_wrong_value' => 'De eigenschap %1 heeft een onjuiste waarde.',
    'property__name_outgoing_messages_domain_limit' => 'Stelt de beperking in voor uitgaande berichten vanaf een domein (per uur). Om de waarde Onbeperkt in te stellen gebruikt u "-1". Geef "default" op om de waarde te gebruiken die is opgegeven in de instellingen voor de server als geheel.',
    'property__name_outgoing_messages_mbox_limit' => 'Stelt de beperking in voor uitgaande berichten vanuit een postvak (per uur). Om de waarde Onbeperkt in te stellen gebruikt u "-1". Geef "default" op om de waarde te gebruiken die is opgegeven in de instellingen voor de server als geheel.',
    'property__name_outgoing_messages_subscription_limit' => 'Stelt de beperking in voor uitgaande berichten voor een abonnement (per uur). Om de waarde Onbeperkt in te stellen gebruikt u "-1". Geef "default" op om de waarde te gebruiken die is opgegeven in de instellingen voor de server als geheel.',

    // for CLI report & email notifications
    '__resource_notify' => 'Melding versturen',
    '__general' => 'Algemeen',
    '__template_shared' => 'Gedeeld sjabloon',
    'limit__overuse' => 'Beleid bij meerverbruik',
    'limit__max_traffic_soft' => 'Geef melding als verbruikt dataverkeer uitkomt op',
    'limit__disk_space_soft' => 'Geef melding als schijfruimtegebruik uitkomt op',
    '__overuse' => 'Beleid bij meerverbruik',
    'performance__title' => 'Prestaties',
    'performance__bandwidth' => 'Maximaal gebruik van bandbreedte (KB/s)',
    'performance__max_connections' => 'Verbindingen beperkt tot',

    'gch__hosting_php_isapi' => 'PHP uitvoeren als ISAPI-extensie',
    'gch__hosting_ssi_html' => 'SSI gebruiken voor *.htm, *.html-bestanden',
    'gch__hosting_php_handler_type' => 'PHP uitvoeren als',
    'gch__hosting_php_handler_id' => 'PHP uitvoeren als',
    'gch__hosting_php_served_by_nginx' => 'PHP bediend door nginx',
    'gch__hosting_unpaid_website_status' => 'Status van websites in abonnementen die zijn opgeschort',
    'gch__mn_no_autoresponder' => 'Er zijn geen automatische beantwoordingen voor het mailaccount ingesteld.',
    'gch__no_clients_selected' => "Er zijn geen cliëntaccounts geselecteerd",
    'gch__no_domains_selected' => "Geen domeinen geselecteerd",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/maand",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Naam van middel',
    '__resource_usage' => 'Gebruikt',
    '__resource_limit' => 'Beperking',

    '__used' => 'Gebruikt',
    '__limit' => 'Beperking',

    '__never_expires' => 'Verloopt nooit',
    '__resource_free' => '%1 van %2 beschikbaar',
    '__resource_unlimited' => '%1 van Onbeperkt in gebruik',

    '__value' => 'Waarde',
    '__unlimited' => 'Onbeperkt',
    '__increment' => "Vergroten (+)",
    '__decrement' => "Verminderen (-)",
    '__pt' => 'eenheden',
    '__procent' => '%',
    '__overused' => 'Met meerverbruik',
    '__left' => 'links',
    '__available' => 'beschikbaar',
    '__not_available' => 'Niet inbegrepen',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__admin/report/traffic-history__title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__admin/report/traffic-history__description' => 'Historie bekijken van bandbreedteverbruik voor resellers, cliënten en domeinen.',
    'admin_traffic_history__title' => 'Overzicht van verbruikt dataverkeer',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Bezorgrooster',
    'ui__admin/report/layout/auto_unknown__title' => 'Verslagbezorgrooster',
    'ui__admin/report/layout/auto_unknown__description' => 'Verslagbezorgrooster voor een verslagindeling kiezen.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Nieuw verslagbezorgrooster toevoegen',
    'ui__admin/report/layout/auto/properties_new__title' => 'Nieuw verslagbezorgrooster toevoegen',
    'ui__admin/report/layout/auto/properties_new__description' => 'Een verslagbezorgrooster toevoegen voor verslag %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Verslagbezorgrooster',
    'ui__admin/report/layout/auto/properties__title' => 'Verslagbezorgrooster',
    'ui__admin/report/layout/auto/properties__description' => 'Eigenschappen van verslagbezorgrooster bekijken en wijzigen.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Verslagbezorgrooster verwijderen',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Verslagbezorgrooster verwijderen',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Geselecteerde bezorgroosters van verslagen verwijderen.',

    'ui__admin/report/layout_unknown__short-title' => 'Verslagindelingen',
    'ui__admin/report/layout_unknown__title' => 'Verslagindelingen',
    'ui__admin/report/layout_unknown__description' => 'Verslagindelingen bekijken en beheren.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Verslagindeling aanmaken',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Verslagindeling aanmaken',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Een verslagindeling aanmaken.',
    'ui__admin/report/layout/delete_multi__short-title' => 'Verslagindelingen verwijderen',
    'ui__admin/report/layout/delete_multi__title' => 'Verslagindelingen verwijderen',
    'ui__admin/report/layout/delete_multi__description' => 'Geselecteerde verslagindelingen verwijderen',
    'ui__admin/report/layout/properties__short-title' => 'Eigenschappen',
    'ui__admin/report/layout/properties__title' => 'Eigenschappen van verslagindeling',
    'ui__admin/report/layout/properties__description' => 'Eigenschappen van verslagindeling bewerken.',

    // reseller
    'reseller_traffic_history__title' => "Overzicht van dataverkeer verbruikt door reseller %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Door reseller %1 verbruikt dataverkeer bekijken',
    'ui__reseller/traffic__description' => 'Verlagen over door reselleraccount %1 verbruikt dataverkeer bekijken.',
    'ui__reseller/traffic_self__short-title' => 'Mijn',
    'ui__reseller/traffic_self__title' => 'Historie bekijken van bandbreedteverbruik per cliënt',
    'ui__reseller/traffic_self__description' => 'Verslagen bekijken over door uw cliëntaccounts verbruikt dataverkeer.',

    'ui__reseller/report/traffic-history__short-title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__reseller/report/traffic-history__title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__reseller/report/traffic-history__description' => "Eerder dataverkeerverbruik van reseller %1 bekijken",
    'ui__reseller/report/traffic-history_self__short-title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__reseller/report/traffic-history_self__title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__reseller/report/traffic-history_self__description' => 'Uw eerder verbruikt dataverkeer bekijken.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Bezorgrooster',
    'ui__reseller/report/layout/auto_unknown__title' => 'Verslagbezorgrooster',
    'ui__reseller/report/layout/auto_unknown__description' => 'Verslagbezorgrooster voor een verslagindeling kiezen.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Verslagbezorgrooster toevoegen',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Verslagbezorgrooster toevoegen',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Een verslagbezorgrooster toevoegen voor verslag %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Verslagbezorgrooster',
    'ui__reseller/report/layout/auto/properties__title' => 'Verslagbezorgrooster',
    'ui__reseller/report/layout/auto/properties__description' => 'Eigenschappen van verslagbezorgrooster bekijken en wijzigen.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Verslagbezorgrooster verwijderen',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Verslagbezorgrooster verwijderen',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Geselecteerde verslagbezorgroosters verwijderen.',

    'ui__reseller/report/layout_unknown__short-title' => 'Verslagindelingen',
    'ui__reseller/report/layout_unknown__title' => 'Verslagindelingen',
    'ui__reseller/report/layout_unknown__description' => 'Verslagindelingen bekijken en beheren.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Verslagindeling aanmaken',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Verslagindeling aanmaken',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Een verslagindeling aanmaken.',
    'ui__reseller/report/layout/properties_new__short-title' => 'Verslagindeling aanmaken',
    'ui__reseller/report/layout/properties_new__title' => 'Verslagindeling aanmaken',
    'ui__reseller/report/layout/properties_new__description' => 'Een verslagindeling aanmaken.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Verslagindelingen verwijderen',
    'ui__reseller/report/layout/delete_multi__title' => 'Verslagindelingen verwijderen',
    'ui__reseller/report/layout/delete_multi__description' => 'Geselecteerde verslagindelingen verwijderen',
    'ui__reseller/report/layout/properties__short-title' => 'Eigenschappen',
    'ui__reseller/report/layout/properties__title' => 'Eigenschappen van verslagindeling',
    'ui__reseller/report/layout/properties__description' => 'Eigenschappen van verslagindeling bewerken.',

    // customer
    'cl_traffic_history__title' => "Historie verbruikt dataverkeer van cliënt %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Historie bekijken van bandbreedteverbruik voor cliënt %1',
    'ui__client/traffic__description' => 'Verslagen bekijken over door cliëntaccount %1 verbruikt dataverkeer.',
    'ui__client/traffic_self__short-title' => 'Dataverkeerverbruik',
    'ui__client/traffic_self__title' => 'Door domeinen gebruikt dataverkeer',
    'ui__client/traffic_self__description' => 'Verslagen over door uw domeinen verbruikt dataverkeer bekijken.',

    'ui__client/report/traffic-history__short-title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__client/report/traffic-history__title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__client/report/traffic-history__description' => 'Historie van bandbreedteverbruik bekijken voor cliënt %1.',
    'ui__client/report/traffic-history_self__short-title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__client/report/traffic-history_self__title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__client/report/traffic-history_self__description' => 'Uw eerder verbruikt dataverkeer bekijken.',



    // domain
    'dom_traffic_history__title' => "Overzicht van dataverkeer verbruikt door domein %1",

    'ui__client/domain/report/traffic-history__short-title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__client/domain/report/traffic-history__title' =>  'Eerder dataverkeerverbruik bekijken',
    'ui__client/domain/report/traffic-history__description' => 'Eerder dataverkeerverbruik van domein %1 bekijken',
    'ui__client/domain/report/traffic-history_self__short-title' => 'Eerder dataverkeerverbruik bekijken',
    'ui__client/domain/report/traffic-history_self__title' =>  'Eerder dataverkeerverbruik bekijken',
    'ui__client/domain/report/traffic-history_self__description' => 'Eerder dataverkeerverbruik van uw domein bekijken.',



    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => 'Statistieken met betrekking tot beveiligde websitebezoeken',
    'ui__client/domain/report/web-stats-ssl__title' => 'Statistieken van beveiligde bezoeken aan de %1 site',
    'ui__client/domain/report/web-stats-ssl__description' => 'Statistieken van beveiligde bezoeken aan de %1 site.',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => 'SSL/TLS-webstatistieken',
    'ui__client/domain/report/web-stats-ssl_self__title' => 'Statistieken met betrekking tot beveiligde bezoeken aan uw site',
    'ui__client/domain/report/web-stats-ssl_self__description' => 'Statistieken met betrekking tot beveiligde bezoeken aan uw site.',
    'ui__client/domain/report/ftp-stats__short-title' => 'FTP-statistieken',
    'ui__client/domain/report/ftp-stats__title' => 'FTP-statistieken voor domein %1',
    'ui__client/domain/report/ftp-stats__description' => 'FTP-statistieken voor domein %1',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'FTP-statistieken',
    'ui__client/domain/report/ftp-stats_self__title' => 'FTP-statistieken voor uw domein',
    'ui__client/domain/report/ftp-stats_self__description' => 'FTP-statistieken voor uw domein.',
    'ui__client/domain/report/anon-ftp-stats__short-title' => 'Statistieken Anonieme FTP',
    'ui__client/domain/report/anon-ftp-stats__title' => 'Statistieken Anonieme FTP voor domein %1',
    'ui__client/domain/report/anon-ftp-stats__description' => 'Statistieken Anonieme FTP voor domein %1',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => 'Statistieken Anonieme FTP',
    'ui__client/domain/report/anon-ftp-stats_self__title' => 'Statistieken Anonieme FTP voor domein %1',
    'ui__client/domain/report/anon-ftp-stats_self__description' => 'Statistieken Anonieme FTP voor domein %1',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'Webalizer-instellingen',
    'ui__client/domain/report/webalizer-preferences__title' => 'Webalizer-instellingen voor %1',
    'ui__client/domain/report/webalizer-preferences__description' => 'Presentatie aanpassen van de statistische verslagen van Webalizer voor %1.',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'Webalizer-instellingen',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'Webalizer-instellingen voor %1',
    'ui__client/domain/report/webalizer-preferences_self__description' => 'Presentatie aanpassen van de statistische verslagen van Webalizer voor %1.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'U',
    'report__full_reseller_name' => 'Naam van reseller', // reseller report
    'report__full_client_name' => 'Naam van cliënt', // customer report
    'report__full_domain_name' => 'Domeinnaam', // domain report
    'report__full_owner' => 'Houder', // customer & domain reports
    'report__full_creation_date' => 'Datum van aanmaken',
    'report__full_size' => 'Grootte',
    'report__full_traffic' => 'Dataverkeer',
    'report__full_active_clients' => 'Actieve cliënten', // reseller report
    'report__full_clients' => 'Cliënten', // reseller report
    'report__full_active_domains' => 'Actieve domeinen', // reseller & customer reports
    'report__full_domains' => 'Domeinen', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Mboxes',
    'report__full_disk_space' => 'Schijfruimte',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Antw',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Verzendlijst',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => 'Algemeen',
    'report__version' => 'Productversie',
    'report__build' => 'Product-build',
    'report__status' => 'Status',
    'report__company_name' => 'Bedrijfsnaam',
    'report__personal_name' => 'Eigennaam',
    'report__login' => 'Gebruikersnaam',
    'report__phone' => 'Telefoon',
    'report__fax' => 'Fax',
    'report__email' => 'E-mail',
    'report__address' => 'Adres',
    'report__city' => 'Stad',
    'report__state' => 'Provincie of staat',
    'report__zip_code' => 'Postcode',
    'report__country' => 'Land',
    'report__creation_date' => 'Datum van aanmaken',
    'report__expiration_date' => 'Verloopdatum',
    'report__dumps_total_size' => 'Totale omvang van reservekopieën',
    'report__section_resellers' => 'Resellers',
    'report__active_resellers' => 'Resellers met actieve pakketten',
    'report__resellers' => 'Resellers',
    'report__section_full_resellers' => 'Resellers',
    'report__section_clients' => 'Cliënten',
    'report__active_clients' => 'Cliënten met actieve pakketen',
    'report__clients' => 'Cliënten',
    'report__section_full_clients' => 'Cliënten',
    'report__section_personal_clients' => 'Eigen cliënten',
    'report__active_personal_clients' => 'Uw eigen cliënten met actieve pakketten',
    'report__personal_clients' => 'Eigen cliënten',
    'report__section_full_personal_clients' => 'Eigen cliënten',
    'report__section_domains' => 'Domeinen',
    'report__disk_usage' => 'Schijfruimtegebruik',
    'report__traffic' => 'Dataverkeer',
    'report__active_domains' => 'Actieve domeinen',
    'report__domains' => 'Domeinen',
    'report__subdomains' => 'Subdomeinen',
    'report__mboxes' => 'Postvakken',
    'report__mail_groups' => 'Doorstuuradressen',
    'report__mail_autoresp' => 'Automatische beantwoordingen',
    'report__mail_lists' => 'Verzendlijsten',
    'report__web_users' => 'Webgebruikers',
    'report__mysql_databases' => 'MySQL-databases',
    'report__mssql_databases' => 'MSSQL-databases',
    'report__section_full_domains' => 'Domeinen',
    'report__section_personal_domains' => 'Persoonlijke domeinen',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Persoonlijke domeinen',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Met Presence Builder gepubliceerde sites',
    'report__invalid_email' => 'Geef een geldig e-mailadres op.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Webgebruikers',
    'report__section_mailnames' => 'Mailaccounts',
    'report__section_maillists' => 'Verzendlijsten',
    'report__section_databases' => 'Databases',
    'report__section_siteapps' => 'Webtoepassingen',
    'report__section_aspnetapps' => 'ASP.NET-toepassingen', // PFW
    'report__owner_pname' => "Persoonlijke naam van provider",
    'report__owner_login' => "Gebruikersnaam van provider",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Het opgegeven taalpakket is geïnstalleerd maar niet ingeschakeld in het systeem.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Sessies verwijderen',
    'ui__sessions/delete__title' => 'Sessies verwijderen',
    'ui__sessions/delete__description' => 'Geselecteerde sessies verwijderen.',
    'ui__ftp-sessions__short-title' => 'FTP-Sessies',
    'ui__ftp-sessions__title' => 'FTP-Sessies',
    'ui__ftp-sessions__description' => 'FTP-sessies bekijken.',
    'ui__ftp-sessions/delete__short-title' => 'FTP-sessies verwijderen',
    'ui__ftp-sessions/delete__title' => 'FTP-sessies verwijderen',
    'ui__ftp-sessions/delete__description' => 'De geselecteerde FTP-sessies verwijderen.',
    'ui__ts-sessions__short-title' => 'TS-sessies',
    'ui__ts-sessions__title' => 'TS-sessies',
    'ui__ts-sessions__description' => 'Terminal Service-sessies bekijken',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Sessies verwijderen',
    'ui__reseller/sessions/delete__title' => 'Sessies verwijderen',
    'ui__reseller/sessions/delete__description' => 'Geselecteerde sessies verwijderen.',
    'ui__reseller/sessions/delete_self__short-title' => 'Sessies verwijderen',
    'ui__reseller/sessions/delete_self__title' => 'Sessies verwijderen',
    'ui__reseller/sessions/delete_self__description' => 'Geselecteerde sessies verwijderen.',
    'ui__reseller/ftp-sessions__short-title' => 'FTP-Sessies',
    'ui__reseller/ftp-sessions__title' => 'FTP-Sessies',
    'ui__reseller/ftp-sessions__description' => 'FTP-sessies bekijken.',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP-Sessies',
    'ui__reseller/ftp-sessions_self__title' => 'FTP-Sessies',
    'ui__reseller/ftp-sessions_self__description' => 'FTP-sessies bekijken.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'FTP-sessies verwijderen',
    'ui__reseller/ftp-sessions/delete__title' => 'FTP-sessies verwijderen',
    'ui__reseller/ftp-sessions/delete__description' => 'De geselecteerde FTP-sessies verwijderen.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'FTP-sessies verwijderen',
    'ui__reseller/ftp-sessions/delete_self__title' => 'FTP-sessies verwijderen',
    'ui__reseller/ftp-sessions/delete_self__description' => 'De geselecteerde FTP-sessies verwijderen.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Sessies verwijderen',
    'ui__client/sessions/delete__title' => 'Sessies verwijderen',
    'ui__client/sessions/delete__description' => 'Geselecteerde sessies verwijderen.',
    'ui__client/sessions/delete_self__short-title' => 'Sessies verwijderen',
    'ui__client/sessions/delete_self__title' => 'Sessies verwijderen',
    'ui__client/sessions/delete_self__description' => 'Geselecteerde sessies verwijderen.',

    // domain administrator

    'forgery_token_expired' => 'Sessie-token is verlopen.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'De volgende reselleraccounts zullen naar cliëntaccounts worden omgezet',
    'downgradeResellers__downgrade' => 'Reselleraccounts die zullen worden omgezet',
    // controls
    'downgradeResellers__submit_downgrade' => 'Accountomzetting uitvoeren.',
    'downgradeResellers__cancel_downgrade' => 'Accountomzetting annuleren.',
    'downgradeResellers__confirm' => 'Omzetting bevestigen',
    'downgradeResellers__confirm_message' => 'Bevestig het omzetten van het account om verder te gaan',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Cliëntaccounts selecteren',
    'upgradeClients__upgrade_clients' => 'De volgende cliëntaccounts zullen worden omgezet naar reselleraccounts',
    'upgradeClients__upgrade' => 'Cliëntaccounts die zullen worden omgezet',
    // controls
    'upgradeClients__submit_upgrade' => 'Accountomzetting uitvoeren.',
    'upgradeClients__cancel_upgrade' => 'Accountomzetting annuleren.',
    'upgradeClients__confirm' => 'Omzetting bevestigen',
    'upgradeClients__confirm_message' => 'Bevestig het omzetten van het account om verder te gaan',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Kan het account \'%1\' niet omzetten naar een reselleraccount: \'%1\' is al een reseller.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'De volgende domeinbeheerderaccounts zullen naar cliëntaccounts worden omgezet',
    'upgradeDomainUser__upgrade' => 'Domeinbeheerderaccounts die zullen worden omgezet',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Accountomzetting uitvoeren.',
    'upgradeDomainUser__cancel_upgrade' => 'Accountomzetting annuleren.',
    'upgradeDomainUser__confirm' => 'Omzetting bevestigen',
    'upgradeDomainUser__confirm_message' => 'Bevestig het omzetten van het account om verder te gaan',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Domeinbeheerderaccounts die niet kunnen worden omgezet',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'De volgende domeinbeheerderaccounts konden niet naar cliëntaccounts worden omgezet:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Een aantal domeinbeheerderaccounts kon niet worden omgezet naar cliëntaccounts. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Domeinbeheerderaccount bestaat niet',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Het domein moet rechtstreeks aan de serverbeheerder of aan een reseller toebehoren.",
    'upgradeDomainUser__all_logins_already_used' => 'Kan geen account aanmaken voor de resulterende cliënt.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Domeinbeheerderaccount is omgezet',
    'upgradeDomainUser__upgrade_notification_body' => 'Uw domeinbeheerderaccount is omgezet naar een cliëntaccount met gebruikersnaam \'%%login%%\' en wachtwoord \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => 'Nieuwe houder toewijzen aan cliëntaccount %1', // customer home
    'ui__client/chowner_multi__wizard-title' => 'Nieuwe houder toewijzen aan geselecteerde cliëntaccounts', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => 'Geselecteerde gebruikeraccounts aan nieuwe houder toewijzen', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => 'Cliëntaccounts selecteren',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => 'Selecteer de cliëntaccounts die u aan een andere houder wilt overdragen.',
    //  owner selection
    'client_chown__select_title' => 'Kies een nieuwe houder voor cliëntaccount',
    'client_chown__select-multi_title' => 'Kies een nieuwe houder voor cliëntaccounts',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "Kies een nieuwe houder voor geselecteerde cliëntaccounts.", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => 'Kies een nieuwe houder voor geselecteerde cliëntaccounts.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => 'Kies een nieuwe houder voor geselecteerde cliëntaccounts.', // reseller & admin home
    // changes check page
    'client_chown__check_title' => 'Wijzigingen controleren en wizard beëindigen',
    'ui__client/chowner__wizard__2' => 'Controleer de wijzigingen en klik Voltooien om de wizard af te sluiten.', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => 'Controleer de wijzigingen en klik Voltooien om de wizard af te sluiten.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => 'Controleer de wijzigingen en klik Voltooien om de wizard af te sluiten.', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => 'U moet een nieuwe houder kiezen voor geselecteerde cliëntaccounts',
    'clientOwnerChanger__unable_to_transfer_some_clients' => 'Een of meer van de geselecteerde gebruikeraccounts kunnen niet worden overgedragen aan de nieuwe houder.',
    'client_chown__client_warn' => 'Omschrijving',

    'clientOwnerChanger__owner_has_no_permission' => 'De geselecteerde reseller beschikt niet over het recht \'%1\', maar een aantal van de cliënten wel.',
    'clientOwnerChanger__application_not_allowed' => 'De toepassing \'%1\' is niet beschikbaar voor de geselecteerde reseller, maar is beschikbaar voor sommige cliënten.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Opnieuw toewijzen van geselecteerde pakketten',
    // errors
    'domain_chown__empty_selection' => 'U moet een nieuwe houder kiezen voor geselecteerde domeinen',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'Werking',
    'hosting_performance__traffic_bandwidth_legend' => 'Beperking van de bandbreedte inschakelen.',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'Beperking van bandbreedte',
    'hosting_performance__traffic_bandwidth_label' => 'Maximaal gebruik van bandbreedte (%1)',
    'hosting_performance__traffic_bandwidth_hint' => 'De beperking van de verbruikte bandbreedte is alleen van toepassing op gegevens die via het HTTP-protocol worden overgedragen.',
    'hosting_performance__max_connection_legend' => 'Beperking van verbindingen inschakelen',
    'hosting_performance__max_connection_legend_ro' => 'Beperking van verbindingen',
    'hosting_performance__max_connection_label' => 'Verbindingen zijn beperkt tot',
    'hosting_performance__max_connection_hint' => 'Als u het bandbreedteverbruik beperkt, is het aanbevolen om ook het aantal gelijktijdige verbindingen met de site te beperken. Anders zullen, bij grote bezoekersaantallen, de processen van de webserver de serverbelasting vergroten.',

    // errors:
    'performance__qos_not_installed' => 'Mogelijkheid uitgeschakeld omdat QoS niet is geïnstalleerd',
    'performance__bandwidth_throttling' => 'U kunt geen tijdelijke verlaging van bandbreedte instellen omdat QoS niet is geïnstalleerd.',
    'performance__invalid_value' => "Waarde is ongeldig. Deze moet liggen tussen %1 en %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Beschikbare webmailprogramma\'s',
    'webmail__none' => 'Geen',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'IP-voorziening van server',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'De database zal niet worden teruggezet: er is geen geschikte database-server',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Reservekopie van server.",
    '__default_backup_comment_reseller' => "Reservekopie van reselleraccount aangemaakt door %1.",
    '__default_backup_comment_client' => "Reservekopie van cliëntaccount aangemaakt door %1.",
    '__default_backup_comment_domain' => "Reservekopie van abonnement aangemaakt door %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'IP-toewijzingen instellen',
    'backup__ip_mapping__download' => 'Huidige IP-toewijzingen opslaan in bestand',
    'b_backup__ip_mapping__download' => 'Klik om de instellingen van IP-toewijzing (mapping) te downloaden.',
    'b_backup__ip_mapping__download_is_empty' => 'Configuratie van IP-toewijzingen is leeg.',
    'backup__ip_mapping_upload__title' => 'IP-toewijzingsbestand uploaden',
    'backup__ip_mapping__upload' => 'IP-toewijzingsbestand uploaden',
    'b_backup__ip_mapping__upload' => 'Klik voor het uploaden van de instellingen voor IP-toewijzing (mapping).',
    'backup__ip_mapping__list__header' => 'IP-toewijzingen',
    'backup__ip_mapping__list__adddress' => 'Oude IP-adressen',
    'backup__ip_mapping__list__select_ip' => 'Nieuwe IP-adressen',
    'backup__ip_mapping__clients_ip' => "IP-voorziening van klant %1",
    'backup__ip_mapping__resellers_ip' => "IP-voorziening van reseller %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Exclusieve IP-adressen moeten worden gekoppeld aan unieke IP-adressen. Selecteer een uniek IP-adres voor elk exclusief IP-adres in de lijst.',
    'backup__ip_mapping__legend' => 'IP-toewijzingen',
    'backup__ip_mapping__upload_legend' => 'Uploaden',
    'backup__ip_mapping__upload_file_text' => 'Bestand met IP-toewijzingen (mapping)',
    'backup__ip_mapping__upload_file_hint' => 'Het bestand met IP-toewijzingen bevat slechts platte tekst. Elke regel van dit bestand bevat een IP-toewijzing in het volgende formaat: <oud IP-adres> <nieuw IP-adres>',
    'backup__ip_mapping__ip_address_not_found' => 'Er zijn geen vrije IP-adressen van dit type beschikbaar.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Kan de overdracht van gegevens niet uitvoeren: De koppeling van IP-adressen is niet compleet omdat er geen IP-adressen vrij zijn in de opslag van de server van bestemming.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Niet-beveiligde FTP-verbindingen zullen niet worden toegestaan voor domeinen met dit IP-adres.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Beveiligde FTPS-verbindingen zullen niet worden toegestaan voor domeinen met dit IP-adres.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Conflicten',
    'backup__restore__object_vhost' => 'Virtuele host',
    'backup__restore__object_plesk_admin' => 'Plesk-beheerder',
    'backup__restore__object_ftpuser' => 'FTP-account',
    'backup__restore__object_frontpageuser' => 'Frontpage-account',
    'backup__restore__object_webuser' => 'webgebruiker',
    'backup__restore__object_domain' => 'domein',
    'backup__restore__object_subdomain' => 'subdomein',
    'backup__restore__object_domainalias' => 'domeinalias',
    'backup__restore__object_client' => 'cliënt',
    'backup__restore__object_reseller' => 'reseller',
    'backup__restore__object_autoresponder' => 'automatische beantwoording',
    'backup__restore__object_mailalias' => 'mailalias',
    'backup__restore__object_database' => 'database',
    'backup__restore__object_mailname' => 'mailaccount',
    'backup__restore__object_db_user' => 'databasegebruiker',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS-certificaat',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'De volgende resellers kunnen niet worden teruggeplaatst omdat ze zijn omgezet naar cliënten: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'De volgende cliënten kunnen niet worden teruggeplaatst omdat ze zijn omgezet naar resellers: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'De volgende cliënten kunnen niet worden teruggeplaatst omdat ze zijn overgedragen aan een andere houder: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Onvoldoende schijfruimte op de server van bestemming om alle geselecteerde abonnementen te kunnen overdragen. Beschikbaar: %1 MB. Vereist: %2 MB. Merk op dat de vereiste ruimte wordt berekend als de som van de web- mail- en databasebestanden van domeinen. De vereiste ruimte wordt eens per dag berekend en opgeslagen in de cache, waardoor de werkelijke grootte van domeinen anders kan zijn dan de berekende omvang. Als u ervoor zorgt dat de geselecteerde domeinen niet meer ruimte innemen dan beschikbaar is, dan kunt u verder met de overdracht.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Maak schijfruimte vrij op de server van bestemming.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Onvoldoende schijfruimte op de bronserver om de tijdelijke bestanden op te slaan voor de overdracht. Beschikbaar: %1 MB. Vereist: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Maak schijfruimte vrij op de bronserver.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Serverinformatie',

    'backup__restore__capability_not_installed_component_text' => 'De component %1 is niet geïnstalleerd op de server van bestemming. %1 zal voor geen van de herstelde objecten beschikbaar zijn.',
    'backup__restore__capability_not_installed_component_resolution' => 'Installeer %1. Merk op dat dit enkele minuten in beslag kan nemen.',
    'backup__restore__capability_existing_sys_user_text' => 'Er bestaat op de server van bestemming al een gebruiker van het systeem met de naam %1.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Wijzig de naam van de bestaande gebruiker van het systeem op de server van bestemming.',
    'backup__restore__capability_license_usage_text' => 'De volgende beperking van middelen (zoals bepaald door de licentiesleutel) zal na de overdracht van gegevens worden overschreven op de server van bestemming:',
    'backup__restore__capability_license_usage_resolution' => 'Installeer op de server van bestemming een andere licentiesleutel die de vereiste hoeveelheid middelen beschikbaar maakt.',
    'backup__restore__capability_max_allowed_packet_text' => "De parameter 'max_allowed_packet' op de database van de bronserver is %1; dit is groter dan op de server van bestemming, waar deze waarde is ingesteld op %2. Bepaalde databaseobjecten voor de hieronder aangegeven domeinen worden wellicht niet geplaatst.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Verhoog de waarde \\'max_allowed_packet\\' op de database-server van bestemming.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Kan de PostgreSQL-databases niet overdragen omdat de versie van PostgreSQL op de server van bestemming lager is dan de die op de bronserver. De huidige versie is %1, de vereiste versie is %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Installeer de juiste versie van PostgreSQL op de server van bestemming.',
    'backup__restore__capability_db_server_connection_problems' => 'Kan geen verbinding maken met de PostgreSQL-database-server van bestemming. Databases zullen niet worden overgedragen totdat u de koppeling hersteld.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Controleer de instellingen van de koppeling op de database-server van bestemming.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'De component %1 is uitgeschakeld op de server van bestemming.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Schakel %1 in op de server van bestemming.',
    'backup__restore__capability_not_configured_component_text' => 'De component %1 is niet ingesteld op de server van bestemming.',
    'backup__restore__capability_not_configured_component_resolution' => 'Stel %1 in op de pagina Hulpprogramma\'s & instellingen.',

    'backup__restore__capability_webmail_is_not_available' => 'De webmaildienst %1 is niet beschikbaar op de server van bestemming. In plaats daarvan zal Plesk de volgende webmaildienst gebruiken: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Als u dezelfde webmail wilt gebruiken als op de originele server, dan moet u deze op deze server installeren.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Om dezelfde webmail te gebruiken als op de bronserver moet u deze installeren op de server van bestemming.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "De '%1' webmail is niet beschikbaar op de server van bestemming. In plaats daarvan, voor de volgende abonnementen: %3, Plesk de volgende webmaildienst gebruiken: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Installeer de juiste webmail op de server van bestemming.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Webmail-instellingen',

    'backup__restore__capability_shell_is_not_available' => 'De shell %1 is niet beschikbaar op de server van bestemming. In plaats daarvan zal een van de beschikbare shells worden gebruikt.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Om dezelfde shell te gebruiken als op de bronserver moet u deze inschakelen (in /etc/shells) of installeren op de server van bestemming.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'De DNS-server van bestemming ondersteunt geen netwerken in het Sjabloon met overdrachtsbeperkingen. De records met IP-adressen van netwerken in de beperking van de DNS-overdracht zal niet worden geplaatst.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'De DNS-server van bestemming ondersteunt geen netwerken in het Sjabloon met overdrachtsbeperkingen, maar bepaalde abonnementen hebben netwerken ingesteld in de restricties voor DNS-overdracht. De records met IP-adressen van netwerken in de beperking van de DNS-overdracht zal niet worden geplaatst.',

    'backup__restore__capability_wrong_php_handler_text' => 'De PHP-handler %1 is niet beschikbaar op de server van bestemming. In plaats daarvan zal Plesk de volgende PHP-handler gebruiken: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Om dezelfde PHP-handler te gebruiken als op de bronserver moet u deze inschakelen of installeren op de server van bestemming.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP-handler %1 is niet beschikbaar. Plesk zal daarom gebruik maken van %2 voor de volgende hostingpakketten: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP-handler %1 is niet beschikbaar. Plesk zal daarom gebruik maken van %2 voor de volgende websites: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP-handler %1 is niet beschikbaar. Dit zal niet beschikbaar zijn voor de volgende websites: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'De %1 van %2 is niet beschikbaar op de server van bestemming. De standaardversie zal worden gebruikt.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Om dezelfde %1 te gebruiken als op de bronserver moet u deze inschakelen of installeren op de server van bestemming.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'De regels voor het gebruik van antivirus op de server van bestemming staan geen persoonlijke antivirus-instellingen toe (per e-mailadres) voor uitgaande mail. Deze instellingen zullen niet worden overgedragen.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'De regels voor het gebruik van antivirus op de server van bestemming staan geen persoonlijke antivirus-instellingen toe (per e-mailadres) voor inkomende mail. Deze instellingen zullen niet worden overgedragen.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'De regels voor het gebruik van antivirus op de server van bestemming staan geen persoonlijke antivirus-instellingen toe (per e-mailadres). Deze instellingen zullen niet worden overgedragen.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Om persoonlijke antivirusinstellingen (per e-mailadres) over te dragen moet u de bijbehorende optie inschakelen onder Hulpprogramma's & instellingen > Antivirusinstellingen.",
    'backup__restore__capability_antivirus_not_active_text' => 'Er is geen antivirussoftware ingeschakeld. Geen van de antivirus-instellingen van de bronserver zal functioneren totdat u de antivirussoftware selecteert op de server van bestemming.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Selecteer de antivirussoftware onder Hulpprogramma\'s & instellingen > Antivirusinstellingen > sectie Antivirusinstellingen.',

    'backup__restore__capability_antivirus_another_active_text' => 'De antivirussoftware %2 is niet beschikbaar op de server van bestemming. In plaats daarvan zal %1 worden gebruikt.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Om dezelfde antivirus te gebruiken als op de bronserver, moet u deze installeren en vervolgens selecteren onder Hulpprogramma\'s & instellingen > Antivirusinstellingen > sectie Antivirusinstellingen.',
    'backup__restore__capability_not_available_sni_text' => 'SNI is niet beschikbaar op de server van bestemming. De websites die hetzelfde IP-adres hebben kunnen geen individuele SSL/TLS-certificaten gebruiken.',
    'backup__restore__capability_not_available_sni_resolution' => "Controleer of het besturingssysteem op de server van bestemming ondersteuning biedt voor SNI en dat de ondersteuning voor SNI is ingeschakeld in Plesk (het selectievakje 'Ondersteuning voor SNI inschakelen, waarmee het gebruik van individuele SSL/TLS-certificaten op websites met hetzelfde IP-adres wordt toegestaan' onder Hulpprogramma's & instellingen> Server-instellingen).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Server-instellingen',

    'backup__restore__capability_vhost_already_exists_text' => 'De website %1 kan niet worden overgedragen: er bestaat al een website met dezelfde naam op de server van bestemming.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Wijzig de naam van de website die dezelfde naam heeft, of verwijder deze van de server.',
    'backup__restore__capability_removed_vhosts' => 'De volgende abonnementen zullen niet worden teruggeplaatst omdat ze een domeinnaam bevatten die al bestaat op de server van bestemming: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Op de bronserver zijn %3 verschillende PHP-handlers van het type %1 en versie %2. In plaats daarvan zal er één handler op de server van bestemming worden gebruikt, met het juiste type en de juiste versie. Merk op dat de PHP-instellingen op de bronserver en de server van bestemming van elkaar kunnen verschillen.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer ondersteunt geen Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer ondersteunt geen Python. Installeer Python handmatig.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Instellingen Mailserver',

    'backup__restore__capability_ftps_disabled' => 'Het gebruik van beveiligde FTPS-verbindingen is toegestaan op de bronserver maar niet op de server van bestemming. Apps van gebruikers die FTP gebruiken werken wellicht niet correct.',
    'backup__restore__capability_ftps_required' => 'Het gebruik van onbeveiligde FTP-verbindingen is toegestaan op de bronserver maar niet op de server van bestemming. Apps van gebruikers die FTP gebruiken werken wellicht niet correct.',
    'backup__restore__capability_ftps_policy_resolution' => 'De regels voor beveiligde FTP wijzigen onder Hulpprogramma\'s & instellingen > Beveiligingsinstellingen.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabyte aan gegevens zal over %2 uur worden verplaatst van de bronserver naar de server van bestemming.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Controleer voor een snellere gegevensoverdracht de netwerkverbinding tussen de bronserver en de server van bestemming en los eventuele problemen op.',
    'backup__restore__too_low_download_speed' => "minder dan 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Controleer voor een snellere gegevensoverdracht de netwerkverbinding tussen de bronserver en de server van bestemming en los eventuele problemen op.',
    'backup__restore__capability_zero_download_speed_text' => 'De minimale acceptabele downloadsnelheid is %1 MBps. De downloadsnelheid tussen de bronserver en de server van bestemming is 0 MBps. Dit kan worden veroorzaakt door problemen met de netwerkverbinding. De overdracht is niet mogelijk.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Controleer de netwerkverbinding tussen de bronserver en de server van bestemming om problemen op te lossen.',
    'backup__restore__capability_too_slow_download_speed_text' => 'De minimale acceptabele downloadsnelheid is %2 MBps. De downloadsnelheid tussen de bronserver en de server van bestemming is %1 MBps. Hierdoor kan de overdracht meer tijd in beslag nemen. In uw huidige omgeving neemt een migratie van %3 MB ongeveer %4 uur in beslag.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'De minimale acceptabele downloadsnelheid is %2 MBps. De downloadsnelheid tussen de bronserver en de server van bestemming is %1 MBps. Hierdoor kan de overdracht meer tijd in beslag nemen.',

    'backup__restore__capability_remote_database_migration' => "De volgende domeinen maken gebruik van externe databases: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Verwijder deze domeinen na de overdracht niet van de bronserver indien de versie van Plesk op de bronserver lager is dan 11.5! Maar schort ze op. Als u deze domeinen verwijdert zullen de databases van de externe server worden verwijderd. Opmerking: De dump-bestanden van externe databases zullen worden opgeslagen op de bronserver in de map %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Reservekopieën van MySQL-servers ouders dan versie 5.1 (%1) kunnen wellicht niet worden teruggeplaatst op MySQL 5.1.x. De Unicode-tekenset wordt in MySQL 5.1.x op een andere manier verwerkt.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Zie het gerelateerde artikel #136850 van de knowledge base',

    'backup__restore__capability_firewall_not_installed_text' => 'Uw Firewall-uitbreiding is niet geïnstalleerd op de server van bestemming. Als u regels instelt om de toegang te beperken, dan zullen deze niet werken.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'Installeer de firewall-uitbreiding via Plesk Installer.',
    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP is niet geïnstalleerd op de server van bestemming.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Installeer Courier-IMAP via Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot is niet geïnstalleerd op de server van bestemming.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Installeer Dovecot via Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'De periode waarin statistieken behouden moeten blijven die is ingesteld voor de volgende objecten is kleiner dan de waarde ingesteld voor de server van bestemming als geheel.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Wijzig de waarde voor de server van bestemming als geheel voor de periode waarin statistieken bewaard moeten blijven. Stel deze in op gelijke of lagere waarde dan de kleinste waarde die wordt gebruikt in de configuratie van de domeinen.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'De periode waarin statistieken behouden moeten blijven is voor sommige domainen kleiner dan de waarde die is ingesteld voor de server als geheel (%1). De waarde voor deze domeinen zal worden gewijzigd naar %1.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'De periode voor het opslaan van statistieken van het dataverkeer is voor sommige hostingpakketten lager dan de waarde voor de server als geheel (%1). De waarde voor deze dienstenpakketten zal worden gewijzigd naar %1.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Het verwijzen van een exclusief IP-adres naar een gedeeld adres zal anonieme FTP en HTTPS uitschakelen (tenzij de ondersteuning voor SNI is ingeschakeld).',

    'backup__restore__no_postgresql_commands_text' => 'Het abonnement maakt gebruikt van een externe PostgreSQL-database en de tijdelijke reservekopie daarvan kan niet worden aangemaakt omdat de opdrachten pg_dump en psql ontbreken op de bronserver.',
    'backup__restore__no_postgresql_commands_resolution' => 'Installeer elke willekeurige PostgreSQL-client die deze opdrachten ondersteunt.',
    'backup__restore__capability_apache_modules_disabled_text' => 'De volgende Apache-modules zijn uitgeschakeld op de server van bestemming: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Schakel deze modules in om mogelijke problemen te voorkomen.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'De volgende Apache-modules zijn niet geïnstalleerd op de server van bestemming: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Installeer deze modules en schakel ze in om mogelijke problemen te voorkomen.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Beperking van uitgaande berichten wordt niet door uw licentie ondersteund. De bijbehorende instellingen worden niet overgedragen.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Installeer een andere licentiesleutel op de server van bestemming die de juiste mogelijkheden ontsluit.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Beperken van uitgaande berichten is uitgeschakeld op de server van bestemming. De bijbehorende instellingen worden niet overgedragen.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Schakel het beperken van uitgaande berichten in op de server van bestemming.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Mailinstellingen voor de server als geheel',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'De beperking van de uitgaande berichten vanuit een postvak wordt niet ondersteund door de mailserver die wordt gebruikt op de server van bestemming. De waarde van deze beperking zal niet worden overgedragen.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Wijzig de mailserver naar hetzelfde soort mailserver als u gebruikt op de bronserver.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Mailinstellingen voor de server als geheel',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'De beperking van de uitgaande berichten vanaf een domein wordt niet ondersteund door de mailserver die wordt gebruikt op de server van bestemming. De waarde van deze beperking zal niet worden overgedragen.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Wijzig de mailserver naar hetzelfde soort mailserver als u gebruikt op de bronserver.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Mailinstellingen voor de server als geheel',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'De beperking van de uitgaande berichten vanuit een abonnement wordt niet ondersteund door de mailserver die wordt gebruikt op de server van bestemming. De waarde van deze beperking zal niet worden overgedragen.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Wijzig de mailserver naar hetzelfde soort mailserver als u gebruikt op de bronserver.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Mailinstellingen voor de server als geheel',

    'bu_conflict_resolver_absent_phosting' => 'Kan de opgegeven bestanden niet terugplaatsen omdat er geen fysieke hosting bestaat waarin ze kunnen worden geplaatst. Maak eerst een domein aan met fysieke hosting en begin opnieuw met het terugplaatsen van de reservekopie.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'De gegevens van resellers worden niet teruggeplaatst omdat beheer van resellers niet wordt ondersteund.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'De component ModSecurity niet geïnstalleerd op de server van bestemming.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Installeer ModSecurity als u wilt dat de firewall voor webtoepassingen blijft werken voor de gemigreerde sites. Merk op dat deze installatie enige minuten in beslag kan nemen.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Installeer ModSecurity als u de instellingen van de firewall voor webtoepassingen wilt overdragen. Merk op dat deze installatie enige minuten in beslag kan nemen.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'De component ModSecurity niet ingesteld op de server van bestemming.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Stel ModSecurity in als u wilt dat de firewall voor webtoepassingen blijft werken voor de gemigreerde sites.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall voor webtoepassingen (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'De ModSecurity is uitgeschakeld op de server van bestemming.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Activeer ModSecurity als u wilt dat de firewall voor webtoepassingen blijft werken voor de gemigreerde sites.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall voor webtoepassingen (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Het component ModSecurity is niet geïnstalleerd. De instellingen van de firewall voor webtoepassingen zullen niet worden teruggeplaatst voor de volgende objecten: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Websites kunnen niet worden hersteld omdat ze horen bij abonnement %1 dat niet is gevonden in Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'De component %1 is niet geïnstalleerd op de server van bestemming. De DNS-dienst zal niet beschikbaar zijn en de DNS-instellingen zullen verloren gaan. De websites van alle klanten zullen onbereikbaar zijn.',
    'bu_conflict_resolver_dns_not_installed' => 'De DNS-dienst is niet geïnstalleerd. De DNS-instellingen zullen niet worden teruggeplaatst voor de volgende objecten: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'De volgende abonnementen kunnen niet worden teruggeplaatst omdat ze aan andere houders zijn overgedragen: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'De volgende abonnementen kunnen niet worden teruggeplaatst omdat ze aan andere providers zijn overgedragen: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Kan het hulpprogramma voor het herstellen van de data in Web Presence Builder niet vinden. Web Presence Builder is waarschijnlijk niet geïnstalleerd.',
    'backup__restore__capability_renamed_db' => 'De databasenaam "%1" wordt al gebruikt door een ander abonnement. De naam van de teruggeplaatste database zal worden gewijzigd naar "%2".',
    'backup__restore__capability_renamed_db_user' => 'De naam van databasegebruiker "%1" wordt al gebruikt door een ander abonnement. De naam van de gebruiker van de teruggeplaatste database zal worden gewijzigd naar "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer ondersteunt geen Perl. Installeer ActiveState Perl handmatig.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% bediend door Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% bediend door nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Datumconflicten',
    'backup__restore__hint_timing_conflicts' => 'Datumconflicten doen zich voor als het herstelde object al in het systeem aanwezig is, maar met een recentere datum waarop het voor het laatst is bewerkt, of als herstelde objecten momenteel niet in het systeem aanwezig zijn.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Instellingen en gegevens uit reservekopie gebruiken',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Overschrijf de volledige configuratie en alle gegevens die momenteel in het systeem staan met de instellingen en gegevens uit de reservekopie. Als het teruggeplaatste object momenteel aan een andere houder toebehoort, dan zal het object worden hersteld onder de vorige houder.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Gebruik instellingen van het huidige systeem en gegevens uit de reservekopie',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Overschrijf de huidige objectgegevens met die uit de reservekopie, maar behoud de objectinstellingen die momenteel in het systeem aanwezig zijn. Als het teruggeplaatste object momenteel aan een andere houder toebehoort, dan zal het object worden hersteld onder de vorige houder.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Niet herstellen',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Objecten met datumconflicten niet herstellen.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Conflicten in gebruik van middelen',
    'backup__restore__hint_resource_usage_conflicts' => 'Conflicten in het gebruik van middelen doen zich voor als de beperkingen van herstelde objecten worden overschreden bij het terugplaatsen.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Meerverbruik toestaan',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Object terugplaatsen en toestaan dat deze meer middelen gebruikt dan aanvankelijk toegewezen.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Niet herstellen',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Objecten met conflicten in het gebruik van middelen niet herstellen.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Configuratieconflicten',
    'backup__restore__hint_configuration_conflicts' => 'Configuratieconflicten doen zich voor als het object dat wordt teruggeplaatst instellingen of webtoepassingen bevat die niet beschikbaar zijn of die niet zijn toegestaan door de huidige server of door het beleid van de objecthouder. Configuratieconflicten zullen bijvoorbeeld voorkomen als teruggeplaatste mailaccounts beschikken over individuele spamfilterinstellingen, terwijl deze instelling voor mailaccounts niet is toegestaan onder het huidige serverbeleid.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatisch',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Object terugplaatsen en automatisch alle conflicterende instellingsopties inschakelen voor zover u over de noodzakelijke beheerrechten beschikt.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Niet herstellen',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Objecten met configuratieconflicten niet herstellen.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Exclusieve IIS groepen van toepassingen zijn niet toegestaan in de instellingen van de IIS groep van toepassingen.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Wijzig de instellingen van uw IIS groep van toepassingen onder Hulpprogramma\'s & instellingen > IIS groep van toepassingen > Algemene instellingen.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Gedeelde IIS groepen van toepassingen zijn niet toegestaan in de instellingen van de IIS groep van toepassingen.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Wijzig de instellingen van uw IIS groep van toepassingen onder Hulpprogramma\'s & instellingen > IIS groep van toepassingen > Algemene instellingen.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Verkorte namen voor POP3/IMAP-mailaccounts zijn niet toegestaan op de server van bestemming.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Verkorte namen voor mailaccounts zullen na het terugplaatsen van de gegevens niet beschikbaar zijn.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Kan het logbestand niet openen.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Kan het abonnement niet terugplaatsen %1: het is uit uw account verwijderd en u hebt geen rechten om abonnementen aan te maken. Als u deze wilt terugplaatsen, neem dan contact op met uw provider.',

    'backup__error11' => 'Onvoldoende schijfruimte voor reservekopie.',
    'backup__error3011' => 'Verbinding is geweigerd: Er zijn geen programma\'s die luisteren op het opgegeven adres en poortnummer.',
    'backup__error3012' => 'Timeout verbinding.',
    'backup__error3013' => 'Network is onbereikbaar.',
    'backup__error3014' => 'Geen route naar host.',
    'backup__error3015' => 'Verbinding mislukt.',
    'backup__error3016' => 'Kan de hostnaam niet vinden.',
    'backup__error3017' => 'Onjuiste gebruikersnaam of wachtwoord.',
    'backup__error3018' => 'SSH-verbinding is mislukt.',

    'backup__error3110' => 'Kan geen verbinding maken met de externe migratie-agent: Er is geen verbinding met de host beschikbaar.',
    'backup__error3111' => 'De migratie-agent is vastgelopen op een mislukte migratietaak of wordt gebruikt door een ander migratieproces. Herstart de migratie-agent op de bronserver.',
    'backup__error3112' => 'Er is geen verbinding mogelijk met de host of de migratie-agent wordt niet op de bronhost uitgevoerd.',
    'backup__error3113' => 'Kan de migratie-agent niet implementeren op een Linux-host. Controleer de SSH-verbinding met de bronhost.',
    'backup__error3114' => 'Kan de migratie-agent niet implementeren op een Linux-host: SSH-verbinding is mislukt.',
    'backup__error3115' => 'Onjuiste gebruikersnaam of wachtwoord.',
    'backup__error3116' => 'De opgegeven gebruiker beschikt niet over beheerdersrechten.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Alle instellingen en bestanden',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Alle instellingen en bestanden, behalve mail',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Alleen mailinstellingen en -gegevens.',

    'dns_t__unable_to_remove_ns_record' => 'Kan het NS-record niet verwijderen uit het DNS-sjabloon: Elke DNS-zone moet over tenminste één NS-record beschikken.',
    'dns__unsupported_server_zone_transfer' => 'Kan het sjabloon met overdrachtrestricties niet overdragen vanwege de DNS-configuratie voor de server als geheel: Voor de bronserver zijn de volgende netwerkadressen toegestaan voor zoneoverdracht, terwijl ze zijn verboden door Microsoft DNS Server: %1',
    'dns__unsupported_domain_zone_transfer' => 'Kan het sjabloon met overdrachtrestricties niet overdragen vanwege de DNS-configuratie: Voor sommige domeinen zijn de volgende netwerkadressen toegestaan voor zoneoverdracht, terwijl ze zijn verboden door Microsoft DNS Server: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Toewijzing van database-servers instellen',
    'dbbackup__check_network_settings_failed' => 'Geen toegang tot de gedeelde netwerkmap voor reservekopieën. Controleer de instellingen van de netwerkmap, de gebruikersnaam en het wachtwoord. Foutmelding: %1',

    'migration_select_exist_db_server' => 'Selecteer de database-server van bestemming',

    'dbbackup__temp_dir_wrong_value' => 'Er is een ongeldige waarde voor de tijdelijke map opgegeven.',
    'dbbackup__network_temp_dir_wrong_value' => 'Er is een ongeldige waarde voor de tijdelijke netwerkmap opgegeven.',
    'dbbackup__dumpfile_name_is_invalid' => 'Naam van reservekopie is ongeldig: De naam kan alleen alfanumerieke karakters bevatten, het verbindingsstreepje (-), de punt (.) en de underscore (_). Gebruik geen namen zoals omschrijving.* als naam van de reservekopie.',
    'dbbackup__server_backup_not_configured' => 'De server is niet geconfigureerd voor database-reservekopieën.',
    'dbbackup__temp_dir' => 'Tijdelijke map',
    'dbbackup__temp_dir_hint' => 'Het zoekpad naar een fysieke map op de externe server waar de MS SQL-server zich bevindt. De MS SQL-server moet toegang tot deze map hebben om tijdelijke reservekopieën te kunnen lezen en schrijven. Bijvoorbeeld C:\\mapnaam',
    'dbbackup__network_temp_dir_hint' => 'Het zoekpad naar de netwerk share die is gekoppeld aan de fysieke map die hierboven is opgegeven. Plesk zal de gedeelde map gebruiken voor het down- en uploaden van reservekopieën. Bijvoorbeeld \\\\ServerNaam\\ZoekpadNaarDeMap',
    'dbbackup__network_user_hint' => 'De gebruikersnaam van een netwerkgebruiker die op de externe server is aangemaakt. Bijvoorbeeld \\servernaam\\gebruikersnaam. De gebruiker moet toegang hebben tot de gedeelde map die hierboven is opgegeven.',
    'dbbackup__network_password_hint' => 'Het wachtwoord van de netwerkgebruiker',

    'dbbackup__success_import_without_dublicate_users' => 'De volgende gebruikers zijn niet geïmporteerd: %1. Ze zijn al aanwezig op de database-server.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Comprimeer logbestanden",
    'log_rot__log_rot_status' => "Status logopschoning",
    'log_rot__log_rot_period' => "Voorwaarde logopschoning",
    'log_rot__log_rot_size' => "naar grootte",
    'log_rot__log_rot_time' => "naar tijd",
    'log_rot__logrotation_enable' => "Logopschoning inschakelen",
    'log_rot__mail' => "Verwerkte logbestanden versturen naar e-mail",
    'log_rot__max_number_of_logfiles' => "Maximaal aantal logbestanden",
    'log_rot__time_period' => "periode",
    'log_rot__unable_turn_off' => 'Kan logopschoning niet uitschakelen omdat dit voor de hele server wordt vereist',
    'log_rot__unable_set_period' => 'Kan geen periode voor logopschoning instellen die anders is dan \'dagelijks\', omdat dit voor de hele server wordt vereist',
    'log_rot__unable_set_max_log_files' => 'Kan geen maximaal aantal logbestanden instellen groter dan het maximum %1 die geldt voor de server als geheel',

    /// action log
    // common/various
    'actionlog__confirm_clean_log' => "Weet u zeker dat u de geselecteerde ingangen uit het bewerkingslogboek wilt verwijderen?",
    'actionlog__digit_expected' => "Getal verwacht: %1",
    'actionlog__dont_remove_recs' => "geen records verwijderen",
    'actionlog__from_date' => "van:",
    'actionlog__incorrect_rotation' => "Ongeldige waarden opgegeven voor logopschoning: %1",
    'actionlog__js_incorrect_date' => "Ongeldige datum opgegeven.",
    'actionlog__js_incorrect_num_periods' => "Ongeldige periode voor opschoning opgegeven.",
    'actionlog__js_incorrect_num_records' => "Ongeldig aantal records opgegeven.",
    'actionlog__logged_actions' => "In logboek vastgelegde bewerkingen",
    'actionlog__period_day' => "dagen",
    'actionlog__period_month' => "maanden",
    'actionlog__period_week' => "weken",
    'actionlog__settings' => "Instellingen bewerkingslogboek",
    'actionlog__store_logs_in_db' => "Records opslaan in de database",
    'actionlog__store_number' => "ingangen",
    'actionlog__to_date' => "Aan:",
    'actionlog__unknown_rot_period' => "Onbekende opschoningsperiode: %1",
    'actionlog__unknown_rot_type' => "Onbekend type opschoning: %1",
    'actionlog__wrong_date_period' => "Ongeldige datum",
    'actionlog__session_preferences' => 'Sessie-instellingen',
    // items (PFU schema)
    'actionlog__admin_info' => 'Gegevens beheerder',
    'actionlog__admin_preferences' => "Voorkeuren van beheerder",
    'actionlog__service' => 'Dienst',
    'actionlog__ip_addr' => 'IP-adres',
    'actionlog__client' => 'Cliëntaccount',
    'actionlog__client_status' => 'Status van cliëntaccount',
    'actionlog__client_preferences' => "Schermvoorkeuren van cliënt",
    'actionlog__client_ip_pool' => "IP-voorziening van cliënt",
    'actionlog__client_siteapp' => "Webtoepassingsvoorziening van cliënt",
    'actionlog__client_guid' => "GUID van cliënt",
    'actionlog__domain' => 'Standaarddomein (het eerste domein dat aan een abonnement is toegevoegd)',
    'actionlog__domain_owner' => 'Abonnementhouder',
    'actionlog__domain_plan' => 'Hostingpakket of abonnement',
    'actionlog__domain_status' => 'Standaarddomein, status',
    'actionlog__domain_dns' => 'Standaarddomein, DNS-zone',
    'actionlog__subdomain' => 'Subdomein van een standaarddomein',
    'actionlog__domain_alias' => 'Standaarddomein, alias',
    'actionlog__domain_alias_dns' => 'Standaarddomein, DNS-zone alias',
    'actionlog__site' => 'Domein',
    'actionlog__site_status' => 'Domeinstatus',
    'actionlog__site_dns' => 'DNS-zone van domein',
    'actionlog__site_guid' => 'Domain GUID',
    'actionlog__site_subdomain' => 'Subdomein',
    'actionlog__site_alias' => 'Domeinalias',
    'actionlog__site_alias_dns' => 'DNS-zone van domeinalias',
    'actionlog__domain_limits' => 'Pakketbeperkingen',
    'actionlog__domain_limit_size' => 'Schijfruimtebeperking van pakket',
    'actionlog__domain_limit_traffic' => 'Dataverkeerbeperking van pakket',
    'actionlog__domain_limits_powerUser' => 'Pakketbeperkingen',
    'actionlog__domain_limit_size_powerUser' => 'Schijfruimtebeperking van pakket',
    'actionlog__domain_limit_traffic_powerUser' => 'Dataverkeerbeperking van pakket',
    'actionlog__domain_guid' => "Standaarddomein, GUID",
    'actionlog__cp_user' => 'Plesk-gebruiker',
    'actionlog__mailname' => 'Mailaccount',
    'actionlog__maillist' => 'Verzendlijst',
    'actionlog__phosting' => 'Hostinginstellingen',
    'actionlog__forwarding' => 'Standaardhosting of doorschakelen via frame',
    'actionlog__webuser' => 'Account webgebruiker',
    'actionlog__site_application' => 'Webtoepassing',
    'actionlog__license' => 'Licentiesleutel',
    'actionlog__additional_license' => 'Aanvullende licentiesleutel',
    'actionlog__template_domain' => "Pakketsjabloon",
    'actionlog__template_admin' => "Pakketsjabloon van beheerder",
    'actionlog__template_reseller' => 'Resellerpakket',
    'actionlog__admin_alias' => 'Extra beheerderaccount', // PFW
    'actionlog__ftpuser' => 'Extra FTP-account', // PFW
    'actionlog__db_server' => 'Database-server',
    'actionlog__db' => 'Database',
    'actionlog__db_user' => 'Database gebruikeraccount',
    'actionlog__client_sapppkg_pool' => "Webtoepassing van gebruiker", // PFW, not used?
    'actionlog__remote_dns' => 'Serverstatus externe DNS', // PFW
    'actionlog__reseller' => 'Reselleraccount',
    'actionlog__reseller_guid' => 'Reseller-GUID',
    'actionlog__reseller_ip_pool' => "IP-voorziening van reseller",
    'actionlog__reseller_limit_size' => 'Schijfruimtebeperking van reselleraccount',
    'actionlog__reseller_limit_traffic' => 'Dataverkeerbeperking voor reselleraccount',
    'actionlog__reseller_limits' => 'Beperkingen reselleraccount',
    'actionlog__reseller_permissions' => 'Rechten van reseller',
    'actionlog__reseller_preferences' => "Schermvoorkeuren van reseller",
    'actionlog__reseller_siteapp' => "Webtoepassingen in voorziening van reseller",
    'actionlog__reseller_status' => 'Status van reselleraccount',
    'actionlog__health_status' => 'Status van serverbewaking',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'bereikt',
    'actionlog__added' => 'toegevoegd',
    'actionlog__removed' => 'verwijderd',
    'actionlog__change' => 'gewijzigd',
    'actionlog__update' => 'bijgewerkt',
    'actionlog__move' => 'Verplaatst',
    'actionlog__upgrade' => 'bijgewerkt', // PFU?
    'actionlog__update_or_add' => 'bijgewerkt of toegevoegd',
    'actionlog__expired' => 'verlopen',
    'actionlog__create' => 'aangemaakt',
    'actionlog__delete' => 'verwijderd',
    'actionlog__service_stop' => 'gestopt',
    'actionlog__service_restart' => 'opnieuw opgestart',
    'actionlog__service_start' => 'gestart',
    'actionlog__login' => 'aangemeld',
    'actionlog__logout' => 'afgemeld',
    'actionlog__install' => 'geïnstalleerd',
    'actionlog__uninstall' => 'verwijderd',
    'actionlog__reconfigure' => 'opnieuw ingesteld',
    // events (PFW schema)
    'actionlog__event_admin_update' => 'Beheerderinformatie is bijgewerkt',
    'actionlog__event_admin_preferences_update' => "Voorkeuren voor beheerder bijgewerkt",
    'actionlog__event_service_restart' => 'Dienst opnieuw opgestart',
    'actionlog__event_service_start' => 'Dienst gestart',
    'actionlog__event_service_stop' => 'Dienst gestopt',
    'actionlog__event_ip_address_create' => 'IP-adres aangemaakt',
    'actionlog__event_ip_address_delete' => 'IP-adres verwijderd',
    'actionlog__event_ip_address_update' => 'IP-adres bijgewerkt',
    'actionlog__event_client_create' => 'Cliëntaccount is aangemaakt',
    'actionlog__event_client_delete' => 'Cliëntaccount is verwijderd',
    'actionlog__event_client_update' => 'Cliëntaccount is bijgewerkt',
    'actionlog__event_client_status_update' => 'Status van cliëntaccount is bijgewerkt',
    'actionlog__event_client_preferences_update' => "Schermvoorkeuren van cliënt zijn bijgewerkt",
    'actionlog__event_client_siteapp_added' => "Webtoepassing toegevoegd aan toepassingsvoorziening van cliëntaccount",
    'actionlog__event_client_siteapp_removed' => "Webtoepassing is verwijderd uit toepassingsvoorziening van cliëntaccount",
    'actionlog__event_domain_limit_size_reached' => 'Schijfruimtebeperking van pakket is bereikt',
    'actionlog__event_domain_limit_traffic_reached' => 'Dataverkeerbeperking van pakket is bereikt',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Schijfruimtebeperking van pakket is bereikt',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Dataverkeerbeperking van pakket is bereikt',

    'actionlog__domain_limit_database' => 'Database-beperking voor abonnement',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Beperking MySQL-databases van abonnement bereikt',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Zachte beperking MySQL-databases van abonnement bereikt',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Quotum van Microsoft SQL-server databases bereik voor dit abonnement',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Zacht quotum van Microsoft SQL-server databases bereik voor dit abonnement',
    'actionlog__event_plesk_component_upgrade' => 'Plesk-component bijgewerkt',
    'actionlog__event_plesk_component_install' => 'Plesk-component geïnstalleerd',
    'actionlog__event_plesk_component_uninstall' => 'Plesk-component verwijderd',
    'actionlog__event_domain_create' => 'Standaarddomein (het eerste domein dat aan een abonnement is toegevoegd) is aangemaakt',
    'actionlog__event_domain_delete' => 'Standaarddomein (het eerste domein dat aan een abonnement is toegevoegd) is verwijderd',
    'actionlog__event_domain_update' => 'Standaarddomein (het eerste domein dat aan een abonnement is toegevoegd) is bijgewerkt',
    'actionlog__event_domain_owner_change' => 'Abonnementhouder gewijzigd',
    'actionlog__event_domain_plan_change' => 'Hostingpakket of abonnement gewijzigd',
    'actionlog__event_domain_status_update' => 'Hoofddomein, status bijgewerkt',
    'actionlog__event_domain_dns_update' => 'Hoofddomein, DNS-zone bijgewerkt',
    'actionlog__event_subdomain_create' => 'Subdomein van een standaarddomein aangemaakt',
    'actionlog__event_subdomain_delete' => 'Subdomein van een standaarddomein verwijderd',
    'actionlog__event_subdomain_update' => 'Subdomein van een standaarddomein geslaagd',
    'actionlog__event_domain_alias_create' => 'Standaarddomein, alias aangemaakt',
    'actionlog__event_domain_alias_delete' => 'Standaarddomein, alias verwijderd',
    'actionlog__event_domain_alias_update' => 'Standaarddomein, alias geslaagd',
    'actionlog__event_domain_limits_update' => 'Beperkingen van abonnement zijn bijgewerkt',
    'actionlog__event_cp_user_login' => 'Plesk-gebruiker is aangemeld',
    'actionlog__event_cp_user_logout' => 'Plesk-gebruiker is afgemeld',
    'actionlog__event_mailname_create' => 'Mailaccount aangemaakt',
    'actionlog__event_mailname_delete' => 'Mailaccount verwijderd',
    'actionlog__event_mailname_update' => 'Mailaccount is bijgewerkt',
    'actionlog__event_maillist_create' => 'Verzendlijst aangemaakt',
    'actionlog__event_maillist_delete' => 'Verzendlijst verwijderd',
    'actionlog__event_maillist_update' => 'Verzendlijst bijgewerkt',
    'actionlog__event_phys_hosting_create' => 'Fysieke hosting aangemaakt',
    'actionlog__event_phys_hosting_delete' => 'Fysieke hosting verwijderd',
    'actionlog__event_phys_hosting_update' => 'Fysieke hosting bijgewerkt',
    'actionlog__event_forwarding_create' => 'Standaarddoorschakeling of doorschakelen via frame aangemaakt',
    'actionlog__event_forwarding_delete' => 'Standaarddoorschakeling of doorschakelen via frame verwijderd',
    'actionlog__event_forwarding_update' => 'Standaarddoorschakeling of doorschakelen via frame bijgewerkt',
    'actionlog__event_webuser_create' => 'Account webgebruiker is aangemaakt',
    'actionlog__event_webuser_delete' => 'Account webgebruiker is verwijderd',
    'actionlog__event_webuser_update' => 'Account webgebruiker is bijgewerkt',
    'actionlog__event_siteapp_install' => 'Webtoepassing is geïnstalleerd',
    'actionlog__event_siteapp_reconfigure' => 'Webtoepassing opnieuw ingesteld',
    'actionlog__event_siteapp_uninstall' => 'Webtoepassing verwijderd',
    'actionlog__event_license_update' => 'Licentiesleutel is bijgewerkt',
    'actionlog__event_admin_alias_create' => 'Extra beheerderaccount aangemaakt',
    'actionlog__event_admin_alias_delete' => 'Extra beheerderaccount verwijderd',
    'actionlog__event_admin_alias_update' => 'Extra beheerderaccount is bijgewerkt',
    'actionlog__event_ftpuser_create' => 'Extra FTP-account is aangemaakt',
    'actionlog__event_ftpuser_update' => 'Extra FTP-account is bijgewerkt',
    'actionlog__event_ftpuser_delete' => 'Extra FTP-account is verwijderd',
    'actionlog__event_template_domain_create' => "Pakketsjabloon is aangemaakt",
    'actionlog__event_template_domain_update' => "Pakketsjabloon is gewijzigd",
    'actionlog__event_template_domain_delete' => "Pakketsjabloon is verwijderd",
    'actionlog__event_template_admin_create' => "Pakketsjabloon van beheerder is aangemaakt",
    'actionlog__event_template_admin_update' => "Pakketsjabloon van beheerder is gewijzigd",
    'actionlog__event_template_admin_delete' => "Pakketsjabloon van beheerder is verwijderd",
    'actionlog__event_database_server_create' => 'Database-server aangemaakt',
    'actionlog__event_database_server_update' => 'Database-server is bijgewerkt',
    'actionlog__event_database_server_delete' => 'Database-server verwijderd',
    'actionlog__event_remote_dns_status_update' => 'Serverstatus externe DNS bijgewerkt',
    'actionlog__event_session_preferences_update' => 'Sessie-instellingen zijn gewijzigd',
    'actionlog__event_domain_alias_dns_update' => 'Standaarddomein, DNS-zone van domeinalias bijgewerkt',
    'actionlog__event_domain_move' => 'Standaarddomein is verplaatst naar een nieuw abonnement',
    'actionlog__event_site_move' => 'Domein is verplaatst naar een nieuw abonnement',
    'actionlog__event_site_subdomain_move' => 'Subdomein is verplaatst naar een nieuw abonnement',
    'actionlog__event_subdomain_move' => 'Subdomein van een standaarddomein is verplaatst naar een nieuw abonnement',
    'actionlog__event_license_expired' => 'De licentie van Plesk is verlopen',
    'actionlog__event_database_create' => 'Database is aangemaakt',
    'actionlog__event_database_delete' => 'Database verwijderd',
    'actionlog__event_database_user_create' => 'Databasegebruikeraccount aangemaakt',
    'actionlog__event_database_user_update' => 'Instellingen databasegebruikeraccount zijn bijgewerkt',
    'actionlog__event_database_user_delete' => 'Databasegebruikeraccount is verwijderd',
    'actionlog__event_client_guid_update' => "GUID van cliënt is bijgewerkt",
    'actionlog__event_domain_guid_update' => 'Hoofddomein, GUID bijgewerkt',
    'actionlog__event_reseller_create' => 'Reselleraccount is aangemaakt',
    'actionlog__event_reseller_delete' => 'Reselleraccount verwijderd',
    'actionlog__event_reseller_update' => 'Reselleraccount is bijgewerkt',
    'actionlog__event_reseller_guid_update' => 'Reseller-GUID is bijgewerkt',
    'actionlog__event_reseller_ip_pool_update' => "IP-voorziening van reseller is bijgewerkt",
    'actionlog__event_reseller_limit_size_reached' => 'Schijfruimtebeperking van reselleraccount is bereikt',
    'actionlog__event_reseller_limit_traffic_reached' => 'Dataverkeerbeperking voor reselleraccount is bereikt',
    'actionlog__event_reseller_limits_update' => 'Beperkingen van reselleraccount zijn bijgewerkt',
    'actionlog__event_reseller_permissions_update' => 'Rechten van reselleraccount zijn bijgewerkt',
    'actionlog__event_reseller_preferences_update' => "Schermvoorkeuren van reseller zijn bijgewerkt",
    'actionlog__event_reseller_siteapp_added' => "Toepassing toegevoegd aan de groep van toepassingen van het reselleraccount",
    'actionlog__event_reseller_siteapp_removed' => "Toepassing verwijderd uit de toepassingsvoorziening van het reselleraccount",
    'actionlog__event_reseller_status_update' => 'Status van reselleraccount is bijgewerkt',
    'actionlog__event_template_reseller_create' => 'Resellerpakket aangemaakt',
    'actionlog__event_template_reseller_delete' => 'Resellerpakket verwijderd',
    'actionlog__event_template_reseller_update' => 'Resellerpakket bijgewerkt',
    'actionlog__event_health_status_change' => 'Status van serverbewaking is gewijzigd',
    'actionlog__event_siteapp_upgrade' => 'Webapp bijgewerkt',
    'actionlog__event_extension_install' => 'Uitbreiding geïnstalleerd',
    'actionlog__event_extension_uninstall' => 'Uitbreiding is verwijderd',
    'actionlog__event_extension_upgrade' => 'Upgrade van uitbreiding is uitgevoerd',
    'actionlog__event_extension_status_update' => 'Status van uitbreiding is bijgewerkt',
    'actionlog__event_additional_license_expired' => 'Aanvullende licentiesleutel is verlopen',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "De Plesk API RPC is niet geïnstalleerd op de externe host. Neem contact op met uw provider voor ondersteuning.",
    'rsession_no_account_errmsg' => "Geen toegang tot de externe service onder uw account. De meest waarschijnlijke reden is dat de dienst voor uw account nog niet is geactiveerd. Wacht enkele minuten, probeer het dan opnieuw. Als u opnieuw deze foutmelding krijgt, neem dan contact op met uw systeembeheerder.",
    'rsession_no_domain_errmsg' => "Geen toegang tot de externe service voor dit domein. De meest waarschijnlijke reden is dat de dienst voor dit domein nog niet is geactiveerd. Wacht enkele minuten, probeer het dan opnieuw. Als u opnieuw deze foutmelding krijgt, neem dan contact op met uw systeembeheerder.",
    'rsession_unknown_errmsg' => "De externe server heeft poging een sessie te starten geweigerd. Neem contact op met uw systeembeheerder voor ondersteuning. De foutmelding was: %1",
    'rsession_unknown2_errmsg' => "Onbekende fout bij het starten van een externe sessie. Hoogstwaarschijnlijk geeft de externe server niet op de juiste manier antwoord, of zelfs helemaal geen antwoord. Vraag uw systeembeheerder om de details van de foutmelding na te kijken in het foutmelding-log van de webserver.",
    'rsession_no_connect_errmsg' => "Kan geen verbinding maken met de externe service: verbinding met externe sessie is mislukt. Neem contact op met uw systeembeheerder voor ondersteuning.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Uploaden naar map \\incoming toestaan",
    'anonftp__allow_create_dirs' => 'Aanmaken van mappen in de map \\incoming toestaan',
    'anonftp__allow_download_incoming' => 'Downloaden vanuit de map \\incoming toestaan',
    'anonftp__display_login' => 'Toon bericht bij aanmelding',
    'anonftp__login_text' => 'Tekst van bericht',
    'anonftp__limit_incoming_disk_space' => "Beperk schijfruimte van de map \\incoming",
    'anonftp__limit_maximum_bandwidth' => "Beperk bandbreedte voor downloads vanuit dit virtuele FTP-domein",
    'anonftp__limit_maximum_connections' => "Beperk aantal gelijktijdige verbindingen",
    'anonftp__unable_init' => "Kan anoniem FTP-account niet initialiseren: %1",
    'anonftp__unable_set_quota' => "Kan voor de map \\incoming geen schijfruimtebeperking instellen: %1",
    'anonftp__unable_update' => "Kan accounteigenschappen van anonieme FTP niet bijwerken: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS-certificaten', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Het CA-certificaat ondertekent het certificaat niet.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Onverenigbare combinatie private sleutel/certificaat.",
    'class_sslcertificate__invalid_cert_format' => "Ongeldig certificaatformaat.",
    'class_sslcertificate__invalid_private_key_format' => "Ongeldig formaat van private sleutel.",
    'class_sslcertificate__prob_invalid_priv_key' => "Waarschijnlijk is het formaat van de private sleutel ongeldig.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Virtuele map aanmaken',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Virtuele map aanmaken',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Een virtuele map maken.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Virtuele map aanmaken',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Virtuele map aanmaken',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Een virtuele map maken.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Map aanmaken',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Map aanmaken',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Een map maken.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Map aanmaken',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Map aanmaken',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Een map maken.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Mapeigenschappen',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Eigenschappen van virtuele map',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Eigenschappen van virtuele map bekijken en wijzigen.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Mapeigenschappen',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Eigenschappen van virtuele map',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Eigenschappen van virtuele map bekijken en wijzigen.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Toegangsrechten tot map',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Toegangsrechten tot map',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Toegangsrechten voor map instellen.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Toegangsrechten tot map',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Toegangsrechten tot map',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Toegangsrechten voor map instellen.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'ASP.NET-instellingen',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'ASP.NET-instellingen voor %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'ASP.NET instellen voor virtuele map %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'ASP.NET-instellingen',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'ASP.NET-instellingen voor %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Instellingen ASP.NET configureren voor de virtuele map %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'Versie wijzigen',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'Versie wijzigen',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'De versie van ASP.NET die virtuele map %1 gebruikt wijzingen.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'Versie wijzigen',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'Versie wijzigen',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'De versie van ASP.NET die gebruikt wordt door virtuele map %1 wijzingen.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'PHP-instellingen',
    'ui__client/domain/hosting/web-directories/php__title' => 'PHP-instellingen voor %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'PHP-instellingen configureren voor de virtuele map %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'PHP-instellingen',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'PHP-instellingen voor %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'PHP-instellingen configureren voor de virtuele map %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Verwijderen',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Virtuele mappen verwijderen',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Geselecteerde virtuele mappen verwijderen.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Verwijderen',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Virtuele mappen verwijderen',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Geselecteerde virtuele mappen verwijderen.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'De volgende virtuele mappen zullen worden verwijderd:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'U moet de mappen selecteren die u wilt verwijderen.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME-typen',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME-typen',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'De lijst bekijken met geregistreerde MIME-typen.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'MIME-type toevoegen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Een MIME-type toevoegen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Een nieuw MIME-type registreren.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Foutmeldingdocumenten',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Foutmeldingdocumenten',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Foutmeldingdocumenten bekijken en wijzigen.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Afscherming',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Mapeigenschappen',
    'ui__client/domain/hosting/web-directories/protection__description' => 'De toegang tot de map beperken door deze met een wachtwoord af te schermen.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Afscherming',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Mapeigenschappen',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'De toegang tot de map beperken door deze met een wachtwoord af te schermen.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Instellingen',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Bekijk maplocatie en geef een titel het afgeschermde deel een titel.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Gebruiker toevoegen',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Een gebruikeraccount toevoegen om toegang tot de beveiligde map toe te staan.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'De nieuwe instellingen zijn toegepast.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Het gebruikeraccount is toegevoegd.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Verwijderen',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Gebruikers van de beveiligde map verwijderen.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Gebruikersaccounts verwijderen',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Verwijderen van gebruikersaccounts bevestigen.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'De gebruikeraccounts zijn verwijderd.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => 'Het proces van het controleren van de rechten van het domein is begonnen. Bij het voltooien van de controle zal een melding worden verzonden naar het volgende e-mailadres: %1', // PFW
    'additional_keys__install_done' => 'Installatie van licentiesleutel is gestart.',

    // UI
    'ui____done' => 'De bewerking is geslaagd.',
    'ui__actionlog__done' => "Wijzigingen in de instellingen van het bewerkingslogboek zijn opgeslagen.",
    'ui__admin/extras-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__admin/interface__done' => 'Wijzigingen van de schermvoorkeuren van de serverbeheerder zijn opgeslagen.',
    'ui__admin/report/layout/delete_multi__done' => 'Geselecteerde verslagindelingen zijn verwijderd.',
    'ui__admin/report/traffic-history__done' => 'De bewerking is geslaagd.',
    'ui__admin/report__done' => 'De bewerking is geslaagd.',
    'ui__admin-alias/delete_multi__done' => "De geselecteerde extra beheerderaccounts zijn verwijderd.",
    'ui__admin-alias/properties__done' => "Eigenschappen van extra beheerderaccount zijn bijgewerkt.",
    'ui__admin-alias/properties_new__done' => "Extra beheerderaccount is aangemaakt.",
    'ui__admin-alias/properties_unknown__done' => "Eigenschappen van extra beheerderaccount zijn bijgewerkt.",
    'ui__admin-alias__done' => "Informatie over extra beheerderaccount is met succes bijgewerkt.",
    'ui__admin/manage-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__admin/register-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Geselecteerde verslagbezorgroosters zijn verwijderd.',
    'ui__admin/report/layout/auto/properties__done' => 'Verslagbezorgrooster is bijgewerkt.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Verslagbezorgrooster is aangemaakt.',
    'ui__admin/report/layout/properties__done' => 'Verslagindeling %1 is bijgewerkt.',
    'ui__admin/report/layout/properties_new__done' => 'Verslagindeling %1 is aangemaakt.',
    'ui__client/chowner__done' => 'Er is een nieuwe houder toegewezen aan cliëntaccount %1.',
    'ui__client/chowner_multi__done' => "De geselecteerde gebruikeraccounts zijn overgedragen aan een andere houder.",
    'ui__client/chowner_multi-select__done' => 'De bewerking is geslaagd.',
    'ui__client/chowner_select__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/certificate/properties__done' => 'Eigenschappen van SSL/TLS-certificaat zijn bijgewerkt.',
    'ui__client/domain/certificate/properties_new__done' => 'Er is een nieuw SSL/TLS-certificaat toegevoegd. Om deze te laten werken moet u deze selecteren in de hosting-instellingen van de website (op het tabblad Website & domeinen> domeinnaam).',
    'ui__client/domain/certificate__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/certificate_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/check-permissions_multi__done' => 'Controle van de rechten van geselecteerde domeinen is voltooid.', // PFW
    'ui__client/domain/chowner__done' => 'Pakket %1 hoort nu bij een andere gebruiker.',
    'ui__client/domain/chowner_multi__done' => 'Abonnementhouder is gewijzigd.',
    'ui__client/domain/chowner_multi-select__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/chowner_select__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/dbbackup/create__done' => "Het maken van een reservekopie van de database is geslaagd.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Het maken van een reservekopie van de database is geslaagd.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Herstellen van ontkoppelde gebruiker is geslaagd.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Verwijderen van reservekopieën is geslaagd.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Het terugplaatsen van de gegevens in de database is geslaagd.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "De bewerking is geslaagd.", // PFW
    'ui__client/domain/dbbackup__done' => "De bewerking is geslaagd.", // PFW
    'ui__client/domain/dbbackup_self__done' => "De bewerking is geslaagd.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "De bewerking is geslaagd.", // PFW
    'ui__client/domain/delete__done' => "Het domein %1 is verwijderd.",
    'ui__client/domain/delete_multi__done' => "Domeinen zijn verwijderd.",
    'ui__client/domain/disable__done' => 'Domein %1 is opgeschort.',
    'ui__client/domain/disable_multi__done' => 'Geselecteerde domeinen zijn opgeschort.',
    'ui__client/domain/enable__done' => 'De website %1 is geactiveerd.',
    'ui__client/domain/enable_multi__done' => 'Geselecteerde websites zijn geactiveerd.',
    'ui__client/domain/extras__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/domain/extras_self__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'Geselecteerde bestanden en mappen zijn gekopieerd of verplaatst.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'Map is aangemaakt.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'Bestand is aangemaakt.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'Bestand is bijgewerkt.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'Toegangsrechten voor bestand of map zijn bijgewerkt.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'Naam van map of bestand is gewijzigd.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'Geselecteerde bestanden en mappen zijn verwijderd.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'Geselecteerde bestanden en mappen zijn verwijderd.',
    'ui__client/domain/hosting/file-manager/view__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/hosting/file-manager__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/hosting/file-manager_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'Instellingen voor logopschoning zijn gewijzigd.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Instellingen voor logopschoning zijn gewijzigd.',
    'ui__client/domain/hosting/logs__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/hosting/logs_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/hosting/performance__done' => 'Instellingen voor hostingprestaties voor website %1 zijn aangepast.',
    'ui__client/domain/hosting/performance_self__done' => 'Instellingen voor hostingprestaties zijn aangepast voor uw website.',
    'ui__client/domain/hosting/performance_unknown__done' => 'Instellingen webhostingprestaties zijn aangepast.',
    'ui__client/domain/hosting/php__done' => 'PHP-instellingen zijn gewijzigd.', // PFW
    'ui__client/domain/hosting/php_self__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/protected-directories__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/hosting/setup__done' => 'Hosting voor %1 is ingesteld.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'De bewerking is geslaagd.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'De bewerking is geslaagd.', // PFU
    'ui__client/domain/hosting/tsclient__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/tsclient_self__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/virtual-directories__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'ASP.NET-versie is gewijzigd.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'ASP.NET-instellingen voor %1 zijn gewijzigd.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Virtuele map is aangemaakt binnen de website %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Virtuele map is aangemaakt.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Geselecteerde mappen zijn verwijderd.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Geselecteerde mappen zijn verwijderd.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Aangepaste foutmeldingdocumenten zijn bijgewerkt.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Geselecteerde MIME-typen zijn verwijderd', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Nieuw MIME-type is geregistreerd.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Toegangsrechten tot map zijn bijgewerkt.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Toegangsrechten tot map zijn bijgewerkt.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'PHP-instellingen voor %1 zijn bijgewerkt.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'PHP-instellingen voor %1 zijn bijgewerkt.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Eigenschappen van map zijn bijgewerkt', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Eigenschappen van map zijn bijgewerkt', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Instellingen voor afscherming van de map zijn bijgewerkt.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Instellingen voor afscherming van de map zijn bijgewerkt.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "De bewerking is geslaagd.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'SSL/TLS-certificaten beschikbaar in de webwinkel',
    'ui__client/domain/mpc-certificates_self__done' => 'SSL/TLS-certificaten beschikbaar in de webwinkel',
    'ui__client/domain/odbc__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/odbc_self__done' => 'De bewerking is geslaagd.', // PFW
    'ui__client/domain/properties__done' => "Het account van de domeinbeheerder is aangepast.",
    'ui__client/domain/properties_new__done' => "Domein %1 is aangemaakt.",
    'ui__client/domain/properties_self__done' => "De eigenschappen van uw domein zijn gewijzigd.",
    'ui__client/domain/register__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/domain/register_self__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/domain/rename__done' => 'De domeinnaam is gewijzigd.',
    'ui__client/domain/rename_self__done' => "Het wijzigen van de domeinnaam is geslaagd.",
    'ui__client/domain/report/anon-ftp-stats__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/report/ftp-stats__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/report/ftp-stats_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/report/traffic-history__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/report/traffic-history_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/report/webalizer-preferences__done' => 'De bewerking is geslaagd.', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => 'De bewerking is geslaagd.', // PFU
    'ui__client/domain/report/web-stats__done' => 'Pagina met webstatistieken is geopend.',
    'ui__client/domain/report/web-stats_self__done' => 'Pagina met webstatistieken is geopend.',
    'ui__client/domain/report/web-stats-ssl__done' => 'Pagina met webstatistieken is geopend.',
    'ui__client/domain/report/web-stats-ssl_self__done' => 'Pagina met webstatistieken is geopend.',
    'ui__client/domain/report__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/report_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/settings_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/to-client__done' => 'Domeinbeheerderaccount %1 is omgezet naar een cliëntaccount.',
    'ui__client/domain/to-client_multi__done' => 'Domeinbeheerderaccounts zijn omgezet naar cliëntaccounts.',
    'ui__client/domain/toggle_disable__done' => "Het domein %1 is opgeschort.",
    'ui__client/domain/toggle_enable__done' => "Het domein %1 is geactiveerd.",
    'ui__client/domain/traffic__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/traffic_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/traffic_unknown__done' => 'De bewerking is geslaagd.',
    'ui__client/domain/web-stats__done' => 'De bewerking is geslaagd.',
    'ui__client/domain-summary-report__done' => 'De bewerking is geslaagd.',
    'ui__client/domain-summary-report_self__done' => 'De bewerking is geslaagd.',
    'ui__client/domain-summary-report_unknown__done' => 'De bewerking is geslaagd.',
    'ui__client/extras-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/extras-domain_self__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/ipaddress/delete_multi__done' => 'De bewerking is geslaagd.',
    'ui__client/ipaddress/properties__done' => 'De bewerking is geslaagd.',
    'ui__client/ipaddress/properties_new__done' => 'De bewerking is geslaagd.',
    'ui__client/ip-pool/properties__done' => "De IP-voorziening van cliënt %1 is bijgewerkt.",
    'ui__client/ip-pool/properties_self__done' => 'De bewerking is geslaagd.',
    'ui__client/limits__done' => "Beperkingen voor cliënt %1 zijn gewijzigd.",
    'ui__client/limits_self__done' => 'De bewerking is geslaagd.',
    'ui__client/logo__done' => 'De nieuwe branding-instellingen voor de cliënt %1 zijn toegepast.',
    'ui__client/logo_reseller__done' => 'De nieuwe branding van hostingbeheer is toegepast.',
    'ui__client/logo_self__done' => 'Instellingen voor branding zijn toegepast.',
    'ui__client/logo_self-reseller__done' => 'De branding van uw hostingbeheer is gewijzigd.',
    'ui__client/manage-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/manage-domain_self__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/permissions__done' => "Rechten van cliënt %1 zijn gewijzigd.",
    'ui__client/permissions_self__done' => 'De bewerking is geslaagd.',
    'ui__client/preferences__done' => "Voorkeuren voor cliënt %1 zijn gewijzigd.",
    'ui__client/preferences_self__done' => "Uw voorkeuren zijn gewijzigd.",
    'ui__client/register-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/register-domain_self__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__client/report/traffic-history__done' => 'De bewerking is geslaagd.',
    'ui__client/report/traffic-history_self__done' => 'De bewerking is geslaagd.',
    'ui__client/report__done' => 'De bewerking is geslaagd.',
    'ui__client/report_self__done' => 'De bewerking is geslaagd.',
    'ui__client/sessions/delete__done' => 'De bewerking is geslaagd.',
    'ui__client/sessions/delete_self__done' => 'De bewerking is geslaagd.',
    'ui__client/sessions__done' => 'De bewerking is geslaagd.',
    'ui__client/sessions_self__done' => 'De bewerking is geslaagd.',
    'ui__client/skeleton__done' => 'De bewerking is geslaagd.',
    'ui__client/skeleton_self__done' => 'De bewerking is geslaagd.',
    'ui__client/to-reseller__done' => 'Cliëntaccount %1 is omgezet naar een reselleraccount.',
    'ui__client/to-reseller_multi__done' => "De geselecteerde cliëntaccounts zijn omgezet naar reselleraccounts.",
    'ui__client/traffic__done' => "De bewerking is geslaagd.",
    'ui__client/traffic_unknown__done' => 'De bewerking is geslaagd.',
    'ui__cp-access__done' => 'De bewerking is geslaagd.',
    'ui__cp-session/properties__done' => 'De bewerking is geslaagd.',
    'ui__cp-session__done' => 'De bewerking is geslaagd.',
    'ui__ftp-sessions__done' => 'De bewerking is geslaagd.',
    'ui__license__done' => 'De bewerking is geslaagd.',
    'ui__logo__done' => "Eigenschappen van de branding van Plesk zijn gewijzigd.",
    'ui__longtasks/longtask/properties__done' => "Het wijzigen van de instellingen voor achtergrondtaken is geslaagd.",
    'ui__mass-email/delete__done' => "Berichtsjabloon %1 is verwijderd.", // PFW
    'ui__mass-email/delete_multi__done' => "Berichtsjablonen zijn verwijderd.",  // PFW
    'ui__mass-email/send_main__done' => "De bewerking is geslaagd.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Selectie van cliëntaccounts is geslaagd.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Selecteren van domeinbeheerderaccounts geslaagd.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Selecteren van reselleraccounts is geslaagd.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'De wijzigen in het sjabloon voor e-mail aan een grote groep zijn opgeslagen.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Sjabloon voor e-mailbericht aan een grote groep is aangemaakt.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Cliëntaccounts zijn geselecteerd voor het berichtsjabloon voor e-mail aan grote groep.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Domeinbeheerderaccounts zijn geselecteerd voor het sjabloon voor e-mail aan een grote groep.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Reselleraccounts zijn geselecteerd voor het berichtsjabloon voor e-mail aan grote groep.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Sjabloon voor e-mailbericht aan een grote groep is gewijzigd.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Er zijn onjuiste waarden opgegeven.', // PFW
    'ui__mass-email__done' => "Uitvoering is geslaagd.", // PFW
    'ui__mass-mail__done' => "Uitvoering is geslaagd", // PFU
    'ui__mass-mail/delete__done' => 'Berichtsjabloon %1 is verwijderd.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Berichtsjablonen zijn verwijderd.', // PFU
    'ui__mass-mail/properties__done' => 'Het sjabloon %1 is gewijzigd.', // PFU
    'ui__mass-mail/properties_new__done' => 'Het sjabloon %1 is aangemaakt.', // PFU
    'ui__mass-mail/send__done' => 'De berichten zijn verzonden.', // PFU
    'ui__mass-mail/send_new__done' => 'De berichten zijn verzonden.', // PFU
    'ui__mass-mail/send_unknown__done' => 'De berichten zijn verzonden.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'De berichten zijn verzonden.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Er is een nieuw berichtsjabloon aangemaakt', // PFU
    'ui__mass-mail/template/properties__done' => 'Berichtsjabloon is gewijzigd.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'De nieuwe instellingen voor schijfbewaking zijn toegepast.', // PFU
    'ui__modules__done' => 'De bewerking is geslaagd.',
    'ui__modules__short-title' => 'Uitbreidingen',
    'ui__modules__title' => 'Extensies',
    'ui__reseller/client/chowner_multi__done' => 'Geselecteerde cliëntaccounts zijn overgedragen aan een andere houder.',
    'ui__reseller/client/chowner_multi-select__done' => 'De bewerking is geslaagd.',
    'ui__reseller/client/traffic_unknown__done' => 'De bewerking is geslaagd.',
    'ui__reseller/extras-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__reseller/extras-domain_self__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__reseller/ftp-sessions_self__done' => 'De bewerking is geslaagd.',
    'ui__reseller/limits__done' => "De beperkingen van de reseller en het beleid met betrekking tot het gebruik van middelen zijn gewijzigd.",
    'ui__reseller/limits_readonly-self__done' => 'De bewerking is geslaagd.',
    'ui__reseller/limits_self__done' => 'Uw beperkingen en het beleid met betrekking tot het gebruik van middelen zijn gewijzigd.',
    'ui__reseller/manage-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__reseller/manage-domain_self__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__reseller/permissions__done' => 'Rechten van reseller %1 zijn gewijzigd.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'De bewerking is geslaagd.',
    'ui__reseller/register-domain__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__reseller/register-domain_self__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Geselecteerde verslagbezorgroosters zijn verwijderd.',
    'ui__reseller/report/layout/auto/properties__done' => 'Verslagbezorgrooster is bijgewerkt.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Verslagbezorgrooster is toegevoegd.',
    'ui__reseller/report/layout/properties__done' => 'Verslagindeling is gewijzigd.',
    'ui__reseller/report/layout/properties_new__done' => 'Nieuwe verslagindeling is aangemaakt.',
    'ui__reseller/report/traffic-history__done' => 'De bewerking is geslaagd.',
    'ui__reseller/report/traffic-history_self__done' => 'De bewerking is geslaagd.',
    'ui__reseller/report__done' => 'De bewerking is geslaagd.',
    'ui__reseller/report_self__done' => 'De bewerking is geslaagd.',
    'ui__reseller/sessions/delete__done' => 'De bewerking is geslaagd',
    'ui__reseller/sessions/delete_self__done' => 'De bewerking is geslaagd',
    'ui__reseller/sessions__done' => 'De bewerking is geslaagd.',
    'ui__reseller/sessions_self__done' => 'De bewerking is geslaagd.',
    'ui__reseller/to-client__done' => 'Reselleraccount %1 is omgezet in een cliëntaccount.',
    'ui__reseller/to-client_multi__done' => "De geselecteerde reselleraccounts zijn omgezet naar cliëntaccounts.",
    'ui__reseller/traffic__done' => 'De bewerking is geslaagd.',
    'ui__reseller/traffic_self__done' => 'De bewerking is geslaagd.',
    'ui__reseller/traffic_unknown__done' => 'De bewerking is geslaagd.',
    'ui__reseller/logo_self__title' => 'Branding van Plesk',
    'ui__reseller/logo_self__done' => 'De branding van uw Plesk is gewijzigd.',
    'ui__server/aspdotnet__done' => 'ASP.NET-instellingen voor de server als geheel zijn gewijzigd.', // PFW
    'ui__server/certificate/default_multi__done' => 'Het geselecteerde SSL/TLS-certificaat is ingesteld om te worden gebruikt voor het beveiligen van verbindingen met nieuw gehoste websites.',
    'ui__server/certificate/delete_multi__done' => 'Geselecteerde SSL/TLS-certificaten zijn verwijderd.',
    'ui__server/certificate/download__done' => 'SSL/TLS-certificaat is gedownload.',
    'ui__server/certificate/properties__done' => 'Eigenschappen van SSL/TLS-certificaat zijn bijgewerkt.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS-certificaat %1 is aangemaakt.',
    'ui__server/certificate/setup_multi__done' => 'Het geselecteerde SSL/TLS-certificaat is ingesteld om te worden gebruikt voor het beveiligen van verbindingen met Plesk.',
    'ui__server/certificate__done' => 'De bewerking is geslaagd.',
    'ui__server/components__done' => 'De bewerking is geslaagd.',
    'ui__server/cp-certificate-download__done' => "Het SSL/TLS-certificaat van Plesk is gedownload.",
    'ui__server/crontab/properties__done' => 'Ingeroosterde taken van %1 zijn gewijzigd.',
    'ui__server/crontab/task/delete__done' => 'De taak is verwijderd.',
    'ui__server/crontab/task/delete_multi__done' => 'De taken zijn verwijderd.',
    'ui__server/crontab/task/properties__done' => 'De ingeroosterde taken zijn bijgewerkt.',
    'ui__server/crontab/task/properties_new__done' => 'De nieuwe taak is ingeroosterd.',
    'ui__server/crontab/task/toggle_disable__done' => 'De ingeroosterde taak %1 is uitgeschakeld.',
    'ui__server/crontab/task/toggle_enable__done' => 'De ingeroosterde taak %1 is ingeschakeld.',
    'ui__server/crontab__done' => 'De bewerking is geslaagd.',
    'ui__server/db__done' => 'De bewerking is geslaagd.',
    'ui__server/dns__done' => 'De bewerking is geslaagd.',
    'ui__server/ftp-settings__done' => "FTP-instellingen zijn met succes gewijzigd",
    'ui__server/ip-address/client/delete__done' => "Het IP-adres is verwijderd uit de IP-voorziening van de gebruiker.",
    'ui__server/ip-address/client/delete_multi__done' => "Het IP-adres is verwijderd uit de IP-voorzieningen van de gebruikers.",
    'ui__server/ip-address/client/properties_new__done' => 'Het IP-adres is aan gebruikers toegewezen.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP-adres %1 is toegewezen aan de geselecteerde cliënten.',
    'ui__server/ip-addresses__done' => "De bewerking is geslaagd.",
    'ui__server/mail/statistics/spam/recipients__done' => "De bewerking is geslaagd.",
    'ui__server/mail/statistics/spam/summary__done' => "De bewerking is geslaagd.",
    'ui__server/mail/statistics/spam__done' => "De bewerking is geslaagd.",
    'ui__server/mail/statistics/virus/recipients__done' => "De bewerking is geslaagd.",
    'ui__server/mail/statistics/virus/summary__done' => "De bewerking is geslaagd.",
    'ui__server/mail/statistics/virus/viruses__done' => "De bewerking is geslaagd.",
    'ui__server/mail/statistics/virus__done' => "De bewerking is geslaagd.",
    'ui__server/mail/statistics__done' => "De bewerking is geslaagd.",
    'ui__server/mail__done' => 'Instellingen van de mailserver zijn gewijzigd.',
    'ui__server/maillists__done' => 'De bewerking is geslaagd.',
    'ui__server/mpc-certificates__done' => 'De pagina van de webwinkel is geopend waarop alle beschikbare SSL/TLS-certificaten worden vermeld.',
    'ui__server/odbc__done' => 'ODBC-instellingen voor de server als geheel zijn gewijzigd.', // PFW
    'ui__server/pmm__done' => 'De bewerking is geslaagd.',
    'ui__server/preferences__done' => "De serverinstellingen zijn gewijzigd.",
    'ui__server/register__done' => 'De pagina MyPlesk.com is geopend.',
    'ui__server/resources__done' => 'De bewerking is geslaagd.',
    'ui__server/services__done' => 'De bewerking is geslaagd.',
    'ui__server/sitebuilder__done' => 'De bewerking is geslaagd.',
    'ui__server/skeleton__done' => 'De bewerking is geslaagd.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Het adres %1 is verwijderd van de zwarte lijst voor de server als geheel.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'De adressen zijn verwijderd van de zwarte lijst voor de server als geheel.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'De adressen zijn toegevoegd aan de zwarte lijst.',
    'ui__server/spam-filter/black-list/address__done' => 'De adressen zijn toegevoegd aan de zwarte lijst.',
    'ui__server/spam-filter/black-list__done' => 'De bewerking is geslaagd.', // PFU
    'ui__server/spam-filter/properties__done' => 'Spamfilterinstellingen zijn gewijzigd.',
    'ui__server/spam-filter/toggle_disable__done' => 'Het detecteren van spam is uitgeschakeld voor het systeem als geheel.',
    'ui__server/spam-filter/toggle_enable__done' => 'Het detecteren van spam is ingeschakeld voor het systeem als geheel.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Het adres %1 is verwijderd van de witte lijst voor de server als geheel.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'De adressen zijn verwijderd van de witte lijst voor de server als geheel.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'De adressen zijn toegevoegd aan de zwarte lijst.',
    'ui__server/spam-filter/white-list/address__done' => 'De adressen zijn toegevoegd aan de witte lijst.',
    'ui__server/spam-filter/white-list__done' => 'De bewerking is geslaagd.', // PFU
    'ui__server/spam-filter__done' => 'De bewerking is geslaagd.',
    'ui__server/statistics__done' => 'De bewerking is geslaagd.',
    'ui__server/time__done' => "De systeemdatum en -tijd zijn gewijzigd.",
    'ui__server/tsclient__done' => 'Sessie van Extern bureaublad is gestart.', // PFW
    'ui__server__done' => "De bewerking is geslaagd.",
    'ui__sessions/properties__done' => 'De bewerking is geslaagd.',
    'ui__sessions__done' => 'De bewerking is geslaagd.',
    'ui__sessions/delete__done' => 'Geselecteerde sessies zijn verwijderd.',
    'ui__start-page__done' => 'De bewerking is geslaagd.',
    'ui__support__done' => 'Het formulier voor verzoek om assistentie is geopend in een apart browservenster of tabblad.',
    'ui__ts-sessions__done' => 'De bewerking is geslaagd.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Geen bestanden om te uploaden.',
    'login_up__access_denied_no_permission' => "Toegang geweigerd: u hebt onvoldoende rechten om u aan te melden.",
    'mail__unable_remove_pattern' => "Kan het adres niet verwijderen van de zwarte lijst van de server: %1", // PFW
    'mail__incorrect_network_format' => 'Onjuist netwerkformaat: %1', // PFW
    'dbbackup__new_remote_backup_available' => 'Deze MS SQL database-server wordt nu uitgevoerd vanaf een externe host. Om hiertoe databases te kunnen importeren en exporteren met behulp van systeemeigen databasedumps moet u de juiste instellingen voor reservekopieën voor deze databaseserver opgeven.', // PFW
    'dbbackup__local_to_remote_backup_available' => 'Deze MS SQL database-server wordt nu uitgevoerd vanaf een externe host. U kunt instellingen voor de reservekopie van deze database-server opgeven op de pagina %1.', // PFW
    'initconf__unable_change_passwd' => "Kan het wachtwoord van de beheerder niet wijzigen:%1",
    'initconf__unable_get_passwd' => 'Kan het wachtwoord van de huidige beheerder niet ophalen:%1 mislukt:%2',
    'initconf__invalid_hostname' => 'Fout in hostnaam "%1"',
    'initconf__unable_reconfig' => 'Instellen van Plesk niet mogelijk:reconfig mislukt:%1',
    'initconf__unable_update_admin' => 'Kan de contactgegevens van de beheerder niet bijwerken:%1',
    '__refresh' => 'Vernieuwen',
    '__dalias_not_exist' => 'Domeinalias bestaat niet.',
    '__bug146523_explanation' => 'Eerdere versies van Plesk stonden FTP-gebruikersnamen met maximaal 16 karakters toe. Deze versie van Plesk beperkt het maximaal aantal tekens dat in FTP-gebruikersnamen kan worden gebruikt tot 15. Om het probleem op te lossen kunt u de FTP-gebruikersnaam verkorten tot maximaal 15 karakters, waarbij u ten minste een karakter wijzigt om problemen met botsende gebruikersnamen te voorkomen. Wij bieden onze excuses aan voor het ongemak dat door deze wijziging wordt veroorzaakt.',
    'domain__cannot_change_webmail' => 'Kan webmail niet wijzigen voor het domein: %1',
    'sb_publish_disable_warning' => 'Als u de mogelijkheid om websites aan te maken via Presence Builder uitschakelt, dan zal de eerder in Presence Builder aangemaakte website worden verwijderd en gaan alle bijbehorende bestanden verloren. Klik OK als u toch wilt doorgaan.',
    '__sbnet_client_use_sbnet' => "Maak een overeenkomstig gebruikeraccount aan in Presence Builder",
    'mail_resp_activate' => 'Automatische beantwoording inschakelen',
    'limitsManger__limit_available_error' => 'Kan de vereisten hoeveelheid middelen niet toewijzen ("%%limitName%%"): slechts %%available%% is voor uw account beschikbaar.',
    'limitsManger__limit_reserved_error' => 'Kan niet minder middelen toewijzen ("%%limitName%%") dan nu reeds in gebruik zijn.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Kan de naam van het domein niet wijzingen: Er bestaat al een virtuele map met de opgegeven naam.',
    'domain_unable_to_rename' => 'Kan de naam van het domein niet wijzingen.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Algemeen',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin spamfilter',
    'spamfilter__spamassassin_settings_legend' => 'Instellingen SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "SpamAssassin-spamfilter inschakelen voor de server als geheel",
    'spamfilter__spamassassin_user_status_legend' => 'Het SpamAssassin-spamfilter inschakelen',
    'spamfilter__greylisting_status_legend' => 'Bescherming tegen spam door middel van greylisting inschakelen voor de server als geheel',
    'spamfilter__personal_settings_not_allowed' => 'Het gebruik van individuele spamfilter-instellingen wordt niet doorgestaan door de instellingen van het systeem.',
    'spamfilter__required_score' => 'De score die een bericht moet krijgen om als spam gekwalificeerd te worden',
    'spamfilter__rewrite_header_subject' => 'De volgende tekst toevoegen aan het begin van het onderwerp van elk bericht dat als spam wordt herkend',
    'spamfilter__use_mailuser_prefs' => 'Individuele instellingen voor spamfilter toepassen',
    'spamfilter_addresses__text_hint' => 'Scheid verschillende adressen met een nieuwe regel, een spatie, een tab, een komma of een puntkomma. Er mogen geen niet-ASCII-karakters links van het apenstaartje staan. Adressen mogen de jokers "*" en "?" bevatten (bijvoorbeeld *@domein.nl, gebruiker?@*.com). Niet-ASCII-delen van domeinnamen mogen geen jokers bevatten.',
    'spamfilter__spamassassin__antivirus_settings_legend' => 'Instellingen gebruiken die gelden voor de server als geheel',
    'spamfilter__antivirus_use_mailuser_prefs' => 'Persoonlijke instellingen toestaan',
    'spamfilter__score_error' => 'De score mag niet negatief zijn, het gedeelte voor de decimale punt moet kleiner zijn dan 100 en en mag niet meer dan twee cijfers na de decimale punt bevatten.',
    'spamfilter__rewrite_header_error' => 'Het onderwerp van het bericht kan alle afdrukbare karakters bevatten, met uitzondering van het hekje (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Terugsturen',
    'nonexistent_mail__mode_discard' => 'Wissen',
    'nonexistent_mail__mode_catch_addr' => 'Doorsturen naar e-mailadres',
    'nonexistent_mail__mode_catch_ip' => 'Doorsturen naar IP',
    'nonexistent_mail__bounce_not_supported' => 'Afwijsmodus wordt niet ondersteund',
    'nonexistent_mail__discard_not_supported' => 'Modus verwijderen wordt niet ondersteund',
    'nonexistent_mail__catch_not_supported' => 'Doorsturen naar e-mailadres wordt niet ondersteund',
    'nonexistent_mail__redirect_not_supported' => 'Doorsturen naar IP wordt niet ondersteund',
    'nonexistent_mail__ip_used_on_this_host' => 'IP-adres wordt herleid naar localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Omdat de controle van uitgaande mail is ingeschakeld moet e-mailadres %1 voor niet-bestaande ontvangers bij het geselecteerd domein horen. Is dit niet het geval, dan zal mail worden geweigerd in plaats van doorgestuurd.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Omdat de Controle van uitgaande mail is ingeschakeld moet het e-mailadres dat is opgegeven voor het doorsturen van e-mail (%1) vallen onder het geselecteerde domein. Is dit niet het geval, dan zullen de berichten die naar dit adres worden gestuurd niet worden meegenomen voor de Controle van uitgaande e-mail.',
    // mail acc extras
    '__antivirus' => "Antivirus",

    // additional keys
    'additional_keys__select_to_install' => 'Er zijn geen sleutels geselecteerd. Selecteer de sleutels die u wilt installeren.',
    'additional_key_update__title' => "Bezig met bijwerken van extra sleutel",
    'additional_key_update__legend' => "Status van het bijwerken van de extra sleutel",
    'additional_key_update__new_key' => "Eigenschappen extra sleutel",
    'bt_additional_key_install' => "Sleutel installeren",
    'b_additional_key_install' => 'Klik om de huidige licentiesleutel te installeren.',
    'bt_additional_key_update' => "Extra sleutel ophalen",
    'bt_additional_key_revert' => "Sleutel terugplaatsen",
    'b_additional_key_upload' => 'Een nieuwe licentiesleutel uploaden.',
    'b_additional_key_download' => 'De huidige licentiesleutel downloaden.',
    'b_additional_key_remove' => 'Verwijder de huidige licentiesleutel.',
    'b_additionalkeyslist_install' => 'Geselecteerde licentiesleutels installeren.',

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Er zijn geen extra beheerderaccounts beschikbaar.', // PFW
    'ui__client/domain/certificate__none-available' => 'De klant beschikt niet over SSL/TLS-certificaten.',
    'ui__client/domain/certificate__none-available__1' => 'De klant beschikt niet over domeinen met SSL/TLS-certificaten.',
    'ui__client/domain/certificate__none-available__2' => 'Domein beschikt niet over SSL/TLS-certificaten.',
    'ui__reseller/client__none-available' => 'Er zijn geen resellers met cliënten.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'U moet de IP-adressen selecteren die u uit de IP-voorziening wilt verwijderen.',
    'ui__reseller/client/chowner__empty_selection' => 'U moet de cliëntaccounts selecteren die u aan een nieuwe houder wilt toewijzen.',
    'ui__server/ip-address/client/delete__empty_selection' => 'U moet de reselleraccounts selecteren waarvan u een IP-adres uit de IP-voorziening wilt verwijderen.',
    'ui__server/crontab/task/delete__empty_selection' => 'U moet de taak selecteren die u wilt annuleren.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'PHP-ondersteuning is uitgeschakeld voor deze website.',
    'phosting__aspdotnet_not_enabled' => 'Ondersteuning van ASP.NET is uitgeschakeld voor deze website.',
    'phosting__php_forced_by_site_isolation' => 'Kan PHP-instellingen niet wijzigen: het recht om de beveiligingsinstellingen voor de server als geheel te omzeilen is niet toegekend.',
    'phosting__option_forced_by_site_isolation' => 'Kan %1 instellingen niet wijzigen: het recht om de beveiligingsinstellingen voor de server als geheel te omzeilen is niet toegekend.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'mod_bw is uitgeschakeld omdat Plesk wordt uitgevoerd in de VPS-geoptimaliseerde modus.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'mod_php is uitgeschakeld omdat Plesk wordt uitgevoerd in de VPS-geoptimaliseerde modus.',
    'phosting__perl_disabled_by_vps_optimized' => 'Perl is uitgeschakeld omdat Plesk wordt uitgevoerd in een modus geoptimaliseerd voor VPS.',
    'phosting__asp_disabled_by_vps_optimized' => 'ASP is uitgeschakeld omdat Plesk wordt uitgevoerd in een modus geoptimaliseerd voor VPS.',
    'phosting__python_disabled_by_vps_optimized' => 'Python is uitgeschakeld omdat Plesk wordt uitgevoerd in een modus geoptimaliseerd voor VPS.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'fastcgi is uitgeschakeld omdat Plesk wordt uitgevoerd in een modus geoptimaliseerd voor VPS.',
    'phosting__php_handler_id_not_registered' => 'De PHP-handler is niet toegestaan in de instellingen voor site-isolatie. De standaard PHP-handler zal worden gebruikt.',
    'phosting__php_served_by_nginx_is_not_available' => 'De PHP-handler (FPM-toepassing bediend door nginx) is niet toegestaan in de instellingen voor site-isolatie. De standaard PHP-handler zal worden gebruikt.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'De lijst met IP-adressen bekijken',
    'ui__client/ipaddress/properties_readonly__title' => 'De lijst met IP-adressen bekijken',
    'ui__client/ipaddress/properties_readonly__description' => 'De lijst bekijken met IP-adressen die voor deze gebruiker beschikbaar zijn.',
    'ui__server/certificate__short-title' => 'SSL/TLS-certificaten',
    'ui__server/certificate__title' => 'SSL/TLS-certificaten',
    'ui__server/certificate__description' => 'SSL/TLS-certificaten bekijken en beheren.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'MIME-typen verwijderen',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'MIME-typen verwijderen',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Geselecteerde MIME-typen verwijderen.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'MIME-type toevoegen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'MIME-type toevoegen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Een MIME-type registreren.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'IP-adressen verwijderen',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Selecteer de IP-adressen die u wilt verwijderen uit de IP-voorziening van cliënt %1',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'Bestand aanmaken',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'Bestand aanmaken',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'Een bestand aanmaken.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'Map aanmaken',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'Map aanmaken',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'Een map aanmaken.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'Bestand of map bewerken',
    'ui__client/domain/hosting/file-manager/edit__title' => 'Bestand of map bewerken',
    'ui__client/domain/hosting/file-manager/edit__description' => 'Het geselecteerde bestand of de geselecteerde map bewerken.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'Naam van bestand of map wijzigen',
    'ui__client/domain/hosting/file-manager/rename__title' => 'Naam van bestand of map wijzigen',
    'ui__client/domain/hosting/file-manager/rename__description' => 'Naam van het geselecteerde bestand of de geselecteerde map wijzigen.',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'Rechten wijzingen',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'Rechten wijzingen',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'Toegangsrechten voor een bestand of map wijzingen.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'Bestand of map verwijderen',
    'ui__client/domain/hosting/file-manager/remove__title' => 'Bestand of map verwijderen',
    'ui__client/domain/hosting/file-manager/remove__description' => 'Dit bestand of deze map verwijderen.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'Bestand of map verwijderen',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'Bestand of map verwijderen',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'Dit bestand of deze map verwijderen.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'Bestand of map kopiëren of verplaatsen',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'Bestand of map kopiëren of verplaatsen',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'Geselecteerde bestanden of mappen kopiëren of verplaatsen.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'Bestand bekijken',
    'ui__client/domain/hosting/file-manager/view__title' => 'Bestand bekijken',
    'ui__client/domain/hosting/file-manager/view__description' => 'Geselecteerd bestand bekijken.',

    'ui__client/ipaddress__short-title' => 'IP-adres',
    'ui__client/ipaddress__title' => 'IP-adres',
    'ui__client/ipaddress__description' => 'Informatie over IP-adres bekijken.',
    'ui__server/ip-address__short-title' => 'IP-adres',
    'ui__server/ip-address__title' => 'IP-adres',
    'ui__server/ip-address__description' => 'Informatie over IP-adres bekijken.',
    'ui__client/domain/hosting/setup__short-title' => 'Instellingen webhosting',
    'ui__client/domain/hosting/setup__title' => 'Webhostinginstellingen',
    'ui__client/domain/hosting/setup__description' => 'Webhostinginstellingen instellen voor website %1.',
    'ui__reseller/client/chowner_multi__description' => 'Kies een nieuwe houder voor geselecteerde cliëntaccounts.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME-type', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Eigenschappen MIME-type', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Eigenschappen van het MIME-type bekijken.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Foutmeldingdocument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Foutmeldingdocument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Eigenschappen foutmeldingdocument.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Geselecteerde verslagindelingen verwijderen.',
    'b_resellerreportslist_search' => 'Geef een zoekopdracht op en klik om verslagindelingen te vinden.',
    'b_resellerreportslist_show_all' => 'Alle beschikbare verslagindelingen tonen.',

    'l_resellerreportslist_auto' => 'Verslagindelingen sorteren op automatisering van bezorging.',
    'l_resellerreportslist_clients' => 'Verslagindelingen sorteren op aanwezigheid van informatie over cliënten.',
    'l_resellerreportslist_domains' => 'Verslagindelingen sorteren op aanwezigheid van informatie over domeinen.',
    'l_resellerreportslist_general' => 'Verslagindelingen sorteren op aanwezigheid van algemene informatie',
    'l_resellerreportslist_name' => 'Verslagindelingen sorteren op verslagnaam.',
    'l_resellerreportslist_personal_domains' => 'Verslagindelingen sorteren op aanwezigheid van informatie over uw eigen domeinen.',

    'b_adminreportslist_remove' => 'Geselecteerde verslagindelingen verwijderen.',
    'b_adminreportslist_search' => 'Geef een zoekopdracht op en klik om verslagindelingen te vinden.',
    'b_adminreportslist_show_all' => 'Alle beschikbare verslagindelingen tonen.',

    'l_adminreportslist_auto' => 'Verslagindelingen sorteren op automatisering van bezorging.',
    'l_adminreportslist_clients' => 'Verslagindelingen sorteren op aanwezigheid van informatie over cliënten.',
    'l_adminreportslist_domains' => 'Verslagindelingen sorteren op aanwezigheid van informatie over domeinen.',
    'l_adminreportslist_general' => 'Verslagindelingen sorteren op aanwezigheid van algemene informatie',
    'l_adminreportslist_name' => 'Verslagindelingen sorteren op verslagnaam.',
    'l_adminreportslist_personal_clients' => 'Verslagindelingen sorteren op aanwezigheid van informatie over uw eigen cliënten.',
    'l_adminreportslist_personal_domains' => 'Verslagindelingen sorteren op aanwezigheid van informatie over uw eigen domeinen.',
    'l_adminreportslist_resellers' => 'Verslagindelingen sorteren op aanwezigheid van informatie over reseller.',

    'b_clientsonlylist_remove' => 'Geselecteerde cliëntaccounts verwijderen.',
    'b_clientsonlylist_search' => 'Geef een zoekopdracht op en klik om cliëntaccounts te vinden.',
    'b_clientsonlylist_show_all' => 'Alle cliëntaccounts tonen.',
    'l_clientsonlylist_cname' => 'Cliëntaccounts sorteren op bedrijfsnaam.',
    'l_clientsonlylist_date' => 'Cliëntaccounts sorteren op datum van aanmaken.',
    'l_clientsonlylist_domains' => 'Cliëntaccounts sorteren op aantal domeinen.',
    'l_clientsonlylist_name' => 'Cliëntaccounts sorteren op naam.',
    'l_clientsonlylist_owner' => 'Cliëntaccounts sorteren op houder.',
    'l_clientsonlylist_type' => 'Cliëntaccounts sorteren op type.',

    'b_get_password_cancel' => 'Terug naar de vorige pagina zonder de e-mail te versturen.',
    'b_get_password_send' => 'Klik OK om een wachtwoordherinnering te versturen aan het e-mailadres dat in het systeem is geregistreerd.',



    'b_personaltrafficlist_search' => 'Geef een zoekopdracht op en klik om domeinen te vinden.',
    'b_personaltrafficlist_show_all' => 'Alle domeinen tonen.',

    'b_back' => 'Terug naar de vorige pagina.',
    'b_next' => 'Ga naar de volgende pagina.',

    'b_dnsnstemplatelist_remove' => 'De geselecteerde naamservers verwijderen.',
    'b_dnsnstemplatelist_search' => 'Geef een zoekopdracht op en klik om naamservers te vinden.',
    'b_dnsnstemplatelist_show_all' => 'Alle naamservers tonen.',

    'l_dnsnstemplatelist_ns' => 'DNS-sjabloonrecords sorteren op naamserver.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Beveiligde links naar bestanden en mappen genereren',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Openbare bestanden inschakelen',
    'cu__serverfilesharing_fsPublicFolder' => 'Map voor het opslaan van openbare bestanden',
    'cu__serverfilesharing_fsPublicUrl' => 'URL voor toegang tot de openbare bestanden',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Openbare bestanden afschermen met een wachtwoord.',
    'cu__serverfilesharing_fsPartnerFolder' => 'Map voor het opslaan van met een wachtwoord afgeschermde bestanden',
    'cu__serverfilesharing_fsPartnersLogin' => 'Gebruikersnaam voor bestandstoegang',
    'cu__serverfilesharing_fsPartnersPassword' => 'Wachtwoord voor toegang tot bestand(en)',
    'cu__serverfilesharing_fsDomain' => 'Basis-URL voor webmap Domeinnaam',
    'cu__serverfilesharing_fsPrefix' => 'Basis-URL voor webmap Voorvoegsel',
    'cu__serverfilesharing_commandUpdate' => 'Instellingen bestandsdeling bijwerken',
    'cu__serverfilesharing_commandInfo' => 'De huidige instellingen van bestandsdeling weergeven',
    'server_preferences_include_admin_dumps_into_client_usage' => 'door de beheerder aangemaakte reservekopieën',
    'server_preferences__forbid_subscription_rename' => 'Verbied cliënten en resellers de naam van hun hoofddomein te wijzigen',
    'subscription_rename_is_forbidden' => 'Het wijzigen van de naam van abonnementen is niet toegestaan door het beleid voor de server als geheel.',
    'server_preferences__allow_sys_user_rename' => 'Cliënten kunnen de naam van hun systeemgebruikers wijzigen',
    'server_preferences__allow_sys_user_rename_false' => 'Altijd',
    'server_preferences__allow_sys_user_rename_true' => 'Alleen als het recht Hostingbeheer is toegekend',
    'server_preferences__allow_sys_user_rename_forced' => 'Nooit',
    'server_preferences__preferred_domain' => 'Voorkeursdomein voor websites',
    'server_preferences__preferred_domain_none' => 'Geen',
    'server_preferences__preferred_domain_to_landing' => 'domain.tld',
    'server_preferences__preferred_domain_to_www' => 'www.domain.tld',
    'server_preferences__anonymize_ips' => 'IP-adressen anonimiseren',
    'server_preferences__anonymize_ips_text' => 'Anonimiseer IP-adressen tijdens logopschoning en tijdens het verzamelen van webstatistieken',
    'server_preferences__anonymize_ips_description' => 'Het post-opschoningscript vervangt voor het archiveren het laatste octet van IPv4-adressen in de logbestanden met "0". In IPv6-adressen vervangt het script de laatste sectie van het adres (twee octetten na de laatste dubbele punt) met "0000" (in de volledige vorm) of "0" (in de verkorte vorm)',
    'server_preferences__logrotate' => 'Logopschoning',
    'server_preferences__logrotate_force' => 'Forceer dagelijkse logopschoning voor alle domeinen',
    'server_preferences__logrotate_period' => 'Het opslaan van logbestanden van websites toestaan voor',
    'server_preferences__logrotate_period_days' => 'dagen',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Ingeroosterde Taken op de Server beheren',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Selecteer de systeemgebruiker waarvan u de ingeroosterde taken wilt beheren.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Ingeroosterde taak %1',
    'ui__server/crontab/task__description' => 'Eigenschappen van ingeroosterde taak %1 bekijken.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Systeemgebruikers',
    'ui__server/crontab_unknown__title' => 'Systeemgebruikers',
    'ui__server/crontab_unknown__description' => 'Systeemgebruikers die houder van ingeroosterde taken kunnen zijn.',


    'ui__server/crontab__none-available' => 'U hebt geen systeemgebruikeraccounts.',
    'ui__server/crontab_readonly-unknown__description' => 'Ingeroosterde taken bekijken.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Ingeroosterde taken',
    'ui__server/crontab_readonly-unknown__title' => 'Ingeroosterde taken bekijken',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Ingeroosterde taken bekijken.',
    'ui__server/crontab_readonly__description' => 'Ingeroosterde taken van %1 bekijken',
    'ui__server/crontab_readonly__short-title' => 'Ingeroosterde taak voor %1',
    'ui__server/crontab_readonly__title' => 'Ingeroosterde taken van %1 bekijken',
    'ui__server/crontab_unknown__wizard-title' => 'Ingeroosterde taken beheren.',

    'ui__server/crontab/properties__description' => 'Ingeroosterde taken van %1 bewerken.',

    'ui__server/crontab/properties__short-title' => 'Instellingen',
    'ui__server/crontab/properties__title' => 'Ingeroosterde taken van %1 bewerken',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Ingeroosterde taken bekijken.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Instellingen',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Ingeroosterde taken bekijken',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Ingeroosterde taken bekijken.',
    'ui__server/crontab/properties_readonly__description' => 'Ingeroosterde taken van %1 bekijken',
    'ui__server/crontab/properties_readonly__short-title' => 'Instellingen',
    'ui__server/crontab/properties_readonly__title' => 'Ingeroosterde taken van %1 bekijken',
    'ui__server/crontab/properties_unknown__description' => 'Ingeroosterde taken bewerken.',
    'ui__server/crontab/properties_unknown__short-title' => 'Eigenschappen',
    'ui__server/crontab/properties_unknown__title' => 'Ingeroosterde taken bewerken',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Ingeroosterde taken bewerken.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Selecteer de systeemgebruiker van wie u de taken wilt zien.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Selecteer de systeemgebruiker van wie u de taken wilt wijzigen.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Klik Voltooien om de wijzigingen toe te passen en de wizard af te sluiten.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Klik Voltooien om de wizard af te sluiten.',

    'ui__server/crontab/task__none-available' => 'U hebt geen ingeroosterde taken.',
    'ui__server/crontab/task__none-available__2' => 'Systeemgebruiker %1 heeft geen ingeroosterde taken.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Ingeroosterde taken.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Taken',
    'ui__server/crontab/task_readonly-unknown__title' => 'Ingeroosterde taken',

    'ui__server/crontab/task/delete__description' => 'De ingeroosterde taak %1 verwijderen',

    'ui__server/crontab/task/delete__short-title' => 'Verwijderen',
    'ui__server/crontab/task/delete__title' => 'De ingeroosterde taak %1 verwijderen',
    'ui__server/crontab/task/delete_multi__description' => 'Ingeroosterde taken verwijderen.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Verwijderen',
    'ui__server/crontab/task/delete_multi__title' => 'Ingeroosterde taken verwijderen',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Ingeroosterde taken verwijderen.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Selecteer de systeemgebruiker van wie u de taken wilt verwijderen.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Selecteer de taken die u wilt verwijderen.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Bevestig de verwijdering van de taak door het selectievakje te selecteren en klik Voltooien om de wizard af te sluiten.',
    'ui__server/crontab/task/delete_unknown__description' => 'Een ingeroosterde taak verwijderen.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Verwijderen',
    'ui__server/crontab/task/delete_unknown__title' => 'Een ingeroosterde taak verwijderen',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Een ingeroosterde taak verwijderen.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Selecteer de systeemgebruiker van wie u de taak wilt verwijderen.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Selecteer de taak die u wilt verwijderen.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Bevestig de verwijdering van de taak door het selectievakje te selecteren en klik Voltooien om de wizard af te sluiten.',

    'ui__server/crontab/task/properties__description' => 'Ingeroosterde taken bewerken.',

    'ui__server/crontab/task/properties__short-title' => 'De taak %1 bewerken',
    'ui__server/crontab/task/properties__title' => 'Ingeroosterde taken bewerken',
    'ui__server/crontab/task/properties_new__description' => 'Ingeroosterde taken voor %1 aanmaken.',

    'ui__server/crontab/task/properties_new__short-title' => 'Taak toevoegen',
    'ui__server/crontab/task/properties_new__title' => 'Ingeroosterde taken voor %1 aanmaken',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Een ingeroosterde taak aanmaken.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Selecteer de systeemgebruiker voor wie u de ingeroosterde taak wilt aanmaken.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Klik Voltooien om de wijzigingen toe te passen en de wizard af te sluiten.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'De ingeroosterde taken bekijken.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Eigenschappen',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'De ingeroosterde taken bekijken',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'De ingeroosterde taken bekijken.',
    'ui__server/crontab/task/properties_readonly__description' => 'Ingeroosterde taken bekijken.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Taak %1 bekijken',
    'ui__server/crontab/task/properties_readonly__title' => 'Ingeroosterde taken bekijken',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Ingeroosterde taken aanmaken.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Taak toevoegen',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Ingeroosterde taken aanmaken',
    'ui__server/crontab/task/properties_unknown__description' => 'Ingeroosterde taken bewerken.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Eigenschappen',
    'ui__server/crontab/task/properties_unknown__title' => 'Ingeroosterde taken bewerken',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Ingeroosterde taken bewerken.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Selecteer de systeemgebruiker van wie u de taken wilt zien.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Selecteer de systeemgebruiker van wie u de taken wilt wijzigen.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Selecteer de ingeroosterde taak.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Selecteer de ingeroosterde taak die u wilt wijzigen.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Klik Voltooien om de wijzigingen toe te passen en de wizard af te sluiten.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Klik Voltooien om de wizard af te sluiten.',

    'ui__server/crontab/task/toggle_disable__description' => 'De ingeroosterde taak %1 uitschakelen.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Uitschakelen',
    'ui__server/crontab/task/toggle_disable__title' => 'De ingeroosterde taak %1 uitschakelen',
    'ui__server/crontab/task/toggle_enable__description' => 'De ingeroosterde taak %1 inschakelen.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Activeren',
    'ui__server/crontab/task/toggle_enable__title' => 'De ingeroosterde taak %1 inschakelen',
    'ui__server/crontab/task/toggle_unknown__description' => 'Ingeroosterde taken in- of uitschakelen.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'In- of uitschakelen',
    'ui__server/crontab/task/toggle_unknown__title' => 'Ingeroosterde taken in- of uitschakelen',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Ingeroosterde taken in- of uitschakelen',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Selecteer de systeemgebruikeraccount waarvan u de taken wilt in- of uitschakelen.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Selecteer de taak die u wilt in- of uitschakelen.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Cliëntaccounts', // not used on HP?
    'ui__client_unknown__title' => 'Cliëntaccounts', // not used on HP?
    'ui__client_unknown__description' => 'Cliëntaccounts beheren.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Domein opschorten', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Domein opschorten', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Een domein opschorten.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Domein activeren', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Domein activeren', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Een domein activeren.', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => 'Nieuwe houder toewijzen aan cliëntaccounts',
    'ui__client/chowner_multi-select__short-title' => 'Nieuwe houder toewijzen',
    'ui__client/chowner_multi-select__description' => 'Een nieuwe houder aan geselecteerde cliëntaccounts toewijzen.',


    //Additional FTP Accounts
    'directory_browser__select_folder' => 'Map selecteren',
    'ftp__management_domain' => "FTP-accounts binnen het domein %1", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP-accounts",
    'ftp__user_name' => "Naam FTP-account",
    'ftp__user_home' => "Hoofdmap",
    'ftp__invalid_path' => "Ongeldig zoekpad opgegeven",
    'ftp__physical_path_not_exist' => "Fysiek zoekpad bestaat niet",
    'i_ftp_ses_sub_user' => 'Sessie van FTP-account.',
    '__new_passwd' => "Nieuw %1 wachtwoord",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Kan de webserver niet instellen op de host <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Kan het configuratiebestand voor de webserver niet genereren op host <%%host%%> vanwege de volgende fouten:\n\n%%error%%\n\nLos eerst de fouten in de sjablonen van de webserverconfiguratie op en genereer het bestand vervolgens opnieuw.",

    'apacheConfigurationMessageAdminTitle' => 'Genereren van webserverconfiguratie is mislukt',
    'apacheConfigurationMessageClientTitle' => 'Waarschuwing',

    'apacheConfigurationFailedAdminHomeMessage' => 'Er is geen nieuw configuratiebestand aangemaakt vanwege fouten in configuratiesjablonen. De gedetailleerde foutmelding is naar uw e-mailadres gestuurd; controleer deze e-mail, los de problemen op en klik op %1 om opnieuw te proberen een configuratiebestand aan te maken.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'hier', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Er is geen nieuw configuratiebestand aangemaakt voor domein %1 vanwege fouten in configuratiesjablonen. De gedetailleerde foutmelding is naar uw e-mailadres gestuurd; controleer deze e-mail, los de problemen op en klik op %2 om opnieuw te proberen een configuratiebestand aan te maken.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'hier', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Webserverinstellingen voor domein %1 zijn wellicht inconsistent. Neem contact op met de serverbeheerder om het probleem op te lossen.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Er is geen nieuw configuratiebestand aangemaakt voor een aantal van de domeinen vanwege fouten in configuratiesjablonen. De gedetailleerde foutmelding is naar uw e-mailadres gestuurd; controleer deze e-mail, los de problemen op en klik op %1 om opnieuw te proberen een configuratiebestand aan te maken.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'hier', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Webserverinstellingen voor een aantal van uw domeinen zijn wellicht inconsistent. Neem contact op met de serverbeheerder om het probleem op te lossen.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Aangepaste foutmeldingdocumenten",
    'dom_pref__webusers_script' => "Webgebruikers mogen scripts uitvoeren",
    '__seoRedirect' => 'Het voorkeursdomein instellen als',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Geen',

    '__sites' => 'Domeinen',
    'domain_plan__perm_denied_manage_phosting' => 'U beschikt niet over de rechten voor het beheren van hostinginstellingen.',
    '__owned_by_client' => 'hoort bij cliënt',
    'ui__client/permissions_readonly__description' => "Bekijk de bewerkingen die de cliënt %1 in Plesk kan uitvoeren.",
    'client_chown_subscription_will_be_anonymous' => 'Cliënten zullen worden afgemeld van hun huidige dienstenpakket.',
    'backup__restore__object_client_template' => 'Cliëntsjabloon',
    '__template_name' => 'Naam pakketsjabloon',
    'template__not_exists' => 'Dienstensjabloon bestaat niet.',
    'template__exists' => 'Een pakket met de naam %1 bestaat al.',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => 'De cliënt beschikt over domeinen die gebruik maken van de pakketten van %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'Het opgegeven IP-adres bevindt zich niet in de voorziening van de reseller.',

    //// Change owner of subscription
    'chown__select_title' => "Kies nieuwe abonnementhouder",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Kies een nieuwe houder voor de geselecteerde pakketten en klik Volgende >>.',
    'domains__client_info' => "%1 domeinen, %2 actieve pakketen, %3 schijfruimte gebruikt, %4 dataverkeer verbruikt",
    '__possible_owners' => 'Mogelijke nieuwe abonnementhouders',

    'clients_list__filter_owner__filter_title' => 'Provider',
    'clients_list__filter_owner_any' => 'Alle gebruikers',
    'clients_list__filter_owner_my' => 'Alleen mijn abonnementhouders',
    'clients_list__filter_owner_name__filter_title' => 'Naam van provider',

    '__owner' => "Provider",
    'l_clientslist_owner' => 'Gebruikeraccounts sorteren op provider.',
    'l_clientslist_date' => 'Gebruikeraccounts sorteren op datum van aanmaken.',
    'l_clientslist_name' => 'Gebruikeraccounts sorteren op naam.',
    'l_clientslist_domains' => 'Gebruikeraccounts sorteren op domeinen.',
    'l_clientslist_cname' => 'Gebruikeraccounts sorteren op bedrijfsnaam.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Opnieuw toewijzen van geselecteerde pakketten',
    'chown__check_title' => 'Abonnementhouder wijzigen',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Klik Voltooien om de nieuwe toewijzingen af te ronden. Hierna zullen de geselecteerde pakketten aan een nieuwe houder worden toegewezen, hun provider zal worden gewijzigd in de provider van de nieuwe houder en ze zullen worden losgekoppeld van hun dienstenpakket en ingesteld als 'Aangepast'.",

    'chown__error_check' => 'Er zijn een aantal problemen geconstateerd tijdens de poging om een aantal van de pakketten over te dragen aan een nieuwe houder.',
    'domain_chown_subscription_will_be_anonymous' => "Pakketten zullen worden losgekoppeld van hun huidige pakketsjabloon en worden 'aangepast'.",
    'chown__error_domains_exclude' => "Er zijn een aantal problemen geconstateerd tijdens de poging om een aantal van de pakketten over te dragen aan een nieuwe houder. Deze pakketten zijn aangegeven.",
    'chown__ip_not_in_client_pool' => "Het IP-adres dat aan dit pakket is gekoppeld is niet toegevoegd aan de IP-voorziening van de nieuwe houder.",
    'chown__already_owned_by_client' => "Dit pakket hoort al bij deze gebruiker.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Afgeschermde map /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Beheer afgeschermde map /%1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'Een beschermde map aanmaken voor site %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'Afgeschermde map toevoegen',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'Een beschermde map aanmaken.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'Het aanmaken van afgeschermde map /%1 is geslaagd.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'Instellingen van de afgeschermde map /%1',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'Mapinstellingen',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'Locatie, naam en omgevingstitel voor de afgeschermde map wijzigen.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'Instellingen afgeschermde map zijn gewijzigd.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'Verwijderingsbevestiging',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'Niet langer afschermen',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'De geselecteerde mappen niet langer afschermen.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'Selecteer de map waarvan u de beveiliging wilt verwijderen.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'Deze bewerking zal ertoe leiden dat de mappen niet langer worden afgeschermd. De mappen zijn vervolgens vrij toegankelijk voor iedereen op internet.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'Het verwijderen van de afscherming van de geselecteerde mappen is geslaagd.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Een gebruiker toevoegen',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Een gebruiker toevoegen',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Een gebruikeraccount instellen voor toegang tot de afgeschermde map %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'Het gebruikeraccount voor toegang tot de afgeschermde map is aangemaakt.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "De aanmeldgegevens van de gebruiker zijn opgeslagen.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Verwijdering gebruikers van afgeschermde map',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Selecteer de gebruikers die u wilt verwijderen.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Verwijderen',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Mapgebruikers verwijderen.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'De volgende gebruikers van afgeschermde map zullen worden verwijderd:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'Geselecteerde gebruikeraccounts zijn verwijderd.',

    '__redirect_hint' => 'U wordt binnen 15 seconden doorgestuurd naar het nieuwe adres als u niet automatisch naar de nieuwe locatie wordt gebracht, zorg dan dat u javascript inschakelt in uw webbrowser of klik op de volgende link %%link%%.',

    'backup__restore__object_maillist' => 'Verzendlijst',
    'backup__restore__object_site' => 'Site',
    'backup__restore__object_user' => 'Gebruiker',
    'backup__restore__object_role' => 'Rol',

    'limit__name_max_site' => 'sites',

    'iis_pool__unable_rename_client' => "Kan naam van de IIS groep van toepassingen niet wijzingen: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'De dienst anonieme FTP wordt alleen ondersteund voor het hoofddomein van een abonnement.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'De dienst anonieme FTP wordt alleen ondersteund voor het hoofddomein van een abonnement.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/maand',
    '__tb_month' => 'TB/maand',

    '__customers' => 'Cliënten',
    '__customer_name' => 'Naam van cliënt',
    '__customer_total' => 'Cliënttotaal',
    '__site' => 'Site',
    '__def_site' => 'Standaardsite',
    '__subscription_name' => 'Naam van abonnement',
    '__subscription_name_powerUser' => 'Abonnementnaam',

    'limit__units_max_traffic_suffix' => '/maand',

    'dom_pref__discard' => "Afwijzen",

    'mail__pattern_already_exists' => 'Patroon "%1" staat al op de zwarte lijst.',

    '__not_supported' => 'Niet ondersteund',

    'plesk_key__sitebuilder' => 'Met Presence Builder gepubliceerde sites',
    'limit__name_max_site_builder' => 'Met Presence Builder gepubliceerde sites',
    'plesk_key__wpb-multi-language-sites-support' => 'Ondersteuning voor meertalige sites in Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Statistieken gegevensoverdracht voor domein %1',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Statistieken gegevensoverdracht voor domein %1',
    'ui__client/domain/traffic-hosting#list__title' => "Dataoverdracht door diensten",

    'login_up__access_denied_no_subscriptions' => "Toegang geweigerd. Er zijn geen abonnementen beschikbaar voor dit account.",

    'interval__day' => '%1 dag(en)',
    'interval__hour' => '%1 uur / uren',
    'interval__minute' => '%1 minuut / minuten',
    'interval__second' => '%1 seconde(n)',

    ///License options
    'plesk_key__backward_incompatibility' => 'U probeert een licentiesleutel te gebruiken die bedoeld is voor een andere versie van Plesk. Neem contact op met een vertegenwoordiger van Plesk voor het aanvragen van de juiste licentiesleutel.',
    //Standalone or virtualization
    'virtualization_any' => "Fysieke server of gevirtualiseerde oplossing",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo-server",
    'plesk_key__virtualization' => "Geldig voor de volgende omgevingen:",
    'plesk_key__virtualization_only_key' => 'De licentiesleutel is alleen bedoeld voor gebruik van Plesk binnen een %1 virtuele omgeving.',
    'plesk_key__virtualizations_only_key' => 'De licentiesleutel is alleen bedoeld voor gebruik van Plesk binnen de volgende virtuele omgevingen: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Het gebruik van eigen taalpakketten is niet toegestaan.',
    'plesk_key__allowed-locales' => 'Beschikbare talen',
    'plesk_key__allowed-locales-any' => 'Alle talen',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'de map cgi-bin bevindt zich in',
    '_cgi_bin_mode_webspace' => 'de hoofdmap van het abonnement',
    '_cgi_bin_mode_www_root' => 'de hoofdmap van dit domein',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'Een ODBC DSN toevoegen',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'ODBC-gegevensbron toevoegen.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'Verwijderen',
    'ui__server/odbc/dsn/delete_multi__title' => 'Bevestigen van verwijdering',
    'ui__server/odbc/dsn/delete_multi__description' => 'Verwijder geselecteerde ODBC DSN-gegevensbronnen.',
    'ui__server/odbc/dsn/delete#legend__description' => 'De volgende ODBC DSN-koppelingen zullen worden verwijderd:',
    'ui__server/odbc/dsn/delete__empty_selection' => 'Geen ODBC DSN-koppelingen geselecteerd.',
    'ui__server/odbc/dsn/delete_multi__done' => 'De geselecteerde gegevensbronnen zijn verwijderd.',
    'ui__server/odbc/dsn__title' => 'ODBC DSN-koppeling %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'Een ODBC DSN toevoegen',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'ODBC-gegevensbron toevoegen.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'Verwijderen',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'Bevestigen van verwijdering',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'Verwijder geselecteerde ODBC DSN-gegevensbronnen.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'De volgende ODBC DSN-koppelingen zullen worden verwijderd:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'Geen ODBC DSN-koppelingen geselecteerd.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'De geselecteerde gegevensbronnen zijn verwijderd.',
    'ui__client/domain/odbc/dsn__title' => 'ODBC DSN-koppeling %1',


    /// Custom buttons
    'custom_button__sort_key' => 'Prioriteit',
    'custom_button__place' => 'Locatie',
    'custom_button__place_navigation' => 'Gedeelde toegang',
    'custom_button__place_admin' => 'Startpagina van beheerder',
    'custom_button__place_admin-settings' => 'Pagina met hulpprogramma\'s & instellingen van beheerder',
    'custom_button__place_reseller' => "Startpagina van Reseller",
    'custom_button__place_reseller-settings' => 'Pagina met hulpprogramma\'s & instellingen van reseller',
    'custom_button__place_client' => 'Startpagina van cliënt',
    'custom_button__place_domain' => "Pagina met websites & domeinen van abonnement",
    'custom_button__place_domain_powerUser' => "Pagina met websites & domeinen van abonnement",
    'custom_button__place_domain-properties' => 'Hulpprogramma\'s voor websites',
    'custom_button__private' => 'Alleen aan mij tonen',
    'custom_button__image' => 'Achtergrondafbeelding',
    'custom_button__conhelp' => "Tekst van knopinfo",
    'custom_button__edit' => "Instellingen van een link naar een aanvullende dienst",
    'custom_button__include_client_cname' => "Bedrijfsnaam van cliënt toevoegen",
    'custom_button__include_client_email' => "E-mail van cliënt toevoegen",
    'custom_button__include_client_id' => "Kenmerk van cliënt toevoegen",
    'custom_button__include_client_pname' => "Contactnaam van cliënt toevoegen",
    'custom_button__include_domain_id' => "Inclusief kenmerk van abonnement, domein en domeinalias",
    'custom_button__include_domain_id_powerUser' => "Inclusief kenmerk van abonnement, domein en domeinalias",

    'custom_button__include_domain_name' => "Primaire domeinnaam toevoegen",
    'custom_button__include_ftp_user' => "FTP-gebruikersnaam toevoegen",
    'custom_button__include_ftp_pass' => "FTP-wachtwoord toevoegen",
    'custom_button__internal_open' => "URL openen in Plesk",
    'custom_button__text' => "Knoptekst",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Het bestand is geen afbeeldingsbestanden.',
    'custom_button__big_image' => 'Het bestand mag niet groter zijn dan 100 KB.',
    'custom_button__failed_copy_image' => 'Kan het bestand niet kopiëren: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Kan geen reservekopie van een niet-Power User terugplaatsen in de Power User-weergave.',
    '__unknown_network_interface' => 'Onbekend netwerkkaart',

    'init_conf__ip_address' => 'IP-adres',

    //Confirmation page
    'bt_confirm' => 'Bevestigen',
    'b_confirm' => 'Bevestig dat u de eigenaar van uw sites bent.',

    //// New VZPP Integration
    '__vzpp_integration_warning' => 'Deze instantie van Plesk is geïnstalleerd in een Virtuozzo container. Vanwege de huidige instellingen voor het offline beheer van de container is Plesk nu niet beschikbaar.',
    '__vzpp_integration_contact_admin' => 'Als u over voldoende rechten beschikt om de containerconfiguratie te wijzigen, %1. Anders kunt u contact opnemen met uw provider die dit voor u kan uitvoeren.',
    '__vzpp_integration_help_link' => 'wijzig de instellingen voor offline beheer',



    'performance__iss_app_pool_forced_by_site_isolation' => 'Instellingen van exclusieve IIS groep van toepassingen worden ingesteld op basis van de beveiligingsregels van de server als geheel (configuratie van site-isolatie).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Instellingen van exclusieve IIS groep van toepassingen worden ingesteld op basis van de prestatie-instellingen voor de server als geheel.',

    '__current' => 'Huidig',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Eigenschappen van gebruiker zijn bijgewerkt.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'U hebt bijna alle domeinen gebruikt die horen bij uw Plesk-licentie (90% of zelfs meer).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'U hebt bijna alle domeinen gebruikt.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'U hebt bijna alle Presence Builder-sites gebruikt die horen bij uw Plesk-licentie (90% of zelfs meer).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'U kunt bijna alle Presence Builder-sites gebruikt',
    'promo__button_hide' => 'Verbergen',
    'promo__button_next' => 'Volgende >>',
    'promo__button_prev' => '<< Vorige',
    'promo__button_license' => 'Licentie bijwerken',

    'promo__google_integration_title' => 'Integratie met Google-diensten',
    'promo__google_integration' => 'Integratie met Google-diensten instellen, zoals AdSense, Google Apps, Webmasterhulpprogramma\'s.',
    'promo__google_integration_button' => 'Instellen',

    'promo__button_learn_more' => 'Meer weten?',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'U kunt het uiterlijk en de brandinginstellingen aanpassen met uw eigen thema\'s. Aanwijzingen voor het aanpassen van de thema\'s van Plesk vindt u in %1.',
    'panel_branding__description_link' => 'volgende document',
    'mail__enable_mail_ui_label' => 'Functies voor beheer van mail in Plesk inschakelen',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Bestanden uitpakken',
    'b_filemanager__extract' => 'Bestanden vanuit de geselecteerde archieven uitpakken naar de huidige map. Merk op dat bestandnamen na het uitpakken wellicht onjuist worden weergegeven wanneer deze speciale karakters bevatten.',
    'filemanager_error_extracting_files' => 'Er is een fout opgetreden bij het uitpakken van de archiefbestanden: %1',
    'filemanager_no_archive_files_specified' => 'Geef de archieven op die u wilt uitpakken.',
    'filemanager_not_zip_archive_specified' => '%1 kan niet worden uitgepakt; het is een ZIP-bestand.',
    'filemanager_files_successfully_extracted' => 'Het bestanden uit het archief zijn uitgepakt.',
    'filemanager_error_file_download' => 'Downloaden van het bestand is mislukt: %1',
    'filemanager__user_poolgrp' => 'Groep van toepassingen',

    'loading' => 'Laden',
    'bt_create_archive' => 'Aan archief toevoegen',
    'filemanager__pack' => "Zoekpad naar het archief: %1",
    'filemanager__archive_name' => 'Bestandsnaam van archief',
    'filemanager__empty_filename' => 'Geef de bestandsnaam van het archief op.',
    'filemanager_archive_created' => 'Het aanmaken van het archief is geslaagd.',
    'filemanager_error_creating_archive' => 'Kan het archief niet aanmaken: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Dit record zal in conflict zijn met het AAAA-record voor zone.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP-server ondersteunt geen IPv6-adressen)",
    'cmd_dns__glue_dns_record_conflict' => 'Dit record zal in conflict zijn met het glue-record voor zone \'%1\'.',
    '__ftp_ipv6_not_supported' => "(FTP-server ondersteunt geen IPv6-adressen)",
    '__ipv6_not_supported' => 'IPv6 wordt niet ondersteund.',
    'mail__ipv6_not_supported' => 'IPv6 wordt niet door de mailserver ondersteund.',
    'mail__relay_while_list_ipv6_not_supported' => 'IPv6 witte lijst-relay wordt niet door de mailserver ondersteund.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'De waarde van het masker moet een meervoud van 16 zijn.',
    'mail__ip_or_mask_is_invalid' => 'IP-adres of masker is ongeldig.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Doorsturen naar IPv6-adressen wordt niet ondersteund.',
    'sa__invalid_trusted_networks' => 'Onjuist opgegeven vertrouwde netwerken: %1',
    'dns_add__enter_ipv6_address' => "IPv6-adres",
    'license_trial_days_left' => 'Uw Plesk wordt uitgevoerd met een proeflicentie die over %1 dagen zal verlopen.',
    'excl_ipv6_num' => 'Exclusief IPv6-adres',
    '__ip_mask' => "Subnetmasker",
    '__ipv4_addr' => 'IPv4-adres',
    '__ipv6_addr' => 'IPv6-adres',
    'template__num_excl_ipv6s' => 'Exclusieve IPv6-adressen aan de reseller toewijzen',
    'anonftp__exclusive_ipv4_required' => 'Voor het instellen en gebruiken van anonieme FTP is een exclusief IPv4-adres nodig.',
    'anonftp__ipv4_already_used' => 'U kunt geen Anonieme FTP instellen voor deze site, omdat er al Anonieme FTP is ingesteld voor een ander domein op hetzelfde IPv4-adres.',


    'restart__kav' => "Kaspersky Antivirus",
    'panel_branding__page_description_admin' => 'Zorg voor uw eigen branding van Plesk door de paginatitels te wijzigen die verschijnen in de titelbalk van de browser en/of door het Plesk-logo in de linkerbovenhoek te vervangen.',
    '__view_migration_log_detailed_info' => 'Het logboek bekijken',

    'chown__ip_address_warn' => 'Voordat u het abonnement kunt overdragen aan de nieuwe houder moet u een IP-adres voor het abonnement selecteren.',
    'chown__no_ip_address' => 'Geen',
    'chown__no_ipv4_address' => 'Geen IPv4-adres',
    'chown__no_ipv6_address' => 'Geen IPv6-adres',
    'chown__domain_exclude_already_owned_by_client' => 'Het abonnement %1 hoort al bij deze gebruiker.',
    'chown__error_ip_absent_in_ip_pool' => 'Het IP-adres %1 ontbreekt in de IP-voorziening van de gebruiker van bestemming.',
    'chown__error_ip_not_exist' => 'Het IP-adres met kenmerk \'%1\' bestaat niet.',
    'chown__error_domain_ip_not_selected' => 'Er moet ten minste één IP-adres worden geselecteerd voor het domein %1. Controleer de waarden voor geselecteerde IP-toewijzing.',

    '__new_passwd_single' => "Wachtwoord",
    '__confirm_passwd_single' => "Wachtwoord bevestigen",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6-adres of masker is ongeldig: IP-adres moet een geldig unicast-adres zijn.',

    '__subscriptions' => 'Abonnementen',

    '__owned_by_reseller' => 'hoort bij reseller',
    '__owned_by_provider' => 'hoort bij provider',

    'service_plan__anonymous' => 'Aangepast',
    'subscription_not_locked__change_limits_warning' => 'Dit abonnement is niet vergrendeld: de beperkingen aan het gebruik van middelen zullen worden gewijzigd tijdens de synchronisatie met het dienstenpakket.',
    'subscription_not_locked__change_permissions_warning' => 'Dit abonnement is niet vergrendeld: de machtigingen zullen worden gewijzigd tijdens de synchronisatie met het dienstenpakket.',

    'subscription__conflict_resolution_policy' => 'Regels voor oplossen van conflicten',
    'subscription__conflict_resolution_policy_lock' => "Abonnement vergrendelen",

    'backup__list__backup_warnings' => 'Waarschuwingen',
    'backup__list__backup_info' => 'Informatie',
    'backup__restore__object_reseller_template' => 'Reseller-sjabloon',
    'backup__restore__object_domain_template' => 'Domeinsjabloon',

    'ui__client/permissions_readonly__title' => 'Rechten',
    'ui__client/permissions_readonly__short-title' => 'Rechten',

    'subscription__unable_lock_anonymous' => 'Dit abonnement is niet gekoppeld aan een dienstenpakket en daarom is er geen vergrendeling om op te heffen.',
    'subscription__unable_sync_anonymous' => 'Dit abonnement is niet gekoppeld aan een dienstenpakket en kan daarom niet worden gesynchroniseerd.',
    'subscription__unable_sync_locked' => 'Dit abonnement is vergrendeld en kan daarom niet worden gesynchroniseerd.',
    'subscription__locked' => 'Het abonnement is vergrendeld.',
    'component_name__urlrewrite' => "URL-rewrite",
    '__quantity' => 'Hoeveelheid',
    'hst__www_root_dir_absent' =>  'Waarschuwing: de map die is opgegeven als hoofdmap bestaat niet.',
    'object_creation__domain_is_not_a_webspace' => 'Dit object kan alleen worden aangemaakt binnen een abonnement.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Abonnementen bevatten sites en daarom kunt u deze niet verwijderen en het type hosten niet wijzigen.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Foutmelding:Het bijwerken van het IP-adres is mislukt.Aan aanvullende domeinen kan geen IP-adres worden toegewezen dat niet is toegewezen aan het hoofddomein van het abonnement.',
    'domain_plan__unable_change' => 'Kan het dienstenpakket niet wijzigen: %1.',
    'domain_plan__different_hosting_type' => 'Het huidige type hosting wijkt af van het type dat voor het abonnement is opgegeven.',
    'domain_plan__addon_text' => 'Uitbreidingspakket',
    'domain_plan__addon_description' => 'Uitbreidingspakket wordt gebruikt als toevoeging aan een hostingpakket.',
    'asp_net__managed_runtime_version' => 'ASP.NET-beheerde runtimeversie',
    'plan__can_not_change_hosting_type' => 'Het is onmogelijk het type hosting te wijzigen tijdens het bewerken van een pakket.',
    'plan__apply_problems' => 'Het pakket is niet toegepast vanwege problemen met de volgende functionaliteit: %1',
    'plan_save__subscription_update_problem' => 'Kan wijzigingen in het pakket niet toepassen op %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Het abonnement is tijdelijk opgeschort totdat het maken of terugplaatsen van de reservekopie is voltooid. Komt u over enkele ogenblikken terug.",
    'mail__whitenet_exists' => "Witte lijst met voorvoegsel %1 bestaat al.",
    '__login_incorrect_plain_shadow_password' => 'U hebt een onjuist wachtwoord voor het beheerderaccount opgegeven. Gebruik de gebruikersnaam en het wachtwoord van de systeembeheerder (root) of zorg dat u het juiste wachtwoord achterhaalt. Als u meer wilt weten over het achterhalen van het wachtwoord, lees dan het bestand /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'U kunt het IP-adres dat u niet bezit niet verzenden',

    'dns__dns_zone_not_synchronized' => 'De DNS-zone is gewijzigd. Als u wijzigingen van het DNS-sjabloon op deze zone wilt toepassen klik dan of op de knop \'Wijzigingen van het DNS-sjabloon toepassen\' op deze pagina, of kies de optie \'De toepassingen op alle zones toepassen\' in Serverbeheer > Hulpprogramma\'s & instellingen > Instellingen DNS-sjabloon > Wijzigingen DNS-sjabloon toepassen.',
    'dns__dns_zone_synchronize_link' => 'Klik',
    'dns__dns_zone_synchronize_done' => 'Het synchroniseren van de DNS-zone is geslaagd.',

    'dns__dns_zone_template_not_synchronized' => 'Het DNS-sjabloon is gewijzigd en deze zal worden toegepast op alle nieuwe domeinen die worden aangemaakt. U kunt ook %1.',
    'dns__dns_zone_soa_template_not_synchronized' => 'Het SOA-sjabloon is gewijzigd en wordt toegepast op alle nieuw aangemaakte domeinen. U kunt ook %1.',
    'dns__dns_zone_template_synchronize_link' => 'de wijzigingen op alle gehoste domeinen toepassen',
    'dns__dns_zone_template_error_details' => 'Details',
    'dns__dns_zone_template_error' => 'Er zijn problemen opgetreden bij het synchroniseren van DNS-zones met het sjabloon van de DNS-zone.%1',

    'dns__soa_rname_type_owner' => 'E-mailadres van de houder van de website',
    'dns__soa_rname_type_domain' => 'E-mailadres domein',
    'dns__soa_rname_type_external' => 'Extern e-mailadres',
    'dns__soa_rname_enforce_email' => 'Het wijzigen van het RNAME-mailadres voor individuele domein niet toestaan',
    'dns__soa_rname_label' => 'E-mail (RNAME)',
    'dns__soa_rname_hint' => 'Het e-mailadres van degene die verantwoordelijk is voor de DNS-zone van het domein. Teruggestuurd door de DNS-server als antwoord op SOA-aanvragen.',

    'dns__dns_zone_soa_sync_title' => 'De SOA-instellingen voor alle bestaande domeinen vervangen',
    'dns__dns_zone_soa_sync_legend' => 'Bevestiging vereist',
    'dns__dns_zone_soa_sync_text' => 'Wilt u de SOA-records van alle gehoste domeinen bijwerken met de wijzigingen die zijn gemaakt in het SOA-sjabloon?',

    'cu_db__repair_mysql_dbus' => "MySQL-gebruikerswachtwoorden herstellen. Deze bewerking is noodzakelijk als u een upgrade naar Plesk 11 hebt uitgevoerd vanaf een eerdere versie.",

    'scheduled_backup_settings__start_at_hint' => 'De interval voor controle op ingeroosterde taken voor reservekopieën is 15 minuten. Als u wilt dat Plesk op een specifiek moment begint met het maken van de reservekopie, zorg dan dat u de taak minimaal 15 minuten voor de gewenste tijd inroostert.',
    'cu_scheduled_backup_comment' => 'Ingeroosterde reservekopie',
    'cu_scheduled_backup_error' => 'Er is een fout opgetreden tijdens het maken van de reservekopie: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Er is een fout opgetreden tijdens het maken van de ingeroosterde reservekopie.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk-ingang: %2\n\nDe volgende fout is opgetreden tijdens het maken van de ingeroosterde reservekopie:\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'Ingeroosterde reservekopie. Alle instellingen en content.',
    'cu_scheduled_backup_comment_backup_vhost' => 'Ingeroosterde reservekopie. Alle instellingen en content, behalve mail.',
    'cu_scheduled_backup_comment_backup_mail' => 'Ingeroosterde reservekopie. Alleen mail-instellingen en -content.',
    'cu_scheduled_backup_comment_backup_domain' => 'Ingeroosterde reservekopie. Domein-instellingen.',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'Storing scheduled backups in a remote cloud storage is a premium feature. Contact your hosting provider to unlock it.',

    'i_backup_invalid_file' => 'Dit is geen geldige reservekopie. Gegevens uit dit bestand kunnen niet worden teruggeplaatst. Klik op de naam van de reservekopie voor meer details.',

    'ui__server/migration/download-agent__short-title' => 'Migratie- en verhuisagent downloaden',
    'ui__server/migration/download-agent__title' => 'Migratie- en verhuisagent downloaden',
    'ui__server/migration/download-agent__description' => 'Download de meest recente versie van de Migratie- en verhuisagent vanaf de website van Plesk.',

    'filemanager_resulting_archive_exists' => 'Het bestand %1 bestaat al in de map van bestemming.',

    'agent_unable_to_connect' => 'Kan geen verbinding maken met de agent op \'%2\'. Zorg ervoor dat de agent is geïnstalleerd en wordt uitgevoerd en dat er geen problemen zijn met de verbinding naar de host \'%2\'.',
    'agent_test_connection_failed' => 'Verbinding met de agent op \'%2\' is mislukt.',

    'agent_unable_to_resolve_host' => 'Kan externe host \'%1\' niet vinden. Controleer dat er geen verbindingsproblemen met de host zijn.',
    'agent_unknown_curl_error' => 'De foutmelding \'%1\' is opgetreden tijdens de verbinding met de agent op \'%2\'.',
    'agent_unexpected_htp_code' => 'De onverwachte HTTP-code \'%1\' is ontvangen na de HTTP-aanvraag aan de agent op \'%2\'.',
    'agent_unable_to_auth' => 'Authenticatie op de host is niet mogelijk \'%1\'. Zie voor het oplossen van dit probleem de aanwijzingen in http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Er is een interne serverfout opgetreden tijdens het uitvoeren van de opdracht op de externe host \'%1\'.',
    'agent_response_is_empty' => 'Er is een lege reactie ontvangen op de HTTP-aanvraag aan de agent op \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Kan de Migratie- en verhuisagent niet vinden de lokale cache. Open de Migratie- en verhuisagent om het probleem op te lossen.',

    '__hosting_webdeploy' => "Publiceren met Web Deploy",
    'cu_domain__webdeploy' => "Publiceren met Web Deploy (standaard: %1)",
    'cu_dom_tpl__webdeploy' => "Publiceren met Web Deploy (standaard: %1)",
    'cu_subdomain__webdeploy' => "Publiceren met Web Deploy (standaard: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy is niet geïnstalleerd op de server",
    'webdeploy__forced_by_site_isolation' => "Kan de instellingen voor publiceren met Web Deploy niet wijzigen: U beschikt niet over het recht om buiten de beveiligingsinstellingen voor de server als geheel om te gaan. Neem voor meer details contact op met uw provider.",



    'backup__restore_options__admin__server_configuration_license' => 'Licentiesleutel',
    'migration_start_migrate_server_license' => 'Licentiesleutel overdragen',

    'defaultcomponents__delegation_rule_not_exist' => '(de vereiste toewijzingsregel \'appPoolPipeline, appPoolNetFx\' is niet aanwezig)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'De reservekopie is aangemaakt door de beheerder.',
    'i_backup_created_by_reseller' => 'De reservekopie is aangemaakt door een reseller.',
    'i_backup_created_by_client' => 'De reservekopie is aangemaakt door een cliënt.',

    'migration__object_exists_on_target_host' => '(bestaat al op de host van bestemming)',

    '__customers_total' => 'Totaal door cliënten',
    '__resellers_total' => 'Totaal door resellers',
    '__reseller_total' => 'Reseller-totaal',


    'cu__mailserver_update_webmail_command' => "Geeft een webmailprogramma aan dat u wilt in- of uitschakelen",
    'cu__mailserver_webmail_state' => "Geeft de status van het geselecteerde webmailprogramma aan (true stelt het programma in, false schakelt deze uit)",

    'cu_db_set_default_user' => 'Een specifieke gebruiker als standaard voor een database instellen. De optie wordt gebruikt met de volgende opdrachten: add_user, update_user',

    'cu_role__opt_subscription_name' => 'Gebruikers alleen toegang tot een specifiek abonnement toestaan',
    'cu_role__opt_for_all_subscription' => 'Gebruikers toegang toestaan tot alle abonnementen binnen een hostingaccount',
    'cu_role__subscription_not_found_role_is_not_limited' => 'Kan geen wijzigingen van de rol toepassen: Het abonnement %1 is niet gevonden.',

    'cu_cl_pref__manage_website_maintenance' => 'Toegang tot geavanceerde bewerkingen: Website kopiëren',
    'cu_cl_pref__manage_protected_dirs' => 'Beheer van met wachtwoord afgeschermde mappen',
    'cu_cl_pref__manage_mail_settings' => 'Mogelijkheid om mail-instellingen te wijzigen',


    'cu__command_update_php_settings' => 'Werkt de PHP-instellingen bij.',
    'cu__php_settings_option' => 'Stelt het zoekpad naar het bestand in met PHP-instellingen.',

    'cu__additional_php_settings_option' => 'Stelt het zoekpad naar het bestand in met aanvullende PHP-opdrachten.',
    'cu__command_show_php_settings' => 'Toont de huidige PHP-instellingen.',
    'cu__general_settings' => 'Algemene instellingen:',
    'cu__performance_settings' => 'Prestatie-instellingen:',
    'cu__php_fpm_settings' => 'Instellingen PHP-FPM',
    'cu__additional_directives' => 'Aanvullende opdrachten:',

    'b_filemanager__pack' => 'Het geselecteerde bestand aan een archief toevoegen.',

    'php_settings_permission_required' => 'Beheer algemene PHP-instellingen',
    'php_settings_performance_permission_required' => 'Instellingen hostingprestaties',
    'php_settings_customized' => 'PHP-instellingen zijn aangepast.',
    'php_settings_synchronized_with_plan' => 'PHP-instellingen moeten met het pakket worden gesynchroniseerd.',
    'phosting__unknown_shell_type' => 'Niet-beschikbare shell',

    'login_up__access_denied_subscription_deleted' => 'Toegang geweigerd: Uw abonnement is verwijderd.',

    'role_restricted_to_subscription' => '(overgedragen met het abonnement: %1)',

    'filemanager__extract' => "Bestanden uitpakken naar: %1",

    'cu__license_command_check_installed_license' => 'Controleer de geldigheid van de geïnstalleerde licentiesleutel (geeft de exitcode 0 als de sleutel geldig is en 1 als deze ongeldig is)',

    'promo__mobile_manager_title' => 'Plesk Mobile Server Manager',
    'promo__mobile_manager' => "Geef Plesk meer functies, zodat u de server vanaf mobiele apparaten (BlackBerry, iPhone, and Android) kunt beheren en in de gaten houden.",
    'promo__mobile_monitor_title' => 'Plesk Mobile Server Monitor',
    'promo__mobile_monitor' => 'Bekijk de belangrijkste informatie over uw Plesk-servers op elk moment en vanaf elke locatie via een mobiel apparaat (BlackBerry, iPhone en Android).',
    'promo__mobile_button' => 'Meer weten?',

    'ui__server/migration/video__short-title' => 'Videolessen',
    'ui__server/migration/video__title' => 'Videolessen bekijken',
    'ui__server/migration/video__description' => 'Videolessen bekijken.',

    'auto_install_updates_moved_to_separate_page' => 'Het updatebeleid instellen',

    '__system_preferences' => 'Systeeminstellingen',
    'subDomainNameHint' => 'Geef * op als naam van een subdomein om een joker-subdomein aan te maken. Bezoekers van de website zullen naar dit subdomein worden geleid, ongeacht welk subdomein ze in hun browser invoeren.',
    'subdomains__wildcard_name_invalid' => "De naam van het subdomein is ongeldig. U kunt alleen alfanumerieke karakters gebruiken, het verbindingsstreepje (-) en de asterisk (*) voor namen van joker-subdomeinen.",
    'subdomains__name_invalid' => "De naam van het subdomein is ongeldig. U kunt alleen alfanumerieke karakters gebruiken en het verbindingsstreepje (-) voor namen van subdomeinen.",

    'domain__wildcard_no_www_prefix' => 'Het is niet mogelijk het voorvoegsel www te gebruiken voor subdomeinen met een joker.',

    '__service_title__milter' => "Plesk Postfix-milter",
    '__service_description__milter' => "Plesk Postfix-mailfilter",
    '__milter' => "Postfix-milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Courier POP3 server",
    'restart__pop3s' => "Courier POP3 server met ondersteuning voor SSL/TLS",
    'restart__imap' => "Courier IMAP server",
    'restart__imaps' => "Courier IMAP server met ondersteuning voor SSL/TLS",
    'restart__authdaemon' => "Courier IMAP authenticatie-daemon",
    'restart__imap-pop3' => "Dovecot IMAP- en POP3-server",


    'addon_packages_not_supported' => 'Uitbereidingen van APS-verpakte webtoepassingen worden niet ondersteund.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Kan niet automatisch een IP-adres aan het domein toewijzen. Geef een IP-adres op met de optie -ip.',

    'plesk_key__mb_accounts' => 'Gebruikeraccounts (resellers en cliënten) in Customer & Business Manager',

    'actionlog__subdomain_dns' => 'Subdomein DNS-zone',
    'actionlog__site_subdomain_dns' => 'DNS-zone van een subdomein onder aanvullend domein',

    // PfW only
    'actionlog__event_site_create' => 'Domein aangemaakt',
    'actionlog__event_site_delete' => 'Domein verwijderd',
    'actionlog__event_site_update' => 'Domein bijgewerkt',

    'actionlog__event_site_status_update' => 'Domeinstatus bijgewerkt',
    'actionlog__event_site_dns_update' => 'DNS-zone van domein is bijgewerkt',
    'actionlog__event_site_guid_update' => 'GUID van domein bijgewerkt',

    'actionlog__event_site_subdomain_create' => 'Subdomein aangemaakt',
    'actionlog__event_site_subdomain_delete' => 'Subdomein verwijderd',
    'actionlog__event_site_subdomain_update' => 'Subdomein bijgewerkt',

    'actionlog__event_site_alias_create' => 'Domeinalias aangemaakt',
    'actionlog__event_site_alias_delete' => 'Domeinalias verwijderd',
    'actionlog__event_site_alias_update' => 'Domeinalias is bijgewerkt',

    'actionlog__event_site_alias_dns_update' => 'DNS-zone van een domeinalias is bijgewerkt',
    'actionlog__event_subdomain_dns_update' => 'DNS-zone van een subdomein onder het standaarddomein is bijgewerkt',
    'actionlog__event_site_subdomain_dns_update' => 'DNS-zone van een subdomein bijgewerkt',
    // End of PfW only

    'rdp_app__type' => 'Toepassing voor terminalsessie',
    'rdp_app__msactivex' => 'Microsoft RDP ActiveX',
    'rdp_info__prop_title' => "Verbinding maken met de server via Extern bureaublad",
    'rdp_info__session_title' => 'Terminalsessie met server %1 (%2)',
    'rdp_info__prop_legend' => "Eigenschappen terminalsessie",
    'rdp_screen_resolution' => 'Schermresolutie voor terminalsessie',
    'rdp_user_name' => 'Gebruikersnaam terminalsessie',

    'win_policy__bad_password' => 'Validatie mislukt: het wachtwoord is ongeldig.',
    'win_policy__password_too_short' => 'Validatie mislukt: het wachtwoord voldoet niet aan de vereisten omdat het te kort is.',
    'win_policy__password_too_long' => 'Validatie mislukt: het wachtwoord voldoet niet aan de vereisten omdat het te lang is.',
    'win_policy__password_not_complex_enough' => 'Verificatie mislukt. Het wachtwoord is niet complex genoeg en voldoet niet aan de eisen gesteld in het wachtwoordbeleid. Sterke wachtwoorden bevatten tenminste het volgende: acht tekens, waarvan één hoofdletter of kleine letter, drie cijfers en één bijzonder karakter (!, @, #, $, %, ^, &, *, ?, _, ~), of één cijfer en twee bijzondere karakters.',

    //// Activation Code feature
    'key__tabs_activation' => 'Activering licentiesleutel',
    'key__description' => 'Hier kunt u de licentiesleutel installeren door het invoeren van een activeringscode of door het uploaden van een licentiesleutelbestand.',
    'key__description_code_only' => 'Hier kunt u uw licentiesleutel installeren door een activatiecode in te voeren.',
    'key__license_key' => 'Kies een van de volgende opties:',
    'key__code_text' => 'Voer een activeringscode in',
    'key__code_hint' => 'Plak hier de activeringscode die u hebt ontvangen.',
    'key__file_text' => 'Een licentiesleutelbestand uploaden',
    'key__file_hint' => 'Geef het zoekpad op naar het bestand dat de licentiesleutel bevat.',
    'plesk_key__code_check_wrong' => 'De activeringscode is niet geldig.',
    'plesk_key__license_update_failed' => 'Kan de productlicentie niet bijwerken.',


    'filemanager__error_path_is_not_allowed' => 'Zoekpad is niet toegestaan',
    'filemanager__error_path_is_invalid' => 'Zoekpad is ongeldig',
    'filemanager__error_path_not_found' => 'Zoekpad niet gevonden',
    'filemanager__error_path_already_exists' => 'Zoekpad bestaat al',
    'filemanager__error_access_is_denied' => 'Toegang geweigerd',
    'filemanager__error_directory_not_empty' => 'Map is niet leeg',
    'filemanager__error_sharing_violation' => 'Fout bij delen',
    'filemanager__error_not_same_device' => 'Zoekpad van bestemming bevindt zich niet op hetzelfde apparaat',
    'filemanager__binary_data_access' => 'Dit bestand kan binair zijn. Wilt u het toch openen?',
    'filemanager__unable_to_resolve_realpath' => "Kan het bestand %1 niet vinden op de opgegeven locatie",
    'filemanager__access_to_realpath_denied' => "Toegang tot werkelijk zoekpad geweigerd: van %1 naar %2.",
    'bt_exit' => 'Afsluiten',

    'filemanager__chdir_error__' => "Kan map niet wijzigen naar %1: %2",
    'filemanager__chmod_dir' => "Rechten voor map %1 wijzigen",
    'filemanager__chmod_error__' => "Kan rechten niet wijzigen voor bestand %1: %2",
    'filemanager__chmod_file' => "Rechten voor bestand %1 wijzigen",
    'filemanager__copy_error__' => "Kan %1 niet naar %2 kopiëren: %3",
    'filemanager__copy_move' => "Bestanden kopiëren (verplaatsen) vanaf %1",
    'filemanager__count_size__' => 'Selectiegrootte: %1',
    'filemanager__count_size_error__' => 'Kan de omvang niet berekenen voor %1: %2',
    'filemanager__create_dir' => "Aanmaken van mappen",
    'filemanager__create_dir_error__' => "Kan map %1 niet aanmaken: %2",
    'filemanager__dir_not_exists' => "Map %1 bestaat niet.",
    'filemanager__dirname' => "Mapnaam",
    'filemanager__filename' => "Bestandsnaam",
    'filemanager__is_no_such' => "Er is geen bestand of map met de naam %1",
    'filemanager__empty_selection' => "Geen bestand(en) geselecteerd.",
    'filemanager__file_exists' => "Bestand %1 bestaat al.",
    'filemanager__move_error__' => "Kan %1 niet verplaatsen naar %2: %3",
    'filemanager__new_dir' => "Mapnaam",
    'filemanager__not_allowed' => "U bent niet gemachtigd om rechten voor dit bestand te wijzigen.",
    'filemanager__r_perm_dir' => "Mapinhoud weergeven",
    'filemanager__r_perm_file' => "Lees gegevens",
    'filemanager__remove' => "Bestanden verwijderen uit %1",
    'filemanager__remove_error__' => "Kan bestand %1 niet verwijderen: %2",
    'filemanager__rename_dir' => "Mapnaam %1 wijzigen",
    'filemanager__rename_error__' => "Kan de naam van %1 niet wijzingen in %2: %3",
    'filemanager__rename_file' => "Naam van bestand %1 wijzigen",
    'filemanager__set_win_permissions_dir' => "Rechten instellen voor %1 map",
    'filemanager__set_win_permissions_file' => "Rechten instellen voor %1 bestand",
    'filemanager__touch_confirm' => "Weet u zeker dat u het tijdstempel van de geselecteerde bestanden wilt wijzigen?",
    'filemanager__no_perms_or_unsupported_file_type' => 'Kan het bestand niet lezen, of het bestandsformaat wordt niet ondersteund.',
    'filemanager__upload_error__' => "Kan %1 niet uploaden naar %2: %3",
    'filemanager__upload_file' => "Bestand uploaden",
    'filemanager__upload_file_src' => "Zoekpad naar bestand",
    'filemanager__username' => "Gebruiker",
    'filemanager__w_perm_dir' => "Bestanden aanmaken",
    'filemanager__w_perm_file' => "Gegevens wegschrijven",
    'filemanager__x_perm_dir' => "Map doornemen",
    'filemanager__x_perm_file' => "Bestand uitvoeren",
    'filemanager__max_image_size_exceeded' => 'Kan de afbeelding niet weergeven. De grootte van de afbeelding kan niet kleiner zijn dan %2 bytes',

    '__fastcgi_unix_support' => 'Beheer FastCGI-ondersteuning',

    'ts_sessions_list' => 'Deze pagina toont de lijst met alle sessies van Terminaldiensten.',
    'b_tssessionslist_search' => 'Sessies zoeken op naam.',
    'b_tssessionslist_show_all' => 'Alle terminalsessies tonen.',
    'l_tssessionslist_state' => 'Sorteren op status.',
    'l_tssessionslist_name' => 'Sorteren op naam.',
    'l_tssessionslist_user' => 'Sorteren op gebruiker.',
    'b_tssessionslist_logoff' => 'Klik om de geselecteerde sessies af te melden.',
    'b_tssessionslist_disconnect' => 'Klik om de verbinding van de geselecteerde sessies te verbreken.',
    'tssessions_info' => 'De eigenschappen van de sessie bekijken.',
    'tssessions_disconnect' => 'Selecteer het selectievakje Verwijdering bevestigen en klik OK om de geselecteerde terminalsessies te beëindigen.',
    'tssessions_logoff' => 'Selecteer het selectievakje Verwijdering bevestigen en klik OK om de geselecteerde terminalsessies af te melden.',
    'b_tssession_disconnect_submit' => 'Klik om de wijzigingen door te voeren.',
    'b_tssession_logoff' => 'Klik om de sessie af te melden.',
    'b_tssession_logoff_submit' => 'Klik om de wijzigingen door te voeren.',
    'i_tssession_active' => 'Actief',
    'i_tssession_connected' => 'Verbonden',
    'i_tssession_disconnected' => 'Verbinding verbroken',
    'i_tssession_listen' => 'Lijst',
    'tssessions__tssessionslist' => 'Sessies',
    'tssessionslist__state' => 'S',
    'tssessionslist__name' => 'Naam',
    'tssessionslist__user' => 'Gebruiker',
    'bt_logoff_selected' => 'Afmelden',
    'bt_logoff' => "Afmelden",
    'bt_disconnect_selected' => 'Verbinding verbreken',
    'bt_tssession_logoff' => 'Afmelden',
    'bt_tssession_disconnect' => 'Verbinding verbreken',
    'bt_tssession_disconect' => 'Verbinding verbreken',
    'b_tssession_disconnect' => 'Klik om de verbinding van de sessie te verbreken.',
    'b_tssession_logoff_disabled' => 'Kan de sessie niet beëindigen.',
    'b_tssession_disconnect_disabled' => 'Kan de sessie niet verbreken.',
    'tssessions_info__title' => 'Eigenschappen van sessie %1',
    'tssessions_info__property_name' => 'Naam Eigenschap',
    'tssessions_info__property_value' => 'Waarde Eigenschap',
    'tssessions__disconnect_title' => 'De volgende Terminaldienstsessies zullen worden afgesloten:',
    'tssessions__session_cant_disconnect' => 'de sessie kan niet worden beëindigd',
    'tssessions__logoff_title' => 'De volgende Terminaldienstsessies zullen worden afgemeld:',
    'tssessions__session_cant_logoff' => 'de sessie kan niet worden afgemeld',
    'tssessions__select_sessions_to_logoff' => 'Selecteer de sessies die u wilt afmelden.',
    'tssessions__select_sessions_to_disconnect' => 'Selecteer de sessies waarvan u de verbinding wilt beëindigen.',
    'dns__subdomain_dns_zone_parent' => 'De DNS-records van dit subdomein worden opgeslagen in de bovenliggende DNS-zone (parent). U kunt de bovenliggende zone %1 aanpassen of u kunt een aparte zone aanmaken voor het subdomein.',
    'dns__subdomain_dns_zone_parent_link' => 'hier',
    'dns__no_dns_zone' => 'Er is geen DNS-zone toegewezen met het domein. Om de DNS-zone voor uw domein te beheren moet u klikken op de knop \\\'Terugkeren naar standaardwaarden\\\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Kan de zone van het subdomein niet inschakelen omdat er een CNAME-record voor dit subdomein aanwezig is in de zone van het bovenliggende domein.',

    '__hosting_write_modify' => 'Aanvullende schrijf- en bewerkrechten',


    'aspdotnet__title' => "ASP.NET-instellingen voor de server als geheel",
    'aspdotnet__dom_title' => "ASP.NET-instellingen voor website",
    'aspdotnet__wdir_title' => "ASP.NET-instellingen voor de virtuele map %1",
    'aspdotnet__group_cas_settings' => "Toegangsbeveiliging door middel van code",
    'aspdotnet__group_client_scripts' => "Instellingen Programmabibliotheek",
    'aspdotnet__group_conn_strings' => "Beheer verbindingsstring",
    'aspdotnet__group_custom_errors' => "Aangepaste foutmeldingsinstellingen",
    'aspdotnet__group_framework_version' => "Frameworkversie",
    'aspdotnet__group_globalization' => "Globaliseringsinstellingen",
    'aspdotnet__group_other' => "Sessie-instellingen",
    'aspdotnet__group_page_and_runtime' => "Complicatie en foutopsporing",
    'aspdotnet__invalid_dom_config_file' => "Het ASP.NET-configuratiebestand van dit domein is beschadigd. Om deze te herstellen, past u de standaard ASP.NET-configuratie toe door te klikken op Terug naar standaardinstelling.",
    'aspdotnet__invalid_file_enc' => "Ongeldige waarde voor parameter karakterset van bestand.",
    'aspdotnet__invalid_req_enc' => "Ongeldige waarde voor parameter karakterset van aanvraag.",
    'aspdotnet__invalid_res_enc' => "Ongeldige waarde voor parameter karakterset van antwoord.",
    'aspdotnet__invalid_parent_wdir_config_file' => "Het ASP.NET-configuratiebestand is beschadigd vanwege de beschadiging van de ASP.NET-configuratie van de %1 bovenliggende map. \nOm dit probleem op te lossen moet u de %1 ASP.NET-instellingen herstellen.",
    'aspdotnet__invalid_global_config_file_admin' => "De ASP.NET-configuratie is beschadigd vanwege de schade aan het configuratiebestand van de ASP.NET-server.",
    'aspdotnet__invalid_global_config_file' => "De ASP.NET-configuratie is beschadigd vanwege de schade aan het configuratiebestand van de ASP.NET-server. Neem voor ondersteuning contact op met uw provider.",
    'aspdotnet__invalid_sess_timeout' => "Ongeldige waarde voor timeout-parameter voor sessie. Geef een positief geheel getal op dat kleiner of gelijk is aan %1.",
    'aspdotnet__invalid_wdir_config_file' => "Het ASP.NET-configuratiebestand van deze webmap is beschadigd. Om deze te herstellen, past u de ASP.NET-configuratie van de bovenliggende virtuele map toe door te klikken op Terug naar standaardinstelling.",
    'aspdotnet__param_auth_mode' => "Verificatiemodus",
    'aspdotnet__param_conn_strings' => "Verbindingsstrings",
    'aspdotnet__param_conn_string_name' => "Naam",
    'aspdotnet__param_conn_string_value' => "Verbindingsparameters",
    'aspdotnet__param_culture' => "Cultuur",
    'aspdotnet__param_custom_err_mode' => "Aangepaste foutmeldingsmodus",
    'aspdotnet__param_custom_error_redirect' => "URL omleiden",
    'aspdotnet__param_custom_error_status' => "Statuscode",
    'aspdotnet__param_custom_errors' => "Aangepaste foutmeldingen",
    'aspdotnet__param_debug_mode' => "Foutopsporing inschakelen",
    'aspdotnet__param_def_language' => "Standaardtaal voor webpagina's",
    'aspdotnet__param_temp_directory' => "Tijdelijke map",
    'aspdotnet__param_file_enc' => "Karakterset van bestand",
    'aspdotnet__param_req_enc' => "Karakterset van aanvraag",
    'aspdotnet__param_res_enc' => "Karakterset van antwoord",
    'aspdotnet__param_sess_timeout' => "Sessie-timeout (minuten)",
    'aspdotnet__param_trust_level' => "CAS-vertrouwensniveau",
    'aspdotnet__param_ui_culture' => "UI-cultuur",
    'aspdotnet__param_version' => "Versie",
    'aspdotnet__param_trust_level_allow_override' => 'Toestaan dat het CAS-vertrouwensniveau wordt gewijzigd voor individuele websites',
    'aspdotnet__restore_default_confirm' => "Standaard ASP.NET-instelingen herstellen?",

    'bt_restore_default' => "Terug naar standaardinstelling",
    'b_aspdotnet' => 'ASP.NET-instellingen bewerken.',
    'b_aspdotnet__restore_default' => 'Standaard ASP.NET-instelingen herstellen.',
    'b_aspdotnet__restore_wdir_default' => "ASP.NET-instellingen van bovenliggende map terugplaatsen voor deze virtuele map.",
    'b_aspdotnet__restore_default_disabled' => 'Het herstel van de standaard ASP.NET-configuratie is niet beschikbaar: ASP.NET-configuratie is beschadigd op ofwel de server, of op het niveau van een bovenliggende map.',
    'b_autoinstaller' => 'Bijwerken van Plesk of componenten.',
    'b_autoinstaller_configure' => 'Update-instellingen.',
    'b_autoinstaller_install' => 'Geselecteerde componenten installeren.',

    '__iis_app_pool__use_dedicated' => 'Exclusieve IIS groep van toepassingen',
    '__iis_app_pool__use_dedicated_addons' => 'Exclusieve IIS groep van toepassingen voor elke website',
    '__iis_app_pool__enable_32bit_app_on_win64' => '32-bits-toepassingen inschakelen',
    'bt_iis_app_pool' => "IIS Groep van toepassingen",

    'performance__cpu_usage' => 'Maximaal gebruik van processor (%)',
    'performance__cpu_usage_action' => 'Actie bij beperking',
    'performance__cpu_usage_interval' => 'Beperkingsinterval (minuten)',
    'performance__cpu_usage_action_not_supported' => 'De opgegeven actie wordt niet ondersteund door de webserver.',

    'performance__idle_timeout_action_not_supported' => 'De opgegeven actie na een timeout bij inactiviteit wordt niet ondersteund door de webserver.',
    'performance__max_worker_processes' => 'Het maximaal aantal werkprocessen',
    'performance__idle_timeout' => 'Timeout bij inactiviteit (minuten)',
    'performance__idle_timeout_action' => 'Actie na timeout bij inactiviteit',
    'performance__recycling_by_time' => 'Recyclen op regelmatige tijden (minuten)',
    'performance__recycling_by_requests' => 'Recyclen als het maximaal aantal aanvragen is bereikt',
    'performance__recycling_by_virtual_memory' => 'Recyclen als de maximale hoeveelheid virtueel geheugen is gebruikt',
    'performance__recycling_by_private_memory' => 'Recyclen als de maximale hoeveelheid privégeheugen is gebruikt',
    'performance__managed_pipeline_mode' => 'Modus managed pipeline',
    'performance__managed_pipeline_mode_not_supported' => 'De opgegeven modus worden niet ondersteund door de webserver.',

    'iis_app_pool' => 'Beheer van IIS Groep van toepassingen.',
    'b_iis_app_pool' => 'IIS Groep van toepassingen beheren.',
    'iis_app_pool_cl_dom' => 'Beheer van IIS Groep van toepassingen.',

    'i_webdirs_not_protected' => 'Deze webmap is niet afgeschermd',
    'i_webdirs_protected' => 'Deze webmap is afgeschermd',
    'i_webdirs_manage_protection' => 'Afscherming beheren.',
    'i_webdirs_open' => 'Open map/bestand in de browser.',
    'i_webdirs_preferences_disabled' => 'Deze map is geen virtuele map.',
    'i_webdirs_permissions' => 'Rechten beheren.',
    'i_webdirs_permissions_disabled' => 'Het beheer van maprechten is niet beschikbaar.',
    'i_webdirs_type_dir' => 'Fysieke map',
    'i_webdirs_type_vdir' => 'Virtuele map',
    'i_webdirs_browse' => 'Door de inhoud van de map bladeren.',
    'i_webdirs_preferences' => 'Beheer webmapinstellingen',

    'l_webdirslist_type' => 'Mappen sorteren op type.',
    'l_webdirslist_protected' => 'Mappen sorteren op afschermingstatus.',
    'l_webdirslist_name' => 'Mappen sorteren op naam.',

    'b_webdirslist_remove' => 'De geselecteerde virtuele mappen verwijderen.',
    'b_webdirslist_search' => 'Geef een zoekopdracht op en klik om virtuele mappen te vinden.',
    'b_webdirslist_show_all' => 'Alle mappen tonen.',

    'l_webdirerrordocslist_code' => 'Foutmeldingdocumenten sorteren op het nummer van de foutcode.',
    'l_webdirerrordocslist_name' => 'Foutmeldingdocumenten sorteren op omschrijving van de fout.',
    'l_webdirerrordocslist_type' => 'Foutmeldingdocumenten sorteren op het soort foutmeldingdocument.',
    'l_webdirerrordocslist_location' => 'Foutmeldingdocumenten sorteren op locatie van het foutmeldingdocument.',

    'b_webdirerrordocslist_search' => 'Geef een zoekopdracht op en klik om foutmeldingdocumenten te vinden.',
    'b_webdirerrordocslist_remove' => 'De geselecteerde foutmeldingdocumenten verwijderen.',
    'b_webdirerrordocslist_show_all' => 'Alle foutmeldingdocumenten tonen.',

    'l_webdirmimetypeslist_name' => 'MIME-typen sorteren op extensie.',
    'l_webdirmimetypeslist_content' => 'MIME-typen sorteren op inhoud.',

    'b_webdirmimetypeslist_remove' => 'Geselecteerde MIME-types verwijderen.',
    'b_webdirmimetypeslist_search' => 'Geef een zoekopdracht op en klik om MIME-typen te vinden.',
    'b_webdirmimetypeslist_show_all' => 'Alle MIME-typen tonen.',

    'b_webdir_preferences' => "Instellen van virtuele map.",
    'b_webdir_permissions' => "Rechten van virtuele map.",
    'b_webdir_permissions_disabled' => "Het beheer van maprechten is niet beschikbaar.",
    'b_to_webdirs' => 'Terug naar het beheren van de mappen.',
    'b_to_webdir_mime_types' => 'Terug naar het beheer van MIME-types.',
    'b_to_webdir_error_docs' => 'Terug naar het beheren van foutmeldingdocumenten.',
    'b_to_webdir_protection' => 'Terug naar het beheren van de afscherming van virtuele mappen.',

    'webdirs__title' => 'Virtuele mappen %1',
    'webdirs__preferences_title' => 'Instellen van virtuele map',
    'webdirs__list_legend' => 'Virtuele mappen',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Naam',
    'webdirs__list_header' => '%1 onderdelen',
    'webdirs__tabs_general' => 'Algemeen',
    'webdirs__tabs_mime_types' => 'MIME-typen',
    'webdirs__tabs_error_docs' => 'Foutmeldingdocumenten',

    'webdirs__tabs_permissions' => 'Rechten',
    'webdir__remove_vdirs' => 'De volgende virtuele mappen zullen worden verwijderd:',
    'webdir__remove_mime_types' => 'De volgende MIME-typen zullen worden verwijderd:',
    'webdir__mime_types_title' => 'MIME-typen',
    'webdir__protection_disable_confirm' => 'Weet u zeker dat u deze map niet langer wilt afschermen?',
    'webdir__protect_title' => 'Gebruikers van afgeschermde URL',
    'webdirs__permissions_title' => 'Rechten van virtuele map',
    'webdirs__browse_content_permission_denied' => 'U beschikt niet over de rechten om de inhoud van deze map te bekijken.',
    'error_doc__list_code' => 'Fout',
    'error_doc__list_code_description' => 'Omschrijving',
    'error_doc__list_type' => 'Type',
    'error_doc__list_location' => 'Locatie',
    'error_doc__code' => 'Fout',
    'error_doc__type' => 'Type',
    'error_doc__type_file' => 'Bestand',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Locatie',
    'error_doc__legend' => 'Foutmeldingdocument',
    'error_doc__edit_title' => 'Foutmeldingdocument bewerken',
    'error_doc_erorr_invalid_url_location' => 'Het URL is ongeldig. Geef de juiste URL op.',
    'error_doc_erorr_invalid_file_location' => 'Het zoekpad is niet geldig. Geef het juiste zoekpad naar het bestand op.',
    'error_doc__type_default' => 'Standaard',

    'webdirs__tabs_protection' => 'Afscherming',
    'pb_webdirs' => 'Virtuele mappen',

    'webdirs_remove_title' => 'De volgende virtuele mappen zullen worden verwijderd:',
    'webdirs_mime_types_remove_title' => 'De volgende MIME-typen zullen worden verwijderd:',
    'webdirs_preferences_title' => 'Instellen van virtuele map',
    'webdirs_permissions_title' => 'Speciale rechten voor bestanden en mappen',
    'webdi_protection_disable_confirm' => 'Weet u zeker dat u de virtuele map niet langer wilt afschermen? Hiermee verwijdert u ook alle gebruikers en instellingen van de afgeschermde map.',
    'bt_protect' => 'Afschermen',
    'bt_unprotect' => 'Niet langer afschermen',
    'bt_show_additional_users' => 'Meer gebruikers tonen',
    'bt_hide_additional_users' => 'Minder gebruikers tonen',
    'error_doc__list_title' => 'Foutmeldingdocumenten',
    'error_doc__list_header' => 'Foutmeldingdocumenten',
    'error_doc__code_400' => 'Onjuiste aanvraag',
    'error_doc__code_401' => 'Niet geautoriseerd',
    'error_doc__code_401.1' => 'Niet geautoriseerd - Aanmelding mislukt',
    'error_doc__code_401.2' => 'Niet geautoriseerd - Aanmelding mislukt vanwege serverinstellingen',
    'error_doc__code_401.3' => 'Niet geautoriseerd - Niet geautoriseerd vanwege ACL op resource',
    'error_doc__code_401.4' => 'Niet geautoriseerd - Autorisatie mislukt door filter',
    'error_doc__code_401.5' => 'Niet geautoriseerd - Autorisatie mislukt door ISAPI/CGI-toepassing',
    'error_doc__code_401.7' => 'Niet geautoriseerd - Geweigerd vanwege autorisatiebeleid URL\'s',
    'error_doc__code_403' => 'Verboden',
    'error_doc__code_403.1' => 'Verboden - Uitvoeringstoegang geweigerd',
    'error_doc__code_403.2' => 'Verboden - Leestoegang geweigerd',
    'error_doc__code_403.3' => 'Verboden - Schrijftoegang geweigerd',
    'error_doc__code_403.4' => 'Verboden - SSL vereist',
    'error_doc__code_403.5' => 'Verboden - SSL128 vereist',
    'error_doc__code_403.6' => 'Verboden - IP-adres geweigerd',
    'error_doc__code_403.7' => 'Verboden - Cliëntcertificaat vereist',
    'error_doc__code_403.8' => 'Verboden - Sitetoegang geweigerd',
    'error_doc__code_403.9' => 'Verboden - Teveel gebruikers',
    'error_doc__code_403.10' => 'Verboden - Ongeldige configuratie',
    'error_doc__code_403.11' => 'Verboden - Wachtwoordwijziging',
    'error_doc__code_403.12' => 'Verboden - Mapper toegang geweigerd',
    'error_doc__code_403.13' => 'Verboden - Cliëntcertificaat ingetrokken',
    'error_doc__code_403.14' => 'Verboden - Weergeven van mapinhoud geweigerd',
    'error_doc__code_403.15' => 'Verboden - Licenties voor cliënttoegang overschreden',
    'error_doc__code_403.16' => 'Verboden - Cliëntcertificaat niet vertrouwd of onjuist opgemaakt',
    'error_doc__code_403.17' => 'Verboden - Cliëntcertificaat is verlopen of is nog niet geldig',
    'error_doc__code_403.18' => 'Verboden - Kan geen aanvraag vanuit deze toepassingsvoorziening uitvoeren',
    'error_doc__code_403.19' => 'Verboden - CGI-toegang geweigerd',
    'error_doc__code_403.20' => 'Verboden - Aanmelding met paspoort mislukt',
    'error_doc__code_404' => 'Niet gevonden',
    'error_doc__code_404.2' => 'Niet gevonden - Geweigerd vanwege Lockdown-beleid',
    'error_doc__code_404.3' => 'Niet gevonden - Geweigerd vanwege MIMEMAP-beleid',
    'error_doc__code_405' => 'Methode niet toegestaan',
    'error_doc__code_406' => 'Niet acceptabel',
    'error_doc__code_407' => 'Proxy-authenticatie vereist',
    'error_doc__code_412' => 'Niet aan voorwaarde voldaan',
    'error_doc__code_414' => 'URI van aanvraag is te lang',
    'error_doc__code_415' => 'Niet-ondersteund type media',
    'error_doc__code_500' => 'Interne serverfout',
    'error_doc__code_500.12' => 'Interne serverfout - Toepassing wordt opnieuw opgestart',
    'error_doc__code_500.13' => 'Interne serverfout - Server overbelast',
    'error_doc__code_500.15' => 'Interne serverfout - Rechtstreekse aanvragen voor GLOBAL.ASA verboden',
    'error_doc__code_500.16' => 'Interne serverfout - Fout in UNC-toegang',
    'error_doc__code_500.17' => 'Interne serverfout - URL autorisatieopslag niet gevonden',
    'error_doc__code_500.18' => 'Interne serverfout - URL autorisatieopslag kan niet worden geopend',
    'error_doc__code_500.19' => 'Interne serverfout - Metagegevens van bestand zijn beschadigd',
    'error_doc__code_500.100' => 'Interne serverfout - ASP-fout',
    'error_doc__code_501' => 'Niet geïmplementeerd',
    'error_doc__code_502' => 'Onjuiste gateway',
    'error_doc__code_503' => 'De dienst is tijdelijk niet beschikbaar',

    'mimetype__extension' => 'Extensie',
    'mimetype__content' => 'Inhoud',
    'mimetypeslist__title' => 'MIME-typen',
    'mimetypes__title' => 'MIME-typen',
    'mimetypes__select_to_remove' => 'Selecteer de MIME-typen die u wilt verwijderen.',
    'mimetypes__select_for_remove' => "Selecteer MIME-typen om te verwijderen.",
    'mimetypes_remove__title' => 'MIME-type verwijderen',
    'mimetype__legend' => 'MIME-type',
    'mimetype_edit__title' => 'MIME-type bewerken',
    'mimetype_edit__already_exists' => 'Het MIME-type voor deze extensie is al ingesteld.',
    'mimetype_edit__not_exists' => 'MIME-type bestaat niet.',
    'mimetype__content_type_other' => 'Aangepast.',

    'b_webdir_protection_enable' => 'De URL naar deze map met een wachtwoord afschermen.',
    'b_webdir_protection_disable' => 'Maak URL naar deze map voor iedereen toegankelijk.',
    'b_webdir_protection_disabled' => 'Afschermen van virtuele map is uitgeschakeld.',

    'b_pd_usr_create' => 'Klik om deze gebruiker van afgeschermde URL aan te maken.',
    'php__changeversion_title' => "Selecteer PHP-versie",
    'php__group_php_version' => "PHP-versie",

    'virtualdir__name' => 'Naam',
    'virtualdir__path' => 'Zoekpad',
    'virtualdir__read' => 'Leesrechten',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Schrijfrechten',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Brontoegang voor script',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Door mappen bladeren',
    'virtualdir__browse_short' => 'M',
    'virtualdir__script_execute' => 'Uitvoeringsrechten',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Bezoeken opnemen in logboek',
    'virtualdir__app_create' => 'Toepassing aanmaken',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Schakelt anonieme authenticatie in.',
    'virtualdir__auth_windows' => 'Schakelt Windows authenticatie in.',
    'virtualdir__auth_not_enabled' => 'Anonieme authenticatie of Windows authenticatie moet zijn ingeschakeld.',
    'virtualdir__require_ssl' => 'SSL/TLS vereist',
    'virtualdir__enable_default_doc' => 'Standaarddocumenten gebruiken',
    'virtualdir__default_doc' => 'Zoekvolgorde standaarddocumenten',
    'virtualdir__enable_parent_paths' => 'Gebruik van bovenliggende zoekpaden toestaan',
    'virtualdir__execute_in_mta' => 'Uitvoering van toepassingen in MTA-modus (multi-threaded apartment modus) toestaan',
    'virtualdir_create__title' => 'Virtuele map aanmaken in %1',
    'virtualdir_edit__title' => 'Eigenschappen van virtuele map %1',
    'virtualdir_edit__legend' => 'Virtuele map',
    'virtualdir_edit__application_legend' => 'Toepassingsinstellingen',
    'virtualdir_edit__security_legend' => 'Mapbeveiliging',
    'virtualdir_edit__documents_legend' => 'Documenten',
    'virtualdir_edit__list_legend' => 'Geneste virtuele mappen',
    'virtualdir_error__path_not_in__' => 'Ongeldig zoekpad opgegeven',
    'virtualdir_error__already_exists' => 'Er bestaat al een map met deze naam.',
    'virtualdir_root' => 'Virtuele mappen',
    'virtualdir_root__title' => 'Virtuele mappen',
    'virtualdir_root__list_legend' => 'Virtuele mappen',
    'virtualdir_se__none' => 'Geen',
    'virtualdir_se__script' => 'Alleen scripts',
    'virtualdir_se__script_execute' => 'Scripts en uitvoerbare bestanden',
    'virtualdirs__title' => 'Virtuele mappen',
    'virtualdirs__path_not_exists' => 'Ongeldig zoekpad.',
    'virtualdirs__select_for_remove' => "Selecteer de virtuele mappen die u wilt verwijderen.",
    'virtualdirs_remove__title' => 'Virtuele mappen verwijderen',
    'virtualdirs_phys_dir_exist' => 'Er bestaat al een fysieke map met deze naam. Als u doorgaat, zal deze niet langer toegankelijk zijn. Wilt u doorgaan?',
    'virtualdir_auto_create_dir' => "Fysieke map aanmaken met dezelfde naam als virtuele map",

    'asp_max_default_text' => 'Bepaald door bovenliggende map (%1 KB)',
    'asp_max_default_text_site' => 'Bepaald door IIS (%1 KB)',
    'asp_max_buffer_text' =>'Maximale omvang van de ASP-buffer (KB)',
    'asp_max_body_text' => 'Maximale omvang van de gehele inhoud van het bericht van een ASP-aanvraag (KB)',
    'asp_buffers_legend' =>'ASP-instellingen',

    'asp_debug_default_text' =>'Bepaald door bovenliggende map',
    'asp_debug_default_text_site' =>'Bepaald door IIS',
    'asp_client_debug_text' =>'Stel foutopsporing voor ASP-scripts aan de kant van de cliënt in',
    'asp_server_debug_text' =>'Stel foutopsporing voor ASP-scripts aan de kant van de server in',

    'webdirs__list_with_broken_dirs' => "Er zijn virtuele domeinen verbonden met niet-bestaande fysieke mappen.",
    'webdirs__vdir_physical_path_not_exist' => "Virtuele map is gekoppeld aan fysieke map die niet bestaat.",
    'webdirs__physical_path_not_exist' => "Het opgegeven zoekpad bestaat niet.",

    'filemanager__new_dir_title' => 'Map aanmaken',
    'php__configuration_title' => "PHP-instellingen",

    'permissions__title' => 'Toegangsrechten instellen',
    'permissions__title_advanced' => 'Geavanceerde toegangsrechten Instellen',
    'permissions__inherit_from_parent' => 'Sta de bovenliggende map toe om overdraagbare rechten door te geven aan dit object en alle onderliggende objecten. Voeg deze samen met de ingangen die hier expliciet zijn opgegeven.',
    'permissions__replace_on_children' => 'Rechteningangen van alle onderliggende objecten vervangen door hier getoonde ingangen.',
    'permissions__group_or_user_name' => 'Groeps- of gebruikersnamen',
    'permissions__Permissions_for' => 'Rechten voor',
    'permissions__allow' => 'Toestaan',
    'permissions__deny' => 'Weigeren',
    'permissions__FullControl' => 'Volledige controle',
    'permissions__Modify' => 'Aanpassen',
    'permissions__ReadAndExecute' => 'Lezen en uitvoeren',
    'permissions__ListFolderContents' => 'Mapinhoud weergeven',
    'permissions__Read' => 'Lezen',
    'permissions__Write' => 'Schrijven',
    'permissions__ReadControl' => 'Leescontrole',
    'permissions__WriteControl' => 'Schrijfcontrole',
    'permissions__ExecuteControl' => 'Uitvoeringscontrole',
    'permissions__TraverseFolderOrExecuteFile' => 'Map doornemen / bestand uitvoeren',
    'permissions__ListFolderOrRead' => 'Mapinhoud weergeven / gegevens lezen',
    'permissions__CreateFilesOrWrite' => 'Bestanden aanmaken / gegevens wegschrijven',
    'permissions__CreateFoldersOrAppend' => 'Mappen aanmaken / gegevens toevoegen',
    'permissions__DeleteSubfoldersandFiles' => 'Submappen en bestanden verwijderen',
    'permissions__Delete' => 'Verwijderen',
    'permissions__ChangePermissions' => 'Rechten wijzingen',
    'permissions__TakeOwnership' => 'Houderschap overnemen',
    'permissions__inherited_from' => 'Overgedragen vanaf',
    'permissions__not_inherited' => '<niet overgedragen>',
    'permissions__apply_to' => 'Toepassen op',
    'permissions__apply_onto' => 'Toepassen op:',
    'permissions__apply_onto1' => 'Alleen deze map',
    'permissions__apply_onto2' => 'Alleen submappen',
    'permissions__apply_onto3' => 'Deze map en submappen',
    'permissions__apply_onto4' => 'Alleen bestanden',
    'permissions__apply_onto5' => 'Deze map en bestanden',
    'permissions__apply_onto6' => 'Alleen submappen en bestanden',
    'permissions__apply_onto7' => 'Deze map, submappen en bestanden',

    'filemanager__not_allowed_dir' => "U bent niet gemachtigd om rechten voor deze map te wijzigen.",

    'filemanager__allow' => "Toestaan",
    'filemanager__deny' => "Weigeren",
    'filemanager__user_domusr' => 'Beheerder van de website',
    'filemanager__user_webusr' => 'Webgebruiker',
    'filemanager__user_admins' => 'Beheerders',
    'filemanager__user_system' => 'Systeem',
    'filemanager__user_aspnet' => 'ASP.NET-gebruiker',
    'filemanager__user_poolusr' => 'Gebruiker van toepassingsvoorziening',
    'filemanager__user_sysaccount' => 'Extra systeemgebruiker',

    'bt_permissions_advanced' => 'Geavanceerd',
    'b_permissions_advanced' => 'Klik om speciale rechten te bekijken en in te stellen.',

    'b_hotlinkprotection' => 'Hotlink-bescherming voor de website instellen.',
    'b_hotlinkprotection_on' => 'Hotlinkbescherming voor de inhoud van de website inschakelen.',
    'b_hotlinkprotection_off' => 'Hotlinkbescherming van op het domein aangeboden informatie uitschakelen.',

    'bt_hotlinkprotection' => 'Bescherming tegen hotlinking',
    'hotlinkprotection__title' =>'Bescherming tegen hotlinking',
    'hotlinkprotection__friend_domains' => 'Adressen van bevriende websites',
    'hotlinkprotection__extensions' => 'Extensies beschermde bestanden',

    'hotlinkprotection_invalid_friend_domains' => 'Ongeldige naam of namen voor bevriende domeinen.',
    'hotlinkprotection_invalid_extensions' => 'Bestandsextensie bevat onjuiste karakters.',

    'i_domain_alias_status_on' => 'Domeinalias is ingeschakeld.',
    'i_domain_alias_status_off' => 'Domeinalias is uitgeschakeld.',
    'i_domain_alias_status_with_parent' => 'Domeinalias is uitgeschakeld omdat het domein is uitgeschakeld.',
    'i_domain_alias_turn_off' => 'Klik om uit te schakelen.',
    'i_domain_alias_turn_on' => 'Klik om in te schakelen.',
    'i_domain_alias_mail_on' => 'Maildienst is ingeschakeld voor dit domeinalias.',
    'i_domain_alias_mail_off' => 'Maildienst is uitgeschakeld voor dit domeinalias.',
    'i_domain_alias_mail_with_parent' => 'Maildienst is uitgeschakeld omdat het domeinalias is uitgeschakeld.',
    'i_domain_alias_web_on' => 'Webdienst is ingeschakeld voor dit domeinalias.',
    'i_domain_alias_web_off' => 'Webdienst is uitgeschakeld voor dit domeinalias.',
    'i_domain_alias_web_with_parent' => 'Webdienst is uitgeschakeld omdat het domeinalias is uitgeschakeld.',
    'i_domain_alias_dns_on' => 'DNS-aliasingservice is ingeschakeld voor dit domeinalias.',
    'i_domain_alias_dns_off' => 'DNS-aliasingservice is uitgeschakeld voor dit domeinalias.',
    'i_domain_alias_dns_with_parent' => 'DNS-synchronisatie met bovenliggend domein is uitgeschakeld omdat het domeinalias is uitgeschakeld.',
    'i_domain_alias_seoRedirect_on' => 'Doorschakeling met HTTP-statuscode 301 is ingeschakeld voor dit domeinalias.',
    'i_domain_alias_seoRedirect_off' => 'Doorschakeling met HTTP-statuscode 301 is uitgeschakeld voor dit domeinalias.',
    'i_domain_alias_seoRedirect_with_parent' => 'Doorschakeling met HTTP-statuscode 301 is uitgeschakeld omdat het domeinalias is uitgeschakeld.',

    'domain_alias__control_title' => 'Domeinalias %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Dienstnaam',
    'domain_alias__control_details_title' => 'Details',

    'domain_alias__invalid_values' => 'De domeinnaam die u hebt opgegeven is ongeldig. Domeinnamen kunnen bestaan uit letters, cijfers en het verbindingstreepje. Elk deel van de domeinnaam, tussen de punten, mag niet langer zijn dan 63 karakters.',
    'domain_alias__domain_already_exists' => "Onjuiste naam voor domeinalias %1. Het domein %1 bestaat al.",
    'domain_alias__www_prefix_domain_already_exists' => "Onjuiste naam voor domeinalias www.%1. Dit alias is al aangemaakt voor het domein %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Onjuiste naam voor domeinalias webmail.%1. Dit alias is al aangemaakt voor het domein %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Onjuiste naam voor de lijst met domeinaliassen.%1. Dit alias is al aangemaakt voor het domein %1.',
    'domain_alias__dns_record_already_exists' => 'Kan het domeinalias %1 niet instellen, omdat er al een DNS-record is dat verwijst naar de host %1.',
    'domain_alias__domain_alias_already_exists' => "Er bestaat al een domeinalias met deze naam.",
    'domain_aliases__mail_server_not_support_aliases' => 'De mailserver ondersteunt geen domeinaliassen. Domeinaliassen werken mogelijk niet correct.',
    'domain_alias__restrict_domain_creation' => 'De opgegeven naam voor een domeinalias is verboden door de regels voor de server als geheel. Als u de houder van dit domeinalias bent, neem dan contact op met uw provider.',
    'domain_alias__restrict_creation_with_www' => 'Geef een domeinnaam op zonder het voorvoegsel \'www\'. Het voorvoegsel www zal automatisch aan het domein worden toegevoegd in de instellingen van de webserver.',
    'domain_unable_to_set_name' => 'Onjuiste naam %1.',

    'domain_alias__domain_service_dns_disabled' => 'Dit domein wordt bediend door een andere DNS-server.',
    'domain_alias__domain_service_dns_enabled_master' => 'Deze DNS-server doet dienst als primaire naamserver voor deze DNS-zone.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Deze DNS-server doet dienst als secundaire naamserver voor deze DNS-zone.',
    'domain_alias__domain_service_mail_enabled' => 'Maildienst is ingeschakeld voor het domein.',
    'domain_alias__domain_service_mail_disabled' => 'Maildienst is uitgeschakeld voor het domein.',
    'domain_alias__domain_service_mail_mx' => '%1 wordt als de mailserver gebruikt.',

    'domain_alias__service_seoRedirect_hint' => 'Wanneer bezoekers de URL van de alias openen, dan worden zij omgeleid naar de URL van het primaire domein. Plesk maakt gebruik van de zoekmachinevriendelijke HTTP 301-omleiding, want betekent dat de waarde van de site voor zoekmachines niet wordt verdeeld over verschillende URLs.',

    'bt_task_run_now' => 'Nu uitvoeren',
    'ftp__read_perm' => "Leesrechten",
    'ftp__write_perm' => "Schrijfrechten",

    'filemanager__upload_backup_file_hint' => 'Hier kunt u reservekopieën uploaden naar de opslag van Plesk. De maximale bestandsgrootte is twee gigabyte.',

    'additional_key__used' => 'Geactiveerd',

    '__default_for_mssql' => 'standaard voor MS SQL',

    '__login_does_not_pass_validation' => "Het gebruikersnaam is ongeldig. Zorg dat deze voldoet aan de volgende vereisten: %1",
    '__login_allowed_symbols' => 'Alleen alfanumerieke karakters, punten, streepjes en de underscores zijn toegestaan. Het eerste teken moet een letter of een cijfer zijn.',

    'restart__nginx' => 'Omgekeerde proxy-server (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Ik ontvang graag algemene productinformatie en aankondigingen van Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Ik ontvang graag informatie over beveiliging en andere technische meldingen van Plesk.",

    'server_preferences__webdeploy_include_password' => 'Het wachtwoord van de gebruiker opslaan in het bestand met de publicatie-instellingen van Web Deploy',

    '__login_status_inactive' => 'Uw account is inactief. Neem contact op met de Plesk-beheerder.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Terug naar de pagina Hulpprogramma\'s & instellingen. De migratie zal op de achtergrond worden voortgezet.',

    'ui__admin-alias-info__description' => "Contactgegevens van extra domeinbeheerderaccount bewerken.",
    'ui__admin-alias-info__short-title' => "Contactgegevens",
    'ui__admin-alias-info__title' => "Gegevens van extra beheerderaccount bewerken",
    'ui__admin-alias-password__description' => "Het extra beheerderwachtwoord wijzigen.",

    'ui__admin-alias-password__short-title' => "Wachtwoord wijzingen",
    'ui__admin-alias-password__title' => "Extra beheerderwachtwoord",
    'ui__admin-alias__description' => "Informatie over extra beheerderaccounts bekijken en wijzigen.",

    'chk_js__warning_about_login_syntax' => "U kunt in de gebruikersnaam kleine letters, cijfers, het streepje en de underscore gebruiken. De gebruikersnaam moet beginnen met een letter. Het wachtwoord mag niet de gebruikersnaam en aanhalingsteken bevatten.",
    'chk_js__warning_about_ftp_login_syntax' => "U kunt in de gebruikersnaam alfanumerieke karakters, het streepje en de underscore gebruiken.",
    'chk_js__warning_about_login_syntax_win' => "U kunt in de gebruikersnaam kleine letters, cijfers, de punt, het streepje en de underscore gebruiken. De gebruikersnaam moet beginnen met een letter of getal uit het alfabet. Het wachtwoord mag niet de gebruikersnaam en aanhalingsteken bevatten.",
    'chk_js__warning_about_passwd_syntax' => "Gebruik geen aanhalingstekens, spaties of letters met accenten in een wachtwoord.\nDe lengte van het wachtwoord moet tussen de %1 en %2 karakters liggen en mag niet de gebruikersnaam bevatten.",
    'chk_js__warning_about_plesk_login_syntax' => "U kunt kleine letters, cijfers, de punt, het verbindingsstreepje of de underscore gebruiken in de gebruikersnaam.",
    'chk_js__warning_about_plesk_login_syntax_win' => "U kunt in de gebruikersnaam kleine letters, cijfers, het streepje en de underscore gebruiken. De gebruikersnaam moet beginnen met een letter.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Gebruik geen aanhalingstekens, spaties of landspecifieke karakters in een wachtwoord.\nDe lengte van het wachtwoord moet tussen de %1 en %2 karakters liggen en mag niet de gebruikersnaam bevatten.",
    'chk_js__warning_about_pam_passwd_error' => "Onjuist systeemgebruikeraccount opgegeven: %1",

    'cmd_server__admin_alias_not_found' => "Kan het extra beheerderaccount niet vinden.",

    'panel_branding__skins_already_exists' => "Opmerking: De thema \"%1\" bestaat al. Deze zal worden vervangen door het thema dat u nu aan het installeren bent.",
    'panel_branding__skins_file_exists' => "Kan geen map aanmaken voor thema '%1': er bestaat al een bestand met deze naam.",

    'actionlog__login_failed' => 'Aanmelden is mislukt',
    'actionlog__event_cp_user_login_failed' => 'Aanmelden van Plesk-gebruiker is mislukt',
    'actionlog__api_login_failed' => 'aanmelden via API is mislukt',
    'actionlog__event_cp_user_api_login_failed' => 'Aanmelden van Plesk-gebruiker via API is mislukt',
    'actionlog__pw_reset' => 'aangevraagde wijziging van wachtwoord',

    'ch_pass_by_secret__email_subject' => "Wachtwoordherinnering Plesk",
    'ch_pass_by_secret__email_body' => "Hallo %2,\n\nOm een nieuw wachtwoord in te stellen volgt u de volgende link: %1\n\nUw gebruikersnaam: %3",
    'ch_pass_by_secret__message_send_error' => 'Kan de geheime code niet versturen: %1',
    'ch_pass_by_secret__title' => 'Uw wachtwoord wijzigen',
    'ch_pass_by_secret__secret' => 'Geheime code',

    'custom_button__noframe' => "Geen frames gebruiken",

    'custom_button__internal_hint' => 'Geef aan of de URL moet worden geopend in Plesk of in een nieuw venster van de browser.',
    'custom_button__noframe_hint' => 'Wanneer u een aangepaste knop toevoegt die leidt naar een Plesk-extensie of naar een app in Hostingbeheer, dan kunt u hier aangeven hoe deze extensie/app moet worden weergegeven: in een frame of als onderdeel van de grafische interface van Plesk.',


    'actionlog__patch' => 'Bijwerken',
    'actionlog__patch_available' => 'beschikbaar',
    'actionlog__event_patch_available' => 'Update beschikbaar',
    'actionlog__patch_installed' => 'geïnstalleerd',
    'actionlog__event_patch_installed' => 'Update geïnstalleerd',

    'actionlog__extension' => 'Extensie',
    'actionlog__extension_status' => 'Status van extensie',
    'actionlog__cloning' => 'Server-klonen',
    'actionlog__cloning_complete' => 'voltooid',
    'actionlog__event_cloning_complete' => 'Het klonen van de server is voltooid',

    'actionlog__ssl_web_binding' => 'SSL/TLS-certificaat voor domein',
    'actionlog__ssl_web_binding_update' => 'wel of niet toegewezen',
    'actionlog__event_ssl_web_binding_update' => 'SSL/TLS-certificaat voor domein wel of niet toegewezen',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS-certificaat voor webmail',
    'actionlog__ssl_web_mail_binding_update' => 'wel of niet toegewezen',
    'actionlog__event_ssl_web_mail_binding_update' => 'SSL/TLS-certificaat voor webmail wel of niet toegewezen',

    'actionlog__ssl_mail_binding' => 'SSL/TLS-certificaat voor mailserver',
    'actionlog__ssl_mail_binding_update' => 'wel of niet toegewezen',
    'actionlog__event_ssl_mail_binding_update' => 'SSL/TLS-certificaat voor e-mailserver wel of niet toegewezen',

    'actionlog__ssl_panel_binding' => 'SSL/TLS-certificaat voor Plesk',
    'actionlog__ssl_panel_binding_update' => 'wel of niet toegewezen',
    'actionlog__event_ssl_panel_binding_update' => 'SSL/TLS-certificaat voor Plesk wel of niet toegewezen',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Totaal per domein',

    'chk_js__warning_about_admin_passwd_syntax' => "Gebruik geen aanhalingstekens, spaties, puntkomma of landspecifieke karakters in een wachtwoord.Het wachtwoord moet tussen de %1 en %2 tekens lang zijn en mag niet de gebruikersnaam bevatten.",

    'passwordSecurityLevelCheckFailed' => 'Uw wachtwoord is niet complex genoeg. De server is ingesteld om alleen wachtwoorden toe te staan met sterkte %1 of hoger. Om de sterkte van het wachtwoord te verbeteren kunt u getallen gebruiken, hoofdletters en kleine letters, en speciale karakters zoals !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Zeer zwak',
    'passwordSecurityLevelCheckFailedWeak' => 'Zwak',
    'passwordSecurityLevelCheckFailedMediocre' => 'Gemiddeld',
    'passwordSecurityLevelCheckFailedStrong' => 'Sterk',
    'passwordSecurityLevelCheckFailedStronger' => 'Zeer sterk',

    'cu__php_settings__command_update_all' => "PHP-instellingen per domein van alle domeinen bijwerken in overeenstemming met het bestand php.ini voor de server als geheel.",
    'cu__php_settings__update_all_done' => "De PHP-instellingen per domein zijn bijgewerkt voor alle domeinen.",

    'filemanager__invalid_path' => "Ongeldig zoekpad opgegeven",

    'rdp_app__msactivex_comment' => 'Wij raden aan Internet Explorer te gebruiken, omdat het component Microsoft RDP ActiveX wellicht niet goed werkt in andere browsers.',

    'additional_key__descr_app' => 'Toepassing',
    'additional_keys__used_keys' => ', %1 sleutels in gebruik',
    'additional_key__descr_key_mailboxes' => 'Postvakken',

    'ui__client/domain/dns/sync__description' => 'Wijzigingen van het DNS-sjabloon voor de server als geheel toepassen op de zone.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Kan de wijzigingen van het DNS-sjabloon niet toepassen op de zone omdat de zone gebruik maakt van een andere DNS-server.',
    'ui__client/domain/dns/sync__short-title' => 'Wijzigingen DNS-sjabloon toepassen',
    'ui__client/domain/dns/sync__done' => 'De wijzigingen van het DNS-sjabloon zijn op de zone toegepast.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Wijzigingen van het DNS-sjabloon voor de server als geheel toepassen op de zone.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Kan de wijzigingen van het DNS-sjabloon niet toepassen op de zone omdat de zone gebruik maakt van een andere DNS-server.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Wijzigingen DNS-sjabloon toepassen',
    'ui__client/domain/domain-alias/dns/sync__done' => 'De wijzigingen van het DNS-sjabloon zijn op de zone toegepast.',
    'bt_dns_zone_sync' => 'Wijzigingen DNS-sjabloon toepassen',
    'b_dns_zone_sync' => 'De wijzigingen van het sjabloon toepassen op bestaande DNS-zones.',
    'dns__dns_zone_sync_form' => 'Wijzigingen DNS-sjabloon toepassen',
    'dns__dns_zone_sync_legend' => 'Opties',
    'dns__dns_zone_sync_ways' => 'Kies een van de volgende opties:',
    'dns__dns_zone_sync_way_safe' => 'De wijzigingen toepassen op niet-gewijzigde zones. Als een zone is aangepast (er zijn nieuwe records toegevoegd of bestaande records zijn gewijzigd), dan zal Plesk de wijzigingen van het sjabloon niet op deze zones toepassen.',
    'dns__dns_zone_sync_way_forced' => 'De wijzigingen toepassen op alle zones. Plesk zal de wijzigingen van het sjabloon toepassen op alle DNS-zones, inclusief handmatig aangepaste zones. Merk op dat door de gebruiker aangepaste sjablonen altijd in tact zullen blijven. Als het sjabloon bijvoorbeeld een nieuw record bevat dat de klant zelf al had toegevoegd, dan dit door de klant toegevoegde record behouden blijven.',
    'dns__dns_default_ipv4_modified' => 'Records met dit IP-adres worden beschouwd als aangepast door de gebruiker en zullen niet worden gesynchroniseerd met het algemene DNS-sjabloon van de server.',
    'dns__dns_default_ipv6_modified' => 'Records met dit IP-adres worden beschouwd als aangepast door de gebruiker en zullen niet worden gesynchroniseerd met het algemene DNS-sjabloon van de server.',

    'dns__view_dns_record_master_title' => 'DNS-records bekijken',
    'dns__view_dns_record_off_title' => 'Naamserverrecords bekijken',
    'dns__view_dns_record_slave_title' => 'Bekijken van records primaire DNS-server',

    'dns_unable_to_resolve_hostname' => "Kan de hostnaam \"%1\" niet omzetten: %2\nControleer of de DNS-omzetter van het besturingssysteem correct is ingesteld en goed functioneert.",

    'no_database_server_available' => 'Er zijn voor dit abonnement geen database-servers beschikbaar.',

    'database_server_edit_form__admin_add_hint' => "Geef de gebruikersnaam en het wachtwoord op van de beheerder namens wie Plesk verbinding zal maken met de database-server. Er moet een beheerderaccount met deze gebruikersnaam en dit wachtwoord op de database-server aanwezig zijn.",
    'database_server_edit_form__admin_edit_hint' => "Hier kunt u de gebruikersnaam en het wachtwoord wijzigen waarmee Plesk verbinding maakt met de database-server. Deze gegevens moeten overeenkomen met de gebruikersnaam en het wachtwoord van de beheerder van de database. Nadat u de gebruikersnaam of het wachtwoord van de beheerder hebt gewijzigd in de database-server is het noodzakelijk om dezelfde wijziging ook door te voeren in Plesk.",
    'database_server_edit_form__admin_change_hint' => 'Hier kunt u de gebruikersnaam en het wachtwoord wijzigen waarmee Plesk verbinding maakt met de database-server. Als u hieronder de gebruikersnaam en het wachtwoord aanpast, dan zal het databasegebruikeraccount met beheerrechten worden bijgewerkt in zowel de database-server als in Plesk.',
    'database_server_edit_form__version' => 'Versie database-server',
    'database_used_by_application_can_not_be_moved' => 'Kan de database niet verplaatsen: er is een webtoepassing die van deze database gebruikt maakt.',
    'database_server_database_list__subscription' => 'Abonnement',
    'database_server_database_list__webspace' => 'Abonnement',
    'bt_assign_subscription_selected' => 'Naar abonnement verplaatsen',
    'bt_cp_login' => 'Openen in Hostingbeheer',
    'bt_cp_login_classic_mode' => 'Hostingbeheer',
    'hint_cp_login' => 'Beheer de database in Hostingbeheer van de abonnementhouder.',
    'hint_cp_admin_login' => 'De database beheren.',
    'hint_cp_login_classic_mode' => 'De database beheren.',
    'database_user_update_orphaned_is_restricted' => 'Het bijwerken van zwevende databasegebruikeraccounts is niet toegestaan. U kunt deze alleen verwijderen of herstellen.',

    'database_unable_to_get_max_filesize_default_message' => 'Kan de maximale bestandsgrootte van de database niet vaststellen: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Kan de maximale bestandsgrootte van de database niet instellen: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Kan de maximale bestandsgrootte van het logbestand van de database niet vaststellen: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Kan de maximale bestandsgrootte van het logbestand van de database niet instellen: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Kan de bestaande omvangbeperking van Microsoft SQL-database niet vaststellen \'%1\'. Het is onmogelijk een nieuwe beperking in te stellen.',
    'database_unable_to_set_max_filesize' => 'Kan de omvangbeperking voor Microsoft SQL-database \'%1\' niet instellen.',
    'database_unable_to_get_max_log_filesize' => 'Kan de logbestand omvangbeperking van Microsoft SQL-database niet vaststellen \'%1\'. Het is onmogelijk een nieuwe beperking in te stellen.',
    'database_unable_to_set_max_log_filesize' => 'Kan de logbestand omvangbeperking voor Microsoft SQL-database \'%1\' niet instellen.',

    'database_unable_to_create_because_max_filesize' => 'Kan Microsoft SQL-database \'%1\' niet aanmaken: het is groter dan de maximaal toegestane bestandsgrootte.',
    'database_unable_to_move_because_max_filesize' => 'Kan Microsoft SQL-database \'%1\' niet verplaatsen: het is groter dan de maximaal toegestane bestandsgrootte: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Kan Microsoft SQL-database \'%1\' niet aanmaken: het logbestand is groter dan maximaal is toegestaan.',
    'database_unable_to_move_because_max_log_filesize' => 'Kan Microsoft SQL-database \'%1\' niet verplaatsen: het logbestand is groter dan maximaal is toegestaan: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Kan de Microsoft SQL-database \'%1\' niet terugplaatsen: het is groter dan de maximaal toegestane bestandsgrootte.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Er is al een identieke MS SQL-server in Plesk geregistreerd. Geef een andere MS SQL-server op als sandbox.',
    'database_server__mssql_server_registered_as_sandbox' => 'Er is al een identieke sandbox MS SQL-server in Plesk geregistreerd. Geef een andere MS SQL-server op als sandbox.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Kan geen verbinding met de server maken via \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'De functie %1 wordt niet ondersteund door de volgende servicenodes: %2. Deze functie zal worden uitgeschakeld voor alle objecten die op deze nodes worden aangemaakt.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Deze functie %1 wordt niet ondersteund door de server. Deze functie zal worden uitgeschakeld voor alle teruggeplaatste objecten.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Het component %1 is niet geïnstalleerd. Dit zal niet beschikbaar zijn voor de volgende websites: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Het component %1 is niet geïnstalleerd. Deze zal worden vervangen door %2 voor de volgende websites: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'De huidige versie van Plesk ondersteunt geen gebruikersnamen waar een punt (.) in voorkomt. Cliënten en resellers met een dergelijk gebruikersnaam zullen niet worden teruggeplaatst.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Kan de reservekopie met de gegevens voor het %1 %2 niet vinden. De gegevens voor het %1 %2 zullen niet worden teruggeplaatst.',

    'bu_conflict_resolver_zone_master_removed' => "Kan het primaire DNS-record niet terugplaatsen: het record in de secundaire zone verwijst naar het bestaande IP-adres %1. Het primaire DNS-record zal worden verwijderd uit de secondaire zone.",

    'bu_conflict_resolver_not_available_scripting' => '%1 niet wordt ondersteund.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 niet wordt ondersteund. Dit zal niet beschikbaar zijn voor de volgende websites: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Het component %1 is niet geïnstalleerd',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Dit zal niet beschikbaar zijn voor de volgende servicenodes: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Dit zal niet beschikbaar zijn voor de volgende objecten: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'De volgend database-servers zijn niet beschikbaar op deze server: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'De reservekopie van de MS SQL-database is opgeslagen in het systeemeigen formaat van MS SQL. Dit kan alleen worden teruggeplaatst op de lokale MS SQL-server of op de externe MS SQL-server met volledig geconfigureerde instellingen voor reservekopieën. Een aantal van uw databases zijn niet teruggeplaatst omdat er geen geschikte MS SQL-server in Plesk is geregistreerd. Het gaat om de volgende domeinen: {{objects}}. Neem contact op met uw hostingprovider.',

    'bu_conflict_resolver_not_available_webmail' => 'De webmaildienst %1 is niet beschikbaar. Deze zal worden vervangen door %2 voor de volgende objecten: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'De webmaildienst %1 is niet beschikbaar. Deze zal worden vervangen door %2 voor de volgende dienstenpakketten: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Bij databases van het type '%1' mogen gebruikersnamen niet samenvallen met de naam van de database. De naam van gebruiker '%2' zal worden gewijzigd in '%3' voor database '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'In de configuratie van de server van bestemming is geen beperking ingesteld voor het gebruik van schijfruimte. De waarde van deze instelling zal worden gewijzigd naar "Onbeperkt".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'In de configuratie van de server van bestemming is geen beperking ingesteld voor het aantal verbindingen. De waarde van deze instelling zal worden gewijzigd naar "Onbeperkt".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'In de configuratie van de server van bestemming is geen beperking ingesteld voor het gebruikte dataverkeer. De waarde van deze instelling zal worden gewijzigd naar "Onbeperkt".',
    'cu__pleskrestore_backup_file_extracted' => 'De reservekopie is uitgepakt naar "%1".',
    '__mod_bw_not_supported' => 'De module mod_bw voor de Apache-webserver wordt niet ondersteund vanwege de configuratie van het bestandsysteem. De beperking van het gebruikte dataverkeer en van het maximaal aantal verbindingen zal niet functioneren.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'POP3-autorisatie voor het versturen van mail wordt niet ondersteund; in plaats daarvan wordt POP3 voor SMTP-autorisatie gebruikt.({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Dienstenpakket \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 niet wordt ondersteund. Deze zal worden vervangen door %2 voor de volgende dienstenpakketten: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 niet wordt ondersteund. Deze zal worden vervangen door %2 voor de volgende websites: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'De volgende objecten zijn niet gevonden in de reservekopie: %1',
    'bu_conflict_resolver_absent_domains' => 'Bepaalde objecten kunnen niet worden hersteld omdat deze horen bij de volgende domeinen die niet in Plesk zijn gevonden: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Bepaalde websites kunnen niet worden hersteld omdat ze horen bij de volgende bovenliggende domeinen die niet in Plesk zijn gevonden: \n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Kan de DNS-zones niet terugplaatsen: De DNS-dienst is uitgeschakeld in de server-instellingen.',
    'bu_conflict_resolver_mail_not_supported' => 'Kan geen postvakken terugplaatsen: De maildienst is uitgeschakeld in de server-instellingen.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'De opgegeven actie na een timeout bij inactiviteit wordt niet ondersteund door de IIS-webserver. De waarde zal worden teruggezet op %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'De opgegeven beperkingsactie voor het processorgebruik wordt niet ondersteund door de IIS-webserver. De waarde zal worden teruggezet op %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'server SSL/TLS-certificaat %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS-certificaat %2 van het domein %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS-certificaat %1',
    'bu_conflict_resolver_absent_objects' => 'De inhoud van de volgende objecten kan niet worden teruggeplaatst omdat de objecten niet in Plesk zijn aangetroffen: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'De inhoud van de volgende postvakken kan niet worden teruggeplaatst omdat de postvakken niet in Plesk zijn aangetroffen: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'De inhoud van de volgende verzendlijsten kan niet worden teruggeplaatst omdat de verzendlijsten niet in Plesk zijn aangetroffen: %1',
    'bu_conflict_resolver_absent_objects_database' => 'De inhoud van de volgende databases kan niet worden teruggeplaatst omdat de databases niet in Plesk zijn aangetroffen: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Het herstellen van de toepassing "%1" op "%2" is mislukt omdat er al een andere toepassing is geïnstalleerd op "%3". U kunt de geïnstalleerde toepassing verwijderen en het opnieuw proberen.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'De functie automatische beantwoording voor e-mail wordt niet ondersteund.',
    'bu_conflict_resolver_not_available_mail_content' => 'Het terugplaatsen van mailberichten wordt niet ondersteund.',
    'bu_conflict_resolver_invalid_mail_name' => 'De volgende postvakken zijn niet teruggeplaatst, omdat e-mail-subadressering is ingeschakeld en bepaalde e-mailadressen het teken "%1" bevatten: %2',
    'bu_conflict_resolver_invalid_user_name' => 'De volgende gebruikers zijn niet teruggeplaatst, omdat e-mail-subadressering is ingeschakeld en bepaalde e-mailadressen het teken "%1" bevatten: %2',
    'expiration_unsupported' => "De beperking \\'expiration\\' wordt niet ondersteund.",

    'component_name__dbconnector' => "Database connector",
    'component_name__mysqlserver' => 'MySQL Server',
    'component_name__troubleshooting' => 'Probleemoplossing',

    '__subscription_has_no_license_key' => 'De middelen van het abonnement worden geleverd door de servicenode #%1, die niet beschikt over een gekoppelde licentiesleutel.',
    '__subscription_has_expired_license_key' => 'De middelen van het abonnement worden geleverd door de servicenode #%1, waarvan de licentiesleutel %2 is verlopen.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Kan configuratiebestanden niet opslaan',
    '__cfgmonConfigurationFileSaveErrorBody' => "Kan bepaalde configuratiebestanden niet opslaan op host <%%host%%>: De volgende fouten zijn opgetreden:\n\n%%errors%%",

    'mail__allow_short_pop3_names' => "Namen voor POP3/IMAP-mailaccounts",
    'mail__allow_short_pop3_names_disabled' => "U kunt alleen de volledige namen van e-mailaccounts ( POP3 of IMAP) gebruiken",
    'mail__allow_short_pop3_names_enabled' => "U kunt korte namen (webmaster) en volledige namen (webmaster@domein.nl) van e-mailaccounts gebruiken (POP3 of  IMAP).",
    'mail__baddomain_exists' => "Dit domein staat al op de zwarte lijst.",
    'mail__block_mail_from_doms' => "Zwarte lijst",
    'mail__blockers' => "Geblokkeerde domeinen",
    'mail__blockers_remove' => "Geblokkeerde domeinen verwijderen",
    'mail__blocker_add' => "Domeinen aan de zwarte lijst toevoegen",
    'mail__closed' => "gesloten",
    'mail__crypted_passwd_match' => "Er zijn mailaccounts die overeenkomen met de versleutelde wachtwoorden.",
    'mail__enable_email_subaddressing' => 'E-mail-subadressering inschakelen',
    'mail__enable_email_subaddressing_hint' => 'Met deze optie kunt u %%verpStyleLink%% e-mailadressen instellen voor verzendlijsten',
    'mail__enable_email_subaddressing_cli_desc' => 'Met deze optie kunt u e-mailadressen in VERP-stijl instellen voor verzendlijsten',
    'mail__dom_in_list' => "Dit domein staat al op de zwarte lijst.",
    'mail__enable_rbl' => "Spambescherming op basis van DNS-blackholelijsten inschakelen",
    'mail__enter_rbl_server' => "Type in de DNS-zone.",
    'mail__enter_right_ip_mask' => "Geef het IP-masker op tussen 1 en 32",
    'mail__enter_right_ip_mask_24' => "Geef het IP-masker op tussen 24 en 32",
    'mail__install_rblsmtpd_program' => "De rblsmtp-software installeren.",
    'mail__invalid_dom_name' => "De domeinnaam %1 is ongeldig.",
    'mail__invalid_pop_lock_time' => "POP3-blokkeringsperiode is ongeldig.",
    'mail__invalid_rbl_server' => "De naam van de DNS-zone is ongeldig.",
    'mail__ip_and_mask' => "IP-adres/masker",
    'mail__ip_and_mask_exists' => "Deze combinatie van IP-adres en netmasker bestaat al.",
    'mail__lock_time' => "blokkeringsperiode",
    'mail__general_options' => 'Algemene opties',
    'mail__relay_options' => 'Relay-opties',
    'mail__mailnames_passwd_match' => "Er zijn overeenkomende combinaties van mailaccount en wachtwoord.",
    'mail__select_domains_for_remove' => "Selecteer de domeinen om te verwijderen.",
    'mail__max_size' => "Maximale berichtomvang",
    'mail__mbox_quota' => "Postvakbeperking",
    'mail__min' => "min",
    'mail__total_files_size' => "Totale opslaggrootte: %1",
    'mail__filename_already_in_repository' => "Er is al een bestand met deze naam in de opslag aanwezig",
    'mail__no_white_list_mask_feature_24' => "Gebruik een maskerwaarde van 24 of hoger.\nUw mailserver ondersteunt het instellen van maskers niet. We kunnen het instellen van het masker alleen emuleren voor waarden die niet lager zijn dan 24.",
    'mail__open' => "openen",
    'mail__open_relay_warning' => "Het openen van uw mail-relay maakt uw mailserver kwetsbaar voor spam.\n\nSla deze instelling alléén op als u de mailserver tijdelijk wilt testen, of wanneer uw Plesk-server zich in het interne netwerk bevindt en niet via internet toegankelijk is.\n\nWilt u de instelling behouden?",
    'mail__pop3' => "POP3 vóór SMTP",
    'mail__rbl_zones' => "DNS-zones voor DNSBL-dienst",
    'mail__rbl_zones_hint' => "U kunt ingangen scheiden met een puntkomma. Bijvoorbeeld: 'zen.spamhaus.org;dnsbl.example.net'",
    'mail__relay_from_ip' => "Witte lijst",
    'mail__relaying' => "Relay",
    'mail__reqr_auth' => "verificatie is vereist:",
    'mail__smtp' => "SMTP",
    'mail__unable_add_new_mail_name' => "Kan het e-mailaccount niet toevoegen: %1",
    'mail_server_is_not_installed' => 'De mailserver (Postfix of Qmail) is niet geïnstalleerd. Installeer deze om door te gaan met werken.',
    'mail_server_not_available' => 'Er zijn geen ondersteunde mailservers beschikbaar op de dienstnode.',
    '__not_installed' => '(niet geïnstalleerd)',
    'mail__server_name_label' => 'Geïnstalleerde mailserver',
    'mail__imap_server_name_label' => 'IMAP/POP3 server geïnstalleerd',
    'mail__server_change_hint' => 'U kunt %%serverChangeLink%%',
    'mail__server_change_link' => 'een andere mailserver installeren en gebruiken',
    'mail__imap_server_change_link' => 'een andere IMAP/POP3 server installeren en gebruiken',
    'mail__message_submission' => 'Schakel de SMTP-service in op poort 587',
    'mail__message_submission_on_all_ips' => 'SMTP op poort 587 inschakelen voor alle IP-adressen',
    'mail__message_submission_bind_to' => 'Aan',
    'mail__message_submission_all_ip_addresses' => 'alle IP-adressen',
    'mail__service_node_outgoing_messages_is_disabled' => 'Het spamfilter voor uitgaande e-mailberichten is uitgeschakeld.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Het beperken van het aantal uitgaande e-mailberichten vanaf een domein wordt niet ondersteund door de dienst-node voor het domein %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Het beperken van het aantal uitgaande e-mailberichten vanuit een postvak wordt niet ondersteund door de dienst-node voor het domein %1.',
    'mail__max_outgoing_messages_enable_text' => 'Beperkingen voor uitgaande e-mailberichten inschakelen',
    'mail__max_outgoing_messages_enable_hint' => 'De volgende beperkingen zijn standaard. Ze kunnen worden opgeheven in elk hostingpakket of abonnement. De beperkingen zijn niet van toepassing op de server als geheel, maar doen dienst als sjabloon voor de pakketten en abonnementen waarvoor geen aangepaste beperkingen zijn opgegeven. Merk op dat het inschakelen van de beperking van uitgaande e-mailberichten de prestaties van de mailserver kunnen beïnvloeden.',
    'mail__outgoing_messages_mbox_limit_text' => 'De standaardbeperking van uitgaande berichten vanuit een postvak (per uur)',
    'mail__outgoing_messages_domain_limit_text' => 'De standaardbeperking van uitgaande berichten vanaf een domein (per uur)',
    'mail__outgoing_messages_subscription_limit_text' => 'De standaardbeperking van uitgaande berichten vanuit een abonnement (per uur)',
    'mail__outgoing_messages_enable_sendmail_text' => 'Gebruikers en scripts toestaan om Sendmail te gebruiken',
    'mail__outgoing_messages_enable_sendmail_hint' => 'Scripts en gebruikers kunnen via Sendmail e-mailberichten versturen (namens de systeemgebruiker van het abonnement), zelfs als de beperkingen van een postvak of domein zijn overschreden. Het maximaal aantal berichten dat kan worden verstuurd via Sendmail zal worden bepaald door de beperking van het abonnement als geheel. Deze instelling staat niet toe dat scripts Sendmail gebruiken op de hele server, maar doet dienst als standaardinstelling voor hostingpakketten en abonnementen.',
    'mail__outgoing_messages_report_period_text' => 'Toont statistische verslagen voor de laatste',
    'mail__max_outgoing_messages_period_P1D' => '1 dag',
    'mail__max_outgoing_messages_period_P1W' => '1 week',
    'mail__max_outgoing_messages_period_P2W' => '2 weken',
    'mail__max_outgoing_messages_period_P1M' => '1 maand',
    'mail__outgoing_messages_report_period_hint' => 'De verslagen zijn aangemaakt en er wordt een waarschuwing getoond op de startpagina over de pogingen om in de opgegeven periode de beperkingen van de uitgaande mail te overschrijden.',
    'mail__outgoing_messages_notification_period_text' => 'Verstuur een melding per e-mail elke',
    'mail__max_outgoing_messages_period_PT15M' => '15 minuten',
    'mail__max_outgoing_messages_period_PT1H' => '1 uur',
    'mail__max_outgoing_messages_period_PT6H' => '6 uren',
    'mail__max_outgoing_messages_period_PT12H' => '12 uren',
    'mail__outgoing_messages_notification_period_hint' => 'De meldingen bieden statistieken over de pogingen om de beperkingen van uitgaande e-mail te overschrijden gedurende de opgegeven periode.',

    'mail__outgoing_email_mode_explicit_ip_none' => 'Geen',
    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Geef een adres op van ten minste één type (IPv4 of IPv6).',

    'mail__max_connections_text_courier' => 'Maximale aantal verbindingen (IMAP, POP3, IMAP via SSL/TLS of POP3 via SSL/TLS)',
    'mail__max_connections_text_dovecot' => 'Maximale aantal verbindingen (IMAP, POP3, IMAP via SSL/TLS of POP3 via SSL/TLS)',
    'mail__max_connections_hint_courier' => 'Het maximaal aantal servers (IMAP of POP3) dat kan worden gestart.',
    'mail__max_connections_hint_dovecot' => 'Het maximaal aantal mailgebruikers dat gelijktijdig kan zijn aangemeld.',

    'mail__max_connections_per_ip_text_courier' => 'Maximum aantal verbindingen per IP-adres',
    'mail__max_connections_per_ip_text_dovecot' => 'Maximaal aantal verbindingen voor een gebruiker per IP-adres',
    'mail__max_connections_per_ip_hint_courier' => 'Het maximale aantal verbindingen (IMAP, POP3, IMAP via SSL/TLS of POP3 via SSL/TLS) dat vanaf hetzelfde IP-adres kan worden geaccepteerd: %.',
    'mail__max_connections_per_ip_hint_dovecot' => 'Het maximale aantal verbindingen (IMAP, POP3, IMAP via SSL/TLS of POP3 via SSL/TLS) dat voor een mailgebruiker vanaf elk IP-adres kan worden geaccepteerd: %.',

    'mail__outgoing_email_mode' => 'Modus van uitgaande mail',
    'mail__outgoing_email_mode_domain_ip' => 'Versturen vanaf IP-adressen van het domein',
    'mail__outgoing_email_mode_domain_name' => 'Verstuur vanaf de IP-adressen van het domein en gebruik domeinnamen in de SMTP-begroeting',
    'mail__outgoing_email_mode_explicit_ip' => 'Verstuurd vanaf de opgegeven IP-adressen',
    'mail__outgoing_email_mode_explicit_ip_v4' => 'IPv4',
    'mail__outgoing_email_mode_explicit_ip_v6' => 'IPv6',
    'mail__outgoing_email_mode_invalid' => 'Er is een ongeldige modus voor uitgaande mail opgegeven.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Er is een ongeldig IPv4-adres opgegeven.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Er is een ongeldig IPv6-adres opgegeven.',
    'mail__outgoing_email_mode_unavailable' => 'De modus voor uitgaande mail kan niet worden gewijzigd, waarschijnlijk omdat de Postfix-mailserver niet op deze server is geïnstalleerd.',

    'mail__smtp_settings_change_hint' => 'Om Plesk in staat te stellen meldingen te verzenden wanneer er geen relay beschikbaar is, kunt u %%changeLink%%',
    'mail__smtp_settings_change_link' => 'de SMTP-instellingen wijzigen',

    'mail__autoresponder_attachment_not_supported' => 'De mailserver die momenteel wordt gebruikt ondersteunt niet het beheer van bijlagen in automatische beantwoordingen.',

    'sfdk_server_wide_legend' => 'Bescherming tegen spam met DKIM',
    'sfdk_server_wide_sign_text' => 'Ondertekenen van uitgaande mail toestaan',
    'sfdk_server_wide_verify_text' => 'Inkomende mail controleren',
    'sfdk_server_wide_verify_failed' => 'Het is niet mogelijk om de instellingen voor de DKIM-verificatiedienst te wijzigen',

    'sfdk_domain__serverwide_disabled' => 'Uitgeschakeld vanwege het serverbeleid',
    'feature__domainkeys__serverwide_disabled' => 'DKIM bescherming tegen spam voor de server als geheel is uitgeschakeld',

    'defaultcomponents__error_set_default' => 'Kan %1 niet instellen als standaard %2',
    'defaultcomponents__required_package_not_default' => 'Het component %1 dat is vereist is niet als standaard ingesteld.',

    '__percentage' => '%',
    '__seconds' => 'Seconden',
    '__resource_remain' => 'Resterend',

    '__not_registered' => '(niet geregistreerd)',
    '__php_handler_id' => 'PHP-versie',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'De PHP-handler "%1" is niet geregistreerd. Deze is waarschijnlijk van de server verwijderd. Registreer een handler met dezelfde eigenschappen en probeer het opnieuw.',
    '__php_handler_not_registered_on_domain' => 'Domein "%1": de PHP-handler "%2" is niet geregistreerd. Deze is waarschijnlijk van de server verwijderd. Registreer een handler met dezelfde eigenschappen en probeer het opnieuw.',
    '__php_fpm_handler' => 'FPM-toepassing',

    'mailname_create_assigned_user_dublicate_error' => 'Kan geen gebruiker voor het postvak aanmaken. De gebruiker met gebruikersnaam %1 bestaat al en heeft een ander postvak.',
    'mailname_create_assigned_user_role_absent_error' => 'Kan geen gebruiker voor het postvak aanmaken. De standaardrol %1 van de gebruiker bestaat niet.',

    'gphd__mime_types' => 'MIME-typen',
    'gphd__handlers' => 'Apache-handlers',
    'gphd__ip_restrictions_allow' => 'Toegang tot de site alleen toestaan voor opgegeven hosts en netwerken (exclusief hosts en netwerken die de toegang wordt geweigerd)',
    'gphd__ip_restrictions_deny' => 'De opgegeven hosts en netwerken toegang tot de site weigeren',
    'gphd__directory_index' => 'Index-bestanden',
    'gphd__nginx_transparent_mode' => 'De modus waarin Apache zowel statische als dynamische content verwerkt, terwijl nginx alleen HTTP-aanvragen en antwoorden doorgeeft zonder deze aan te passen.',
    'gphd__nginx_serve_static' => 'Statische bestanden rechtstreeks door nginx laten afleveren',
    'gphd__nginx_static_extensions' => 'Extensies van statische bestanden die door nginx moeten worden verwerkt',
    'gphd__nginx_serve_php' => 'PHP- bestanden verwerking door nginx',
    'gphd__www_root' => 'WWW Hoofdmap',

    'eol__none' => 'niet wijzigen',
    'eol__lf' => 'converteren naar Unix-stijl',
    'eol__cr' => 'converteren naar MacOS-stijl',
    'eol__crlf' => 'converteren naar Windows-stijl',

    'ui__dns_bad_zone' => 'Inconsistente zone "%1":',
    'ui__dns_ns_has_no_address_records' => 'Het NS-record "%1" bevat geen adres-records (A of AAAA).',
    '__dns_bad_zone' => 'Inconsistente zone "%1":',
    '__dns_ns_has_no_address_records' => 'Het NS-record "%1" bevat geen adres-records (A of AAAA).',
    '__dns_ptr_is_wildcard' => 'Het PTR-record "%1" is ongeldig: Het record verwijst naar een jokerdomein.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Externe toegang toestaan voor databasegebruiker \'%3\' van klant \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Kan geen externe verbindingen toestaan voor databasegebruiker \'%1\': Kan het TCP-poortnummer niet vaststellen dat wordt gebruikt door Microsoft SQL server \'%2\'. De mogelijke redenen hiervoor zijn de volgende: het TCP/IP-protocol is niet ingeschakeld in de netwerkinstellingen van de server of de server is insteld voor het gebruik van dynamische TCP-poorten. Stel de server in om te luisteren op een specifieke, vaste TCP-poort en probeer opnieuw om externe verbindingen toe te staan.',

    'command__convertResellerHasCustomer' => 'Dit reselleraccount \'%1\' beschikt over een of meer cliëntaccounts. Om dit reselleraccount om te zetten naar een cliëntaccount dient u deze cliëntaccounts eerst aan een nieuwe houder over te dragen of om te zetten naar reselleraccounts.',
    'command__convertResellerNotReseller' => 'Alleen reseller-accounts kunnen worden omgezet naar cliëntaccounts. \'%1\' is geen reseller.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Kan het abonnement niet met het hostingpakket synchroniseren. De volgende instellingen van het abonnement zijn ongeldig voor het hostingpakket: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Het account \'%1\' is een reselleraccount. Reselleraccounts kunnen niet worden overgedragen aan een nieuwe houder omdat zij direct onder de systeembeheerder vallen.',
    'moveCustomer__wrong_owner_type' => "Cliëntaccount '%1' kan alleen worden overgedragen aan een reseller of beheerder, niet aan een andere cliënt.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Cliëntaccount \'%1\' hoort al bij de geselecteerde houder.',
    'upgradeClient__user_is_admin' => 'Het account \'%1\' kan niet worden omgezet naar een reselleraccount, omdat het een beheerderaccount betreft.',

    'mail__error_setting_max_connections_courier' => 'Kan het maximale aantal verbindingen niet instellen (IMAP, POP3, IMAP via SSL/TLS of POP3 via SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Kan het maximale aantal verbindingen niet instellen (IMAP, POP3, IMAP via SSL/TLS of POP3 via SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Kan het maximale aantal verbindingen per IP-adres niet instellen (IMAP, POP3, IMAP via SSL/TLS of POP3 via SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Kan het maximale aantal verbindingen niet instellen (IMAP, POP3, IMAP via SSL/TLS of POP3 via SSL/TLS) per IP-adres voor een specifieke mailgebruiker: %1',
    'mail__error_no_localhost_for_maillists_in_server_white_list' => 'Om verzendlijsten te gebruiken moet de localhost (127.0.0.0/8, ::1/128) zijn toegevoegd aan de witte lijst van de mailserver. Als u echter de controle van uitgaande mail wilt gebruiken, dan mag localhost niet aan de witte lijst zijn toegevoegd. Een mogelijk alternatief voor wie controle van uitgaande mail wil gebruiken, is het doorsturen van e-mail vanaf een postvak in plaats van het gebruik van een verzendlijst.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv4' => 'Om verzendlijsten te gebruiken moet de localhost zijn toegevoegd aan de witte lijst van de mailserver. Als u echter de controle van uitgaande mail wilt gebruiken, dan mag localhost niet aan de witte lijst zijn toegevoegd. Een mogelijk alternatief voor wie controle van uitgaande mail wil gebruiken, is het doorsturen van e-mail vanaf een postvak in plaats van het gebruik van een verzendlijst. Merk op dat er geen IPv4 localhost-adressen (127.0.0.0/8) in de witte lijst meer staan, dus de controle van uitgaande mail werkt voor IPv4-adressen.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv6' => 'Om verzendlijsten te gebruiken moet de localhost zijn toegevoegd aan de witte lijst van de mailserver. Als u echter de controle van uitgaande mail wilt gebruiken, dan mag localhost niet aan de witte lijst zijn toegevoegd. Een mogelijk alternatief voor wie controle van uitgaande mail wil gebruiken, is het doorsturen van e-mail vanaf een postvak in plaats van het gebruik van een verzendlijst. Merk op dat er geen IPv6 localhost-adressen (::1/128) in de witte lijst meer staan, dus de controle van uitgaande mail werkt voor IPv6-adressen.',
    'mail__outgoing_messages_with_open_relay_error' => 'Voor een juiste beperking van het aantal uitgaande e-mailberichten sluit u de relay.',
    'outgoing_messages_limit_value_invalid' => 'De waarde moet liggen in het bereik %%MIN%%..%%MAX%%. Alleen de beheerder van Plesk kan deze instelling wijzigen.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "De volgende domeinen gebruiken externe e-mailadressen voor het doorsturen van mail naar niet-bestaande adressen. De berichten die naar deze adressen worden verstuurd tellen niet mee voor de Controle van uitgaande mail:\n %1",
    'outgoing_messages_white_list_not_empty' => 'De beperkingen voor uitgaande mail worden niet toegepast op mailverzenders waarvan het IP-adres is opgenomen op de witte lijst van de mailserver. Als bijvoorbeeld de localhost (127.0.0.0 / 8, ::1 / 128) is opgenomen in de witte lijst, dan zal alle mail vanaf de lokale server worden verstuurd, ongeacht de beperkingen. Mailverzenders kunnen ofwel een lokaal IP-adres gebruiken (websites en eigen scripts die op de lokale server worden gehost) of een extern adres (klanten die mail versturen vanuit e-mailprogramma\'s die op hun computer of op een mobiel apparaat zijn geïnstalleerd). Om ervoor te zorgen dat de beperkingen van toepassing zijn op alle verzenders van e-mail (lokaal en extern), verwijdert u alle IP-adressen en netwerken uit de witte lijst. Let er wel op als u localhost (127.0.0.0 / 8, ::1 / 128) uit de witte lijst verwijdert dit mogelijk problemen oplevert voor websites en scripts die mail vanaf deze server versturen. Meer informatie over het beperken van uitgaande mail vindt u de Handleiding voor beheerders, Bescherming tegen uitgaande spam.',
    'outgoing_messages_relay_open' => 'De mailrelay is geopend: beperkingen van de uitgaande mail zullen niet werken.',

    'spf_dsnignore' => 'SPF-controle zal worden uitgevoerd, ook als er problemen zijn met de DNS-lookup',
    'spf_dnsignore_hint' => 'Eerst voert SPF een DNS-lookup uit. Selecteer deze optie als u de controle wilt voortzetten als de DNS-lookup mislukt. Deze optie is niet geselecteerd als deze geen effect heeft op de huidige controlemodus.',
    'spf_behavior_hint' => 'Vervolgens past SPF lokale regels en gastregels toe. Het bericht zal worden geweigerd afhankelijk van de geselecteerde controlemodus en het resultaat van de controle.',

    'notification_aps_app_updates_available' => 'Updates voor de volgende toepassingen zijn beschikbaar:',
    'notification_aps_app_updates_installed' => 'Updates zijn automatisch geïnstalleerd voor de volgende toepassingen:',
    'notification_aps_app_updates_requirements' => 'Er zijn updates beschikbaar voor de volgende toepassingen, maar deze kunnen niet worden geïnstalleerd omdat de hostinginstellingen voor de bijbehorende websites niet voldoen aan de installatievereisten:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Geïnstalleerde versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" op %%parentName%% (%%url%%). Geïnstalleerde versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Thema "%%name%%" op %%parentName%% (%%url%%). Geïnstalleerde versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Geïnstalleerde versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" op %%parentName%% (%%url%%). Geïnstalleerde versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Thema "%%name%%" op %%parentName%% (%%url%%). Geïnstalleerde versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Uw versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" op %%parentName%% (%%url%%). Uw versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Thema "%%name%%" op %%parentName%% (%%url%%). Uw versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nieuwe versie: %%to%%. Vorige versie: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nieuwe versie: %%to%%. Vorige versie: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nieuwe versie: %%to%%. Vorige versie: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Geïnstalleerde versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Geïnstalleerde versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Uw versie: %%from%%. Beschikbare versie: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'externe toepassing',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domeinen',
    'notification_outgoing_mail_exceeded_limits_mails' => 'E-mailadressen',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abonnementen',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 berichten per uur',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Onbeperkt',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, de beperking is %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 poging(en) om de beperking te overschrijden tussen %2 en %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 poging(en) om de beperking te overschrijden tussen %2 en nu',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Blokkeren IP-adressen (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'De component Fail2ban is niet geïnstalleerd op de server van bestemming.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Installeer Fail2ban. Merk op dat dit enkele minuten in beslag kan nemen.',

    'plesk_key__no_reseller_support' => 'U kunt geen resellers beheren vanwege licentiebeperkingen.',
    'plesk_key__no_customers_support' => 'U kunt geen cliënten beheren vanwege licentiebeperkingen.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Kan niet overschakelen naar de Provider-weergave vanwege licentiebeperkingen.',
    'plesk_key__no_security_core_support' => 'De hoofdfuncties voor beveiliging (ModSecurity en Fail2Ban) zijn niet beschikbaar vanwege beperkingen van de licentie.',
    'plesk_key__outgoing-antispam' => 'Controle van uitgaande mail',
    'plesk_key__security-core' => 'Security Core (ModSecurity en Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Beheer van accounts',
    'plesk_key__can-manage-subscriptions' => 'Beheer van abonnementen',
    'plesk_key__can-manage-customers' => 'Cliëntbeheer',
    'plesk_key__can-manage-resellers' => 'Resellerbeheer',
    'plesk_key__can-manage-custom-view' => 'Beschikbaarheid beperkte modus',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Het beheer van abonnementen is uitgeschakeld maar u beschikt over meerdere abonnementen (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Het beheer van resellers is uitgeschakeld maar u beschikt over meerdere resellers (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Cliëntbeheer is uitgeschakeld terwijl u over meerdere cliënten beschikt (%1).',
    'plesk_key__no_subscriptions_support' => 'U kunt geen abonnement beheren vanwege licentiebeperkingen.',
    'plesk_key__no_custom_view_support' => 'U kunt vanwege licentiebeperkingen de Beperkte modus niet gebruiken.',
    'plesk_key__trial_forbidden_region' => 'Sorry, Plesk is momenteel niet beschikbaar in uw regio.',
    'additional_key__main_key' => 'De sleutel is een hoofdsleutel: U kunt geen hoofdsleutel als aanvullende sleutel uploaden.',

    'gch__hosting_waf_rule_engine' => 'Modus firewall voor webtoepassingen',

    'backup__fieldset__restoration_options' => 'Herstelopties',
    'backup__restore_options__restore' => 'Terugplaatsen',
    'backup__restore_options__domain__domain_configuration' => 'Domein-instellingen',
    'backup__restore_options__domain__virtual_host_content' => 'Bestanden van virtuele host',
    'backup__restore_options__domain__mail' => 'Mail',
    'backup__restore_options__domain__databases' => 'Databases',
    'backup__restore_options__client__client_configuration' => 'Instellingen cliëntaccount',
    'backup__restore_options__client__domains' => "Domeinen van cliënt",
    'backup__restore_options__reseller__reseller_configuration' => 'Instellingen reselleraccount',
    'backup__restore_options__reseller__personal_domains' => "Domeinen van de reseller",
    'backup__restore_options__reseller__clients' => "Cliënten van reseller",
    'backup__restore_options__admin__server_configuration' => 'Serverinstellingen',
    'backup__restore_options__admin__administrator_configuration' => 'Instellingen beheerderaccount',
    'backup__restore_options__admin__personal_domains' => "Domeinen van de beheerder",
    'backup__restore_options__admin__personal_clients' => "Cliënten van de beheerder",
    'backup__restore_options__admin__resellers' => 'Resellers',

    'badge_new' => 'Nieuw',
    'upgrade_php_on_subscription' => 'Upgrade PHP binnen uw abonnement naar versie 5.3.0 of later.',

    'pkey_notify__body_expiration_notification' => 'De licentiesleutel is verlopen. Sommige mogelijkheden zijn niet beschikbaar. Neem contact op met uw hostingprovider.',

    'crontab__crontab_entry_exists' => "De ingeroosterde taak bestaat al.",
    'crontab__crontab_entry_not_exists' => "De ingeroosterde taak bestaat niet.",
    'crontab__invalid_values_found' => "Onjuiste parameterwaarden.",
    'crontab__cmd_max_len' => "De opdracht kan niet langer zijn dan %1 tekens.",

    'domain__domain_exists' => "Er is een domein met het voorvoegsel 'www' en dezelfde naam: %1.%2.",
    'domain__subdomain_exists' => "Er is een subdomein met het voorvoegsel 'www' en dezelfde naam: %1.%2.",
    'domain__dalias_exists' => "Er is een domeinalias met het voorvoegsel 'www' en dezelfde naam: %1.%2.",
    'domain__record_exists' => "Er is een DNS-record dat verwijst naar de host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Certificaat '%1' kan niet als standaard worden ingesteld: de private sleutel ontbreekt.",
    'ip_addr__update_dns_error' => 'Er hebben zich problemen voorgedaan tijdens het bijwerken van het IP-adres in DNS-zones. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Kan het IP-adres niet toevoegen.Deze netwerkkaart krijgt automatisch IP-adressen toegewezen.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Kan IP-adres %1 niet verwijderen.Deze netwerkkaart krijgt automatisch IP-adressen toegewezen.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Kan IP-adres %1 niet herstellen.Deze netwerkkaart krijgt automatisch IP-adressen toegewezen.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Kan de netwerkkaart van IP-adres %1 niet wijzigen omdat netwerkkaart %2 automatisch IP-adressen verkrijgt.',

    'shm_lmsg__limit_for_resource_exceeded' => 'De beperking van het aantal %%type%% voor het abonnement is overschreden. De beperking is %%limit%% en er wordt momenteel %%usage%% gebruikt.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Het aanmaken van %%type%% is voor dit abonnement niet toegestaan.',
    'shm_lmsg__resource_title__db-mysql' => 'MySQL-databases',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL-databases',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL-databases',
    'shm_lmsg__resource_title__db-user' => 'databasegebruikers',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS Groepen van toepassingen',
    'shm_lmsg__resource_title__additional-ftp-account' => 'extra FTP-accounts',

    'db_user_unable_remove_mysql_global_privileges' => 'Kan de algemene MySQL-rechten van databasegebruiker %1 niet verwijderen. Reden: %2',
    'report__client_description' => 'Omschrijving',

    'db__user_role_error' => 'Er is een onjuiste rol opgegeven voor de databasegebruiker: %1. Selecteer een van de volgende rollen: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Kan de omvangbeperking instellen voor het bestand van de volgende Microsoft SQL Server-databases, omdat hun bestand al groter is: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Kan de omvangbeperking instellen voor het logbestand van de volgende Microsoft SQL Server-databases, omdat hun logbestand al groter is: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Kan geen publiek IP-adres instellen: er moet een privaat IP-adres bestaan.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Kan geen publiek IPv4-adres instellen voor het IPv6-adres.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Kan geen publiek IPv6-adres instellen voor het IPv4-adres.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Kan geen openbaar IP-adres instellen: ongeldig IP-adres.',

    '__user_already_exists' => "Het gebruiker %1 bestaat al.",
    '__user_name_is_empty' => "Geef een gebruikersnaam op.",

    'upgrade_php_on_domain' => 'Kan PHP-versie 5.3.0 of later op geen van uw WordPress-domeinen vinden. Probeer een upgrade van PHP uit te voeren.',

    'component_name__waf' => 'Firewall voor webtoepassingen',
    'component_name__vcs' => 'Versiecontrolesysteem',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Er is een mogelijke poging tot misleiding (spoofing) gedetecteerd: de link probeerde om irrelevante informatie te laten zien.',

    'php_handlers_error_no_available_instance' => 'Kan geen domein aanmaken: er zijn geen PHP-handlers beschikbaar.',
    'domain_error_unable_to_apply_hosting_settings' => 'Kan hostinginstellingen niet toepassen: %1',

    'plesk_not_configured' => 'Plesk is niet geconfigureerd. Ga naar Hostingbeheer voor het uitvoeren van de post-installatieconfiguratie.',
    'cmd_mail__mail_password_duplicated' => 'De opgegeven combinatie van e-mailadres en wachtwoord bestaat al op de mailserver. Geef een ander e-mailadres of wachtwoord op.',

    'extensionRequirementOs' => 'Het besturingssysteem (%1) wordt niet ondersteund door het installatiepakket.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 is de eerste versie van Plesk die door het installatiepakket wordt ondersteund.',
    'extensionRequirementPleskMaxVersion' => 'Versies van Plesk vanaf %1 worden niet ondersteund door het installatiepakket.',
    'extensionBlacklisted' => 'Het installeren van de uitbreiding %1 is niet toegestaan.',
    'extensionDisabled' => 'De uitbreiding is uitgeschakeld.',


    'optimization_settings__unable_set_mpm_event' => 'Kan de modus mpm_event niet instellen: hiervoor is vereist dat de Apache PHP5-module is uitgeschakeld, maar die module wordt momenteel gebruikt door een of meer domeinen.',
    'optimization_settings__unable_turn_off_php' => 'Kan de Apache PHP5-module niet uitschakelen: deze wordt gebruikt door een of meer domeinen.',

    'hst_def__fp_admin_login' =>  'FTP-gebruikersnaam',
    'hst_def__fp_admin_passwd' =>  'FTP-wachtwoord',

    'database_user_orphaned_old_password_wrong' => "Kan ontkoppelde gebruiker '%1' niet herstellen: het wachtwoord is onjuist.",
    'cannot_load_partner_central_property_key_no_exist' => "Kan aangepaste eigenschappen niet ophalen: de licentiesleutel bestaat niet.",
    'extensionScriptFailure' => "De uitvoering van %1 is mislukt, met het volgende bericht:\n%3",
    '__ssl_redirect' => "Permanente SEO-vriendelijke 301-redirect van HTTP naar HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Beheer van DKIM wordt niet ondersteund.',
    'mail__dmarc_not_supported' => 'Beheer van DMARC wordt niet ondersteund.',
    'mail__relay_white_list_not_supported' => 'Het overdragen van het beheer van witte lijsten wordt niet ondersteund.',
    'mail__black_list_not_supported' => 'Beheer van zwarte lijsten wordt niet ondersteund.',
    'mail__autoresponder_not_supported' => 'Beheer van automatische beantwoordingen wordt niet ondersteund.',
    'defaultcomponents__not_supported_version' => '(niet-ondersteunde versie)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Het certificaat \'%1\' is gevonden.',
    'certificate__unable_setup_certificate' => 'Kan het certificaat niet installeren: de private sleutel en de inhoud van het certificaat ontbreken.',
    'certificate__used_by_panel' => 'Een van de certificaten die u gaat verwijderen wordt gebruikt voor het beveiligen van Plesk.',
    'certificate__used_by_mail_server' => 'Een van de certificaten die u gaat verwijderen wordt gebruikt voor het beveiligen van de mailserver.',
    'certificate__used_by_domain_service' => 'Een van de certificaten die u gaat verwijderen wordt gebruikt door de domeindienst.',
    'mail_server__not_installed' => 'Kan geen certificaat voor de mailserver installeren omdat de mailserver niet is geïnstalleerd.',

    'email_activation_mail_subject' => 'Activeer uw account in Plesk',
    'email_activation_mail_body' => "Er is een account aangemaakt op Plesk-server %1\n\nAccountdetails:\nNaam: %2\nE-mailadres: %3\n\nAls deze informatie juist is en het account is aangemaakt voor u, dan kunt u deze met de volgende link activeren:\n\n%4\n\nDoor het account te activeren, geeft u de serverhouder toestemming om uw persoonlijke gegevens (naam en e-mailadres) te verzamelen, op te slaan, te verwerken en te gebruiken voor het maken en ondersteunen van uw account, in overeenstemming met de wetten voor gegevensbescherming die momenteel van kracht zijn, als onderdeel van een contract.",

    'backup_transport_permission_name' => '%1-beheer',
    'backup_transport_permission_description' => 'Staat het gebruik van %1 toe voor het opslaan van reservekopieën.',

    'domain_move_err_target_no_hosting' => 'Kan het domein niet naar een abonnement zonder hosting verplaatsen.',
    'domain_move_err_already_in_target' => 'Het domein hoort al bij het abonnement van bestemming.',
    'domain_move_err_main_domain' => 'Het hoofddomein kan niet worden verplaatst.',
    'domain_move_err_subdomain_without_parent' => 'Kan het subdomein %1 niet verplaatsen zonder het bovenliggende domein %2.',
    'domain_move_err_root_exists' => 'Het zoekpad van bestemming voor www_root %1 bestaat al.',
    'domain_move_err_nested_roots' => 'Het domein kan niet worden verplaatst omdat de hoofdmap wordt gedeeld met een ander domein: %1.',
    'domain_move_err_no_mail_service' => 'Het domein kan niet worden verplaatst omdat de e-maildienst voor het abonnement van bestemming is uitgeschakeld.',
    'domain_move_err_app' => "De toepassing die op %1 is geïnstalleerd is niet verplaatst naar abonnement '%2': %3",
    'domain_move_database_used_by_app' => "De database '%1' op %2 wordt gebruikt door de verplaatste applicatie. Om de database opnieuw aan '%3' toe te wijzen, voert u de opdracht `plesk bin database --assign-to-subscription` uit",
    'domain_move_target_locked' => "Het abonnement van bestemming '%1' is vergrendeld en kan niet worden gesynchroniseerd.",
    'domain_move_filesharing_disabled' => 'Bestandsdeling is uitgeschakeld.',
    'domain_move_website_preview_disabled' => 'Voorbeeld van website is uitgeschakeld.',
    'domain_move_additional_webserver_settings' => "Bekijk de aanvullende richtlijnen voor de webserver van het domein om een beschadigde configuratie te voorkomen.",
    'domain_move_no_permission' => "%1 is niet toegestaan voor abonnement '%2'.",
    'domain_move_no_access' => "Geen toegang tot abonnement '%1'.",
    'domain_split_no_create_permission' => "Het aanmaken van domeinen is niet toegestaan.",
    'domain_split_empty_login' => 'De aanmeldgegevens van de systeemgebruiker zijn vereist.',
    'domain_split_empty_password' => 'Het wachtwoord van de systeemgebruiker is vereist.',
    'domain_split_err_home_exists' => 'Het domein %1 kan niet worden verplaatst omdat het zoekpad voor de nieuwe hoofdmap al bestaat in %2. Wijzig de naam van het domein om het naar een nieuw abonnement te verplaatsen.',
    'domain_split_err_no_hosting_subdomains' => 'Het domein kan niet worden verplaatst naar een nieuw abonnement, omdat het domein niet beschikt over hosting, alleen over subdomeinen. Als u het domein wilt verplaatsen, wijzigt dan de waarde \'Type hosting\' naar \'Websitehosting\' (onder Hostinginstellingen).',
    'domain_split_target_locked' => "Het abonnement van bestemming '%1' is vergrendeld en kan niet worden gesynchroniseerd.",
    'domain_split_target_unsynced' => "Het abonnement van bestemming '%1' is niet gesynchroniseerd met het hostingpakket vanwege: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Ingeroosterde reservekopie is gedeactiveerd op '%1'.",
    'domain_merge_database_error' => "De database '%1' op %2 is niet naar het abonnement '%3' verhuisd: %4",
    'domain_merge_anon_ftp_deactivated' => "Anonieme FTP op '\\%1' is uitgeschakeld.",
    'domain_merge_smb_user_access' => "De aanvullende gebruiker '%1' is verplaatst naar het  abonnement '%2' maar de toegang van de gebruiker tot het abonnement is ingetrokken.",
    'domain_merge_scheduled_tasks' => "Ingeroosterde taken zijn verplaatst naar het abonnement van bestemming. Controleer de taak-instellingen.",
    'domain_merge_scheduled_tasks_deactivated' => "Ingeroosterde taken zijn verplaatst naar het abonnement van bestemming en uitgeschakeld. Controleer de taak-instellingen.",
    'domain_merge_no_remove_permission' => "Het verwijderen van abonnementen is niet toegestaan.",
    'domain_merge_err_has_addons' => 'Kan het hoofddomein met de aanvullende domeinen niet verplaatsen; verplaats eerst de domeinen %1.',
    'domain_merge_err_has_webusers' => 'Kan het hoofddomein met webgebruikers niet verplaatsen.',
    'domain_merge_err_root_exists' => 'Het zoekpad van bestemming %1 bestaat al.',

    'database_server_edit_used_for_psa' => 'Het is niet toegestaan de lokale MySQL-databaseserver bij te werken.',
    'suggest_repair_main_suggestion_ui' => '<b>U kunt deze fout oplossen</b> met het hulpprogramma `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'U kunt deze fout oplossen met het hulpprogramma `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'ga naar Diagnose & reparatie',
    'suggest_repair_using_cli_and_ui' => 'Om dit te doen, voert u de opdracht `plesk repair %1` uit via de CLI of %2 en u klikt op Herstellen naast “Plesk-database ”',
    'suggest_repair_using_cli' => 'Om dit te doen, geeft u via de CLI de opdracht `plesk repair %1` op',
    'verp_style_link' => 'VERP-stijl',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'De DNS-dienst was niet beschikbaar toen de reservekopie is gemaakt. Er zijn echter actieve DNS-zones in de reservekopie opgenomen en deze worden ingeschakeld voor de volgende objecten: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Resource-controller (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Ondersteuning voor externe SmarterMail',
    'plesk_key__complete-backup-solution' => 'Reservekopieën met Cloud Pro',
    'defaultcomponents__no_license' => '(niet toegestaan door licentiesleutel)',
    'plesk_key__validation_failed' => '%1 (Foutcode: %2)',
    'promo__button_details' => 'Details',
    'promo__extension_catalog_title' => 'Extensiecatalogus',
    'promo__extension_catalog_description' => 'Neem een kijkje in de nieuwe extensiecatalogus en geef Plesk een boost met een ruime keus aan krachtige extensies!',
    'promo__button_open_catalog' => 'De Catalogus openen',

    'backup__repository_check_login' => "Geen toegang tot de opslag: %1\nZorg ervoor dat u de juiste aanmeldgegevens voor de opslag hebt ingevoerd.",
    'backup__repository_check_error_list' => "Geen toegang tot de opslag: %1\nZorg ervoor dat u de juiste instellingen voor de opslag hebt ingevoerd.",
    'backup__repository_check_error_mkdir' => "Kan de map niet aanmaken: %1\nControleer of u beschikt over het recht om mappen aan te maken binnen de opslag.",
    'backup__repository_check_error_upload' => "Kan het bestand niet naar de opslag uploaden: %1\nControleer of u beschikt over het recht om bestanden naar de opslag te uploaden.",
    'backup__repository_check_error_download' => "Kan het bestand niet vanuit de opslag downloaden: %1\nControleer of beschikt over het recht om bestanden van en naar de opslag te up- of downloaden.",
    'backup__repository_check_error_resume-upload' => "Kan het uploaden van het bestand naar de opslag niet hervatten: %1\nControleer of u beschikt over het recht om uploads naar de opslag te hervatten.",
    'backup__repository_check_error_resume-download' => "Kan een download van het bestand vanuit de opslag niet hervatten: %1\nControleer of u beschikt over het recht om downloads uit de opslag te hervatten.",
    'backup__repository_check_error_enable-utf8' => "Kan de opslag niet bewerken: %1\nControleer of de opslag de codering UTF8 ondersteunt.",
    'backup__repository_check_error_rm' => "Kan de opslag niet bewerken: %1\nControleer of u beschikt over het recht om bestanden uit de opslag te verwijderen.",
    'backup__repository_check_error_rmdir' => "Kan de opslag niet bewerken: %1\nControleer of u beschikt over het recht om mappen uit de opslag te verwijderen.",

    'backup__ftp_repository_check_login' => "%1 U kunt deze onafhankelijk controleren met de volgende opdracht:\n  %2",
    'backup__ftp_repository_check_error_list' => "%1 U kunt deze onafhankelijk controleren met de volgende opdracht:\n  %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 U kunt het onafhankelijk controleren met de volgende opdracht:\n  %2",
    'backup__ftp_repository_check_error_upload' => "%1 U kunt het onafhankelijk controleren met de volgende opdrachten:\n  %2\n  %3",
    'backup__ftp_repository_check_error_download' => "%1 U kunt het onafhankelijk controleren met de volgende opdrachten:\n  %2\n  %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 U kunt het onafhankelijk controleren met de volgende opdrachten:\n  %2\n  %3\n  %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 U kunt het onafhankelijk controleren met de volgende opdrachten:\n  %2\n  %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 U kunt het onafhankelijk controleren met de volgende opdracht:\n  %2",
    'backup__ftp_repository_check_error_rm' => "%1 U kunt het onafhankelijk controleren met de volgende opdrachten:\n  %2\n  %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 U kunt het onafhankelijk controleren met de volgende opdrachten:\n  %2\n  %3",

    'link_to_extension_developer_guide' => 'Hoe kan ik zelf een uitbreiding ontwikkelen?',

    'sfdmarc_server_wide_legend' => 'DMARC',
    'sfdmarc_server_wide_enable_dmarc' => 'DMARC inschakelen voor het controleren van inkomende e-mail',
    'sfdmarc_server_wide_enable_failed' => 'Kan instellingen voor DMARC niet wijzigen. Om deze optie te activeren moet u bescherming tegen spam via DKIM en SPF inschakelen.',
    'sfdmarc_server_wide_enable_hint' => 'Deze optie is beschikbaar wanneer  DKIM en SPF voor inkomende e-mail zijn ingeschakeld.',
    'spf_server_wide_enable_hint' => 'Deze optie kan niet worden uitgeschakeld terwijl DMARC voor inkomende mail is ingeschakeld.',
    'spf_server_wide_disable_failed' => 'Kan de  instellingen voor beveiliging tegen spam via SPF niet wijzigen. Om SPF uit te schakelen moet u DMARC voor inkomende e-mail uitzetten.',
    'sfdk_server_wide_enable_hint' => 'Deze optie kan niet worden uitgeschakeld terwijl DMARC voor inkomende mail is ingeschakeld.',
    'sfdk_server_wide_verify_disable_failed' => 'Kan instellingen voor de DKIM-beveiliging tegen spam niet wijzigen. Om DKIM uit te schakelen moet u DMARC voor inkomende e-mail uitzetten.',

    'ccs_not_supported' => 'De IIS Central Certificate Store is niet op het systeem ingesteld.',
    'ccs_not_enabled' => 'Het beheer van de IIS Central Certificate Store is niet ingeschakeld in Plesk.',
    'ad_not_supported' => 'De server is niet aan een domein gekoppeld.',

    'component_name__appinit' => "Initialisatie van de applicatie",
    'component_name__httpcompression' => 'HTTP-inhoudscompressie',
    'common_feature_is_not_supported' => 'Deze functie wordt niet langer ondersteund.',
    'common_feature_is_not_supported_in_proto' => 'Deze functie wordt niet ondersteund voor protocolversie %1.',
    'autoinstaller__plesk_component' => 'Plesk-component',
    'plesk_key__key_expired' => 'Uw licentiesleutel is verlopen. Om Plesk te kunnen blijven gebruiken moet u een commerciële %1 aanschaffen die niet verloopt.',
    'plesk_key__key_purchase' => 'licentiesleutel',

    'sa_action_move' => 'Verplaats spam naar de map "Junk E-mail"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java-applicaties worden niet langer ondersteund. Deze zullen niet beschikbaar voor de volgende websites: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Mobiele versies van websites die worden gehost via UNITY Mobile worden niet langer ondersteund. Deze zullen niet beschikbaar voor de volgende websites: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Het beleid van de server als geheel staat geen persoonlijke antivirusinstellingen toe. Deze worden teruggeplaatst, maar niet volledig, voor e-mailaccounts onder de volgende domeinen: {{objects}}',

    'server_preferences__ip_logging' => 'IP-logboekregistratie',
    'server_preferences__disable_ip_logging' => 'IP-registratie in de IIS-, FTP- en e-maillogboeken uitschakelen',
    'server_preferences__disable_ip_logging_description' => 'Als deze optie is geselecteerd zullen IIS en MailEnable geen IP-adressen meer in logbestanden opslaan',

    'module__not_installed' => "De uitbreiding %1 is niet geïnstalleerd",

    'mail__mailbox_quota_warning_text' => 'Waarschuwing voor postvakbeperking inschakelen',
    'mail__mailbox_quota_warning_hint' => 'Verstuur een melding naar e-mailgebruikers wanneer zij de beperking van hun postvak voor meer dan 95% hebben overschreden.',
    'mail__mailbox_quota_warning_customization_text' => 'De standaardwaarschuwing voor de postvakbeperking aanpassen',
    'mail__mailbox_fix-incorrectly-set-sender-text' => 'Verbeter verkeerd ingestelde afzender voor uitgaande e-mail',
    'mail__mailbox_fix-incorrectly-set-sender-hint' => 'Stel automatisch geldige e-mailheaders en een envelopadres in voor de afzender van uitgaande e-mail van domeinen om de kans te verkleinen als spam te worden gezien',
    'mail__mail_autodiscovery' => 'Autodiscover voor mail',
    'mail__mail_autodiscovery_description_text' => 'Bekijk hoe het werkt in de %%link%%',
    'mail__mail_autodiscovery_description_text_link' => 'kennisbank',
    'mail__mail_autodiscovery_text' => 'Autodiscover voor e-mail inschakelen',
    'mail__mail_autodiscovery_hint' => 'Wanneer u deze functie inschakelt worden alle domeinen waarvoor autodiscover is ingeschakeld opnieuw ingesteld',
    'mail__mail_autodiscovery_server_text' => 'Een aangepaste domeinnaam voor e-mail autodiscover opgeven',
    'mail__mail_autodiscovery_server_hint' => 'Opmerking: De domeinnaam moet zijn beveiligd met een geldig SSL/TLS-certificaat.',
    'mail__mail_autodiscovery_server_error' => 'Een aangepaste domeinnaam voor e-mail autodiscover opgeven',
    'mail__mail_autodiscovery_reconfigure_dns_text' => 'De DNS-records voor autodiscover opnieuw instellen',
    'mail__mail_autodiscovery_reconfigure_dns_hint' => 'Wanneer u deze functie inschakelt worden alle autodiscover DNS-records opnieuw ingesteld voor alle domeinen waarvoor autodiscover is ingeschakeld',
    'mail__error_mail_autodiscovery_enable' => 'Kan de autodiscover voor e-mail niet instellen: %1',
    'mail__error_mail_autodiscovery_server' => 'Kan geen aangepaste domeinnaam instellen voor e-mail autodiscover: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Kan de DNS-records voor autodiscover voor domeinen niet opnieuw instellen: %1',

    '__invalid_url' => 'URL "%1" is ongeldig',
    'actionlog__cloning_start' => 'starten',
    'actionlog__event_cloning_start' => 'Starten met klonen van server',

        '__show_hide_title' => 'Minimaliseren/herstellen',
    '__show_hide_navigation_pane' => 'Navigatiepaneel tonen/verbergen',
    '__UPLOAD_ERR_FORM_SIZE' => "Geüpload bestand overschrijdt de toegestane grootte",
    '__UPLOAD_ERR_INI_SIZE' => "Geüpload bestand overschrijdt de toegestane grootte",
    '__UPLOAD_ERR_NO_FILE' => "Geen bestand ontvangen",
    '__UPLOAD_ERR_OK' => "Uploaden van bestand is geslaagd",
    '__UPLOAD_ERR_PARTIAL' => "Bestand gedeeltelijk ontvangen, probeer opnieuw",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Tijdelijke map ontbreekt',
    '__UPLOAD_ERR_CANT_WRITE' => 'Schrijven naar schijf is mislukt',
    '__UPLOAD_ERR_UNKNOWN' => 'Er is een onbekende fout opgetreden bij het uploaden van een bestand',
    '__accounts' => "Accounts",
    '__access' => "Toegang",
    '__address' => "Adres",
    '__addresses' => "Adressen",
    '__acl_records' => 'ACL-records',
    '__admin_repository' => "Opslag van beheerder",
    '__all' => 'Alle',
    '__allowed' => "Toegestaan",
    '__anonftp_status' => "Anonieme FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 webserver wordt opnieuw opgestart, een ogenblik geduld...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET-ondersteuning",
    '__asp_win_support' => "Microsoft ASP-ondersteuning",
    '__attachments' => "Bijlagen",
    '__attachments_list' => "Bijlagen",
    '__author' => 'Auteur',
    '__autoresp_name_already_exists' => "Automatische beantwoording met naam %1 bestaat al.",
    '__autoresponder' => "Automatische beantwoording",
    '__autoresponders' => "Automatische beantwoordingen",
    '__autoresponders_list' => "Automatische beantwoordingen",
    '__autoresponder_attachment_files' => "Bijlagen voor automatische beantwoording",
    '__auto_updates_list' => 'Beschikbare updates',
    '__avail' => "Beschikbaar",
    '__backup_utilites' => "Hulpprogramma's voor reservekopieën",
    '__bind_status' => "Status DNS-server",
    '__bu_is_not_installed' => "Deze dienst is momenteel niet beschikbaar, omdat de hulpprogramma's voor reservekopieën niet zijn geïnstalleerd.",
    '__bu_not_support_in_key' => "De mogelijkheid tot het maken van een reservekopie wordt niet ondersteund door de licentiesleutel.",
    '__notifications_not_support_in_key' => 'Meldingen worden niet ondersteund door de licentiesleutel',
    'disabled_by_key' => 'Niet ondersteund door de licentiesleutel',
    '__bytes' => "bytes",
    '__can_not_use_reserved_words' => "U kunt de gereserveerde woorden niet gebruiken.",
    '__certificate' => "Certificaat",
    '__cgi_support' => "CGI-ondersteuning",
    '__change_date' => "Datum van wijziging",
    '__choose_logo' => "Logobestand",
    '__city' => "Plaats",
    '__cl_not_exist' => "Cliëntaccount bestaat niet.",
    '__client' => 'Cliënt',
    '__client_card' => "Cliëntkaart",
    '__client_contact_name' => "Contactnaam cliënt",
    '__client_form' => "Persoonlijke gegevens",
    '__client_ip_pool' => "IP-voorziening van cliënt",
    '__client_limits' => "Beperkingen van cliëntaccount",
    '__client_permissions' => "Rechten van cliënt",
    '__client_preferences' => "Voorkeuren van cliënt",
    '__client_status' => "Cliëntstatus",
    '__client_name' => "Naam van cliënt",
    '__client_total' => "Cliënttotaal",
    '__client_with_login_name_already_exists' => "Er bestaat al een gebruiker met gebruikersnaam \"%1\".",
    '__client_domuser_with_login_already_exists' => "De gebruikersnaam '%1' wordt al gebruikt door de beheerder van het domein '%1'.",
    '__clients_global_changes' => "Geselecteerde cliëntaccounts aanpassen",
    '__clients_list' => "Cliënten",
    '__cmd_not_found' => "Onbekende opdracht: %1",
    '__comments' => "Opmerkingen",
    '__company_name' => "Bedrijfsnaam",
    '__component_version' => "Componentversie",
    '__allow_zone_transfer_list' => 'Algemene ACL voor toestaan van zoneoverdracht',
    '__component_not_installed' => "Het component %1 is niet geïnstalleerd",
    '__confirm_del' => "U moet het verwijderen bevestigen.",
    '__confirm_overwrite' => "Overschrijven bevestigen.",
    '__confirm_stop' => "U moet het beëindigen van het proces bevestigen.",
    '__confirm_passwd' => "Wachtwoord %1 bevestigen",
    '__confirm_removal' => "Verwijdering bevestigen",
    '__conhelp' => "Omschrijving",
    '__contact_name' => "Contactnaam",
    '__country' => "Land",
    '__countries' => 'Land',
    '__country_unknown' => 'De subcode van het land wordt niet herkend.',
    '__courier-imap' => 'Courier-server',
    '__create_domain' => 'Een domein aanmaken',
    '__crypted' => 'versleuteld',
    '__cp_access' => "Toegang tot Plesk",
    '__cp_user' => "Plesk-gebruiker",
    '__create' => "Aanmaken",
    '__create_client_template_without_template' => "Gebruikeraccount aanmaken zonder sjabloon",
    '__create_domain_for' => "Een domein aanmaken voor <b />%1</b>",
    '__create_domain_template_without_template' => "Domein aanmaken zonder sjabloon",
    '__creation_date' => "Datum van aanmaken",
    '__crontab_unix' => "Takenrooster",
    '__crontab_win' => "Takenrooster",
    '__ct_month_jan' => 'Januari',
    '__ct_month_feb' => 'Februari',
    '__ct_month_mar' => 'Maart',
    '__ct_month_apr' => 'April',
    '__ct_month_may' => 'Mei',
    '__ct_month_jun' => 'Juni',
    '__ct_month_jul' => 'Juli',
    '__ct_month_aug' => 'Augustus',
    '__ct_month_sep' => 'September',
    '__ct_month_oct' => 'Oktober',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'December',
    '__custom_button' => "Eigen knop",
    '__custom_buttons_list' => "Links naar aanvullende diensten",
    '__daily' => "Dagelijks",
    '__database_not_activated' => "%1 is niet geactiveerd vanaf de beheerpagina van de server.",
    '__database_not_installed' => "Database %1 is niet geïnstalleerd.",
    '__database_not_run' => "Database %1 is niet gestart.",
    '__database_is_corrupt' => "De database van Plesk is beschadigd. Gebruik het hulpprogramma Reconfigurator om deze te herstellen.",
    '__databases' => "Databases",
    '__databases_list' => "Databases",
    '__database_type_not_supported_by_key' => 'Om %1 server te gebruiken hebt u daarvoor ondersteuning nodig in uw licentiesleutel. Neem contact op met uw contactpersoon bij Plesk.',
    '__date_immediately' => "vandaag",
    '__date_never' => "nooit",
    '__day(s)' => "Dag(en)",
    '__day0' => "Zon",
    '__day1' => "Ma",
    '__day2' => "Din",
    '__day3' => "Woe",
    '__day4' => "Don",
    '__day5' => "Vrij",
    '__day6' => "Za",
    '__days' => "%1 dag(en)",
    '__db_admin_login_empty' => "U hebt een lege gebruikersnaam opgegeven, waarmee u controle over %1 in het scherm uitschakelt. Wilt u doorgaan?",
    '__db_unable_to_unregister' => 'Kan parameters van databaseverbinding niet verwijderen',
    '__db_db_exists' => 'Er bevindt zich ten minste één database op de server',
    '__db_unable_to_change_server_name' => 'Naam voor de server kan niet worden gewijzigd',
    '__db_unable_to_change_port' => 'De poort voor de server kan niet worden gewijzigd',
    '__db_already_exist' => "Database %1 bestaat al.",
    '__db_credentials_invalid' => "Aanmeldgegevens voor database zijn niet geldig.",
    '__db_invalid_password_characters' => 'Het wachtwoord bevat ongeldige karakters',
    '__db_engine' => "Database-engine", // indirect
    '__db_type' => "Type database",
    '__db_user' => "Databasegebruiker",
    '__db_server' => 'Database-server',
    '__def_domain' => "Standaarddomein",
    '__default_for_mysql' => 'standaard voor MySQL',
    '__default_for_mariadb' => 'standaard voor MariaDB',
    '__default_for_percona' => 'standaard voor Percona',
    '__default_for_postgresql' => 'standaard voor PostgreSQL',
    '__delete' => "Verwijderen",
    '__demo' => "Deze functie is niet beschikbaar in de demonstratieversie.",
    '__directory' => "Map",
    '__disable_lock_screen' => 'Gebruikers kunnen niet met Plesk werken totdat het scherm volledig is geladen',
    '__dismiss_news?' => "Weet u zeker dat het nieuwsblok volledig wilt afsluiten? \n\nU zult het nieuwsblok niet meer kunnen zien totdat er meer nieuws beschikbaar is.",
    '__description' => "Omschrijving",
    '__disabled' => "uitgeschakeld",
    '__disk_space_limit' => "Schijfruimtebeperking",
    '__cgroups_cpu_usage_limit' => 'Beperking processorgebruik',
    '__cgroups_ram_usage_limit' => 'Beperking gebeugengebruik',
    '__cgroups_disk_read_usage_limit' => 'Bandbreedtebeperking voor lezen van harde schijf',
    '__cgroups_disk_write_usage_limit' => 'Bandbreedtebeperking voor schrijven naar harde schijf',
    '__disk_usage_by' => "Schijfruimte gebruikt door %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Er bestaat al een DNS-record '%1'.",
    '__dns_master_should_be_remote' => "U moet twee verschillende authoratieve naamservers hebben op afzonderlijke hosts.",
    '__dns_record_not_exist' => "DNS-record bestaat niet.",
    '__dns_server' => "DNS-server", // indirect
    '__dom_id_is_undefined' => "Domeinkenmerk is niet ingesteld.",
    '__dom_name' => "Domeinnaam",
    '__dom_name_is_invalid' => "Domeinnaam is ongeldig. Zorg ervoor dat uw domeinnaam enkel bestaat uit alfanumerieke tekens, punten en verbindingsstreepjes en dat deze niet langer is dan 255 karakters. Elk deel van de domeinnaam, tussen twee punten, mag niet langer zijn dan 63 karakters.",
    '__dom_not_exist' => "Domein bestaat niet.",
    '__domain' => "Domein",
    '__domain_' => 'Domein %1',
    '__domain_form' => "Domeinformulier",
    '__domain_id' => "Domeinkenmerk",
    '__domain_is_turned_off_for_backup' => "De website %1 is tijdelijk uitgeschakeld voor het maken of terugplaatsen van een reservekopie en is momenteel niet beschikbaar.",
    '__domain_limits' => "Domeinbeperkingen",
    '__domain_name' => "Domeinnaam",
    '__mail_name_in_ASCII_form' => "Naam mailaccount in ASCII-formaat",
    '__message_error' => 'Fout',
    '__message_warning' => 'Waarschuwing',
    '__message_info' => 'Informatie',
    '__domain_name_in_ASCII_form' => "Domeinnaam in ASCII-formaat",
    '__domain_repository' => "Opslag van domein %1",
    '__domain_status' => "Domeinstatus",
    '__domain_dns' => 'DNS-zone van domein',
    '__domain_total' => "Totaalbedrag van het abonnement",
    '__domain_total_powerUser' => "Totaalbedrag van het abonnement",
    '__domain_user' => "Domeinbeheerder",
    '__domains_global_changes' => "Geselecteerde domeinen aanpassen",
    '__mailnames_global_changes' => "Geselecteerde mailaccounts aanpassen",
    '__backup_manager' => 'Bestandsbeheer',
    '__domains_list' => "Domeinen",
    'domains_list__list_header' => "Domeinen", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "De domeinnaam begint met www, hoewel het voorvoegsel WWW is gebruikt.\nToch doorgaan?",
    '__dovecot' => 'Dovecot IMAP- en POP3-server',
    '__dsmail' => "Maildienst",
    '__dsmaillist' => "Verzendlijstdienst",
    '__dsr_db' => "DB",
    '__dsr_dname' => "Domeinnaam",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "Naam van cliënt",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Totale omvang van reservekopieën in lokale opslag",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "E-mailadres is ongeldig.",
    '__enabled' => "ingeschakeld",
    '__enter_cert_text' => "Voer certificaattekst in",
    '__enter_logo_url' => "URL van logo",
    '__enter_size' => "Geef grootte op",
    '__exclusive' => "Exclusief",
    '__expiration_date' => "Verloopdatum",
    '__fax' => "Fax",
    '__file' => "Bestand",
    '__file_is_empty' => "Bestand is leeg.",
    '__file_name' => "Bestandsnaam",
    '__file_type' => 'Bestandstype',
    '__filemanager' => "Bestandsbeheer",
    '__filepath_is_empty' => "Zoekpad naar het bestand is leeg",
    '__files_list' => "Bestanden",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP-instellingen",
    '__ftp_serv' => "FTP-server", // indirect
    '__ftp_server_parameters_are_empty' => "U moet eerst de eigenschappen van het FTP-account instellen!",
    '__ftp_status' => "Status van FTP-server",
    '__full_day0' => "Zondag",
    '__full_day1' => "Maandag",
    '__full_day2' => "Dinsdag",
    '__full_day3' => "Woensdag",
    '__full_day4' => "Donderdag",
    '__full_day5' => "Vrijdag",
    '__full_day6' => "Zaterdag",
    '__full_month1' => "Januari",
    '__full_month10' => "Oktober",
    '__full_month11' => "November",
    '__full_month12' => "December",
    '__full_month2' => "Februari",
    '__full_month3' => "Maart",
    '__full_month4' => "April",
    '__full_month5' => "Mei",
    '__full_month6' => "Juni",
    '__full_month7' => "Juli",
    '__full_month8' => "Augustus",
    '__full_month9' => "September",
    '__giga' => "G",
    '__group' => "Groep",
    '__h' => "U",
    '__hard_disk_quota' => "Harde beperking domein",
    '__hard_disk_quota_not_supported' => 'Harde beperking van schijfruimte wordt niet ondersteund vanwege de instellingen van het bestandssysteem van de server.',
    '__header_text_is_invalid' => "Titel van de afgeschermde omgeving is ongeldig.",
    '__help_topic_not_found' => 'Het hulponderwerp dat u hebt opgevraagd (%1) bestaat niet.',
    '__hosting' => "Hosting",
    '__hosting_ip_dns_ip_not_equiv' => "Geen van de IP-adressen die in DNS A-records zijn opgegeven komt overeen met het IP-adres dat wordt gebruikt voor hosting.",
    '__hosting_scripting' => "Ondersteuning van scripts voor hosting",
    '__hosting_setup_page_title' => "Instellingen fysieke hosting voor domein %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Type hosting",
    '__hostname' => "Hostnaam",
    '__hostname_is_empty' => "Hostnaam is leeg.",
    '__hour(s)' => 'Uur (Uren)',
    '__hst_type_incorrect' => "Type hosting is onjuist.",
    '__http' => "HTTP", //indirect
    '__htype' => "U",
    '__idle_time' => "Inactieve periode",
    '__iface' => "Scherm",
    '__image' => "Afbeelding",
    '__imap_status' => "Status IMAP-server",
    '__in' => "in",
    '__in_%' => "in %",
    '__incorrect_databases_login_pass' => "De aanmeldgegevens die u hebt opgegeven voor toegang tot PostgreSQL zijn onjuist.",
    '__incorrect_ip_or_network_address' => 'Onjuist IP- of netwerkadres.',
    '__info' => 'Info',
    '__install' => "Installeren",
    '__install_prefix' => "Installatievoorvoegsel",
    '__invalid_cert_id' => "Ongeldige certificaatkenmerk",
    '__invalid_context' => "Ongeldige context: %1",
    '__invalid_db_usr_name' => "Databasegebruikersnaam is ongeldig.",
    '__invalid_dir_name' => "Mapnaam is ongeldig",
    '__invalid_dom_name' => "Domeinnaam is ongeldig.",
    '__invalid_filename' => "Ongeldige bestandsnaam. Gebruik geen enkele aanhalingstekens en/of \"../\" combinatie.",
    '__invalid_id' => "Ongeldig identificatie.",
    '__invalid_lines_num' => "Onjuiste waard voor het aantal regels, alleen getallen zijn toegestaan.",
    '__invalid_max_letter_size' => "Maximale berichtomvang is ongeldig.",
    '__invalid_pdir_name' => "Naam van afgeschermde map is ongeldig.",
    '__invalid_restart_apache_interval' => "Apache-herstartinterval is ongeldig.",
    '__invalid_tmpl_name' => "Sjabloonnaam is ongeldig.",
    '__invalid_value' => "Onjuiste waarde.",
    '__ip_addr' => "IP-adres",
    '__ip_address_and_mask' => "IP-adres en subnetmasker",
    '__ip_alias__mask' => "IP-adres en subnetmasker",
    '__ip_addr_form' => "Formulier IP-adres",
    '__ip_addr_is_invalid' => "IP-adres is ongeldig.",
    '__ip_addr_list' => "IP-adressen",
    '__ip_address_does_not_exist' => "IP-adres bestaat niet.",
    '__ip_addresses' => "IP-adressen",
    '__ip_address_and_mask_hint' => 'Bijvoorbeeld %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "Kbytes",
    '__key_for_virtuozzo_only' => "Uw licentiesleutel is alleen bedoeld voor gebruik in Virtuozzo containers.",
    '__key_limits_exceeding' => "Deze bewerking overschrijdt de beperkingen gesteld door uw softwarelicentie. Als u dit bericht krijgt neem dan contact op met uw provider of de producent om de beperkingen van deze licentie uiteen te zetten of om de mogelijkheden uit te breiden.",
    '__kilo' => "K",
    '__keywords' => 'Sleutelwoorden',
    '__lang_unknown' => 'Kan de taal niet herkennen.',
    '__languages' => 'Taal',
    '__learn_more' => 'Meer weten?',
    '__loading' => 'Bezig met laden...',
    '__locales' => "Taalpakketten",
    '__link_url_is_invalid' => "Logo-URL is ongeldig.",
    '__lists' => "Verzendlijsten",
    '__literal_bytes' => "B",
    '__processing' => "Een ogenblik geduld.<br> Laden",
    '__locale' => "Schermtaal",
    '__locale_is_not_defined' => "Schermtaal is niet opgegeven.",
    '__local_server_mysql' => 'Lokale MySQL-server',
    '__local_server_postgresql' => 'Lokale PostgreSQL-server',
    '__log_files' => "Logbestanden",
    '__log_and_statistics_files' => 'logbestanden en statistische verslagen',
    '__config_files' => 'Configuratiebestanden',
    '__chroot_files' => 'Chrooted omgeving',
    '__login' => "%1 Gebruikersnaam",
    '__login1' => "Gebruikersnaam",
    '__login_disabled' => "Aanmelden verboden",
    '__login_enabled' => "Aanmelden toegestaan",
    '__login_incorrect' => "U hebt een onjuiste gebruikersnaam of onjuist wachtwoord ingevuld.",
    '__login_name' => "%1 gebruikersnaam",
    '__login_name_is_invalid' => "%1 gebruikersnaam is ongeldig.",
    '__logon_time' => "Tijdstip van aanmelden",
    '__ma' => "Mailaliassen",
    '__mail' => "Mail",
    '__mail_alias_name' => "Naam mailalias",
    '__mail_autodiscovery' => 'Autodiscover voor mail',
    '__mail_exchanger_name_is_invalid' => "Naam mailexchanger is ongeldig.",
    '__mail_groups' => "Mailgroepen",
    '__mail_list_engine' => "Verzendlijstsoftware",
    '__mail_name' => "Mailaccount",
    '__mail_name_form' => "Eigenschappen mailaccount",
    '__mail_names' => "Mailaccounts",
    '__mail_serv' => "Mailsever",
    '__mail_user' => 'Mailgebruiker',
    '__mailgroup' => "Mailgroep",
    '__maillist' => "Verzendlijst",
    '__maillists' => "Verzendlijsten",
    '__maillist_member' => 'Verzendlijstabonnee',
    '__mailname' => "Mailaccount",
    '__mailname_redir_self' => "Mailaccount kan geen mail naar zichzelf doorsturen.",
    '__max_dom_num_reached_for_cl' => "De beperking van het aantal domeinen is bereikt voor dit cliëntaccount.",
    '__max_file_size_available' => "Maximaal toegestane bestandsgrootte %1",
    '__max_subdom_num_reached_for_cl' => "De beperking van het aantal subdomeinen is bereikt voor dit cliëntaccount.",
    '__max_subdom_num_reached_for_dom' => "De beperking van het aantal subdomeinen is bereikt voor het domein.",
    '__max_subdom_num_reached_for_key' => "De beperking die de licentiesleutel stelt aan het aantal toegestane subdomeinen is bereikt.",
    '__max_traffic_limit' => "Dataverkeerbeperking",
    '__maximum_excl_ip_num' => "Mailaccounts",
    '__mb' => "MB",
    '__mbytes' => "megabyte",
    '__mb_month' => "MB/maand",
    '__mb_sec' => "MB/sec",
    '__gb_sec' => "GB/sec",
    '__tb_sec' => "TB/sec",
    '__mega' => "M",
    '__minute(s)' => 'Minuut (minuten)',
    '__mls_not_in_key' => "Uw licentiesleutel ondersteunt geen extra talen.",
    '__modification_date' => "Datum van wijziging",
    '__module' => "Extensie",
    '__month' => "Maand",
    '__month(s)' => "Maand(en)",
    '__month1' => "Jan",
    '__month10' => "Okt",
    '__month11' => "Nov",
    '__month12' => "Dec",
    '__month2' => "Feb",
    '__month3' => "Mrt",
    '__month4' => "April",
    '__month5' => "Mei",
    '__month6' => "Juni",
    '__month7' => "Juli",
    '__month8' => "Aug",
    '__month9' => "Sep",
    '__monthly' => "Maandelijks",
    '__months' => "Maanden",
    '__moved_permanently' => 'Permanent verplaatst',
    '__mssql' => "Microsoft SQL-server",
    '__mssql__server' => "Server",
    'mssql__server' => "Naam Microsoft SQL-server",
    'mssql__unable_to_change_server_name_db_exists' => "naam voor de server kan niet worden gewijzigd: er is ten minste één database op de server aanwezig.",
    '__mssql_status' => "Status Microsoft SQL server",
    '__multiply_login_deny' => "Kan u niet aanmelden. Een andere gebruiker met dezelfde gebruikersnaam (%1) is al aangemeld bij Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Status MySQL-server",
    '__mysql_version' => "MySQL-versie",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Status MariaDB-server",
    '__mariadb_version' => "Versie MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Status Percona-server",
    '__percona_version' => "Versie Percona",
    '__name' => "Naam",
    '__name_invalid' => "Naam is ongeldig.",
    '__nameserver' => "naamserver",
    '__network' => "Netwerk",
    '__networks' => "Netwerken",
    '__no' => "Nee",
    '__no_ip_address_with_properly_type_available' => "Kan de gegevens uit de reservekopie niet terugplaatsen, omdat er geen geschikte IP-adressen zijn.",
    '__no_clients_specified' => "Er zijn geen cliëntaccounts opgegeven.",
    '__no_comments' => "Geen opmerkingen.",
    '__no_ip_specified' => "Geen IP opgegeven.",
    '__nologin' => "Verboden",
    '__none' => "Geen",
    '__not_configured' => "Niet ingesteld",
    '__not_implemented_yet' => "Nog niet geïmplementeerd",
    '__not_supported_by_ftp' => "(niet ondersteund door FTP-server)",
    '__not_supported_by_mailmng' => "niet ondersteund door de mailserver",
    '__notification' => "Melding",
    '__num_displayed' => "%1 van %2 weergegeven",
    '__num_is_invalid' => "Aantal is ongeldig.",
    '__object_not_found' => 'Object niet gevonden: %1',
    '__of_all' => "% van Alle",
    '__off' => "Uit",
    '__ok' => "OK",
    '__old_passwd' => "Oud %1 wachtwoord",
    '__on' => "Aan",
    '__others' => "Overigen",
    '__other_ip__will_be_added' => 'Overige beschikbare IP-adressen (zullen worden toegevoegd aan IP-voorziening van de cliënt)',
    '__out' => "Uitgaand",
    '__p' => "P",
    '__passwd' => "%1 Wachtwoord",
    '__passwd_hint' => "At least 5 characters, maximum 255, no national characters",
    '__passwd_is_invalid' => "%1 Wachtwoord is ongeldig.",
    '__passwd_not_match' => "De wachtwoorden komen niet overeen!",
    '__path' => "Zoekpad",
    '__perl_unix_support' => "Perl-ondersteuning",
    '__perl_win_support' => "Perl-ondersteuning",
    '__perm_denied' => "Toegang geweigerd.",
    '__permissions' => "Rechten",
    '__personal_name' => "Eigennaam",
    '__pg_admin_not_activated' => "PostgreSQL is niet geactiveerd vanaf de beheerpagina van de server.",
    '__pg_not_inst' => "PostgreSQL is niet geïnstalleerd.",
    '__pg_not_run_or_inst' => "PostgreSQL is niet geïnstalleerd of opgestart.",
    '__pg_not_support_in_key' => "PostgreSQL wordt niet ondersteund door de licentiesleutel.",
    '__phone' => "Telefoon",
    '__phosting' => "Fysieke hosting",
    '__php_support' => "PHP-ondersteuning",
    '__php_run_as_isapi' => "uitvoeren als ISAPI-extensie",
    '__php_safe_mode' => "PHP 'safe_mode' ingeschakeld",
    '__php_version' => "PHP-versie",
    '__physical' => "Fysieke hosting",
    '__plesk_stat_pdir' => "De map '/plesk-stat/webstat/' met een wachtwoord afschermen",
    '__plesk_stat_dir_name' => "Domeinstatistieken",
    '__plesk_stat_protect' => "Toegang tot webstatistieken afschermen voor met de gebruikersnaam en het wachtwoord die de gebruiker ook voor FTP gebruikt",
    '__plesk_stat_protect_install' => "toegankelijk via met wachtwoord afgeschermde map '/plesk-stat/webstat/'",
    '__plesk_stat_webstat_not_activate' => "U hebt geen programma voor webstatistieken geselecteerd om voor deze website te gebruiken.",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Status van POP3 server",
    '__popen_error' => "Een fout is opgetreden bij het oproepen van de popen-functie.",
    '__port' => 'Poort',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Status PostgreSQL",
    '__preferences' => "Instellingen",
    '__account_preferences' => "Accountinstellingen",
    '__interface_preferences_general' => 'Algemeen',
    '__interface_preferences_default' => 'Standaard schermvoorkeuren',
    '__interface_preferences_admin' => "Schermvoorkeuren van beheerder",
    '__interface_template' => 'Aanpassingssjabloon voor scherm',
    '__interface_preferences' => "Schermvoorkeuren",
    '__proceed?' => "Wilt u doorgaan?",
    '__protect_dir_user' => "Gebruiker van afgeschermde map",
    '__protect_dir_users' => "Gebruikers van afgeschermde map",
    '__protect_dirs' => "Afgeschermde mappen",
    '__provider_contact_name' => "Naam van contact van houder",
    '__python_unix_support' => "Python-ondersteuning",
    '__python_win_support' => "Python-ondersteuning",
    '__quota' => "Beperkingen",
    '__r' => "R",
    '__reconfigure' => "Opnieuw instellen",
    '__record_type' => "Type record",
    '__release' => "Versie",
    '__remote_db_not_supported_by_key' => 'Externe databasehosting wordt niet ondersteund door uw licentiesleutel.',
    '__remove' => "Verwijderen",
    '__remove_confirmation' => "Verwijdering bevestigen",
    '__remove_protection' => 'Niet langer afschermen',
    '__report' => "Verslag",
    '__report_auto' => 'Bezorgrooster',
    '__report_form' => "Verslagformulier",
    '__report_size_na' => "Dienst is niet beschikbaar",
    '__reports_list' => "Verslagen",
    '__requested' => "Aangevraagd",
    '__required_fields' => "Vereiste velden",
    '__resp_name_invalid' => "Naam van automatische beantwoording is ongeldig. Gebruik alleen alfanumerieke tekens, punten, underscores en spaties.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Servernaam is ongeldig.",
    '__screenshots' => 'Schermafbeeldingen',
    '__script_warning' => "Na het ontnemen van de scriptingmogelijkheden van dit domein zullen alle betrokken scripts als platte tekst worden getoond wanneer ze door een browser worden aangeroepen. Het is daarom aangeraden dat de beheerder alle betrokken scripts van het opgegeven domein verwijdert.",
    '__sec' => "Seconden",
    '__second(s)' => "Seconde(n)",
    '__see_list_of_logged_in' => "Bekijk de lijst met gebruikers die momenteel zijn aangemeld.",
    '__select_certs_to_remove' => "Selecteer certificaten om te verwijderen.",
    '__select_domains_to_default_host' => "Selecteer een domein om als standaard in te stellen.",
    '__select_domains_to_remove' => "Selecteer domeinen om te verwijderen.",
    '__type_domain_name_to_add' => "Geef een domeinnaam op om toe te voegen.",
    '__select_files_to_remove' => "Selecteer bestanden om te verwijderen.",
    '__select_ip' => "IP-adres toewijzen",
    '__select_ip_to_remove' => "Selecteer een IP-adres om te verwijderen.",
    '__select_domain_template' => "Instellingen uit domeinsjabloon gebruiken",
    '__select_templates_to_remove' => "Selecteer sjablonen om te verwijderen.",
    '__server' => "Server",
    '__server_total' => "Servertotaal",
    '__service' => "Dienst",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MySQL database-server",
    '__service_description__mysql' => "MySQL database-server",
    '__service_title__web' => "Webserver",
    '__service_description__web' => "Webserver",
    '__service_title__smtp' => "SMTP-server",
    '__service_description__smtp' => "SMTP-server",
    '__service_title__mail' => "IMAP/POP3 Server",
    '__service_description__mail' => "IMAP/POP3 Server",
    '__service_title__dns' => "DNS-server",
    '__service_description__dns' => "DNS-server",
    '__service_title__postgresq' => "PostgreSQL database-server",
    '__service_description__postgresq' => "PostgreSQL database-server",
    '__service_title__spamassassin' => "SpamAssassin spamdetectie",
    '__service_description__spamassassin' => "SpamAssassin spamdetectie",
    '__services' => "Diensten",
    '__all_services' => "Alle diensten",
    '__sessions' => "Sessies",
    'sessions__feature_ftp_session_manager_not_supported' => "FTP-sessiemogelijkheid wordt niet ondersteund door huidige FTP-server",
    '__sessions_list' => "Sessies",
    '__set' => "Inschakelen",
    '__setup_logo_pref' => "Logo",
    '__shared' => "Gedeeld",
    '__shell_access_warning' => "Het toestaan van shelltoegang tot het systeem is uiterst riskant voor de systeemveiligheid. Geef alleen toegang tot het systeem als u precies weet wat dit inhoudt en alleen aan betrouwbare gebruikers. Weet u zeker dat u toegang wilt toestaan?",
    '__siteapp_not_support_in_key' => "Webtoepassingen worden niet ondersteund door de licentiesleute",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'De instellingen van deze webtoepassing zijn handmatig gewijzigd. Om de handmatige aanpassingen te beschermen is het niet mogelijk de toepassing opnieuw in te stellen via Plesk.',
    '__site_management' => "Webpublishing", // indirect
    '__size' => "Grootte",
    '__skeleton' => 'Sjabloon voor virtuele hosts',
    '__skins' => 'Thema\'s',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Status SMTP-server",
    '__some_fields_are_empty_or_invalid' => "Sommige velden zijn leeg of hebben een onjuiste waarde.",
    '__spamassassin' => "Spamfilter",
    '__spamassassin_status' => "Status SpamAssassin",
    '__spamd_status' => 'Status van spamfilter',
    '__splited_backup' => "(meerdelige reservekopie)",
    '__split_backup_file' => "Een meerdelige reservekopie aanmaken",
    '__split_backup_size' => "Omvang van volume",
    '__split_backup_less_than_500' => "Volumes met een omvang kleiner dan 500 megabyte worden niet ondersteund",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI-ondersteuning",
    '__ssi_with_html' => "SSI gebruiken voor *.htm, *.html-bestanden",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS-ondersteuning",
    '__same_ssl' => "Gebruik een enkele map voor het opslaan van bestanden met en zonder SSL/TLS",
    '__same_ssl_cu' => "Zowel bestanden met als zonder SSL/TLS",
    '__state' => "Provincie of staat",

    '__status__Active' => 'Actief',
    '__status__active' => 'actief',
    '__status__Passive' => 'Uitgeschakeld',
    '__status__passive' => 'uitgeschakeld',
    '__status__off' => 'uitgeschakeld',
    '__status__with_parent' => 'uitgeschakeld',
    '__status__backup_restore' => 'tijdelijk opgeschort vanwege het maken of herstellen van een reservebestand',
    '__status__admin' => 'opgeschort door beheerder van de server',
    '__status__resseler' => 'opgeschort door reseller',
    '__status__client' => 'opgeschort door cliënt',
    '__status__unknown' => 'status is onbekend',

    '__status_of' => "%1 status",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnelserver", // indirect
    '__subdomain' => "Subdomein",
    '__subdomain_name' => "Naam subdomein",
    '__subdomain_name_in_ASCII_form' => "Subdomeinnaam in ASCII-formaat",
    '__subdomains' => "Subdomeinen",
    '__domainaliases' => "Domeinaliassen",
    '__subdomains_list' => "Subdomeinen",
    '__subdomains_not_support_in_key' => "Subdomeinbewerkingen worden niet ondersteund door de licentiesleutel",
    '__sys_user_type' => "FTP-gebruiker",
    '__sys_user_type_main' => "Het FTP-gebruikeraccount van het hoofddomein gebruiken",
    '__sys_user_type_native' => "Een apart FTP-gebruikeraccount voor dit subdomein aanmaken",
    '__t' => "T",
    '__target_domain' => "Doeldomein",
    '__template' => "Sjabloon",
    '__template_not_accepted' => "Kan het sjabloon niet accepteren: de volgende beperkingen zijn overschreden.",
    '__templates' => "Sjablonen",
    '__templates_list' => "Sjablonen",
    '__tera' => "T",
    '__title' => "Titel",
    '__tools' => "Hulpprogramma's",
    '__total' => "Totaal %1",
    '__total_size' => "Totale grootte",
    '__total_used' => "Totaal verbruikt",
    '__traffic' => "Dataverkeer",
    '__traffic_by_client' => "Dataverkeer van cliënt",
    '__traffic_by_domain' => "Dataverkeer van domein",
    '__traffic_by_service' => "Dataverkeer van dienst",
    '__traffic_history' => "Overzicht van verbruikt dataverkeer",
    '__unable_change_locale' => "Kan de schermtaal niet wijzingen: %1",
    '__unable_create_new_dom' => "Kan geen domein aanmaken: %1",
    '__unable_define_dom_name' => "Kan domeinnaam niet definiëren: %1",
    '__unable_define_necessary_properties' => "Kan niet alle vereiste eigenschappen definiëren.",
    '__unable_define_properties' => "Kan eigenschappen niet definiëren: %1",
    '__unable_exec_util' => "Kan hulpprogramma niet uitvoeren: %1",
    '__unable_get_dns_a_recs' => "Kan IP-adressen voor DNS A-records voor dit hostingaccount niet ophalen: %1",
    '__unable_get_mbox_quota' => "Kan de informatie over de beperking van de omvang van het postvak niet ophalen.",
    '__unable_redirect_to_myself' => "Kan geen mail doorsturen naar hetzelfde account.",
    '__unable_redirect_to_my_alias' => "Kan geen mail doorsturen naar een mailalias.",
    '__default_domain_redirect_to_myself' => "Kan domein niet instellen als standaard voor IP-adres:\nomleiding naar zichzelf vastgesteld.",
    '__unable_remove_client' => "Kan cliënt niet verwijderen: %1",
    '__unable_set_up_mbox_quota' => "Kan beperking van de omvang van het postvak niet instellen voor het domein: %1",
    '__unable_setup_pass' => "Kan wachtwoord niet instellen: %1",
    '__unable_to_create_new_account' => "Kan geen account aanmaken: %1",
    '__unable_to_define_db_size' => "Kan databasegrootte niet definiëren.",
    '__unable_to_enable_short_names' => "Kan het gebruik van korte namen voor POP3/IMAP-accounts niet toestaan.",
    '__unable_to_fetch_data_from_submit' => "Kan de verzonden gegevens niet ophalen: %1",
    '__unable_to_open_file' => "Kan het bestand %1 niet openen: %2",
    '__unable_to_update_subdomain' => "Kan geen wijzigen aanbrengen aan het subdomein: %1",
    '__unable_update_cl_data' => "Kan geen wijzigingen van het gebruikeraccount opslaan: %1",
    '__unable_update_db_params' => "Kan databaseparameters niet bijwerken: %1",
    '__unable_update_dom_data' => "Kan domeingegevens niet bijwerken: %1",
    '__undefined' => "niet gedefinieerd",
    '__uninstall' => "Verwijderen",
    '__unknown_error' => "Onbekende fout",
    '__unlimited_lower' => "Onbeperkt",
    '__unset' => "Uitschakelen",
    '__update' => "Bijwerken",
    '__uploaded_file_is_invalid' => "Geüpload bestand is ongeldig: %1",
    '__url' => "URL",
    '__usage' => "Schijfruimtegebruik",
    '__user' => 'Gebruiker',
    '__user_already_logged' => "Een andere gebruiker met dezelfde gebruikersnaam (%1) is al aangemeld bij Plesk.",
    '__version' => "versie",
    '__aps_license' => "Licentiesleutel",
    '__vh_type' => "Type virtuele host",
    '__vhosts_apache_status' => "Status van webserver",
    '__wrong_charset_conversion' => 'Onjuist karakterset, conversie van "%1" naar "%2" is niet toegestaan',
    '__warning_' => "Let op!",
    '__warning_excl_ip_num' => "Exclusief IP-adres",
    '__warning_expiration' => "Verloopdatum",
    '__web_scripting' => "Webscripting", // indirect
    '__web_serv' => "Webserver", // indirect
    '__web_statistic' => "Webstatistieken", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer is niet op de server geïnstalleerd. Neem contact op met uw provider voor ondersteuning bij de installatie van Webalizer.",
    '__webstat_support' => "Webstatistieken",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Wanneer u van het ene statistiekprogramma overstapt naar een ander, worden alle verslagen die zijn gemaakt door het eerder gebruikte programma gewist en nieuwe verslagen worden aangemaakt op basis van de informatie die wordt ingelezen uit de logbestanden die op de server bewaard zijn gebleven. Dit betekent dat wanneer u het systeem hebt ingesteld (via Domeinen > domeinnaam > Logbeheer > Logopschoning) om logbestanden alleen voor de laatste maand te bewaren, webstatistieken alleen voor deze laatste maand beschikbaar zijn. Wilt u overstappen naar een ander statistiekprogramma?",
    '__webstat_perm_denied' => 'U beschikt niet over de rechten om webstatistieken te beheren.',
    '__webuser' => "Webgebruiker",
    '__sysusers_list' => "Systeemgebruikers",
    '__sysuser' => "Systeemgebruiker",
    '__weekly' => "Wekelijks",
    '__whats_new_in_version' => "Nieuw in Plesk %1?",
    '__wrong_hosting_type__none' => 'Er is geen webhosting ingesteld voor domein %1.',
    '__wrong_hosting_type__std_fwd' => 'Standaard doorschakelen is ingesteld voor domein %1. Deze bewerking is alleen beschikbaar voor domeinen met webhosting.',
    '__wrong_hosting_type__frm_fwd' => 'Doorschakelen via frame is ingesteld voor domein %1. Deze bewerking is alleen beschikbaar voor domeinen met webhosting.',
    '__wu' => "Webgebruikers",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW-voorvoegsel is gewijzigd. Zorg ervoor dat u het SSL/TLS-certificaat vervolgens ook aanpast.",
    '__year' => "Jaar",
    '__year(s)' => "Jaar (Jaren)",
    '__yes' => "Ja",
    '__you' => "U",
    '__zip_code' => "Postcode",
    '__form_normal' => "Normaal",
    '__form_advanced' => "Geavanceerd",

    'admin_ed__edit_administrator_info' => "Profiel van beheerder bewerken",
    'admin_ed__create_default_client' => "Ik zou graag een standaard cliëntaccount aanmaken.",
    'admin_ed__unable_update' => "Kan beheerderinformatie niet bijwerken: %1",

    'auth__update_admin_info' => "Voer informatie over de beheerder in. Deze informatie is benodigd voor het uitvoeren van %1.",
    'auth__you_not_have_perm' => "U beschikt niet over de rechten om dit domein te beheren.",
    'auth__key_expired_admin' => 'Uw Plesk-licentie is verlopen. Als u Plesk wilt blijven gebruiken, verleng dan uw licentie of schaf een nieuwe aan.',
    'auth__key_expired_admin_restricted' => 'Uw Plesk-licentie is verlopen. Neem contact op met uw provider om Plesk te blijven gebruiken.',
    'auth__key_expired_client' => 'Uw Plesk-licentie is verlopen. Neem contact op met uw hostingprovider.',
    'autoinstaller__not_installed' => 'Het component Automatische installatie is niet geïnstalleerd.',
    'autoinstaller__release_action' => 'Beschikbare bewerkingen',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Opwaarderen naar de nieuwe versie van Plesk',
    'autoinstaller__release_action_update' => 'Bezig met bijwerken of toevoegen van nieuwe componenten',
    'autoinstaller__release_action_up2date' => 'U beschikt over een actuele versie',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Niet geïnstalleerd',
    'autoinstaller__component_action_update' => 'Er zijn updates beschikbaar',
    'autoinstaller__component_action_upgrade' => 'Er is een update beschikbaar',
    'autoinstaller__component_action_up2date' => 'U beschikt over een actuele versie',
    'autoinstaller__component_action_error' => 'Er zijn geen updates beschikbaar',
    'autoinstaller__component_serverbuildtime' => 'Nieuwste versie',
    'autoinstaller__component_localbuildtime' => 'Uw versie',
    'autoinstaller__component_installed_version' => 'Uw versie',
    'autoinstaller__component_available_version' => 'Laatste versie',
    'autoinstaller__component' => 'Component',
    'autoinstaller__components' => 'Componenten',
    'autoinstaller__components_title' => '%1 Componenten',
    'autoinstaller__component_dependency_note' => 'vereist voor de installatie van de geselecteerde onderdelen',
    'autoinstaller__install_confirm' => 'Ja, ik wil deze componenten installeren',
    'autoinstaller__install_confirm_request' => 'Selecteer het selectievakje ter bevestiging',
    'autoinstaller__install_title' => 'Installatie van de geselecteerde onderdelen bevestigen',
    'autoinstaller__key_update_confirm' => 'Bevestig overslaan bijwerken van sleutel en installatie van de standaardsleutel',
    'autoinstaller__key_update_confirm_request' => 'Selecteer het selectievakje ter bevestiging.',
    'autoinstaller__key_update_failed' => '<p>Plesk kan uw productlicentie niet bijwerken.</p><p>%1</p><p>Als u doorgaat met de upgrade zonder over de juiste licentie te beschikken, dan zal er een standaardlicentie worden geïnstalleerd met beperkte functionaliteit. Beheerders wordt aangeraden om eerst de juiste licentiesleutel te verkrijgen en dan pas verder te gaan met de upgrade van het product.</p>',
    'autoinstaller__email' => 'Melding versturen naar',
    'autoinstaller__email_admin' => "E-mail van beheerder",
    'autoinstaller__email_email' => 'Aangepast e-mailadres...',
    'autoinstaller__release' => 'Releasenaam',
    'autoinstaller__releases' => 'Beschikbare versies',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Selecteer de componenten die geïnstalleerd moeten worden',
    'autoinstaller__status_error' => 'Foutmelding: %1',
    'autoinstaller__status_install_error' => 'Installatie kan niet worden gestart: %1',
    'autoinstaller__status_install_busy' => 'Installatie kan niet worden gestart: er is nog een andere installatieprocedure bezig.',
    'autoinstaller__status_install_ok' => 'Installatie is begonnen. U wordt per e-mail op de hoogte gehouden van de voortgang (%1).',
    'autoinstaller__status_query_busy' => 'Bezig met installeren.',
    'autoinstaller__status_query_error' => 'Kan installatiestatus niet ophalen: %1',
    'autoinstaller__status_unknown' => 'Kan status van automatische installatie niet vaststellen.',
    'autoinstaller__status_busy' => 'Automatische installatie is bezet, een moment geduld alstublieft.',
    'autoinstaller__configure_title' => 'Update-instellingen',
    'autoinstaller__preferences_legend' => 'Instellingen',
    'autoinstaller__target' => 'Map met tijdelijke download',
    'autoinstaller__target_invalid' => "Specificeer een absoluut zoekpad",
    'autoinstaller__check_updates' => 'Op updates controleren wanneer beheerder zich bij Plesk aanmeldt',
    'autoinstaller__check_updates_warning' => 'Nieuwe <a href="%1">updates</a> beschikbaar voor %2',
    'autoinstaller__source_type' => 'Brontype',
    'autoinstaller__source' => 'Bron-URL',
    'autoinstaller_source__preferences_legend' => 'Instellingen',
    'autoinstaller_source__type' => 'Brontype',
    'autoinstaller_source__url_invalid' => 'Ongeldige bron',
    'autoinstaller_source__url_invalid_network' => 'Ongeldige oorspronkelijke URL (Voorbeeld: http:// source, ftp://source)',
    'autoinstaller_source__url' => 'Bron-URL',
    'autoinstaller__source_invalid_network' => 'U hebt een ongeldig netwerkadres opgegeven',
    'backup__repository' => 'Locatie van opslag reservekopieën',
    'backup__error_notify_email' => 'Als zich tijdens het maken van de reservekopie fouten voordoen, stuur dan een melding naar e-mail',
    'backup__dump_info' => "Informatie reservekopie",
    'backup__dump_file_name_not_defined' => "Geen bestandsnaam voor reservekopie opgegeven",
    'backup__local_file' => 'Lokale reservekopie',
    'backup__domain_ftp' => 'externe FTP-server',
    'backup__wrong_path' => "Incorrect zoekpad naar de opslag van reservekopieën: gebruik niet de serie karakters ../../",
    'backup__unable_to_connect_to_ftp_server' => "Kan geen verbinding maken met FTP-server: %1",
    'backup__unable_to_read_file' => 'Kan de reservekopie niet lezen.',
    'backup__backup_task_does_not_exist' => "Taak reservekopie maken bestaat niet, deze moet worden aangemaakt voordat u deze inschakelt.",
    'backup__restore_params' => "Herstelparameters",
    'backup__confirmation' => "Waarschuwing: het domein is niet beschikbaar tijdens het maken of herstellen van een reservekopie.",
    'backup__backup_method' => 'Reservekopiemethode',
    'backup__dumpfile_name' => "Bestandsnaam van reservekopie",
    'backup__dumpfile_name_is_invalid' => "Naam van reservekopie is ongeldig: gebruik alleen cijfers en letters, het verbindingsstreepje, de punt en de underscore. Gebruik geen namen als omschrijving.* als naam van de reservekopie.",
    'backup__email_required' => "Uw e-mailadres is vereist om u op de hoogte te houden over het verloop van het maken of terugplaatsen van de reservekopie. Geef u e-mailadres op in de accountdetails.",
    'backup__error_during_backup' => "Kan reservekopie niet aanmaken: %1",
    'backup__input_email_warning' => "U moet ofwel e-mail voor notificatie opgeven, of het selectievakje uitschakelen.",
    'backup__make_download' => "reservekopie niet opslaan in opslag, deze alleen downloaden",
    'backup__make_dump' => 'reservekopie maken en opslaan in lokale opslag',
    'backup__makedump_to_ftp' => 'reservekopie maken en opslaan op externe FTP-server',
    'backup__restore_ip' => "IP-adres voor herstel",
    'backup__select_dumpfile' => "Selecteer een reservekopie.",
    'backup__time' => "Tijd aanmaken reservekopie",
    'backup__day' => 'Dag reservekopie',
    'backup__view_dump_info' => "Informatie over reservekopieën van domein %1 bekijken",
    'backup__wrong_domain_name' => "De reservekopie bevat de gegevens van domein %1 en kan daarom niet worden teruggeplaatst op domein %2",
    'backup__incorrect_ftp_user_or_passwd' => "Onjuiste FTP-gebruikersnaam of wachtwoord. Pas de eigenschappen van FTP-account aan",
    'backup__access_denied' => "Toegang geweigerd: pas de FTP-accounteigenschappen aan",
    'backup__restore_from' => "%1 terugplaatsen",
    'backup__domain_session_failed' => 'Er is geen reservekopie aangemaakt van domein %1',
    'backup__client_session_failed' => 'Er is geen reservekopie aangemaakt van cliënt %1',
    'backup__domain_session_restore_failed' => 'Domein %1 is niet hersteld',
    'backup__client_session_restore_failed' => 'Cliëntaccount %1 is niet teruggeplaatst',
    'backup__domain_session_complete' => 'Reservekopie van domein %1 is aangemaakt',
    'backup__domain_session_backup' => 'Reservekopie van domein %1',
    'backup__client_session_backup' => 'Reservekopie van cliënt %1',
    'backup__domain_stop_title' => 'Annuleren maken reservekopie van domein %1',
    'backup__client_stop_title' => 'Maken reservekopie van cliëntaccount %1 annuleren',
    'backup__domain_restore_stop_title' => 'Terugplaatsen reservekopie van domein %1 annuleren',
    'backup__client_restore_stop_title' => 'Terugplaatsen reservekopie van cliëntaccount %1 annuleren',
    'backup__domain_session_backup_stop' => 'U staat op het punt om het maken van de reservekopie te annuleren. De reservekopie zal niet worden aangemaakt.',
    'backup__backup_stop_confirm' => 'Ja, ik wil het maken van de reservekopie stoppen',
    'backup__restore_stop_confirm' => 'Ja, ik wil het terugplaatsen beëindigen',
    'backup__domain_session_restore' => 'Terugplaatsen van domein %1',
    'backup__domain_session_restore_stop' => 'U staat op het punt om het terugplaatsen van de reservekopie te annuleren.',
    'backup__domain_backup_file_info' => 'Informatie over reservekopie van domein',
    'backup__domain_backup_file_list' => 'bestaande reservekopieën',
    'backup__domain_backup_progress' => 'Voortgang van maken reservekopie van website %1',
    'backup__domain_restore_progress' => 'Voortgang van terugplaatsen van website %1',
    'backup__domain_backup_progress_elapsed_time' => 'Verstreken tijd: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Verstreken tijd: %1',
    'backup__ip_map_legend' => 'IP-toewijzingen',
    'backup__ip_map_list_count' => 'IP-adressen',
    'backup__domain_restore_session_complete' => 'Domein %1 is teruggeplaatst.',
    'backup__domain_restore_session_complete_message' => 'Domein %1 is teruggeplaatst.',
    'backup__domain_backup_file_delete' => 'De volgende reservekopieën zullen worden verwijderd:',
    'backup__domain_backup_file_for_remove' => 'Selecteer de reservekopieën die u wilt verwijderen',
    'backup__backup_overwrite_file_confirm' => 'Vervanging bevestigen',
    'backup__backup_overwrite_file_confirm_text' => 'Reservekopie met de naam "%1" bestaat al. Wilt u deze vervangen?',
    'backup__backup_confirm_overwrite' => 'Vervangen van bestand bevestigen',
    'backup__backup_overwrite_legeng' => 'Vervangen',
    'backup__backup_not_contain_domain' => 'Reservekopie bevat geen informatie over domein %1',
    'backup__backup_not_contain_client' => 'Reservekopie bevat geen informatie over cliëntaccount %1',
    'backup__backup_client_info' => "Reservekopie maken van instellingen en accountdetails van cliënt",
    'backup__client_backup_progress' => 'Voortgang van maken reservekopie van cliëntaccount %1',
    'backup__client_session_complete' => 'Van cliëntaccount %1 is een reservekopie gemaakt',
    'backup__client_backup_file_info' => 'Informatie over reservekopie cliënt',
    'backup__restore_client_info' => "Instellingen en accountdetails van cliënt terugplaatsen",
    'backup__client_session_restore' => 'Terugplaatsen van cliëntaccount %1',
    'backup__client_db_server_map' => 'Toewijzing database-servers',
    'backup__domain_db_server_map' => 'Toewijzing database-servers',
    'backup__client_restore_session_complete_message' => 'Cliëntaccount %1 is teruggeplaatst.',
    'backup__client_restore_session_complete' => 'Cliëntaccount %1 is teruggeplaatst.',
    'backup__restore_select_some' => 'Selecteer de objecten die u wilt herstellen.',
    'backup__client_restore_progress' => 'Voortgang terugplaatsen van cliëntaccount %1',
    'backup__new_backup' => 'Nieuwe reservekopie aanmaken',
    'backup__done' => 'Voltooid:',
    'backup__done_domains' => '%1 domeinen van de %2',
    'backup__done_clients' => '%1 cliënt(en) van %2',
    'backup__remaining' => 'Nog te doen:',
    'backup__remaining_domains' => '%1 domein(en)',
    'backup__remaining_clients' => '%1 cliënt(en)',
    'backup__overall_backup_progress' => 'Algehele voortgang van maken reservekopie',
    'backup__comment_n_a' => 'n/b',
    'backup__command_ignore' => 'Opdracht "%1" wordt genegeerd',
    'backup__no_objects' => 'er zijn geen objecten voor reservekopie',
    'backup__cli_warning_not_enough_ip' => 'WAARSCHUWING: onvoldoende IP-adressen om standaard IP-toewijzingen in te stellen:',
    'backup__local_repository' => "Opslag van Plesk",
    'backup__ftp_repository' => 'FTP-opslag',
    'backup__ftp_login' => 'Gebruikersnaam',
    'backup__ftp_password' => 'Wachtwoord',
    'backup__ftp_directory_hint' => 'Bijvoorbeeld: /mijnmap/mijnreservekopieen',
    'backup__ftp_account_settings' => 'Instellingen FTP-account',
    'backup__ftp_account_preferences' => 'Instellingen FTP-account',
    'backup__repository_not_exist' => 'Map bestaat niet',
    'backup__repository_not_readable' => 'De opgegeven map kan niet worden gelezen',
    'backup__ftp_repository_not_configure' => 'Om gebruik te maken van FTP-opslag voor reservekopieën , <a href="%1">moet u eerst het FTP-account opgeven</a> .',
    'backup__ftp_repository_list_not_configure' => 'Accountinstellingen zijn niet opgegeven',
    'backup__repository_list_unable_listing' => 'Kan lijst met bestanden niet ophalen',
    'backup__ftp_repository_unable_listing' => 'Kan geen overzicht van map "%1" ophalen:',
    'backup__repository_legend' => 'Opslag van reservekopieën',
    'backup__store_in_repository' => 'Bestanden opslaan in',
    'backup__local_repository_lable' => 'Lokale opslag',
    'backup__ftp_repository_lable' => 'FTP-opslag',
    'backup__ftp_repository_not_configure_hint' => '(accountinstellingen zijn niet opgegeven)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP-account is niet opgegeven of niet ondersteund)',
    'backup__ftp_directory_not_exist' => 'De opgegeven map bestaat niet',
    'backup__other_user_process_modified' => 'Een andere gebruiker heeft het maken van de reservekopie of het migratieproces beëindigd.',
    'backup__another_user_exist' => 'De bewerking die wordt uitgevoerd is gestart door een andere Plesk-gebruiker. Deze gebruiker is nog steeds aangemeld bij Plesk.',
    'backup__ftp_repository_wait' => 'Een moment geduld terwijl informatie over FTP-opslag wordt opgehaald',
    'backup__ftp_write_test_failed' => 'Schrijven van testgegevens naar de FTP-account is mislukt %1:',
    'bt_upload_to_repository' => 'Bestanden uploaden naar lokale opslag',
    'bt_new_restore' => "Terugplaatsen",
    'bt_backup_schedule' => "Maken van reservekopie inroosteren",
    'backup_exist_backups' => "Bestaande reservekopieën",
    'backup_dialog__page_title' => "Maken van reservekopieën",
    'backup_dialog__please_wait' => "Het proces van het maken van de reservekopie staat op punt te beginnen. Dit kan enige tijd in beslag nemen. Een ogenblik geduld alstublieft.",
    'backup_conf__page_title' => 'Instellingen voor reservekopieën',
    'bt_accept' => "Accepteren",
    'bt_access' => "Toegang",
    'bt_action_log' => "Bewerkingslogboek",
    'bt_add' => "Toevoegen",
    'bt_add_client' => "Toewijzen aan gebruikers",
    'bt_database_server_add' => 'Database-server toevoegen',
    'bt_add_services' => "Diensten toevoegen",
    'bt_add_address_to_acl' => 'Adres toevoegen',
    'bt_anonftp_stats' => "Statistieken Anon. FTP",
    'bt_anonymous_ftp' => "Anonieme FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Bijsluiten",
    'bt_autoinstaller' => 'Updates',
    'bt_auto-updates' => 'Updates',
    'bt_back' => "<< Terug",
    'bt_backup' => "Reservekopieën",
    'bt_backup_configure' => "Instellingen reservekopie",
    'bt_buy_certs' => "Certificaten aanschaffen",
    'bt_blocked_domains' => 'Zwarte lijst',
    'bt_blocked_domain_add' => 'Domein toevoegen',
    'bt_card' => "Kaart",
    'bt_cert' => "Certificaat",
    'bt_certificates' => "Certificaten",
    'bt_change_passwd' => "Wijzig Wachtwoord",
    'bt_clean_log' => "Logbestand leegmaken",
    'bt_clear' => "Wissen",
    'bt_client_templates' => "Cliëntsjablonen",
    'bt_clients' => "Cliënten",
    'bt_codepage_change' => 'Karakterset wijzigen',
    'bt_comp_info' => "Componentenbeheer",
    'bt_common_acl' => 'Sjabloon met overdrachtsbeperkingen',
    'bt_configure_maillists' => "Mailman Instellen",
    'bt_configure_odbc' => "ODBC-gegevensbronnen",
    'bt_configure' => 'Instellen',
    'bt_copy' => "Kopiëren",
    'bt_copy_move' => "Kopiëren/Verplaatsen",
    'bt_create' => "Aanmaken",
    'bt_create_account' => "Een account aanmaken",
    'bt_create_dir' => "Een map toevoegen",
    'bt_create_file' => "Een bestand toevoegen",
    'bt_count_size' => "Omvang berekenen",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Takenrooster",
    'bt_custom_button_new' => "Een knop toevoegen",
    'bt_custom_buttons' => "Eigen knoppen",
    'bt_customize' => "Aanpassen",
    'bt_databases' => "Databases",
    'bt_database_servers' => 'Database-servers',
    'bt_sqlservers' => "Database-servers",
    'bt_db_usr_new' => "Een database-gebruiker toevoegen",
    'bt_db_new' => "Een database toevoegen",
    'bt_db_phpmyadmin' => "Beheer van MySQL",
    'bt_dbuser_default' => "Instellen als standaard voor DB Webadmin",
    'bt_decline' => "Afwijzen",
    'bt_default' => "Standaard",
    'bt_defaultcomponents' => "Diensten van andere bedrijven",
    'bt_defaults' => "Standaarden",
    'bt_delete' => "Verwijderen",
    'bt_directories' => "Afgeschermde mappen",
    'bt_disable' => "Uitschakelen",
    'bt_dns' => "DNS-instellingen",
    'bt_dns_add' => "DNS-record toevoegen",
    'bt_dnsrecord_add' => 'DNS-record toevoegen',
    'bt_dns_soa' => "Sjabloon voor SOA-records",
    'bt_dns_zone_settings_template' => "Zone-instellingssjabloon",
    'bt_dns_preferences' => "DNS-recursie",
    'bt_do_backup' => "Reservekopieën",
    'bt_do_restore' => "Terugplaatsen",
    'bt_do_upload' => "Uploaden",
    'bt_domain_aliases' => "Domeinaliassen",
    'bt_domain_templates' => "Domeinsjablonen",
    'bt_domain_user' => "Domeinbeheerder",
    'bt_domain_user_passwd' => "Wachtwoord domeinbeheerder",
    'bt_domains' => "Domeinen",
    'bt_domain_alias_add' => 'Domeinalias toevoegen',
    'bt_download' => "Downloaden",
    'bt_download_log' => "Downloaden",
    'bt_edit' => "Bewerken",
    'bt_enable' => "Inschakelen",
    'bt_export' => 'Exporteren',
    'bt_extras' => "Extras",
    'bt_file_manager' => "Bestandsbeheer",
    'bt_finish' => "Voltooien",
    'bt_ftp_account' => "Eigenschappen FTP-account",
    'bt_forget_password' => "Wachtwoord vergeten?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS-webadmin",
    'bt_fp_webadmin' => "FP-webbeheer",
    'bt_ftp_stats' => "FTP-stats",
    'bt_get_password' => "Wachtwoord ophalen",
    'bt_global_changes' => "Aanpassen",
    'bt_help' => "Contact",
    'bt_hide_aliases' => "Aliassen verbergen",
    'bt_hide_toolbar' => 'Werkbalk verbergen',
    'bt_hide_subdomains' => "Subdomeinen verbergen",
    'bt_hide_domainaliases' => "Domeinaliassen verbergen",
    'bt_home' => "Startpagina",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Installeren",
    'bt_ip_aliasing' => "IP-adressen",
    'bt_ip_add' => "IP-adres toevoegen",
    'bt_ip_pool' => "IP-voorziening",
    'bt_key_info' => "Licentiebeheer",
    'bt_key_buyonline_addons' => 'Uitbreidingen voor Plesk bestellen',
    'bt_key_buyonline_upgrades' => 'Upgrades voor Plesk bestellen',
    'bt_key_buyonline_new' => 'Nieuwe sleutel bestellen',
    'bt_key_update' => 'Sleutels ophalen',
    'bt_key_upload' => 'Sleutel installeren',
    'bt_key_download' => 'Sleutel downloaden',
    'bt_key_revert' => 'Sleutel terugplaatsen',
    'bt_limits' => "Beperkingen",
    'bt_locale_add' => 'Regio toevoegen',
    'bt_locales' => 'Landinstellingen',
    'bt_log_manager' => "Logbeheer",
    'bt_login' => "Aanmelden",
    'bt_login_vzpp' => "Aanmelden bij Power Panel",
    'bt_logo' => "Branding",
    'bt_logo_default' => "Standaardlogo",
    'bt_logo_send_link' => "Link bijsluiten",
    'bt_logo_send_logo' => "Logo bijsluiten",
    'bt_logout' => "Afmelden",
    'bt_logrotation' => "Logopschoning",
    'bt_mail' => "Mail",
    'bt_mail_alias_add' => "Mail-alias toevoegen",
    'bt_mail_aliases' => "Mailaliassen",
    'bt_mail_group_add' => "Lid toevoegen",
    'bt_mail_groups' => "Groepen",
    'bt_mail_name_add' => "Mailaccount toevoegen",
    'bt_mail_preferences' => "Instellingen",
    'bt_mail_group' => "Mailgroep",
    'bt_mail_mailbox' => "Postvak",
    'bt_mail_redirect' => "Doorstuuradres",
    'bt_mail_resp_add' => "Automatische beantwoording toevoegen",
    'bt_mail_resp_attach_add' => "Bijlage toevoegen",
    'bt_mail_resp_files' => "Bijlagen",
    'bt_mail_responders' => "Automatische beantwoordingen",
    'bt_mail_spamfilter' => "Spamfilter",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Verzendlijst toevoegen",
    'bt_maillists' => "Verzendlijsten",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Reservekopie maken",
    'bt_manage' => "Beheer",
    'bt_master' => "Primair",
    'bt_migrate' => 'Migreren',
    'bt_modules_add' => 'Extensie toevoegen.',
    'bt_modules_manage' => 'Extensies beheren',
    'bt_move' => "Verplaatsen",
    'bt_mimetypes' => 'MIME-typen',
    'bt_mimetype_new' => 'MIME-type toevoegen',
    'bt_new_client' => "Cliëntaccount toevoegen",
    'bt_new_domain' => "Domein toevoegen",
    'bt_next' => "Volgende >>",
    'bt_next_page' => "Volgende",
    'bt_network_add' => "Netwerk toevoegen",
    'bt_notifications' => "Meldingen",
    'bt_odbc_dsn_add' => "ODBC DSN toevoegen",
    'bt_off' => "Uit",
    'bt_on' => "Aan",
    'bt_on_off' => "Aan/Uit",
    'bt_pd_new' => "Afgeschermde map toevoegen",
    'bt_pd_user_new' => "Gebruiker toevoegen",
    'bt_performance' => 'Prestaties',
    'bt_permissions' => "Rechten",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Instellingen",
    'bt_prev_page' => "Vorige",
    'bt_preview' => 'Voorbeeld van Site',
    'bt_print' => "Afdrukken",
    'bt_reboot' => "Opnieuw opstarten",
    'bt_reload' => "Opnieuw laden",
    'bt_refresh' => "Vernieuwen",
    'bt_register' => "Registreren",
    'bt_remove' => "Verwijderen",
    'bt_enable_selected' => 'Inschakelen',
    'bt_disable_selected' => 'Uitschakelen',
    'bt_repair_ip' => "IP herstellen",
    'bt_report' => "Verslag",
    'bt_report_auto' => 'Verslagbezorging',
    'bt_report_auto_new' => 'Bezorgrooster toevoegen',
    'bt_report_new' => "Opmaak toevoegen",
    'bt_reset' => "Resetten",
    'bt_restart_services' => "Beheer diensten",
    'bt_save' => "Opslaan",
    'bt_send_by_email' => "Versturen per e-mail",
    'bt_send_file' => "Bestand versturen",
    'bt_send_mail' => "Mailbericht versturen",
    'bt_send_passwd' => "Wachtwoord versturen",
    'bt_send_text' => "Tekst versturen",
    'bt_server' => "Server",
    'bt_server_add' => "Server toevoegen",
    'bt_server_preferences' => "Server-instellingen",
    'bt_servers_list' => "Servers",
    'bt_sessions' => "Sessies",
    'bt_set' => "Instellen",
    'bt_set_as_default' => "Als standaard instellen",
    'bt_setup' => 'Instellingen',
    'bt_show_aliases' => "Aliassen tonen",
    'bt_show_subdomains' => "Subdomeinen tonen",
    'bt_show_domainaliases' => "Domeinaliassen tonen",
    'bt_shutdown' => "Uitschakelen",
    'bt_site_apppkgs' => "Toepassingopslag",
    'bt_site_apppool' => "Toepassingsvoorziening",
    'bt_application-pool' => "Webtoepassingen",
    'bt_site_apps' => "Webtoepassingen",
    'bt_site_app_add' => "Toepassing installeren",
    'bt_additional_key_upload' => 'Nieuwe sleutel uploaden',
    'bt_additional_key_download' => 'Sleutel downloaden',
    'bt_additional_key_remove' => 'Sleutel verwijderen',
    'bt_additional_key_activate' => 'Activeren',
    'bt_site_builder' => "Presence Builder-ondersteuning",
    'bt_skeleton' => 'Sjabloon voor virtuele hosts',
    'bt_skins' => 'Thema\'s',
    'bt_skin_add' => 'Thema toevoegen',
    'bt_skin_manual' => 'Handleiding Aangepaste thema\'s voor Plesk', // not used
    'bt_skin_download' => 'Thema downloaden',
    'bt_skin_replace' => 'Thema bijwerken',
    'bt_skip' => 'Overslaan',
    'bt_spamassassin' => "Spamfilter",
    'bt_spamassassin_train' => "Training",
    'bt_spamfilter' => "Spamfilter",
    'bt_sshterm' => 'SSH Terminal',
    'bt_start' => "Starten",
    'bt_stop' => "Stoppen",
    'bt_recycle' => "Recyclen",
    'bt_statistics' => "Statistieken",
    'bt_subdomain_new' => "Subdomein toevoegen",
    'bt_subdomains' => "Subdomeinen",
    'bt_submit' => "Versturen",
    'bt_summary_report' => "Samenvattend verslag",
    'bt_support' => "Ondersteuning",
    'bt_switch' => "Overschakelen",
    'bt_system_time' => "Systeemtijd",
    'bt_task_new' => "Nieuwe taak toevoegen",
    'bt_dom_tmpl_add' => 'Een domeinsjabloon toevoegen',
    'bt_cl_tmpl_add' => 'Een cliëntsjabloon toevoegen',
    'bt_cron_backup' => 'Instellingen van ingeroosterde reservekopieën',
    'bt_test' => "Verbinding testen",
    'bt_text' => "Tekst",
    'bt_touch' => "Tijdstempel wijzigen",
    'bt_traffic' => "Dataverkeer",
    'bt_traffic_history' => "Overzicht van verbruikt dataverkeer",
    'bt_tsclient' => "Extern bureaublad",
    'bt_update' => "Bijwerken",
    'bt_upload' => "Uploaden",
    'bt_upload_from_ftp' => "Uploaden met FTP",
    'bt_virtualdirs' => 'Virtuele mappen',
    'bt_virtualdir_new' => 'Virtuele map toevoegen',
    'bt_virtualdir_add' => 'Virtuele map toevoegen',
    'bt_web_app_new' => "Java-toepassing installeren",
    'bt_web_stats' => "Webstats",
    'bt_web_stats_ssl' => "SSL/TLS-webstatistieken",
    'bt_web_user_add' => "Webgebruiker toevoegen",
    'bt_web_users' => "Webgebruikers",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "Instellingen voor webstatistieken",
    'bt_hidden-referrer-add' => 'Ingangen verbergen',
    'bt_group-referrer-add' => 'Verwijzingen samenvoegen',
    'bt_whats_new_full' => "Bekijk de volledige lijst met wijzigingen",
    'bt_white_list' => "Witte lijst",
    'bt_white_list_add' => "Netwerk toevoegen",
    'cert_add__unable_set_ca_cert' => "Kan CA-certificaat niet instellen: %1",
    'cert_add__unable_set_cert' => "Kan certificaat niet instellen: %1",
    'cert_add__unable_set_private_key' => "Kan private sleutel niet instellen: %1",
    'certificates_list__certificate_used_as_default' => "Een van de certificaten die u gaat verwijderen wordt gebruikt als het standaardcertificaat.",
    'certificates_list__certificates_assigned_on_ip' => "er zijn één of meer certificaten toegewezen aan de IP-adressen/domeinen.",
    'ch_pass__admin_pass' => "Wachtwoord van beheerder wijzigen",
    'ch_pass__old_pass' => "Oud wachtwoord",
    'ch_pass__pass_confirm' => "Bevestigen",
    'ch_pass__unable_change_admin_pass' => "Kan het wachtwoord van de beheerder niet wijzigen:%1",
    'check_mail_cycle__aliases' => "Mailcycling is geconstateerd, het adres \"%1\" is opgenomen in de aliassen van dit mailaccount.",
    'check_mail_cycle__autoresponders' => "Oneindig rondsturen van mail vastgesteld: het adres \"%1\" is opgenomen in de automatische beantwoordingen van dit mailaccount.",
    'check_mail_cycle__mail_groups' => "Mailcycling is geconstateerd, het adres \"%1\" is opgenomen in de mailgroep van dit mailaccount.",
    'check_mail_cycle__mail_name' => "Mailcycling is geconstateerd, het adres \"%1\" valt samen met dit mailaccount.",
    'check_mail_cycle__redirect' => "Oneindig rondsturen van mail vastgesteld: het adres '%1' valt samen met het doorstuuradres van dit mailaccount.",
    'check_mail_dup__redirect' => "Dubbele doorschakeling gedetecteerd: het adres \"%1\" valt samen met het doorstuuradres van dit mailaccount.",
    'check_mail_dup__mail_groups' => "Dubbele doorschakeling gedetecteerd: het adres \"%1\" valt binnen de mailgroep van dit mailaccount.",
    'check_maillist_cycle__admin' => "Oneindig rondsturen van mail vastgesteld: het e-mailadres \"%1\" van de beheerder valt samen met het adres van verzendlijst.",
    'check_maillist_cycle__member' => "Oneindig rondsturen van mail vastgesteld: het adres \"%1\" valt samen met het adres van verzendlijst.",
    'chk_js__enter_login_and_passwd' => "Gebruikersnaam en wachtwoord invoeren.",
    'chk_js__enter_login_name' => "Gebruikersnaam invoeren.",
    'chk_js__enter_passwd' => "Voer wachtwoord in.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1's accountdetails",
    'cl_limits__cl' => "Beperkingen van cliënt %1",
    'cl_logo__setup_logo_pref' => "Eigenschappen instellen voor logo van cliënt %1",
    'cl_new__enter_new_cl_data' => "De gegevens van nieuwe cliënt invoeren",
    'cl_new__unable_to_sent_notification' => 'Het gebruikeraccount is aangemaakt, maar het verzenden van een melding aan de cliënt is mislukt: %1',
    'cl_perm__all_ip' => "Alle beschikbare IP's",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Alle IP-gebaseerde hostingaccounts van de cliënt zullen worden omgezet naar naamgebaseerde accounts.",
    'cl_perm__allow_client_create_domain' => "De velden die u wilt selecteren zijn alleen van toepassing voor cliënten die domeinen mogen aanmaken.",
    'cl_perm__allow_create_nb_w_ip' => "Cliënt kan naamgebaseerde hosting aanmaken door middel van %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Toestaan van IP-gebaseerd aanmaken van hostingaccounts",
    'cl_perm__available_ips' => "Beschikbare IP's",
    'cl_perm__change_limits' => "Aanpassing van beperkingen",
    'cl_perm__cl_disk_space' => "Totale schijfruimte beschikbaar",
    'cl_perm__cl_expiration' => "Geldigheidsduur van cliëntaccount",
    'cl_perm__cl_max_box' => "Postvakken",
    'cl_perm__cl_max_db' => "Databases",
    'cl_perm__cl_max_dom' => "Domeinen",
    'cl_perm__cl_max_maillists' => "Verzendlijsten",
    'cl_perm__cl_max_subdom' => "Subdomeinen",
    'cl_perm__cl_max_traffic' => "Totale hoeveelheid beschikbaar dataverkeer",
    'cl_perm__cl_max_wu' => "Webgebruikers",
    'cl_perm__cl_mbox_quota' => "De maximale omvang van postvakken binnen dit gebruikeraccount",
    'cl_perm__current_maximum_exp_date' => "De huidige maximumwaarde voor geldigheidsduur van het domein is %1; gevraagd %2.",
    'cl_perm__current_maximum_mailbox_quota' => "De maximale hoeveelheid schijfruimte die momenteel kan worden gereserveerd voor postvakken binnen dit gebruikeraccount is %1; gevraagd %2",
    'cl_perm__current_total_requested' => "Het huidige maximumaantal domeinen voor %1 is %2; gevraagd %3.",
    'cl_perm__current_total_requested_dom' => "Het huidige aantal %1 van deze cliënt is %2; gevraagd %3.",
    'cl_perm__disk_space' => "maximale omvang van schijfruimte",
    'cl_perm__dashboard_stdgui' => 'Gebruikerscherm',
    'cl_perm__dashboard' => 'Startpaginaweergave',
    'cl_perm__stdgui' => 'Standaardbeeld',
    'cl_perm__manage_dashboard' => 'Beheer van startpagina',
    'cl_perm__dashboard_and_stdgui' => 'Startpaginaweergave en standaardweergave zijn beide toegestaan',
    'cl_perm__dashboard_only' => 'Alleen de startpaginaweergave is toegestaan',
    'cl_perm__stdgui_only' => 'Alleen de standaardweergave is toegestaan',
    'cl_perm__edit_cl' => "Rechten van cliënt %1",
    'cl_perm__exp_date_exceeded' => "De geldigheidsperiode die u probeert in te stellen overschrijdt de beperking die is opgegeven voor individuele domeinen die bij deze cliënt horen.",
    'cl_perm__invalid_value' => "Ongeldige waarde, alleen getallen zijn toegestaan.",
    'cl_perm__limit_disk_space' => "%1 Beperk de totale hoeveelheid schijfruimte",
    'cl_perm__limit_expiration' => "%1 Beperk de geldigheidsduur van cliëntaccount",
    'cl_perm__limit_max_box' => "%1 Beperk het maximaal aantal postvakken",
    'cl_perm__limit_max_db' => "%1 Beperk het maximaal aantal databases",
    'cl_perm__limit_max_dom' => "%1 Beperk het maximaal aantal domeinen",
    'cl_perm__limit_max_maillists' => "%1 Beperk het maximaal aantal verzendlijsten",
    'cl_perm__limit_max_subdom' => "%1 Beperk het maximaal aantal subdomeinen",
    'cl_perm__limit_max_traffic' => "%1 Beperk de totale hoeveelheid dataverkeer",
    'cl_perm__limit_max_wu' => "%1 Beperk het maximaal aantal webgebruikers",
    'cl_perm__limit_mbox_quota' => "%1 Stel de postvakbeperking in",
    'cl_perm__limits_exceeded' => "Eén of meer beperkingen die u wilt instellen overschrijden nu al de beperkingen die zijn vastgesteld voor individuele domeinen van deze cliënt. \nDe totale beperking voor de cliënt moet groter of gelijk zijn aan de totale som van de domeinbeperkingen die voor dit cliëntaccount zijn ingesteld.",
    'cl_perm__mailbox_quota_exceeded' => "De beperking van de schijfruimte die u probeert te in te stellen voor postvakken overschrijdt de beperking die is ingesteld binnen individuele domeinen die bij dit cliëntaccount horen.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "De beperking die u probeert in te stellen voor de hoeveelheid schijfruimte die u kunt toewijzen aan postvakken overschrijdt de beperking die vanaf serverniveau wordt opgelegd.",
    'cl_perm__make_dumps' => "Reservekopie maken en gegevens terugplaatsen",

    'cl_perm__max_box' => "maximaal aantal postvakken",
    'cl_perm__max_db' => "maximaal aantal databases",
    'cl_perm__max_dom' => "Domeinen",
    'cl_perm__max_maillists' => "maximaal aantal verzendlijsten",
    'cl_perm__max_subdom' => "Subdomeinen",
    'cl_perm__max_traffic' => "maximale hoeveelheid dataverkeer",
    'cl_perm__max_wu' => "maximaal aantal webgebruikers",
    'cl_perm__max_dom_aliases' => "domeinaliassen",
    'cl_perm__mbox_quota' => "postvakbeperking",
    'cl_perm__not_allow_create_nb_hst' => "Cliënt kan geen naamgebaseerde hosting aanmaken.",
    'cl_perm__select_ip_addrs' => "Selecteer IP-adressen",
    'cl_perm__this_ip_used_vrt_hst' => "Dit IP-adres wordt gebruikt voor virtuele hosting.\nOm dit IP-adres te wissen, verwijdert u de hostingdienst of verandert u het type naar Naamgebaseerd.",
    'cl_perm__unable_off_ipb_creating' => "Er is al IP-gebaseerde hosting ingesteld voor de cliënt. Om deze mogelijkheid uit te schakelen voor de cliënt, zorgt u dat het selectievakje \"Domein aanmaken\" niet is geselecteerd of verwijdert u alle IP-gebaseerde hostingaccounts.",
    'cl_perm__unable_off_nb_creating' => "Er is al naamgebaseerde hosting ingesteld voor de cliënt. Om deze mogelijkheid uit te schakelen voor de cliënt, zorgt u dat het selectievakje \"Domein aanmaken\" niet is geselecteerd of verwijdert u alle naamgebaseerde hostingaccounts.",
    'cl_perm__unable_set_domain_limit' => "Kan het maximaal aantal domeinen niet beperken: cliënt heeft al %1 domeinen",
    'cl_perm__unable_update_client_limitations' => "Kan beperkingen voor cliëntaccount niet wijzigen: %1",
    'cl_pref__edit_cl' => "Voorkeuren van cliënt %1",
    'class_anonftp__create_ftp_domain' => "Geen virtueel FTP-domein voor dit dom_id, probeer het eerst aan te maken.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "De schijfruimtebeperking die u probeert in te stellen (%1) mag niet groter zijn dan de totale schijfruimte die op domeinniveau is vastgelegd (%2).",
    'class_anonftp__invalid_input_only_digits' => "Ongeldige waarde opgegeven, alleen cijfers zijn toegestaan.",
    'class_anonftp__unable_change_ownerships' => "Kan eigendom of rechten voor het quotabestand niet wijzingen: %1",
    'class_anonftp__unable_copy_quota_file' => "Kan quotabestand niet kopiëren: %1",
    'class_anonftp__unable_get_disk_usage' => "Kan geen informatie over schijfgebruik van de inkomende map ophalen: %1",
    'class_anonftp__unable_parse_quota_file' => "Kan het quotabestand niet verwerken.",
    'class_anonftp__unable_read_quota_file' => "Kan het quotabestand niet lezen: %1",
    'class_anonftp__unable_update_quota' => "Kan de beperking niet aanpassen: de bestanden in de inkomende map gebruiken %1 KBs schijfruimte, wat meer is dan het nieuwe opgegeven quotum.",
    'class_anonftp__unable_write_temp_file' => "Kan niet schrijven naar het tijdelijke bestand: %1",
    'class_bsdomain__warn_max_date__' => "De verloopdatum is ingesteld op %1",
    'class_cList__empty' => "Geen onderdelen.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Geen overeenkomsten gevonden voor <b>\"%1\"</b> in %2 (%3 van %4).",
    'class_cList__search_result' => "Zoekresultaten voor <b>\"%1\"</b> in %2 (%3 van %4).",
    'class_client__client_creation_notification' => "Melding bij aanmaken cliënt.",
    'class_client__client_with_contact_name_already_exists' => "Er bestaat al een cliënt met de naam %1.",
    'class_client__disk_space' => "Schijfruimte",
    'class_client__invalid_max_dom' => "Ongeldige waarde voor domeinaantal, alleen cijfers zijn toegestaan.",
    'class_client__limit_exceed' => "De gevraagde hoeveelheid %1 kan niet worden toegewezen om dit de toewijzing van middelen voor het account van cliënt %2 (%3) zou overschrijden. Als u meer middelen wilt toewijzen, gaat u naar Cliënten > naam van cliënt > Beperkingen en wijzigt u de toegewezen middelen. Keer vervolgens terug naar dit scherm en probeer opnieuw om de middelen te wijzigen.",
    'class_client__limit_exceed_unlimited' => "Als u een onbeperkte hoeveelheid middelen wilt toewijzen (%1), gaat u eerst naar Cliënten > naam van cliënt > Beperkingen en selecteert u op de juiste plaats het selectievakje Onbeperkt. Keer vervolgens terug naar deze pagina en probeer opnieuw om de toegewezen middelen te wijzigen.",
    'class_client__max_box' => "Postvakken",
    'class_client__max_db' => "Databases",
    'class_client__max_maillists' => "Verzendlijsten",
    'class_client__max_subdom' => "Subdomeinen",
    'class_client__max_traffic' => "Maximaal dataverkeer",
    'class_client__max_wu' => "Webgebruikers",
    'class_client__max_dom_aliases' => "Domeinaliassen",
    'class_client__mbox_quota' => "Postvakbeperking",
    'class_client__unable_define_cl_status' => "Kan status van cliëntaccount niet vaststellen: %1",
    'class_client__unable_define_inactive_dom' => "Kan inactieve domeinen niet definiëren: %1.",
    'class_client__unable_del_ip' => "Kan de IP's niet verwijderen: %1",
    'class_db__db_name_not_set' => "Databasenaam is niet opgegeven.",
    'class_db__db_not_exist_for_curr_dom' => "De database bestaat niet voor dit domein.",
    'class_db__invalid_db_or_dom_name' => "Het kenmerk van het domein of de database is ongeldig of de databasenaam is niet opgegeven.",
    'class_db__invalid_pass' => "Het wachtwoord is ongeldig.",
    'class_db__mailgrp_member_exist' => "Dit mailgroeplid bestaat al.",
    'class_db__access_hosts_notsupport' => 'Toegang tot hostinstellingen wordt niet ondersteund voor dit databasetype',
    'class_db__unable_add' => 'Kan toegangshostrecord niet toevoegen: %1',
    'class_db__unable_del' => 'Kan toegangshostrecord niet verwijderen: %1',
    'class_db__inc_user_not_exist' => 'Databasegebruiker "%1" bestaat niet',
    'class_db__inc_access_record_exist' => 'Dit toegangsrecord bestaat al',
    'class_db__inc_access_record_not_exist' => 'Opgegeven toegangsrecord bestaat niet',
    'class_db__inc_unable_del_last_record' => 'Kan het laatste hosttoegangsrecord niet verwijderen',
    'class_domtmpleditform__dns_master' => "Primair",
    'class_domtmpleditform__dns_slave' => "Secundair",
    'class_domtmpleditform__dns_type' => "Type domein DNS-zone",
    'class_traffichistory__no_data_available' => "Geen gegevens beschikbaar.",
    'class_traffichistory__reten_pref' => 'Instellingen voor het bewaren van web- en dataverkeerstatistieken',
    'class_traffichistory__traffic_usage' => "Dataverkeerverbruik",
    'clienttrafficlist_header' => "Dataverkeer van domeinen",
    'clienttrafficlist_header_of_client__' => "Dataverkeer van de domeinen van cliënt %1",
    'cmd_dns__a_dns_record_already_exist' => "Dit record zal in conflict zijn met het A-record voor zone.",
    'cmd_dns__domain_has_no_ns' => 'Domein heeft geen NS DNS-record',
    'cmd_dns__domain_last_ns' => 'Het laatste NS-record van een domein kan niet worden verwijderd.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Canonieke domeinnaam is ongeldig.",
    'cmd_dns__cname_dns_record_already_exist' => "Dit record zal in conflict zijn met het CNAME-record voor zone.",
    'cmd_dns__cname_in_rr_combination' => 'Er is een incorrecte combinatie van DNS-records in de zone aanwezig',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS-zonerecord kan niet tegelijk bestaan met andere DNS-records in dezelfde zone.',
    'cmd_dns__dns_record_type_is_invalid' => "Type DNS-record is ongeldig.",
    'cmd_dns__ext_host_is_not_resolved' => "De canonieke naam %1 kan niet worden herleid tot een A- of AAAA-record.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Kan het record %1 niet toevoegen aan zone %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Naam mailexchanger is ongeldig.",
    'cmd_dns__mx_priority_is_invalid' => "MX-prioriteit is ongeldig.",
    'cmd_dns__name_server_is_invalid' => "Naamserver is ongeldig.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "De waarde van het netwerkmasker moet 24, 16 of 8 zijn.",
    'cmd_dns__this_dns_record_already_exists' => "Er bestaat al een dergelijk A DNS-record.",
    'cmd_dns__unable_add_record' => "Kan '%1' record niet toevoegen: %2",
    'cmd_dns__unable_add_a_record' => "Kan A-record niet toevoegen: %1",
    'cmd_dns__unable_add_cname_record' => "Kan CNAME-record niet toevoegen: %1",
    'cmd_dns__unable_add_dns_record' => "Kan geen DNS-record toevoegen: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Kan EXT_NS-record niet toevoegen: %1",
    'cmd_dns__unable_add_ns_record' => "Kan NS-record niet toevoegen: %1",
    'cmd_dns__unable_add_ptr_record' => "Kan PTR-record niet toevoegen: %1",
    'cmd_dns__unable_add_txt_record' => "Kan TXT-record niet toevoegen: %1",
    'cmd_dns__unable_create_dns_zone' => "Kan DNS-zone niet aanmaken %1",
    'cmd_dns__unable_define_dns_record' => "Kan DNS-record %1 niet definiëren.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Kan de status van de standaard DNS-zone niet ontvangen: %1",
    'cmd_dns__unable_insert_a_record' => "Kan A-record niet invoegen: %1",
    'cmd_dns__unable_insert_mx_record' => "Kan MX-record niet invoegen: %1",
    'cmd_dns__unable_insert_ns_record' => "Kan NS-record niet invoegen: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Kan status van DNS-zone niet instellen: %1",
    'cmd_domains__dom_already_exists' => "Domein %1 bestaat al.",
    'cmd_domains__dns_record_already_exists' => "Kan het domein %1 niet aanmaken omdat er al een record bestaat dat verwijst naar de host %1.",
    'cmd_domains__dom_already_exists1' => "Er zijn %2 subdomeinen voor dit domein. Domein %1 bestaat al.",
    'cmd_domains__dom_already_exists2' => "het subdomein %1 bestaat al.",
    'cmd_domains__dalias_already_exists' => "Dit alias bestaat al.",
    'cmd_domains__domain_alias_already_exists' => 'Er bestaat al een domeinalias met deze naam.',
    'cmd_domains__unable_del_mail_for_dom' => "Kan de maildienst niet verwijderen van domein: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Kan anoniem FTP-account niet verwijderen voor domein: %1",
    'cmd_domains__unable_update_dom_param' => "Kan de waarden van het domein niet aanpassen: %1.",
    'cmd_domains__unable_rename_client_exist' => "gebruikersnaam van domeinbeheerder is al in gebruik.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Type hosting is niet fysiek.",
    'cmd_hosting__unable_create_user' => "Kan gebruiker %2 niet aanmaken: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Kan IP-adres voor naamgebaseerde virtuele hosts niet definiëren: %1",
    'cmd_hosting__unable_del_old_hst' => "Kan de voorheen ingestelde hosting niet verwijderen: %1",
    'cmd_hosting__unable_del_protected_directory' => "Kan afgeschermde map niet verwijderen: %1.",
    'cmd_hosting__unable_del_web_user' => "Kan webgebruiker niet verwijderen: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Kan de virtuele host niet aanmaken of aanpassen: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Kan hosting niet instellen met doorschakelen via frame.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Kan het proftpd-configuratiebestand niet opnieuw aanmaken: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Kan SSL/TLS niet instellen: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Kan het wachtwoord niet verwijderen van de SSL/TLS-map: %1",
    'cmd_hosting__unable_update_dest_url' => "Kan de URL van bestemming %1 niet bijwerken.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Kan de DNS-zone voor het domein niet bijwerken: uitvoering van het hulpprogramma is mislukt.",
    'cmd_hosting__unable_update_ftp_passwd' => "Kan FTP-wachtwoord niet bijwerken %1.",
    'cmd_hosting__unable_update_user' => "Kan gebruiker %2 niet aanpassen: %1",
    'cmd_hosting__unknown_hst_type' => "Onbekend type hosting.",
    'cmd_hosting__you_not_have_permission_del_hst' => "U beschikt niet over de rechten om de hostingdienst te beëindigen.",
    'cmd_mail__autoresponder__not_configured' => "Automatische beantwoording voor dit mailaccount is niet geconfigureerd",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Adres %1 wordt al gebruikt voor het doorsturen van mail.",
    'cmd_mail__alias_already_exists' => "alias bestaat al.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID's van automatische beantwoording en mailaccount komen niet overeen.",
    'cmd_mail__autoresp_id_is_undefined' => "ID van automatische beantwoording is niet ingesteld.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Er bestaat al een mailalias met deze naam voor het mailaccount %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Mailaccount %1 is al abonnee van deze verzendlijst.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Mailaccount %1 bestaat al binnen dit domein.",
    'cmd_mail__mail_name_not_exist' => "Het mailaccount bestaat niet.",
    'cmd_mail__mail_name_passwd_part' => "Het wachtwoord mag niet de naam van het mailaccount bevatten.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Verzendlijst %1 bestaat al binnen dit domein.",
    'cmd_mail__mailname_already_exist_in_mg' => "Mailaccount %1 hoort al tot een mailgroep.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Mailaccount %1 bestaat al binnen dit domein.",
    'cmd_mail__mailname_already_exists' => "Mailaccount bestaat al.",
    'cmd_mail__mailname_is_invalid' => "De naam van mailaccount %1 is ongeldig.",
    'cmd_mail__mailname_unable_update' => "Kan de eigenschappen van het mailaccount niet bijwerken:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Het maximaal aantal automatische beantwoordingen is bereikt voor dit domein.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Maximaal aantal mailgroepen is bereikt voor dit domein.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Maximaal aantal doorstuuradressen is bereikt voor dit domein.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Maximaal aantal postvakken is bereikt.",
    'cmd_mail__no_members_specified' => "geen leden opgegeven.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Het wachtwoord is te simpel, kies een ander wachtwoord.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Het e-mailadres is al in gebruik.",
    'cmd_mail__unable_define_autoresp_id' => "Kan kenmerk %1 van automatische beantwoording niet vaststellen.",
    'cmd_mail__unable_update_mail_for_dom' => "Het wijzigen van de instellingen van de maildienst voor domein %1 is mislukt",
    'cmd_mail__unable_del_mail_for_dom' => "Kan de mailcliënt niet verwijderen van domein %1.",
    'cmd_mail__unable_del_mail_redirection' => "Kan de dienst voor het doorsturen van e-mail %1 niet verwijderen.",
    'cmd_mail__unable_remove_autoresp' => "Kan automatische beantwoordingen niet verwijderen: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Kan de leden van de mailgroep niet verwijderen: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Uitschakelen van de mailgroep mislukt: %1",
    'cmd_mail__unable_update_mail_redirect' => "Kan het dienst voor het doorsturen van e-mail %1 niet instellen.",
    'cmd_mail__uploaded_file_is_too_big' => "Geüpload bestand is te groot.",
    'cmd_mail__additionally' => "Aanvullend:",
    'cmd_pd__invalid_login' => "Onjuiste gebruikersnaam.",
    'cmd_pd__this_user_already_exist' => "Er bestaat al een dergelijke gebruiker.",
    'cmd_pd__unable_define_hst_type' => "Kan type hosting niet definiëren.",
    'cmd_pd__unable_upd_pd_usr' => "Kan gebruikerseigenschappen van afgeschermde map niet aanpassen: %1.",
    'cmd_pd__user_is_undefined' => "Gebruiker is niet gedefinieerd.",
    'cmd_server__no_enough_free_disk_space' => "Onvoldoende schijfruimte.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "oud wachtwoord is onjuist. Probeert u het opnieuw.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "het maximaal aantal toegestane webgebruikers binnen dit domein is bereikt.",
    'cmd_web_usr__unable_create_user' => "kan systeemgebruiker niet aanmaken: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "kan de beperking van het maximale aantal webgebruikers niet definiëren: %1",
    'cmd_web_usr__user_already_exists' => "gebruiker bestaat al.",
    'cmd_web_usr__web_user_name_is_invalid' => "Webgebruikersnaam %1 is ongeldig.",
    'cmd_web_usr__web_user_not_exist' => "webgebruiker bestaat niet.",
    'common_func__exec_bad_argument' => "uitvoeringsargument mag geen apostrof bevatten.",
    'common_acl__add_address' => 'Toevoegen aan algemene ACL voor toestaan van zoneoverdracht',
    'common_acl_add_record' => 'Een ACL-record toevoegen',
    'enter_ip_or_network_address' => 'Voer een IP of netwerkadres in',
    '__eol' => 'Regelafbrekingen',
    'eol__binary_file' => 'Kan stijl van regelafbreking niet aanpassen in binair bestand.',
    'comp_info__header' => 'Componenten',
    'comp_info__comp_name' => "Componentnaam",
    'comp_info__comp_disabled' => 'Uitgeschakeld',
    'comp_info__comp_active' => 'Actief',
    'comp_info__comp_not_configured' => 'Niet ingesteld',
    'comp_info__comp_not_started' => 'Niet gestart, controleer de instellingen van de component',
    'comp_info__comp_version' => "Componentversie",
    'comp_info__integration_error' => "Fout bij integratie",
    'comp_info__title' => "Plesk-componenten",
    'comp_info__service_name' => "Dienst",
    'comp_info__last_updated' => '(laatste update: %1)',
    'configure__full_hostname' => "Volledige hostnaam",
    'cp_access_admin_deny' => "Toegang voor beheerder vanaf adres '%1' wordt beperkt in overeenstemming met het momenteel toegepaste IP-toegangrestrictiebeleid.",
    'create_domain_warn__' => "Tijdens aanmaken van domein vonden de volgende uitzonderingen plaats:",
    'create_domain__client_select' => 'Selecteer de cliënt om het domein voor aan te maken',

    'dashboard__nav_button_name' => "Startpagina",
    'dalias__list_title' => 'Domeinaliassen van het domein %1',
    'dalias__list_legend' => 'Domeinaliassen',
    'dalias__list_header' => 'Domeinaliassen',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Naam domeinalias',
    'dalias__list_ascii_name' => 'In ASCII-formaat',
    'dalias__remove_title' => 'De volgende domeinaliassen van het domein %1 zullen worden verwijderd:',
    'dalias__select_domain_aliases_to_remove' => 'Selecteer de domeinaliassen om te verwijderen.',
    'dalias__mail_turn_on_failed' => 'Kan maildienst niet inschakelen: %1',
    'dalias__web_turn_on_failed' => 'Kan webdienst niet starten: %1',
    'db_usr_edit__db_usr_name_old' => "Oude databasegebruikersnaam",
    'databases__db_title' => "Aanmeldgegevens van MS SQL Server-beheerder en hulpprogramma's",
    'databases__server_title' => "%1 wachtwoord van beheerder",
    'databases__connection' => "Verbinding",
    'databases__db_server' => "Servernaam",
    'databases__db_admin_login' => "Gebruikersnaam van beheerder",
    'databases__db_admin_passwd' => "Wachtwoord van beheerder",
    'databases__db_confirm_passwd' => "Bevestig wachtwoord",
    'databases__can_not_manage' => "U kunt geen database-server beheren",
    'databases__not_installed' => "(niet geïnstalleerd)",
    'databases__not_supported_license' => "(niet ondersteund door uw licentiesleutel)",
    'databases__title' => "Databasebeheer en aanmeldgegevens van beheerder",
    'databases__unable_connect' => "Geen toegang tot de database: onjuiste parameters.",
    'databases__incorrect_db_admin_login' => 'De gebruikersnaam kan alleen cijfers en letters, het verbindingsstreepje en de underscore bevatten en moet beginnen met een cijfer of letter.',
    'databases__incorrect_db_admin_passwd' => 'Het wachtwoord mag niet de gebruikersnaam bevatten.',
    'database_servers_form__title' => 'Database-servers',
    'database_servers_form__server_list_legend' => 'Database-servers',
    'database_servers_form__remove_empty_selection' => 'Geen database servers geselecteerd.',
    'database_servers_form__remove_title' => 'De volgende database servers zullen worden verwijderd:',
    'database_server_database_list__client' => 'Cliënt',
    'database_server_database_list__domain' => 'Domein',
    'database_server_database_list__header' => 'Databases',
    'database_server_database_list__name' => 'Naam',
    'database_server_databases_form__databases_list_legend' => 'Databases',
    'database_server_databases_form__remove_empty_selection' => 'Geen databases geselecteerd.',
    'database_server_databases_form__remove_title' => 'De volgende databases zullen worden verwijderd:',
    'database_server_databases_form__tab' => 'Databases (%1)',
    'database_server_edit_form__admin_login' => "Gebruikersnaam",
    'database_server_edit_form__admin_password' => "Wachtwoord",
    'database_server_edit_form__admin_password2' => "Bevestig wachtwoord",

    'database_server_edit_form__default' => 'Deze server gebruiken als standaard voor %1',
    'database_server_edit_form__duplicate' => 'Een database-server met deze combinatie van hostadres en poortnummer is reeds geregistreerd.',
    'database_server_edit_form__host' => 'Hostnaam of IP-adres',
    'database_server_edit_form__legend_authentication' => 'Verificatie',
    'database_server_edit_form__legend_general' => 'Algemeen',
    'database_server_edit_form__port' => 'Poortnummer',
    'database_server_edit_form__port_hint' => 'Laat leeg voor het standaard poortnummer',
    'database_server_edit_form__tab' => 'Database-server',
    'database_server_edit_form__title_new' => 'Nieuwe database-server',
    'database_server_edit_form__title_edit' => 'Database-server op %1',
    'database_server_edit_form__type' => 'Type database-server',
    'database_server_edit_form__unix_socket' => '(lokale verbinding)',
    'database_server_edit_form__external_connection' => 'Accepteren van externe verbindingen met de lokale MySQL-server toestaan',
    'database_server_edit_form__external_connection_hint' => 'Als u deze instelling wijzigt dan wordt de lokale MySQL-server opnieuw opgestart. Als u externe toegang tot andere in Plesk geregistreerde MySQL-servers wilt inschakelen, dan wijzigt u de instellingen daarvan met de hand.',
    'database_server_edit_form__external_connection__configured_to_local' => 'Lokale MySQL-server is ingesteld om externe verbindingen te weigeren',
    'database_server_edit_form__external_connection__configured_to_remote' => 'Lokale MySQL-server is ingesteld om externe verbindingen te accepteren',
    'database_server_error__consult_admin' => 'Neem contact op met de beheerder van de server.',
    'database_server_error__last__connection_failed' => 'De laatste poging om deze database-server te besturen is mislukt vanwege netwerkproblemen.',
    'database_server_error__last__permission_denied' => 'De laatste poging om deze database-server te besturen is mislukt omdat het opgegeven account niet beschikt over beheerderrechten.',
    'database_server_error__last__credentials_not_set' => "De laatste poging om verbinding te maken met deze server is mislukt omdat er geen geldige gebruikersnaam en wachtwoord voor de beheerder zijn opgegeven.",
    'database_server_error__last__other_error' => 'De laatste poging om de database-server te besturen is mislukt.',
    'database_server_error__real__connection_failed' => 'Connectie naar de database-server is mislukt vanwege netwerkproblemen:',
    'database_server_error__real__permission_denied' => 'Verbinding met de database-server is mislukt omdat het opgegeven account niet over beheerderrechten beschikt:',
    'database_server_error__real__duplicate_object' => 'Verbinding met de database-server is mislukt vanwege een naamconflict:',
    'database_server_error__real__unacceptable_name' => 'Verbinding met de database-server is mislukt vanwege een ongeldige objectnaam:',
    'database_server_error__real__unacceptable_password' => 'Verbinding met de database-server is mislukt vanwege een onacceptabel wachtwoord:',
    'database_server_error__real__credentials_not_set' => "Plesk kan geen verbinding maken met de database-server omdat er geen geldige gebruikersnaam en wachtwoord voor de beheerder zijn opgegeven.",
    'database_server_error__real__other_error' => 'Verbinding met de database-server is mislukt:',
    'database_server_error__test__connection_failed' => 'De testverbinding met de database-server is mislukt vanwege netwerkproblemen:',
    'database_server_error__test__permission_denied' => 'De testverbinding met de database-server is mislukt omdat het opgegeven account niet beschikt over beheersrechten:',
    'database_server_error__test__duplicate_object' => 'De testverbinding met de database-server is mislukt vanwege een naamconflict:',
    'database_server_error__test__unacceptable_name' => 'De testverbinding met de database-server is mislukt vanwege een ongeldige objectnaam:',
    'database_server_error__test__unacceptable_password' => 'De testverbinding met de database-server is mislukt vanwege een niet-acceptabel wachtwoord:',
    'database_server_error__test__credentials_not_set' => "De testverbinding met deze server is mislukt omdat er geen geldige gebruikersnaam en wachtwoord voor de beheerder zijn opgegeven.",
    'database_server_error__test__other_error' => 'De testverbinding met de database-server is mislukt:',
    'database_server_list__header' => 'Database-servers',
    'database_server_list__last_error' => 'S',
    'database_server_list__type' => 'Servertype',
    'database_server_list__host' => 'Hostnaam',
    'database_server_list__port' => 'Poort',
    'database_server_list__version' => 'versie',
    'database_server_list__dbcount' => 'Databases',
    'db__create_new_db' => "Een database toevoegen",
    'db__db_add' => "Database toevoegen",
    'db__db_for_dom' => "Databases van website %1",
    'db__db_id_undefined' => "Databasekenmerk is niet ingesteld.",
    'db__db_name' => "Databasenaam",
    'db__db_not_exist' => "Database bestaat niet.",
    'db__db_type' => "Type",
    'db__db_server' => "Database-server",
    'db_server_not_exist' => "Database-server bestaat niet.",
    'db__db_user_not_exist' => "Databasegebruiker bestaat niet.",
    'db__domain_not_exist' => "Domein bestaat niet.",
    'db__enter_db_name' => "Voer nieuwe database naam in.",
    'db__invalid_db_id' => "Database-identificatie is ongeldig.",
    'db__invalid_db_name' => "Databasenaam is ongeldig. De databasenaam mag alleen karakters uit het Latijnse alfabet, cijfers, de underscore of het verbindingsstreepje bevatten. Het mag niet langer zijn dan 63 karakters.",
    'db__max_db_reached_for_dom' => "De beperking van het aantal databases is bereikt voor dit domein.",
    'db__max_mssql_db_reached_for_dom' => "De beperking van het aantal Micrsoft SQL Server-databases is bereikt voor het domein",
    'db__postgres_not_connect_for_admin' => "Kan geen verbinding maken met PostgreSQL. Schakel ondersteuning voor PostgreSQL in op de beheerpagina van de server.",
    'db__postgres_not_connect_for_client' => "Kan geen verbinding maken met PostgreSQL. Vraag uw systeembeheer om hulp.",
    'db__remove_db_on_domain' => "De volgende databases van domein %2, behorend bij cliënt %1, zullen worden verwijderd:",
    'db__remove_db_on_domain_of_cl' => "De volgende databases van domein %2, behorend bij cliënt %1, zullen worden verwijderd:",
    'db__remove_db_linked_resource' => 'Deze database wordt gebruik door een webtoepassing en kan alleen worden verwijderd na het verwijderen van deze webtoepassing.',
    'db__remove_db_users' => "De volgende gebruikers van de database %3 van de website %2, die hoort bij cliënt %1, zullen worden verwijderd:",
    'db__remove_db_users_of_cl' => "De volgende gebruikers van de database %3 van de website %2, die hoort bij cliënt %1, zullen worden verwijderd:",
    'db__select_db_for_remove' => "Selecteer de databases om te verwijderen.",
    'db__select_db_users_for_remove' => "Selecteer de databasegebruikers om te verwijderen.",
    'db__unable_create_db_user' => "Kan de databasegebruiker niet aanmaken: %1",
    'db__unable_define_db_name' => "Kan de databasenaam niet definiëren: %1",
    'db__unable_define_db_user' => "Kan de databasegebruiker niet definiëren: %1",
    'db__unable_define_db_users' => "Kan databasegebruikers niet definiëren: %1",
    'db__unable_select_dom_name' => "Kan domeinnaam niet selecteren: %1",
    'db_edit__db_for_dom' => "Gebruikers voor database %1 op domein %2",
    'db_edit__invalid_db_name' => "De databasenaam is ongeldig.",
    'db_edit__no_users' => "Er zijn geen gebruikers met aanmeldgegevens voor deze database.",
    'db_edit__unable_define_db_usrs' => "Kan de databasegebruikers niet definiëren: %1",
    'db_edit__unable_select_db_usr' => "Kan de databasegebruiker niet selecteren.",
    'db_edit__db_user_password_for_' => "Voer het wachtwoord in om u aan te melden als databasegebruiker %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Databasegebruiker toevoegen",
    'db_usr_edit__db_usr_name' => "Gebruikersnaam voor database",
    'db_usr_edit__edit_db_usr' => "Aanmeldgegevens voor databasegebruikeraccount instellen",
    'db_usr_edit__for_db' => "voor %1 database",
    'db_usr_edit__not_create_pass' => "Deze bewerking zal leiden tot het aanmaken van een databasegebruikeraccount zonder wachtwoord.\nWilt u doorgaan met het aanmaken van een gebruiker zonder een wachtwoord toe te wijzen?",
    'dbuser__only_one_user_can_be_default' => "Er kan slechts één gebruiker als standaard worden ingesteld.",
    'db_server__cannot_delete_default' => "De standaarddatabase kan niet worden verwijderd.",
    'db_server__cannot_delete_local' => "De lokale database-server kan niet worden verwijderd.",
    'db_server__cannot_delete_used' => 'Een database-server kan niet worden verwijderd als er nog databases of databasegebruikers op worden gehost.',
    'demo__disabled_in_demo' => "Deze bewerking wordt niet ondersteund in de demonstratieversie.",
    'defaultcomponents__title' => "Standaardcomponenten aanwijzen",
    'defaultcomponents__select_default' => "Selecteer standaard %1-component",//to check
    'defaultcomponents__not_installed' => "(niet geïnstalleerd)",
    'defaultcomponents__not_configured' => "(niet ingesteld)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Sommige dienstcategorieën bevatten een ongeldige selectie, of er is geen selectie gemaakt.",
    'defaultcomponents__depends_on' => "(%1 vereist)",
    'defaultcomponents__parameters' => "Parameters van %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL-server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS-server",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "FTP-server",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Mailsever",
    'component_name__local_mailserver' => "Lokale mailserver",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Webscripting",
    'component_name__spamfilter' => "Spamfilter",
    'component_name__stats' => "Webstatistieken",
    'component_name__stunnel' => "SSL/TLS-wrapper",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Webpublishing",
    'component_name__webserver' => "Webserver",
    'dns__dns_zone_legend' => 'DNS-records',
    'dns__dns_record_invalid_values' => 'Er zijn onjuiste waarden voor DNS-records opgegeven: %1: %2',
    'dns__dns_zone_invalid_values' => 'Er zijn onjuiste parameters voor DNS-zone opgegeven.',

    'dns__soa_mname_title' => 'Primaire naamserver',
    'dns__soa_mname_legend' => 'Naam server',
    'dns__soa_mname_autoselect' => '(Automatische selectie)',

    'dns__dns_soa_title' => 'SOA-record',
    'dns__dns_zone_default' => 'Standaardwaarden van zone',
    'dns__dns_zone_settings_template_title' => 'Zone-instellingen',
    'dns__dns_soa_legend' => 'SOA-record',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'Vernieuwen',
    'dns__dns_soa_retry' => 'Nieuwe Poging',
    'dns__dns_soa_expire' => 'Verlopen',
    'dns__dns_soa_minimum' => 'Minimum',
    'dns__dns_soa_ttl_error' => 'TTL-waarde is onjuist; deze moet liggen tussen de 1 seconde en 68 jaar.',
    'dns__dns_soa_refresh_error' => 'Vernieuwingswaarde is ongeldig; deze moet liggen tussen de 1 seconde en 68 jaar.',
    'dns__dns_soa_retry_error' => 'De waarde voor opnieuw proberen is onjuist; deze moet liggen tussen de 1 seconde en 68 jaar.',
    'dns__dns_soa_expire_error' => 'Verloopwaarde is niet geldig; deze moet liggen tussen de 1 seconde en 68 jaar.',
    'dns__dns_soa_minimum_error' => 'Minimale waarde is onjuist; deze moet liggen tussen 1 seconde en 68 jaar.',
    'dns__dns_default_title' => 'De DNS-zone herstellen',
    'dns__dns_default_legend' => "Opties voor zoneherstel",
    'dns__dns_default_text' => "Kies instellingen voor het terugplaatsen van de DNS-zone, bevestig deze en klik op OK.",
    'dns__dns_default_confirm' => "Herstel van de DNS-zone bevestigen",
    'dns__dns_default_confirm_required' => "Bevestig het terugplaatsen van de DNS-zone",
    'dns__dns_default_invalid_ip_address' => 'Ongeldig IP-adres',

    'dns_t__dns_default_title' => 'Terugkeren naar het standaard DNS-zonesjabloon',
    'dns_t__dns_default_legend' => "Herstelopties",
    'dns_t__dns_default_text' => 'Bevestig dat u de standaardconfiguratie van het DNS-zonesjabloon wilt terugplaatsen.',
    'dns_t__dns_default_confirm' => "Bevestig herstel",
    'dns_t__dns_default_confirm_required' => "Bevestig het terugplaatsen van het DNS-zonesjabloon",
    'dns_t__dns_zone_off_remove_title' => "De volgende DNS-records voor DNS-zonesjabloon zullen worden verwijderd:",
    'dns_t__dns_zone_master_remove_title' => "De volgende DNS-records zullen worden verwijderd uit DNS-zonesjabloon:",
    'dns_t__add_dns_record_master_title' => 'DNS-record toevoegen aan het zonesjabloon',
    'dns_t__add_dns_record_off_title' => 'Naamserver toevoegen',
    'dns_t__edit_dns_record_master_title' => 'DNS-record bewerken',
    'dns_t__edit_dns_record_off_title' => 'Naamserver bewerken',
    'dns_t__select_record_to_remove' => "Selecteer records om uit het DNS-zonesjabloon te verwijderen",
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__unit_seconds' => 'seconden',
    'dns__unit_minutes' => 'minuten',
    'dns__unit_hours' => 'uren',
    'dns__unit_days' => 'dagen',
    'dns__unit_weeks' => 'weken',
    'dns__dns_zone_off_remove_title' => "De volgende DNS-records zullen worden verwijderd uit de zone %1:",
    'dns__dns_zone_master_remove_title' => "Verwijderen van DNS-records uit de DNS-zone %1",
    'dns__dns_zone_slave_remove_title' => "De volgende primaire naamserverrecords voor %1 zullen worden verwijderd:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Voer recordstring in',
    'dns_add__is_spf_syntax' => 'SPF-record',
    'dns_add__spf_value_is_invalid' => "De waarde van het SPF-record is onjuist: deze moet beginnen met 'v=spf'",
    'dns__dns_zone_status' => "Status DNS-zone.",
    'dns__dns_zone_template' => "DNS-zonesjabloon",
    'dns__host' => "Host",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "IP-adres van nieuwe master DNS-server is ongeldig of leeg.",
    'dns__ip_address' => "IP-adres",
    'dns__master_dns_type' => "is een DNS-masterserver",
    'dns__masters' => "Primaire DNS-servers (masters)",
    'dns__soa_minimum_too_large' => 'Cache voor negatieve antwoorden langer dan drie uur wordt afgeraden.',
    'dns__select_masters_to_remove' => "Selecteer primaire DNS-servers om te verwijderen.",
    'dns__select_template_record_to_remove' => 'Selecteer DNS-sjabloonrecords om te verwijderen.',
    'dns__select_common_acl_record_to_remove' => 'Selecteer de ACL-records die u wilt verwijderen.',
    'dns__select_record_to_remove' => 'Selecteer DNS-records om te verwijderen.',
    'dns__nameservers_for_domain' => "Naamservers voor het domein",
    'dns__ns' => "Naamserver",
    'dns__ns_record' => "Naamservers",
    'dns__remove_dns_zone_of_domain__' => "Verwijdering DNS-records van domein %1",
    'dns__remove_dns_zone_template__' => "De volgende DNS-records zullen uit het sjabloon worden verwijderd",
    'dns__remove_common_acl_record' => "De volgende ACL-records zullen worden verwijderd",
    'dns__remove_this_dns_record?' => "Weet u zeker dat u dit DNS-record wilt verwijderen?",
    'dns__restore_default' => "Herstellen van de DNS-zone aan de hand van het sjabloon",
    'dns__restore_default_confirm' => "Met het herstellen van de DNS-zone gaan de huidige instelling van de DNS-zone verloren. Toch doorgaan?",
    'dns__restore_default_error' => "Fout bij herstellen van DNS-zone:",
    'dns__slave_dns_type' => "is een secondaire DNS-server",
    'dns__soa_refresh_value_is_small' => 'Waarde van vernieuwingsinterval is minder dan een uur, wat een kritische verhoging van het dataverkeer en het brongebruik op de server tot gevolg kan hebben. Wilt u doorgaan met deze waarde?',
    'dns__subdomain_dns_rec_removed' => "Het A-record is verwijderd uit de zone van subdomein %1.",
    'dns__zone_switched_off_no_ns' => "De zone was uitgeschakeld omdat er geen NS record %1 is, dat aanwezig moet zijn in de zone. Om de record aan de zone toe te voegen, klik op Record toevoegen.",
    'dns__cant_switch_on_no_ns' => "De zone kan niet ingeschakeld worden omdat er geen NS-record %1 bestaat, terwijl deze wel in de zone aanwezig moet zijn. Om het record aan de zone toe te voegen, klikt u op Record toevoegen.",
    'dns__type' => "Type record",
    'dns__unable_activate/deactivate_dns' => "Kan DNS niet in- of uitschakelen: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Kan primaire DNS-server niet toevoegen: dubbele invoer.",
    'dns__unable_add_dns_master_local_ip' => "Kan geen IP-adres voor primaire DNS-server toevoegen: dit record moet worden aangemaakt op een externe server.",
    'dns__unable_define_dns_record' => "Kan het DNS-record niet definiëren: %1",
    'dns__unable_get_dns_template_status' => "Kan de status van het DNS-sjabloon niet ophalen.",
    'dns__unable_remove_dns_rec' => "Kan het DNS-record niet verwijderen: %1",
    'dns__val' => "Waarde",
    'dns__warnings__' => "Het resultaat van aanpassing van de DNS-zone:",
    'dns__you_not_have_perm_manage_dns' => "U beschikt niet over de rechten om DNS-zone voor dit domein te beheren.",
    'dns__zone_record' => "DNS-records",
    'dns__dns_preferences_form' => 'Instellingen DNS-recursie',
    'dns__dns_recursion_settings' => 'Instellingen DNS-recursie',
    'dns__allow_recursion' => 'Recursie toestaan',
    'dns__cant_create_record_with_server_ip' => "Kan dit IP-adres niet toevoegen omdat het overeenkomt met het IP-adres van deze Plesk-server.",

    'dns__tabs_acl' => "Zoneoverdracht",
    'dns__acl_add_network_legend' => "Netwerk toevoegen",
    'dns__acl_add_ip_legend' => "IP-adres toevoegen",
    'dns__acl_network_not_allowed' => "Dit netwerkadres is niet toegestaan door DNS in Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP-adres/masker",
    'dns__acl_enter_ip_address' => "IP-adres",
    'dns__acl_list_network_legend' => "Netwerken toegestaan om kopie van DNS-zone te ontvangen",
    'dns__acl_list_ip_legend' => "IP-adressen toegestaan om kopie van DNS-zone te ontvangen",
    'dns__acl_record_network' => "Toegestane netwerken",
    'dns__acl_record_ip' => "Toegestane IP-adressen",
    'bt_dns_acl_add_network' => "Netwerk toevoegen",
    'bt_dns_acl_add_ip' => "IP-adres toevoegen",

    'dns_add__add_rec_for_zone' => "%1 toevoegen voor zone %2",
    'dns_add__canonical_dom_name_is_invalid' => "Canonieke domeinnaam is ongeldig.",
    'dns_add__enter_canonical_name' => "Canonieke naam",
    'dns_add__enter_dom_name' => "Domeinnaam",
    'dns_add__enter_ip_address' => "IP-adres",
    'dns_add__enter_ip_mask' => "IP-adres en netwerkmasker",
    'dns_add__enter_mail_domain' => "Maildomein",
    'dns_add__enter_mail_exchanger' => "Server voor mailexchange",
    'dns_add__enter_nameserver' => "Naamserver",
    'dns_add__enter_txt_record' => "TXT-record",
    'dns_add__enter_service_name' => "Dienstnaam",
    'dns_add__hint_service_name' => "Bijvoorbeeld: SIP",
    'dns_add__enter_protocol' => "Protocol",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioriteit",
    'dns_add__specify_weight_of_service' => "Relatief gewicht voor records met dezelfde prioriteit",
    'dns_add__enter_target_host' => "Doelhost",
    'dns_add__hint_target_host' => "Bijvoorbeeld: example.com",
    'dns_add__enter_target_port' => "Doelpoort",
    'dns_add__caa_tag' => "Tag",
    'dns_add__caa_value' => "Waarde",

    'dns_add__invalid_ip' => "IP-adres is ongeldig.",
    'dns_add__low' => "laag",
    'dns_add__mail_dom_name_is_invalid' => "Naam maildomein is ongeldig.",
    'dns_add__nameserver_is_invalid' => "Naamserver is ongeldig.",
    'dns_add__record' => "%1 record",
    'dns_add__select_prefer_for_mail_exchange_server' => "Geef prioriteit op van mail exchange server",
    'dns_add__unable_insert_new_dns_rec' => "Kan geen nieuw DNS-record invoegen: %1",
    'dns_add__very_high' => "zeer hoog",
    'dns_check__test_dns_zone' => "Test DNS-zone %1 op %2",
    'dns_check__unable_get_dom_properties' => "Kan domeineigenschappen niet ophalen: %1",
    'dom_ctrl__allowed' => "Toegestaan",
    'dom_ctrl__db' => "MySQL-databases",
    'dom_ctrl__mssql_db' => "MS SQL-databases",
    'dom_ctrl__disk_space' => "Schijfruimte",
    'dom_ctrl__dom_adm' => "Domein %1 van %2",
    'dom_ctrl__dom_cl' => "Domein %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Voor het domein is doorschakelen ingeschakeld met ongespecificeerde doorschakel-URL",
    'dom_ctrl__domain_has_frame_forwarding' => "Domein wordt via frame doorgeschakeld naar de URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Er is geen hosting ingesteld voor het domein",
    'dom_ctrl__domain_has_physical_hosting' => "Webhosting is ingesteld voor dit domein op IP-adres %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domein wordt standaard doorgeschakeld naar de URL %1",
    'dom_ctrl__maillists' => "Verzendlijsten",
    'dom_ctrl__mboxes' => "Postvakken",
    'dom_ctrl__mg' => "Doorstuuradressen",
    'dom_ctrl__resource_name' => "Middel",
    'dom_ctrl__resp' => "Automatische beantwoordingen",
    'dom_ctrl__subdom' => "Subdomeinen",
    'dom_ctrl__dom_aliases' => "Domeinaliassen",
    'dom_ctrl__traffic' => "Dataverkeer",
    'dom_ctrl__unable_activate/deactivate_dom' => "Kan domein niet in- of uitschakelen: %1",
    'dom_ctrl__used' => "Gebruikt",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Webgebruikers",
    'dom_pref__bounce_with_phrase' => "Terugsturen met verklaring",
    'dom_pref__bounce' => "Afwijzen",
    'dom_pref__catch_addr' => "Doorsturen naar adres",
    'dom_pref__reject' => 'Afwijzen',
    'dom_pref__confirm_domain_removing' => "Vergeet niet om de bezoekers van het domein te informeren over de naamsverandering. Weet u zeker dat u het domein een nieuwe naam wilt geven?",
    'dom_pref__db_inconsystency' => "inconsistentie in database.",
    'dom_pref__dbs' => "databases",
    'dom_pref__delete_traffic_stat' => "Web- en dataverkeerstatistieken behouden.",
    'dom_pref__delete_traffic_stat_older' => "Web- en dataverkeerstatistieken behouden.",
    'dom_pref__dom_level_name_conflict' => "De gebruikersnaam van de domeinbeheerder conflicteert met de gebruikersnaam van één van de cliënten.",
    'dom_pref__invalid_disk_space_limit' => "Ongeldige schijfruimtebeperking. Maximale waarde: %1",
    'dom_pref__invalid_expiration_date_limit' => "Ongeldige geldigheidsduur.",
    'dom_pref__invalid_max_traffic_limit' => "Ongeldige dataverkeerbeperking. Maximale waarde: %1",
    'dom_pref__limits_of_dom' => "Beperkingen voor domein %1",
    'dom_pref__mail_grps' => "mailgroepen",
    'dom_pref__mail_nonexistent_user' => "Wat te doen met mail aan niet-bestaande gebruikers",
    'dom_pref__mail_redirs' => "Doorstuuradressen e-mail",
    'dom_pref__mail_resps' => "Automatische beantwoordingen e-mail",
    'dom_pref__max_limit_is_invalid' => "%1 is ongeldig.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maximaal aantal %1 is ongeldig.",
    'dom_pref__new_limit_less_currently_used' => "%1: gevraagd - %2, momenteel gebruikt - %3",
    'dom_pref__older_that' => "voor",
    'dom_pref__postboxes' => "postvakken",
    'dom_pref__preferences_of_dom' => "Instellingen voor domein %1",
    'dom_pref__redirect_to_itself' => "Het domein zal doorsturen naar zichzelf hebben ingesteld",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "U hebt opgegeven dat de bewaartijd voor dataverkeerstatistieken van het domein minder moet zijn dan de totale waarde die voor de server is ingesteld (%1 maand/maanden). De bewaartijd voor statistieken is ingesteld op de standaardwaarde van de server (%1 maand/maanden).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Kan geen www-voorvoegsel aan domein toevoegen: %1",
    'dom_pref__unable_define_physical_hst_param' => "Kan parameters van fysieke hosting niet definiëren: %1",
    'dom_pref__unable_rename_domain' => "Kan de naam van het domein niet wijzingen",
    'dom_pref__unable_set_up_mbox_quota' => "Kan omvang van het postvak niet instellen voor dit domein: %1",
    'dom_pref__unable_set_up_web_user_script' => "Kan geen scripting voor webgebruikers instellen: %1",
    'dom_pref__unlimited' => "Onbeperkt",
    'dom_pref__web_usrs' => "webgebruikers",
    'dom_pref__you_already_have_%object' => "U hebt reeds %1",
    'dom_cli__warning_ignore_quota' => 'WAARSCHUWING: De optie "-hard_quota" is genegeerd: harde beperkingen van schijfruimte worden niet ondersteund',
    'dom_user_client_login_exist' => "Kan geen toegang voor domeinbeheerder in Plesk toestaan op het domein %1: Deze gebruikersnaam wordt al gebruikt.",
    'domain__unable_to_turn_on_service' => "Het inschakelen van de %1-dienst is mislukt.",
    'domains__change_the_status_of_domain?' => "Weet u zeker dat u de status van domein %1 wilt wijzigen?",
    'domains__client_info_hiding_traffic' => "%1 domeinen, %2 actieve domeinen, %3 schijfruimte gebruikt",
    'domains__unable_to_change_client_status' => "Kan de accountstatus van de cliënt niet wijzigen: %1",
    'domains__unable_update_apache_settings' => "Kan Apache-instellingen niet bijwerken.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "U beschikt niet over de rechten om domeinen te verwijderen.",
    'domains__you_want_change_the_status_of_the_cl??' => "Weet u zeker dat u de status van het cliëntaccount wilt wijzigen?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Weet u zeker dat u deze bewerking wilt uitvoeren?",
    'domains_list__unable_remove_doms' => "Kan domeinen niet verwijderen: %1",
    'domaintrafficlist_header_of_domain__' => "Dataverkeer van domein %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Selecteer de domeinaliassen om te verwijderen.',
    'domain_aliases_remove__title' => 'Domeinaliassen verwijderen',
    'domain_aliases__max_aliases_reached_for_dom' => "De beperking van het aantal aliassen is bereikt voor dit domein.",
    'domain_edit__edit_title' => 'Naam domeinalias bewerken',
    'domain_alias_edit__type' => 'Type domeinalias',
    'domain_aliases__list_header' => 'Domeinaliassen',
    'domain_aliases__name' => 'Naam',
    'domain_aliases__type' => 'Type',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Domeinaliassen',
    'domain_aliases__legend' => 'Domeinaliassen',
    'domain_alias__domain_exists' => 'Er bestaat al een domein met deze naam',
    'domain_alias__subdomain_exists' => 'Er bestaat al een subdomein met deze naam',
    'domain_alias__dns_record_exists' => 'Er bestaat al een DNS-record met het opgegeven domeinnaamalias',
    'domain_alias__domain_alias_exists' => "Er bestaat al een domeinalias met deze naam",
    'domain_alias__invalid_type_full' => 'Mailserver ondersteunt geen domeinaliassen',
    'domain_alias__redirect_exists' => 'Doorschakeling naar zichzelf vastgesteld.',

    'ds__anonymous_ftp' => "Anonieme FTP",
    'drweb__pagetitle' => 'Antivirusinstellingen',
    'drweb__drweb' => 'Mail virusscanner',
    'drweb__drweb_direction' => 'Mail aan het controleren op virussen',
    'drweb__drweb_direction_off' => 'Niet op virussen controleren',
    'drweb__drweb_direction_any' => 'Inkomende en uitgaande mail',
    'drweb__drweb_direction_from' => 'Alleen uitgaande mail',
    'drweb__drweb_direction_to' => 'Alleen inkomende mail',
    'drweb__disable_reason_key' => 'Antivirus wordt niet ondersteund door de licentiesleutel.',
    'drweb__disable_reason_perm' => 'U hebt geen rechten om Antivirus te beheren.',
    'drweb__disable_reason_install' => 'Antivirus is niet geïnstalleerd.',
    'drweb__filters' => 'Antivirusfilters',
    'ds__dns' => "DNS-zone",
    'ds__mail' => "Mail",
    'dsr__of_client_title' => "Samenvattend domeinverslag over %1",
    'dsr__report_has_been_sent_email' => "Het verslag is verzonden naar e-mail: %1",
    'dsr__title' => "Samenvattend domeinverslag",
    'dumps_list__deletion_page_title' => "De volgende reservekopieën van domein %1 zullen worden verwijderd:",
    'dumps_list__dumpfile_is_invalid' => "Het bestand %1 is geen geldige reservekopie.",
    'dumps_list__page_title' => "Opslag van reservekopieën",
    'dumps_upload__page_title' => "Bezig met uploaden reservekopieën naar opslag",
    'dumps_list__repository_is_not_exist' => "Opslag van reservekopieën bestaat niet.",
    'dumps_list__unable_to_remove' => "Kan de reservekopie niet verwijderen: %1",
    'dumps_list__dumpfile_can_conflict' => "De bestandsnaam die u hebt opgegeven conflicteert met bestand %1. Geef een andere bestandsnaam op.",
    'dusr_ed__allow_dl_usr_access' => "Toegang voor domeinbeheerder toestaan",
    'dusr_ed__information' => "Eigenschappen van beheerder van domein %1",
    'dusr_ed__locale' => "Taal van domeinbeheerder",
    'dusr_ed__skin' => "Door domeinbeheerder gebruikt thema",
    'dusr_ed__personal_information' => 'Persoonlijke gegevens',
    'ess__error' => "Fout",
    'example__' => "Bijvoorbeeld: %1",
    'extras__allow_certificate_purchasing' => "Aanschaf van certificaten toestaan",
    'extras__allow_domain_registration' => "Domeinregistratie toestaan",
    'extras__allow_extras' => "Extra diensten toestaan",
    'extras__buy_new_key' => "Uw licentiesleutel staat u niet toe deze objecten aan te passen.",
    'extras__setup_services' => "Extra diensten instellen",

    'firewallmainform__title' => 'Beheer firewall',
    'firewallmainform__interfaces_list_legend' => 'Lijst met netwerkkaarten',
    'firewall__interfacelist' => 'Netwerkkaarten',
    'interfacelist__enabled' => 'F',
    'interfacelist__status' => 'l',

    'interfacelist__interface' => 'Schermnaam',
    'interfacelist__type' => 'Type netwerkkaart',
    'bt_rule_add' => 'Regel aan Firewall toevoegen',
    'bt_panic' => 'Paniekmodus',
    'firewallmainform__rules_list_legend' => 'Lijst met regels',
    'firewall__rulelist' => 'Regels',
    'rulelist__enable' => 'S',
    'rulelist__name' => 'Naam',
    'rulelist__allow_input_from_any_port_profiles' => '[Toestaan] Inkomende verbindingen [weigeren] vanaf [alles] op poort [%1], profielen: [%2]',
    'rulelist__allow_input_from_port_profiles' => '[Toestaan] Inkomende verbindingen [toestaan] vanaf [%1] op poort [%2], profielen: [%3]',
    'rulelist__block_input_from_any_port_profiles' => '[Weigeren] Inkomende verbindingen [weigeren] vanaf [alles] op poort [%1], profielen: [%2]',
    'rulelist__block_input_from_port_profiles' => '[Weigeren] Inkomende verbindingen [toestaan] vanaf [%1] op poort [%2], profielen: [%3]',
    'rulelist__description' => 'Omschrijving',
    'ruleeditform__add_title' => 'Een nieuwe regel toevoegen',
    'ruleeditform__properties' => 'Eigenschappen van de regel',
    'ruleeditform__name' => 'Naam van de regel',
    'ruleeditform__port' => 'Verbinding naar de volgende poort of het volgende poortbereik toestaan',
    'ruleeditform__protocol_tcp' => 'TCP-protocol',
    'ruleeditform__protocol_udp' => 'UDP-protocol',
    'ruleeditform__edit_title' => 'Een firewall-regel bewerken',
    'ruleeditform__newrule' => 'Nieuwe regel',
    'ruleeditform__enabled' => 'De regel inschakelen.',
    'ruleeditform__profiles_text' => 'Profielen',
    'ruleeditform__profiles_domain_text' => 'Domein',
    'ruleeditform__profiles_private_text' => 'Privaat',
    'ruleeditform__profiles_public_text' => 'Openbaar',
    'ruleeditform__action' => 'Bewerking',
    'ruleeditform__action_allow' => 'Toestaan',
    'ruleeditform__action_deny' => 'Weigeren',
    'ruleeditform__from' => 'Externe adressen',
    'ruleeditform__from_add' => 'Een IP-adres of een netwerk toevoegen:',
    'ruleeditform__profiles_hint' => 'U moet ten minste één profiel selecteren.',
    'ruleeditform__port_hint' => 'Bijvoorbeeld: 1000 of 1000-1051',
    'ruleeditform__from_hint' => 'Bijvoorbeeld: 192.168.0.1 or 192.168.0.0/16',
    'ruleeditform__ip_any' => 'Alle',
    'firewall_from_add' => 'Toevoegen',
    'firewall_from_remove' => 'Verwijderen',
    'firewall_from_clear' => 'Lijst leeg maken',
    'bt_firewall_from_add' => 'Toevoegen',
    'bt_firewall_from_remove' => 'Verwijderen',
    'bt_firewall_from_clear' => 'Lijst leeg maken',
    'ruleeditform__name_is_required' => 'Geef de naam van de regel op.',
    'ruleeditform__profiles_is_required' => 'Selecteer ten minste één profiel.',
    'ruleeditform__invalid_action' => 'De opgegeven actie is niet geldig. De mogelijke waarden zijn "Toestaan" en "Weigeren".',
    'ruleeditform__invalid_ip' => 'Het opgegeven IP-adres of netwerk is ongeldig.',
    'ruleeditform__invalid_protocol' => 'Het opgegeven protocol is ongeldig. De mogelijke waarden zijn "udp" en "tcp".',
    'ruleeditform__invalid_port' => 'De opgegeven poort is ongeldig. De mogelijke waarden zijn 1000 of 1000-1051',
    'firewall__panic_configuration' => 'Weet u zeker dat u de Paniekmodus wilt inschakelen? Gebruikers zullen geen toegang meer hebben tot hun domeinen.',
    'firewall__reset_configuration' => 'Weet u zeker dat u de standaardinstellingen van de firewall wilt terugzetten?',
    'rulelist__remove_selected' => 'Wilt u de geselecteerde regels verwijderen?',

    'filemanager__items' => 'onderdelen in map %1',
    'filemanager__items_paging' => 'onderdelen in map %1',

    'get_password__encrypted_password' => "Kan de wachtwoordinformatie niet verzenden: het wachtwoord is versleuteld opgeslagen.",
    'get_password__mail_error' => "Er is een fout opgetreden bij de poging tot het versturen van het wachtwoord aan e-mailadres %1: %2",
    'get_password__mail_ok' => "Het wachtwoord is met succes verzonden aan e-mail: %1",
    'get_password__message' => "Uw gebruikersnaam voor toegang tot het systeem: %1\nUw wachtwoord is %2",
    'get_password__subject' => "Wachtwoord voor toegang tot het systeem",
    'groups__available' => "Beschikbare mailgroepen",
    'groups__groups_for_mailname' => "Mailgroepen waar het mailaccount %1 op is geabonneerd",
    'groups__member_of' => "Lid van de volgende mailgroepen",
    'help__help_area' => "Hulpcentrum.",
    'hst_def__auth_disabled' => "verboden",
    'hst_def__auth_enabled' => "toegestaan",
    'hst_def__change_curr_dns_ip' => "Het huidige IP-adres van het DNS A-record zal worden gewijzigd",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Geen van de IP-adressen in het DNS A-record komt overeen met het IP-adres dat is toegewezen aan het hostingaccount dat wordt aangemaakt",
    'hst_def__dest_url' => "URL van bestemming",
    'hst_def__disk_quota' => "Schrijfruimtebeperking",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "De schijfruimtebeperking die u probeert in te stellen wordt overschreden door de schijfruimtebeperking van de map \\incoming van Anonieme FTP. De schijfruimtebeperking van map \\incoming van Anonieme FTP mag de schijfruimtebeperking van het domein niet overschrijden.",
    'hst_def__frame_forwarding_definition' => "Opdracht doorschakelen via frame voor domein %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Waarschuwing: FTP-gebruiker %1 is opgegeven in de hostingaccountinstellingen maar bestaat niet in het systeem.",
    'hst_def__hst_type_is_not_defined' => "Type hosting is niet opgegeven",
    'hst_def__ip_based' => "IP-gebaseerd",
    'hst_def__name_based_power_anonymous_ftp_down' => "Het overdragen van dit hostingaccount naar een gedeeld IP-adres maakt dat de anonieme FTP-dienst niet langer bereikbaar is. Toch doorgaan?",
    'hst_def__password_is_invalid_password_syntax' => "Wachtwoord is ongeldig.\nGebruik geen apostrof of landspecifieke karakters in een wachtwoord.\nDe lengte van het wachtwoord moet tussen de 5 en 14 karakters liggen. Het wachtwoord mag niet de gebruikersnaam bevatten.",
    'hst_def__shell' => "SSH-toegang tot de shell van de server via de systeemgebruiker van het abonnement",
    'hst_def__shell_windows' => "Toegang tot de server via Extern Bureaublad onder de naam van de systeemgebruiker die bij het pakket hoort",
    'hst_def__standard_forwarding_definition' => "Opdracht tot standaard doorschakelen voor domein %1",
    'hst_def__title_name_based' => "Naamgebaseerd",
    'hst_def__unable_create/update_physic_hst' => "Kan fysieke hosting niet aanmaken/bijwerken: %1",
    'hst_def__unable_create/update_std_fwd' => "Kan standaard doorsturen niet aanmaken/bijwerken: %1",
    'hst_def__unable_create_forwarding_myself' => "Kan niet doorsturen naar het domein zelf.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Kan het gebruik niet toestaan van een enkele map voor het opslaan van zowel bestanden met als zonder SSL/TLS: ondersteuning voor SSL/TLS is niet ingeschakeld.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Kan ondersteuning voor SSL/TLS niet inschakelen: er is geen SSL/TLS-certificaat geïnstalleerd.",
    'hst_def__url_is_invalid' => "URL is ongeldig.",
    'hst_def__virtual_host_access' => "Virtuele hosttoegang voor domein %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "WAARSCHUWING. Deze virtuele host gebruikt een niet-bestaand IP-adres voor hosting.",
    'hst_def__you_have_no_ips' => "U hebt geen IP-adressen beschikbaar en het is u niet toegestaan om Naamgebaseerde hosting aan te maken.",
    'hst_sel__header' => "Om een website op deze machine te hosten, selecteert u de optie Fysieke hosting.\nOm een domein te laten doorschakelen naar een andere site op een andere machine, selecteert u de optie Doorschakelen via frame of Standaard doorschakelen.\nMet standaard doorschakelen wordt een gebruiker omgeleid naar de site en wordt de werkelijke URL van de site getoond in de browser van de gebruiker, die daardoor weet heeft van de doorschakeling. Met doorschakelen via frame wordt een gebruiker naar de site omgeleid zonder te weten dat de site zich eigenlijk op een andere locatie bevindt.",
    'hst_sel__physical_hst' => "Fysieke hosting",
    'hst_sel__select_hst_type' => "Selecteer het type hosting voor het domein",
    'hst_sel__select_hst_type_warning' => "Selecteer het type hosting voor het domein",
    'hst_sel__hosting_exists' => "Kan geen hosting aanmaken: deze is al ingesteld voor dit domein. U wordt doorgeschakeld naar de pagina hostingbeheer.",
    'hst_sel__standard_frw' => "Standaard doorschakelen",
    'hst_sel__frame_frw' => "Doorschakelen via frame",
    '__frame_frw' => "Doorschakelen via frame",
    '__hosting_exists' => "Kan geen hosting aanmaken: deze is al ingesteld voor dit domein. U wordt doorgeschakeld naar de pagina hostingbeheer.",
    '__choose_hst_type' => "Selecteer het vereiste type hosting.",
    '__no_hst_conf' => "Er is geen hosting ingesteld voor uw domein.",
    '__physical_hst' => "Fysieke hosting",
    '__select_hst_type' => "Selecteer het type hosting voor het domein",
    '__standard_frw' => "Standaard doorschakelen",
    '__warning' => "Let op! Alle eerder ingestelde parameters zullen verloren gaan. Weet u zeker dat u het type hosting wilt wijzigen?",
    'i_cl_off' => "Cliënt is inactief.",
    'i_cl_off_by_admin' => "Cliëntaccount is opgeschort door serverbeheerder.",
    'i_cl_off_expired' => "Cliëntaccount is verlopen.",
    'i_cl_on' => "Cliënt is actief.",

    'icf__title' => 'Firewall internetverbinding',
    'icf__if_legend' => 'Netwerkkaarten',
    'icf__mode' => 'Modus',

    'invalid_value' => 'Waarde is ongeldig',

    'ip_addr__already_exists' => "IP-adres %1 bestaat al.",
    'ip_addr__cant_add' => "IP %1 bestaat niet of behoort tot de IP-voorziening van andere cliënt",
    'ip_addr__cl_list_for_ip' => "Resellers die %1 IP-adres %2 gebruiken",
    'ip_addr__cl_list_for_ip_add' => "IP-adres toevoegen aan de voorziening van de reseller",
    'ip_addr__domains_list_for_ip' => "Websites die %1 IP-adres %2 gebruiken",
    'ip_addr__ip_used_by_hst_or_frw' => "IP-adres %1 wordt gebruikt voor hosting of doorschakeling.",
    'ip_addr__only_one_ip_and_client_have_domain' => "Kan dit IP-adres niet verwijderen omdat er domeinen op dit IP-adres worden gehost.",
    'ip_addr__remove_ip_addr' => "Deze IP-adressen zullen worden verwijderd van het systeem:",
    'ip_addr__select_clients' => "Cliënten selecteren",
    'ip_addr__select_ip_addr_to_remove' => "Selecteer het IP-adres om te verwijderen.",
    'ip_addr__unallowed_by_license' => "Deze kopie van Plesk heeft geen licentie om uitgevoerd te worden IP-adres %1.\nToegestaan IP-bereik is: %2.",
    'ip_alias__interface' => "Scherm",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP-adres voor naamgebaseerde virtuele hosting is ongeldig.",
    'ip_alias__invalid_ip_or_netmask' => "Ongeldige combinatie IP-adres/netmasker.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Het IP-adres %1 is het originele IP van de server, daarom kunt u deze niet verwijderen.",
    'ip_alias__ip_is_invalid' => "%1 IP-adres is ongeldig.",
    'ip_alias__ip_mask_is_invalid' => "%1 IP-masker is ongeldig.",
    'ip_alias__ip_not_exist' => "IP-adres %1 bestaat niet.",
    'ip_alias__ip_address_and_mask' => 'IP-adres en subnetmasker',
    'ip_alias__mask' => "Subnetmasker",
    'ip_alias__remove_selected_ip_aliases?' => "Weet u zeker dat u de geselecteerde IP-adressen wilt verwijderen?",
    'ip_alias__select_ip' => "Selecteer ten minste één IP-adres uit de lijst om te verwijderen.",
    'ip_alias__this_ip_used_for_domain' => "(%1) dit IP-adres wordt gebruikt voor domein %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) dit IP-adres wordt gebruikt voor naamgebaseerde virtuele hosts.",
    'ip_alias__unable_add_ip' => "Kan de IP niet toevoegen: %1",
    'ip_alias__unable_remove_ip' => "Kan IP niet verwijderen: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "U kunt het IP-adres niet veranderen in gedeeld, omdat dan anonieme FTP voor het domein '%1' niet langer bereikbaar zou zijn.",
    'ip_ctrl__ip_addr' => "IP-adres %2 op de netwerkkaart %1",
    'ip_ctrl__ip_exists_many_pools' => "U kunt het IP-type niet veranderen. Dit IP-adres behoort toe aan de voorziening van verschillende gebruikers tegelijk.",
    'ip_ctrl__ssl_cert' => "SSL/TLS-certificaat",
    'ip_pool__ip_address_is_absend_in_pool' => "IP-adres ontbreekt.",
    'ip_pool__ip_pool_for_client' => "IP-voorziening van cliënt %1",
    'ip_pool__no_cliens_avail' => "Er zijn geen cliënten beschikbaar.",
    'ip_pool__no_vacant_ips' => "Er zijn geen beschikbare IP's.",
    'ip_pool__pool_is_empty' => "IP-voorziening is leeg.",
    'ip_pool__remove_ip_addr' => "Deze IP-adressen zullen worden verwijderd uit de voorziening %1:",
    'ip_pool__select_free_ips' => "Beschikbare IP's",
    'limit__date_in_past' => "Geldigheidsduur is onjuist. %1 ligt in het verleden.",
    'limit__enter_date' => "Voer datum in",
    'limit__max_db' => "Databases",
    'limit__name_disk_space' => "Schijfruimte",
    'limit__name_max_box' => "postvakken",
    'limit__name_max_db' => "MySQL-databases",
    'limit__name_max_dom' => "Domeinen",
    'limit__name_max_maillists' => "Verzendlijsten",
    'limit__name_max_subdom' => "Subdomeinen",
    'limit__name_max_traffic' => "Dataverkeer",
    'limit__name_max_wu' => "webgebruikers",
    'limit__name_mbox_quota' => "postvakbeperking",
    'limit__name_max_mn' => "Mailaccounts",
    'limit__name_max_cl' => 'cliënten',
    'limit__name_total_mboxes_quota' => "totale postvakbeperking",
    'limit__name_mysql_dbase_space' => "MySQL-databaseruimte",
    'limit__name_mssql_dbase_space' => "MSSQL-databaseruimte",
    'limit__name_expiration' => 'verloopdatum',

    'locale_upload__title' => 'Regio toevoegen',
    'locale_upload__file_name' => 'Zoekpad naar de locatie van het taalpakket',
    'locale_upload__unable_to_install' => 'Kan het taalpakketbestand niet installeren',
    'locale_upload__wrong_package' => 'Het bestand dat u hebt geüpload bevat geen geldig taalpakket voor deze versie van Plesk.',
    'locale_upload__wrong_locale' => 'Het bestand dat u hebt geladen bevat geen geldig taalpakket.',

    'locales_remove__title' => 'Verwijdering van Regio\'s',
    'locales_remove__select_locales_for_remove' => 'Selecteer de regio\'s om te verwijderen.',
    'locales__can_not_remove' => 'Kan het taalpakket voor regio %1 niet verwijderen: %2',

    'ma__create_title' => 'Mailalias aanmaken voor %1',
    'ma__edit_title' => "Mailalias %1 bewerken",
    'ma__enter_new_alias' => "Voer nieuw alias in.",
    'ma__invalid_alias' => "Ongeldig mailalias.",
    'ma__mail_aliases_mailname' => "Aliassen voor mailaccount %1",
    'ma__mailname_does_not_exist' => "Mailaccount bestaat niet.",
    'ma__select_ma_for_remove' => "Selecteer mailaliassen om te verwijderen.",
    'ma__unable_to_add_new_ma' => "Kan geen mailalias toevoegen: %1",

    'mail__white_list' => "Witte lijst",
    'mail__white_list_add' => 'Netwerk toevoegen',
    'mail__white_list_remove' => 'De volgende netwerken zullen worden verwijderd:',
    'mail__white_list_remove_warning_webmail' => 'Het verwijderen van de volgende netwerken zal het versturen van e-mail vanuit webmail wellicht onmogelijk maken: %1.',
    'mail__white_list_member' => 'Toegestane netwerken',
    'mail__white_list_empty_selection_for_remove' => 'Selecteer de ingangen om te verwijderen.',
    'mail_queue__not_allowed_by_license_key' => 'Beheer van de mailwachtrij is niet toegestaan door de licentiesleutel.',
    'maillist__' => "Verzendlijst %1",
    'maillist__already_exists' => "Verzendlijst bestaat al.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Het mailalias %1 bestaat al binnen dit domein",
    'maillists__' => "Verzendlijsten %1",
    'maillists__limit_cl_max_maillists' => "De beperking van het aantal verzendlijsten is bereikt voor de cliënt (beperking: %1, gebruikt: %2)",
    'maillists__limit_dom_max_maillists' => "De beperking van het aantal verzendlijsten is bereikt voor het domein.",
    'maillists__list' => "Verzendlijsten",
    'maillists__mailman_not_installed_or_conf' => "Mailman Serveruitbreidingen zijn momenteel niet geïnstalleerd of ingesteld. Neem contact op met de beheerder van de server om Mailman Serveruitbreidingen te installeren of correct in te stellen.",
    'maillists__status' => "De verzendlijstdienst is ingeschakeld",
    'maillists__unable_to_delete__' => "Kan de verzendlijst niet verwijderen: %1",
    'maillists__disabled_text' => 'U kunt geen verzendlijsten beheren omdat de component voor Mailman-verzendlijsten niet in geïnstalleerd of niet is ingesteld.',
    'maillist_member__already_exists' => 'Verzendlijstabonnee bestaat al.',
    'maillist_member__not_exists' => 'Deze gebruiker staat niet op de verzendlijst.',
    'mailserver_switching_warning' => "Waarschuwing!\n\nHet wijzigen van de mailserver is alleen bedoeld voor de initiële instelling. Als de server al in gebruik is veroorzaakt dit de volgende problemen: verlies van instellingen en de inhoud van postvakken en, in gevallen waarbij de server die u wilt gaan gebruiken al is ingesteld, diverse conflicten.\nAls deze server nu in gebruik is en u weet zeker dat u wilt overstappen naar een andere server, dan kunt u uw klanten daarvan op de hoogte stellen. Zij kunnen dan hun mail downloaden en bewaren.",
    'manager__access_denied' => "Toegang geweigerd: %1",
    'manager__admin' => "Beheerder",
    'manager__client' => 'Cliënt',
    'manager__domain' => "Domein",
    'manager__domain_cl_limit_exceeding' => "De beperking van het aantal domeinen is bereikt voor dit cliëntaccount",
    'manager__domain_is_not_yours' => "Domein %1 hoort niet bij u.",
    'manager__domain_key_limit_exceeding' => "De beperking die u licentiesleutel stelt aan het aanmaken van domeinen is bereikt.",
    'manager__no_perm_to_call' => "U beschikt niet over de rechten om %1 aan te roepen.",
    'manager__no_perm_to_create_domains' => "U beschikt niet over de rechten om domeinen aan te maken.",
    'manager__no_perm_to_modify_domain' => "U beschikt niet over de rechten om domein %1 aan te passen.",
    'manager__no_perm_to_modify_domains' => "U beschikt niet over de rechten om domeinen aan te passen.",
    'manager__no_perm_to_remove_domain' => "U beschikt niet over de rechten om domein %1 te verwijderen.",
    'manager__no_perm_to_remove_domains' => "U beschikt niet over de rechten om domeinen te verwijderen.",
    'manager__node_doesnt_exist' => "%1 bestaat niet.",
    'manager__user_disabled' => "Uw account is opgeschort. U kunt het systeem niet bedienen.",
    'mail_quota_unsupported' => "niet ondersteund door de mailserver",
    'mbox_quota_unsupported' => "niet ondersteund door de mailserver",
    'mn__create_title' => "Mailaccount aanmaken",
    'mn__edit_title' => "Instellingen",
    'mn__files_list_title' => "Bijlagen",
    'mn__files_remove' => "Bestanden uit de opslag van bijlagen verwijderen. Deze bestanden worden mogelijk gebruikt door automatische beantwoordingen. Ze zullen worden verwijderd uit zowel de opslag als van de automatische beantwoordingen door welke ze worden gebruikt.",
    'mn__files_select_for_remove' => "Selecteer bestanden om te verwijderen.",
    'mn__mail_alias_form' => "Formulier mailalias",
    'mn__mail_aliases_list' => "Mailaliassen",
    'mn__mailbox' => "Beheer van postvak",
    'mn__unable_define_mn' => "Kan geen mailaccounts instellen: %1",
    'mn__unable_remove_mbox_quota' => "Kan postvakbeperking niet verwijderen: %1",
    'mn__upload_file' => "Bestand uploaden",
    'mn_edit__attach_filename_changed' => 'De naam van het geüploade bestand %1 is gewijzigd naar %2 omdat de naam niet-ASCII-karakters bevatte.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "U moet een mailgroeplid toevoegen voordat u de mailgroep activeert.",
    'mn_edit__add_resp_or_turn_off_box' => "U moet een automatische beantwoording toevoegen, of zorgen dat het selectievakje automatische beantwoording niet is geselecteerd.",
    'mn_edit__attachments' => "Bijlagen",
    'mn_edit__dom_quota_less_then_quota' => "De omvang van dit postvak mag niet groter zijn dan de beperking van de hoeveelheid schijfruimte die onder dit domein voor postvakken is ingesteld.",
    'mn_edit__enter_external_rcpnt_email' => "Geef e-mail op van lid van externe emailgroep",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Voer een adres in voor het doorsturen van e-mail of zorg dat het selectievakje niet is geselecteerd.",
    'mn_edit__ext_rcpnt_email_invalid' => "E-mailadres van externe ontvanger is niet geldig.",
    'mn_edit__file_exists' => "Bestand bestaat al. Overschrijven?",
    'mn_edit__files_deld_from_repository' => "Deze bestanden zullen worden verwijderd uit de opslag en van de automatische beantwoordingen waar ze aan zijn gekoppeld. Wilt u doorgaan?",
    'mn_edit__mail_name' => "Mailaccount",
    'mn_edit__mail_name_invalid' => "Naam mailaccount is ongeldig.",
    'mn_edit__mail_redir' => "Doorstuuradressen e-mail",
    'mn_edit__mail_redir_add' => "Lid aan mailgroep toevoegen",
    'mn_edit__mail_resps' => "Automatische beantwoordingen e-mail",
    'mn_edit__mailbox' => "Postvak",
    'mn_edit__enable_mailbox' => "Postvak",
    'mn_edit__mailgroup' => "Mailgroep",
    'mn_edit__mailgroup_addresses' => "Mailgroepleden",
    'mn_edit__mailgroup_disabled' => "Alleen beschikbaar wanneer mailaccount al is toegevoegd.",
    'mn_edit__max_dom_quota' => "Standaard voor het domein (%1)",
    'mn_edit__mbox_quota_invalid' => "Onjuiste grootte van het postvak opgegeven.",
    'mn_edit__new_resp_name' => "Nieuwe naam voor automatische beantwoording",
    'mn_edit__no_autoresponders' => "U moet ten minste één automatische beantwoording toevoegen voordat u de dienst automatische beantwoording in- of uitschakelt.",
    'mn_edit__no_file_sel' => "Geen bestanden geselecteerd.",
    'mn_edit__no_mail_addresses' => "Er zijn geen e-mailadressen opgegeven of geselecteerd.",
    'mn_edit__none' => "Geen",
    'mn_edit__not_create_pass' => "Hiermee zal geen wachtwoord voor dit account worden aangemaakt.\nZonder wachtwoord zal de gebruiker niet in staat zijn om mail te lezen of versturen.",
    'mn_edit__redir_email_invalid' => "Doorstuuradres is ongeldig.",
    'mn_edit__redirect_addr' => "Doorstuuradres",
    'mn_edit__remove_autoresp?' => "Weet u zeker dat u de automatische beantwoording wilt verwijderen?",
    'mn_edit__remove_rcpnts?' => "Weet u zeker dat u deze ontvangers wilt verwijderen?",
    'mn_edit__repository' => "Opslag",
    'mn_edit__resps_attach' => "Bijlagen voor automatische beantwoording",
    'mn_edit__select_rcpnt_from_list' => "Selecteer ten minste één ontvanger uit de lijst om te verwijderen.",
    'mn_edit__select_registered_users' => "Selecteer geregistreerde gebruikers",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "U hebt ervoor gekozen een postvak aan te maken, maar U hebt daar nog niet het wachtwoord voor ingesteld.",
    'mn_edit__unable_act_deact_mail_group' => "Kan mailgroep niet in- of uitschakelen: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Kan doorstuuradres niet in- of uitschakelen: %1",
    'mn_edit__unable_act_deact_postbox' => "Kan postvak niet in- of uitschakelen: %1",
    'mn_edit__unable_act_deact_resp' => "Kan automatische beantwoordingen niet in- of uitschakelen: %1",
    'mn_edit__unable_add_attach' => "Kan bijlagebestand niet toevoegen: %1",
    'mn_edit__unable_add_mail_group_member' => "Kan mailgroeplid niet toevoegen: %1",
    'mn_edit__unable_add_resp' => "Kan automatische beantwoording niet toevoegen: %1",
    'mn_edit__unable_change_mail_name' => "Kan mailaccountnaam niet wijzigen: %1",
    'mn_edit__unable_deactivate_mail_group' => "Kan mailgroep niet uitschakelen: %1",
    'mn_edit__unable_deactivate_resp' => "Kan automatische beantwoordingen niet uitschakelen: %1",
    'mn_edit__unable_define_resp_id' => "Kan kenmerk van automatische beantwoording niet vaststellen: %1",
    'mn_edit__unable_remove_attach' => "Kan bijlagebestand(en) niet verwijderen: %1",
    'mn_edit__unable_remove_autoresp' => "Kan automatische beantwoording niet verwijderen: %1",
    'mn_edit__unable_remove_mail_group_member' => "Kan mailgroepleden niet verwijderen: %1",
    'mn_edit__wrong_way' => 'Het bericht gericht aan %1 zal niet worden bezorgd, aangezien dit mailaccount geen postvak of doorstuuradres heeft ingesteld.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Het postvak van de adressen %1 was uitgeschakeld. De berichten in het postvak zijn niet verwijderd, maar het zal onmogelijk zijn om ze via IMAP of POP3 protocollen te herstellen.',
    'mn_list__mail_names_for_domain' => "Mailaccounts binnen het domein %1",
    'mn_list__sa_cannot_unable' => "Kan het detecteren van spam niet inschakelen",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Cliënt',
    'mn_list__tab_title_domain' => 'Domein',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Naam",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Kan de mailaccounts niet verwijderen: %1",
    'no_psa_mails_matched' => "Er zijn geen mailaccounts opgegeven die voldoen aan de zoekopdracht.",
    'module_upload__module_was_installed' => 'Deze module is al geïnstalleerd. Als u een nieuwe versie van deze module wilt installeren, moet de huidige versie eerst worden verwijderd vanuit Plesk; daarna kunt u de installatie nogmaals proberen.',
    'module_upload__unable_to_install' => 'Kan het modulepakketbestand niet installeren',
    'module_upload__wrong_package' => 'Het geüploade bestand is geen ondersteund modulepakket.',
    'module_upload__wrong_module' => 'Het geüploade bestand bevat geen modulepakket.',

    'news_articles_title' => 'Nieuws over Plesk',
    'notification_text__invalid_subject_length' => "Ongeldige lengte van het onderwerp van de melding. Moet tussen de 1 en 255 karakters zijn.",
    'notification_text__invalid_text_length' => "Ongeldige lengte meldingstekst. De waarde moet tussen de 1 en 65533 karakters liggen.",
    'notification_text__subject' => "Onderwerp van melding",
    'notification_text__text' => "Tekst van melding",
    'notification_text__title' => "Melding wijzigen",
    'notification_text__unable_set_text' => "Kan meldingstekst niet aanpassen:",

    'odbc__cant_add_dsn' => "Kan DSN %1 niet toevoegen: %2",
    'odbc__cant_build_connection_string' => "Kan met de opgegeven parameters geen verbinding maken, probeer het opnieuw met andere parameters. Hulpprogramma heeft teruggegeven: %1",
    'odbc__cant_connect' => "Kan met de opgegeven instellingen geen verbinding maken met de gegevensbron. De server heeft teruggegeven: %1",
    'odbc__cant_delete_dsn' => "Kan DSN %1 niet verwijderen: %2",
    'odbc__cant_get_drivers_info' => "Kan geen informatie over stuurprogramma's verkrijgen.",
    'odbc__cant_get_drivers' => "Kan geen lijst met ODBC-stuurprogramma's ophalen: %1",
    'odbc__cant_get_list' => "Kan geen lijst van bestaande DSN's ophalen: %1",
    'odbc__cant_get_servers_list' => "Kan geen lijst met servers ophalen.",
    'odbc__cant_open_info_file' => "Kan het bestand met informatie over ODBC-stuurprogramma niet openen.",
    'odbc__cant_parse_string' => "Kan verbindingsstring niet verwerken.",
    'odbc__connect_success' => "Verbinding succesvol",
    'odbc__driver_not_set' => "Stuurprogramma is niet ingesteld",
    'odbc__driver_or_name_not_set' => "Stuurprogramma of naam van de ODBC-verbinding zijn niet ingesteld",
    'odbc__dsn_already_exists' => "DSN met deze naam (%1) bestaat al in het systeem",
    'odbc__dsn_not_exists' => "Deze DSN bestaat niet",
    'odbc__enter_connection_params' => "Een ODBC-verbinding instellen",
    'odbc__enter_dsn_name' => "Voer DSN-naam in",
    'odbc__invalid_dsn_name' => "Verkeerde syntaxis voor ODBC-verbindingsnaam (%1): gebruik alleen alfanumerieke karakters.",
    'odbc__no_such_driver' => "ODBC-stuurprogramma met deze naam (%1) wordt niet ondersteund.",
    'odbc__remove_page_title' => "De volgende ODBC DSN-koppelingen zullen worden verwijderd:",
    'odbc__select_dsn_to_remove' => "Selecteer DSN's om te verwijderen.",
    'odbc__unknown_driver' => "Onbekende naam stuurprogramma (%1).",
    'odbc_add_new' => "Een DSN-verbinding toevoegen",
    'odbc_driver' => "Stuurprogramma",
    'odbc_dsn_description' => "Omschrijving van de koppeling",
    'odbc_dsn_list' => "ODBC DSN-koppelingen",
    'odbc_dsn_name' => "Naam van de koppeling",
    'odbc_dsn_system' => "Systeem-DSN",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => 'Een ODBC DSN toevoegen',
    'odbc_req_field_not_set' => "Vereiste parameters zijn niet opgegeven.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'Zoekpad naar databasebestand',
    'odbc__access_pagetimeout' => 'De tijdsduur, in tienden van seconden, dat een ongebruikte pagina in de buffer blijft. Deze optie is van toepassing op alle gegevensbronnen die gebruik maken van het stuurprogramma van Microsoft Access.',
    'odbc__access_maxbuffersize' => 'De omvang van de interne buffer, in KB, in lijn gebracht met de 256 KB-grens.',
    'odbc__access_readonly' => 'Wijst de database aan als alleen-lezen om gedeelde updates te verbieden.',
    'odbc__access_exclusive' => 'Wijst de database aan als exclusief om gedeelde updates te verbieden.',
    'odbc__access_safetransactions' => 'Indien ingesteld op 0 (de standaardinstelling) worden alle transacties direct verwerkt. Indien ingesteld op 1 worden alle transacties pas op de schrijf opgeslagen bij een verwerkingsopdracht, maar daardoor worden de prestaties enigszins aangetast.',
    'odbc__access_threads' => 'Het aantal achtergrondthreads dat de engine kan gebruiken.',
    'odbc__access_maxscanrows' => "Het aantal rijen dat nagekeken moet worden als het datatype van een kolom wordt ingesteld aan de hand van bestaande gegevens.",
    'odbc__access_implicitcommitsync' => 'Geeft aan hoe wijzigingen die buiten een transactie om worden gemaakt moeten worden weggeschreven in de database.',
    'odbc__access_usercommitsync' => 'Geeft aan of het stuurprogramma van MS Access expliciet door de gebruiker ingestelde transacties asynchroon zal uitvoeren.',
    'odbc__mssql_server' => 'Server',
    'odbc__mssql_uid' => 'Aanmeldingskenmerk',
    'odbc__mssql_pwd' => 'Wachtwoord',
    'odbc__mssql_database' => 'Standaard database voor de ODBC-gegevensbron',
    'odbc__mssql_app' => 'Naam van toepassing',
    'odbc__mssql_wid' => 'Werkstation-id',
    'odbc__mssql_language' => 'Standaard te gebruiken nationale taal',
    'odbc__mssql_oemtoansi' => 'Omzetting van speciale karakters naar OEM-waarden',
    'odbc__mysql_server' => 'De hostnaam van de MySQL-server',
    'odbc__mysql_database' => 'De standaarddatabase',
    'odbc__mysql_user' => 'De gebruikersnaam om verbinding te maken met MySQL',
    'odbc__mysql_password' => 'Het wachtwoord voor het gebruikeraccount op de server',
    'odbc__mysql_port' => 'De TCP/IP-poort die gebruikt moet worden voor andere servers dan localhost',
    'odbc__mysql_socket' => 'Windows named pipe om verbinding te maken als de server \'localhost\' is',
    'odbc__mysql_option' => 'Opties die aangeven hoe MyODBC zou moeten werken. Zie <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'Zoekpad DB-bestand',
    'odbc__excel_defaultdir' => 'Standaard gegevensmap',
    'odbc__excel_fil' => 'Databaseversie',
    'odbc__excel_maxbuffersize' => 'Maximale omvang van buffer',
    'odbc__excel_pagetimeout' => 'Pagina-timeout',

    'pb__aliases' => "Aliassen",
    'pb__anonftp' => "Anonieme FTP",
    'pb__autoinstaller_releases' => 'Updates',
    'pb__cert' => "Certificaten",
    'pb__cl_pool' => "IP-adressen",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Instellingen",
    'pb__cl_rpt' => "Verslag",
    'pb__cl_rpt_list' => "Aanpassen",
    'pb__cl_templates' => "Cliëntsjablonen",
    'pb__cl_traffic' => "Dataverkeer",
    'pb__cl_traffic_history' => "Overzicht van verbruikt dataverkeer",
    'pb__cl_traffic_of' => "Dataverkeer van %1",
    'pb__client' => "%1",
    'pb__clients' => "Cliënten",
    'pb__comp_info' => "Servercomponenten",
    'pb__common_acl' => 'ACL-overdracht toestaan',
    'pb__cp_access' => "Toegang",
    'pb__crontab' => "Takenrooster",
    'pb__scheduler' => "Takenrooster",
    'pb__custom_buttons' => "Eigen knoppen",
    'pb__databases_db' => 'Databases',
    'pb__sqlservers_db' => 'SQL-servers',//to check
    'pb__db' => "Databases",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Database-servers',
    'pb__dl_usr_ed' => "Domeinbeheerder",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Domeinbeperkingen",
    'pb__dom_pref' => "Instellingen",
    'pb__dom_sum_report' => "Samenvattend domeinverslag",
    'pb__dom_templates' => "Domeinsjablonen",
    'pb__dom_traffic' => "Dataverkeer van %1",
    'pb__dom_traffic_history' => "Overzicht van verbruikt dataverkeer",
    'pb__domains' => "Domeinen",
    'pb__domain_aliases' => 'Domeinaliassen',
    'pb__dumps_list' => "Opslag van reservekopieën",
    'pb__forwarding_setup' => "Doorschakelinstellingen",
    'pb__filemanager' => "Bestandsbeheer",
    'pb__ip_aliasing' => "IP-adressen",
    'pb__ip_clients' => "Verwijdering IP-adressen",
    'pb__license_management' => 'Licentiebeheer',
    'pb__locales' => 'Landinstellingen',
    'pb__log_files' => "Logbestanden",
    'pb__mail' => 'Mail',
    'pb__mail_blocked_domains' => 'Zwarte lijst',
    'pb__mail_name_files' => "Bijlagen",
    'pb__mail_name_redirects' => "Doorstuuradressen e-mail",
    'pb__mail_name_resp_attach_add' => "Nieuwe bijlage",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Automatische beantwoordingen e-mail",
    'pb__mail_names' => "Mail",
    'pb__mail_white_list' => 'Witte lijst',
    'pb__maillists' => "Verzendlijsten",
    'pb__mimetypes' => 'MIME-typen',
    'pb__modules' => 'Extensies',
    'pb__modules_management' => 'Modules beheren',
    'pb__notifications' => "Meldingen",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Instellingen fysieke hosting",
    'pb__prtd_dirs' => "Afgeschermde mappen",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Verslag",
    'pb__report_auto' => "Bezorgrooster voor %1",
    'pb__report_list' => "Aanpassen",
    'pb__server' => "Server",
    'pb__sessions' => "Sessies",
    'pb__sapp_pool' => "Groep van Webtoepassingen",
    'pb__siteapp_install' => 'Installatie van webtoepassing',
    'pb__site_app_pkgs' => 'Webtoepassingen',
    'pb__site_apps' => "Webtoepassingen",
    'pb__additional_key_info' => 'Eigenschappen van sleutel',
    'pb__additional_key_properties' => 'Eigenschappen van sleutel',
    'pb__skeleton' => 'Sjabloon voor virtuele hosts',
    'pb__skins' => 'Thema\'s',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Spamfilter",
    'pb__statistics' => "Statistieken",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomeinen",
    'pb__templates' => "Sjablonen",
    'pb__virtualdirs' => 'Virtuele mappen',
    'pb__web_users' => "Webgebruikers",
    'pb__webalizer_preferences' => 'Instellingen voor webstatistieken',
    'pdir__enter_dir_name' => "Voer mapnaam in.",
    'pdir__invalid_hst' => "Type hosting is ongeldig: moet fysiek zijn.",
    'pdir__pd_id_is_undefined' => "ID van afgeschermde map is niet opgegeven.",
    'pdir__pdir_exist' => "Map met deze naam is reeds afgeschermd.",
    'pdir__pdir_not_exist' => "Afgeschermde map bestaat niet.",
    'pdir__pdir_usr_not_exist' => "Gebruiker van afgeschermde map bestaat niet.",
    'pdir__prdirs_for_domain' => "Afgeschermde mappen binnen de website %1",
    'pdir__prdirs_for_subdomain' => "Afgeschermde mappen binnen subdomein %1",
    'pdir__remove_pdir_usrs' => "De volgende gebruikers van afgeschermde map %2 in de website %1 zullen worden verwijderd:",
    'pdir__remove_pdir_usrs_on_subdom' => "De volgende gebruikers van afgeschermde map %2 in subdomein %1 zullen worden verwijderd:",
    'pdir__remove_pdirs_on_dom' => "Deze bewerking zal ertoe leiden dat de mappen van website %2 van cliënt %1 niet langer worden afgeschermd. De mappen zelf zullen niet worden verwijderd.",
    'pdir__remove_pdirs_on_subdom' => "Deze bewerking zal ertoe leiden dat de mappen binnen het subdomein %1 niet langer worden afgeschermd. De mappen zelf zullen niet worden verwijderd.",
    'pdir__select_pdir_usrs_for_remove' => "Selecteer de gebruikers van afgeschermde mappen om te verwijderen.",
    'pdir__select_pdirs_to_remove' => "Selecteer de mappen die u niet langer wilt afschermen.",
    'pdir__unable_define_pdir_users' => "Kan de afgeschermde mapgebruikers niet definiëren.",
    'pdir__unable_define_pdirs_properties' => "Kan de eigenschappen van afgeschermde mappen niet instellen: %1",
    'pdir__unable_select_dom_param' => "Kan de domeinparameters niet selecteren: %1",
    'pdir_ed__create_pdir_for_domain' => "Een beschermde map aanmaken voor site %1",
    'pdir_ed__create_pdir_for_subdomain' => "Een afgeschermde map aanmaken binnen het subdomein %1",
    'pdir_ed__dir_already_protect' => "Deze map is reeds afgeschermd.",
    'pdir_ed__head_txt' => "Titel van de afgeschermde omgeving",
    'pdir_ed__invalid_login' => "U hebt een onjuiste gebruikersnaam opgegeven.",
    'pdir_ed__login_exists' => "Deze gebruiker bestaat al. Probeer een andere gebruikersnaam op te geven.",
    'pdir_ed__new_usr' => "Gebruikersnaam",
    'pdir_ed__non_ssl' => "niet-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Mapnaam",
    'pdir_ed__pdir_for_domain' => "Afgeschermde map %1 op domein %2",
    'pdir_ed__pdir_for_subdomain' => "Afgeschermde map %1 binnen subdomein %2",
    'pdir_ed__pdir_location' => "Maplocatie",
    'pdir_ed__pdir_users' => "Gebruikers van afgeschermde map",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "SSL/TLS wordt niet ondersteund door deze site of dit is niet in uw abonnement inbegrepen. Om ondersteuning voor SSL/TLS in te schakelen gaat u naar het tabblad Websites & domeinen en u klikt op de naam van uw domein in de lijst. Als uw abonnement geen ondersteuning voor SSL/TLS bevat, neem dan contact op met uw hostingprovider voor een upgrade van uw hostingpakket.",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "SSL/TLS wordt niet ondersteund door deze site. Om ondersteuning voor SSL/TLS in te schakelen gaat u naar het tabblad Websites & domeinen en u klikt op de naam het domein in de lijst.",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Er moet tenminste een van de volgende twee selectievakjes zijn geselecteerd: SSL/TLS en niet-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Kan de afgeschermde mapgebruiker niet aanmaken: %1",
    'pdir_ed__unable_create_pdir' => "Kan de afgeschermde map niet aanmaken: %1",
    'pdir_ed__unable_define_hst_type' => "Kan het type hosting niet definiëren.",
    'pdir_ed__unable_update_pdir' => "Kan de instellingen van de afgeschermde map niet opslaan: %1",
    'pdir_ed__wrong_symbol_in_header' => "Gebruik niet het symbool %1 in de titel van de map.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Gebruiker voor de afgeschermde map %1 aanmaken",
    'pdir_usr_ed__not_create_pass' => "Dit zal geen wachtwoord aanmaken voor de nieuwe afgeschermde mapgebruiker.\nZonder wachtwoord zal de gebruiker zich niet kunnen aanmelden.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Wachtwoord voor gebruiker van afgeschermde map %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Kan de afgeschermde mapgebruiker niet selecteren: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Kan de afgeschermde mapgebruikers niet definiëren: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Kan de afgeschermde mapgebruikers niet verwijderen: %1",
    'pdirs_list__name' => "Naam",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "S",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "Kan de afgeschermde mappen niet verwijderen: %1",
    'phosting__anonftp_disabled' => "Anonieme FTP is niet beschikbaar voor dit domein omdat het IP-adres al in gebruik is voor anonieme FTP op een ander domein.",
    'phosting__anonftp_encrypt' => 'Het wachtwoord van de FTP-gebruiker is versleuteld en kan daarom niet worden gebruikt om de map /plesk-stat/webstat/ te beveiligen. Voer uw FTP-wachtwoord opnieuw in, of zorg dat de optie " toegankelijk via met wachtwoord afgeschermde map \'/plesk-stat/\'" niet is geselecteerd',
    'phosting__hosting_and_dns_ip_difference_warning' => "De domeinnaam %%domain_name%% verwijst naar het IP-adres %%dns_ip_address%%. Uw website heeft als IP-adres toegewezen gekregen %%hosting_ip_address%%. Als uw website niet wordt geopend in de browser wanneer u deze via de domeinnaam probeert op te vragen, ga dan naar de pagina voor DNS-beheer (Domeinen > domeinnaam > DNS) en wijzig de eigenschappen van het DNS A-record: wijs het IP-adres %%hosting_ip_address%% toe aan de domeinnaam %%domain_name%%.",
    'phosting__ip_change_warning' => "IP-adres gewijzigd. De overeenkomstige veranderingen zijn ook doorgevoerd in de DNS-zone van het domein.",
    'phosting__other_hosting_exists_on_ip' => "Kan het certificaat niet wijzigen om dit IP-adres wordt gebruikt binnen één of meer hostingaccounts.",
    'phosting__unable_to_change_certificate' => "Kan het certificaat niet installeren: %1",
    'phosting__unable_to_change_ip_address' => "Kan het IP-adres niet wijzingen: %1",
    'phosting__unable_to_set_cert' => "Kan het SSL/TLS-certificaat niet instellen: %1",
    'phosting__unable_update' => "Kan hostinginstellingen niet bijwerken: %1",
    'phosting__unable_manage' => "Kan hosting niet beheren: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Kan fail2ban niet instellen om logboeken van het domein bij te houden. Logs zullen automatisch worden bijgehouden nadat de fail2ban-service de volgende keer opnieuw is opgestart. \n%1",

    'picker_acl_record__tittle' => 'Selecteer een ACL-record',
    'picker_autoresponder__title' => 'Een automatische beantwoording selecteren',
    'picker_black_list__domain_name' => 'Selecteer een domeinnaam',
    'picker_certificate' => 'Selecteer een SSL/TLS-certificaat',

    'picker_dns_zone_template__title' => 'Selecteer een DNS-record',
    'picker_domain__title' => 'Een website selecteren',
    'picker_domain_alias__title' => 'Selecteer een domeinalias',
    'picker_resource_record__title' => 'Selecteer een DNS-record',
    'picker_disabled_resource_record__title' => 'Selecteer een naamserver',
    'picker_ip_address__title' => 'Selecteer een IP-adres',
    'picker_ip_address_clients__title' => 'Selecteer cliënten die dit IP-adres gebruiken',
    'picker_mail_queue' => 'Selecteer e-mailberichten',
    'picker_site_application__title' => 'Selecteer een webtoepassing',
    'picker_subdomain__title' => 'Selecteer een subdomein',
    'picker_web_user__title' => 'Selecteer een webgebruiker',
    'picker_custom_button__title' => 'Selecteer een Eigen knop',
    'picker_license_key__title' => "Selectie van licentiesleutel",
    'picker_spamfilter_address__title' => 'Selecteer een spamfilteradres',
    'picker_white_list__networks' => 'Netwerkselectie',

    'plesk_key__action_logs' => "Bewerking van gebruikers van Plesk vastleggen in logboek",
    'plesk_key__app_vault' => "Programmabibliotheek",
    'plesk_key__backup' => "Functies voor aanmaken en terugplaatsen van reservekopieën",
    'plesk_key__client_templs' => "Beheer pakketsjablonen",
    'plesk_key__clients' => "Gebruikeraccounts (resellers en cliënten)",
    'plesk_key__resellers_only' => "Gebruikersaccounts (resellers)",
    'plesk_key__customers_only' => "Gebruikersaccounts (cliënten)",
    'plesk_key__domains' => "Domeinen",
    'plesk_key__domain_aliases' => "Domeinaliassen",
    'plesk_key__manage_dashboard' => 'Aanpassen van startpagina',
    'plesk_key__drweb' => "Beheer antivirus",
    'plesk_key__event_manager' => "Eventbeheer",
    'plesk_key__expirations' => "Beheer van verloopdatums van accounts",
    'plesk_key__group_ops' => "Aanpassen van meerdere elementen tegelijk",
    'plesk_key__expiration' => "Verloopdatum sleutel",
    'plesk_key__edition_name' => "Plesk-editie",
    'plesk_key__key_number' => "Sleutelnummer",
    'plesk_key__languages' => "Taalpakketten",
    'plesk_key__mailnames' => "Mailaccounts",
    'plesk_key__migration_manager' => "Migratie- en verhuismanager",
    'plesk_key__mssql' => "Ondersteuning van Microsoft SQL-server",
    'plesk_key__myplesk_func' => "Links voor het aanschaffen van SSL/TLS-certificaten en voor het registreren van domeinen",
    'plesk_key__myplesk_server_id' => "MPC secundaire server-identificatie",
    'plesk_key__notifications' => "Beheer meldingen",
    'plesk_key__postgresql' => "Ondersteuning van PostgreSQL-server",
    'plesk_key__qmail_queue' => 'Beheer mailwachtrij',
    'plesk_key__remote_db' => 'Externe databasehosting',
    'plesk_key__slave_servers' => "Secundaire servers (slaves)",
    'plesk_key__spamassassin' => "Beheer spamfilter",
    'plesk_key__subdomains' => "Beheer subdomeinen",
    'plesk_key__sys_access' => "Beheer van toegang tot de server",
    'plesk_key__traffic_reports' => "Verslagen van dataverkeerverbruik",
    'plesk_key__tts' => "Helpdesk",
    'plesk_key__virtuozzo' => "Alleen geldig voor Virtuozzo containers",
    'plesk_key__webusers' => "Webgebruikers",
    'plesk_key__license_update_date' => 'Volgende update van de licentiesleutel',
    'plesk_key__autoinstaller_config' => 'Beheer update-instellingen',
    'plesk_key_update__title' => 'Voortgang bijwerken sleutel',
    'plesk_key_update__legend' => 'Voortgang bijwerken sleutel',
    'plesk_key_update__new_additional_key' => 'Nieuwe extra sleutel ontvangen',
    'plesk_key__check_wrong' => "De licentiesleutel is ongeldig. Om Plesk te gebruiken dient u een nieuwe geldige licentiesleutel te verkrijgen en installeren.",
    'plesk_key__upload_check_wrong' => 'Geüploade licentiesleutel is niet geldig.',
    'plesk_key__revert_check_wrong' => 'De eerder geïnstalleerde licentiesleutel is niet geldig.',
    'plesk_key__update_check_wrong' => 'Bijgewerkte licentiesleutel is niet geldig.',
    'plesk_key__viruozzo_only_key' => 'De licentiesleutel is alleen bedoeld voor gebruik van Plesk binnen Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'U kunt deze officiële versie van Plesk alleen gebruiken met de volgende IP-adressen: %2. De volgende IP-adressen zijn niet gedekt onder uw licentie: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'De hoeveelheid momenteel gebruikte middelen overschreidt de beperkingen die door uw licentie worden aangegeven.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Het aantal websites dat op uw de server wordt gehost overschrijdt de beperking van uw licentie. U host %2 sites; uw licentie staat slechts het hosten van %1 sites toe.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Het aantal domeinaliassen op de server overschrijdt de beperking van uw licentie. U hebt %2 domeinaliassen; uw licentie staat slechts de hosting van %1 domeinaliassen toe.',
    'plesk_key__limits_exceeded_lim_cl' => 'Het aantal gebruikte cliëntaccounts overschrijdt de beperking van uw licentie. U hebt momenteel %2 cliëntaccounts in gebruik; uw licentie staat slechts %1 cliëntaccounts toe.',
    'plesk_key__limits_exceeded_lim_mn' => 'Het aantal gebruikte mailaccounts overschrijdt de beperking van uw licentie. U hebt momenteel %2 cliëntaccounts in gebruik; uw licentie staat slechts %1 cliëntaccounts toe.',
    'plesk_key__limits_exceeded_lim_wu' => 'Het aantal gebruikte webgebruikeraccounts overschrijdt de beperking van uw licentie. U hebt momenteel %2 webgebruikeraccounts in gebruik; uw licentie staat slechts %1 webgebruikeraccounts toe.',
    'plesk_key__limits_exceeded_MLS' => 'Het aantal taalpakketten dat momenteel is geïnstalleerd overschrijdt de beperking die door uw licentie wordt gesteld. Er zijn %2 taalpakketten geïnstalleerd; uw licentie staat slechts de installatie van %1 taalpakketten toe.',
    'plesk_key__wrong_version' => 'U probeert een licentiesleutel te gebruiken die bedoeld is voor een andere versie van Plesk. Neem contact op met een vertegenwoordiger van Plesk voor het aanvragen van de juiste licentiesleutel.',
    'plesk_key__other_product' => 'U probeert een licentiesleutel te gebruiken die voor een ander product is bedoeld. Neem contact op met een vertegenwoordiger van Plesk voor het aanvragen van de juiste licentiesleutel.',
    'plesk_key__limits_exceeded_error' => 'Kan de licentiesleutel niet installeren: de momenteel gebruikte hoeveelheid middelen overschrijdt de beperkingen van de geüploade licentiesleutel.',
    'plesk_key__limits_exceeded_note' => 'Het huidige Plesk gebruikt meer middelen dan toegestaan door de geüploade licentiesleutel.',
    'plesk_key__key_file_invalid' => 'Het geüploade sleutelbestand is niet geldig of bevat geen licentiesleutel.',
    'plesk_key__server_request_error' => 'Kan de licentie niet bijwerken. Zorg ervoor dat verbindingen met licentieserver ka.plesk.com op TCP-poort %1 niet worden geblokkeerd. <a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">Hier ziet u hoe u dit doet</a>.',
    'key__title' => 'Licentiebeheer',
    'key__upload_title' => 'Een licentiesleutel installeren',
    'key__no_key_file_in_zip' => 'Het geüploade .zip-bestand bevat geen licentiesleutelbestand',
    'key__key_upload' => 'Installatie van licentiesleutel',
    'key__tabs_plesk' => 'Plesk-licentiesleutel',
    'key__tabs_additional' => 'Extra licentiesleutels',
    'key_revert__title' => 'Vorige licentiesleutel terugplaatsen',
    'key_revert__legend' => 'Bevestiging terugzetten van vorige licentiesleutel',
    'key_revert__text' => 'De licentiesleutel met de volgende eigenschappen zal worden teruggezet:',
    'key__license_update_date_hint' => 'De verloopdatum zal automatisch worden verlengd op %%license_update_date%%. Om deze automatisch bij te werken moet u verbinding toestaan met %%keyserver_host%%. Voor meer informatie, zie het %%help begin:lim_date%%volgende Help-onderwerp%%help end:lim_date%%.',
    'additional_key__info' => 'Eigenschappen extra sleutel',
    'additional_key__prop_name' => 'Eigenschap',
    'additional_key__prop_value' => 'Waarde',
    'additional_key__descr_name' => 'Sleutelnaam',
    'additional_key__descr_key_number' => 'Sleutelnummer',
    'additional_key__descr_key_vz' => "Deze licentiesleutel is alleen bedoeld voor gebruik in Virtuozzo containers.",
    'additional_key__descr_lim_date' => 'Verloopdatum',
    'additional_key__descr_license_update_date' => 'Volgende update van de licentiesleutel',
    'additional_key__remove_title' => "De webtoepassingssleutel met de volgende eigenschappen zal worden verwijderd:",
    'additional_keys__remove_title' => "De volgende extra sleutels zullen worden verwijderd:",
    'additional_keys__select_to_remove' => 'Selecteerde de extra sleutels die u wilt verwijderen.',
    'additional_key__file_invalid' => 'Het geüploade sleutelbestand is niet geldig of bevat geen licentiesleutel.',
    'additional_key__file_incompatible' => 'Het geüploade sleutelbestand is niet geldig voor deze toepassing.',
    'additional_key__expired' => 'De extra sleutel is verlopen.',
    'additional_key__not_exists' => 'Geen licentiesleutel geïnstalleerd.',
    'additional_key__viruozzo_only_key' => 'Deze licentiesleutel is alleen bestemd voor gebruik met Plesk geïnstalleerd in Virtuozzo containers.',
    'additional_keys__legend' => 'Extra sleutels',
    'additional_keys__list_header' => 'Extra sleutels',
    'additional_key_update__result_response' => 'Antwoord licentieserver: %1',
    'additional_key_update__result_network' => 'Kan geen verbinding maken met de licentieserver. Zorg ervoor dat uw netwerk communicatie toestaat met %1: %2.',
    'additional_key_update__result_lock' => 'De sleutel wordt op dit moment al bijgewerkt',
    'additional_key_update__result_internal_error' => 'Er is een fout opgetreden tijdens het bijwerken van de licentiesleutel: %1',

    'additional_key_revert__title' => 'Bevestig de bewerking',
    'additional_key_revert__legend' => 'Eigenschappen van de laatst gebruikte extra sleutel',
    'additional_key_revert__confirm_text' => 'Sleutel terugplaatsen',
    'additional_key_revert__confirm_required' => 'Bevestig de bewerking.',

    'proceed_to_cl_pool' => "Ga door naar het instellen van de IP-voorziening van de cliënt",
    'proceed_to_hosting_setup' => "Ga door naar het instellen van hosting",
    'removeCerts__remove_certificates_cp' => "De volgende certificaten zullen worden verwijderd:",
    'removeCerts__remove_certificates_domain' => "De volgende certificaten van %1 zullen verwijderd worden:",
    'removeClientsIP_remove_clients_ip' => "Dit IP-adres zal worden verwijderd uit de voorziening van volgende cliënten:",
    'removeMailAliases__remove_mail_aliases' => "De volgende mailaliassen voor het mailaccount %1 zullen worden verwijderd:",
    'removeMailNames__remove_mailnames' => "De volgende mailaccounts en -aliassen zullen worden verwijderd van het domein %1:",
    'removeMailNames__remove_mailnames_of_cl' => "De volgende mailaccounts en aliassen zullen worden verwijderd van domein %2, dat hoort bij cliënt %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Deze mailaccounts zullen niet worden verwijderd.",
    'removeFtpSessions__remove_title' => "De volgende FTP-sessies zullen worden beëindigd:",
    'removeTemplates__remove_templates' => "De volgende sjablonen zullen worden verwijderd:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'Frequentie',
    'report_auto__list_last' => 'Laatste bezorgdatum',
    'report_auto__list_recipient' => 'Bezorgen aan',
    'report_auto__list_select' => 'Verslaglegging aan',
    'report_auto__title' => 'Bezorgroosters voor %1',
    'report_auto__recipient_email' => 'het door mij opgegeven e-mailadres',
    'report_auto__recipient_admin' => 'de serverbeheerder',
    'report_auto__recipient_client' => 'de cliënt',
    'report_auto__recipient_domain' => 'de domeinbeheerder',
    'report_auto_edit__select' => 'Verslaglegging aan',
    'report_auto__select_client_report_all' => 'alle cliënten',
    'report_auto__select_client_report_current' => 'deze cliënt',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'alle domeinen',
    'report_auto__select_domain_report_other_client' => 'alle domeinen van %1',
    'report_auto__select_domain_report_client' => 'alle domeinen van deze cliënt',
    'report_auto__select_domain_report_reseller' => 'alle domeinen van deze reseller',
    'report_auto__select_domain_report_current' => 'dit domein',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Bezorgroosters',
    'report_auto__select_for_remove' => "Selecteer de bezorgroosters om te verwijderen.",
    'report_auto_remove__title' => "De volgende verslagbezorgroosters zullen worden verwijderd:",
    'report_auto_edit__title' => 'Eigenschappen bezorgrooster',
    'report_auto_edit__recipient' => 'Bezorgen aan',
    'report_auto_edit__target' => 'Verslaglegging aan',
    'report_auto_edit__auto' => 'Bezorgingsfrequentie',
    'resp_edit__always_respond' => "altijd beantwoorden",
    'resp_edit__reply_subject' => "Onderwerpregel van beantwoording",
    'resp_edit__answer_subject' => "Beantwoorden met onderwerp",
    'resp_edit__answer_txt' => "Beantwoord met tekst",
    'resp_edit__attach' => "Bestanden bijsluiten",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "voor",
    'resp_edit__frw_rqst_email' => "Stuur bij een automatisch antwoord het originele bericht door naar de opgegeven e-mail",
    'resp_edit__fwd_email_invalid' => "E-mailadres van ontvanger is ongeldig.",
    'resp_edit__in_body' => "wanneer er specifieke woorden worden gevonden in de tekst van het bericht",
    'resp_edit__in_subject' => "wanneer er specifieke woorden worden gevonden in de onderwerpregel van het bericht",
    'resp_edit__invalid_resp_freq' => "Antwoordfrequentie is ongeldig.",
    'resp_edit__invalid_rqst_txt' => "Ongeldige aanvraagtekst.",
    'resp_edit__invalid_store_lim_num' => "Waarde van de beperking is ongeldig.",
    'resp_edit__limits_title' => "Beperkingen",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Maximaal aantal antwoorden per dag overschrijdt de vastgestelde hoeveelheid. Toegestaan: %1, gevraagd: %2",
    'resp_edit__no_files_sel' => "Geen bestanden geselecteerd.",
    'resp_edit__no_txt_supplied' => "Geen tekst opgegeven.",
    'resp_edit__reply_title' => "Beantwoorden",
    'resp_edit__reply_to_address' => "Antwoordadres",
    'resp_edit__reply_to_invalid' => "Antwoordadres is ongeldig.",
    'resp_edit__reply_uniq_email' => "Stuur een antwoord naar het unieke e-mailadres niet vaker dan",
    'resp_edit__conditions_title' => "Voorwaarden",
    'resp_edit__request_title' => "Aanvragen",
    'resp_edit__resp' => "Automatische beantwoording",
    'resp_edit__resp_name' => "Naam van automatische beantwoording",
    'resp_edit__resp_not_exist' => "Automatische beantwoording bestaat niet.",
    'resp_edit__resp_status' => "Status van automatische beantwoording",
    'resp_edit__rqst_txt' => 'Specificeer de voorwaarde voor dit automatische antwoord',
    'resp_edit__select_files_on_server_for_attach' => "Selecteer de bestanden die u wilt aanhechten",
    'resp_edit__store_up_to' => "Maximaal opslaan",
    'resp_edit__subj_line_invalid' => "De onderwerpregel is incorrect.",
    'resp_edit__text_too_big' => "De tekst van het antwoordbericht is te lang.",
    'resp_edit__times_in_a_day' => "keer per dag.",
    'resp_edit__unable_define_resp_cond' => "Kan de voorwaarde voor automatische beantwoording niet vaststellen: %1",
    'resp_edit__unable_define_resp_status' => "Kan status van automatische beantwoording niet vaststellen: %1",
    'resp_edit__unable_turn_on_resp' => "Kan de automatische beantwoording niet inschakelen: %1",
    'resp_edit__uniq_email' => "unieke e-mailadressen",
    'resp_edit__content_type' => 'Formaat om mails te versturen',
    'resp_edit__content_type_text' => 'Platte tekst',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Codering',
    'restart__dns' => 'DNS-server (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 Server (%1)",
    'restart__mssql' => "Microsoft SQL server",
    'restart__mysql' => "MySQL-server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Diensten",
    'restart__smtp' => "SMTP-server (%1)",
    'restart__spamd' => "Spamfilter",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Webserver (%1)",
    'restart__ftp' => "FTP-server (%1)",
    'restart__service_start' => 'Het kan enige tijd duren voordat de service is opgestart.',
    'restart__service_stop' => 'Het kan enige tijd duren voordat de service is afgesloten.',
    'restart__service_restart' => 'Het kan enige tijd duren voordat de service opnieuw is opgestart.',
    'rm_domains__some_domains_are_not_exist' => "Een aantal van de opgegeven domeinen bestaat niet. Deze zijn mogelijk verwijderd door een andere gebruiker.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroepen",
    'rpt_cl_dom_mail_lists' => "MLijsten",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBoxen",
    'rpt_cl_dom_redirects' => "Doorstuuradressen",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliassen",
    'rpt_cl_dom_web_users' => "WGebr",
    'rpt_cl_report_for_admin__' => "Verslag voor de beheerder %1",
    'rpt_cl_report_for_reseller__' => "Verslag voor de reseller %1",
    'rpt_cl_report_for_cl__' => "Verslag over de cliënt %1",
    'rpt_cl_section_domains' => "Domeinen",
    'rpt_cl_section_full_domains' => "Domeinen",
    'rpt_cl_section_general' => "Algemeen",
    'rpt_create' => "Verslag aanmaken",
    'rpt_empty' => "Het verslag moet ten minste één sectie bevatten",
    'rpt_default_report' => "Gebruiken als standaardverslag",
    'rpt_dom_report_for_dom__' => "Domeinverslag voor %1",
    'rpt_dom_section_databases' => "Databases",
    'rpt_dom_section_full_databases' => "Databases",
    'rpt_dom_section_full_maillists' => "Verzendlijsten",
    'rpt_dom_section_full_mailnames' => "Mailaccounts",
    'rpt_dom_section_full_webusers' => "Webgebruikers",
    'rpt_dom_section_full_siteapps' => 'Webtoepassingen',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET-webtoepassingen',
    'rpt_dom_section_general' => "Algemeen",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Verzendlijsten",
    'rpt_dom_section_mailnames' => "Mailaccounts",
    'rpt_dom_section_siteapps' => 'Webtoepassingen',
    'rpt_dom_section_aspnetapps' => 'ASP.NET-webtoepassingen',
    'rpt_dom_section_webusers' => "Webgebruikers",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Verslag %1 bewerken",
    'rpt_enter_email_address' => "Voer het e-mailadres in waar dit verslag moet worden bezorgd.",
    'rpt_list' => "Aangepaste verslagindelingen",
    'rpt_name' => "Verslagnaam",
    'rpt_remove_reports' => "De volgende verslagindelingen zullen verwijderd worden:",
    'rpt_reports' => "Verslagen",
    'rpt_section_full' => "Volledig",
    'rpt_section_none' => "Geen",
    'rpt_section_summary' => "Samenvatting",
    'rpt_select_reports_for_remove' => "Selecteer de verslagindelingen om te verwijderen.",
    'rpt_default_full' => 'Compleet verslag',
    'rpt_default_summary' => 'Samenvattend verslag',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Fout bij verzenden van het verslag: %1",
    'rpt_send_report_by_email_ok__' => "Het verslag is verzonden aan %1",
    'sa_action' => "Bewerking",
    'sa_action_del' => "Verwijderen",
    'sa_action_desc' => "Wat doen met spam mails",
    'sa_action_save' => "Als spam markeren en in postvak opslaan",
    'sa_admin_blacklist' => "Zwarte lijst van beheerder",
    'sa_admin_whitelist' => "Witte lijst van beheerder",
    'sa_blacklist' => "Zwarte lijst",
    'sa_blacklist_desc' => "Markeer mail van adressen altijd als spam",
    'sa_by_tag' => "naar kenmerk",
    'sa_conf_list_black' => "Weet u zeker dat u de geselecteerde patronen van de zwarte lijst wilt verwijderen?",
    'sa_conf_list_ignore' => "Weet u zeker dat u de geselecteerde patronen van de negeerlijst wilt verwijderen?",
    'sa_conf_list_white' => "Weet u zeker dat u de geselecteerde patronen van de witte lijst wilt verwijderen?",
    'sa_db_del_confirm' => "Weet u zeker dat u de database van het spamfilter wilt leegmaken?",
    'sa_disabled__mailserv_not_support_sa_mbox_settings' => "Spamfilter is uitgeschakeld: de mailserver ondersteunt geen instellingen van het spamfilter op het niveau van het postvak.",
    'sa_eml_in_ignorelist' => "E-mail staat op de negeerlijst",
    'sa_eml_pattern' => "E-mailpatroon",
    'sa_empty_email' => "Kan geen leeg e-mailpatroon toevoegen.",
    'sa_exists_email' => "Er bestaat al een dergelijk e-mailpatroon.",
    'sa_disabled__mailname_not_filtering' => "Huidige serverinstellingen staan het filteren van mail niet toe voor dit mailaccount",
    'sa_disabled__filtering_is_disabled' => 'Het detecteren van spam is uitgeschakeld door de beheerder van de server',
    'sa_disabled__hasnt_mailbox' => "Niet mogelijk om spamfiltering in te schakelen zonder een postvak",
    'sa_enable_filter' => "Het detecteren van spam inschakelen",
    'bt_sa_clear_db' => 'Database van spamfilter legen',
    'bt_sa_forget' => 'Vergeet het maar',
    'bt_sa_learn_as_spam' => "Het is spam!",
    'bt_sa_learn_as_nonspam' => "Het is geen spam",
    'sa_forget' => "vergeet",
    'sa_from' => "Van",
    'sa_ham' => "ham",
    'sa_ignorelist' => "Negeerlijst voor de server als geheel",
    'sa_ignorelist_desc' => "Mail voor deze accounts niet filteren",
    'sa_pattern_in_blacklist' => "Patroon bestaat al in zwarte lijst.",
    'sa_pattern_in_ignorelist' => "Patroon bestaat al in negeerlijst",
    'sa_pattern_in_whitelist' => "Patroon bestaat al in witte lijst.",
    'sa_pattern_is_invalid' => "Patroon is ongeldig.",
    'sa_select_email' => "Selecteer ten minste één e-mailpatroon uit de lijst om te verwijderen.",
    'sa_spam' => "Spam",
    'sa_trainer__page_title' => 'Training spamfilter',
    'sa_trainer__tools_legend' => 'Hulpprogramma\'s',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Berichten in uw postvak',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Onderwerp',
    'sa_trainer__from' => 'Van',
    'sa_trainer__date' => 'Datum',
    'sa_trainer__info_text' => 'Berichten onthouden: %1 als spam, %2 als niet-spam, %3 totaal.',
    'sa_trainer__messages' => 'bericht(en)',
    'sa_trainer__select__all' => 'Alle',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Niet-spam',
    'sa_trainer__select__unknown_only' => 'Onbekend',
    'sa_trainer__cannot_remove_messages' => 'Kan de geselecteerde bestanden niet uit het postvak verwijderen.',
    'sa_trainer__remove_messages_confirm' => 'Weet u zeker dat u de geselecteerde berichten uit het postvak wilt verwijderen?',
    'sa_srv_blacklist' => "Zwarte lijst voor de server als geheel",
    'sa_srv_whitelist' => "Witte lijst voor de server als geheel",
    'sa_subj' => "Onderwerp",
    'sa_training' => "Training spamfilter",
    'sa_training_legend' => "Bayesian-filtertraining",
    'sa_use_srv_settings' => "Instellingen gebruiken die gelden voor de server als geheel",
    'sa_user_blacklist' => "Zwarte lijst van gebruiker",
    'sa_user_whitelist' => "Witte lijst van gebruiker",
    'sa_usr_disabled_by_srv' => "Individuele spamfilterinstellingen worden door de serverbeheerder niet toegestaan",
    'sa_usr_no_postbox' => "Kan geen spamfilter inschakelen, omdat het postvak voor dit e-mailaccount is uitgeschakeld.",
    'sa_whitelist' => "Witte lijst",
    'sa_whitelist_desc' => "Mail van adressen die nooit als spam gemarkeerd mag worden",
    'sa_filters' => 'Spamfilters',
    'sa_max_mail' => 'Niet filteren als de mail groter is dan de opgegeven omvang',
    'sa_size_limit_text' => 'maximale grootte',
    'sa_invalid__max_spam_threads' => 'Ongeldige waarde: geef een waarde op tussen 1 en 32.',
    'sa_max_threads' => 'Aantal threads dat het spamfilter kan opstarten',
    'sa_max_threads_maximum' => '(maximaal 32)',
    'sa_disabled__spamfilter_not_support_sa_max_threads_limit' => '(niet beschikbaar: het huidige spamfilter ondersteunt deze mogelijkheid niet)',
    'spamfilter__tools_legend' => 'Hulpprogramma\'s',
    'spamfilter__prefs_legend' => 'Instellingen',
    'spamfilter__max_children' => 'Het maximaal aantal worker spamd-processen dat kan worden uitgevoerd',
    'spamfilter__rewrite_header_subject_hint' => 'Laat dit veld leeg als u geen tekst wilt toevoegen. Type _SCORE_ als u de score aan de onderwerpregel van het bericht wilt toevoegen.',
    'spamfilter__reject_spam' => 'Spam verwijderen wanneer deze het postvak binnenkomt',
    'spamfilter__enabled' => 'Ingeschakeld',
    'spamfilter_addresses_list__tools_legend' => 'Hulpprogramma\'s',
    'spamfilter_addresses_list__list_legend' => 'Adressen',
    'spamfilter_addresses_list__items' => 'adressen',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => 'Adres',
    'spamfilter_addresses__file_legend' => 'Uit bestand',
    'spamfilter_addresses__file_label' => 'Bestandsnaam',
    'spamfilter_addresses__file_hint' => 'Upload een bestand in UTF-8 codering.',
    'spamfilter_addresses__text_legend' => 'Uit lijst',
    'spamfilter_addresses__text_label' => 'E-mailadressen',
    'spamfilter_addresses__remove_title' => 'De volgende adressen zullen van de lijst worden verwijderd:',
    'spamfilter_addresses__empty_selection' => 'Geen adressen geselecteerd.',
    'server__admin_info' => "Gegevens beheerder",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Geef hieronder de omschrijving van de fout op",
    'server__power_management' => "Energiebeheer",
    'server__services' => "Diensten",
    'server__system' => "Systeem",
    'server__title' => "Serverbeheer",
    'server_preferences__admin_skin' => "Thema van beheerder",
    'server_preferences__count_disk_space' => "Meenemen bij de berekening van het schijfruimtegebruik",
    'server_preferences__count_traffic' => "Meenemen bij de berekening van het dataverkeer",
    'server_preferences__count_type' => 'Bij het berekenen van de schijfruimte, reken',
    'server_preferences__count_type__byte' => 'bestandsgrootte',
    'server_preferences__count_type__block' => 'hoeveelheid verbruikte schijfruimte',
    'server_preferences__default_language' => "Standaardtaal",
    'server_preferences__default_skin' => "Standaardthema",
    'server_preferences__include_databases' => "databases",
    'server_preferences__include_domaindumps' => "reservekopieën van domeinen",
    'server_preferences__include_incoming' => "alleen inkomend dataverkeer",
    'server_preferences__include_incoming_and_outgoing' => "binnenkomend en uitgaand dataverkeer",
    'server_preferences__include_logs' => "logbestanden en statistische verslagen",
    'server_preferences__include_mailboxes' => "postvakken",
    'server_preferences__include_maillists' => "Verzendlijsten",
    'server_preferences__include_outgoing' => "alleen uitgaand dataverkeer",
    'server_preferences__include_remote_databases' => 'Externe databases',
    'server_preferences__keep_stats' => "Web- en dataverkeerstatistieken behouden gedurende",
    'server_preferences__restart_apache_interval' => "Apache-herstartinterval",
    'server_preferences__stat_warning' => "De wijzigingen die aangebracht zijn aan de berekening van het schijfruimtegebruik zullen pas bij de volgende berekening effectief zijn.",
    'server_preferences__title' => "Server-instellingen",
    'server_preferences__system' => 'Systeeminstellingen',
    'server_mail__title' => "Mailinstellingen voor de server als geheel",
    'mail__tabs_preferences' => "Instellingen",
    'mail__tabs_white_list' => "Witte lijst",
    'mail__tabs_blocked_domains' => "Zwarte lijst",
    'mail__tabs_mail_queue' => "Mailwachtrij",
    'server_preferences__use_vocabulary' => "De wachtwoorden voor postvakken in het woordenboek controleren",
    'sessions__agreement' => "Ja, ik wil deze sessies afsluiten.",
    'sessions__select_sessions_for_remove' => "Selecteer de sessies om af te sluiten.",
    'sessions__tabs_cp_sessions' => 'Plesk-sessies',
    'sessions__tabs_ftp_sessions' => 'FTP-sessies',
    'sessions__ftp_sessions_login' => 'Gebruikersnaam FTP-account',
    'sessions__ftp_sessions_domain' => 'Domeinnaam',
    'sessions__ftp_sessions_path' => 'Huidige locatie',
    'sessions__ftp_sessions_file' => 'Bestandsnaam',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Snelheid, KB/S',
    'sessions__ftp_sessions_comp' => 'Voortgang, %',

    'site_apps__access_level' => 'Toegangsniveau',
    'site_apps__access_level_commercial' => 'Commercieel',
    'site_apps__access_level_free' => 'Vrij',
    'site_apps__action_installer' => "Installatie van webtoepassing",
    'site_apps__action_reconfigure' => "Opnieuw instellen van webtoepassing",
    'site_apps__custom_button_level' => 'Wilt u een Eigen knop aanmaken om toegang te krijgen tot deze toepassing?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nee',
    'site_apps__custom_button_level_domain_user_only' => 'Ja',
    'site_apps__custom_button_level_false' => 'Nee',
    'site_apps__custom_button_level_domain' => 'Ja, en maak het beschikbaar voor alleen het huidige domein',
    'site_apps__custom_button_level_client' => 'Ja, en stel het beschikbaar aan alle domeinen van de cliënt.',
    'site_apps__custom_button_level_admin' => 'Ja, en maak het beschikbaar voor alle domeinen',
    'site_apps__description' => "Omschrijving",
    'site_apps__dir_used_by_sapp__' => "De map \"%1\" wordt gebruikt door een andere webtoepassing",
    'site_apps__dir_used_by_unknown__' => "De map \"%1\" bestaat al. Als u verder gaat zal de inhoud ervan worden overschreven.",
    'site_apps__dir_invalid_name__' => "De mapnaam %1 is onjuist",
    'site_apps__file_name' => 'Bestandsnaam van webtoepassing',
    'site_apps__invalid_install_prefix' => "Ongeldig installatievoorvoegsel",
    'site_apps__invalid_package' => "Webtoepassing is ongeldig",
    'site_apps__key_status' => 'Licentieverlening',
    'site_apps__key_status_free' => 'Vrije distributie, geen licentiesleutel vereist.',
    'site_apps__key_status_ok' => 'De vereiste licentiesleutel is geïnstalleerd',
    'site_apps__key_status_problem' => 'De vereiste licentiesleutel is niet geïnstalleerd',
    'site_apps__name' => "Naam",
    'site_apps__no_domains' => 'De webtoepassing kan niet worden geïnstalleerd: er is al een andere webtoepassing geïnstalleerd in de hoofdmap van dit domein. Overweeg het aanmaken van een subdomein voor deze webtoepassing.',
    'site_apps__package_info_' => "Informatie over webtoepassing",
    'site_apps__package_integrated' => "ingebouwde toepassing, kan niet worden verwijderd",
    'site_apps__pool_select_packages_to_add' => 'Selecteer de webtoepassingen die u aan de voorziening wilt toevoegen',
    'site_apps__release' => "Versie",
    'site_apps__resource_used_by_sapp' => "Deze middelen worden gebruikt door geïnstalleerde webtoepassing",
    'site_apps__root_used_by_sapp' => "Deze middelen worden gebruikt door een geïnstalleerde webtoepassing",
    'site_apps__these_domains_will_not_delete' => 'Deze (sub)domeinen zullen niet worden verwijderd',
    'site_apps__upload_site_app_pkg_title' => 'Nieuwe webtoepassing uploaden',
    'site_apps__version' => "versie",
    'site_apps__access_to' => "Toegang tot %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Sjabloon voor virtuele hosts",
    'skeleton__client_label' => "%1 sjabloon voor virtuele hosts",
    'skeleton__admin_page' => "Sjabloon voor virtuele hosts beheren",
    'skeleton__files_list' => "Bestanden en mappen",
    'skeleton__archiver_not_installed' => "Kan het archief niet uitpakken. Decompressieprogramma is wellicht niet op de server geïnstalleerd. Neem contact op met de {$PROD_NAME}-beheerder om de decompressiesoftware te laten installeren.",
    'skeleton__client_page' => "Sjabloon voor virtuele hosts beheren",
    'skeleton__archive_corrupted' => "Uit controle van het archief blijkt dat het archiefbestand ofwel corrupt is, of dat het type archief niet wordt ondersteund.",
    'skeleton__archive_too_large' => "Uit controle van het archief blijkt dat het archiefbestand te groot is.",
    'skeleton__not_supported_archive_type' => "Dit archieftype (bestand %1) wordt niet ondersteund.",
    'skeleton__upload_archive_file' => "Archiefbestand uploaden",
    'skin_download__title' => 'Thema downloaden',
    'skin_download_now__title' => 'Thema downloaden',
    'skin_download_now__text' => 'Het themapakket wordt nu aangemaakt.<br>Dit kan even duren.<br>Wanneer het dialoogvenster verschijnt, kunt u doorgaan met het gebruik van Plesk.',
    'skin_file__help_for_using_types' => "Gebruik de thema-archieven in één van de volgende formaten:",
    'skin_info__title' => 'Thema-eigenschappen',
    'skin_mng_err__rpm_not_skin' => 'Deze RPM is geen themapakket voor Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Installeren van rpm-gebaseerd thema in de opgegeven locatie is mislukt.',
    'skin_mng_err__already_exists' => 'De map voor installatie van thema\'s bestaat al en er is al een themapakket actief.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Het geüploade bestand is geen geldig RPM-themapakket.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Het geüploade bestand is geen geldig themapakket.',
    'skin_mng_err__rpm_upgrade_base' => "Het geüploade bestand is geen geldig {$PROD_NAME}-themapakket.",
    'skin_mng_err__rpm_upgrade_other' => 'Kan het thema niet instelleren: ongeldig themaformaat.',
    'skin_mng_err__no_a_skin' => "Het geüploade bestand is geen geldig {$PROD_NAME}-themapakket.",
    'skin_upload__title' => 'Nieuw thema uploaden',
    'skin_upload__already_exists' => "Het thema '%1' bestaat al.",
    'skin_upload__unable_to_apply' => "Het geüploade bestand bevat geen Plesk-thema, of de archiefindeling wordt niet ondersteund.",
    'skin_upload__unable_to_rename__' => "Kan de naam van thema %2 niet wijzingen in %1: %3.",
    'skin_upload__file_name' => 'Zoekpad naar het bestand met het themapakket',
    'skins_list__title' => 'Themavoorziening',
    'skins_remove__title' => 'Verwijdering van thema',
    'skins_remove__select_skins_for_remove' => 'Selecteer de thema\'s om te verwijderen',

    'spamassassin__title' => "Instellingen spamfilter",
    'spf_parameters' => 'Bescherming tegen spam met SPF',
    'spf_enable_label' => 'Het met SPF op spam controleren van inkomende e-mail',
    'spf_behavior' => 'SPF-controlemodus',
    'spf_rules' => 'SPF lokale regels',
    'spf_guess' => 'SPF-gisregels',
    'spf_exp' => 'Uitleg voor SPF-weigering',
    'spf__unable_update' => 'Kan SPF-parameters niet bijwerken',
    'spf_bhv__create_headers_no_block' => 'Ontvangen-SPF headers alleen aanmaken, nooit blokkeren',
    'spf_bhv__use_tmp_errors' => 'Gebruik tijdelijke foutmeldingen wanneer u DNS-lookupproblemen hebt',
    'spf_bhv__reject_if_fail' => 'E-mail afwijzen als SPF wordt herleid tot "fail"',
    'spf_bhv__reject_if_softfail' => 'E-mail afwijzen als SPF wordt herleid tot "softfail"',
    'spf_bhv__reject_if_neutral' => 'E-mail afwijzen als SPF wordt herleid tot "neutral"',
    'spf_bhv__reject_if_no_pass' => 'E-mail afwijzen als SPF niet wordt herleid tot "pass"',
    'sshterm__title' => 'Beveiligde Shell-terminal',
    'sshterm__password_authentication_warning' => 'Opmerking: wachtwoordverificatie is uitgeschakeld voor de lokale SSH-serverconfiguratie. Als u geen verbinding kunt maken via de SSH Terminal, vraag dan aan de beheerder om "PasswordAuthentication yes" op te nemen in het bestand /etc/ssh/sshd_config',
    'sshterm__password_authentication_warning_admin' => 'Opmerking: wachtwoordverificatie is uitgeschakeld voor de lokale SSH-serverconfiguratie. Als u geen verbinding kunt maken via de SSH Terminal, neem dan "PasswordAuthentication yes" op in het bestand /etc/ssh/sshd_config',
    'statistics__active_domains' => "Actieve domeinen",
    'statistics__clients' => "Cliënten",
    'statistics__subdomains' => "Subdomeinen",
    'statistics__cpu' => "Processor",
    'statistics__databases' => "Databases",
    'statistics__db_users' => "Databasegebruikers",
    'statistics__dirs' => "Afgeschermde mappen",
    'statistics__dom_active' => "Actief",
    'statistics__dom_passive' => "Passief",
    'statistics__dom_problem' => "Probleem",
    'statistics__domains' => "Domeinen",
    'statistics__domains_with_host' => "Domeinen met hosting",
    'statistics__doms' => "Domeinen",
    'statistics__filesystem' => "Bestandssysteem",
    'statistics__general' => "Algemeen",
    'statistics__hdd_available' => "Beschikbaar",
    'statistics__hdd_capacity' => "Capaciteit",
    'statistics__hdd_total' => "Totaal",
    'statistics__hdd_usage' => "Schijfruimtegebruik",
    'statistics__hdd_used' => "Gebruikt",
    'statistics__ip' => "IP-adres",
    'statistics__key_number' => "Sleutelnummer",
    'statistics__l1' => "Laatste 1 minuut",
    'statistics__l15' => "Laatste 15 minuten",
    'statistics__l5' => "Laatste 5 minuten",
    'statistics__la' => "CPU-gebruik",
    'statistics__mail_autoresponders' => "Automatische beantwoordingen",
    'statistics__mail_boxes' => "Postvakken",
    'statistics__mail_groups' => "Mailgroepen",
    'statistics__mail_lists' => "Verzendlijsten",
    'statistics__mail_redirects' => "Doorstuuradressen e-mail",
    'statistics__mem' => "Geheugengebruik",
    'statistics__mem_usage' => "Gebruik",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Opgeslagen in cache",
    'statistics__memory_free' => "Vrij",
    'statistics__memory_shared' => "Gedeeld",
    'statistics__memory_total' => "Totaal",
    'statistics__memory_used' => "Gebruikt",
    'statistics__os' => "Besturingssysteem",
    'statistics__problem_clients' => "Probleemcliënten",
    'statistics__problem_domains' => "Probleemdomeinen",
    'statistics__swap' => "Swapgebruik",
    'statistics__swap_free' => "Vrij",
    'statistics__swap_total' => "Totaal",
    'statistics__swap_usage' => "Gebruik",
    'statistics__swap_used' => "Gebruikt",
    'statistics__system_stat' => "Serverinformatie",
    'statistics__unable_define_active_doms' => "Kan het aantal actieve domeinen niet vaststellen: %1",
    'statistics__unable_define_inactive_doms' => "Kan het aantal inactieve domeinen niet vaststellen: %1",
    'statistics__up_time' => "Uptime van het systeem:",
    'statistics__ver' => "versie",
    'statistics__web_users' => "Webgebruikers",
    'statistics__mem_win' => "Gebruik Fysiek Geheugen",
    'statistics__memory_total_win' => "Totaal",
    'statistics__memory_used_win' => "Gebruikt",
    'statistics__memory_free_win' => "Beschikbaar",
    'statistics__swap_win' => "Gebruik van virtueel geheugen",
    'statistics__swap_total_win' => "Totaal",
    'statistics__swap_used_win' => "Gebruikt",
    'statistics__swap_free_win' => "Beschikbaar",
    'status__domain_has_reasons_to_be_off' => "Het domein is nog altijd opgeschort vanwege de volgende reden: %1",
    'subdomain__create__' => "Een subdomein binnen het domein %1 aanmaken",
    'subdomain__edit__' => "Subdomein %1 beheren",
    'subdomain__invalid_name' => "Ongeldige naam subdomein: gebruik alleen alfanumerieke tekens en het verbindingsstreepje.",
    'subdomain__incorrect_name' => "Ongeldige naam voor subdomein.",
    'subdomains__maillists_enabled_in_domain' => "Onjuiste naam voor subdomein lists.%1: deze domeinnaam wordt al gebruikt door verzendlijsten binnen het domein %1.",
    'subdomains__dalias_exists' => 'Er bestaat al een domeinalias met deze naam.',
    'subdomains__name_exists' => "Er bestaat al een subdomein met deze naam.",
    'subdomains__regular_domain_exists' => "Er bestaat al een domein met deze naam.",
    'subdomains__domain_alias_exists' => 'Er bestaat al een domeinalias met deze naam.',
    'subdomains__remove_subdomains_on_domain' => "De volgende subdomeinen van domein %1 zullen verwijderd worden:",
    'subdomains__select_subdomains_for_remove' => "Selecteer de subdomeinen om te verwijderen.",
    'subdomains__webmail_enabled_in_domain' => "Onjuiste naam voor subdomein webmail.%1: deze domeinnaam wordt gebruikt voor toegang tot webmail binnen het domein %1.",
    'subdomains__dns_record_already_exists' => 'Kan het subdomein %1 niet aanmaken omdat er al een DNS-record is dat verwijst naar host %1.',
    'subdomains__www_prefix_in_domain' => "Onjuiste domeinnaam www.%1: het domein %1 heeft al het WWW-voorvoegsel.",
    'subdomains__user_type_quota_exceeds' => 'Kan de gebruikeraccount niet wijzigen omdat dit zou leiden tot overschrijding van de toegewezen schijfruimte.',
    'subdomains__creation_in_dns_slave' => "De naamserver van Plesk doet dienst als secundaire naamserver voor dit domein. Om uw subdomein op de juiste manier gevonden te laten worden, zorgt u ervoor dat het zonebestand op de primaire server het record %1 bevat.",
    'sys_user__attributes_not_changed' => "De volgende kenmerken van systeemgebruikers zijn niet gewijzigd: %1",
    'sys_user__no_access_without_password' => "U hebt geen wachtwoord ingesteld. De systeemgebruiker zal worden aangemaakt, maar zal niet in staat zijn zich aan te melden bij het systeem zolang hij of zij niet over een wachtwoord beschikt. Wilt u doorgaan?",
    'sys_user__no_hard_quota' => "niet ondersteund",
    'sysuser__zero_quota_is_unlimited' => "0 voor onbeperkt",
    'template__num_excl_ips' => "Exclusieve IP-adressen aan de cliënt toewijzen",
    'template__sel_sh_ips' => "Geselecteerde gedeelde IP-adressen",
    'template__av_sh_ips' => "Beschikbare gedeelde IP-adressen",
    'template__up_to_excl_ip' => "Tot %1 IP-adressen",
    'templates__all_clients' => "alle cliënten",
    'templates__cl_domain_templates' => "Sjablonen voor %1",
    'templates__cl_templates' => "Cliëntsjablonen",
    'time__day' => "Dag",
    'time__dom_name_ip' => "Domeinnaam of IP",
    'time__hours' => "Uren",
    'time__invalid_ip' => "Ongeldig IP-adres of domeinnaam.",
    'time__invalid_year' => "Jaar is ongeldig; deze moet liggen tussen 1971 en 2036.",
    'time__invalid_month' => "Maand is niet geldig; de waarde moet liggen tussen 1 en 12.",
    'time__invalid_day' => "Ongeldige dag. Moet tussen 1 en 31 liggen.",
    'time__invalid_hours' => "Uur is onjuist. De waarde moet liggen tussen de 0 en 24.",
    'time__invalid_minutes' => "Minuten is ongeldig; de waarde moet liggen tussen 0 en 59.",
    'time__invalid_seconds' => "Seconden is ongeldig; de waarde moet liggen tussen de 0 en 59.",
    'time__minutes' => "Min",
    'time__month' => "Maand",
    'time__sec' => "Seconden",
    'time__syn_sys_time' => "Systeemtijd synchroniseren",
    'time__system_datetime' => 'Datum en tijd',
    'time__system_date_update' => 'Systeemtijd bijwerken',
    'time__system_date' => "Datum (Jaar-Maand-Dag)",
    'time__system_time' => "Tijd (Uren:Minuten:Seconden)",
    'time__system_date_title' => "Systeemdatum en -tijd",
    'time__timezone_title' => 'Tijdzone',
    'time__network_time' => 'Netwerktijd',
    'time__timezone' => 'Uw tijdzone',
    'time__daylight' => 'Klok automatisch aanpassen aan zomer- en wintertijd',
    'time__please_select_timezone' => 'Selecteer een tijdzone',
    '__please_select_country' => 'Selecteer uw land',
    'time__unable_set_time' => "Kan de systeemtijd niet instellen: %1",
    'time__year' => "Jaar",
    'tmpl__create' => "Sjabloon aanmaken",
    'tmpl__edit__' => 'Sjabloon %1',
    'tmpl__logrotation_warn' => "Logbestandsverwerking van het domein, aangemaakt door dit sjabloon, wordt alleen actief als fysieke hosting ingesteld wordt.",
    'tmpl__name' => "Sjabloonnaam",
    'tmpl__dom_exist' => "Er bestaat al een domeinsjabloon met deze naam in sjabloonvoorziening van beheerders of cliënten.",
    'tmpl__name_invalid' => "Sjabloonnaam is ongeldig of leeg.",
    'tmpl__use_next_ip_addr' => "Het volgende beschikbare IP-adres zal worden gebruikt",
    'tmpl_name_already_exists' => "Sjabloon met naam '%1' bestaat al.",
    'traffic__no_periods_found' => "Kan de web- en dataverkeerstatistieken niet weergeven. Deze functie is pas beschikbaar na de volgende statistiekberekening.",

    'vh_based__no_free_ip_for_vh' => "Er zijn geen beschikbare IP-adressen voor de IP-gebaseerde virtuele hosting. Gelieve een IP-adres toe te voegen.",

    'wu__at_domains_text' => "Toestaan webgebruiker@%1 toegangsformaat",
    'wu__unable_create' => "Kan webgebruiker niet aanmaken: %1",
    'wu_edit__disk_quota' => "Schrijfruimtebeperking",
    'wu_edit__invalid_pass' => "Wachtwoord is ongeldig.",
    'wu_edit__invalid_quota' => "De opgegeven waarde voor de beperking van de schijfruimte is ongeldig. Geef een positief geheel getal in.",
    'wu_edit__invalid_quota_value' => "De opgegeven schijfruimtebeperking is kleiner dan welke momenteel wordt gebruikt (%1MB). Bepaalde functionaliteit is daardoor wellicht niet langer beschikbaar. Weet u zeker dat u door wilt gaan?",
    'wu_edit__not_create_pass' => "Deze bewerking zal geen wachtwoord aanmaken voor de nieuwe webgebruiker.\nZonder wachtwoord zal de gebruiker zich niet kunnen aanmelden.",
    'wu_edit__unable_update' => "Kan de eigenschap van de webgebruiker niet bijwerken: %1",

    'dns__soa_settings_legend' => 'SOA-instellingen',
    'dns__default_ttl_legend' => 'Standaard-TTL',
    'dns__soa_param_ttl' => 'Standaard-TTL',
    'dns__soa_param_retry' => 'Interval voor nieuwe poging',
    'dns__soa_param_refresh' => 'Vernieuwingsinterval',
    'dns__soa_param_expire' => 'Verloopinterval',
    'dns__soa_param_minimum' => 'Minimale TTL',

    'bt_webdirs' => 'Virtuele mappen',

    'dns__tabs_general' => 'Zone-instellingen',
    'dns__tabs_zone_settings' => 'SOA-records',
    'soa__seconds' => 'seconden',
    'soa__minutes' => 'minuten',
    'soa__hours' => 'uren',
    'soa__days' => 'dagen',

    'DomainSubdirectory' => 'Submap van bestemming',

    'filemanager__select_codepage' => 'Selecteer karakterset:',

    'bt_server_app_add' => 'Servertoepassing toevoegen',
    'packages_list' => 'Servertoepassingen',

    'bt_packages_management' => 'Pakketbeheer',
    'pb__packages_management' => 'Toepassingsbeheer',
    'bt_package_new' => 'Toepassing toevoegen',
    '__packages' => 'Servertoepassingen',

    'dom_ctrl__mysql_dbase_space' => 'Totale beperking MySQL-databases',
    'dom_ctrl__mssql_dbase_space' => 'Totale beperking MS SQL-databases',
    'server_preferences__include_mysql_databases' => 'MySQL-databases',
    'server_preferences__include_mssql_databases' => 'Microsoft SQL-databases',

    'check_permissions__domains_selection' => 'Toegangsrechten voor bestanden en mappen zullen worden gecontroleerd voor de volgende domeinen',

    'dns_add__enter_ixfr_path' => 'Geef IXFR-zoekpad op',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT-record bestaat al. Er kan maar één SPF-record zijn. Om een record toe te voegen, verwijder eerst de bestaande.',

    'component_name__network' => 'Netwerken',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Thema instellen',
    'bt_set_skin' => 'Thema instellen',
    'firewall__rule_already_exists' => 'Er bestaat al een regel met de naam "%1"',
    'pb__firewall' => 'Firewall',
    'ruleeditform__incorect_port_value' => 'Het poortnummer moet liggen tussen 1 en 65535.',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Bestandslocatie is ongeldig.',

    'error_doc__erorr_invalid_url_location' =>  'Verkeerd URL-formaat. Geef een absoluut URL op binnen de virtuele host (site).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Antivirus',
    'antivirus__antivirus_direction_off' => 'Uitgeschakeld',
    'antivirus__antivirus_direction_any' => 'Inkomende en uitgaande mail',
    'antivirus__antivirus_direction_from' => 'Alleen uitgaande mail',
    'antivirus__antivirus_direction_to' => 'Alleen inkomende mail',
    'antivirus__unable_to_update_settings' => 'Kan antivirusinstellingen niet wijzigen: %1',




    '__normal' => 'Normaal',
    '__low' => 'laag',
    '__high' => 'Hoog',

    'mail__antivirus' => "Interne antivirus van mailserver",
    'mail__use_internal_antivirus' => 'Interne antivirus gebruiken',

    'sa__tabs_general' => 'Algemeen',
    'sa__tabs_whitelist' => 'Witte lijst',
    'sa__tabs_blacklist' => 'Zwarte lijst',
    'sa__tabs_trustednetworks' => 'Vertrouwde netwerken',
    'sa__alarm_message_text' => 'Waarschuwingstekst bij detectie van ongewenste e-mail',
    'sa__ok_languages' => 'Vertrouwde talen',
    'sa__language_groups_available' => 'Beschikbare talen',
    'sa__language_groups_belonged' => 'Geselecteerde vertrouwde talen',
    'sa__ok_locales' => 'Vertrouwde regio\'s',
    'sa__locale_groups_available' => 'Beschikbare regiogroepen',
    'sa__locale_groups_belonged' => 'Geselecteerde vertrouwde regiogroepen',

    'sa_trustednetworks' => 'Lijst met vertrouwde netwerken',
    'sa_tn_address' => 'Netwerk/masker',
    'sa_trustednetworks_desc' => 'Geselecteerde vertrouwde netwerken',

    '__mysql_databases' => 'MySQL-databases',

    'check_permissions__read_only' => 'Alleen controle',
    'check_permissions__notification_email' => 'Melding versturen via e-mail',

    'cl_perm__mysql_dbase_space' => 'Totale beperking MySQL-databases',
    'cl_perm__mssql_dbase_space' => 'Totale beperking MS SQL-databases',
    'cl_perm__max_mssql_db' => 'Maximaal aantal Microsoft SQL-serverdatabases',
    'cl_perm__total_mboxes_quota' => 'Totale beperking van postvakken',



    'time__date' => 'Datum',
    'time__time' => 'Tijd',

    'check_permissions_warning' => 'Het kan lang duren voordat deze bewerking is voltooid. Wij vragen uw geduld, onderbreek het laden van pagina niet.',

    'i_i_cl_on' => 'Cliëntaccount is actief.',
    'i_i_cl_off_by_admin' => 'Cliëntaccount is opgeschort door beheerder.',

    'check_permissions__email_is_invalid' => 'De opgegeven e-mail is ongeldig.',

    'sa_invalid_tn_ip' => 'De IP-waarde is ongeldig.',
    'sa_invalid_tn_mask' => 'De waarde van het masker is ongeldig.',
    'sa_exists_tn' => 'Het netwerk staat al op de lijst.',
    'sa_select_tn' => 'Er zijn geen netwerken geselecteerd om te verwijderen.',
    'sa_conf_list_tn' => 'Bevestig de verwijdering van het/de geselecteerde netwerk(en).',

    'firewall__tabs_general' => 'Algemeen',
    'firewall_tabs_icmp' => 'ICMP-protocol',

    'firewallicmpform__title' => 'Firewall-regels voor het ICMP-protocol',
    'firewallicmpform__icmpsettings_list_legend' => 'Firewall-regels voor het ICMP-protocol',
    'firewallicmpform__icmpsettingslist' => 'Regels',
    'icmpsettingslist__enabled' => 'S',
    'icmpsettingslist__type' => 'Regelnaam',
    'firewall__icmp_type_allowinboundrouterrequest' => 'Inkomende routeraanvraag toestaan',
    'firewall__icmp_type_allowinboundtimestamprequest' => 'Inkomende tijdsstempelaanvraag toestaan',
    'firewall__icmp_type_allowinboundmaskrequest' => 'Inkomende maskeraanvraag toestaan',
    'firewall__icmp_type_allowoutboundsourcequench' => 'Uitgaande bron-quench toestaan',
    'firewall__icmp_type_allowoutboundparameterproblem' => 'Uitgaand parameterprobleem toestaan',
    'firewall__icmp_type_allowredirect' => 'Doorschakeling toestaan',
    'firewall__icmp_type_allowinboundechorequest' => 'Inkomende echoaanvraag toestaan',
    'firewall__icmp_type_allowoutboundtimeexceeded' => 'Uitgaande tijdsoverschrijding toestaan',
    'firewall__icmp_type_allowoutbounddestinationunreachable' => 'Uitgaande bestemming onbereikbaar toestaan',


    'webdir__select_vdirs_to_remove' => 'Selecteer mappen die u wilt verwijderen',
    'webdir__select_mime_types_to_remove' => 'Selecteer MIME-typen die u wilt wissen',

    'defaultcomponents__not_activated' => 'niet geactiveerd',

    'bt_traffic_at_domains' => 'Dataverkeer',

    'firewall__icmpsettingslist' => 'Regels',
    'icmpsettingslist__name' => 'Regelnaam',

    '__awstats_perl_warning' => 'Als Perl niet is geïnstalleerd, zal AWStats gebruikers niet in staat stellen om statistieken voor voorgaande jaren te controleren.',

    'class_client__mysql_dbase_space' => 'Waarde overstijgt beperking van cliënt',
    'class_client__mssql_dbase_space' => 'Waarde overstijgt beperking van cliënt',
    'class_client__max_mssql_db' => 'Waarde overstijgt beperking van cliënt',

    'firewall__icmp_reset_configuration' => 'Weet u zeker dat u de standaardinstellingen van de firewall wilt terugzetten?',
    'firewall__icmp_panic_configuration' => 'Weet u zeker dat u de Paniekmodus wilt inschakelen? Sommige netwerkdiensten zullen dan wellicht niet meer werken.',


    'dns__remove_transfer_restrictions_list_items' => 'De volgende netwerken zullen worden verwijderd uit de toegangbeheerlijst:',
    'dns__select_transfer_restrictions_list_items_to_remove' => 'Selecteer de netwerken die u uit de toegangbeheerlijst wilt verwijderen',

    'firewall__select_rule_to_remove' => 'Selecteer regels voor verwijdering',

    'bt_up' => "Omhoog",
    'bt_down' => "Omlaag",
    'virtualdir__type_default_doc_name_to_add' => 'Geef bestandsnaam op om aan de lijst toe te voegen',
    'virtualdir__select_default_doc_to_remove' => 'Selecteer bestanden om uit de lijst te verwijderen',

    'bt_install_selected' => 'Geselecteerde licentiesleutels installeren', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Het domein leidt naar een ander IP-adres: (%1). Corrigeer de DNS-instellingen.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'De mailserver die momenteel wordt gebruikt staat niet toe dat zowel postvak als mailgroepen tegelijkertijd zijn ingeschakeld. Klik OK om postvak in te schakelen en daarmee mailgroepen uit te schakelen. Druk Annuleren om alles intact te laten.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'De mailserver die momenteel wordt gebruikt staat niet toe dat zowel postvak als mailgroepen tegelijkertijd zijn ingeschakeld. Klik OK om mailgroepen in te schakelen en daarmee postvak uit te schakelen. Druk Annuleren om alles intact te laten.',

    'mysql_dbase_space_limit' => 'Ruimtebeperking MySQL-database',
    'mysql_dbase_usage' => 'Ruimtegebruik MySQL-database',
    'mssql_dbase_space_limit' => 'Beperking ruimte Microsoft SQL-serverdatabases',
    'mssql_dbase_usage' => 'Ruimtegebruik Microsoft SQL-serverdatabases',

    '__statistics' => "Statistieken", //indirect

    'dns__soa_minimum_value_is_big' => 'Het instellen van een TTL-waarde van meer dan 3 uur kan uw domeinen ontoegankelijk maken voor een aantal van de domeinbeheerders. Het wordt aanbevolen om alleen een dergelijke waarde te gebruiken als het bedrijf waarbij u de domeinnaam registreert dat van u eist.',

    'maillists__server_legend' => 'Mailman-instellingen',
    'maillists__secure_links_text' => 'Beveiligde links gebruiken in verzendlijsten',
    'maillists__secure_links_hint' => 'Aanmaken van beveiligde (HTTPS) links in verzendlijsten in- of uitschakelen.',

    'virusfilter__interface_not_available' => 'Er zijn geen virusfilters beschikbaar.',
    'virusfilter__none_virus_filter' => 'Geen',
    'virusfilter__server_legend' => 'Antivirusinstellingen',
    'virusfilter__server_text' => 'Antivirus gebruikt',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'uitgeschakeld',
    'virusfilter__status_any' => 'inkomende en uitgaande mail',
    'virusfilter__status_outgoing' => 'alleen uitgaande mail',
    'virusfilter__status_incoming' => 'alleen inkomende mail',

    'visibility__adminonly' => 'Alleen beheerder',
    'visibility__button_sets' => 'Bedieningselementen',
    'visibility__control' => 'Klik om dit bedieningselement aan te passen.',
    'visibility__customization_footnote' => 'Klik OK om het aanpassen van dit scherm te voltooien.',
    'visibility__default' => 'Standaard',
    'visibility__export_note' => "De aanpassingsinstellingen die u hebt gemaakt zullen nu worden geëxporteerd. Hiertoe zal een shellscript worden gedownload naar uw computer. Om deze instellingen op een andere Plesk-server toe te passen, waarbij alle bestaande scherminstellingen worden overschreven, kunt u het script uploaden en uitvoeren op deze andere server.\n\nMerk op, dat als u wijzigingen hebt gemaakt op deze pagina maar u hebt nog niet op OK geklikt, de geëxporteerde gegevens niet uw laatste wijzingen zullen bevatten.",
    'visibility__hide' => 'Verbergen',
    'visibility__reset_all' => 'Alles herstellen naar de standaard',
    'visibility__reset_screen' => 'Terugkeren naar de originele indeling van dit scherm',
    'visibility__root_override_parse_error' => 'Er bevindt zich een syntaxfout in bestand %1 in regel %2.',
    'visibility__screen_title' => 'Schermvoorkeuren',
    'visibility__set_billing_enabled' => 'Customer & Business Manager loskoppelen',
    'visibility__set_cert_puchasing' => 'Knoppen voor de aanschaf van certificaten verbergen',
    'visibility__set_domain_registration' => 'Knoppen voor domeinregistratie verbergen',
    'visibility__set_extras' => 'Knoppen voor extra diensten verbergen',
    'visibility__set_mail_bounce' => 'Knoppen voor verklaring van afwijzing voor niet-bestaande mailadressen verbergen',
    'visibility__show' => 'Tonen',
    'visibility__show_toolbar' => 'Werkbalk schermbeheer tonen',
    'visibility__standby_footnote' => 'Klik om de bedieningselementen op dit scherm aan te passen.',
    'visibility__standby_footnote_nocontrols' => 'Er zijn geen aanpasbare bedieningselementen op dit scherm.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "Automatiseren van publiceren wordt niet ondersteund door het component",

    'component_name__cphosting' => "Plesk hosting",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Het instellen van postvakbeperkingen wordt niet ondersteund door de huidige mailserver.',
    '__unable_get_total_mboxes_quota' => 'Het instellen van postvakbeperkingen wordt niet ondersteund door de huidige mailserver.',

    'install_prefix__parent_not_exists' => "Bovenliggende map bestaat niet.",

    'bt_change_version' => 'Versie wijzigen',
    'aspdotnet__changeversion_title' => 'Selecteren van ASP.NET-versie',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Alle selecteren",
    '__uncheck_all' => "Alles wissen",

    'dns__editing_domain_controller_zone' => "Het bewerken van DNS-zonerecords voor domeincontroller kan problemen opleveren voor het functioneren van het domein",

    'pb__interface_management' => "Schermvoorkeuren",
    'interface_management__tabs_skins' => "Thema's",
    'interface_management__tabs_interface_templates' => "Schermsjablonen",
    'interface_management__tabs_locales' => "Landinstellingen",
    'locales_list__title' => "Opslag van taalpakketten",
    'locales_list__legend' => "Beschikbare talen",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Taalpakket",
    'locales_list__lang_title' => "Taal",
    'locales_list__country_title' => "Land",
    'locales_list__used_title' => "Gebruikt",

    'backup__suspend_warning_during_backup' => "Het domein zal tijdens het maken van de reservekopie niet beschikbaar zijn",
    'backup__suspend_warning_during_restore' => "Het domein zal tijdens het terugplaatsen van de reservekopie niet beschikbaar zijn",
    'backup__suspend_domain' => "Domein opschorten",

    'locales_list__mls_limit' => "Uw huidige licentie van Plesk staat het gebruik van %2 talen toe. Op dit moment hebt u %1 talen ingesteld als beschikbaar voor gebruikers, wat meer is dan de licentie toestaat. Selecteer de %2 talen die u wilt gebruiken en stel de overige talen in als niet-beschikbaar voor gebruikers door te klikken op de betreffende pictogrammen in de kolom 'S'.",

    'bt_change_owner' => 'Nieuwe houder toewijzen',
    'chown__new_owner' => 'Nieuwe houder',
    'chown__selected_domains' => 'Geselecteerde pakketten',
    'chown__limits_legend' => 'Middelen',
    'chown__limit_name' => 'Naam van middel',
    'chown__limit_value' => 'Toegewezen middelen',
    'chown__limit_assigned_before' => 'Voorafgaand aan overdracht',
    'chown__limit_assigned_after' => 'Na overdracht',
    'chown__error_limits' => "Kan pakketoverdracht niet voortzetten: dit pakket vereist meer middelen dan door de provider van de nieuwe houder kunnen worden geleverd.",
    'chown__error_no_domains' => 'Kan de pakketoverdracht niet voortzetten: of er zijn geen pakketten geselecteerd, of de geselecteerde pakketten horen al bij de gebruiker van bestemming.',
    'chown__error_empty_ip_pool' => "Kan pakketoverdracht niet voortzetten: de IP-voorziening van de provider van de nieuwe houder is leeg. Zorg ervoor dat de provider ten minste één IP-adres in de voorziening heeft.",
    'chown__please_select_new_domain_owner' => 'Selecteer de nieuwe houder voor dit abonnement',
    'chown__old_ip_address' => 'Huidig IP-adres',
    'chown__new_ip_address' => 'Nieuw IP-adres',

    'chown__error_ssl_already_used' => "Ondersteuning voor SSL/TLS wordt al gebruikt op de volgende IP-adressen van bestemming: %1 Om deze reden kunnen de volgende domeinen met ondersteuning voor SSL/TLS niet worden overgedragen: %2. Los het probleem op en probeer het opnieuw",
    'chown__sitebuilder_not_installed' => 'Presence Builder is niet geïnstalleerd',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domein %1 kan niet aan een andere houder worden overgedragen omdat Presence Builder niet is geïnstalleerd.',

    'backup__backup_time' => 'Tijd aanmaken reservekopie',
    'backup__backup_time_hour' => 'uren',
    'backup__backup_time_minute' => 'minuten',
    'backup__every' => 'elke',
    'backup__day_of_month' => 'dag van de maand',

    'subdomain__select_hst_type' => 'Selecteer het type hosting voor het subdomein',
    'hst_sel__subdom_subfolder_hst' => 'Subdomein op submap',
    'subdomain__www_root_folder_not_exists' => 'Hoofdmap %1 van site bestaat niet',
    '__site_home_dir' => 'Hoofdmap van site',
    'subdomain__aspnet_disabled_domain' => 'uitgeschakeld door domein',

    'domains__remove_description' => 'Alle gegevens van het domein, inclusief de bestanden en instellingen die horen bij het domein en de betreffende subdomeinen, de gegevens van webtoepassingen, de inhoud van postvakken, mail, instellingen voor antivirus en spamfilters, logbestanden, reservekopieën in de opslag van het domein en SSL/TLS-certificaten zullen worden verwijderd. Als u geen reservekopie op uw lokale machine heeft, zullen alle gegevens permanent verloren gaan.',
    'subdomains__remove_description' => 'Alle gegevens van het subdomein, inclusief inhoud en instellingen, gegevens van webtoepassingen en logbestanden zullen worden verwijderd. Als u geen reservekopie op uw lokale machine heeft dan zullen alle gegevens permanent verloren gaan.',

    'mail__no_relay_networks' => 'Geen relaybeperkingen gebruiken voor de volgende netwerken:',
    'mail__tabs_spam_filtering' => 'Spamdetectie',
    'mail__tabs_antivirus' => 'Antivirus',
    'server_mail__usage_policy_legend' => 'Gebruiksvoorwaarden',
    'server_mail__for_incoming_mail' => 'voor inkomende mail',
    'server_mail__for_outgoing_mail' => 'voor uitgaande mail',
    'server_mail__antivirus_direction_off' => 'Controle uitgeschakeld',
    'server_mail__antivirus_direction_any' => 'Zowel inkomende als uitgaande mail controleren',
    'server_mail__antivirus_direction_from' => 'Alleen uitgaande mail controleren',
    'server_mail__antivirus_direction_to' => 'Alleen inkomende mail controleren',
    'antivirus__use_server_settings_scan' => 'De standaardinstellingen voor de server als geheel gebruiken (scannen)',
    'antivirus__use_server_settings_no_scan' => 'De standaardinstellingen voor de server als geheel gebruiken (niet scannen)',
    'antivirus__check_for_viruses' => 'Op virussen controleren',
    'antivirus__dont_check_for_viruses' => 'Niet op virussen controleren',
    'antivirus__incoming_mail' => 'Inkomende mail',
    'antivirus__outgoing_mail' => 'Uitgaande mail',

    'domain_alias__CNAME_dns_record_exists' => 'Er bestaat al een DNS CNAME-record met deze naam',
    'domain_alias__A_dns_record_exists' => 'Er bestaat al een DNS A-record met deze naam',
    'domain_alias__bad_prefix' => 'Verkeerd voorvoegsel voor domeinalias',
    'domain_alias__domain_doesnt_exist' => "Domein bestaat niet",

    'dns__zone_ttl_message_info' => 'Als de TTL-waarde niet is opgegeven, wordt de TTL-waarde van het SOA-recordsjabloon (%1) ook gebruikt voor dit DNS-record.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Er zal een bestand met de naam index.html worden aangemaakt voor doorschakeling naar de geselecteerde webtoepassing. Als er al een bestand met de naam index.html bestaat, dan zal hiervan een reservekopie worden gemaakt met de naam index.html.old, waarna het origineel wordt vervangen door het nieuwe bestand. Klik OK om te bevestigen",

    'bt_ftp_ctrl' => "Extra FTP-accounts",
    'ftp_users_no_permission' => "U beschikt niet over de rechten om FTP-accounts voor dit domein te beheren",
    'ftp_users_limit_reached' => "Beperking aantal FTP-accounts is bereikt voor dit domein",
    'pb__ftp_ctrl' => "FTP-beheer",
    'class_client__max_subftp_users' => "Extra FTP-accounts",

    '__client_form_settings' => "Instellingen van cliënt",
    '__sbnet_client_keep_sbnet' => "Behoud het bijbehorende gebruikeraccount in Presence Builder",
    '__sbnet_cant_add_more_sites' => "De beperking van het aantal sites dat gebruik kan maken van Presence Builder is bereikt voor deze cliënt",
    '__sbnet_legend_text' => "Presence Builder-integratie",
    '__sbnet_synchronize_user_with_sbnet' => "Maak een overeenkomstig gebruikeraccount aan in Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "U probeert het Presence Builder-gebruikeraccount dat aan deze cliënt is gekoppeld te verwijderen. Daarmee zullen alle websites en alle andere relevante instellingen uit het Presence Builder-systeem worden verwijderd. Het is daardoor niet meer mogelijk bestaande websites via Presence Builder te bewerken, zelfs als u deze optie later opnieuw inschakelt. Als u later opnieuw een Presence Builder-gebruikeraccount aanmaakt, dan moet u al uw websites helemaal opnieuw aanmaken en publiceren. Wilt u het aanmaken en publiceren van websites via Presence Builder uitschakelen?",
    'sb__build_site_with_subdomains' => "Subdomeinen aanmaken voor Blog en Fotogallery",
    '__sbnet_client_dont_have_sbuser' => "Kan geen site met Presence Builder aanmaken of publiceren: Presence Builder-gebruiker bestaat niet",

    '__component_disabled' => "Component is uitgeschakeld",

    'dns_t__remove_transfer_restrictions_list_items' => "De volgende netwerken zullen worden verwijderd uit de toegangbeheerlijst (ACL) van het DNS-zonesjabloon:",

    'subdomains__physical_path_not_exist' => "Er zijn subdomeinen verbonden met niet-bestaande fysieke mappen",
    'dns__recursion_settings_legend' => "Instellingen DNS-recursie",
    'dns__recursion_on' => "Toestaan voor alle aanvragen",
    'dns__recursion_local' => "Alleen toestaan voor lokale aanvragen",
    'dns__recursion_off' => "Weigeren",

    'dnsserver_bind_to_msdns_switching_warning' => "Waarschuwing: alleen de eerste 254 IP-adressen van subnetten met /8 en /16-maskers die zich in de toegangbeheerlijst (ACL) bevinden zullen worden overgedragen. Deze worden overgedragen als aparte IP-adressen. Wilt u doorgaan?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder-sites hebben wellicht ondersteuning voor ASP.NET 2.0 nodig op uw domein. Het is aan te raden ondersteuning voor ASP.NET 2.0 in te schakelen wanneer u gebruik maakt van Presence Builder.",

    'subdomain_auto_create_dir' => "Fysieke map voor subdomein aanmaken",

    'sa_trainer__unable_to_get_messages_list' => "Kan de lijst met berichten in het postvak niet krijgen: %1",
    'sa_trainer__pass_doesnt_exist' => "Het wachtwoord voor dit mailaccount ontbreekt",

    '__sitebuilder_error' => "Er is een fout opgetreden tijdens een poging verbinding te maken met Presence Builder. Neem contact op met uw provider voor ondersteuning.",
    'wsb_error_user_not_exist' => "Dit Presence Builder-gebruikeraccount bestaat niet.",
    'wsb_error_site_already_exist' => "Deze site bestaat al in Presence Builder.",
    'wsb_error_site_limit_reached' => "De beperking van het aantal Presence Builder-sites is bereikt.",
    'wsb_error_internal_error' => "Er is een interne fout opgetreden in Presence Builder. Neem contact op met uw provider voor ondersteuning.",
    'wsb_error_user_already_exist' => "Er bestaat al een gebruiker met deze naam in Presence Builder.",
    'sb_error_user_not_exist' => "Presence Builder-gebruiker bestaat niet.",
    'wsb_error_object_not_found' => "Presence Builder kan de juiste host-ingang niet vinden..",

    'mg_no_mail_groups' => "Geen mailgroepen",

    'drweb__drweb_incoming' => 'Controle van inkomende mail op virussen',
    'drweb__drweb_outgoing' => 'Controle van uitgaande mail op virussen',
    'drweb__disable_reason_serv' => 'De mailserver ondersteunt geen instellingen van antivirusfilter op postvakniveau',

    'vz_sitebuilder3_client_cant_be_created' => "Kan geen cliëntaccount aanmaken: SiteBuilder versie 3.1 of hoger is niet geïnstalleerd",

    'chown__client_without_sitebuilder_support' => "Kan de pakketoverdracht niet voortzetten: het dienstenpakket van de nieuwe houder of diens provider beschikt niet over Presence Builder.",

    // new limits

    'class_client__max_odbc' => "ODBC-koppelingen",
    'cl_perm__max_odbc' => "maximaal aantal ODBC-koppelingen",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Naam domeinalias',
    'domain_alias__list_ascii_name' => 'In ASCII-formaat',
    'dns_template__tabs_general' => "Zone-instellingssjabloon",
    'dns_template__tabs_zone_settings' => "Sjabloon voor SOA-records",
    'dns_template__tabs_acl' => "Sjabloon met overdrachtsbeperkingen",
    'dns_template__tabs_recursion' => "DNS-recursie",
    'dns_template__tabs_records_template' => "Sjabloon voor zone-records",


    // Interface Customization Templates
    'interface_preferences' => 'Schermvoorkeuren',
    'pb__interface_templates' => 'Schermvoorkeuren',
    'pb__interface_clients' => 'Cliënten die %1 gebruiken',

    // service management
    'bt_service_showall' => "Alles tonen",
    'bt_service_hideall' => "Alles verbergen",
    'bt_service_start' => "Starten",
    'bt_service_stop' => "Stoppen",
    'bt_service_restart' => "Opnieuw opstarten",
    'bt_service_disable' => "Uitschakelen",
    'bt_service_manual' => "Handmatig",
    'bt_service_auto' => "Auto",
    'comp_info__statup_type' => 'Opstarttype',
    'service_startup_auto' => 'Automatisch',
    'service_startup_manual' => 'Handmatig',
    'service_startup_disabled' => 'uitgeschakeld',
    'service_action_ok' => "De bewerking met %1-dienst is met succes afgerond",
    'service_action_failed_disabled_service' => "Kon bewerking met dienst %1 niet voltooien omdat deze is uitgeschakeld",
    'service_action_failed_error' => "Kon de bewerking niet voltooien: %1",
    'service_group_action_ok' => "De bewerking met de volgende diensten is met succes afgerond:\n%1",
    'service_group_action_disabled' => "Kon bewerking met de volgende diensten niet voltooien omdat deze zijn uitgeschakeld: \n %1",
    'service_group_action_failed' => "Kan de bewerking met de volgende diensten niet voltooien:\n%1. \nOm meer uitgebreide informatie over de foutmelding te ontvangen, voert u de bewerking met elke dienst apart uit",

    // php 4vs5
    'bt_php' => "PHP-instellingen",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Beschikbare resellers',
    'massmail__resellers_list_selected' => 'Geselecteerde resellers',
    'massmail__clients_list_available_for_select' => 'Beschikbare cliënten',
    'massmail__clients_list_selected' => 'Geselecteerde cliënten',
    'massmail__advanced' => 'Geavanceerd',
    'bt_massmail_send' => 'Verzenden',
    'massmail__save_template_name' => 'Tekst opslaan in een nieuw sjabloon met de naam',
    'massmail__template' => 'Sjabloon',
    'massmail__compose_mail' => 'Bericht',
    'massmail__from' => 'Van',
    'massmail__to' => 'Aan',
    'massmail__subject' => 'Onderwerp',
    'massmail__body' => 'Tekst van bericht',
    'massmail__body_hint' => 'Gebruik variabele <name> om de gebruikersnaam automatisch in uw bericht in te voegen.',
    'massmail__send_to_clients' => "Cliënten",
    'massmail__send_to_domainusers' => "Domeinbeheerders",
    'massmail__send_to_admins' => "Plesk-beheerders",
    'massmail_select' => 'Selecteer adressen',
    'massmail_showhide_selected' => "Selectie tonen of verbergen",
    'massmail_send_all' => "Alle",
    'massmail_send_selected' => "Alleen selectie",
    'massmail_send_except' => "Alle behalve selectie",
    'bt_new_mass_mail_template' => "Sjabloon voor e-mail aan een grote groep toevoegen",
    '__mass_mail_templates_list' => "Lijst met sjablonen voor e-mail aan een grote groep",
    'massmail__template_name' => 'Sjabloonnaam',
    'massmail__receivers' => 'Ontvangers',
    'massmail__created' => 'Afzender',
    'massmail__date_created' => 'Datum van aanmaken',
    'massmail__compose' => 'Verzenden',
    'mass_mail__resellers_all' => 'Alle resellers',
    'mass_mail__clients_all' => 'Alle cliënten',
    'mass_mail__domainusers_all' => 'Alle domeinbeheerders',
    'mass_mail__resellers_selected' => 'Geselecteerde resellers',
    'mass_mail__clients_selected' => 'Geselecteerde cliënten',
    'mass_mail__domainusers_selected' => 'Geselecteerde domeinbeheerders',
    'mass_mail__resellers_except' => 'Alle resellers behalve de geselecteerde',
    'mass_mail__clients_except' => 'Alle cliënten behalve de geselecteerde',
    'mass_mail__domainusers_except' => 'Alle domeinbeheerders behalve de geselecteerde',
    'mass_mail__admins_all' => 'Alle beheerders',
    'massmailtemplateslist__title' => 'Sjablonen voor e-mailberichten voor een grote groep',
    'massmail__insert_from_template' => "Gegevens vanuit sjabloon invoegen",
    'massmail__select_template' => "Selecteer sjabloon",
    'massmail__body_short_hint' => "(alleen platte tekst)",
    'massmail__from_short_hint' => "(e-mail of naam)",
    'bt_insert' => "Invoegen",
    'massmail__mail_send_successfully' => "Het bericht is met succes verzonden",
    'massmail__mail_send_successfully_with_some_errors' => "Het bericht is verstuurd, maar verschillende fouten zijn opgetreden. Een aantal ontvangers heeft het bericht wellicht niet ontvangen. Kijk voor meer informatie in het volgende logbestand: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Het bericht is niet verstuurd. Controleer of tenminste één ontvanger is geselecteerd en of de mailserver van Plesk correct functioneert. Voor meer informatie, bekijk het logbestand op: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Het invoegen van de gegevens uit het sjabloon %1 is geslaagd.",
    'massmail__template_added_successfully' => "Het berichtsjabloon is opgeslagen onder de naam %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Fout in de Presence Builder-database. Neem contact op met uw provider voor ondersteuning.",
    'wsb_error_sitebuilder_access_denied_error' => "Geen toegang tot het bestand: Presence Builder beschikt niet over toegangsrechten voor het bestand of de map. Neem contact op met uw provider voor ondersteuning.",
    'wsb_error_sitebuilder_connection_failed' => "Kan geen verbinding maken met Presence Builder omdat de verbinding is weggevallen. Neem contact op met uw provider voor ondersteuning.",
    'wsb_error_critical_during_operation' => "Er is een kritieke fout opgetreden in Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "Er is een licentiefout opgetreden in Presence Builder:\n%1",
    'wsb_error_during_operation' => "Er is een fout opgetreden in Presence Builder:\n%1",
    'wsb_error_license_error' => "Er is een beperking van de Presence Builder-licentie aangetroffen.",

    // Other
    '__confrim_service_stop' => "Let op! Als u de dienst %1 stopt, dan werkt Plesk wellicht niet meer. Weet u zeker dat u de dienst %1 wilt stoppen?",
    'virtualdir__name_is_reserved' => "Deze naam is gereserveerd",
    'index_redirect_help_text' => 'U wordt nu automatisch doorgeschakeld naar de vereiste website. Als uw browser geen doorschakeling ondersteunt, klik dan %1 hier %2',
    'bt_default_settings' => "Terugkeren naar standaardwaarden",
    'logfiles__remove_failed' => "Kan bestand %1 niet verwijderen: het bestand is vergrendeld door een andere toepassing. Probeer het later opnieuw",
    'subdomain__invalid_homedirectory' => "De opgegeven hoofdmap van het subdomein is niet geldig",
    'scheduler_item__empty_filename' => "Geef het uitvoeringsbestand op dat u wilt starten",
    'subdomains__overlapped_domain_exists' => 'Subdomein wordt overlapt door DNS-zone van domein %1',
    'subdomains__overlapped_domain_alias_exists' => 'Subdomein wordt overlapt door DNS-zone van domeinalias %1',
    'services_action_none_selected' => 'Kon de bewerking niet voltooien: selecteer de vereiste diensten',
    'cl_perm__max_subftp_users' => "maximaal aantal extra FTP-accounts",
    'login_up__access_denied_no_cp_access' => 'Toegang geweigerd. U beschikt niet over de rechten om toegang tot Plesk te krijgen.',
    'drweb__disable_reason_admin' => "Het instellen van antivirus op het niveau van het postvak wordt niet toegestaan binnen het serverbeleid.",

    'webdirs__name_is_invalid' => 'Gebruik alleen alfanumerieke karakters, de underscore en het verbindingsstreepje in mapnamen.',
    'webdirs__physical_path_is_invalid' => 'Fysiek zoekpad is ongeldig of bestaat niet',
    '__use_default' => 'Standaard gebruiken',
    'branding_pagetitle' => 'Branding-instellingen',
    'fieldset_titlebar_setup' => "Titel van Plesk-pagina's",
    'use_custom_titlebar' => "Tekst van titel",
    'odbc__dsn_list_legend' => 'ODBC DSN-koppelingen',

    'webalizer_preferences__title' => 'Instellingen voor webstatistieken',
    'webalizer_preferences__tab_hidden_referrers' => 'Verborgen verwijzingen',
    'webalizer_preferences__tab_group_referrers' => 'Gegroepeerde Verwijzingen',

    'webalizer_hidden_referrer__edit_title' => 'Eigenschappen van verborgen ingangen',
    'webalizer_hidden_referrer__edit_legend' => 'Verborgen ingangen',
    'webalizer_hidden_referrer__referrer_type' => 'Verwijzingstype',
    'webalizer_hidden_referrer__referrer' => 'Verwijzing',
    'webalizer_hidden_referrer__list_header' => 'Verborgen verwijzingen',
    'webalizer_hidden_referrer__list_legend' => 'Verborgen verwijzingen',
    'webalizer_hidden_referrer__referrer_direct_request' => 'Directe aanvraag',
    'webalizer_hidden_referrer__referrer_custom_referrer' => 'Verwijzing',
    'webalizer_hidden_referrer__remove_empty_selection' => 'Geen ingangen geselecteerd',
    'webalizer_hidden_referrer__remove_title' => 'De volgende verwijzingen zullen niet langer verborgen zijn:',
    'webalizer_hidden_referrer__already_exist' => 'Deze ingang bestaat al.',

    'webalizer_group_referrer__list_header' => 'Verwijzingen samenvoegen',
    'webalizer_group_referrer__list_legend' => 'Verwijzingen samenvoegen',
    'webalizer_group_referrer__edit_title' => 'Eigenschappen van verwijzingsgroep',
    'webalizer_group_referrer__edit_legend' => 'Eigenschappen van verwijzingsgroep',
    'webalizer_group_referrer__group' => 'Groep',
    'webalizer_group_referrer__referrer' => 'Verwijzing',
    'webalizer_group_referrer__already_exist' => 'Een groepsverwijzing met deze naam bestaat al.',
    'webalizer_group_referrer__remove_empty_selection' => 'Geen verwijzingen geselecteerd',
    'webalizer_group_referrer__remove_title' => 'De volgende verwijzingssites zullen niet langer gegroepeerd zijn:',

    'pb__dashboard' => 'Startpagina',

    'server_interface__page_title' => 'Instellingen serverinterface',
    'server_interface__tabs_locales' => 'Landinstellingen',
    'server_interface__tabs_skins' => 'Thema\'s',
    'server_interface__tabs_interface_templates' => 'Schermsjablonen',
    'bt_server_interface' => 'Schermvoorkeuren',
    'pb__server_interface' => 'Schermvoorkeuren',

    'bt_wizard_next' => 'Volgende >>',
    'bt_wizard_prev' => '<< Terug',

    '__limit_exceeded_max_dom_server' => 'U kunt niet meer domeinen hosten op deze server omdat de beperking van het aantal domeinen dat onder de licentiesleutel op de server is toegestaan is bereikt. Neem contact op met uw provider om dit probleem op te lossen.',
    '__limit_exceeded_max_subdom_server' => 'U kunt niet meer subdomeinen op deze server hosten. Neem contact op met uw provider.',
    '__limit_exceeded_max_dom_aliases_server' => 'U kunt geen domeinaliassen meer instellen op deze server. Neem contact op met uw provider.',
    '__limit_exceeded_max_wu_server' => 'U kunt geen webgebruikers meer aanmaken omdat de beperking van het aantal webgebruikers dat onder de licentiesleutel op de server is toegestaan is bereikt. Neem contact op met uw provider om dit probleem op te lossen.',
    '__limit_exceeded_max_mn_server' => 'U kunt geen mailaccounts meer aanmaken omdat de beperking van het aantal mailaccounts dat onder de licentiesleutel op de server is toegestaan is bereikt. Neem contact op met uw provider om dit probleem op te lossen.',

    '__limit_exceeded_max_cl_useradmin' => 'U hebt de beperking van het aantal cliëntaccounts bereikt, zoals deze is bepaald door uw licentiesleutel (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'U hebt de beperking van het aantal domeinen, zoals bepaald door uw licentiesleutel, bereikt (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'U hebt de beperking van het aantal subdomeinen, zoals bepaald door uw licentiesleutel, bereikt (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'U hebt de beperking van het aantal domeinaliassen bereikt dat is vastgesteld door uw licentiesleutel (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'U hebt geen vrije schijfruimte meer over',
    '__limit_exceeded_max_wu_useradmin' => 'U hebt de beperking van het aantal webgebruikeraccounts, zoals bepaald door uw licentiesleutel, bereikt (%2)',
    '__limit_exceeded_max_db_useradmin' => 'U hebt de beperking van het aantal databases, zoals bepaald door uw licentiesleutel, bereikt (%2)',
    '__limit_exceeded_max_box_useradmin' => 'U hebt de beperking van het aantal postvakken, zoals bepaald door uw licentiesleutel, bereikt (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'U hebt de beperking van het aantal mailaccounts bereikt, zoals deze is bepaald door uw licentiesleutel (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'U hebt de beperking van het aantal verzendlijsten, zoals bepaald door uw licentiesleutel, bereikt (%2)',

    '__limit_exceeded_max_dom_userclient' => 'U hebt de beperking van het aantal domeinen bereikt (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'U hebt de beperking bereikt van het aantal subdomeinen (%2) dat door uw provider is toegestaan.',
    '__limit_exceeded_max_dom_aliases_userclient' => 'U hebt de beperking van het aantal domeinaliassen bereikt (%2)',
    '__limit_exceeded_disk_space_userclient' => 'U hebt de beperking van verbruikte schijfruimte bereikt (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'U hebt de beperking van de gebruikte hoeveelheid bandbreedte per maand bereikt (%2)',
    '__limit_exceeded_max_wu_userclient' => 'U hebt de beperking bereikt van het aantal webgebruikers (%2) dat door uw provider is toegestaan.',
    '__limit_exceeded_max_db_userclient' => 'U hebt de beperking van het aantal databases bereikt (%2)',
    '__limit_exceeded_max_box_userclient' => 'U hebt de beperking van het aantal postvakken bereikt (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'U hebt de beperking van het aantal verzendlijsten bereikt (%2)',
    '__limit_exceeded_expiration_userclient' => 'Uw account verloopt op %2',

    '__limit_exceeded_max_subdom_userdomain' => 'U hebt de beperking bereikt van het aantal subdomeinen (%2) dat door uw provider is toegestaan.',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'U hebt de beperking van het aantal domeinaliassen bereikt (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'U hebt de beperking van verbruikte schijfruimte bereikt (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'U hebt de beperking van de gebruikte hoeveelheid bandbreedte per maand bereikt (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'U hebt de beperking van het aantal webgebruikeraccounts bereikt (%2)',
    '__limit_exceeded_max_db_userdomain' => 'U hebt de beperking van het aantal databases bereikt (%2)',
    '__limit_exceeded_max_box_userdomain' => 'U hebt de beperking van het aantal postvakken bereikt (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'U hebt de beperking van het aantal verzendlijsten bereikt (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Uw account verloopt op %2',

    'mmt__to_none' => 'Geen',
    'mmt__to_admin' => 'Beheerder',
    'mmt__to_resellers_all' => 'Alle resellers',
    'mmt__to_resellers_select' => 'Geselecteerde resellers',
    'mmt__to_resellers_select__available' => 'Beschikbare resellers',
    'mmt__to_resellers_except' => 'Alle resellers behalve de geselecteerde',
    'mmt__to_clients_all' => 'Alle cliënten',
    'mmt__to_clients_select' => 'Geselecteerde cliënten',
    'mmt__to_clients_select__available' => 'Beschikbare cliënten',
    'mmt__to_clients_except' => 'Alle cliënten behalve de geselecteerde',

    'mmt__unable_send_empty_selection' => 'Kan geen e-mail voor een grote groep verzenden, geen e-mailadressen geselecteerd.',
    'mmt__unable_send_to__' => 'Kan geen e-mail voor een grote groep verzenden aan:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Kan de webtoepassing niet verifiëren omdat één van de vereiste bestanden (%1) niet is gevonden. Neem contact op met uw vertegenwoordiger voor technische ondersteuning voor verdere assistentie.',
    'sapp_error_validation_spec_failed' => 'De geüploade webtoepassing voldoet niet aan de AppPacks-specificaties: %1.',
    'sapp_error_validation_register' => 'Kan de webtoepassing in de map "%1" niet registreren: %2 U kunt de webtoepassing het beste van de server verwijderen omdat deze niet correct zal functioneren.',

    'sapp__install_failed' => 'Installatie van webtoepassing is mislukt: %1',
    'sapp__install_res_failed' => 'De poging om de aangevraagde bron te creëren is mislukt.',

    'server_preferences__subdomains_blog_and_photo' => 'Standaard subdomeinen aanmaken voor Blog en Fotogallery',
    'firewall__info' => 'Omwille van de veiligheid blokkeert de firewall alle verbindingen die niet expliciet zijn toegestaan. U kunt een verbinding toestaan door een regel aan te maken. Zie de documentatie voor meer informatie.',
    'plesk_key__blog_and_photo' => 'Bevoegdheid om de standaardinstelling van het selectievakje voor het aanmaken van de subdomeinen Blog en Fotogallery te beheren',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Kan het type IP-adres niet wijzigen naar exclusief omdat deze aan meer dan één gebruiker is toegewezen.',

    // 8.1.1


    'database_server_list__mssql_server_port_undefined' => "Kan het TCP-poortnummer niet vaststellen dat wordt gebruikt door Microsoft SQL server '%1': het TCP/IP-protocol is niet ingeschakeld in de netwerkinstellingen van de server of de server is insteld voor het gebruik van dynamische TCP-poorten.\n Om uw cliënten toe te staan de firewall voor externe database-toegang automatisch in te stellen moet u de SQL-server instellen om te luisteren op een specifieke, vaste TCP-poort.",
    '__local_server_mssql' => 'Lokale MS SQL-server',
    'pb__db_server_databases' => 'Beheer van database-server',

    '__write_modify_warning' => 'Door extra schrijf/wijzigingsrechten te selecteren zullen sommige webtoepassingen goed gaan functioneren, maar het zorgt ook voor een significante vergroting van beveiligingsrisico\'s',
    '__write_modify_subdomain_warning' => 'Door extra schrijf/wijzigingsrechten te selecteren zullen sommige webtoepassingen goed gaan functioneren, maar het zorgt ook voor een significante vergroting van beveiligingsrisico\'s',

    'phosting__php_incorrect_version_used' => "Er zijn problemen met de PHP-versie vastgesteld. Om deze problemen op te lossen, selecteert u het selectievakje voor de vereiste PHP-versie hieronder en klikt u op OK. Om PHP op dit domein uit te schakelen klikt u op OK zonder de PHP-versie te selecteren",
    'fp__mail_preferences' => 'Mail-instellingen',

    'mail__specify_patterns' => 'E-mailadressen',
    'mail__blocker_action_text' => 'Wat te doen met mail die aan de criteria voldoet:',
    'mail__action_delete' => 'Van server verwijderen',
    'mail__action_spam' => 'Als spam markeren',
    'mail__action_with_mails' => 'Bewerking',
    'mail__white_list_action_text' => 'Mail die aan de criteria voldoet zal niet worden aangemerkt als spam',
    'mail__invalid_white_pattern' => 'De opgegeven waarde is ongeldig. Gebruik de volgende notatie: mail@voorbeeld.nl voor e-mailadressen, voorbeeld.nl voor domeinen, of 123.123.123.123/32 voor IP-adressen.',
    'mail__invalid_black_pattern' => 'De opgegeven waarde is ongeldig. Gebruik de volgende notatie: mail@voorbeeld.nl voor e-mailadressen, voorbeeld.nl voor domeinen.',
    'mail__black_list_no_sa_warning' => 'Ingangen zullen niet als ongewenste e-mail worden gemarkeerd omdat Spamassassin niet is geïnstalleerd of is uitgeschakeld',

    'resp_edit__reply_as_html' => 'Versturen in HTML-formaat',
    'exception__path_very_long' => "Het zoekpad is te lang. Zorg ervoor, dat het zoekpad uit minder dan %1 tekens bestaat.",

    // 8.2


    //SAPP
    'sapp_on' => 'Aan',
    'sapp_off' => 'Uit',
    'sapp_directive_aspect' => 'Vereist',
    'sapp_databases_num' => 'Databases',
    'sapp_db_required' => 'Vereist',
    'sapp_Required' => 'Vereist',
    'sapp_Variant' => 'Variant',
    'sapp_db_id' => 'Database-kenmerk',
    'sapp_db_id_type' => 'Type DB (id: %1)',
    'sapp_db_id_min_version' => 'DB (id: %1) min versie',
    'sapp_db_id_table_prefix' => 'DB (id: %1) tabelvoorvoegsel',
    'sapp_Default' => 'Standaardwaarde',
    'sapp_apache_mod_req' => 'Apache-module',
    'sapp_dbtype_not_installed' => 'niet geïnstalleerd',
    'sapp_apache_mod_not_installed' => 'niet geïnstalleerd',
    'sapp__value_error_empty' => 'Lege waarde is niet toegestaan.',
    'sapp_error_invalid_type' => 'De toepassing "%1" ondersteunt de gevraagde bewerking niet.',
    'sapp_error_unknown_app_type' => 'Niet-ondersteund type toepassing: %1.',
    'sapp__ssl_text' => 'Toepassing installeren voor virtuele host "http://" of "https://"?',
    'sapp__app_to_upgrade' => 'Toepassingen geselecteerd voor upgrade',
    'sapp__upgrade_apps_title' => 'Toepassingen upgraden',
    'sapp__upgrade_to_ver' => 'Upgrade naar versie',
    'sapp__choose_pkg_ver' => 'Selecteer een pakket...',
    'sapp__pkg_cant_upgrade_pkg' => 'Het pakket "%1" kan niet worden gebruikt voor het upgraden van de webtoepassing "%2".',
    'sapp__app_ugrade_error' => 'Kan de toepassing niet upgraden: %1. Neem contact op met uw systeembeheerder.',
    'sapp__no_suitable_db_found' => 'Geen geschikte database gevonden.',
    'sapp__upgrade_success' =>  'Upgrade van de toepassing is geslaagd.',
    'sapp__pkg_info_changelog' => 'Overzicht van eerdere wijzigingen',
    'sapp_requirement_legend' => 'Hostingmogelijken vereist voor de toepassing',

    // other
    'odbc__mssql_wsid' => 'Werkstation-id',
    'odbc__mssql_driver' => 'Stuurprogramma',
    'bt_apply' => 'Toepassen',
    'tsclient_disabled' => 'U hebt geen toegangsrechten tot het systeem via Extern bureaublad',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Om een mailalias aan te maken, moet het postvak zijn ingeschakeld voor dit mailaccount. Postvak inschakelen?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Het uitschakelen van het postvak zal de mailaliassen verwijderen omdat deze niet langer functioneren. Wilt u het postvak uitschakelen?',
    'odbc__mysql_driver' => 'ODBC-stuurprogramma MySQL',
    'antivirus__disable_reason_install' => 'U kunt antivirus niet beheren omdat deze niet is geïnstalleerd.',
    'antivirus__disable_reason_key' => 'U kunt antivirus niet beheren omdat deze niet met een juiste licentiesleutel is geactiveerd.',
    'antivirus__disable_reason_deny_personal_settings' => 'U kunt antivirus niet beheren omdat het serverbeleid geen individuele instellingen voor antivirus toestaat',
    'component_name__sqladminmssql' => 'Microsoft SQL Webadmin',
    'change_foreign_user_password' => 'Wachtwoord wijzingen',
    'change_foreign_user_password_hint' => "De gebruiker hoort niet bij deze toepassing. Klik om de link om naar een andere toepassing te gaan en verander daar het wachtwoord van de gebruiker. Om dit te doen, moet u wel over de juiste rechten binnen de toepassing beschikken.",
    'cf_url_text' => 'URL JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Stringnotatie',
    'lang_unknown' => 'Onbekende taal',
    'odbc__access_driver' => 'Stuurprogramma',
    'odbc__access_pwd' => 'Wachtwoord',
    'odbc__access_uid' => 'Aanmeldingskenmerk',
    'odbc__excel_driver' => 'Stuurprogramma',
    'pb__cl_ed' => 'Details cliënt',
    'pb__actionlog' => 'Bewerkingslogboek',
    'pb__cl_limits' => 'Beperkingen van cliënt',
    'pb__edit' => 'Bewerken',
    'pb__subdom_edit' => 'Hostinginstellingen',
    'cf__select_dsn_to_remove' => 'Selecteer ten minste één DSN om te verwijderen',

    // NEW 8.3 FEATURES

    'firewall__port_range_warn_limit' => 'Het verwerken van de regels voor dit poortbereik kan veel tijd in beslag nemen. \\nWilt u doorgaan?',
    'firewall__port_range_exceeds_limit' => 'Het gespecificeerde poortbereik overtreft het beschikbare poortbereik van %1',

    'backup_mail_content' => 'Maak reservekopie van de inhoud van postvakken',

    'maillist_import_result' => "Totaal aantal e-mailadressen in bestand: %1\naantal geïmporteerde e-mailadressen: %2\naantal reeds bestaande e-mailadressen: %3\naantal dubbele e-mailadressen in geselecteerd bestand: %4\naantal ongeldige e-mailadressen in bestand: %5",
    'maillist_import_error' => 'Kan lijst met e-mailadressen niet importeren',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Het bestand dat u hebt geselecteerd is leeg of is geen geldig HTML-document met de geselecteerde karakterset. Selecteer de juiste karakterset of voeg simpelweg inhoud toe aan het bestand.",

    'dom_pref__external_mail_srv' => "Doorsturen naar externe mailserver met IP-adres:",
    'mn_edit__store_messages' => 'Postvak',

    // aps

    'sapp__before_upgrade_notice' => 'Het is aan te bevelen om de toepassing en de gebruikersgegevens op te slaan voordat u het upgraden start.',
    'sapp__application_properties' => 'Toepassingseigenschappen',
    'sapp__application_root_descr' => 'De hoofdpagina van de toepassing',

    'sapp__aps_license_invalid_id' => 'Licentiesleutel heeft ongeldige ID: %1',
    'sapp__aps_lic_key_alredy_exists' => 'Licentie met het sleutelnummer %1 is al in de database aanwezig.',
    'sapp__aps_lic_del_used' => 'Kan de licentiesleutel niet verwijderen, omdat deze wordt gebruikt door één van de geïnstalleerde toepassingen.',
    'sapp__aps_lic_del_unknown' => 'Kan de licentiesleutel niet verwijderen: %1',
    'sapp__aps_cappi_duplicate' => "Deze toepassing bevindt zich al in de toepassingsvoorziening van de cliënt",
    'sapp__appi_not_shared_no_install' => "Deze toepassing is niet aanwezig in de toepassingsvoorziening van de cliënt. Als u deze toepassing op een site wilt installeren, dan moet u deze eerst aan de toepassingsvoorziening van de cliënt toevoegen.",
    'sapp__appi_shared_not_client' => "Deze toepassing is niet aanwezig in de toepassingsvoorziening van de cliënt. Voor een upgrade van de toepassing naar de aangegeven versie moet u deze versie van de toepassing eerst aan de toepassingsvoorziening van de cliënt toevoegen.",
    'sapp__apply_license_script_not_found' => 'Kan het script "apply-license" voor deze webtoepassing niet vinden.',
    'sapp__unable_to_activate_key' => 'Er is een fout opgetreden tijdens een poging om de licentiesleutel te activeren: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Er zijn geïnstalleerde webtoepassingen waarvoor de aanwezigheid van deze webtoepassing in het systeem is vereist.',
    'sapp__unable_to_delete_ai_in_pool' => 'Deze toepassing is nog aanwezig in de voorziening van een cliënt. Als u deze toepassing wilt verwijderen, zult u deze ofwel eerst uit alle toepassingsvoorzieningen van cliënten moeten verwijderen, of deze kosteloos ter beschikking moeten stellen.',
    'sapp__unable_to_delete_app_template' => 'Kan de toepassing niet verwijderen #%1: %2',
    'sapp__limit_exceeded_client' => 'U hebt het maximale aantal keren bereikt dat u deze webtoepassing kunt installeren (%2).',


    // atis module

    '_week_on' => 'week op',
    '__week_first' => 'eerste',
    '__week_second' => 'tweede',
    '__week_third' => 'derde',
    '__week_fourth' => 'vierde',
    '__week_last' => 'laatste',
    '__not_started' => 'Wachten',
    '__started' => 'Wordt uitgevoerd',
    '__cancel_pending' => 'Bezig met annuleren',
    '__canceled' => 'Geannuleerd',
    '__error' => 'Fout',
    '__done' => 'Voltooid',

    '__php_cgi_handler' => 'CGI-toepassing',
    '__php_isapi_handler' => 'ISAPI-extensie',
    '__php_fastcgi_handler' => 'FastCGI-toepassing',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'uitvoeren als',

    'firewall_tabs_rules' => 'Firewall-regels',

    'cf_dbfolder_text' =>'Databasemap',
    'cf_isnewdb_text' => 'Database aanmaken',
    'cf_isnewdb_title' => 'Selecteer het selectievakje als de database moet worden aangemaakt',

    'pb__site_apps_upgrade' => 'Upgrade van webtoepassing',

    'detach' => 'Verbinding verbreken',
    'preferences' => "Wijzig Wachtwoord",

    'toolsbar__switch_user?' => "Weet u zeker dat u zich wilt aanmelden onder een andere gebruikersnaam?",
    '__aps_left' => 'Overgebleven installaties',
    'aps__license_key' => 'Licentiesleutel',
    'aps__download_code' => 'Download en activatiecode van licentiesleutel',
    'aps__license_key_hint' => 'Ophalen vanaf de licentieserver m.b.v. activatiecode',
    'aps__database_not_available' => 'niet beschikbaar, controleer de beperkingen van het domein of de cliënt',
    'aps__yes' => 'ja',
    'aps__no' => 'nee',
    '__click_to_enlarge' => 'Klik om te vergroten',
    'site_apps__back_to_list' => 'Terug naar lijst',
    'sapp__pkg_info_installation_requirements' => 'Installatievereisten',
    '__close_window' => 'Sluiten',

    //SAPP END

    'skin_info__already_default' => 'Dit thema is al als standaardthema ingesteld.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Instellingen Plesk Premium Antivirus Settings voor %1',
    'drweb:properties_legend' => 'Instellingen',
    'drweb:status' => 'Mail aan het controleren op virussen',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder-wizard',
    'dom_site_builder' => 'Klik om de Presence Builder-wizard te openen.',
    'sb_plesk_admin_url' => 'Presence Builder server URL. Controleer of dit adres goed werkt in DNS.',
    'sb_plesk_admin_login' => 'Gebruikersnaam voor het inloggen op de Beheerserver tot Presence Builder',
    'sb_plesk_admin_password' => 'Wachtwoord van beheerder',
    'sb_sitebuilder_preferences' => 'Gebruikersnaam en wachtwoord van Presence Builder-beheerder',
    'sb__server' => 'Voorkeuren Presence Builder-systeembeheerder',
    'sb__sitebuilder_support' => 'Presence Builder-ondersteuning',
    'sb_keep_sb_user' => 'Behoud het bijbehorende gebruikeraccount in Presence Builder',
    'sb_create_sb_user' => 'Maak een overeenkomstig gebruikeraccount aan in Presence Builder',
    'sb__build_site_using_sitebuilder' => "Website aanmaken met Presence Builder",
    'sb_no_current_sb_server_set' => 'De koppeling met Presence Builder is nog niet ingesteld: u moet aan het DNS-zonesjabloon een A-record toevoegen dat verwijst naar de Presence Builder-server.',
    'sb_unable_update_sb_server_sb_return_message' => "Kan de informatie uit het Presence Builder-systeem niet ophalen: \n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Kan geen verbinding maken met Presence Builder: verkeerde gebruikersnaam of wachtwoord.",
    'sb_init_sb_manager' => "Initialisatie van Web Presence Builder-manager: %1",
    'sb_err_couldnt_connect_sb' => "Het is niet gelukt om verbinding te maken met het Presence Builder-systeem.",
    'sb_err_client_dont_have_sbuser' => "Deze cliënt beschikt niet over een gebruikeraccount in Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder is niet geconfigureerd.",
    'sb_err_you_dont_have_sbaccount' => "Verificatie bij Presence Builder is mislukt.",
    'sb_error_critical_during_operation' => "De volgende fout is opgetreden in Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Ondersteuning voor eenmalige aanmelding is niet ingeschakeld in Plesk.",

    'forbid_create_dns_subzone' => "Gebruikers mogen geen DNS-subzones aanmaken in de DNS-superzones van andere gebruikers",
    'warning__super_zone_exist' => "De zone %1 is aangemaakt. Echter, deze zonenaam is een subzone van een andere reeds bestaande zone %2, die hoort bij een andere gebruiker %3. Dit is mogelijk correct, maar verzeker u ervan dat u het juiste gebruikeraccount heeft gekozen.",
    'error__super_zone_exist' => "Kan de DNS-zone niet opnieuw aanmaken omdat de bijbehorende superzone bij een andere gebruiker hoort.",

    'locales__files_not_exits' => 'Kan regio niet wijzigen: de bestanden van het opgegeven taalpakket zijn niet in het systeem aanwezig.',
    'locales__unavailable' => 'Kan regio niet wijzigen: het opgegeven taalpakket is niet beschikbaar.',

    // DB BU

    'pb__dbbackup_list' => 'Database-reservekopieën',
    // server
    'dbbackup__server_backup_settings' => 'Reservekopie',
    'dbbackup__network_temp_dir' => 'Tijdelijke netwerkmap',
    'dbbackup__network_user' => 'Gebruikersnaam',
    'dbbackup__network_pass' => 'Wachtwoord',
    // domain
    'dbbackup__add_database_legend' => 'Database terugplaatsen vanuit reservekopie',
    'dbbackup__add_database_restore' => 'Database terugplaatsen vanuit reservekopie',
    'dbbackup__add_database_file' => 'Reservekopie van database',
    'dbbackup__add_database_user' => 'Standaard gebruikersnaam',
    'dbbackup__add_database_pass' => 'Standaard wachtwoord voor gebruiker',
    'dbbackup__add_database_pass2' => 'Standaard wachtwoord voor gebruiker bevestigen',

    'bt_dbbackup_now' => 'Reservekopieën',

    'bt_repair' => 'Herstellen',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Het uploaden van SQL Server-databasedumps wordt niet toegestaan door de hostingprovider.',

    // APS categories

    'cf_invalid_password' => 'Wachtwoord mag niet langer zijn dan 16 tekens',
    'cf_invalid_description_length' => 'Omschrijving mag niet langer zijn dan 256 karakters',
    'ip_addr__ip_used_by_external_mail_server' => 'IP-adres %1 wordt al gebruikt door externe mailserver',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Gebruikersnaam of wachtwoord FTP-account is ongeldig. Controleer uw gegevens.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Het maximaal aantal wijzigingen van het serienummer is bereikt. Er kunnen vandaag geen wijzigingen in de DNS-zone meer worden uitgevoerd.',
    'dns__serial_format_legend' => 'Serienummernotatie DNS-zone',
    'dns__soa_param_serial_format_hint' => 'Gebruik van het serienummerformaat dat wordt aanbevolen door IETF en RIPE kan problemen oplossen als de registratie van een domein wordt geweigerd en is verplicht voor veel domeinen die worden geregistreerd in een aantal DNS-zones op hoog niveau.',
    'dns__soa_param_serial_format' => 'Het serienummerformaat gebruiken dat wordt aanbevolen door IETF en RIPE',
    'dns__serial_format_dns_zone_update_delay' => 'Het wisselen van het serienummerformaat van de DNS-zone kan leiden tot een vertraging in het bijwerken van de DNS-zone',
    'dns__zone_apply_changes' => 'De wijzigingen in de DNS-records zijn nog niet opgeslagen. De gemaakte wijzigingen worden hieronder aangegeven. Klik op Bijwerken om de wijzigingen van de DNS-zone toe te passen of klik op Ongedaan maken om terug te keren zonder de wijzigingen te behouden.',
    'dns__update_dns_zone' => 'Klik om de aanpassingen van de DNS-records toe te passen.',
    'dns__revert_dns_zone' => 'Klik om het aanpassen van DNS-records te annuleren.',
    'bt_revert' => 'Ongedaan maken',
    'dns__dns_zone_has_beed_updated' => 'De wijzigen van de DNS-records zijn opgeslagen',
    'dns__dns_zone_has_beed_reverted' => 'De wijzigen van de DNS-records zijn geannuleerd',
    'db__nondefault_server_not_allowed' => 'Gebruik van een niet-standaard database-server is niet toegestaan',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Account en domeinen van cliënt %1.',
    'ui__client__disabled-warning' => 'De account van cliënt %1 is opgeschort.',
    'ui__client__none-available' => 'Er zijn geen cliëntaccounts ingesteld.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Cliënt %1',
    'ui__client_self__description' => 'Lijst met mijn domeinen.',
    'ui__client_self__short-title' => 'Mijn domeinen',
    'ui__client_self__title' => 'Mijn domeinen',


    'site_apps__non_removable' => 'Onderdelen die niet verwijderd kunnen worden',
    'site_apps__non_removable_items' => 'De volgende webtoepassingen kunnen niet worden verwijderd:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Er zijn geen Eigen knoppen.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Er zijn geen Eigen knoppen in Hostingbeheer voor cliënt %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'De knop %1 verwijderen.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Verwijderen',
    'ui__client/custom-buttons/custom-button/delete__title' => 'De knop %1 verwijderen',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Eigen knoppen verwijderen uit Hostingbeheer van cliënt',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Verwijderen',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Eigen knoppen verwijderen',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Knoppen verwijderen',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Selecteer een cliënt waarvan u de Eigen knoppen wilt verwijderen en klik Volgende >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Selecteer de knoppen die u wilt verwijderen en klik Volgende >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bevestig de verwijdering van de knoppen door het selectievakje in dit scherm te selecteren en klik vervolgens op Voltooien.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Een Eigen knop uit Hostingbeheer van cliënt verwijderen.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Verwijderen',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Een Eigen knop verwijderen',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Eigen knop verwijderen',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Selecteer een cliënt waarvan u een Eigen knop wilt verwijderen en klik Volgende >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Selecteer een Eigen knop die u wilt verwijderen en klik Volgende >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bevestig de verwijdering van de Eigen knop door het selectievakje in dit scherm te selecteren en klik vervolgens op Voltooien.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Eigenschappen van knop op cliëntniveau %1 bewerken.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Instellingen',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Eigen knop %1 van cliënt aanpassen',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Eigen knop toevoegen',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selecteer een cliënt voor wiens Hostingbeheer u een Eigen knop wilt aanmaken en klik Volgende>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klik Voltooien om de knop aan te maken.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Eigenschappen wijzigen van een knop in Hostingbeheer van cliënt.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Eigenschappen',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Eigenschappen wijzigen van een knop in Hostingbeheer van cliënt',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Eigenschappen van Eigen knop wijzigen',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Selecteer een cliënt waarvan u een Eigen knop wilt aanpassen en klik Volgende >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Selecteer een Eigen knop die u wilt aanpassen en klik Volgende >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Wanneer u klaar bent met het bewerken de eigenschappen van de knop, klik Voltooien om wijzigingen op te slaan en deze wizard af te sluiten.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'De knop %1 niet langer aan uw klanten beschikbaar stellen.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Niet langer aan uw klanten beschikbaar stellen',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'De knop %1 niet langer aan uw klanten beschikbaar stellen',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Maak de knop %1 zichtbaar voor de gebruikers van de cliënt.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Aan uw klanten beschikbaar stellen',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Maak de knop %1 zichtbaar voor de gebruikers van de cliënt',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Stel een Eigen knop beschikbaar/niet beschikbaar aan uw klanten.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Beschikbaar/niet beschikbaar voor uw klanten',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Stel een Eigen knop beschikbaar of niet beschikbaar aan uw klanten',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Stel een Eigen knop beschikbaar/niet beschikbaar aan uw klanten.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Selecteer een cliënt wiens Eigen knop u beschikbaar wilt stellen aan zijn of haar klanten en klik Volgende >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Selecteer een Eigen knop die u beschikbaar of niet beschikbaar wilt stellen aan uw klanten en klik Volgende >>.',

    'ui__client/domain__description' => 'Domein %1 beheren.',
    'ui__client/domain__disabled-warning' => 'Domein %1 is opgeschort.',
    'ui__client/domain__none-available' => 'U hebt geen domeinen.',
    'ui__client/domain__none-available__1' => 'Het account van %1 beschikt niet over domeinen.',
    'ui__client/domain__none-available__2' => 'Het account van %1 beschikt niet over domeinen.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domein %1',
    'ui__client/domain_self__description' => 'Uw domein beheren.',
    'ui__client/domain_self__disabled-warning' => 'Uw domein is opgeschort.',
    'ui__client/domain_self__quick-search' => 'Mijn domeinen',
    'ui__client/domain_self__short-title' => 'Mijn domein',
    'ui__client/domain_self__title' => 'Mijn domein',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Er zijn geen eigen knoppen geplaatst in het Hostingbeheer van de cliënt.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Cliënt %1 heeft geen eigen knoppen in Hostingbeheer.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Er zijn geen Eigen knoppen voor het domein %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'De Eigen knop %1 verwijderen.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Verwijderen',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'De Eigen knop %1 verwijderen',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Eigen knoppen verwijderen.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Verwijderen',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Eigen knoppen verwijderen',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Eigen knoppen verwijderen',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Selecteer de cliënt uit wiens domeinbeheerpaneel u de knoppen wilt verwijderen en klik Volgende >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Selecteer het domein van welk beheerpaneel u de knoppen wilt verwijderen en klik Volgende >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Selecteer de knoppen die u wilt verwijderen en klik Volgende >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Bevestig de verwijdering van de knoppen door de bijbehorende selectievakjes te selecteren en klik Voltooien om de knoppen te verwijderen en deze wizard af te sluiten.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Een Eigen knop verwijderen.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Verwijderen',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Een Eigen knop verwijderen',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Een Eigen knop verwijderen',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Selecteer de cliënt uit wiens domeinbeheerpaneel u de Eigen knop wilt verwijderen en klik Volgende >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Selecteer het domein van welk beheerpaneel u de knop wilt verwijderen en klik Volgende >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Selecteer de Eigen knop die u wilt verwijderen en klik Volgende >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Bevestig de verwijdering van de Eigen knop door het selectievakje te selecteren en klik Voltooien om de knop te verwijderen en deze wizard af te sluiten.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "De eigenschappen van de Eigen knop %1 wijzigen",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Eigenschappen",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "De eigenschappen wijzigen van de eigen knop %1 in Hostingbeheer.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Een knop toevoegen',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selecteer de cliënt in wiens Hostingbeheer u de knop wilt plaatsen en klik Volgende>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Selecteer het abonnement waarvoor u de knop wilt aanpassen en klik Volgende >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Klik Voltooien om de knop aan te maken en de wizard af te sluiten.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "De eigenschappen wijzigen van een knop in Hostingbeheer.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Eigenschappen',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'De eigenschappen wijzigen van een knop in Hostingbeheer',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Knopeigenschappen wijzingen',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Selecteer de Eigen knop waarvan u de instellingen wilt wijzigen en klik Volgende >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Wanneer u klaar bent met het aanpassen van de eigenschappen van de knop, klik Voltooien om de wijzigingen op te slaan en deze wizard af te sluiten.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'De knop %1 niet langer beschikbaar stellen voor mailgebruikers binnen dit domein.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Niet beschikbaar voor mailgebruikers',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'De knop %1 niet langer beschikbaar stellen voor mailgebruikers binnen dit domein',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'De knop %1 zichtbaar maken voor mailgebruikers binnen het domein.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Toegankelijk voor mailgebruikers binnen dit domein',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'De Eigen knop %1 zichtbaar maken voor mailgebruikers binnen dit domein',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Stel een Eigen knop beschikbaar of niet beschikbaar aan andere gebruikers.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Beschikbaar/niet beschikbaar voor andere gebruikers',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Stel een Eigen knop beschikbaar of niet beschikbaar aan mailgebruikers',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Stel een Eigen knop beschikbaar of niet beschikbaar aan andere gebruikers',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Selecteer een domein om de knop te plaatsen en klik Volgende >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Selecteer een knop die u beschikbaar of niet beschikbaar wilt stellen aan andere gebruikers en klik Volgende >>.',

    'ui__client/domain/delete__description' => 'Het domein %1 verwijderen.',
    'ui__client/domain/delete__short-title' => 'Verwijderen',
    'ui__client/domain/delete__title' => 'Het domein %1 verwijderen',
    'ui__client/domain/delete_multi__description' => 'Domeinen verwijderen.',

    'ui__client/domain/delete_multi__short-title' => 'Verwijderen',
    'ui__client/domain/delete_multi__title' => 'Domeinen verwijderen',
    'ui__client/domain/delete_multi__wizard-title' => 'Domeinen verwijderen',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Selecteer de domeinen die u wilt verwijderen en klik Volgende >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Bevestig het verwijderen van de domeinen door het selectievakje te selecteren en klik vervolgens op Voltooien om ze te verwijderen en de wizard te sluiten.',
    'ui__client/domain/delete_unknown__description' => 'Een domein verwijderen.',
    'ui__client/domain/delete_unknown__short-title' => 'Verwijderen',
    'ui__client/domain/delete_unknown__title' => 'Domein verwijderen',
    'ui__client/domain/delete_unknown__wizard-title' => 'Een domein verwijderen',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Selecteer een domein dat u wilt verwijderen en klik Volgende >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Bevesting de verwijdering van het domein door het selectievakje te selecteren en klik Voltooien om deze wizard af te sluiten.',

    'ui__client/domain/hosting__none-available' => 'Er zijn geen domeinen waarvoor webhosting is ingesteld.',
    'ui__client/domain/hosting__none-available__1' => 'Dit gebruikeraccount bevat geen domeinen waarvoor webhosting is ingesteld.',
    'ui__client/domain/hosting__none-available__2' => 'Hosting is niet ingesteld voor domein %1.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'Uw bestanden en mappen beheren',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'Selecteer het domein waarvan u de bestanden wilt gebruiken.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'Hosting is nog niet ingesteld voor het domein. Stel fysieke hosting in klik Volgende >> om naar bestandsbeheer te gaan.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'Hosting is nog niet ingesteld voor uw domein. Stel fysieke hosting in klik Volgende >> om naar bestandsbeheer te gaan.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'Wanneer u klaar bent met de bestanden en mappen, klik Voltooien om deze wizard af te sluiten.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'Wanneer u klaar bent met de bestanden en mappen, klik Voltooien om deze wizard af te sluiten.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'De instellingen hostingprestaties bekijken.',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'Instellingen webhostingprestaties aanpassen',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'Kies het domein waarvoor u de hostingprestatie-instellingen wilt bekijken en klik op Volgende >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'Kies het domein waarvoor u de hostingprestatieconfiguratie wilt instellen en klik op Volgende >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'Pas de instellingen voor hostingprestaties voor het domein aan en klik op Voltooien.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'Wanneer u de hostingprestatie-instellingen voor het domein hebt bekeken, klikt u op Voltooien.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'Wanneer u de hostingprestatie-instellingen voor uw domein hebt bekeken, klikt u op Voltooien.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'Wanneer u de hostingprestatie-instellingen voor het domein hebt bekeken, klikt u op Voltooien.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'Wanneer u de hostingprestatieconfiguratie voor uw domein hebt ingesteld, klikt u op Voltooien.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'Wanneer u de hostingprestatieconfiguratie voor het domein hebt ingesteld, klikt u op Voltooien.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Cliënten",
    'ui__client/domain/hosting/application#list_header__description__title' => "Omschrijving",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Onderdelen",
    'ui__client/domain/hosting/application#list_header__name__title' => "Naam",
    'ui__client/domain/hosting/application#list_header__release__title' => "Versie",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Sorteren op cliënt",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Sorteren op omschrijving",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Sorteren op onderdeel",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Sorteren op naam",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Sorteren op exact versienummer",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Sorteren op versie",
    'ui__client/domain/hosting/application#list_header__title' => "Webtoepassingen",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versies",

    'ui__client/domain/properties__client_ip_address_was_assigned' => 'Het IP-adres %%ip_address%% is toegewezen aan %%client_name%%.',
    'ui__client/domain/properties__client_ip_pool_is_empty' => 'IP-voorziening van de gebruiker is leeg. Het geselecteerde IP-adres zal worden toegewezen aan het bijbehorende gebruikeraccount.',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => 'Het nieuwe domein zal direct worden aangemaakt zodra u klikt op Volgende >>.',

    'ui__client/domain/properties_new__wizard-title' => 'Domein aanmaken',
    'ui__client/domain/properties_new__wizard__1_unknown' => 'Selecteer de cliënt voor wie u het domein wilt aanmaken.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => 'Selecteer het gewenste type hosting en klik Volgende >>.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => 'Wanneer u klaar bent met het instellen van doorsturen op het domein, klik Voltooien om de instellingen op te slaan en de wizard af te sluiten.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => 'Wanneer u klaar bent met het instellen van de hostingdiensten op het domein, klik Voltooien om alle wijzigingen op te slaan en de wizard af te sluiten.',

    'ui__client/domain/properties_unknown__wizard-title' => 'Het domeinbeheerderaccount instellen',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => 'Selecteer het domein waarvoor u het domeinbeheerderaccount wilt instellen.',
    'ui__client/domain/properties_unknown__wizard__3' => 'Om het aanmaken van het domeinbeheerderaccount te voltooien, klik Voltooien.',
    'ui__client/domain/properties_unknown__wizard__3_self' => 'Om de wijzigingen toe te passen en de wizard af te sluiten, klik Voltooien.',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => 'Statistieken Anonieme FTP voor een domein',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => 'Statistieken Anonieme FTP',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => 'Statistieken Anonieme FTP voor een domein',

    'ui__client/domain/report/ftp-stats_unknown__description' => 'FTP-statistieken voor een domein',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'FTP-statistieken',
    'ui__client/domain/report/ftp-stats_unknown__title' => 'FTP-statistieken voor een domein',

    'ui__client/domain/report/traffic__description' => 'Gebruik van bandbreedte door de site %1 bekijken',
    'ui__client/domain/report/traffic__short-title' => 'Bandbreedteverbruik',
    'ui__client/domain/report/traffic__title' => 'Bandbreedteverbruik van site %1',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => 'Statistieken van beveiligde bezoeken aan de site',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => 'Statistieken van het bezoek via SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => 'Statistieken van beveiligde bezoeken aan de site',

    'rpt_reseller_section_general' => 'Algemeen',
    'rpt_reseller_section_domains' => 'Domeinen',
    'rpt_reseller_section_clients' => 'Cliënten',
    'statistics__cl_active_domains' => "Actieve domeinen",
    'rpt_reseller_cl_domains' => "Domeinen",
    'rpt_reseller_cl_subdomains' => "Subdomeinen",
    'by__cl_domains' => "domeinen van de cliënten",
    'dom_ctrl__cl_mboxes' => "Postvakken",
    'rpt_reseller_cl_redirects' => "Doorstuuradressen",
    'rpt_reseller_cl_mail_groups' => "Mailgroepen",
    'rpt_reseller_cl_mail_resps' => "Automatische beantwoordingen",
    'rpt_reseller_cl_mail_lists' => "Verzendlijsten",
    'rpt_reseller_cl_web_users' => "Webgebruikers",
    'rpt_reseller_cl_data_bases' => "Databases",

    'statistics__active_clients' => 'Cliënten met actieve pakketen',
    'statistics__clients_active_domains' => 'Actieve domeinen',
    'statistics__clients_doms' => 'Domeinen',
    'statistics__cl_doms' => 'Domeinen',
    '__clients_subdomains' => 'Subdomeinen',
    '__clients_domains' => 'Domeinen',
    'dom_ctrl__clients_mboxes' => 'Postvakken',
    'dom_ctrl__clients_redir' => 'Doorstuuradressen',
    'dom_ctrl__clients_mg' => 'Mailgroepen',
    'dom_ctrl__clients_resp' => 'Automatische beantwoordingen',
    'dom_ctrl__clients_maillists' => 'Verzendlijsten',
    'dom_ctrl__clients_wu' => 'Webgebruikers',
    'dom_ctrl__clients_db' => 'Databases',

    'dom_ctrl__cl_redir' => 'Doorstuuradressen', // to resolve!
    'dom_ctrl__cl_mg' => 'Mailgroepen', // to resolve!
    'dom_ctrl__cl_resp' => 'Automatische beantwoordingen', // to resolve!
    'dom_ctrl__cl_maillists' => 'Verzendlijsten', // to resolve!
    'dom_ctrl__cl_wu' => 'Webgebruikers', // to resolve!
    'dom_ctrl__cl_db' => 'Databases', // to resolve!

    'rpt_cl_section_clients' => 'Cliënten',

    'rpt_admin_section_general' => 'Algemeen',
    'rpt_admin_section_resellers' => 'Resellers',
    'rpt_admin_section_clients' => 'Cliënten',
    'rpt_admin_section_personal_clients' => 'Eigen cliënten',
    'rpt_admin_section_domains' => 'Domeinen',
    'rpt_admin_section_personal_domains' => 'Persoonlijke domeinen',

    'rpt_reseller_section_personal_domains' => 'Persoonlijke domeinen',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Selecteer het domein dat u wilt opschorten of activeren.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Domein opschorten of activeren',

    'ui__client/ip-pool__description' => 'IP-adressen en SSL/TLS-certificaten toewijzen aan en terugnemen van cliënt %1.',
    'ui__client/ip-pool__short-title' => 'IP-voorziening',
    'ui__client/ip-pool__title' => 'IP-voorziening van cliënt %1',
    'ui__client/ip-pool_self__description' => 'Uw IP-voorziening bekijken.',
    'ui__client/ip-pool_self__short-title' => 'IP-voorziening',
    'ui__client/ip-pool_self__title' => 'Mijn IP-voorziening',
    'ui__client/ip-pool/properties__description' => 'IP-voorziening voor cliënt %1 instellen.',

    'ui__client/ip-pool/properties__short-title' => 'IP-voorziening',
    'ui__client/ip-pool/properties__title' => 'IP-voorziening voor cliënt %1 instellen',
    'ui__client/ip-pool/properties_self__description' => 'Uw IP-voorziening bekijken.',

    'ui__client/ip-pool/properties_self__short-title' => 'Mijn IP-voorziening',
    'ui__client/ip-pool/properties_self__title' => 'Mijn IP-voorziening',
    'ui__client/ip-pool/properties_unknown__description' => 'IP-adressen en SSL/TLS-certificaten toewijzen aan en terugnemen van cliënten.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP-voorziening',
    'ui__client/ip-pool/properties_unknown__title' => 'IP-voorziening van cliënt instellen',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'IP-voorziening van cliënt instellen',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Selecteer de cliënt wiens IP-voorziening u wilt instellen.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Wanneer u klaar bent met het instellen van de IP-voorziening, klik Voltooien om de wijzigingen op te slaan en de wizard af te sluiten.',


    'ui__client/limits_readonly-unknown__description' => 'Bekijk beperkingen van een cliënt.',
    'ui__client/limits_readonly-unknown__short-title' => 'Beperkingen',
    'ui__client/limits_readonly-unknown__title' => 'Bekijk beperkingen van een cliëntaccount',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Beperkingen van een cliënt bekijken of wijzigen',

    'ui__client/limits_unknown__wizard-title' => 'Beperkingen van een cliënt bekijken of wijzigen',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Selecteer de juiste cliënt.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Selecteer de juiste cliënt.',
    'ui__client/limits_unknown__wizard__2' => 'Klik voltooien om de wijzigen toe te passen.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Om de wizard af te sluiten klikt u op Voltooien.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Om de wizard af te sluiten klikt u op Voltooien.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Om de wizard af te sluiten klikt u op Voltooien.',

    'ui__client/permissions_unknown__wizard-title' => 'Rechten voor een cliënt bekijken of wijzigen',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Wanneer u klaar bent met het bekijken van uw rechten, klik Voltooien om de wijzigingen op te slaan en de wizard af te sluiten.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Selecteer de cliënt wiens rechten u wilt inzien of wijzigen.',
    'ui__client/permissions_unknown__wizard__2' => 'Wanneer de rechten van de cliënt hebt bewerkt, klikt u op Voltooien om de wijzigen toe te passen en de wizard af te sluiten.',

    'ui__client/preferences_unknown__wizard-title' => 'Voorkeuren van cliënt bewerken',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Selecteer de cliënt wiens sessie- en schermvoorkeuren u wilt beheren.',
    'ui__client/preferences_unknown__wizard__2' => 'Wanneer de voorkeuren van de cliënt hebt gewijzigd, klikt u op Voltooien.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Wanneer u uw voorkeuren hebt gewijzigd, klikt u op Voltooien.',

    'ui__custom-buttons/custom-button__none-available' => 'U hebt geen Eigen knoppen.',
    'ui__custom-buttons/custom-button/delete__description' => 'De Eigen knop %1 verwijderen.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Verwijderen',
    'ui__custom-buttons/custom-button/delete__title' => 'De Eigen knop %1 verwijderen',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'De Eigen knoppen verwijderen.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Verwijderen',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Eigen knoppen verwijderen',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Eigen knoppen verwijderen',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Selecteer de knoppen die u wilt verwijderen.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Bevestig de verwijdering van de knoppen door het selectievakje te selecteren en klik Voltooien om de wizard af te sluiten.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Eigen knoppen verwijderen.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Verwijderen',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Eigen knoppen verwijderen',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Eigen knoppen verwijderen',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Selecteer de Eigen knop die u wilt verwijderen.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Bevestig de verwijdering van de knop door het selectievakje te selecteren en klik Voltooien om de wizard af te sluiten.',
    'ui__custom-buttons/custom-button/properties__description' => 'De eigenschappen van de knop %1 wijzigen.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Eigenschappen',
    'ui__custom-buttons/custom-button/properties__title' => 'De eigenschappen van de knop %1 wijzigen',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Knop aanmaken',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Klik Voltooien om de knop aan te maken.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'De eigenschappen van een Eigen knop wijzigen.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Eigenschappen',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'De eigenschappen van een Eigen knop wijzigen',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'De eigenschappen van een Eigen knop wijzigen',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Selecteer de Eigen knop waarvan u de eigenschappen wilt veranderen.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Klik voltooien om de wijzigen toe te passen.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'De Eigen knop %1 niet langer aan andere gebruikers beschikbaar stellen.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Niet beschikbaar voor andere gebruikers',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'De Eigen knop %1 niet langer aan andere gebruikers beschikbaar stellen',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'De Eigen knop %1 beschikbaar stellen aan andere gebruikers.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Beschikbaar voor andere gebruikers',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'De Eigen knop %1 beschikbaar stellen aan andere gebruikers',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'De Eigen knop beschikbaar of niet-beschikbaar maken voor andere gebruikers.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Beschikbaar of niet beschikbaar voor andere gebruikers',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'De Eigen knop beschikbaar of niet-beschikbaar maken voor andere gebruikers',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'De Eigen knop beschikbaar of niet-beschikbaar maken voor andere gebruikers',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Selecteer de Eigen knop die u beschikbaar of niet beschikbaar wilt stellen aan andere gebruikers en klik Volgende >>.',

    'ui__longtasks#list_header__name__title' => "Naam",
    'ui__longtasks#list_header__owner__title' => "Eigenaar",
    'ui__longtasks#list_header__start_time__title' => "Tijd van aanmaken",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Taken",
    'ui__longtasks#list_header__finish_time__title' => "Tijd voor voltooiing",
    'ui__longtasks#task_list_legend__title' => "Taken",
    'ui__longtasks#tools_legend__title' => "Hulpprogramma's",
    'ui__longtasks__description' => "Achtergrondtaken beheren",
    'ui__longtasks__short-title' => "Achtergrondtaken",
    'ui__longtasks__title' => "Achtergrondtaken",
    'ui__longtasks/longtask/properties#current_operation__title' => "Huidige bewerking:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Geschatte tijd voor voltooiing:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Algemeen",
    'ui__longtasks/longtask/properties#owner__title' => "Taak gestart door:",
    'ui__longtasks/longtask/properties#progress__title' => "Algehele voortgang:",
    'ui__longtasks/longtask/properties#start_time__title' => "Taak gestart:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Status van taak",
    'ui__longtasks/longtask/properties__description' => "Status van en informatie over achtergrondtaken",

    'ui__longtasks/properties__description' => "Instellen van achtergrondtaken",
    'ui__longtasks/properties__short-title' => "Instellingen",
    'ui__longtasks/properties__title' => "Achtergrondtaken",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Sjablonen voor e-mailberichten voor een grote groep',
    'ui__mass-mail/template#list_header__name__title' => 'Sjabloonnaam',
    'ui__mass-mail/template#list_header__from_email__title' => 'Afzender',
    'ui__mass-mail/template#list_header__to__title' => 'Ontvangers',
    'ui__mass-mail/template#list_header__subject__title' => 'Onderwerp',
    'ui__mass-mail/template#list_header__cdate__title' => 'Datum van aanmaken',
    'ui__mass-mail/template#list_header__send__title' => 'Verzenden',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Sjabloon voor e-mailbericht aan grote groep bewerken',
    'ui__mass-mail/template/properties__description' => 'Dit sjabloon voor e-mailberichten aan een grote groep bewerken.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Sjabloon voor e-mail aan een grote groep toevoegen',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Sjabloon voor e-mail aan een grote groep toevoegen',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Een sjabloon voor e-mailbericht aan grote groep toevoegen.',
    'ui__mass-mail/send__short-title' => 'E-mail aan een grote groep versturen',
    'ui__mass-mail/send__title' => 'E-mailbericht aan een grote groep versturen',
    'ui__mass-mail/send__description' => 'E-mailbericht naar een grotere groep versturen maar alleen naar geselecteerde ontvangers.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Sjablonen voor e-mail aan een grote groep verwijderen',
    'ui__mass-mail/template/delete_multi__title' => 'De volgende sjablonen voor e-mailberichten aan een grote groep verwijderen:',
    'ui__mass-mail/template/delete_multi__description' => 'Geselecteerde sjablonen voor e-mailbericht aan grote groep verwijderen.',
    'ui__mass-mail/template/delete_multi__done' => 'De geselecteerde berichtsjablonen zijn verwijderd.',
    'ui__mass-mail/template/properties__invalid_values' => 'Ongeldige waarden opgegeven',


    // old
    'ui__mass-mail#body_text__description' => 'U kunt de <name>variabele in de tekst van het bericht gebruiken (maar niet in de header). Deze zal worden vervangen door de contactnaam van de cliënt of reseller.',
    'ui__mass-mail#body_text__title' => 'Tekst van bericht',
    'ui__mass-mail#compose_legend__title' => 'Bericht',
    'ui__mass-mail#from_email_text__title' => 'Vanaf (e-mail)',
    'ui__mass-mail#list_header__cdate__title' => 'Aangemaakt',
    'ui__mass-mail#list_header__from_email__title' => 'Van',
    'ui__mass-mail#list_header__name__title' => 'Naam',
    'ui__mass-mail#list_header__send__title' => 'Bericht aanmaken',
    'ui__mass-mail#list_header__subject__title' => 'Onderwerp',
    'ui__mass-mail#list_header__title' => 'Sjablonen voor e-mailberichten voor een grote groep',
    'ui__mass-mail#list_header__to__title' => 'Aan',
    'ui__mass-mail#list_legend__title' => 'Sjablonen voor e-mailberichten voor een grote groep',
    'ui__mass-mail#load_template_text__title' => 'Laden',
    'ui__mass-mail#name_text__title' => 'Sjabloonnaam',
    'ui__mass-mail#option_mode_all__title' => 'Alle',
    'ui__mass-mail#option_mode_except__title' => 'Alle behalve selectie',
    'ui__mass-mail#option_mode_select__title' => 'Alleen selectie',
    'ui__mass-mail#option_select_template__title' => '--Selecteer een sjabloon--',
    'ui__mass-mail#picker_legend__title' => 'Sjablonen voor e-mailberichten voor een grote groep',
    'ui__mass-mail#picker_title__title' => 'Selecteer een sjabloon',
    'ui__mass-mail#save_as_legend__title' => 'Opslaan als sjabloon',
    'ui__mass-mail#save_as_text__title' => 'Bewaar ingevoerd bericht als een nieuw sjabloon met de naam',
    'ui__mass-mail#subject_text__title' => 'Onderwerp',
    'ui__mass-mail#template_legend__title' => 'Sjabloon',
    'ui__mass-mail#to_admin_text__title' => 'Plesk-beheerder',
    'ui__mass-mail#to_clients_text__title' => 'Cliënten',
    'ui__mass-mail#to_domains_text__title' => 'Domeinbeheerders',
    'ui__mass-mail#to_select_text__title' => 'Selecteer adressen',
    'ui__mass-mail#to_show_hide_text__title' => 'Selectie tonen of verbergen',
    'ui__mass-mail#to_text__title' => 'Aan',
    'ui__mass-mail#tools_legend__title' => 'Hulpprogramma\'s',
    'ui__mass-mail__already_exists' => 'Sjabloon met naam %1 bestaat al',
    'ui__mass-mail__none-available' => 'U hebt geen berichtsjablonen.',

    'ui__mass-mail/delete__description' => 'Het sjabloon voor emailbericht aan grote groep %1 verwijderen',

    'ui__mass-mail/delete__empty_selection' => 'Selecteer het sjabloon dat u wilt verwijderen',
    'ui__mass-mail/delete__short-title' => '%1 verwijderen',
    'ui__mass-mail/delete__title' => 'Het sjabloon voor emailbericht aan grote groep %1 verwijderen',
    'ui__mass-mail/delete_multi__description' => 'Sjablonen voor e-mailbericht aan grote groep verwijderen.',

    'ui__mass-mail/delete_multi__short-title' => 'Verwijderen',
    'ui__mass-mail/delete_multi__title' => 'Sjablonen voor e-mailbericht aan grote groep verwijderen',
    'ui__mass-mail/delete_multi__wizard-title' => 'Verwijdering van sjablonen voor e-mailberichten voor een grote groep',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Selecteer de sjablonen voor e-mailberichten aan een grote groep die u wilt verwijderen.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Bevestig de verwijdering van de sjablonen door het selectievakje te selecteren en klik Voltooien om de wizard af te sluiten.',
    'ui__mass-mail/delete_unknown__description' => 'Sjablonen voor e-mailbericht aan grote groep verwijderen.',
    'ui__mass-mail/delete_unknown__short-title' => 'Verwijderen',
    'ui__mass-mail/delete_unknown__title' => 'Sjablonen voor e-mailbericht aan grote groep verwijderen',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Verwijdering van sjablonen voor e-mailberichten voor een grote groep.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Selecteer het sjabloon voor een e-mailbericht aan een grote groep dat u wilt verwijderen.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Bevestig de verwijdering van het sjabloon door het selectievakje te selecteren en klik Voltooien om de wizard af te sluiten.',

    'ui__mass-mail/properties__description' => 'Sjabloon van e-mailbericht %1 bewerken.',

    'ui__mass-mail/properties__invalid_values' => 'Opgegeven waarden zijn onjuist',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Sjabloon van e-mailbericht %1 bewerken',

    'ui__mass-mail/properties_new__wizard-title' => 'Sjabloon voor e-mailbericht aan grote groep aanmaken',
    'ui__mass-mail/properties_unknown-new__description' => 'Een sjabloon voor e-mailberichten aanmaken.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Sjabloon voor e-mailbericht toevoegen',
    'ui__mass-mail/properties_unknown-new__title' => 'Sjabloon voor e-mailbericht aanmaken',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Sjabloon voor e-mailbericht aan grote groep bewerken',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Selecteer het sjabloon dat u wilt aanpassen en klik Volgende >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Wanneer u klaar bent met het bewerken van het sjabloon, klik Voltooien om de wijzigingen op te slaan en de wizard af te sluiten.',

    'ui__mass-mail/send__invalid_values' => 'U hebt onjuiste waarden opgegeven',

    'ui__mass-mail/send_new__wizard-title' => 'Een berichtsjabloon aanmaken en e-mail versturen',
    'ui__mass-mail/send_unknown-new__description' => 'E-mail versturen aan geselecteerde ontvangers',

    'ui__mass-mail/send_unknown-new__short-title' => 'E-mail aan een grote groep versturen',
    'ui__mass-mail/send_unknown-new__title' => 'E-mailbericht aan een grote groep versturen',
    'ui__mass-mail/send_unknown__description' => 'E-mail versturen aan geselecteerde ontvangers',

    'ui__mass-mail/send_unknown__short-title' => 'E-mail aan een grote groep versturen',
    'ui__mass-mail/send_unknown__title' => 'E-mailbericht aan een grote groep versturen',
    'ui__mass-mail/send_unknown__wizard-title' => 'E-mailbericht aan een grote groep versturen',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Selecteer het sjabloon dat u nodig hebt en klik Volgende >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Wanneer u klaar bent met het bewerken de eigenschappen van het sjabloon, klik Voltooien om het bericht te versturen en de wizard af te sluiten.',

    'ui__mass-email/delete__description' => 'Geselecteerde sjablonen voor e-mailbericht aan grote groep verwijderen.',

    'ui__mass-email/delete__empty_selection' => "Selecteer de sjablonen die u wilt verwijderen.",
    'ui__mass-email/delete__short-title' => "%1 verwijderen",
    'ui__mass-email/delete__title' => "Het sjabloon voor emailbericht aan grote groep %1 verwijderen",
    'ui__mass-email/delete_multi__description' => "Sjablonen voor e-mailbericht aan grote groep verwijderen.",

    'ui__mass-email/delete_multi__short-title' => "Verwijderen",
    'ui__mass-email/delete_multi__title' => "Sjablonen voor e-mailbericht aan grote groep verwijderen",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Bevestig de verwijdering van de sjablonen door het selectievakje te selecteren en klik Voltooien om de wizard af te sluiten.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Selecteer de sjablonen voor e-mailberichten aan een grote groep die u wilt verwijderen.",
    'ui__mass-email/delete_multi__wizard-title' => "Verwijdering van sjablonen voor e-mailberichten voor een grote groep",
    'ui__mass-email/delete_unknown__description' => "Sjablonen voor e-mailbericht aan grote groep verwijderen.",
    'ui__mass-email/delete_unknown__short-title' => "Verwijderen",
    'ui__mass-email/delete_unknown__title' => "Sjablonen voor e-mailbericht aan grote groep verwijderen",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Bevestig de verwijdering van het sjabloon door het selectievakje te selecteren en klik Voltooien om de wizard af te sluiten.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Selecteer het sjabloon voor een e-mailbericht aan een grote groep dat u wilt verwijderen.",
    'ui__mass-email/delete_unknown__wizard-title' => "Verwijdering van sjablonen voor e-mailberichten voor een grote groep.",
    'ui__mass-email/send__description' => "E-mail versturen aan geselecteerde ontvangers",
    'ui__mass-email/send__short-title' => "E-mail aan een grote groep versturen",
    'ui__mass-email/send__title' => "E-mailbericht aan een grote groep versturen",
    'ui__mass-email/send_main__description' => "E-mail versturen aan geselecteerde ontvangers",

    'ui__mass-email/send_main__short-title' => "E-mail aan een grote groep versturen",
    'ui__mass-email/send_main__title' => "E-mailbericht aan een grote groep versturen",
    'ui__mass-email/send_selectresellers__title' => 'Resellers selecteren',
    'ui__mass-email/send_selectresellers__short-title' => 'Resellers',
    'ui__mass-email/send_selectresellers__description' => 'Reselleraccounts selecteren',

    'ui__mass-email/send_selectclients__description' => "Cliëntaccounts selecteren",

    'ui__mass-email/send_selectclients__short-title' => "Cliënten",
    'ui__mass-email/send_selectclients__title' => "Cliënten selecteren",
    'ui__mass-email/send_selectdomainusers__description' => "Domeinbeheerderaccounts selecteren",

    'ui__mass-email/send_selectdomainusers__short-title' => "Domeinbeheerders",
    'ui__mass-email/send_selectdomainusers__title' => "Domeinbeheerders selecteren",
    'ui__mass-email/template/properties_main__description' => "Sjabloon voor e-mailbericht aan grote groep aanmaken",
    'ui__mass-email/template/properties_main__short-title' => "Sjabloon bewerken",
    'ui__mass-email/template/properties_main__title' => "Sjabloon voor e-mailbericht aan grote groep bewerken",
    'ui__mass-email/template/properties_new-main__description' => "Een sjabloon voor e-mailberichten aan een grote groep aanmaken.",
    'ui__mass-email/template/properties_new-main__short-title' => "Sjabloon voor e-mailbericht aan grote groep aanmaken",
    'ui__mass-email/template/properties_new-main__title' => "Sjabloon voor e-mailbericht aan grote groep aanmaken",
    'ui__mass-email/template/properties_new-selectclients__description' => "Selecteer cliënten die e-mailberichten aan een grote groep moeten ontvangen die zijn gebaseerd op dit sjabloon",
    'ui__mass-email/template/properties_new-selectclients__title' => "Selecteer cliënten die e-mailberichten aan een grote groep moeten ontvangen die zijn gebaseerd op dit sjabloon",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Selecteer domeinbeheerders die e-mailberichten aan een grote groep moeten ontvangen die op dit sjabloon zijn gebaseerd.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Selecteer domeinbeheerders die e-mailberichten aan een grote groep moeten ontvangen die op dit sjabloon zijn gebaseerd.",
    'ui__mass-email/template/properties_selectclients__title' => "Selecteer cliënten die e-mailberichten aan een grote groep moeten ontvangen die zijn gebaseerd op dit sjabloon",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Selecteer domeinbeheerders die e-mailberichten aan een grote groep moeten ontvangen die op dit sjabloon zijn gebaseerd.",

    'ui__mass-email/template/properties_unknown-new__description' => "Een berichtsjabloon voor e-mail aan een grote groep aanmaken",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Sjabloon aanmaken",
    'ui__mass-email/template/properties_unknown-new__title' => "Sjablonen aanmaken voor e-mail aan een grote groep",
    'ui__news/dismiss__description' => 'Klik om het nieuwsblok te sluiten. Plesk zal dit blok niet meer tonen zolang er geen nieuwe berichten zijn.',

    'ui__news/dismiss__title' => 'Het nieuws sluiten',

    'ui__server__description' => 'Serverbeheer.',
    'ui__server__short-title' => 'Uw server beheren',
    'ui__server__title' => 'Serverbeheer',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'Het IP-adres %1 is niet beschikbaar.',
    'ui__server/ip-address__none-available' => 'Er zijn geen IP-adressen.',
    'ui__server/ip-addresses/ip-address__title' => "IP-adressen",
    'ui__server/ip-address/client/properties_new__description' => "IP-adres %1 aan resellers toewijzen.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Toewijzen',
    'ui__server/ip-address/client/properties_new__title' => "IP-adres %1 aan resellers toewijzen",
    'ui__server/ip-address/client__none-available' => 'Er zijn geen gebruikeraccounts',
    'ui__server/ip-address/client_unknown__quick_search' => 'Gebruikers',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Lijst van gebruikers die gebruik maken van dit IP-adres.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Selecteer het IP-adres.',
    'ui__server/ip-address/client/delete__description' => 'De reseller IP-adres ontnemen.',
    'ui__server/ip-address/client/delete__short-title' => 'Ontnemen',
    'ui__server/ip-address/client/delete__title' => 'De reseller IP-adres ontnemen',
    'ui__server/ip-address/client/delete_multi__description' => "Het IP-adres uit de voorziening van resellers halen.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Ontnemen',
    'ui__server/ip-address/client/delete_multi__title' => 'Een reseller een IP-adres ontnemen',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "IP-adres verwijderen uit voorziening van gebruikers.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Selecteer het IP-adres dat u aan gebruikers wilt onttrekken en klik Volgende >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Selecteer de gebruikers aan wie u het IP-adres wilt ontnemen en klik Volgende >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Bevestig het onttrekken van het IP-adres aan de gebruikers door het selectievakje te selecteren en klik Voltooien om de wizard af te ronden.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Resellers een IP-adres ontnemen.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Ontnemen',
    'ui__server/ip-address/client/delete_unknown__title' => 'Resellers IP-adres ontnemen',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Gebruikers een IP-adres afnemen',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Selecteer het IP-adres dat u aan gebruikers wilt onttrekken en klik Volgende >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Selecteer de gebruiker aan wie u het IP-adres wilt ontnemen en klik Volgende >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Bevestig het onttrekken van het IP-adres aan de gebruikers door het selectievakje te selecteren en klik Voltooien om de wizard af te ronden.',

    'ui__server/ip-address/domain__description' => "Alle domeinen op het IP-adres %1.",
    'ui__server/ip-address/domain__short-title' => "Domeinen",
    'ui__server/ip-address/domain__title' => "Domein op het IP-adres %1",
    'ui__server/ip-address/domain_unknown__description' => "Alle domeinen op het IP-adres.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domeinen",
    'ui__server/ip-address/domain_unknown__title' => "Domeinen op IP-adres",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Selecteer het juiste IP-adres en klik op volgende >>.",

    'ui__server/ip-address/properties__description' => 'De eigenschappen van het IP-adres %1 wijzigen.',
    'ui__server/ip-address/properties__short-title' => 'Eigenschappen',
    'ui__server/ip-address/properties__title' => 'De eigenschappen van het IP-adres %1 wijzigen',

    'ui__server/ip-address/properties_new__wizard-title' => 'IP-adres toevoegen',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Als u klaar bent met het aanpassen van de eigenschappen van het domeinalias klikt u op Voltooien om de wijzigingen op te slaan.',
    'ui__server/ip-address/properties_unknown__description' => 'De eigenschappen van het IP-adres wijzigen.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Eigenschappen',
    'ui__server/ip-address/properties_unknown__title' => 'De eigenschappen van het IP-adres wijzigen',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'De eigenschappen van het IP-adres wijzigen',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Selecteer het IP-adres waarvan u de eigenschappen wilt wijzingen.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Als u klaar bent met het aanpassen van de eigenschappen van het domeinalias klikt u op Voltooien om de wijzigingen op te slaan.',

    'ui__server/spam-filter/black-list__description' => 'Zwarte lijst instellen voor het spamfilter van de server als geheel.',
    'ui__server/spam-filter/black-list__short-title' => 'Zwarte lijst',
    'ui__server/spam-filter/black-list__title' => 'Zwarte lijst voor spamfilter van server als geheel',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Alleen de %1 eerste unieke e-mailadressen zullen worden toegevoegd.',
    'ui__server/spam-filter/black-list/address__description' => 'Adres van zwarte lijst van het spamfilter.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Er staan geen adressen in de lijst.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Het geüploade bestand is leeg.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'De volgende e-mailadressen zijn ongeldig: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Er staan geen adressen in de zwarte lijst van het spamfilter.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adres',
    'ui__server/spam-filter/black-list/address__title' => 'Zet adres %1 op de zwarte lijst',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Adressen aan de zwarte lijst toevoegen.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Adressen toevoegen',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Adressen aan de zwarte lijst toevoegen',

    'ui__server/spam-filter/black-list/address/delete__description' => '%1 adres van de zwarte lijst voor de server als geheel verwijderen.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Verwijderen',
    'ui__server/spam-filter/black-list/address/delete__title' => '%1 adres van de zwarte lijst voor de server als geheel verwijderen',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Adressen verwijderen van de zwarte lijst voor de server als geheel.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Verwijderen',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Adressen verwijderen van de zwarte lijst voor de server als geheel',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Verwijdering van adressen uit de zwarte lijst van het spamfilter van de server als geheel',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Selecteer de spamfilteradressen die u wilt verwijderen en klik Volgende >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Bevestig de verwijdering van de spamfilteradressen door het selectievakje te selecteren en klik Voltooien voor een volledige verwijdering en om de wizard af te sluiten.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Adres verwijderen van de zwarte lijst voor de server als geheel.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Verwijderen',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Adres verwijderen van de zwarte lijst voor de server als geheel',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Verwijdering van adressen uit de zwarte lijst van het spamfilter van de server als geheel',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Selecteer het spamfilteradres dat u wilt verwijderen en klik Volgende >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Bevestig de verwijdering van het spamfilteradres door het selectievakje te selecteren en klik Voltooien voor een volledige verwijdering en om de wizard af te sluiten.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Alleen de %1 eerste unieke e-mailadressen zullen worden toegevoegd.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Er staan geen adressen in de lijst.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Kan het bestand niet uploaden. De maximale omvang van een bestand om te uploaden is %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'De volgende e-mailadressen zijn ongeldig: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Adressen aan de zwarte lijst toevoegen.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Adressen toevoegen',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Adressen aan de zwarte lijst toevoegen',

    'ui__server/spam-filter/properties__description' => 'Spamfilter voor de server als geheel instellen.',

    'ui__server/spam-filter/properties__short-title' => 'Instellingen',
    'ui__server/spam-filter/properties__title' => 'Spamfilterinstellingen',

    'ui__server/spam-filter/toggle_disable__description' => 'Uitschakelen van het detecteren van spam voor het gehele systeem.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Uitschakelen',
    'ui__server/spam-filter/toggle_disable__title' => 'Spam niet langer detecteren',
    'ui__server/spam-filter/toggle_enable__description' => 'Detecteren van spam voor de server als geheel inschakelen.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Activeren',
    'ui__server/spam-filter/toggle_enable__title' => 'Detecteren van spam inschakelen',
    'ui__server/spam-filter/toggle_unknown__description' => 'Het detecteren van spam in- of uitschakelen voor de server als geheel.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'In- of uitschakelen',
    'ui__server/spam-filter/toggle_unknown__title' => 'Het detecteren van spam in- of uitschakelen',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Spamfilter in- of uitschakelen',

    'ui__server/spam-filter/white-list__description' => 'Witte lijst instellen voor het spamfilter van de server als geheel.',
    'ui__server/spam-filter/white-list__short-title' => 'Witte lijst',
    'ui__server/spam-filter/white-list__title' => 'Witte lijst van het spamfilter voor het systeem als geheel',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Alleen de %1 eerste unieke e-mailadressen zullen worden toegevoegd.',
    'ui__server/spam-filter/white-list/address__description' => 'Witte lijst adres van het spamfilter.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Er staan geen adressen in de lijst.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Het geüploade bestand is leeg.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'De volgende e-mailadressen zijn ongeldig: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Er staan geen adressen in de witte lijst van het spamfilter voor de server als geheel.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adres',
    'ui__server/spam-filter/white-list/address__title' => 'Witte lijst-adres %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Adressen aan de witte lijst toevoegen.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Adressen toevoegen',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Adressen aan de witte lijst toevoegen',

    'ui__server/spam-filter/white-list/address/delete__description' => '%1 adres van de witte lijst voor de server als geheel verwijderen.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Verwijderen',
    'ui__server/spam-filter/white-list/address/delete__title' => '%1 adres van de witte lijst voor de server als geheel verwijderen',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Adressen verwijderen van de witte lijst voor de server als geheel.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Verwijderen',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Adressen verwijderen van de witte lijst voor de server als geheel',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Verwijdering van adressen uit de witte lijst van het spamfilter van de server als geheel',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Selecteer de spamfilteradressen die u wilt verwijderen en klik Volgende >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Bevestig de verwijdering van de spamfilteradressen door het selectievakje te selecteren en klik Voltooien voor een volledige verwijdering en om de wizard af te sluiten.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Adres verwijderen van de witte lijst voor de server als geheel.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Verwijderen',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Adres verwijderen van de witte lijst voor de server als geheel',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Verwijdering van adressen uit de witte lijst van het spamfilter van de server als geheel',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Selecteer het spamfilteradres dat u wilt verwijderen en klik Volgende >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Bevestig de verwijdering van het spamfilteradres door het selectievakje te selecteren en klik Voltooien voor een volledige verwijdering en om de wizard af te sluiten.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Alleen de %1 eerste unieke e-mailadressen zullen worden toegevoegd.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Er staan geen adressen in de lijst.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Kan het bestand niet uploaden. De maximale omvang van een bestand om te uploaden is %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'De volgende e-mailadressen zijn ongeldig: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Adressen aan de witte lijst toevoegen.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Adressen toevoegen',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Adressen aan de witte lijst toevoegen',

    'ui__server/mail/statistics#apply__description' => "Filter toepassen",
    'ui__server/mail/statistics#apply__title' => "Toepassen",
    'ui__server/mail/statistics#custom_from__title' => "van",
    'ui__server/mail/statistics#custom_to__title' => "tot",
    'ui__server/mail/statistics#period_all__title' => "Alle",
    'ui__server/mail/statistics#period_custom__title' => "Aangepast",
    'ui__server/mail/statistics#period_month__title' => "Huidige maand",
    'ui__server/mail/statistics#period_prev_month__title' => "Vorige maand",
    'ui__server/mail/statistics#period_prev_week__title' => "Vorige week",
    'ui__server/mail/statistics#period_today__title' => "Vandaag",
    'ui__server/mail/statistics#period_week__title' => "Huidige week",
    'ui__server/mail/statistics#period_yesterday__title' => "Gisteren",
    'ui__server/mail/statistics#show_for_period__title' => "Toon voor tijdvak tonen",
    'ui__server/mail/statistics#tools_legend__title' => "Hulpprogramma's",
    'ui__server/mail/statistics__description' => "Spam- en virusstatistieken bekijken",

    'ui__server/mail/statistics__short-title' => "Statistieken",
    'ui__server/mail/statistics__title' => "Mail-instellingen",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Spamstatistieken",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Hulpprogramma's",
    'ui__server/mail/statistics/spam__description' => "Spamstatistieken bekijken",

    'ui__server/mail/statistics/spam__short-title' => "Spamstatistieken",
    'ui__server/mail/statistics/spam__title' => "Spamstatistieken",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Mailnaam",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% van alle",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Sorteren op mailaccount",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Sorteren op % van alle",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Sorteren op ontvangen spam",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "Mailaccounts",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Ontvangen spam",
    'ui__server/mail/statistics/spam/recipients__description' => "Ontvangers",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Ontvangers",
    'ui__server/mail/statistics/spam/recipients__title' => "Ontvangers",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Schoon",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Besmet",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% van alle",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Aantal",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Afgeschermd",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Niet gecontroleerd",
    'ui__server/mail/statistics/spam/summary__description' => "Samenvatting",

    'ui__server/mail/statistics/spam/summary__short-title' => "Samenvatting",
    'ui__server/mail/statistics/spam/summary__title' => "Samenvatting",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Virusstatistieken",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Hulpprogramma's",
    'ui__server/mail/statistics/virus__description' => "Virusstatistieken bekijken",

    'ui__server/mail/statistics/virus__short-title' => "Virusstatistieken",
    'ui__server/mail/statistics/virus__title' => "Virusstatistieken",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Mailaccount",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% van alle",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Sorteren op mailnaam",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Sorteren op % van alle",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Sorteren op ontvangen virussen",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Mailaccounts",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Ontvangen virussen",
    'ui__server/mail/statistics/virus/recipients__description' => "Ontvangers",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Ontvangers",
    'ui__server/mail/statistics/virus/recipients__title' => "Ontvangers",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Schoon",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Besmet",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% van alle",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Aantal",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Afgeschermd",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Niet gecontroleerd",
    'ui__server/mail/statistics/virus/summary__description' => "Samenvatting",

    'ui__server/mail/statistics/virus/summary__short-title' => "Samenvatting",
    'ui__server/mail/statistics/virus/summary__title' => "Samenvatting",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Naam",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% van alle",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Sorteren op naam",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Sorteren op % van alle",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Sorteren op besmette objecten",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Virussen",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Besmette bestanden",
    'ui__server/mail/statistics/virus/viruses__description' => "Virussen",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Virussen",
    'ui__server/mail/statistics/virus/viruses__title' => "Virussen",

    'ui__support#param_company__title' => "Bedrijf",
    'ui__support#param_email__title' => "E-mail",
    'ui__support#param_firstname__title' => "Voornaam",
    'ui__support#param_keynumber__title' => "Sleutelnummer van product",
    'ui__support#param_operatingsystem__title' => "Besturingssysteem",
    'ui__support#param_phone__title' => "Telefoon",
    'ui__support#param_psabuild__title' => "Plesk build",
    'ui__support#param_psainsttype__title' => "Type installatie van Plesk",
    'ui__support#param_psaversion__title' => "Plesk-versie",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Hulpprogramma's",

    'ui__reseller/traffic-history_unknown__short-title' => "Dataverkeer bekijken per reseller",
    'ui__reseller/traffic-history_unknown__title' => "Dataverkeer bekijken per reseller",
    'ui__reseller/traffic-history_unknown__description' => "Dataverkeer bekijken per reselleraccount.",
    'ui__reseller#list__title' => "Resellers",
    'accounts_list__name__filter_title' => "Naam",
    'accounts_list__resource__filter_title' => "Verbruik",
    'resellers_list__filter_resource_usage_any' => "Alle",
    'resellers_list__filter_resource_usage_overuse' => "Beperkingen overschreden",
    'resellers_list__filter_resource_usage_normal' => "Binnen de beperkingen",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Alle",
    'resellers_list__filter_status_blocked' => "Opgeschort",
    'resellers_list__filter_status_active' => "Actief",
    'resellers_list__filter_clients__filter_title' => "Tonen",
    'resellers_list__filter_clients_on' => "Resellers met hun cliënten",
    'resellers_list__filter_clients_off' => "Alleen resellers",
    '__disk_usage' => "Verbruikte schijfruimte",
    'ui__reseller/traffic_unknown__short-title' => "Dataverkeer bekijken per reseller",
    'ui__reseller/traffic_unknown__title' => "Dataverkeer bekijken per reseller",
    'ui__reseller/traffic#list__title' => "Dataverkeer van resellers",
    'ui__reseller/traffic_unknown__description' => "Verslagen over verbruikt dataverkeer bekijken.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Dataverkeer van resellers",

    '__reseller_name' => "Naam van reseller",
    '__reseller' => "Resellers",
    'resellertrafficlist_header' => "Dataverkeer bekijken per reseller",
    '__reseller_personal' => "Dataverkeer verbruikt door domeinen van reseller",
    'ui__reseller/traffic-history__short-title' => "Dataverkeer van resellers",
    'ui__reseller/traffic-history__title' => "Dataverkeer van resellers",
    'ui__reseller/traffic-history__description' => "Verslagen over verbruikt dataverkeer bekijken.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Overselling toestaan",
    'limits__reseller_oversell_description' => "Meerverkoop stelt de reseller in staat om meer middelen te verkopen dan in werkelijkheid aan hem of haar zijn toegewezen. Als meerverkoop wordt toegestaan, dan valt de reseller onder een regime van daadwerkelijk gebruikte middelen in plaats van onder een regime van aanvankelijk toegewezen middelen",
    'limits__overuse_block_text' => "Beleid bij meerverbruik",
    'limits__overuse_block_true_text' => "Meerverbruik is niet toegestaan",
    'limits__reseller_overuse_block_true_description' => "Blokkeer het gebruik van meer middelen dan zijn toegewezen. Daadwerkelijk gebruik van middelen kan de aanvankelijk toegewezen middelen niet overschrijden",
    'limits__overuse_block_false_text' => "Meerverbruik is toegestaan",
    'limits__reseller_overuse_block_false_description' => "Het gebruik van meer middelen dan zijn toegestaan niet blokkeren, zodat de reseller meer middelen kan gebruiken dan aanvankelijk zijn toegewezen. Daadwerkelijk gebruik van middelen kan de oorspronkelijke toewijzing van middelen overschrijden",
    'limits__reseller_overuse_notify_text' => "De reseller op de hoogte stellen bij het bereiken van beperkingen",
    'reseller_perm__manage_sh_access_disabled' => "Reseller kan shell-toegang niet toekennen of weigeren",
    'reseller_perm__manage_sh_access_chrooted' => "Reseller kan alleen toegang tot een chrooted omgeving toestaan",
    'reseller_perm__manage_sh_access_any' => "Reseller kan toegang tot elk type shell toestaan",
    'template__reseller_num_excl_ips' => "Exclusieve IP-adressen aan de reseller toewijzen",

    // Reseller's Home page
    'client_chown__no_clients_selected' => 'Selecteer de cliëntaccounts die u aan een nieuwe houder wilt toewijzen.',
    'ui__reseller#tools2__title' => "Account",
    'ui__reseller#info__title' => "Info",
    'ui__reseller#clientsTab__title' => "Cliënten",
    'ui__reseller#domainsTab__title' => "Domeinen",
    'ui__reseller__title' => "Reselleraccount van %1 beheren",
    'domains__reseller_info' => "%1 cliënten, %2 domeinen, %3 schijfruimte gebruikt, %4 aan gegevens overgedragen.",
    'domains__reseller_info_hiding_traffic' => "%1 cliënten, %2 domeinen, %3 schijfruimte gebruikt.",
    'ui__reseller__description' => "Account van reseller beheren.",

    'ui__reseller/limits_unknown__wizard-title' => 'Beperkingen voor een reseller bekijken',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Selecteer de juiste reseller.',
    'ui__reseller/limits_unknown__wizard__2' => 'Klik voltooien om de wijzigen toe te passen.',

    'ui__client/report_reseller__short-title' => "Verslag",
    'ui__client/report_reseller__title' => "Accountverslag bekijken",
    'ui__client/report_reseller__description' => "Verslag van reselleraccount bekijken.",
    'ui__client/ip-pool_reseller__short-title' => "IP-voorziening",
    'ui__client/ip-pool_reseller__description' => "IP-adressen en SSL/TLS-certificaten toewijzen aan en terugnemen uit het reselleraccount.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Geef de accountinstellingen op en klik Voltooien.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Rechten voor een reseller bekijken',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Selecteer de reseller waarvan u de rechten wilt bekijken of wijzigen.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Als u klaar bent met het aanpassen van de rechten van de reseller klikt u op Voltooien om de wijzigingen op te slaan en de wizard af te sluiten.',

    // Customers > create customer account

    '__resellers_list' => 'Resellers',
    'picker_reseller__title' => 'Selecteer de reseller',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Hulpprogramma's",
    'ui__client#tools2__title' => "Account",
    'ui__client#info__title' => "Info",
    'ui__client#clientslist__title' => "Cliënten",
    'ui__client#domainslist__title' => "Domeinen",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Alle webtoepassingen worden nu op categorie gesorteerd, waardoor het makkelijker wordt de juiste toepassing te kiezen die u wilt installeren.",
    'feature__domainkeys__reseller' => "U kunt het DKIM-mechanisme voor verificatie van e-mailafzenders gebruiken om de hoeveelheid spam en phishing-mails terug te dringen.",

    '__reseller_form' => "Reseller-formulier",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Selecteer het cliëntaccount waarvan u de instellingen wilt wijzigen.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Om de beperkingen van het gebruik van middelen aan te passen, klikt u op Beperkingen.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Om de rechten te wijzigen voor de bewerkingen die de cliënt in Plesk kan uitvoeren, klikt u op Rechten.",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "Om een domein voor uw eigen account aan te maken klikt u op Domein aanmaken. Om een domein voor een van uw cliënten aan te maken, klikt u op de naam van de juiste cliënt en daarna op Domein aanmaken.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Dit sjabloon aan andere gebruikers beschikbaar stellen",
    'template__shared_description' => "Selecteer deze optie als u wilt dat uw gebruikers dit sjabloon kunnen gebruiken.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Hulpprogramma\'s',

    'ui__client/traffic-history_unknown__short-title' => 'Dataverkeer bekijken per cliënt',
    'ui__client/traffic-history_unknown__title' => 'Dataverkeer van cliënten',
    'ui__client/traffic-history_unknown__description' => 'Verslag bekijken over verbruikt dataverkeer voor alle cliënten',
    'ui__client/traffic-history__short-title' => 'Dataverkeer van cliënten',
    'ui__client/traffic-history__title' => 'Dataverkeer bekijken per cliënt',
    'ui__client/traffic-history__description' => 'Verslag bekijken over verbruikt dataverkeer voor alle cliënten',

    'ui__client/traffic#list__title' => 'Dataverkeer van cliënten',
    'ui__reseller/client/traffic#list__title' => 'Dataverkeer van cliënten',

    'clients_list__filter_type__filter_title' => 'Tonen',
    'clients_list__filter_type_any' => 'Cliënten en resellers',
    'clients_list__filter_type_clients' => 'Alleen cliënten',
    'clients_list__filter_type_resellers' => 'Alleen resellers',
    'ui__client/domain_unknown-new__short-title' => "Domein aanmaken",

    // Customers > View traffic by customers
    '__personal' => "Dataverkeer verbruikt door domeinen van reseller",
    'PersonalTrafficList_header_of_client__' => "Verslag over door uw account verbruikt dataverkeer bekijken",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Domeinbeheerder kan shell-toegang niet toekennen of weigeren",
    'domain_perm__manage_sh_access_chrooted' => "Domeinbeheerder kan alleen toegang verlenen tot een chrooted omgeving",
    'domain_perm__manage_sh_access_any' => "Domeinbeheerder kan toegang verlenen tot alle shell-typen",

    // APS Catalog
    'bt_add_to_vault' => "Toevoegen aan bibliotheek",
    'bt_hide_updates' => "Beschikbare updates verbergen",
    'bt_show_updates' => "Beschikbare updates tonen",

    '__site_apps__applications' => "Toepassingen",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Toepassingen geselecteerd om aan de bibliotheek te worden toegevoegd",
    'site_apps__application_selected' => "Geselecteerd",
    'site_apps__currently_in_vault' => "Andere versies die reeds in de bibliotheek aanwezig zijn:",
    'site_apps__new_versions' => "Nieuwe versies:",
    'site_apps__patches' => "Patches:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Aantal toepassingen dat is ingeroosterd om aan de bibliotheek te worden toegevoegd: %1",
    'site_apps__applications_downloading_now' => "De volgende toepassingen worden nu gedownload: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Reeds in de bibliotheek",

    // Server > Action Log
    'bt_skin_edit' => "Omschrijving van thema bewerken",
    'domains__you_want_change_the_status_of_the_reseller??' => "Weet u zeker dat u de status van het reselleraccount wilt wijzigen?",
    'limits__oversell_legend' => "Meerverkoop",
    'limitsManager__limit_available_error' => "Kan de vereisten hoeveelheid middelen niet toewijzen (%%quantity%% %%limitName%%\"). Slechts %%available%% %%limitName%% beschikbaar.",
    'limitsManager__limit_reserved_error' => "Kan de vereiste beperking van het gebruik van middelen niet instellen (%%quantity%% %%limitName%%) omdat de nieuwe waarde lager ligt dan de hoeveelheid middelen die voor uw klanten zijn gereserveerd of waarvan u zelf gebruikt maakt (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Kan de vereiste beperking van het gebruik van middelen niet instellen (%%quantity%% %%limitName%%) omdat de nieuwe waarde lager ligt dan middelen die momenteel al door uw account en sites worden gebruikt (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Bandbreedteverbruik door diensten",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Verslag over verbruikt dataverkeer bekijken",
    'ui__client/domain/traffic_unknown-reseller__title' => "Verslag over verbruikt dataverkeer bekijken",

    'ui__client/domain_new__short-title' => "Domein aanmaken",

    'ui__client_reseller__description' => "Reselleraccount %1 beheren",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Reselleraccount beheren",

    '__owner_name' => "Naam van houder",
    'domains_list__resource__filter_title' => "Verbruik",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS-app-catalogus",
    'site_apps__applications_have_updates' => "Er zijn updates beschikbaar van de volgende toepassingen:\n%1\nOm de updates te bekijken zorgt u ervoor dat het zoekveld beschikbaar is, selecteert u het selectievakje <b>Alleen updates weergeven</b> en zoekt u naar de juiste toepassingen.",
    'site_apps__progress_adding_to_vault' => "Aan de bibliotheek toevoegen:",
    'site_apps__progress_done_message' => "Voortgang:",
    'site_apps__progress_applications_left' => "Nog %1 van %2 toepassingen",
    'site_apps__download_item_long_task_title' => "APS-toepassing (%1) downloaden",
    'site_apps__download_transaction_long_task_title' => "APS-toepassingen downloaden uit APS-catalogus",
    'site_apps__last_check_for_updates' => "laatste controle op updates: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Het toevoegen van alle ingeroosterde toepassingen aan de Programmabibliotheek is geslaagd",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 toepassingen zijn met succes toegevoegd aan de Programmabibliotheek.",
    'site_apps__no_search_results' => 'Geen toepassingen gevonden. Probeer een andere zoekopdracht of blader door de toepassingen gesorteerd op categorie.',
    'site_apps__search_results_title' => 'Zoekresultaten',
    '__site_apps__search_by_application' => 'Naam van toepassing',
    '__site_apps__search_by_vendor' => 'Leverancier',
    '__site_apps__search_by_vendor__all' => 'Alle leveranciers',
    '__site_apps__search_by_packager' => 'Pakket maken',
    '__site_apps__search_by_certification_level' => 'Niveau van certificering',
    '__site_apps__search_by_cert__any' => 'Alle',
    '__site_apps__search_by_cert__silver_and_higher' => 'Zilver en hoger',
    '__site_apps__search_by_cert__gold_and_higher' => 'Goud en hoger',
    '__retry' => 'Nieuwe Poging',
    'site_apps__application_packager_site' => 'Pakket maken',
    'site_apps__add_to_pool_message' => "Toepassingen gemarkeerd als \"beschikbaar voor iedereen\" worden automatisch verspreid naar alle resellers en cliënten met een onbeperkt aantal installaties. Toepassingen met beperkingen worden handmatig en op individuele basis verspreid onder resellers en cliënten met een expliciet aangegeven aantal beschikbare installaties.",
    'site_apps__make_available_for_all' => "Geselecteerde toepassingen aan alle gebruikers beschikbaar stellen",

    'site_apps__broadcast_app_text' => "Toepassingen gemarkeerd als \"beschikbaar voor iedereen\" worden automatisch verspreid naar alle resellers en cliënten met een onbeperkt aantal installaties. Toepassingen met beperkingen worden handmatig en op individuele basis verspreid onder resellers en cliënten met een expliciet aangegeven aantal beschikbare installaties.",
    'site_apps__broadcast_app_name' => 'Stel toepassing beschikbaar aan alle gebruikers',

    // User Application Pool per application
    'site_apps__available_clients' => 'Beschikbare gebruikers',
    'site_apps__no_more_clients_to_add_to_pool' => 'Er zijn geen verdere gebruikeraccounts waaraan u deze toepassing kunt aanbieden',

    // Installed application instances
    'site_apps__installations' => 'Installaties',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Domeinnaam en IP-adres",
    '__assign_ip_address' => "IP-adres toewijzen",
    '__switch_on_service' => "Dienst inschakelen",
    '__hosting_configuration' => "Hostinginstellingen",
    '__vrt_hst' => "Websitehosting",
    '__vrt_hst_hint' => "Een website op deze server hosten.",
    '__fwd' => "Doorsturen",
    '__web_hosting_settings' => "Hostinginstellingen",
    '__fwd_hint' => "Bezoekers doorschakelen naar een andere website.",
    '__none_hint' => "Op dit moment geen website hosten.",
    '__login_hint' => "Deze gebruikersnaam wordt gebruikt voor toegang tot uw website via FTP",
    '__password_hint' => "Dit wachtwoord wordt gebruikt voor toegang tot uw website via FTP.",
    '__advanced_hosting_setup' => "Geavanceerde instellingen voor websitehosting configureren",
    '__domain_creation_successful' => "Het domein is aangemaakt.",
    'bt_hosting_settings' => "Hostinginstellingen",
    '__change_hosting_type' => "Type hosting voor domein %1 wijzigen",
    '__hosting_type_change_warning' => "Als u het type hosting wijzigt in doorschakelen, dan zullen alle bestanden en mappen die bij uw site horen van de server worden verwijderd. Zorg ervoor dat een lokale kopie van uw site hebt opgeslagen.",
    '__current_hosting_type' => "Huidig type hosting",
    '__new_hosting_type' => "Nieuw type hosting",
    '__fwd_settings' => "Doorschakelinstellingen",
    '__fwd_settings_legend' => "Doorschakelinstellingen",
    '__fwd_destination_url' => "URL van bestemming",
    '__fwd_type' => "Type doorschakeling",
    '__fwd_type_standart' => "Standaard doorschakelen",
    '__fwd_type_standart_hint' => "Bezoekers omleiden naar een andere website waarbij zij het adres van bestemming kunnen zien, zodat ze weten dat ze zijn doorgeschakeld.",
    '__fwd_type_frame' => "Doorschakelen via frame",
    '__fwd_type_frame_hint' => "Bezoekers doorschakelen naar een andere website, maar daarbij het adres van bestemming niet weergeven zodat de bezoekers niets van de doorschakeling weten.",
    '__hosting_type_template_warning' => "Het type hosting dat u hebt geselecteerd wijkt af van het type dat in het sjabloon is opgegeven. Als u doorgaat, dan zullen de instellingen voor webhosting in het geselecteerde sjabloon worden genegeerd. Weet u zeker dat u het geselecteerde type hosting wilt instellen?",

    'ui__client/domain/properties#vrt_hst__title' => "Websitehosting",
    'ui__client/domain/properties#vrt_hst__description' => "Een website op deze server hosten",
    'ui__client/domain/properties#fwd__title' => "Doorsturen",
    'ui__client/domain/properties#fwd__description' => "Bezoekers doorschakelen naar een andere website",
    'ui__client/domain/properties#none__title' => "Geen hosting",
    'ui__client/domain/properties#none__description' => "Op dit moment geen website hosten",

    '__no_resellers_selected' => "U moet ten minste één reselleraccount te selecteren.",

    'ui__client/logo_unknown__wizard-title' => 'Een logo instellen',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Selecteer de cliënt waarvan u de logo-eigenschappen wilt veranderen.',
    'ui__client/logo_unknown__wizard__2' => 'Klik Voltooien om de wijzigingen toe te passen.',
    'ui__client/logo_unknown__wizard__2_self' => 'Klik Voltooien om de wijzigingen toe te passen.',

    'ui__client/ipaddress/properties_new__short-title' => "IP-adres toevoegen",
    'ui__client/ipaddress/properties_new__title' => 'IP-adres toevoegen',
    'ui__client/ipaddress/properties_new__description' => "IP-adres toevoegen",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "IP-adres toevoegen",
    'ui__client/ipaddress/properties_unknown-new__title' => "IP-adres toevoegen",
    'ui__client/ipaddress/properties_unknown-new__description' => "IP-adres toevoegen",
    'ui__client/ipaddress/delete_multi__short-title' => "IP-adres verwijderen",
    'ui__client/ipaddress/delete_multi__description' => "IP-adressen verwijderen.",
    'ippool_Manager__no_available_ips' => "Er zijn geen beschikbare IP-adressen in de IP-voorziening.",
    'ippool_Manager__ip_shared' => "gedeeld",
    'ippool_Manager__ip_exclusive' => "exclusief",
    'ui__client/ipaddress/properties__title' => "IP-adressen beheren",
    'ui__client/ipaddress/properties__description' => "Eigenschappen IP-adres bekijken of wijzigen.",
    'ui__client/ipaddress_unknown-new__title' => "IP-adres toevoegen",
    'ui__client/ipaddress_unknown-new__short-title' => "IP-adres toevoegen",
    'ui__client/ipaddress_unknown-new__description' => "IP-adressen toevoegen.",

    'ui__mass-mail#to_resellers_text__title' => "Resellers",
    'ui__mass-mail#to_domainusers_text__title' => "Domeinbeheerders",
    'ui__mass-email#tools_legend__title' => "Hulpprogramma's",
    'ui__mass-email#list_legend__title' => 'Sjablonen voor e-mailberichten voor een grote groep',
    'ui__mass-email#template_legend__title' => "Sjabloon",
    'ui__mass-email#from_email_text__title' => "Van",
    'ui__mass-email#to_text__title' => 'Aan',
    'ui__mass-email#to_resellers_text__title' => "Resellers",
    'ui__mass-email#to_clients_text__title' => "Cliënten",
    'ui__mass-email#to_domainusers_text__title' => "Domeinbeheerders",
    'ui__mass-email#to_admin_text__title' => "Plesk-beheerder",
    'ui__mass-email#option_mode_all__title' => "Alle",
    'ui__mass-email#option_mode_select__title' => "Alleen selectie",
    'ui__mass-email#option_mode_except__title' => "Alle behalve selectie",
    'ui__mass-email#option_select_template__title' => '--Selecteer een sjabloon--',
    'ui__mass-email#subject_text__title' => "Onderwerp",
    'ui__mass-email#body_text__title' => "Tekst van bericht",
    'ui__mass-email#save_as_legend__title' => "Opslaan als sjabloon",
    'ui__mass-email#save_as_text__title' => "Bewaar ingevoerd bericht als een nieuw sjabloon met de naam",
    'ui__reseller/preferences_unknown__wizard-title' => "Accountinstellingen wijzigen",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Selecteer de reseller waarvan u de accountinstellingen wilt wijzigen en klik Volgende.",
    'ui__reseller/preferences_unknown__wizard__2' => "Geef de accountinstellingen op en klik OK.",
    'ippoolManager__ip_shared' => "gedeeld",
    'ippoolManager__ip_exclusive' => "exclusief",

    '__users_list' => "Gebruikers",
    '__users' => "Gebruikers",
    '__user_name' => "Naam van gebruiker",

    'clientOwnerChanger__wrong_owner_type' => "U kunt de geselecteerde cliëntaccounts alleen aan een reselleraccount overdragen.",
    'clientOwnerChanger__wrong_client_type' => 'Geselecteerd gebruikeraccount is een reselleraccount. Aan reselleraccounts kan geen nieuwe houder worden toegewezen aangezien deze onder de serverbeheerder vallen.',
    'ui__client/chowner_multi__description' => "Gebruikeraccounts aan andere gebruiker overdragen.",
    'client_chown__clients_list_legend' => "Gebruikeraccounts",
    'client_chown__client_name' => "Naam van gebruiker",
    'client_chown__old_owner' => "Vorige houder",
    'client_chown__limits_legend' => "Middelen",
    'client_chown__limit_name' => "Naam van middel",
    'client_chown__limit_value' => "Toegewezen middelen",
    'client_chown__usage_before' => "Voorafgaand aan overdracht",
    'client_chown_usage_after' => "Na overdracht",
    'limit__name_max_dom_aliases' => "domeinaliassen",
    'limit__name_max_subftp_users' => "extra FTP-accounts",
    'limit__name_max_mssql_db' => "Microsoft SQL Server-databases",
    'limit__name_max_iis_app_pools' => "IIS Groepen van toepassingen",
    'limit__name_max_odbc' => "ODBC-koppelingen",
    'total_mboxes_quota_unsupported' => 'niet ondersteund door de mailserver',
    'limit_soft__disk_space' => 'Melding geven bij bereiken van schijfruimte',
    'limit_soft__max_traffic' => 'Melding geven bij bereiken van dataverkeer',
    'dsr__of_reseller_title' => "Verbruik van middelen per domein",
    'client_chown__new_owner' => 'Nieuwe houder',
    'ui__reseller/to-client__has_clients_warning' => 'Een aantal van de geselecteerde reselleraccounts kan niet naar cliëntaccounts worden omgezet omdat zij cliënten bevatten die van hun diensten gebruik maken. Verwijder eerst de cliëntaccounts van deze reseller of verplaats deze naar een andere reseller.',
    'limitsManager__commit_failed' => "Kan de beperkingen niet wijzigen.",
    'limitsManager__date_in_past' => "Onjuiste verloopdatum %1.",
    'limitsManager__limit_not_supported' => "Beperkingen voor %1 kunnen niet worden ingesteld.",
    'limitsManager__limit_oversell_inconsistency' => "Kan de opgegeven hoeveelheid middelen niet toewijzen als meerverkoop is uitgeschakeld.",
    'limitsManager__limit_overuse_inconsistency' => "Verbruik van middelen overschrijdt de vastgestelde beperkingen.",
    'limitsManager__no_resource_available' => "Er zijn geen beschikbare middelen van dit type meer (%%limitName%%). Aangevraagd: %%quantity%%; Beschikbaar: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Er zijn geen middelen van dit type (%%limitName%%) beschikbaar bij uw provider. Aangevraagd: %%quantity%%; Beschikbaar: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "De verloopdatum moet gelijk zijn aan of eerder dan %1.",
    'limitsManager__invalid_disk_space_limit' => "De hoeveelheid schijfruimte moet gelijk zijn aan of minder dan %1.",
    'limitsManager__invalid_max_traffic_limit' => "De hoeveelheid dataverkeer moet gelijk zijn aan of minder dan %1.",
    'ippoolManager__ip_has_suballocations' => "Kan het type IP-adres niet wijzigen van een IP-adres dat al aan een gebruiker is toegewezen. IP-adres %%ip%% is reeds toegewezen aan een of meer gebruiker als %%reserved%% IP-adres.",
    'ippoolManager__ip_is_already_in_pool' => "Dit IP-adres is al aan de gebruiker toegewezen.",
    'ippoolManager__ip_is_not_in_pool' => "Er bevindt zich geen IP-adres %%ip%% in de voorziening.",
    'ippoolManager__can_not_allocate_ip' => "Het IP-adres %%ip%% is alleen beschikbaar als %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Het IP-adres %%ip%% kan niet als exclusief worden toegewezen.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Het IP-adres %%ip%% wordt al gebruikt voor hosting.",
    'ippoolManager__active_anon_ftp_on_ip' => "Anonieme FTP-toegang is reeds ingeschakeld voor het IP-adres %%ip%%",
    'ippoolManager__no_vacant_ips' => "Er zijn geen beschikbare IP-adressen.",
    'ippoolManager__no_available_ips' => "Er zijn geen beschikbare IP-adressen.",
    'templates__dublicate_name' => "Er bestaat al een sjabloon met deze naam. Kies een andere naam voor dit sjabloon.",
    'cl_perm__client_limits_exceeded' => "De opgegeven waarden voor de beperkingen overschrijden de waarden die zijn toegestaan binnen uw hostingpakket, of deze waarden staan minder middelen toe dan momenteel door uw sites worden gebruikt.",
    'cl_perm__reseller_limits_exceeded' => "De opgegeven waarden voor de beperkingen overschrijden de waarden die zijn toegestaan binnen uw hostingpakket, of deze waarden staan minder middelen toe dan momenteel door gebruikeraccounts en sites worden gebruikt.",

    'site_apps__preferences_show_all_versions_title' => "De volledige lijst met versies voor elke toepassing die uit de catalogus wordt opgehaald tonen",
    'site_apps__preferences_show_all_versions_hint' => "Als deze optie is geselecteerd kan het enige tijd duren om alle versies van alle toepassingen op te halen, steeds wanneer u de catalogus opent. Als deze optie niet is geselecteerd worden alleen de meest recente versies getoond.",
    '__select_user_template' => "Gebruikeraccount aanmaken op basis van een sjabloon",
    'ip_already_added_to_all_clients' => "Dit IP-adres is al aan alle gebruikers toegewezen.",
    'ui__server/ip-address/client/delete#legend__description' => "De volgende IP-adressen zullen worden verwijderd uit het systeem en uit de IP-voorziening van gebruikers:",

    'dns__serial_format_timestamp' => "SOA-serienummerformaat UNIX-tijdstempel",
    'dns__serial_format_yyyymmddnn' => "SOA-serienummerformaat aanbevolen door IEFT en RIPE",
    'site_apps__cancelled_apps' => "U hebt de toevoeging van de volgende toepassingen geannuleerd: %2",

    'sb_url_is_not_resolved' => 'URL kan niet worden herleid: controleer uw DNS-instellingen. URL %1 moet worden herleid naar een IP-adres van de server waarop Presence Builder is geïnstalleerd.',

    'ip_addr__is_last_on_interface' => 'Kan het IP-adres %%ip%% niet verwijderen omdat het gaat om het laatste IP-adres op een netwerkkaart.',
    'ip_addr__used_for_current_session' => 'Kan het IP-adres %%ip%% niet verwijderen omdat het door een actieve sessie wordt gebruikt.',
    'ip_addr__used_for_hosting' => 'Kan het IP-adres %%ip%% niet verwijderen omdat deze wordt gebruikt voor het hosten van een website.',
    'ip_addr__is_main' => 'Kan het IP-adres %%ip%% niet verwijderen omdat het om het primaire IP-adres op een netwerkkaart gaat.',
    'ip_addr__ip_used_by_message_submission' => 'Kan het IP-adres %%ip%% niet verwijderen omdat het wordt gebruikt voor het versturen van mailberichten.',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domeinen van cliënten',
    'excl_ip_num' => 'Exclusief IP-adres',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder is niet geïnstalleerd.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Het recht op meerverkoop kan de gebruiker niet worden ontnomen, aangezien hij of zij inmiddels meer middelen heeft toegewezen dan beschikbaar zijn, waardoor hij of zij zich nu in de meerverkoop-modus bevindt.',
    'limitsManager__invalid_limit_value' => 'Onjuiste waarde %%value%% opgegeven voor de beperking %%limit_name%%',
    'ip_alias__type' => "IP-adres verspreid als",
    'ip_alias__in_type' => 'IP-adres toegewezen als',
    'ui__client/ipaddress/delete_multi__title' => 'IP-adressen verwijderen',
    'ui__client/ipaddress/delete#legend__short-title' => 'Onderdelen die verwijderd zullen worden',
    'ui__client/ipaddress/delete#legend__description' => "De volgende IP-adressen zullen worden verwijderd uit de IP-voorziening van de gebruiker:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'Onderdelen die niet verwijderd kunnen worden',
    'ui__client/ipaddress/delete#nlegend__description' => 'De volgende IP-adressen kunnen niet worden verwijderd:',
    'ui__server/ip-address/delete#legend__description' => 'De volgende IP-adressen zullen worden verwijderd uit de IP-voorziening van de server:',
    'confirmationForm_default_agreement_text' => 'De bewerking bevestigen',
    'confirmationForm_default_confirm_message' => 'Bevestig de bewerking.',
    'limit__max_mn' => 'Maximaal aantal mailaccounts',

    'limits__client_overuse_description' => 'Het overusebeleid bepaalt wat Plesk moet doen als het gebruik van middelen de oorspronkelijk toegewezen middelen overschrijdt.',
    'limits__client_overuse_block_true_description' => 'Blokkeer het gebruik van meer middelen dan zijn toegewezen. Daadwerkelijk gebruik van middelen kan de aanvankelijk toegewezen middelen niet overschrijden',
    'limits__client_overuse_block_false_description' => 'Het gebruik van meer middelen dan zijn toegestaan niet blokkeren, zodat de cliënt meer middelen kan gebruiken dan aanvankelijk zijn toegewezen. Daadwerkelijk gebruik van middelen kan de oorspronkelijke toewijzing van middelen overschrijden',
    'limits__client_overuse_notify_text' => 'Stel de cliënt op de hoogte bij het bereiken van beperkingen',

    'limits__domain_overuse_description' => 'Het overusebeleid bepaalt wat Plesk moet doen als het gebruik van middelen de oorspronkelijk toegewezen middelen overschrijdt.',
    'limits__domain_overuse_block_true_description' => 'Het overusebeleid bepaalt wat Plesk moet doen als er meer middelen worden gebruikt dan zijn toegewezen.',
    'limits__domain_overuse_block_false_description' => 'Het gebruik van meer middelen dan zijn toegestaan niet blokkeren, zodat het domein meer middelen kan gebruiken dan aanvankelijk zijn toegewezen. Daadwerkelijk gebruik van middelen kan de oorspronkelijke toewijzing van middelen overschrijden',
    'limits__domain_overuse_notify_text' => 'De domeinhouder op de hoogte stellen bij het bereiken van beperkingen',


    'cancel_remove' => 'Terug naar de vorige pagina zonder wijzigingen op te slaan.',
    'php_not_installed' => 'PHP is niet geïnstalleerd',

    'dns__dns_rr_delete' => 'Onderdelen die verwijderd zullen worden',
    'dns__delete_rr' => 'De volgende DNS-records zullen uit de DNS-zone worden verwijderd:',
    'dns__dns_rr_delete_non_removable' => 'Onderdelen die niet verwijderd kunnen worden',
    'dns__non_delete_rr' => 'De volgende DNS-records kunnen niet worden verwijderd:',
    'dns__dns_rr_delete_confirm_message' => 'Het verwijderen van DNS-records bevestigen',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Formaat van webtoepassing is onbekend: webtoepassing is wellicht niet beschikbaar voor installatie en gebruik.',

    '__php_handler_type_desc' => 'PHP uitvoeren als',
    'sfdk_domain_sign__failed' => 'Er is een niet-geïdentificeerde fout opgetreden bij de poging het ondertekenen van mail met DKIM in te schakelen voor een domein. Zie het foutmelding-logbestand van de server voor meer informatie.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Melding bij succesvolle update van Plesk-licentiesleutel',
    'pkey_notify__subj_update_deferral_notification' => 'Melding als het bijwerken van de sleutel van Plesk is uitgesteld',
    'pkey_notify__subj_update_error_notification' => 'Melding als het bijwerken van de sleutel van Plesk is mislukt',
    'pkey_notify__update_successful' => 'Update van %1 is geslaagd.',
    'pkey_notify__update_failed_no_more_try' => 'Kan %1 niet bijwerken. De sleutel die u probeert te verzenden is ongeldig. Probeer deze sleutel niet opnieuw bij te werken.',
    'pkey_notify__update_failed_try_later' => 'Kan het %1 niet bijwerken: Er is een fout opgetreden bij het verwerken van uw sleutel. U kunt proberen de sleutel handmatig op te halen via Plesk (Hulpprogramma\'s & instellingen>Licentiebeheer), of u kunt Plesk laten proberen om deze in de komende 24 uur bij te werken. Als u deze melding niet meer wilt ontvangen, verwijder deze sleutel dan uit Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Kan spamfilter voor de server als geheel niet uitschakelen.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Kan spamfilter voor de server als geheel niet inschakelen.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Deze reseller',
    'report_auto__select_reseller_report_all' => 'Alle resellers',
    'report_auto__select_reseller_report_client' => 'Alle resellers van deze cliënt',
    'report_auto__select_reseller_report_current' => 'Deze reseller',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Alle cliënten van deze reseller',
    'report_auto__select_client_report_client' => 'Deze cliënt',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Reseller, cliënten en domeinen',

    'rpt_reseller_section_full_domains' => 'Domeinen',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliassen',
    'rpt_reseller_dom_postboxes' => 'MBoxen',
    'rpt_reseller_dom_redirects' => 'Doorstuuradressen',
    'rpt_reseller_dom_mail_groups' => 'MGroepen',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MLijsten',
    'rpt_reseller_dom_web_users' => 'WGebr',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Cliënten',
    '__cl_name' => 'Naam van cliënt',
    '__cl_creation_date' => 'Datum van aanmaken',
    '__clients_traffic' => 'Dataverkeer van cliënt',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder is niet geïnstalleerd.',
    'sitebuilder_disabled' => 'Presence Builder is uitgeschakeld.',
    'b_sitebuilder_disabled' => 'Presence Builder is uitgeschakeld.',
    'webmail_not_installed' => 'Er is geen webmail-software geïnstalleerd.',
    'webmail_disabled' => 'Webmail is uitgeschakeld.',
    'spamassassin_not_installed' => 'SpamAssassin is niet geïnstalleerd.',
    // pfu:
    'anonymous_ftp_shared' => 'Kan anonieme FTP niet instellen: er wordt een gedeeld IP-adres gebruikt.',
    'anonymous_ftp_used' => 'Kan anonieme FTP niet instellen: het IP-adres wordt al door een ander domein voor anonieme FTP gebruikt.',
    'sshterm__not_installed' => 'SSH-terminal is niet geïnstalleerd.',
    'sshterm__empty_shell' => 'Om de terminalcliënt te gebruiken dient u shelltoegang voor dit domein toe te staan.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET is niet geïnstalleerd.',
    'tsclient__not_installed' => 'Extern bureaublad is niet geïnstalleerd.',
    'site_builder_no_package' => 'Presence Builder is niet beschikbaar. Controleer of Presence Builder is geïnstalleerd en geselecteerd als een actieve component.',
    'site_builder_not_configured' => 'Presence Builder is niet geconfigureerd.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Hulpprogramma\'s',
    'ui__reseller/client#clientslist__title' => 'Cliënten',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "ODBC-gegevensbronnen voor website instellen",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "Selecteer de website waarvoor u ODBC-gegevensbronnen wilt instellen.",

    'ui__client/domain/hosting/tsclient_unknown__wizard-title' => "Toegang tot virtuele host van domein via Extern bureaublad",
    'ui__client/domain/hosting/tsclient_unknown__wizard__2_unknown' => "Selecteer het domein tot wiens virtuele host u toegang wilt krijgen via Extern bureaublad.",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "Virtuele mappen binnen domein beheren",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "Selecteer het domein waarvan u de virtuele mappen wilt beheren.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Virtuele mappen binnen een website beheren',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Selecteer de website waarvan u de mappen wilt beheren.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "Hotlink-bescherming voor domein instellen",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "Selecteer het domein waarvan u de bestanden wilt beschermen tegen hotlinking.",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "PHP-configuratie voor domein instellen",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "Selecteer het domein waarvan u de PHP-configuratie wilt instellen.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Anonieme FTP voor domein instellen.',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Selecteer het domein waarvoor u anonieme FTP wilt instellen.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Met wachtwoord afgeschermde mappen binnen domein beheren',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Selecteer het domein waarvan u de met een wachtwoord afgeschermde mappen wilt beheren.',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => 'Webstatistieken voor domein bekijken',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => 'Selecteer het domein waarvan u webstatistieken wilt bekijken.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Logbeheer voor domein instellen en logbestanden bekijken',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Selecteer het domein waarvoor u logbeheer wilt instellen en waarvan u de logbestanden wilt bekijken.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'SSL/TLS-certificaten voor domein beheren',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Selecteer het domein waarvan u de SSL/TLS-certificaten wilt beheren.',

    'ui__client/to-reseller_multi__wizard-title' => 'Cliëntaccounts omzetten naar reselleraccounts',
    'ui__client/to-reseller_multi__wizard__1_multi' => 'Selecteer de cliëntaccounts die u wilt omzetten naar reselleraccounts.',

    'ui__reseller/to-client_multi__wizard-title' => 'Reselleraccounts omzetten naar cliëntaccounts',
    'ui__reseller/to-client_multi__wizard__1_multi' => 'Selecteer de reselleraccounts die u wilt omzetten naar cliëntaccounts.',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => 'Geef hostinginstellingen voor het domein op.',







    'ui__client/domain/disable_multi__wizard-title' => 'Domeinen opschorten',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Selecteer de domeinen die u wilt opschorten.',

    'ui__client/domain/enable_multi__wizard-title' => 'Domeinen activeren',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Selecteer de domeinen die u wilt activeren.',

    'ui__client/domain_unknown__wizard-title' => 'Domeinen bekijken',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Selecteer een cliënt van wie u de domeinen wilt bekijken.',

    'ui__client/domain/to-client_multi__wizard-title' => 'Domeinbeheerderaccounts omzetten naar cliëntaccounts',
    'ui__client/domain/to-client_multi__wizard__2_multi' => 'Selecteer de domeinen waarvan u de beheerderaccounts wilt omzetten naar cliëntaccounts',

    'ui__client/domain/register_unknown__wizard-title' => 'Domeinen registreren',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Selecteer het domein dat u wilt registreren.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Hulpprogramma\'s van MyPlesk.com gebruiken',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Selecteer het domein dat u wilt beheren met de hulpprogramma\'s van MyPlesk.com.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'Toegang tot de server via SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'Selecteer het domein met de virtuele host waarmee u via SSH verbinding wilt leggen.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Gebruikers IP-adres',
    'ui__server/ip-address/client_unknown__title' => 'Gebruikers IP-adres',
    'ui__server/ip-address/client_unknown__description' => 'Gebruikers van IP-adres %1',

    'disabled_by_admin' => 'Uitgeschakeld door serverbeheerder',






    'ui__client/domain/chowner_multi__short-title' => 'Houder wijzigen',
    'ui__client/domain/chowner_multi__title' => 'Abonnementhouder wijzigen',
    'ui__client/domain/chowner_multi__description' => 'Abonnementhouder wijzigen.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Selecteer de domeinen waarvan u houderschap wilt overdragen en klik Volgende >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Houder wijzigen',
    'ui__client/domain/chowner_unknown__title' => 'Abonnementhouder wijzigen',
    'ui__client/domain/chowner_unknown__description' => 'Abonnementhouder wijzigen.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Abonnementhouder wijzigen',


    'ui__client/chowner__short-title' => 'Houder van cliënt wijzigen',
    'ui__client/chowner__title' => 'Houder van cliëntaccount wijzigen',
    'ui__client/chowner__description' => 'Nieuwe houder toewijzen aan dit cliëntaccount',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Er zijn geen Eigen knoppen.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Er zijn geen aangepaste knoppen in het scherm van reseller %1.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'De knop %1 verwijderen.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Verwijderen',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'De knop %1 verwijderen',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Aangepaste knoppen uit het scherm van de reseller verwijderen',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Verwijderen',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Eigen knoppen verwijderen',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Knoppen verwijderen',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Selecteer een reseller van wie u de Eigen knoppen wilt verwijderen en klik Volgende >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Selecteer de knoppen die u wilt verwijderen en klik Volgende >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bevestig de verwijdering van de knoppen door het selectievakje in dit scherm te selecteren en klik vervolgens op Voltooien.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Een aangepaste knop uit het scherm van de reseller verwijderen.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Verwijderen',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Een Eigen knop verwijderen',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Eigen knop verwijderen',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Selecteer een reseller van wie u een Eigen knop wilt verwijderen en klik Volgende >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Selecteer een Eigen knop die u wilt verwijderen en klik Volgende >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bevestig de verwijdering van de Eigen knop door het selectievakje in dit scherm te selecteren en klik vervolgens op Voltooien.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Eigenschappen van Eigen knop %1 bewerken op resellerniveau.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Instellingen',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Eigen knop %1 van reseller aanpassen',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Eigen knop toevoegen',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Selecteer een reseller bij wie u een aangepaste knop in het scherm wilt plaatsen en klik op Volgende >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klik Voltooien om de knop aan te maken.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'De eigenschappen van een knop in interface van reseller wijzigen.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Eigenschappen',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'De eigenschappen van een knop in interface van reseller wijzigen',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Eigenschappen van Eigen knop wijzigen',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Selecteer een reseller van wie u een Eigen knop wilt aanpassen en klik Volgende >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Selecteer een Eigen knop die u wilt aanpassen en klik Volgende >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Wanneer u klaar bent met het bewerken de eigenschappen van de knop, klik Voltooien om wijzigingen op te slaan en deze wizard af te sluiten.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'De knop %1 niet langer aan uw klanten beschikbaar stellen.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Niet langer aan uw klanten beschikbaar stellen',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'De knop %1 niet langer aan uw klanten beschikbaar stellen',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'De knop %1 zichtbaar maken voor klanten van reseller.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Aan uw klanten beschikbaar stellen',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'De knop %1 zichtbaar maken voor klanten van reseller',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Stel een Eigen knop beschikbaar/niet beschikbaar aan uw klanten.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Beschikbaar/niet beschikbaar voor uw klanten',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Stel een Eigen knop beschikbaar of niet beschikbaar aan uw klanten',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Stel een Eigen knop beschikbaar/niet beschikbaar aan uw klanten.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Selecteer een reseller van wie u een Eigen knop beschikbaar wilt stellen aan de klanten van de reseller en klik Volgende >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Selecteer een Eigen knop die u beschikbaar of niet beschikbaar wilt stellen aan uw klanten en klik Volgende >>.',




    'ui__server/ip-addresses__short-title' => 'IP-adressen',
    'ui__server/ip-addresses__title' => 'Beheer van IP-adressen',
    'ui__server/ip-addresses__description' => 'Toevoegen, verwijderen en toewijzen van IP-adressen.',

    'ip_ctrl__allow_ftps' => 'FTP via SSL/TLS toestaan',
    '__ftps' => 'FTP via SSL/TLS',
    '__not_allowed' => 'Niet toegestaan',



    'ui__client/ipaddress/domain_unknown__short-title' => 'Domein die gebruik maken van %2',
    'ui__client/ipaddress/domain_unknown__title' => 'Domeinen die gebruik maken van %1 IP-adres %2',
    'ui__client/ipaddress/domain_unknown__description' => 'Bekijk de lijst met domeinen die gebruik maken van %1 IP address %2',

    'ui__client/ipaddress__none-available' => 'Geen IP-adressen beschikbaar',
    'ui__client/ipaddress__none-available__1' => 'Geen IP-adressen beschikbaar',



    'ui__client/domain/report_unknown__wizard-title' => 'Domeinverslag bekijken',
    'ui__client/domain/report_unknown__wizard__2_unknown' => 'Selecteer het domein waarvan u het verslag wilt bekijken.',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Selecteer de nieuwe houder van het domein.',

    'ui__client/chowner__wizard__2_select' => 'Selecteer nieuwe houder voor het cliëntaccount.',

    '__ip_addr_state_unknown' => "IP-adres is momenteel niet operationeel omdat het systeem nog bezig is met het verwerken van uw aanvraag. Nog even geduld, alstublieft.",


    'resellers_list__accounts' => 'Gebruikers',

    'ip_addr__repair_is_not_allowed' => 'IP-adres kan niet worden hersteld in Virtuozzo-omgeving.',

    'ui__reseller/client__none-available__1' => 'Reseller %1 heeft geen cliënten.',

    'ippoolManager__ip_used_by_nohost_domain' => "IP-adres %%ip%% kan niet worden verwijderd omdat deze wordt gebruikt door één of meer domeinen zonder hosting.",
    'ippoolManager__ip_used_for_mail_service' => "IP-adres %%ip%% kan niet worden verwijderd omdat deze wordt gebruikt door één of meer domeinen voor het IP-adres van hun maildiensten.",
    'ippoolManager__ip_used_for_send_emails' => "IP-adres %%ip%% kan niet worden verwijderd omdat deze wordt gebruikt om e-mails te versturen vanaf een specifiek IP-adres (zie Instellingen mailserver).",
    'ippoolManager__ip_used_in_dns_zone' => 'IP-adres %%ip%% kan niet worden verwijderd omdat deze wordt gebruikt door de DNS-zone van één of meer domeinen.',
    'ip_ctrl__cannot_manage_on_vz' => 'Deze installatie van Plesk wordt uitgevoerd binnen Virtuozzo containers. Nieuwe IP-adressen kunnen alleen worden toegevoegd door de node-beheerder van Virtuozzo containers.',

    'client_template__limits_auto_adjusted' => 'Beperkingen uit het cliëntsjabloon zijn automatisch aangepast.',

    '__entries' => 'Ingangen',

    '__path_is_not_set' => 'Geen zoekpad opgegeven. Geef een geldig zoekpad op.',

    // license keys
    'key_new_plesk_key_is_uploaded' => 'De nieuwe sleutel voor Plesk is geüpload.',
    'key_new_additional_key_is_uploaded' => 'De nieuwe extra sleutel is geüpload.',

    'defaultcomponents__imap_required' => '(Huidige mailserver ondersteunt geen IMAP)',
    'defaultcomponents__php_required' => '(PHP is niet geïnstalleerd)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'Bescherming tegen hotlinking is uitgeschakeld voor dit domein.',
    'i_hotlinkprotection_off' => 'Bescherming tegen hotlinking is uitgeschakeld voor dit domein.',

    '__commercial_web_stats_not_installed' => 'Plesk ondersteunt alleen commerciële software voor het berekenen van webstatistieken voor subdomeinen. Dergelijke software is momenteel niet in het systeem geïnstalleerd.',

    'mail__spamassassin_personal_settings_disallowed' => 'De mogelijkheid om persoonlijke spamfilter-instellingen toe te passen is door de serverbeheerder uitgeschakeld. Onderstaande spamfilter-instellingen zullen niet worden toegepast',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => 'Kan %1-object niet aanmaken: %2',
    'cu_dom_pref__invalid_expiration_date' => 'Ongeldige verloopdatum: %1',
    'cu_cl_pref__illegal_date_val' => 'U hebt een ongeldige waarde als datum opgegeven ("%1")',
    'cu_cl_pref__illegal_date_greater_less' => 'Geef jaartal op tussen "%1" en "%2""',
    'cu_initconf__unable_set_ip_alias_type' => 'Kan type IP-alias niet instellen: %1',
    'cu_mlist__unable_change_status' => "Kan de verzendlijststatus niet wijzigen: %1",
    'cu_initconf__unable_change_passwd' => "Kan beheerderwachtwoord niet wijzigen: %1",
    'cu_serverpref__option_description_include_remote_databases' => 'Externe MySQL-databases meenemen in de berekening van het schijfruimtegebruik.',
    'cu_siteapp_item__add_to_pool_success' => 'Webtoepassing is aan de webtoepassingsvoorziening toegevoegd.',
    'cu_siteapp_item__remove_from_pool_success' => 'Webtoepassing is uit de webtoepassingsvoorziening verwijderd.',
    'cu_traffic_command_description_add_user' => 'Legt een specifieke hoeveelheid dataverkeer vast als reeds gebruikt door cliënt/reseller',
    'cu_traffic_command_description_sub_user' => 'Trekt een specifieke hoeveelheid dataverkeer af van de hoeveelheid die is geregistreerd voor de cliënt/reseller',
    'cu_traffic_command_description_add_batch_user' => 'Legt een specifieke hoeveelheid dataverkeer vast als reeds gebruikt door cliënt/reseller (batch-modus)',
    'cu_traffic_command_description_del_user' => 'Zet de hoeveelheid geregistreerd dataverkeer van deze cliënt/reseller terug op nul',
    'cu_resellerpref__option_lock_screen' => 'Gebruikers kunnen niet met Plesk werken totdat het scherm volledig is geladen',
];